/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.wadmin.transforms.sql.editor.JoinEditorIcons;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class TablesPaletteTreeModel
extends AbstractTreeModel {
    private ITable[] m_aTables;
    private boolean m_bSortColumns;

    public TablesPaletteTreeModel(ITable[] sourceTables, ITable[] targetTables) {
        super(Workspace.getWorkspace().getUserContext(), null);
        int iTable;
        this.m_aTables = new ITable[sourceTables.length + targetTables.length];
        for (iTable = 0; iTable < sourceTables.length; ++iTable) {
            this.m_aTables[iTable] = sourceTables[iTable];
        }
        for (iTable = 0; iTable < targetTables.length; ++iTable) {
            this.m_aTables[sourceTables.length + iTable] = targetTables[iTable];
        }
        cRootNode treeRoot = new cRootNode();
        treeRoot.setTreeModel((ITreeModel)this);
        treeRoot.setSorted(false);
        this.setRoot((TreeNode)((Object)treeRoot));
    }

    public TablesPaletteTreeModel(ITable[] aTables) {
        super(Workspace.getWorkspace().getUserContext(), null);
        this.m_aTables = aTables;
        cRootNode treeRoot = new cRootNode();
        treeRoot.setTreeModel((ITreeModel)this);
        this.setRoot((TreeNode)((Object)treeRoot));
    }

    public void moveDataToModel() {
        this.removeAllChildren((ITreeNode)this.getRoot());
        this.addTables((IDataObject[])this.m_aTables);
    }

    public void addSourceAndTargetTables(ITable[] sources, ITable[] targets) {
        this.addTables((IDataObject[])sources);
        this.addTables((IDataObject[])targets);
    }

    public void addTables(IDataObject[] aTable) {
        for (int iTable = 0; iTable < aTable.length; ++iTable) {
            this.addTable(aTable[iTable]);
        }
    }

    public void addTable(IDataObject oTable) {
        cRootNode rootNode = (cRootNode)((Object)this.getRoot());
        if (oTable instanceof ITable) {
            cTableNode tableNode = new cTableNode((ITable)oTable);
            this.addChild((ITreeNode)tableNode, (ITreeNode)rootNode);
            tableNode.addChildren();
        }
    }

    public void setSortColumns(boolean bSort) {
        if (this.m_bSortColumns == bSort) {
            return;
        }
        this.m_bSortColumns = bSort;
        this.reorderTableColumns((TreeNode)this.getRoot());
    }

    private void reorderTableColumns(TreeNode node) {
        for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
            ITreeNode nodeChild = (ITreeNode)node.getChildAt(iChild);
            if (nodeChild instanceof cTableNode) {
                nodeChild.setSorted(this.m_bSortColumns);
                this.removeAllChildren(nodeChild);
                ((cTableNode)nodeChild).addChildren();
                continue;
            }
            this.reorderTableColumns((TreeNode)nodeChild);
        }
    }

    public void addChild(IDataTreeNode newNode) {
    }

    public void addChildren(ITreeNode parentNode) {
    }

    public List findParentNodes(SimpleBrowseObject object) {
        return null;
    }

    public boolean isValidParent(ITreeNode parentNode, ITreeNode childNode) {
        return false;
    }

    protected void addCreatedObjects(Map objectsMap) {
    }

    protected void updateModifiedObjects(Map objectsMap) {
    }

    protected String getDisplayTableName(ITable oTable) {
        return oTable.getName();
    }

    protected class cColumnNode
    extends AbstractTreeNode
    implements IDataTreeNode {
        private IColumn m_column;
        private ITable m_table;

        public cColumnNode(IColumn oColumn, ITable oTable) {
            super((Object)oColumn.getName());
            this.setAllowsChildren(false);
            this.m_column = oColumn;
            this.m_table = oTable;
        }

        public Icon getIcon() {
            Icon icon = ColumnUIUtilities.getTypeIcon(this.m_column.getType());
            return icon != null ? icon : WorkspaceTree.getDefaultLeafIcon();
        }

        public boolean isFolder() {
            return false;
        }

        public String getType() {
            return "" + this.m_column.getType();
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isValidDragSource() {
            return true;
        }

        public boolean isValidDropTarget() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public Object getData() {
            return this.m_column;
        }

        public String getID() {
            return this.m_column.getID();
        }

        public boolean isDeleteAllowed() {
            return false;
        }

        public boolean isRenameAllowed() {
            return false;
        }

        public boolean isValidName(String sNewName) {
            return false;
        }

        public void rename(String sNewName) {
        }

        public void update() {
        }

        public ITable getTable() {
            return this.m_table;
        }
    }

    protected class cTableNode
    extends AbstractTreeNode
    implements IDataTreeNode {
        private ITable m_table;

        public cTableNode(ITable oTable) {
            String alias;
            IQuery query;
            super((Object)TablesPaletteTreeModel.this.getDisplayTableName(oTable), true);
            this.m_table = oTable;
            this.setSorted(TablesPaletteTreeModel.this.m_bSortColumns);
            if (oTable instanceof ISubqueryTargetTable && (query = ((ISubqueryTargetTable)oTable).getParentQuery()) instanceof ISubquery && (alias = ((ISubquery)query).getAliasName()) != null && alias.length() > 0) {
                this.setUserObject(alias);
            }
        }

        public void addChildren() {
            IColumn[] aColumn = this.m_table.getColumns();
            for (int iColumn = 0; iColumn < this.m_table.getColumnCount(); ++iColumn) {
                TablesPaletteTreeModel.this.addChild((ITreeNode)new cColumnNode(aColumn[iColumn], this.m_table), (ITreeNode)this);
            }
        }

        public Icon getIcon() {
            return JoinEditorIcons.getTableIcon(this.m_table);
        }

        public boolean isFolder() {
            return false;
        }

        public String getType() {
            return this.m_table.getMetadataType();
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isValidDragSource() {
            return false;
        }

        public boolean isValidDropTarget() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public Object getData() {
            return this.m_table;
        }

        public String getID() {
            return this.m_table.getID();
        }

        public boolean isDeleteAllowed() {
            return false;
        }

        public boolean isRenameAllowed() {
            return false;
        }

        public boolean isValidName(String sNewName) {
            return false;
        }

        public void rename(String sNewName) {
        }

        public void update() {
        }
    }

    private class cRootNode
    extends AbstractTreeNode {
        public cRootNode() {
            super((Object)"TablePaletteRoot");
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isFolder() {
            return true;
        }
    }
}

