/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.other.IResponsibleParty;
import com.sas.etl.models.other.IResponsiblePartyContainer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;

public class ResponsiblePartyTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ResponsiblePartyTableModel.class);
    private static final String OWNER_VIEW_ROLE = bundle.getString("ResponsiblePartyTableModel.Role.Owner.txt");
    private static final String ADMINISTRATOR_VIEW_ROLE = bundle.getString("ResponsiblePartyTableModel.Role.Administrator.txt");
    private static final int NAME_COLUMN = 0;
    private static final int ROLE_COLUMN = 1;
    private static final int RESPONSIBLEPARTY_COLUMN = 2;
    private static final int VISIBLE_COLUMNS = 2;
    private static final int HIDDEN_COLUMNS = 1;
    private IResponsiblePartyContainer m_container;
    private String[] m_saPersons;
    private IModelListener m_lsnrModel;

    private static String getViewRole(String sModelRole) {
        if ("OWNER".equalsIgnoreCase(sModelRole)) {
            return OWNER_VIEW_ROLE;
        }
        if ("ADMINISTRATOR".equalsIgnoreCase(sModelRole)) {
            return ADMINISTRATOR_VIEW_ROLE;
        }
        return sModelRole;
    }

    private static String getModelRole(String sViewRole) {
        if (OWNER_VIEW_ROLE.equals(sViewRole)) {
            return "OWNER";
        }
        if (ADMINISTRATOR_VIEW_ROLE.equals(sViewRole)) {
            return "ADMINISTRATOR";
        }
        return sViewRole;
    }

    public ResponsiblePartyTableModel(IResponsiblePartyContainer container) {
        this.m_container = container;
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private void createColumnDefinitions() {
        String[] saRoles = new String[]{OWNER_VIEW_ROLE, ADMINISTRATOR_VIEW_ROLE};
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new NameColumn(0, bundle.getString("ResponsiblePartyTableModel.Column.Name.txt"), 150);
        this.m_aColumns[1] = new WsEnumeratedTableColumn(1, bundle.getString("ResponsiblePartyTableModel.Column.Role.txt"), 150, saRoles, saRoles[0]);
        this.m_aColumns[2] = new WsMetadataTableColumn();
        ((WsEnumeratedTableColumn)this.m_aColumns[0]).setSorted(true);
    }

    public int getColumnCount() {
        return 2;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populate store not implemented");
    }

    public void moveDataToModel() {
        this.clear();
        IResponsibleParty[] aRPs = this.m_container.getResponsibleParties();
        for (int iRP = 0; iRP < aRPs.length; ++iRP) {
            String responsibility = aRPs[iRP].getResponsibility();
            if ("Created By".equalsIgnoreCase(responsibility) || "Modified By".equalsIgnoreCase(responsibility)) continue;
            this.m_lData.add(this.createRowValues(aRPs[iRP]));
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        throw new UnsupportedOperationException("move data to store not implemented");
    }

    public void setValueAt(Object value, int iRow, int iColumn) {
        IResponsibleParty rp = this.getResponsibleParty(iRow);
        if (iColumn == 0 && !rp.getName().equals(value)) {
            if (rp.isNew()) {
                rp.setName((String)value);
            } else {
                this.replaceResponsibleParty(rp, (String)value, rp.getResponsibility());
            }
        } else if (iColumn == 1 && !rp.getResponsibility().equals(value)) {
            if (rp.isNew()) {
                rp.setResponsibility(ResponsiblePartyTableModel.getModelRole((String)value));
            } else {
                this.replaceResponsibleParty(rp, rp.getName(), (String)value);
            }
        }
    }

    private List createRowValues(IResponsibleParty rp) {
        ArrayList<String> lValues = new ArrayList<String>();
        lValues.add(rp.getName());
        lValues.add(ResponsiblePartyTableModel.getViewRole(rp.getResponsibility()));
        lValues.add((String)rp);
        return lValues;
    }

    private void addResponsibleParty(IResponsibleParty rpNew) {
        int iRow = 0;
        IResponsibleParty[] aRPs = this.m_container.getResponsibleParties();
        for (int iRP = 0; iRP < aRPs.length && aRPs[iRP] != rpNew; ++iRP) {
            String responsibility = aRPs[iRP].getResponsibility();
            if ("Created By".equals(responsibility) || "Modified By".equals(responsibility)) continue;
            ++iRow;
        }
        this.insertRow(iRow - 1, this.createRowValues(rpNew));
    }

    private void removeResponsibleParty(IResponsibleParty rp) {
        int iRow = this.getRowIndex(rp);
        if (iRow != -1) {
            this.deleteRow(iRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceResponsibleParty(IResponsibleParty rpOld, String sName, String sResponsibility) {
        this.m_container.getModel().startCompoundUndoable();
        try {
            List lRPs = this.m_container.getResponsiblePartiesList();
            int iRP = lRPs.indexOf(rpOld);
            lRPs.remove(iRP);
            IResponsibleParty newRP = this.m_container.getModel().getObjectFactory().createNewResponsibleParty();
            newRP.setName(sName);
            newRP.setResponsibility(sResponsibility);
            lRPs.add(iRP, newRP);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    public IResponsibleParty getResponsibleParty(int iRow) {
        return (IResponsibleParty)this.getValueAt(iRow, 2);
    }

    public int getRowIndex(IResponsibleParty rp) {
        for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
            if (this.getResponsibleParty(iRow) != rp) continue;
            return iRow;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPersons() {
        if (this.m_saPersons == null) {
            try {
                MdFactory factory = Workspace.getMdFactory();
                MdObjectStore store = factory.createObjectStore(null, "get persons");
                try {
                    String sRepositoryId = factory.getOMIUtil().getFoundationReposID();
                    List lPersons = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, sRepositoryId, "Person", 0, null);
                    this.m_saPersons = new String[lPersons.size()];
                    for (int iPerson = 0; iPerson < lPersons.size(); ++iPerson) {
                        this.m_saPersons[iPerson] = ((Root)lPersons.get(iPerson)).getName();
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                    this.m_saPersons = new String[0];
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return this.m_saPersons;
    }

    private class NameColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        private boolean m_bPopulated;

        public NameColumn(int iModelIndex, String sName, int cxWidth) {
            super(iModelIndex, sName, cxWidth);
        }

        public Object createDefaultValue() {
            this.populate(null, 0, 0);
            return this.m_sDefault;
        }

        protected void populate(JTable table, int iRow, int iColumn) {
            if (!this.m_bPopulated) {
                String[] saPersons = ResponsiblePartyTableModel.this.getPersons();
                this.setPossibleValues(saPersons);
                this.m_bPopulated = true;
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            IObject obj = ev.getModelObject();
            String sType = ev.getType();
            if ("ModelController:UnknownChanges".equals(sType)) {
                ResponsiblePartyTableModel.this.moveDataToModel();
            } else if (obj == ResponsiblePartyTableModel.this.m_container) {
                if ("Objecty:ResponsiblePartyAdded".equals(sType)) {
                    ResponsiblePartyTableModel.this.addResponsibleParty((IResponsibleParty)ev.getData());
                } else if ("Objecty:ResponsiblePartyRemoved".equals(sType)) {
                    ResponsiblePartyTableModel.this.removeResponsibleParty((IResponsibleParty)ev.getData());
                }
            } else if (obj instanceof IResponsibleParty) {
                IResponsibleParty rp = (IResponsibleParty)ev.getModelObject();
                int iRowIndex = ResponsiblePartyTableModel.this.getRowIndex(rp);
                if (iRowIndex == -1) {
                    return;
                }
                if ("Object:NameChanged".equals(sType)) {
                    ResponsiblePartyTableModel.super.setValueAt(rp.getName(), iRowIndex, 0);
                } else if ("ResponsibleParty:ResponsibilityChanged".equals(sType)) {
                    ResponsiblePartyTableModel.super.setValueAt(ResponsiblePartyTableModel.getViewRole(rp.getResponsibility()), iRowIndex, 1);
                }
            }
        }
    }
}

