/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.wadmin.visuals.common.NotePreviewPane;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class PrivateNotePane
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(NotePreviewPane.class);
    protected JLabel m_lblText;
    protected WATextArea m_pnlText;
    protected JScrollPane m_scrText;
    private INotesAndDocumentsContainer m_container;
    private FocusListener m_lsrNote;

    public PrivateNotePane() {
        this(null);
    }

    public PrivateNotePane(INotesAndDocumentsContainer container) {
        this.m_container = container;
        this.initialize();
        this.layoutWidgets();
    }

    public String getContents() {
        return this.m_pnlText.getText();
    }

    public void setContents(String sText) {
        this.m_pnlText.setText(sText);
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
        this.m_pnlText.setEditable(bEditable);
    }

    public boolean isEditable() {
        return super.isEditable() && this.m_pnlText.isEditable();
    }

    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.m_pnlText.setEnabled(bEnabled);
    }

    protected void initialize() {
        this.m_pnlText = new WATextArea(4, 60);
        this.m_pnlText.setWrapStyleWord(true);
        this.m_pnlText.setLineWrap(true);
        this.m_lblText = WsUIUtilities.createLabelForComponent((JComponent)this.m_pnlText, (String)bundle.getString("PrivateNotePane.Label.txt"));
        this.m_scrText = new JScrollPane((Component)this.m_pnlText);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrText);
        this.m_lsrNote = new NoteFocusListener();
        this.m_pnlText.addFocusListener(this.m_lsrNote);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrText, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlText.removeFocusListener(this.m_lsrNote);
    }

    public void moveDataToStore() {
        this.updateNote();
    }

    private void updateNote() {
        if (this.m_container == null) {
            return;
        }
        String sNote = this.m_pnlText.getText();
        if (sNote == null || sNote.trim().length() == 0) {
            this.m_container.setPrivateNote(null);
        } else {
            this.m_container.setPrivateNote(sNote);
        }
    }

    private class NoteFocusListener
    implements FocusListener {
        private NoteFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            PrivateNotePane.this.updateNote();
        }
    }
}

