/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.wadmin.transforms.scd.ColumnSelectorPanel;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsDropMenuTableCellEditor;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PartnerKeyPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(PartnerKeyPanel.class);
    public static final int PARTNER_KEY_COLUMN_NAME = 0;
    public static final int FOREIGN_KEY_COLUMN_NAME = 1;
    public static final int PARTNER_KEY_COLUMN_OBJECT = 2;
    public static final int FOREIGN_KEY_COLUMN_OBJECT = 3;
    private WAComboBox m_keysComboBox;
    private WsTable m_columnsTable;
    private PartnerKeyColumnsTableModel m_columnsTableModel;
    private ActionListener m_partnerKeyListener;
    private IPhysicalTable m_partnerKeyTable;
    private IPhysicalTable m_foreignKeyTable;
    private IForeignKey m_foreignKey;
    private IKey m_partnerKey;
    private WsAbstractAction m_createNewColumnAction;
    private WsAbstractAction m_selectColumnAction;
    private IModelListener m_modelListener;
    private ListSelectionListener m_tableSelectionListener;
    private boolean m_listenForEvents;

    public PartnerKeyPanel(IPhysicalTable partnerKeyTable, IPhysicalTable foreignKeyTable, IForeignKey key) {
        this.m_partnerKeyTable = partnerKeyTable;
        this.m_foreignKeyTable = foreignKeyTable;
        this.m_foreignKey = key;
        this.m_modelListener = new ModelListener();
        this.m_foreignKey.getModel().addModelListener(this.m_modelListener);
        this.m_listenForEvents = true;
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        WATextArea tableDescriptionText = new WATextArea();
        tableDescriptionText.setText(bundle.formatString("PartnerKeyPanel.Table.fmt.txt", (Object)this.m_partnerKeyTable.getName()));
        tableDescriptionText.setBehavior(1);
        tableDescriptionText.setAutosize(true);
        WATextArea keyDescriptionText = new WATextArea();
        keyDescriptionText.setBehavior(1);
        keyDescriptionText.setText(bundle.getString("PartnerKeyPanel.Key.Description.txt"));
        keyDescriptionText.setAutosize(true);
        this.m_keysComboBox = new WAComboBox();
        JLabel keyLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_keysComboBox, (String)bundle.getString("PartnerKeyPanel.Key.txt"));
        this.m_partnerKeyListener = new PartnerKeyListener();
        this.m_keysComboBox.addActionListener(this.m_partnerKeyListener);
        WATextArea columnsDescriptionText = new WATextArea();
        columnsDescriptionText.setBehavior(1);
        columnsDescriptionText.setText(bundle.getString("PartnerKeyPanel.Columns.Description.txt"));
        columnsDescriptionText.setAutosize(true);
        this.m_columnsTableModel = new PartnerKeyColumnsTableModel();
        this.m_columnsTable = new WsTable((WsAbstractTableModel)this.m_columnsTableModel);
        this.m_columnsTable.setAutoResizeMode(4);
        this.m_columnsTable.setColumnHidingEnabled(false);
        this.m_columnsTable.setColumnHoldingEnabled(false);
        this.m_columnsTable.setColumnsReorderable(false);
        this.m_columnsTable.setSortingEnabled(false);
        this.m_columnsTable.setColumnHeaderVisible(true);
        this.m_columnsTable.setRowHeaderVisible(true);
        this.m_columnsTable.setRowHoldingEnabled(false);
        this.m_columnsTable.setViewportPopupMenuEnabled(false);
        this.m_columnsTable.setOriginPopupMenuEnabled(false);
        this.m_columnsTable.setCellSelectionEnabled(true);
        this.m_columnsTable.setColumnSelectionAllowed(false);
        this.m_columnsTable.setRowSelectionAllowed(true);
        this.m_columnsTable.setAutoResizeMode(1);
        this.m_columnsTable.setSelectionMode(2);
        this.m_columnsTable.setEditable(true);
        this.m_columnsTable.setTablePopupMenuEnabled(true);
        this.m_columnsTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.m_tableSelectionListener = new TableSelectionListener();
        this.m_columnsTable.getSelectionModel().addListSelectionListener(this.m_tableSelectionListener);
        JScrollPane columnsPane = new JScrollPane((Component)this.m_columnsTable);
        this.add((Component)tableDescriptionText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)keyDescriptionText, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(keyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.m_keysComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)columnsDescriptionText, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(columnsPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void moveDataToView() {
        IKey[] keys = this.m_partnerKeyTable.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.m_keysComboBox.addItem((Object)new KeyItem(keys[i]));
        }
    }

    public boolean validateData() {
        this.m_columnsTable.stopCellEditing();
        for (int i = 0; i < this.m_columnsTable.getRowCount(); ++i) {
            IColumn foreignColumn = this.getForeignKeyColumn(i);
            if (foreignColumn != null) continue;
            MessageUtil.displayMessage((String)bundle.getString("PartnerKeyPanel.Error.NoColumns.txt"), (int)0);
            this.m_columnsTable.selectCell(i, 1);
            this.m_columnsTable.editCellAt(i, 1);
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.updateComponents();
    }

    public IColumn getPartnerKeyColumn(int rowIndex) {
        return (IColumn)this.m_columnsTableModel.getValueAt(rowIndex, 2);
    }

    public IColumn getForeignKeyColumn(int rowIndex) {
        return (IColumn)this.m_columnsTableModel.getValueAt(rowIndex, 3);
    }

    public void setKeyColumn(IColumn keyColumn, IColumn partnerColumn) {
        for (int rowIndex = 0; rowIndex < this.m_columnsTableModel.getRowCount(); ++rowIndex) {
            IColumn currentPartnerColumn = (IColumn)this.m_columnsTableModel.getValueAt(rowIndex, 2);
            if (currentPartnerColumn != partnerColumn) continue;
            this.setKeyColumn(rowIndex, keyColumn);
            break;
        }
    }

    private void setKeyColumn(int rowIndex, IColumn keyColumn) {
        this.m_columnsTableModel.setValueAt(keyColumn, rowIndex, 3);
        this.m_columnsTableModel.setValueAt(keyColumn != null ? keyColumn.getName() : "", rowIndex, 1);
        this.m_columnsTableModel.fireTableCellUpdated(rowIndex, 1);
    }

    private void updateComponents() {
        this.m_columnsTable.setEnabled(this.isEditable());
    }

    private void updateActions() {
        boolean editable = this.isEditable();
        int[] selectedRows = this.m_columnsTable.getSelectedRowsFromSelectedCells();
        boolean createColumns = true;
        IColumn[] foreignTableColumns = this.m_foreignKeyTable.getColumns();
        for (int i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            IColumn partnerColumn = this.getPartnerKeyColumn(selectedRow);
            for (int j = 0; j < foreignTableColumns.length; ++j) {
                if (!partnerColumn.getName().equalsIgnoreCase(foreignTableColumns[j].getName())) continue;
                createColumns = false;
                break;
            }
            if (!createColumns) break;
        }
        this.m_createNewColumnAction.setEnabled(editable && createColumns);
    }

    public void saveSettingsAndCleanUp() {
        this.m_foreignKey.getModel().removeModelListener(this.m_modelListener);
        this.m_columnsTable.getSelectionModel().removeListSelectionListener(this.m_tableSelectionListener);
        this.m_columnsTableModel.dispose();
    }

    public void listenForEvents(boolean value) {
        this.m_listenForEvents = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createColumn() {
        int rowIndex = this.m_columnsTable.getCurrentRow();
        this.m_columnsTable.stopCellEditing();
        IColumn partnerColumn = this.getPartnerKeyColumn(rowIndex);
        try {
            this.m_foreignKeyTable.getModel().startCompoundUndoable();
            IColumn keyColumn = this.m_foreignKeyTable.getModel().getObjectFactory().createNewColumn(this.m_foreignKeyTable.getID());
            partnerColumn.deepCopy(keyColumn);
            this.m_foreignKeyTable.addColumn(keyColumn);
            this.m_foreignKey.replaceKeyColumn(partnerColumn, keyColumn);
        }
        finally {
            this.m_foreignKeyTable.getModel().endCompoundUndoable();
        }
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectColumn() {
        int rowIndex = this.m_columnsTable.getCurrentRow();
        this.m_columnsTable.stopCellEditing();
        IColumn keyColumn = this.promptForColumn();
        if (keyColumn != null) {
            IColumn partnerColumn = (IColumn)this.m_columnsTableModel.getValueAt(rowIndex, 2);
            try {
                this.m_foreignKey.getModel().startCompoundUndoable();
                this.m_foreignKey.replaceKeyColumn(partnerColumn, keyColumn);
            }
            finally {
                this.m_foreignKey.getModel().endCompoundUndoable();
            }
        }
    }

    private IColumn promptForColumn() {
        String title = bundle.formatString("PartnerKeyColumnsTableModel.ColumnsDialog.Title.txt", (Object)this.m_foreignKeyTable.getName());
        String description = bundle.getString("PartnerKeyColumnsTableModel.ColumnsDialog.Description.txt");
        ColumnSelectorPanel columnSelector = new ColumnSelectorPanel((ITable)this.m_foreignKeyTable, description, false);
        List excludeColumns = this.m_foreignKey.getColumnsList();
        int[] selectedRows = this.m_columnsTable.getSelectedRowsFromSelectedCells();
        for (int i = 0; i < selectedRows.length; ++i) {
            IColumn partnerColumn = this.getPartnerKeyColumn(selectedRows[i]);
            IColumn[] columns = this.m_foreignKeyTable.getColumns();
            for (int j = 0; j < columns.length; ++j) {
                if (columns[j].getType() == partnerColumn.getType()) continue;
                excludeColumns.add(columns[j]);
            }
        }
        if (excludeColumns.containsAll(Arrays.asList(this.m_foreignKeyTable.getColumns()))) {
            MessageUtil.displayMessage((String)bundle.getString("PartnerKeyPanel.Error.NoMatchingColumns.txt"), (int)0);
            return null;
        }
        columnSelector.hideColumns(excludeColumns);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)columnSelector);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return columnSelector.getSelectedColumn();
        }
        return null;
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent event) {
            if (!PartnerKeyPanel.this.m_listenForEvents) {
                return;
            }
            String type = event.getType();
            IObject object = event.getModelObject();
            if (type == "ModelController:UnknownChanges") {
                PartnerKeyPanel.this.moveDataToView();
            } else if (object != PartnerKeyPanel.this.m_partnerKey) {
                if (object == PartnerKeyPanel.this.m_foreignKey) {
                    if (type == "ForeignKey:ColumnAdded") {
                        IColumn keyColumn = (IColumn)event.getData();
                        IColumn partnerColumn = (IColumn)event.getAdditionalData();
                        PartnerKeyPanel.this.setKeyColumn(keyColumn, partnerColumn);
                    } else if (type == "ForeignKey:ColumnRemoved") {
                        IColumn partnerColumn = (IColumn)event.getAdditionalData();
                        PartnerKeyPanel.this.setKeyColumn(null, partnerColumn);
                    } else if (type == "ForeignKey:ColumnReplaced") {
                        IColumn keyColumn = (IColumn)event.getData();
                        IColumn partnerColumn = (IColumn)event.getAdditionalData();
                        PartnerKeyPanel.this.setKeyColumn(keyColumn, partnerColumn);
                    } else if (type == "ForeignKey:PartnerKeyChanged") {
                        IKey partnerKey = (IKey)event.getData();
                        PartnerKeyPanel.this.m_keysComboBox.setSelectedItem((Object)new KeyItem(partnerKey));
                    }
                    PartnerKeyPanel.this.updateActions();
                } else if (object == PartnerKeyPanel.this.m_foreignKeyTable && (type == "Table:ColumnAdded" || type == "Table:ColumnRemoved")) {
                    PartnerKeyPanel.this.updateActions();
                }
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            PartnerKeyPanel.this.updateActions();
        }
    }

    private class SelectColumnAction
    extends WsAbstractAction {
        public SelectColumnAction() {
            super(bundle, "PartnerKeyColumnsTableModel.SelectColumnAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PartnerKeyPanel.this.selectColumn();
        }
    }

    private class CreateNewColumnAction
    extends WsAbstractAction {
        public CreateNewColumnAction() {
            super(bundle, "PartnerKeyColumnsTableModel.CreateNewColumnAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            PartnerKeyPanel.this.createColumn();
        }
    }

    private class PartnerKeyColumnsTableModel
    extends WsAbstractTableModel {
        private static final int VISIBLE_COLUMNS = 2;
        private static final int HIDDEN_COLUMNS = 2;
        private static final int PARTNER_KEY_COLUMN_WIDTH = 100;
        private static final int FOREIGN_KEY_COLUMN_WIDTH = 100;
        private WsDropMenuTableCellEditor m_foreignKeyColumnCellEditor;
        private ForeignKeyColumnCellRenderer m_foreignKeyColumnCellRenderer;

        public PartnerKeyColumnsTableModel() {
            this.createColumnDefinitions();
        }

        public void dispose() {
        }

        protected void createColumnDefinitions() {
            this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
            WsUniqueNameTableColumn column = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("PartnerKeyColumnsTableModel.PartnerKeyColumn.txt"), 100, 32);
            column.setEditable(false);
            column.setCellRenderer((TableCellRenderer)((Object)new PartnerKeyColumnCellRenderer()));
            this.m_aColumns[0] = column;
            column = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 1, bundle.getString("PartnerKeyColumnsTableModel.ForeignKeyColumn.txt"), 100, 32);
            column.setEditable(true);
            PartnerKeyPanel.this.m_createNewColumnAction = new CreateNewColumnAction();
            PartnerKeyPanel.this.m_selectColumnAction = new SelectColumnAction();
            this.m_foreignKeyColumnCellEditor = new WsDropMenuTableCellEditor();
            this.m_foreignKeyColumnCellEditor.setDropMenu(this.createForeignKeyColumnMenu());
            this.m_foreignKeyColumnCellEditor.setClicksToStart(1);
            this.m_foreignKeyColumnCellEditor.setTextEditable(false);
            this.m_foreignKeyColumnCellEditor.getComponent().setBackground(SystemColor.window);
            column.setCellEditor((TableCellEditor)this.m_foreignKeyColumnCellEditor);
            this.m_foreignKeyColumnCellRenderer = new ForeignKeyColumnCellRenderer();
            column.setCellRenderer((TableCellRenderer)((Object)this.m_foreignKeyColumnCellRenderer));
            column.setEditable(true);
            this.m_aColumns[1] = column;
            column = new WsObjectTableColumn();
            this.m_aColumns[2] = column;
            column = new WsObjectTableColumn();
            this.m_aColumns[3] = column;
        }

        protected JPopupMenu createForeignKeyColumnMenu() {
            JPopupMenu menu = new JPopupMenu();
            menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)PartnerKeyPanel.this.m_createNewColumnAction));
            menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)PartnerKeyPanel.this.m_selectColumnAction));
            return menu;
        }

        public void setPartnerKey(IKey partnerKey) {
            PartnerKeyPanel.this.m_partnerKey = partnerKey;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getHiddenColumnCount() {
            return 2;
        }

        public Class getColumnClass(int index) {
            return IColumn.class;
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                super.setValueAt(value, rowIndex, columnIndex);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                super.setValueAt(value, rowIndex, columnIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveDataToModel() {
            this.clear();
            IColumn[] partnerColumns = PartnerKeyPanel.this.m_partnerKey.getColumns();
            for (int i = 0; i < partnerColumns.length; ++i) {
                IColumn partnerColumn = partnerColumns[i];
                ArrayList<String> row = new ArrayList<String>();
                row.add(partnerColumn.getName());
                IColumn keyColumn = PartnerKeyPanel.this.m_foreignKey.getKeyColumn(partnerColumn);
                if (keyColumn != null) {
                    row.add(keyColumn.getName());
                } else {
                    String name = "";
                    IColumn[] foreignTableColumns = PartnerKeyPanel.this.m_foreignKeyTable.getColumns();
                    for (int j = 0; j < foreignTableColumns.length; ++j) {
                        IColumn foreignTableColumn = foreignTableColumns[j];
                        if (!foreignTableColumn.getName().equals(partnerColumn.getName()) || foreignTableColumn.getType() != partnerColumn.getType()) continue;
                        keyColumn = foreignTableColumn;
                        name = keyColumn.getName();
                        try {
                            PartnerKeyPanel.this.listenForEvents(false);
                            PartnerKeyPanel.this.m_foreignKey.replaceKeyColumn(partnerColumn, keyColumn);
                            break;
                        }
                        finally {
                            PartnerKeyPanel.this.listenForEvents(true);
                        }
                    }
                    row.add(name);
                }
                row.add((String)partnerColumns[i]);
                row.add((String)keyColumn);
                this.m_lData.add(row);
            }
            this.fireTableModelPopulated();
            this.m_nRowInstances = this.m_lData.size() + 1;
        }

        public void moveDataToStore() {
            throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
        }

        public void populateStore() {
            throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
        }

        private class PartnerKeyColumnCellRenderer
        extends WsDefaultTableCellRenderer {
            private PartnerKeyColumnCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int rowIndex, int columnIndex) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, isFocused, rowIndex, columnIndex);
                IColumn column = (IColumn)PartnerKeyColumnsTableModel.this.getValueAt(rowIndex, 2);
                if (column != null) {
                    ((JLabel)component).setIcon(ColumnUIUtilities.getTypeIcon(column));
                    ((JLabel)component).setText(column.getName());
                } else {
                    ((JLabel)component).setText("");
                    ((JLabel)component).setIcon(null);
                }
                return component;
            }
        }

        private class ForeignKeyColumnCellRenderer
        extends WsDefaultTableCellRenderer {
            private ForeignKeyColumnCellRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int rowIndex, int columnIndex) {
                super.getTableCellRendererComponent(table, value, isSelected, isFocused, rowIndex, columnIndex);
                IColumn column = (IColumn)PartnerKeyColumnsTableModel.this.getValueAt(rowIndex, 3);
                if (column != null) {
                    this.setIcon(ColumnUIUtilities.getTypeIcon(column));
                    this.setText(column.getName());
                } else {
                    this.setText("");
                    this.setIcon(null);
                }
                JButton btn = WsUIUtilities.createDropMenuButton();
                JPanel pnl = new JPanel(new BorderLayout());
                pnl.add((Component)((Object)this), "Center");
                pnl.add((Component)btn, "East");
                pnl.setBackground(table.getBackground());
                return pnl;
            }
        }
    }

    private class PartnerKeyListener
    implements ActionListener {
        private PartnerKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyItem item = (KeyItem)PartnerKeyPanel.this.m_keysComboBox.getSelectedItem();
            PartnerKeyPanel.this.m_partnerKey = item.getKey();
            try {
                PartnerKeyPanel.this.m_foreignKey.getModel().startCompoundUndoable();
                PartnerKeyPanel.this.m_foreignKey.setPartnerKey(PartnerKeyPanel.this.m_partnerKey);
                PartnerKeyPanel.this.m_columnsTableModel.moveDataToModel();
            }
            finally {
                PartnerKeyPanel.this.m_foreignKey.getModel().endCompoundUndoable();
            }
        }
    }

    private class KeyItem
    implements Comparable {
        private IKey m_key;
        private String m_name;

        public KeyItem(IKey key) {
            this.m_key = key;
            this.m_name = this.m_key.getName();
        }

        public IKey getKey() {
            return this.m_key;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyItem)) {
                return false;
            }
            KeyItem item = (KeyItem)object;
            return this.m_key.equals(item.m_key);
        }

        public int hashcode() {
            return super.hashCode();
        }

        public int compareTo(Object object) {
            if (!(object instanceof KeyItem)) {
                throw new IllegalArgumentException("Illegal argument for KeyItem.compareTo; expecting KeyItem, got: " + object.getClass().getName());
            }
            KeyItem item = (KeyItem)object;
            return this.m_name.compareTo(item.m_name);
        }

        public String toString() {
            return this.m_name;
        }
    }
}

