/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.ITransform;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.wadmin.jobeditor.diagram.adapters.DiagramNodeAdapterFactory;
import com.sas.wadmin.jobeditor.diagram.adapters.IDiagramNodeAdapter;
import com.sas.wadmin.visuals.common.ParameterTreeNode;
import com.sas.wadmin.visuals.common.WsModelDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParametersSelectorTreeModel
extends DefaultTreeModel {
    private Comparator m_cmp;
    private IJob m_mdJob;

    public ParametersSelectorTreeModel(IJob startingJob) {
        super(new DefaultMutableTreeNode());
        this.m_mdJob = startingJob;
        this.setAsksAllowsChildren(true);
        this.setComparator(new cComparator());
        cJobTreeNode node = new cJobTreeNode(this.m_mdJob);
        this.setRoot((TreeNode)((Object)node));
    }

    public void setComparator(Comparator cmp) {
        this.m_cmp = cmp;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    public void expandRootNode() {
        cJobTreeNode node = (cJobTreeNode)((Object)this.getRoot());
        node.addChildren();
    }

    public WsTreeNode createTreeNode(Object mdObject, IPersistableObject parent) {
        WsTreeNode node = mdObject instanceof ITransform ? new cTransformationStepTreeNode((ITransform)mdObject) : (mdObject instanceof ITable ? new cDataTableTreeNode((ITable)mdObject) : (mdObject instanceof PromptDefinitionInterface ? new ParameterTreeNode((PromptDefinitionInterface)mdObject, parent, true) : (mdObject instanceof IJob ? new cJobTreeNode((IJob)mdObject) : new WsTreeNode(mdObject.toString()))));
        return node;
    }

    public DefaultMutableTreeNode getInitialNodeToScrollTo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRoot();
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        return node;
    }

    public void addListenersToTree(JTree tree) {
        tree.addTreeExpansionListener(new cExpansionListener());
        tree.addTreeSelectionListener(new cSelectionListener());
    }

    protected void appendChild(MutableTreeNode nodeChild, MutableTreeNode nodeParent) {
        this.insertNodeInto(nodeChild, nodeParent, nodeParent.getChildCount());
    }

    private class cComparator
    implements Comparator {
        private cComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }

    protected class cSelectionListener
    implements TreeSelectionListener {
        protected cSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] aPaths = e.getPaths();
            if (aPaths != null) {
                for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                    WsTreeNode node;
                    Object obj = aPaths[iPath].getLastPathComponent();
                    if (obj instanceof ParameterTreeNode || obj.equals(ParametersSelectorTreeModel.this.getRoot()) || (node = (WsTreeNode)obj).hasExpanded()) continue;
                    node.addChildren();
                    node.setHasExpanded(true);
                    if (node.getChildCount() != 0) continue;
                    node.setAllowsChildren(false);
                }
            }
        }
    }

    protected class cExpansionListener
    implements TreeExpansionListener {
        protected cExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode node = (WsTreeNode)e.getPath().getLastPathComponent();
            if (!node.hasExpanded()) {
                node.addChildren();
                node.setHasExpanded(true);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }

    protected class cTransformationStepTreeNode
    extends WsModelDataTreeNode {
        private ITransform m_oStep;

        public cTransformationStepTreeNode(ITransform oStep) {
            super((IPersistableObject)oStep);
            this.m_oStep = oStep;
            IDiagramNodeAdapter adapter = DiagramNodeAdapterFactory.getInstance().createAdapter((IObject)oStep);
            if (adapter != null) {
                this.setIcon(adapter.getIcon());
            }
            this.setAllowsChildren(true);
        }

        public void addChildren() {
            List attrList = this.m_oStep.getPromptGroup().getPromptDefinitions(true);
            for (int i = 0; i < attrList.size(); ++i) {
                ParametersSelectorTreeModel.this.appendChild((MutableTreeNode)ParametersSelectorTreeModel.this.createTreeNode(attrList.get(i), (IPersistableObject)this.m_oStep), (MutableTreeNode)((Object)this));
            }
            this.setHasExpanded(true);
        }

        public void removeChildren() {
            while (this.getChildCount() > 0) {
                ParametersSelectorTreeModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
            this.setHasExpanded(false);
        }
    }

    protected class cDataTableTreeNode
    extends WsModelDataTreeNode {
        private ITable m_oTable;

        public cDataTableTreeNode(ITable oTable) {
            super((IPersistableObject)oTable);
            this.m_oTable = oTable;
            this.setAllowsChildren(true);
        }

        public void addChildren() {
            List attrList = this.m_oTable.getPromptGroup().getPromptDefinitions(true);
            for (int i = 0; i < attrList.size(); ++i) {
                ParametersSelectorTreeModel.this.appendChild((MutableTreeNode)ParametersSelectorTreeModel.this.createTreeNode(attrList.get(i), (IPersistableObject)this.m_oTable), (MutableTreeNode)((Object)this));
            }
            this.setHasExpanded(true);
        }

        public void removeChildren() {
            while (this.getChildCount() > 0) {
                ParametersSelectorTreeModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
            this.setHasExpanded(false);
        }
    }

    protected class cJobTreeNode
    extends WsModelDataTreeNode {
        private IJob m_oJob;

        public cJobTreeNode(IJob mdJob) {
            super((IPersistableObject)mdJob);
            this.m_oJob = mdJob;
        }

        public void addChildren() {
            int i;
            ArrayList<Object> parmObjects = new ArrayList<Object>();
            if (!ParametersSelectorTreeModel.this.getRoot().equals((Object)this)) {
                parmObjects.addAll(this.m_oJob.getPromptGroup().getPromptDefinitions(true));
            }
            ITransform[] ordSteps = this.m_oJob.getControlOrderedTransformsAndOthers();
            for (i = 0; i < ordSteps.length; ++i) {
                ITransform step = ordSteps[i];
                if (step.hasParameters()) {
                    parmObjects.add(step);
                }
                if (!(step instanceof IDataTransform)) continue;
                IDataTransform dataStep = (IDataTransform)step;
                ArrayList<IDataObject> tables = new ArrayList<IDataObject>();
                tables.addAll(Arrays.asList(dataStep.getDataSources()));
                tables.addAll(Arrays.asList(dataStep.getDataTargets()));
                for (int k = 0; k < tables.size(); ++k) {
                    IParametersContainer table;
                    Object oTable = tables.get(k);
                    if (!(oTable instanceof IParametersContainer) || parmObjects.contains(oTable) || !(table = (IParametersContainer)oTable).hasParameters()) continue;
                    parmObjects.add(table);
                }
            }
            for (i = 0; i < parmObjects.size(); ++i) {
                ParametersSelectorTreeModel.this.appendChild((MutableTreeNode)ParametersSelectorTreeModel.this.createTreeNode(parmObjects.get(i), (IPersistableObject)this.m_oJob), (MutableTreeNode)((Object)this));
            }
            this.setHasExpanded(true);
        }
    }
}

