/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IParametersContainer;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.wadmin.visuals.common.ParameterPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class ParameterTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ParameterTab.class);
    protected ParameterPanel m_attrPanel = null;
    public static String DEFAULT_PARAMETER_HELPID = "parameters_tab";
    protected IParametersContainer m_parameterContainer = null;
    protected boolean m_allowImportParameters = false;
    protected boolean m_showImportExportXML = false;
    protected boolean m_bGeneratedTransform = false;

    public ParameterTab(IParametersContainer parmObject) {
        this(parmObject, DEFAULT_PARAMETER_HELPID, null);
    }

    public ParameterTab(IParametersContainer parmObject, String helpMapID, String title) {
        this(parmObject, false, helpMapID, title);
    }

    public ParameterTab(IParametersContainer parmObject, boolean allowImportParameters, String helpMapID, String title) {
        this(parmObject, allowImportParameters, helpMapID, false, title);
    }

    public ParameterTab(IParametersContainer parmObject, boolean allowImportParameters, String helpMapID, boolean showImportExportXML, String title) {
        this(parmObject, allowImportParameters, helpMapID, showImportExportXML, false, title);
    }

    public ParameterTab(IParametersContainer parmObject, boolean allowImportParameters, String helpMapID, boolean showImportExportXML, boolean generatedTransform, String title) {
        this.m_parameterContainer = parmObject;
        this.m_allowImportParameters = allowImportParameters;
        this.m_showImportExportXML = showImportExportXML;
        this.m_bGeneratedTransform = generatedTransform;
        this._initialize();
        this._layoutWidgets();
        if (helpMapID != null && helpMapID.length() > 0) {
            this.setHelpTopic(helpMapID);
        }
        if (title != null && title.length() > 0) {
            this.setName(title);
        } else {
            this.setName(bundle.getString("ParameterTab.Parameters.Title.txt"));
        }
    }

    protected void _initialize() {
        this.m_attrPanel = new ParameterPanel(null, this.m_allowImportParameters, this.m_parameterContainer, this.m_showImportExportXML, this.m_bGeneratedTransform);
        this.m_attrPanel.setHelpTopic(this.m_sHelpTopic);
        this.listenForDataChangesTo(this.m_attrPanel);
        this.m_attrPanel.setWAUndoManager(this.getWAUndoManager());
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_attrPanel.setEditable(editable);
    }

    public void setHelpTopic(String helpid) {
        super.setHelpTopic(helpid);
        this.m_attrPanel.setHelpTopic(helpid);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_attrPanel.saveSettingsAndCleanUp();
    }

    protected void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_attrPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        PromptGroupInterface promptGroup = this.m_parameterContainer.getPromptGroup();
        if (promptGroup != null) {
            this.m_attrPanel.setPromptGroup(promptGroup);
        }
        this.m_attrPanel.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_attrPanel.populateStore();
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        return this.m_attrPanel.validateData();
    }
}

