/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class OptionsCollectionPane
extends WAPanel {
    private WAPanel m_pnlPrompt;
    private PhysicalTablePromptModelCollection m_promptModel;
    private boolean m_bShowRequiredCheckbox = false;

    public OptionsCollectionPane(boolean bShowRequiredCheckbox) {
        this.m_bShowRequiredCheckbox = bShowRequiredCheckbox;
        this.setLayout(new BorderLayout());
    }

    public OptionsCollectionPane(PhysicalTablePromptModelCollection model, boolean showRequiredCheckbox) {
        this(showRequiredCheckbox);
        this.m_promptModel = model;
        this.initialize();
    }

    public void setPromptModel(PhysicalTablePromptModelCollection model) {
        if (this.m_promptModel == model) {
            return;
        }
        if (this.m_pnlPrompt != null) {
            this.remove((Component)this.m_pnlPrompt);
            this.m_pnlPrompt.saveSettingsAndCleanUp();
            this.m_pnlPrompt = null;
        }
        this.m_promptModel = model;
        if (this.m_promptModel != null) {
            try {
                this.m_pnlPrompt = this.createMainRunTimePanel();
                this.add((Component)this.m_pnlPrompt, "Center");
                this.validate();
                this.moveDataToView();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (ServerConnectionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
        }
    }

    public void initialize() {
        try {
            this.m_pnlPrompt = this.createMainRunTimePanel();
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_pnlPrompt, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (ServerConnectionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage());
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public PhysicalTablePromptModelCollection getModel() {
        return this.m_promptModel;
    }

    protected WAPanel createMainRunTimePanel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
        IPromptModel[] aModels;
        PhysicalTablePromptModelCollection collection = this.getModel();
        Object panel = null;
        if (collection != null && (aModels = collection.getModels()) != null && aModels.length > 0) {
            if (aModels.length > 1) {
                panel = new WATabbedPanel();
                for (int i = 0; i < aModels.length; ++i) {
                    panel.addTab(collection.getTitles()[i], (WAPropertyTab)new OptionsTab(aModels[i], collection.getHelpTopics()[i], this.m_bShowRequiredCheckbox));
                }
            } else {
                panel = new OptionsTab(aModels[0], collection.getHelpTopics()[0], this.m_bShowRequiredCheckbox);
            }
            panel.setEditable(this.isEditable());
        }
        return panel;
    }

    public String getHelpTopic() {
        return this.m_pnlPrompt != null ? this.m_pnlPrompt.getHelpTopic() : null;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.saveSettingsAndCleanUp();
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.setEditable(editable);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.moveDataToStore();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.moveDataToView();
        }
        this.setListeningForChanges(true);
    }

    public boolean validateData() {
        if (this.m_pnlPrompt != null) {
            this.m_pnlPrompt.validateData();
        }
        return true;
    }
}

