/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IHTTPServer;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.etl.models.other.ILASRServer;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.models.SimpleObject;
import java.awt.Frame;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class ModelUIUtilities {
    private static final WAdminResource bundle = WAdminResource.getBundle(ModelUIUtilities.class);
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    private ModelUIUtilities() {
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static void showWebpage(String url) {
        boolean windows = ModelUIUtilities.isWindowsPlatform();
        String runTimeCommandFmt = null;
        runTimeCommandFmt = windows ? "rundll32 url.dll,FileProtocolHandler {0}" : "netscape -remote openURL({0})";
        MessageFormat fmt = new MessageFormat(runTimeCommandFmt);
        String runTimeCommand = fmt.format(new Object[]{url});
        try {
            Runtime.getRuntime().exec(runTimeCommand);
        }
        catch (IOException e) {
            MessageUtil.displayMessage((String)e.getMessage(), (String)bundle.getString("ModelUIUtilities.ViewWebpage.FileError.title.txt"), (int)0, (int)-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showPropertiesDialog(IComplexPersistableObject object, WAPropertyTab[] aTabs) {
        int iRC;
        String sTitle = bundle.formatString("ModelUIUtilities.PropertiesDialog.Title.fmt", (Object)object.getName());
        WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), sTitle, true);
        dlg.setResizable(true);
        dlg.setEditable(object.getModel().isEditable() && Workspace.isObjectEditable((SimpleObject)object));
        dlg.setSettingsName("Transformation.PropertyDialog");
        WATabbedPanel pnlMain = (WATabbedPanel)dlg.getMainPanel();
        for (int iTab = 0; iTab < aTabs.length; ++iTab) {
            dlg.addTab(aTabs[iTab]);
        }
        AppPropertiesDialogFactory.getInstance().addPluginTabs(pnlMain, object);
        IModel mdl = object.getModel();
        UndoManager mgrOld = mdl.getUndoManager();
        ModelUndoManager mgrNew = new ModelUndoManager();
        dlg.setUndoManager((UndoManager)((Object)mgrNew));
        pnlMain.setUndoManager((UndoManager)((Object)mgrNew));
        mdl.setUndoManager((UndoManager)((Object)mgrNew));
        try {
            dlg.show();
            iRC = dlg.getReturnValue();
            ((UndoManager)((Object)mgrNew)).end();
            if (((UndoManager)((Object)mgrNew)).canUndo()) {
                if (iRC == 1) {
                    if (((CompoundEdit)((Object)mgrNew)).isSignificant()) {
                        mgrOld.addEdit((UndoableEdit)((Object)mgrNew));
                    }
                } else {
                    ((UndoManager)((Object)mgrNew)).undo();
                }
            }
        }
        finally {
            mdl.setUndoManager(mgrOld);
        }
        return iRC;
    }

    public static IServer acquireModelForDefaultSASAppServer(IModel model) {
        WsAppServer appServer = WsAppServer.createDefaultAppServer();
        if (appServer == null) {
            return null;
        }
        try {
            return ModelUIUtilities.getServerForAppServer(model, appServer);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return null;
    }

    public static boolean isTransformPerformingDataTransfer(IDataTransform transform) {
        IServer defaultServer = ModelUIUtilities.acquireModelForDefaultSASAppServer(transform.getModel());
        try {
            return transform.isTransformPerformingDataTransfer(defaultServer);
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayChainedExceptionMessage((Exception)((Object)e), (String)bundle.getString("Common.Error.txt"), (int)0);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayChainedExceptionMessage((Exception)((Object)e), (String)bundle.getString("Common.Error.txt"), (int)0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showDialog(IObject object, String sTitle, WAPanel pnlMain) {
        int iRC;
        WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), sTitle, true);
        dlg.setMainPanel(pnlMain);
        boolean bEditable = object.getModel().isEditable();
        if (object instanceof IComplexPersistableObject && !Workspace.isObjectEditable((SimpleObject)((IComplexPersistableObject)object))) {
            bEditable = false;
        }
        dlg.setEditable(bEditable);
        dlg.setResizable(true);
        IModel mdl = object.getModel();
        UndoManager mgrOld = mdl.getUndoManager();
        ModelUndoManager mgrNew = new ModelUndoManager();
        dlg.setUndoManager((UndoManager)((Object)mgrNew));
        mdl.setUndoManager((UndoManager)((Object)mgrNew));
        try {
            dlg.show();
            iRC = dlg.getReturnValue();
            ((UndoManager)((Object)mgrNew)).end();
            if (((UndoManager)((Object)mgrNew)).canUndo()) {
                if (iRC == 1) {
                    mgrOld.addEdit((UndoableEdit)((Object)mgrNew));
                } else {
                    ((UndoManager)((Object)mgrNew)).undo();
                }
            }
        }
        finally {
            mdl.setUndoManager(mgrOld);
        }
        return iRC;
    }

    public static IDataObject createDataObject(IModel model, PrimaryType obj) throws MdException, RemoteException {
        String sPublicType = obj.getPublicType();
        IDataObject oData = model.getObjectFactory().createDataObjectForPublicType(sPublicType, obj.getFQID());
        if (oData == null) {
            if ("PhysicalTable".equals(obj.getCMetadataType())) {
                oData = model.getObjectFactory().createPhysicalTable(obj.getFQID());
            } else if ("ExternalTable".equals(obj.getCMetadataType())) {
                oData = model.getObjectFactory().createExternalTable(obj.getFQID());
            } else if ("SASLibrary".equals(obj.getCMetadataType())) {
                oData = model.getObjectFactory().createLibrary(obj.getFQID());
            } else if ("Transformation".equals(obj.getCMetadataType())) {
                oData = model.getObjectFactory().createMessageQueue((Root)obj);
            } else if ("Document".equals(obj.getCMetadataType())) {
                oData = model.getObjectFactory().createDocument(obj.getFQID());
            }
        }
        return oData;
    }

    public static IServer getServerForAppServer(IModel model, WsAppServer appServer) throws MdException, RemoteException {
        if (appServer == null) {
            return null;
        }
        return ModelUIUtilities.getServerForAppServer(model, appServer.getServerFQID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServer getServerForAppServer(IModel model, String appServerId) throws MdException, RemoteException {
        if (appServerId == null) {
            return null;
        }
        IServer server = (IServer)model.getObject(appServerId);
        if (server != null) {
            return server;
        }
        server = model.getObjectFactory().createServer(appServerId);
        OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
        boolean bUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        try {
            omr.populateFor((IOMRPersistable)server);
            server.loadFromOMR(omr);
            IServer iServer = server;
            return iServer;
        }
        finally {
            model.setUndoSupported(bUndo);
            omr.dispose();
        }
    }

    public static ServerComponentInterface[] getServerComponents(String productName) throws MdException, RemoteException, ServiceException {
        InformationServiceInterface informationService = CorePlatformServices.getInformationService();
        Filter filter = new Filter();
        filter.setType("ServerComponent");
        List lServers = informationService.search(Workspace.getWorkspace().getUserContext(), (FilterInterface)filter);
        for (int i = lServers.size() - 1; i >= 0; --i) {
            if (lServers.get(i) instanceof ServerComponentInterface) {
                ServerComponentInterface sc = (ServerComponentInterface)lServers.get(i);
                if (productName.equals(sc.getProductName())) continue;
                lServers.remove(i);
                continue;
            }
            lServers.remove(i);
        }
        return lServers.toArray(new ServerComponentInterface[lServers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IHadoopServer[] getHadoopServers(IModel model) throws RemoteException, MdException, ServiceException {
        ServerComponentInterface[] scs = ModelUIUtilities.getServerComponents("HADOOP");
        ArrayList<IHadoopServer> hadoopServers = new ArrayList<IHadoopServer>();
        for (int i = 0; i < scs.length; ++i) {
            IHadoopServer server = (IHadoopServer)model.getObject(scs[i].getReposId());
            if (server == null) {
                server = model.getObjectFactory().createHadoopServer(scs[i].getReposId());
                OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
                boolean bUndo = model.isUndoSupported();
                model.setUndoSupported(false);
                try {
                    omr.populateFor((IOMRPersistable)server);
                    server.loadFromOMR(omr);
                }
                finally {
                    model.setUndoSupported(bUndo);
                    omr.dispose();
                }
            }
            hadoopServers.add(server);
        }
        return hadoopServers.toArray(new IHadoopServer[hadoopServers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ILASRServer[] getLASRServers(IModel model) throws RemoteException, MdException, ServiceException {
        ServerComponentInterface[] scs = ModelUIUtilities.getServerComponents("SASIOLA");
        ArrayList<ILASRServer> lServers = new ArrayList<ILASRServer>();
        for (int i = 0; i < scs.length; ++i) {
            ILASRServer server = (ILASRServer)model.getObject(scs[i].getReposId());
            if (server == null) {
                server = model.getObjectFactory().createLASRServer(scs[i].getReposId());
                OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
                boolean bUndo = model.isUndoSupported();
                model.setUndoSupported(false);
                try {
                    omr.populateFor((IOMRPersistable)server);
                    server.loadFromOMR(omr);
                }
                finally {
                    model.setUndoSupported(bUndo);
                    omr.dispose();
                }
            }
            lServers.add(server);
        }
        return lServers.toArray(new ILASRServer[lServers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServer[] getDMServers(IModel model) throws RemoteException, MdException, ServiceException {
        Filter filter = new Filter();
        filter.setType("ServerComponent");
        FilterComponent fqidComponent = new FilterComponent("ClassIdentifier", 0, "DAC0D7F0-10DA-11D6-8816-AA0004006D06");
        AssociationPathComponent assocComponent = new AssociationPathComponent();
        assocComponent.setAssociationPath("Properties", "Property");
        FilterComponent subType = new FilterComponent("PropertyName", 0, "SubType");
        subType.addComponent(new FilterComponent("DefaultValue", 0, "DatafluxDMS"));
        assocComponent.setAttributeCriteria(subType);
        fqidComponent.addAssociationPathComponent(assocComponent);
        fqidComponent.setAggregation(0);
        filter.setFilterComponent(fqidComponent);
        InformationServiceInterface informationService = CorePlatformServices.getInformationService();
        List lServers = informationService.search(Workspace.getWorkspace().getUserContext(), (FilterInterface)filter);
        ArrayList<IHTTPServer> httpServers = new ArrayList<IHTTPServer>();
        for (int i = 0; i < lServers.size(); ++i) {
            IHTTPServer server = (IHTTPServer)model.getObject(((ServerComponentInterface)lServers.get(i)).getReposId());
            if (server == null) {
                server = model.getObjectFactory().createHTTPServer(((ServerComponentInterface)lServers.get(i)).getReposId());
                OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
                boolean bUndo = model.isUndoSupported();
                model.setUndoSupported(false);
                try {
                    omr.populateFor((IOMRPersistable)server);
                    server.loadFromOMR(omr);
                }
                finally {
                    model.setUndoSupported(bUndo);
                    omr.dispose();
                }
            }
            httpServers.add(server);
        }
        return httpServers.toArray(new IHTTPServer[httpServers.size()]);
    }

    public static class UnableToUndoUndoable
    extends AbstractUndoableEdit {
        private BaseModel m_mdl;

        public UnableToUndoUndoable(BaseModel mdl) {
            this.m_mdl = mdl;
        }

        @Override
        public void undo() {
            super.undo();
            String sName = this.m_mdl.getMainObject().getName();
            String sMessage = bundle.formatString("ModelUIUtilities.Message.UnableToUndo.fmt.txt", (Object)sName);
            MessageUtil.displayMessage((String)sMessage, (String)sName, (int)1);
            this.m_mdl.getUndoManager().redo();
        }
    }
}

