/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IReflectiveObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.impl.DesignTimeJobModel;
import com.sas.etl.models.job.transforms.ExtractTransformModel;
import com.sas.etl.models.job.transforms.FileReaderTransformModel;
import com.sas.etl.models.job.transforms.FileWriterTransformModel;
import com.sas.etl.models.job.transforms.TableLoaderTransformModel;
import com.sas.etl.models.job.transforms.lookup.LookupTransformModel;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.impl.SelectResultsContainer;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.sql.editor.INavigationListener;
import com.sas.wadmin.transforms.sql.editor.NavigationEvent;
import com.sas.wadmin.transforms.sql.editor.SQLExpressionActions;
import com.sas.wadmin.visuals.common.ExpressionBuilderTab;
import com.sas.wadmin.visuals.common.MappingsModel;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.SourceColumnsTableModel;
import com.sas.wadmin.visuals.common.TableMappingsPanel;
import com.sas.wadmin.visuals.common.TableUIUtilities;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.wadmin.visuals.common.TargetColumnsTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsDropMenuTableCellEditor;
import com.sas.workspace.WsMapping;
import com.sas.workspace.WsObjectListModel;
import com.sas.workspace.WsObjectSelectionEvent;
import com.sas.workspace.WsObjectSelectionListener;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class MappingsTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(MappingsTab.class);
    private static final int MIN_TABLE_WIDTH = 50;
    private static final int MIN_TABLE_HEIGHT = 100;
    private static final int PREF_TABLE_WIDTH = 150;
    private static final int PREF_TABLE_HEIGHT = 200;
    private static final int MIN_MAPPINGS_WIDTH = 20;
    private static final int MIN_MAPPINGS_HEIGHT = 100;
    private static final int PREF_MAPPINGS_WIDTH = 50;
    private static final int PREF_MAPPINGS_HEIGHT = 200;
    private static final int MIN_WIDTH = 120;
    private static final int MEDIUM_WIDTH = 320;
    private static final int PREF_WIDTH = 350;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private IMappingsContainer m_container;
    private DesignTimeJobModel m_mdlJob;
    private SourceColumnsTableModel m_mdlSourceColumns;
    private TargetColumnsTableModel m_mdlTargetColumns;
    private MappingsModel m_mdlMappings;
    private ITable[] m_aSourceTables;
    private boolean[] m_aSourceTableEditables;
    private ITable[] m_aTargetTables;
    private boolean[] m_aTargetTableEditables;
    private Configuration m_configuration;
    private JCheckBox m_ckbAllFields;
    private JCheckBox m_ckbDistinctRows;
    private JPanel m_pnlSetOperatorSpecifics;
    private JToolBar m_barTools;
    private JSplitPane m_spltInner;
    private JSplitPane m_spltOuter;
    private WsTable m_tblSourceColumns;
    private JScrollPane m_scrSourceColumns;
    private JLabel m_lblSourceTables;
    private WAComboBox m_cmbSourceTables;
    private JLabel m_lblSourceTable;
    private JButton m_btnExpandSourcePanel;
    private JButton m_btnCollapseSourcePanel;
    private JToolBar m_pnlSourceLabel;
    private JPanel m_pnlSource;
    private JPopupMenu m_mnuSourceTablePopup;
    private JPopupMenu m_mnuSourceViewportPopup;
    private WsTable m_tblTargetColumns;
    private JScrollPane m_scrTargetColumns;
    private JLabel m_lblTargetTables;
    private WAComboBox m_cmbTargetTables;
    private JLabel m_lblTargetTable;
    private JButton m_btnExpandTargetPanel;
    private JButton m_btnCollapseTargetPanel;
    private JToolBar m_pnlTargetLabel;
    private JPanel m_pnlTarget;
    private JPopupMenu m_mnuTargetTablePopup;
    private JPopupMenu m_mnuTargetViewportPopup;
    private TableMappingsPanel m_pnlMappings;
    private JPanel m_pnlCenterLabel;
    private JPanel m_pnlCenter;
    private JPopupMenu m_mnuMappingsPopup;
    private JPopupMenu m_mnuExpressionsPopup;
    private WsAbstractAction m_actPropagate;
    private WsDropMenuAction m_actPropagateDropMenu;
    private WsAbstractAction m_actToTargets;
    private WsAbstractAction m_actToTargetsFromSources;
    private WsAbstractAction m_actToTargetsFromBeginning;
    private WsAbstractAction m_actToTargetsFromEnd;
    private WsAbstractAction m_actToSources;
    private WsAbstractAction m_actToSourcesFromTargets;
    private WsAbstractAction m_actToSourcesFromBeginning;
    private WsAbstractAction m_actToSourcesFromEnd;
    private WsAbstractAction m_actFromTargets;
    private WsAbstractAction m_actFromTargetsToSources;
    private WsAbstractAction m_actFromTargetsToBeginning;
    private WsAbstractAction m_actFromTargetsToEnd;
    private WsAbstractAction m_actFromSources;
    private WsAbstractAction m_actFromSourcesToTargets;
    private WsAbstractAction m_actFromSourcesToBeginning;
    private WsAbstractAction m_actFromSourcesToEnd;
    private WsAbstractAction m_actSelectedTargetColumns;
    private WsAbstractAction m_actSelectedTargetColumnsToSources;
    private WsAbstractAction m_actSelectedTargetColumnsToBeginning;
    private WsAbstractAction m_actSelectedTargetColumnsToEnd;
    private WsAbstractAction m_actSelectedSourceColumns;
    private WsAbstractAction m_actSelectedSourceColumnsToTargets;
    private WsAbstractAction m_actSelectedSourceColumnsToBeginning;
    private WsAbstractAction m_actSelectedSourceColumnsToEnd;
    private WsAbstractAction m_actUpdateSelectedTargetColumns;
    private WsAbstractAction m_actUpdateSelectedTargetColumnsToSources;
    private WsAbstractAction m_actUpdateSelectedTargetColumnsToBeginning;
    private WsAbstractAction m_actUpdateSelectedTargetColumnsToEnd;
    private WsAbstractAction m_actUpdateSelectedSourceColumns;
    private WsAbstractAction m_actUpdateSelectedSourceColumnsToTargets;
    private WsAbstractAction m_actUpdateSelectedSourceColumnsToBeginning;
    private WsAbstractAction m_actUpdateSelectedSourceColumnsToEnd;
    private WsAbstractAction m_actMapAll;
    private WsAbstractAction m_actMapSelected;
    private WsDropMenuAction m_actSettings;
    private WsAbstractToggleAction m_actIncludeTransformationInPropagation;
    private WsAbstractToggleAction m_actIncludeTransformationInMapping;
    private WsAbstractToggleAction m_actIncludeColumnsInPropagation;
    private WsAbstractToggleAction m_actIncludeColumnsInMapping;
    private WsAbstractAction m_actSaveCurrentSourceColumnOrder;
    private WsAbstractAction m_actNewColumn;
    private WsAbstractAction m_actImportColumns;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actSaveCurrentTargetColumnOrder;
    private WsAbstractAction m_actFixWarningMenu;
    private WsDropMenuAction m_actFixWarningDropMenu;
    private WsAbstractAction m_actFixSourceColumn;
    private WsAbstractAction m_actFixTargetColumn;
    private WsAbstractAction m_actFixExpressionMappings;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractAction m_actExpression;
    private WsDropMenuAction m_actExpressionDropMenu;
    private WsAbstractAction m_actChooseColumns;
    private WsAbstractAction m_actCase;
    private WsAbstractAction m_actSubquery;
    private WsAbstractAction m_actAdvanced;
    private WsDropMenuAction m_actDelete;
    private WsAbstractAction m_actDeleteSourceColumns;
    private WsAbstractAction m_actDeleteMappings;
    private WsAbstractAction m_actDeleteTargetColumns;
    private WsAbstractAction m_actExpandSourcePanel;
    private WsAbstractAction m_actCollapseSourcePanel;
    private WsAbstractAction m_actExpandTargetPanel;
    private WsAbstractAction m_actCollapseTargetPanel;
    private WsAbstractAction m_actSelectAllSourceColumns;
    private WsAbstractAction m_actSelectAllMappings;
    private WsAbstractAction m_actSelectAllTargetColumns;
    private WsAbstractToggleAction m_actAllFields;
    private WsAbstractToggleAction m_actDistinctRows;
    private ChangeListener m_lsnrUndo;
    private ModelListener m_lsnrModel;
    private List m_lSQLNavigateListeners;
    private boolean m_bSQLNavigateEventsEnabled;
    private Border m_brdrPanel;
    private ITable m_tblSelectedSource;
    private boolean m_bSelectedSourceTableEditable;
    private ITable m_tblSelectedTarget;
    private boolean m_bSelectedTargetTableEditable;
    private boolean m_bSourcePanelExpanded;
    private boolean m_bTargetPanelExpanded;
    private boolean m_bSplitLocationSet;
    private int m_cxInnerOriginal;
    private int m_cxOuterOriginal;
    private int m_cxDividerSize;
    private JRootPane m_rootPane;

    public MappingsTab(IMappingsContainer container) {
        this(container, new Configuration());
    }

    public MappingsTab(IMappingsContainer container, Configuration configuration) {
        this.m_container = container;
        this.m_mdlJob = (DesignTimeJobModel)container.getModel();
        this.m_configuration = configuration;
        this.m_bSQLNavigateEventsEnabled = true;
        this.initialize();
        this.setName(bundle.getString("MappingsTab.Name.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("mapping_tab");
    }

    protected void initialize() {
        this.createActions();
        this.createSetOperatorSpecifics();
        this.createToolBar();
        this.createPanelBorder();
        this.createSourceColumnsTableModel();
        this.createSourceColumnsTable();
        this.createSourceColumnsTablePopupMenu();
        this.createSourceColumnsViewportPopupMenu();
        this.createSourcePanelLabel();
        this.createSourcePanel();
        this.createTargetColumnsTableModel();
        this.createTargetColumnsTable();
        this.createTargetColumnsTablePopupMenu();
        this.createTargetColumnsViewportPopupMenu();
        this.createTargetPanelLabel();
        this.createTargetPanel();
        this.createMappingsModel();
        this.createMappingsPanel();
        this.createMappingsPopupMenu();
        this.createCenterPanelLabel();
        this.createCenterPanel();
        this.m_spltInner = this.createSplitPane(this.m_pnlSource, this.m_pnlCenter);
        this.m_spltInner.setName("inner");
        this.m_spltOuter = this.createSplitPane(this.m_spltInner, this.m_pnlTarget);
        this.m_spltOuter.setName("outer");
        this.layoutComponents();
        this.m_aSourceTables = this.m_container.getSourceTables();
        this.m_aTargetTables = this.m_container.getTargetTables();
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener((IModelListener)this.m_lsnrModel);
    }

    private void createActions() {
        this.m_actPropagate = new PropagateAction();
        this.m_actPropagateDropMenu = new PropagateDropMenuAction();
        this.m_actToTargets = new ToTargetsAction();
        this.m_actToTargetsFromSources = new ToTargetsFromSourcesAction();
        this.m_actToTargetsFromBeginning = new ToTargetsFromBeginningAction();
        this.m_actToTargetsFromEnd = new ToTargetsFromEndAction();
        this.m_actToSources = new ToSourcesAction();
        this.m_actToSourcesFromTargets = new ToSourcesFromTargetsAction();
        this.m_actToSourcesFromBeginning = new ToSourcesFromBeginningAction();
        this.m_actToSourcesFromEnd = new ToSourcesFromEndAction();
        this.m_actFromTargets = new FromTargetsAction();
        this.m_actFromTargetsToSources = new FromTargetsToSourcesAction();
        this.m_actFromTargetsToBeginning = new FromTargetsToBeginningAction();
        this.m_actFromTargetsToEnd = new FromTargetsToEndAction();
        this.m_actFromSources = new FromSourcesAction();
        this.m_actFromSourcesToTargets = new FromSourcesToTargetsAction();
        this.m_actFromSourcesToBeginning = new FromSourcesToBeginningAction();
        this.m_actFromSourcesToEnd = new FromSourcesToEndAction();
        this.m_actSelectedTargetColumns = new SelectedTargetColumnsAction();
        this.m_actSelectedTargetColumnsToSources = new SelectedTargetColumnsToSourcesAction();
        this.m_actSelectedTargetColumnsToBeginning = new SelectedTargetColumnsToBeginningAction();
        this.m_actSelectedTargetColumnsToEnd = new SelectedTargetColumnsToEndAction();
        this.m_actSelectedSourceColumns = new SelectedSourceColumnsAction();
        this.m_actSelectedSourceColumnsToTargets = new SelectedSourceColumnsToTargetsAction();
        this.m_actSelectedSourceColumnsToBeginning = new SelectedSourceColumnsToBeginningAction();
        this.m_actSelectedSourceColumnsToEnd = new SelectedSourceColumnsToEndAction();
        this.m_actUpdateSelectedTargetColumns = new UpdateSelectedTargetColumnsAction();
        this.m_actUpdateSelectedTargetColumnsToSources = new UpdateSelectedTargetColumnsToSourcesAction();
        this.m_actUpdateSelectedTargetColumnsToBeginning = new UpdateSelectedTargetColumnsToBeginningAction();
        this.m_actUpdateSelectedTargetColumnsToEnd = new UpdateSelectedTargetColumnsToEndAction();
        this.m_actUpdateSelectedSourceColumns = new UpdateSelectedSourceColumnsAction();
        this.m_actUpdateSelectedSourceColumnsToTargets = new UpdateSelectedSourceColumnsToTargetsAction();
        this.m_actUpdateSelectedSourceColumnsToBeginning = new UpdateSelectedSourceColumnsToBeginningAction();
        this.m_actUpdateSelectedSourceColumnsToEnd = new UpdateSelectedSourceColumnsToEndAction();
        this.m_actPropagateDropMenu.setDropMenu(this.createPropagateDropMenu());
        this.m_actMapAll = new MapAllAction();
        this.m_actMapSelected = new MapSelectedColumnsAction();
        this.m_actSettings = new SettingsAction();
        this.m_actIncludeTransformationInPropagation = new IncludeTransformationInPropagationAction();
        this.m_actIncludeTransformationInMapping = new IncludeTransformationInMappingAction();
        this.m_actIncludeColumnsInPropagation = new IncludeColumnsInPropagationAction();
        this.m_actIncludeColumnsInMapping = new IncludeColumnsInMappingAction();
        this.m_actSettings.setDropMenu(this.createSettingsDropMenu());
        this.m_actSaveCurrentSourceColumnOrder = new SaveCurrentSourceColumnOrderAction();
        this.m_actNewColumn = new NewColumnAction();
        this.m_actImportColumns = new ImportColumnsAction();
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actSaveCurrentTargetColumnOrder = new SaveCurrentTargetColumnOrderAction();
        this.m_actFixWarningMenu = new FixWarningAction();
        this.m_actFixWarningDropMenu = new FixWarningDropMenuAction();
        this.m_actFixSourceColumn = new FixSourceColumnAction();
        this.m_actFixTargetColumn = new FixTargetColumnAction();
        this.m_actFixExpressionMappings = new FixExpressionMappingsAction();
        this.m_actFixWarningDropMenu.setDropMenu(this.createFixWarningDropMenu());
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_actExpression = new ExpressionAction();
        this.m_actExpressionDropMenu = new ExpressionDropMenuAction();
        this.m_actChooseColumns = new ChooseColumnsAction();
        this.m_actCase = new CaseAction();
        this.m_actSubquery = new SubqueryAction();
        this.m_actAdvanced = new AdvancedAction();
        this.createExpressionsDropMenu();
        this.m_actExpressionDropMenu.setDropMenu(this.m_mnuExpressionsPopup);
        this.m_actAllFields = new AllFieldsToggleAction();
        this.m_actDistinctRows = new DistinctRowsToggleAction();
        this.m_actExpandSourcePanel = new ExpandSourcePanelAction();
        this.m_actCollapseSourcePanel = new CollapseSourcePanelAction();
        this.m_actExpandTargetPanel = new ExpandTargetPanelAction();
        this.m_actCollapseTargetPanel = new CollapseTargetPanelAction();
        this.m_actDelete = new DeleteAction();
        this.m_actDeleteSourceColumns = new DeleteSourceColumnsAction();
        this.m_actDeleteMappings = new DeleteMappingsAction();
        this.m_actDeleteTargetColumns = new DeleteTargetColumnsAction();
        this.m_actDelete.setDropMenu(this.createDeleteDropMenu());
        this.m_actSelectAllSourceColumns = new SelectAllSourceColumnsAction();
        this.m_actSelectAllMappings = new SelectAllMappingsAction();
        this.m_actSelectAllTargetColumns = new SelectAllTargetColumnsAction();
        ActionMap mapActions = this.getActionMap();
        mapActions.put("delete", (Action)this.m_actDeleteMappings);
        mapActions.put("selectAll", (Action)this.m_actSelectAllMappings);
        InputMap mapInput = this.getInputMap(1);
        mapInput.put(KeyStroke.getKeyStroke(127, 0), "delete");
        mapInput.put(KeyStroke.getKeyStroke(65, 2), "selectAll");
    }

    private JPopupMenu createPropagateDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        int ePropagationActionsVisible = this.m_configuration.getPropagationActionsVisible();
        if (ePropagationActionsVisible == 0) {
            JMenu mnuToTargets = WsUIUtilities.createMenu((WsAbstractAction)this.m_actToTargets);
            mnuToTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToTargetsFromSources));
            mnuToTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToTargetsFromBeginning));
            mnuToTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToTargetsFromEnd));
            JMenu mnuToSources = WsUIUtilities.createMenu((WsAbstractAction)this.m_actToSources);
            mnuToSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToSourcesFromTargets));
            mnuToSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToSourcesFromBeginning));
            mnuToSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToSourcesFromEnd));
            JMenu mnuFromTargets = WsUIUtilities.createMenu((WsAbstractAction)this.m_actFromTargets);
            mnuFromTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromTargetsToSources));
            mnuFromTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromTargetsToBeginning));
            mnuFromTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromTargetsToEnd));
            JMenu mnuFromSources = WsUIUtilities.createMenu((WsAbstractAction)this.m_actFromSources);
            mnuFromSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToTargets));
            mnuFromSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToBeginning));
            mnuFromSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToEnd));
            JMenu mnuTargetColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actSelectedTargetColumns);
            mnuTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedTargetColumnsToSources));
            mnuTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedTargetColumnsToBeginning));
            mnuTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedTargetColumnsToEnd));
            JMenu mnuSourceColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actSelectedSourceColumns);
            mnuSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToTargets));
            mnuSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToBeginning));
            mnuSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToEnd));
            JMenu mnuUpdateTargetColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actUpdateSelectedTargetColumns);
            mnuUpdateTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedTargetColumnsToSources));
            mnuUpdateTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedTargetColumnsToBeginning));
            mnuUpdateTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedTargetColumnsToEnd));
            JMenu mnuUpdateSourceColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actUpdateSelectedSourceColumns);
            mnuUpdateSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToTargets));
            mnuUpdateSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToBeginning));
            mnuUpdateSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToEnd));
            mnuDrop.add(mnuToTargets);
            mnuDrop.add(mnuToSources);
            mnuDrop.add(mnuFromTargets);
            mnuDrop.add(mnuFromSources);
            mnuDrop.addSeparator();
            mnuDrop.add(mnuTargetColumns);
            mnuDrop.add(mnuSourceColumns);
            mnuDrop.addSeparator();
            mnuDrop.add(mnuUpdateTargetColumns);
            mnuDrop.add(mnuUpdateSourceColumns);
        } else if (ePropagationActionsVisible == 1) {
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToTargets));
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToTargets));
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToTargets));
        }
        return mnuDrop;
    }

    private JPopupMenu createSettingsDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actIncludeTransformationInPropagation));
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actIncludeTransformationInMapping));
        mnuDrop.addSeparator();
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actIncludeColumnsInPropagation));
        mnuDrop.add(WsUIUtilities.createCheckBoxMenuItem((WsAbstractToggleAction)this.m_actIncludeColumnsInMapping));
        return mnuDrop;
    }

    private JPopupMenu createDeleteDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        if (this.m_configuration.isSourceTablesEditable()) {
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteSourceColumns));
        }
        mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteMappings));
        if (this.m_configuration.isTargetTablesEditable()) {
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteTargetColumns));
        }
        return mnuDrop;
    }

    private JPopupMenu createFixWarningDropMenu() {
        JPopupMenu mnuDrop = new JPopupMenu();
        mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFixSourceColumn));
        mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFixTargetColumn));
        if (this.m_configuration.m_bExpressionActionsVisible) {
            mnuDrop.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFixExpressionMappings));
        }
        return mnuDrop;
    }

    private void createExpressionsDropMenu() {
        this.m_mnuExpressionsPopup = new JPopupMenu();
        this.addActionToMenu(0, this.m_actChooseColumns, this.m_mnuExpressionsPopup);
        this.addActionToMenu(1, this.m_actCase, this.m_mnuExpressionsPopup);
        this.addActionToMenu(2, this.m_actSubquery, this.m_mnuExpressionsPopup);
        this.addActionToMenu(3, this.m_actAdvanced, this.m_mnuExpressionsPopup);
    }

    private boolean addActionToMenu(int eAction, WsAbstractAction action, JComponent menu) {
        if (this.m_configuration.isActionHidden(eAction)) {
            return false;
        }
        menu.add(WsUIUtilities.createMenuItem((WsAbstractAction)action));
        return true;
    }

    private void createSetOperatorSpecifics() {
        if (this.m_configuration.isSetOperatorSpecificsEnabled()) {
            this.m_ckbAllFields = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actAllFields);
            this.m_ckbDistinctRows = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.m_actDistinctRows);
            this.listenForDataChangesTo(this.m_ckbAllFields);
            this.listenForDataChangesTo(this.m_ckbDistinctRows);
            this.m_pnlSetOperatorSpecifics = new JPanel(new GridBagLayout());
            this.m_pnlSetOperatorSpecifics.add((Component)this.m_ckbAllFields, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSetOperatorSpecifics.add((Component)this.m_ckbDistinctRows, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSetOperatorSpecifics.add((Component)new JPanel(), new GridBagConstraints(2, 0, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSetOperatorSpecifics.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        }
    }

    private void createToolBar() {
        this.m_barTools = this.createToolBarInstant();
    }

    protected JToolBar createToolBarInstant() {
        JToolBar toolbar = WsUIUtilities.createToolBar();
        if (this.m_configuration.getPropagationActionsVisible() != 2) {
            toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actFromSourcesToTargets));
        }
        if (this.m_configuration.getPropagationActionsVisible() == 0) {
            toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actFromTargetsToSources));
        }
        if (this.m_configuration.getPropagationActionsVisible() != 2) {
            toolbar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actPropagateDropMenu));
            toolbar.addSeparator();
        }
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMapAll));
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMapSelected));
        toolbar.addSeparator();
        if (this.m_configuration.isSettingsActionVisible()) {
            toolbar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actSettings));
            toolbar.addSeparator();
        }
        if (this.m_configuration.isTargetTablesEditable()) {
            toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actNewColumn));
            toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actImportColumns));
            toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveUp));
            toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actMoveDown));
            toolbar.addSeparator();
        }
        if (this.m_configuration.isExpressionActionsVisible()) {
            toolbar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actExpressionDropMenu));
            toolbar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actFixWarningDropMenu));
            toolbar.addSeparator();
        }
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUndo));
        toolbar.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRedo));
        toolbar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actDelete));
        return toolbar;
    }

    private void createSourceColumnsTableModel() {
        this.m_mdlSourceColumns = new SourceColumnsTableModel(this.m_container);
        if (!this.m_configuration.isSourceTablesEditable()) {
            for (int iColumn = 0; iColumn < this.m_mdlSourceColumns.getColumnCount(); ++iColumn) {
                this.m_mdlSourceColumns.getColumn(iColumn).setEditable(false);
            }
        }
    }

    private void createSourceColumnsTable() {
        this.m_tblSourceColumns = new WsTable((WsAbstractTableModel)this.m_mdlSourceColumns);
        this.m_tblSourceColumns.setName("source");
        this.m_tblSourceColumns.setKeepSortedEnabled(true);
        this.m_tblSourceColumns.setMultipleSelectionDragEnabled(this.m_configuration.isDragMultipleSourceColumnsEnabled());
        int[] aHiddenColumns = this.m_configuration.getHiddenColumnsInSourceColumnsTable();
        for (int iColumn = 0; iColumn < aHiddenColumns.length; ++iColumn) {
            this.m_tblSourceColumns.removeColumn(aHiddenColumns[iColumn]);
        }
        String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix() + ".";
        this.m_tblSourceColumns.restoreSettings(rootKey + this.m_configuration.getSourceTableSettingsKeyPrefix());
        this.m_tblSourceColumns.setDeleteKeyAction((Action)this.m_actDeleteSourceColumns);
        SourceColumnsTablePopupListener lsnr = new SourceColumnsTablePopupListener();
        this.m_tblSourceColumns.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblSourceColumns.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblSourceColumns.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new SourceColumnsViewportPopupListener());
        this.m_tblSourceColumns.getSelectionModel().addListSelectionListener(new SourceColumnsSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblSourceColumns.getRowModel()).addRowModelListener((WsTableRowModelListener)new SourceRowModelListener());
        this.m_scrSourceColumns = new JScrollPane((Component)this.m_tblSourceColumns);
        this.m_scrSourceColumns.setMinimumSize(new Dimension(50, 100));
        this.m_scrSourceColumns.setPreferredSize(new Dimension(150, 200));
        this.m_scrSourceColumns.setBorder(BorderFactory.createEmptyBorder());
    }

    private void createSourceColumnsTablePopupMenu() {
        this.m_mnuSourceTablePopup = this.createSourceTablePopupMenu();
    }

    protected JPopupMenu createSourceTablePopupMenu() {
        JPopupMenu sourceTablePopupMenu = new JPopupMenu();
        int ePropagationActionsVisible = this.m_configuration.getPropagationActionsVisible();
        if (ePropagationActionsVisible == 0) {
            JMenu mnuToSources = WsUIUtilities.createMenu((WsAbstractAction)this.m_actToSources);
            mnuToSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToSourcesFromTargets));
            mnuToSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToSourcesFromBeginning));
            mnuToSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToSourcesFromEnd));
            JMenu mnuFromSources = WsUIUtilities.createMenu((WsAbstractAction)this.m_actFromSources);
            mnuFromSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToTargets));
            mnuFromSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToBeginning));
            mnuFromSources.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToEnd));
            JMenu mnuSourceColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actSelectedSourceColumns);
            mnuSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToTargets));
            mnuSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToBeginning));
            mnuSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToEnd));
            JMenu mnuUpdateSourceColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actUpdateSelectedSourceColumns);
            mnuUpdateSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToTargets));
            mnuUpdateSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToBeginning));
            mnuUpdateSourceColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToEnd));
            JMenu mnuPropagate = WsUIUtilities.createMenu((WsAbstractAction)this.m_actPropagate);
            mnuPropagate.add(mnuToSources);
            mnuPropagate.add(mnuFromSources);
            mnuPropagate.addSeparator();
            mnuPropagate.add(mnuSourceColumns);
            mnuPropagate.add(mnuUpdateSourceColumns);
            sourceTablePopupMenu.add(mnuPropagate);
        } else if (ePropagationActionsVisible == 1) {
            JMenu mnuPropagate = WsUIUtilities.createMenu((WsAbstractAction)this.m_actPropagate);
            mnuPropagate.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromSourcesToTargets));
            mnuPropagate.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedSourceColumnsToTargets));
            mnuPropagate.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedSourceColumnsToTargets));
            sourceTablePopupMenu.add(mnuPropagate);
        }
        sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapAll));
        sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapSelected));
        sourceTablePopupMenu.addSeparator();
        sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllSourceColumns));
        if (this.m_configuration.isSourceTablesEditable()) {
            sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteSourceColumns));
            sourceTablePopupMenu.addSeparator();
            sourceTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSaveCurrentSourceColumnOrder));
        }
        return sourceTablePopupMenu;
    }

    private void createSourceColumnsViewportPopupMenu() {
        this.m_mnuSourceViewportPopup = new JPopupMenu();
        this.m_mnuSourceViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllSourceColumns));
        if (this.m_configuration.isSourceTablesEditable()) {
            this.m_mnuSourceViewportPopup.addSeparator();
            this.m_mnuSourceViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSaveCurrentSourceColumnOrder));
        }
    }

    private void createSourcePanelLabel() {
        this.m_pnlSourceLabel = WsUIUtilities.createToolBar();
        this.m_pnlSourceLabel.setLayout(new GridBagLayout());
        this.m_btnExpandSourcePanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actExpandSourcePanel);
        this.m_btnCollapseSourcePanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCollapseSourcePanel);
        this.m_btnCollapseSourcePanel.setVisible(false);
        if (this.m_configuration.isMultipleSourceTablesEnabled()) {
            this.m_cmbSourceTables = new WAComboBox();
            this.m_cmbSourceTables.addItemListener((ItemListener)new SourceTableSelectionListener());
            this.m_lblSourceTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbSourceTables, (String)this.m_configuration.getSourceTableLabel());
            this.m_pnlSourceLabel.add((Component)this.m_lblSourceTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_cmbSourceTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnExpandSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnCollapseSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.m_lblSourceTable = new JLabel();
            this.m_lblSourceTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_tblSourceColumns, (String)this.m_configuration.getSourceTableLabel());
            this.m_pnlSourceLabel.add((Component)this.m_lblSourceTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_lblSourceTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnExpandSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlSourceLabel.add((Component)this.m_btnCollapseSourcePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void refreshSQLSetOperatorsSpecifics() {
        IQuery query = null;
        if (this.m_container instanceof ISelectResultsContainer && this.m_configuration.isSetOperatorSpecificsEnabled()) {
            query = ((ISelectResultsContainer)this.m_container).getParentQuery();
            this.m_ckbDistinctRows.setSelected(query.useDistinct());
            this.m_ckbAllFields.setSelected(query.useImplicit());
        }
    }

    private void refreshSourcePanelLabel() {
        if (this.m_configuration.isMultipleSourceTablesEnabled()) {
            ITable tblSelected = this.getSelectedSourceTable();
            this.m_cmbSourceTables.removeAllItems();
            this.m_cmbSourceTables.addItem((Object)bundle.getString("MappingsTab.ComboBoxItem.AllTables.txt"));
            this.m_cmbSourceTables.addItem(WAComboBox.SEPARATOR);
            for (int iTable = 0; iTable < this.m_aSourceTables.length; ++iTable) {
                this.m_cmbSourceTables.addItem((Object)TableUIUtilities.getViewName(this.m_aSourceTables[iTable]));
                if (this.m_aSourceTables[iTable] != tblSelected) continue;
                this.m_cmbSourceTables.setSelectedIndex(iTable + 2);
            }
            if (this.m_aSourceTables.length == 1) {
                this.m_cmbSourceTables.setSelectedIndex(2);
            }
        } else {
            this.m_lblSourceTable.setText(this.m_aSourceTables.length > 0 ? TableUIUtilities.getViewName(this.m_aSourceTables[0]) : "");
            this.setSelectedSourceTable(this.m_aSourceTables.length > 0 ? this.m_aSourceTables[0] : null);
        }
    }

    private void createSourcePanel() {
        this.m_pnlSource = new JPanel(new BorderLayout());
        this.m_pnlSource.setBorder(this.m_brdrPanel);
        this.m_pnlSource.add((Component)this.m_pnlSourceLabel, "North");
        this.m_pnlSource.add((Component)this.m_scrSourceColumns, "Center");
    }

    private void setSourceColumnsTableEditable(boolean bEditable) {
        if (!this.m_configuration.isSourceTablesEditable()) {
            return;
        }
        for (int iColumn = 0; iColumn < this.m_mdlSourceColumns.getColumnCount(); ++iColumn) {
            this.m_mdlSourceColumns.getColumn(iColumn).setEditable(bEditable);
        }
    }

    private void createTargetColumnsTableModel() {
        this.m_mdlTargetColumns = new TargetColumnsTableModel(this.m_container);
        this.m_mdlTargetColumns.setUseSQLSyntax(this.m_configuration.isUsingSQLSyntax());
        this.m_mdlTargetColumns.setMappingsFilter(this.m_configuration.getMappingsFilter());
        this.createExpressionCellEditor();
        if (!this.m_configuration.isTargetTablesEditable()) {
            for (int iColumn = 0; iColumn < this.m_mdlTargetColumns.getColumnCount(); ++iColumn) {
                if (iColumn == 0 || iColumn == 1 || iColumn == 4) continue;
                this.m_mdlTargetColumns.getColumn(iColumn).setEditable(false);
            }
        }
    }

    private void createExpressionCellEditor() {
        WsDropMenuTableCellEditor editor = new WsDropMenuTableCellEditor();
        editor.setMultiLineEdit(true);
        editor.setDropMenu(this.m_mnuExpressionsPopup);
        this.m_mdlTargetColumns.setExpressionCellEditor((TableCellEditor)editor);
    }

    private void createTargetColumnsTable() {
        this.m_tblTargetColumns = new WsTable((WsAbstractTableModel)this.m_mdlTargetColumns);
        this.m_tblTargetColumns.setName("target");
        this.m_tblTargetColumns.setKeepSortedEnabled(true);
        this.m_tblTargetColumns.setColumnHeaderToolTipsEnabled(true);
        this.m_tblTargetColumns.setMultipleSelectionDragEnabled(this.m_configuration.isDragMultipleTargetColumnsEnabled());
        this.m_tblTargetColumns.getColumnModel().getColumn(0).setResizable(false);
        this.m_tblTargetColumns.getColumnModel().getColumn(1).setResizable(false);
        int[] aHiddenColumns = this.m_configuration.getHiddenColumnsInTargetColumnsTable();
        for (int iColumn = 0; iColumn < aHiddenColumns.length; ++iColumn) {
            this.m_tblTargetColumns.removeColumn(aHiddenColumns[iColumn]);
        }
        String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix() + ".";
        this.m_tblTargetColumns.restoreSettings(rootKey + this.m_configuration.getTargetTableSettingsKeyPrefix());
        this.m_tblTargetColumns.setDeleteKeyAction((Action)this.m_actDeleteTargetColumns);
        TargetColumnsTablePopupListener lsnr = new TargetColumnsTablePopupListener();
        this.m_tblTargetColumns.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblTargetColumns.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)lsnr);
        this.m_tblTargetColumns.setViewportPopupMenuRequestListener((WsPopupMenuRequestListener)new TargetColumnsViewportPopupListener());
        this.m_tblTargetColumns.getSelectionModel().addListSelectionListener(new TargetColumnsSelectionListener());
        ((WsDefaultTableRowModel)this.m_tblTargetColumns.getRowModel()).addRowModelListener((WsTableRowModelListener)new TargetRowModelListener());
        this.m_scrTargetColumns = new JScrollPane((Component)this.m_tblTargetColumns);
        this.m_scrTargetColumns.setBorder(BorderFactory.createEmptyBorder());
        this.m_scrTargetColumns.setMinimumSize(new Dimension(50, 100));
        this.m_scrTargetColumns.setPreferredSize(new Dimension(150, 200));
    }

    private void createTargetColumnsTablePopupMenu() {
        this.m_mnuTargetTablePopup = this.createTargetTablePopupMenu();
    }

    protected JPopupMenu createTargetTablePopupMenu() {
        JPopupMenu targetTablePopupMenu = new JPopupMenu();
        if (this.m_configuration.getPropagationActionsVisible() == 0) {
            JMenu mnuToTargets = WsUIUtilities.createMenu((WsAbstractAction)this.m_actToTargets);
            mnuToTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToTargetsFromSources));
            mnuToTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToTargetsFromBeginning));
            mnuToTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actToTargetsFromEnd));
            JMenu mnuFromTargets = WsUIUtilities.createMenu((WsAbstractAction)this.m_actFromTargets);
            mnuFromTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromTargetsToSources));
            mnuFromTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromTargetsToBeginning));
            mnuFromTargets.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFromTargetsToEnd));
            JMenu mnuTargetColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actSelectedTargetColumns);
            mnuTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedTargetColumnsToSources));
            mnuTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedTargetColumnsToBeginning));
            mnuTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectedTargetColumnsToEnd));
            JMenu mnuUpdateTargetColumns = WsUIUtilities.createMenu((WsAbstractAction)this.m_actUpdateSelectedTargetColumns);
            mnuUpdateTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedTargetColumnsToSources));
            mnuUpdateTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedTargetColumnsToBeginning));
            mnuUpdateTargetColumns.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actUpdateSelectedTargetColumnsToEnd));
            JMenu mnuPropagate = WsUIUtilities.createMenu((WsAbstractAction)this.m_actPropagate);
            mnuPropagate.add(mnuToTargets);
            mnuPropagate.add(mnuFromTargets);
            mnuPropagate.addSeparator();
            mnuPropagate.add(mnuTargetColumns);
            mnuPropagate.add(mnuUpdateTargetColumns);
            targetTablePopupMenu.add(mnuPropagate);
        }
        JMenu mnuExpressions = WsUIUtilities.createMenu((WsAbstractAction)this.m_actExpression);
        this.addActionToMenu(0, this.m_actChooseColumns, mnuExpressions);
        this.addActionToMenu(1, this.m_actCase, mnuExpressions);
        this.addActionToMenu(2, this.m_actSubquery, mnuExpressions);
        this.addActionToMenu(3, this.m_actAdvanced, mnuExpressions);
        JMenu mnuFixWarning = WsUIUtilities.createMenu((WsAbstractAction)this.m_actFixWarningMenu);
        mnuFixWarning.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFixSourceColumn));
        mnuFixWarning.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFixTargetColumn));
        mnuFixWarning.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actFixExpressionMappings));
        targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapAll));
        targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapSelected));
        targetTablePopupMenu.addSeparator();
        if (this.m_configuration.isTargetTablesEditable()) {
            targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewColumn));
            targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actImportColumns));
            targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMoveUp));
            targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMoveDown));
            targetTablePopupMenu.addSeparator();
        }
        if (this.m_configuration.isExpressionActionsVisible()) {
            targetTablePopupMenu.add(mnuExpressions);
            targetTablePopupMenu.add(mnuFixWarning);
            targetTablePopupMenu.addSeparator();
        }
        targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllTargetColumns));
        if (this.m_configuration.isTargetTablesEditable()) {
            targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteTargetColumns));
            targetTablePopupMenu.addSeparator();
            targetTablePopupMenu.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSaveCurrentTargetColumnOrder));
        }
        return targetTablePopupMenu;
    }

    private void createTargetColumnsViewportPopupMenu() {
        this.m_mnuTargetViewportPopup = new JPopupMenu();
        if (this.m_configuration.isTargetTablesEditable()) {
            this.m_mnuTargetViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewColumn));
            this.m_mnuTargetViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actImportColumns));
            this.m_mnuTargetViewportPopup.addSeparator();
        }
        this.m_mnuTargetViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllTargetColumns));
        if (this.m_configuration.isTargetTablesEditable()) {
            this.m_mnuTargetViewportPopup.addSeparator();
            this.m_mnuTargetViewportPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSaveCurrentTargetColumnOrder));
        }
    }

    private void createTargetPanelLabel() {
        this.m_pnlTargetLabel = WsUIUtilities.createToolBar();
        this.m_pnlTargetLabel.setLayout(new GridBagLayout());
        this.m_btnExpandTargetPanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actExpandTargetPanel);
        this.m_btnCollapseTargetPanel = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCollapseTargetPanel);
        this.m_btnCollapseTargetPanel.setVisible(false);
        if (this.m_configuration.isMultipleTargetTablesEnabled()) {
            this.m_cmbTargetTables = new WAComboBox();
            this.m_cmbTargetTables.addItemListener((ItemListener)new TargetTableSelectionListener());
            this.m_lblTargetTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbTargetTables, (String)this.m_configuration.getTargetTableLabel());
            this.m_pnlTargetLabel.add((Component)this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_cmbTargetTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnExpandTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnCollapseTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.m_lblTargetTable = new JLabel();
            this.m_lblTargetTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_tblTargetColumns, (String)this.m_configuration.getTargetTableLabel());
            this.m_pnlTargetLabel.add((Component)this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_lblTargetTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnExpandTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_pnlTargetLabel.add((Component)this.m_btnCollapseTargetPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private void refreshTargetPanelLabel() {
        if (this.m_configuration.isMultipleTargetTablesEnabled()) {
            ITable tblSelected = this.getSelectedTargetTable();
            this.m_cmbTargetTables.removeAllItems();
            this.m_cmbTargetTables.addItem((Object)bundle.getString("MappingsTab.ComboBoxItem.AllTables.txt"));
            this.m_cmbTargetTables.addItem(WAComboBox.SEPARATOR);
            for (int iTable = 0; iTable < this.m_aTargetTables.length; ++iTable) {
                this.m_cmbTargetTables.addItem((Object)TableUIUtilities.getViewName(this.m_aTargetTables[iTable]));
                if (this.m_aTargetTables[iTable] != tblSelected) continue;
                this.m_cmbTargetTables.setSelectedIndex(iTable + 2);
            }
            if (this.m_aTargetTables.length == 1) {
                this.m_cmbTargetTables.setSelectedIndex(2);
            }
        } else {
            this.m_lblTargetTable.setText(this.m_aTargetTables.length > 0 ? TableUIUtilities.getViewName(this.m_aTargetTables[0]) : "");
            this.setSelectedTargetTable(this.m_aTargetTables.length > 0 ? this.m_aTargetTables[0] : null);
        }
    }

    private void createTargetPanel() {
        this.m_pnlTarget = new JPanel(new BorderLayout());
        this.m_pnlTarget.setBorder(this.m_brdrPanel);
        this.m_pnlTarget.add((Component)this.m_pnlTargetLabel, "North");
        this.m_pnlTarget.add((Component)this.m_scrTargetColumns, "Center");
    }

    private void setTargetColumnsTableEditable(boolean bEditable) {
        if (!this.m_configuration.isTargetTablesEditable()) {
            return;
        }
        for (int iColumn = 0; iColumn < this.m_mdlTargetColumns.getColumnCount(); ++iColumn) {
            if (iColumn == 0 || iColumn == 1 || iColumn == 4) continue;
            this.m_mdlTargetColumns.getColumn(iColumn).setEditable(bEditable);
        }
    }

    private void createMappingsModel() {
        this.m_mdlMappings = new MappingsModel(this.m_container, this.m_mdlSourceColumns, this.m_mdlTargetColumns);
        this.m_mdlMappings.setMappingsFilter(this.m_configuration.getMappingsFilter());
    }

    private void createMappingsPanel() {
        this.m_pnlMappings = new TableMappingsPanel(this.m_tblSourceColumns, this.m_tblTargetColumns, this.m_container);
        this.m_pnlMappings.setMappingsModel((WsObjectListModel)this.m_mdlMappings);
        this.m_pnlMappings.setPreferredSize(new Dimension(50, 200));
        this.m_pnlMappings.setMinimumSize(new Dimension(20, 100));
        this.m_pnlMappings.setBorder(this.m_brdrPanel);
        this.m_pnlMappings.setAutoSelectEnabled(true);
        this.m_pnlMappings.getSelectionModel().addObjectSelectionListener((WsObjectSelectionListener)new MappingsSelectionListener());
        this.m_pnlMappings.setPopupMenuRequestListener(new MappingsPopupListener());
    }

    private void createMappingsPopupMenu() {
        this.m_mnuMappingsPopup = new JPopupMenu();
        this.m_mnuMappingsPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actMapAll));
        this.m_mnuMappingsPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actSelectAllMappings));
        this.m_mnuMappingsPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDeleteMappings));
    }

    private void createCenterPanelLabel() {
        this.m_pnlCenterLabel = new JPanel(new GridBagLayout());
        this.m_pnlCenterLabel.setBorder(this.m_brdrPanel);
        this.m_pnlCenterLabel.setCursor(Cursor.getPredefinedCursor(10));
        CenterPanelLabelMouseListener listener = new CenterPanelLabelMouseListener();
        this.m_pnlCenterLabel.addMouseListener(listener);
        this.m_pnlCenterLabel.addMouseMotionListener(listener);
        JLabel lbl = new JLabel("|||");
        lbl.setForeground(this.m_pnlCenterLabel.getBackground().darker());
        this.m_pnlCenterLabel.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createCenterPanel() {
        this.m_pnlCenter = new JPanel(new BorderLayout());
        this.m_pnlCenter.add((Component)this.m_pnlCenterLabel, "North");
        this.m_pnlCenter.add((Component)((Object)this.m_pnlMappings), "Center");
    }

    private void createPanelBorder() {
        this.m_brdrPanel = BorderFactory.createBevelBorder(1, SystemColor.controlHighlight, SystemColor.controlShadow);
    }

    private JSplitPane createSplitPane(JComponent cmpLeft, JComponent cmpRight) {
        JSplitPane splt = new JSplitPane(1, cmpLeft, cmpRight);
        splt.setContinuousLayout(true);
        splt.setResizeWeight(0.0);
        splt.setBorder(null);
        splt.setDividerSize(splt.getDividerSize() / 2);
        ((BasicSplitPaneUI)splt.getUI()).getDivider().setBorder(null);
        return splt;
    }

    private void layoutComponents() {
        int height = Math.max(this.m_pnlSourceLabel.getPreferredSize().height, this.m_pnlTargetLabel.getPreferredSize().height);
        this.m_pnlSourceLabel.setMinimumSize(new Dimension(50, height));
        this.m_pnlSourceLabel.setPreferredSize(new Dimension(150, height));
        this.m_pnlCenterLabel.setMinimumSize(new Dimension(20, height));
        this.m_pnlCenterLabel.setPreferredSize(new Dimension(50, height));
        this.m_pnlTargetLabel.setMinimumSize(new Dimension(50, height));
        this.m_pnlTargetLabel.setPreferredSize(new Dimension(150, height));
        if (this.m_pnlSetOperatorSpecifics != null) {
            this.setLayout(new GridBagLayout());
            this.add(this.m_pnlSetOperatorSpecifics, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_barTools, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_spltOuter, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(new JPanel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.setLayout(new BorderLayout());
            this.add(this.m_barTools, "North");
            this.add(this.m_spltOuter, "Center");
        }
    }

    public void doLayout() {
        if (!this.m_bSplitLocationSet) {
            int cxMappings;
            int cxTable;
            int cxDeficit;
            Insets insTab = this.getInsets();
            Insets insSource = this.m_pnlSource.getInsets();
            Insets insCenter = this.m_pnlCenter.getInsets();
            Insets insTarget = this.m_pnlTarget.getInsets();
            int cxAvailable = this.getWidth() - insTab.left - insSource.left - insSource.right - this.m_spltInner.getDividerSize() - insCenter.left - insCenter.right - this.m_spltOuter.getDividerSize() - insTarget.left - insTarget.right - insTab.right;
            if (cxAvailable < 120) {
                cxDeficit = (120 - cxAvailable) / 3;
                cxTable = 50 - cxDeficit;
                cxMappings = 20 - cxDeficit;
            } else if (cxAvailable < 320) {
                cxDeficit = (320 - cxAvailable) / 2;
                cxTable = 150 - cxDeficit;
                cxMappings = 20;
            } else if (cxAvailable < 350) {
                cxDeficit = 350 - cxAvailable;
                cxTable = 150;
                cxMappings = 50 - cxDeficit;
            } else {
                int cxExtra = (cxAvailable - 350) / 2;
                cxTable = 150 + cxExtra;
                cxMappings = 50;
            }
            int xInner = cxTable + insSource.left + insSource.right;
            int xOuter = xInner + this.m_spltInner.getDividerSize() + cxMappings + insCenter.left + insCenter.right;
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix();
            this.m_spltOuter.setDividerLocation(appDefaults.getPropertyInt(rootKey + ".OuterLocation.x", xOuter));
            this.m_spltInner.setDividerLocation(appDefaults.getPropertyInt(rootKey + ".InnerLocation.x", xInner));
            this.m_bSplitLocationSet = true;
        }
        super.doLayout();
    }

    private void setSelectedSourceTable(ITable tbl) {
        if (tbl == null) {
            this.m_bSelectedSourceTableEditable = this.allTrue(this.m_aSourceTableEditables);
            this.setSourceColumnsTableEditable(this.m_bSelectedSourceTableEditable);
        }
        if (this.m_tblSelectedSource == tbl) {
            return;
        }
        this.m_tblSourceColumns.cancelCellEditing();
        this.m_tblSelectedSource = tbl;
        this.m_mdlSourceColumns.setSelectedTable(tbl);
        if (tbl != null) {
            int iSourceTable = this.indexOfSourceTable(tbl);
            this.m_bSelectedSourceTableEditable = this.m_aSourceTableEditables[iSourceTable];
            this.setSourceColumnsTableEditable(this.m_bSelectedSourceTableEditable);
        }
        this.m_mdlMappings.moveDataToModel();
    }

    private ITable getSelectedSourceTable() {
        return this.m_tblSelectedSource;
    }

    private void setSelectedTargetTable(ITable tbl) {
        if (tbl == null) {
            this.m_bSelectedTargetTableEditable = this.allTrue(this.m_aTargetTableEditables);
            this.setTargetColumnsTableEditable(this.m_bSelectedTargetTableEditable);
        }
        if (this.m_tblSelectedTarget == tbl) {
            return;
        }
        this.m_tblTargetColumns.cancelCellEditing();
        this.m_tblSelectedTarget = tbl;
        this.m_mdlTargetColumns.setSelectedTable(tbl);
        if (tbl != null) {
            int iTargetTable = this.indexOfTargetTable(tbl);
            this.m_bSelectedTargetTableEditable = this.m_aTargetTableEditables[iTargetTable];
            this.setTargetColumnsTableEditable(this.m_bSelectedTargetTableEditable);
        }
        this.m_mdlMappings.moveDataToModel();
    }

    private ITable getSelectedTargetTable() {
        return this.m_tblSelectedTarget;
    }

    private void setSourcePanelExpanded(boolean bExpanded) {
        if (this.m_bSourcePanelExpanded == bExpanded) {
            return;
        }
        this.m_bSourcePanelExpanded = bExpanded;
        this.m_btnExpandSourcePanel.setVisible(!bExpanded);
        this.m_btnExpandTargetPanel.setVisible(!bExpanded);
        this.m_btnCollapseSourcePanel.setVisible(bExpanded);
        if (bExpanded) {
            this.m_cxInnerOriginal = this.m_spltInner.getDividerLocation();
            this.m_cxOuterOriginal = this.m_spltOuter.getDividerLocation();
            this.m_spltOuter.setDividerLocation(1.0);
            this.m_spltOuter.validate();
            this.m_spltInner.setDividerLocation(1.0);
            this.m_cxDividerSize = this.m_spltInner.getDividerSize();
            this.m_spltInner.setDividerSize(0);
            this.m_spltOuter.setDividerSize(0);
        } else {
            this.m_spltOuter.setDividerLocation(this.m_cxOuterOriginal);
            this.m_spltInner.setDividerLocation(this.m_cxInnerOriginal);
            this.m_spltOuter.setDividerSize(this.m_cxDividerSize);
            this.m_spltInner.setDividerSize(this.m_cxDividerSize);
        }
    }

    private boolean isSourcePanelExpanded() {
        return this.m_bSourcePanelExpanded;
    }

    private void setTargetPanelExpanded(boolean bExpanded) {
        if (this.m_bTargetPanelExpanded == bExpanded) {
            return;
        }
        this.m_bTargetPanelExpanded = bExpanded;
        this.m_btnExpandTargetPanel.setVisible(!bExpanded);
        this.m_btnCollapseTargetPanel.setVisible(bExpanded);
        if (bExpanded) {
            this.m_cxInnerOriginal = this.m_spltInner.getDividerLocation();
            this.m_cxOuterOriginal = this.m_spltOuter.getDividerLocation();
            this.m_spltOuter.setDividerLocation(0.0);
            this.m_spltInner.setDividerLocation(0.0);
            this.m_cxDividerSize = this.m_spltInner.getDividerSize();
            this.m_spltInner.setDividerSize(0);
            this.m_spltOuter.setDividerSize(0);
        } else {
            this.m_spltOuter.setDividerLocation(this.m_cxOuterOriginal);
            this.m_spltInner.setDividerLocation(this.m_cxInnerOriginal);
            this.m_spltOuter.setDividerSize(this.m_cxDividerSize);
            this.m_spltInner.setDividerSize(this.m_cxDividerSize);
        }
    }

    private boolean isTargetPanelExpanded() {
        return this.m_bTargetPanelExpanded;
    }

    private void initializeUndo() {
        if (this.m_lsnrUndo != null) {
            return;
        }
        WsUndoManager mgrUndo = (WsUndoManager)this.m_container.getModel().getUndoManager();
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
    }

    public void moveDataToView() {
        this.m_mdlSourceColumns.moveDataToModel();
        this.m_mdlTargetColumns.moveDataToModel();
        this.m_mdlMappings.moveDataToModel();
        this.m_aSourceTableEditables = this.getTableEditables(this.m_aSourceTables);
        this.m_aTargetTableEditables = this.getTableEditables(this.m_aTargetTables);
        this.refreshSourcePanelLabel();
        this.refreshTargetPanelLabel();
        this.refreshSQLSetOperatorsSpecifics();
        this.updateActions();
        this.initializeUndo();
    }

    private boolean[] getTableEditables(ITable[] aTables) {
        boolean[] aEditables = new boolean[aTables.length];
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            aEditables[iTable] = aTables[iTable] instanceof IWorkTable ? this.m_mdlJob.isEditable() : (aTables[iTable] instanceof IExternalTable && ((IExternalTable)aTables[iTable]).isFixedWidth() ? false : Workspace.isObjectEditable((SimpleObject)aTables[iTable]));
        }
        return aEditables;
    }

    public boolean validateData() {
        if (!this.stopCellEditing()) {
            return false;
        }
        return this.validateSourceColumns() && this.validateTargetColumns();
    }

    private boolean validateSourceColumns() {
        int iViewInformatColumn = this.m_tblSourceColumns.convertColumnIndexToView(6);
        int iViewFormatColumn = this.m_tblSourceColumns.convertColumnIndexToView(7);
        for (int iRow = 0; iRow < this.m_tblSourceColumns.getRowCount(); ++iRow) {
            int iModelRow = this.m_tblSourceColumns.convertRowIndexToModel(iRow);
            String sType = this.m_mdlSourceColumns.getSourceColumn(iModelRow).getType() == 0 ? WsColumnMetadataUtil.getDataCharacterType() : WsColumnMetadataUtil.getDataNumericType();
            String sInformat = (String)this.m_mdlSourceColumns.getValueAt(iModelRow, 6);
            if (!sInformat.equals(WsColumnMetadataUtil.NONE) && !WsColumnMetadataUtil.isInformatNameValid((String)sInformat, (String)sType)) {
                String sMessage = bundle.getString("MappingsTab.Error.InvalidInformat.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                if (iViewFormatColumn != -1) {
                    this.m_tblSourceColumns.selectCell(iRow, iViewInformatColumn);
                    this.m_tblSourceColumns.editCellAt(iRow, iViewInformatColumn);
                }
                return false;
            }
            String sFormat = (String)this.m_mdlSourceColumns.getValueAt(iModelRow, 7);
            if (sFormat.equals(WsColumnMetadataUtil.NONE) || WsColumnMetadataUtil.isFormatNameValid((String)sFormat, (String)sType)) continue;
            String sMessage = bundle.getString("MappingsTab.Error.InvalidFormat.txt");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            if (iViewFormatColumn != -1) {
                this.m_tblSourceColumns.selectCell(iRow, iViewFormatColumn);
                this.m_tblSourceColumns.editCellAt(iRow, iViewFormatColumn);
            }
            return false;
        }
        return true;
    }

    private boolean validateTargetColumns() {
        int iViewInformatColumn = this.m_tblTargetColumns.convertColumnIndexToView(9);
        int iViewFormatColumn = this.m_tblTargetColumns.convertColumnIndexToView(10);
        for (int iRow = 0; iRow < this.m_tblTargetColumns.getRowCount(); ++iRow) {
            int iModelRow = this.m_tblTargetColumns.convertRowIndexToModel(iRow);
            String sType = this.m_mdlTargetColumns.getTargetColumn(iModelRow).getType() == 0 ? WsColumnMetadataUtil.getDataCharacterType() : WsColumnMetadataUtil.getDataNumericType();
            String sInformat = (String)this.m_mdlTargetColumns.getValueAt(iModelRow, 9);
            if (!sInformat.equals(WsColumnMetadataUtil.NONE) && !WsColumnMetadataUtil.isInformatNameValid((String)sInformat, (String)sType)) {
                String sMessage = bundle.getString("MappingsTab.Error.InvalidInformat.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                if (iViewFormatColumn != -1) {
                    this.m_tblTargetColumns.selectCell(iRow, iViewInformatColumn);
                    this.m_tblTargetColumns.editCellAt(iRow, iViewInformatColumn);
                }
                return false;
            }
            String sFormat = (String)this.m_mdlTargetColumns.getValueAt(iModelRow, 10);
            if (sFormat.equals(WsColumnMetadataUtil.NONE) || WsColumnMetadataUtil.isFormatNameValid((String)sFormat, (String)sType)) continue;
            String sMessage = bundle.getString("MappingsTab.Error.InvalidFormat.txt");
            MessageUtil.displayMessage((String)sMessage, (int)0);
            if (iViewFormatColumn != -1) {
                this.m_tblTargetColumns.selectCell(iRow, iViewFormatColumn);
                this.m_tblTargetColumns.editCellAt(iRow, iViewFormatColumn);
            }
            return false;
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        String rootKey = this.m_configuration.getSettingsKeyPrefix() + "." + this.m_configuration.getWhereUsedSettingsKeyPrefix() + ".";
        this.m_tblSourceColumns.saveSettings(rootKey + this.m_configuration.getSourceTableSettingsKeyPrefix());
        this.m_tblTargetColumns.saveSettings(rootKey + this.m_configuration.getTargetTableSettingsKeyPrefix());
        boolean bUseSavedValues = this.isSourcePanelExpanded() || this.isTargetPanelExpanded();
        int xOuter = bUseSavedValues ? this.m_cxOuterOriginal : this.m_spltOuter.getDividerLocation();
        int xInner = bUseSavedValues ? this.m_cxInnerOriginal : this.m_spltInner.getDividerLocation();
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.setPropertyInt(rootKey + "OuterLocation.x", xOuter);
        appDefaults.setPropertyInt(rootKey + "InnerLocation.x", xInner);
        this.m_mdlSourceColumns.dispose();
        this.m_mdlTargetColumns.dispose();
        this.m_mdlMappings.dispose();
        IModel mdl = this.m_container.getModel();
        ((WsUndoManager)mdl.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        mdl.removeModelListener((IModelListener)this.m_lsnrModel);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlMappings.setDraggingFromSourceTableEnabled(bEditable);
        this.m_pnlMappings.setDraggingFromTargetTableEnabled(bEditable);
        this.m_tblSourceColumns.setEditable(bEditable);
        this.m_tblTargetColumns.setEditable(bEditable);
        this.updateActions();
    }

    private void updateActions() {
        int iRow;
        IMapping mapping;
        boolean bEditable = this.isEditable();
        boolean bSourceNotSorted = !this.m_tblSourceColumns.isSorted();
        boolean bTargetNotSorted = !this.m_tblTargetColumns.isSorted();
        boolean bOneSourceTable = this.getSelectedSourceTable() != null;
        boolean bOneTargetTable = this.getSelectedTargetTable() != null;
        boolean bAtLeastOneSourceTable = this.m_aSourceTables.length > 0;
        boolean bAtLeastOneTargetTable = this.m_aTargetTables.length > 0;
        boolean bSourceTablesEditable = bAtLeastOneSourceTable && this.m_bSelectedSourceTableEditable;
        boolean bTargetTablesEditable = bAtLeastOneTargetTable && this.m_bSelectedTargetTableEditable;
        int[] aSourceRows = this.m_tblSourceColumns.getSelectedRowsFromSelectedCells();
        int[] aTargetRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
        List lMappings = this.m_pnlMappings.getSelectedMappings();
        boolean bAtLeastOneSourceColumn = aSourceRows.length > 0;
        boolean bAtLeastOneTargetColumn = aTargetRows.length > 0;
        boolean bAtLeastOneMapping = lMappings.size() > 0;
        boolean bOneTargetColumn = aTargetRows.length == 1;
        boolean bFirstTargetColumn = bAtLeastOneTargetColumn && aTargetRows[0] == 0;
        boolean bLastTargetColumn = bAtLeastOneTargetColumn && aTargetRows[aTargetRows.length - 1] == this.m_tblTargetColumns.getRowCount() - 1;
        boolean bAnyIncludedInPropagation = false;
        boolean bAnyIncludedInMapping = false;
        for (int iTargetRow = 0; iTargetRow < aTargetRows.length; ++iTargetRow) {
            int iModelRow = this.m_tblTargetColumns.convertRowIndexToModel(aTargetRows[iTargetRow]);
            IColumn column = this.m_mdlTargetColumns.getTargetColumn(iModelRow);
            if (!this.m_container.getListOfColumnsExcludedFromPropagation().contains(column)) {
                bAnyIncludedInPropagation = true;
            }
            if (!this.m_container.getListOfColumnsExcludedFromMapping().contains(column)) {
                bAnyIncludedInMapping = true;
            }
            if (bAnyIncludedInMapping && bAnyIncludedInPropagation) break;
        }
        this.m_actToTargetsFromSources.setEnabled(bEditable && bAtLeastOneSourceTable && bTargetTablesEditable);
        this.m_actToTargetsFromBeginning.setEnabled(bEditable && bSourceTablesEditable && bTargetTablesEditable);
        this.m_actToTargetsFromEnd.setEnabled(bEditable && bTargetTablesEditable);
        this.m_actToSourcesFromTargets.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetTable);
        this.m_actToSourcesFromBeginning.setEnabled(bEditable && bSourceTablesEditable);
        this.m_actToSourcesFromEnd.setEnabled(bEditable && bSourceTablesEditable && bTargetTablesEditable);
        this.m_actFromTargetsToSources.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetTable);
        this.m_actFromTargetsToBeginning.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetTable);
        this.m_actFromTargetsToEnd.setEnabled(bEditable && bAtLeastOneTargetTable);
        this.m_actFromSourcesToTargets.setEnabled(bEditable && bAtLeastOneSourceTable && bTargetTablesEditable);
        this.m_actFromSourcesToBeginning.setEnabled(bEditable && bAtLeastOneSourceTable);
        this.m_actFromSourcesToEnd.setEnabled(bEditable && bAtLeastOneSourceTable && bTargetTablesEditable);
        this.m_actSelectedTargetColumnsToSources.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetColumn);
        this.m_actSelectedTargetColumnsToBeginning.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetColumn);
        this.m_actSelectedTargetColumnsToEnd.setEnabled(bEditable && bAtLeastOneTargetColumn);
        this.m_actSelectedSourceColumnsToTargets.setEnabled(bEditable && bAtLeastOneSourceColumn && bTargetTablesEditable);
        this.m_actSelectedSourceColumnsToBeginning.setEnabled(bEditable && bAtLeastOneSourceColumn);
        this.m_actSelectedSourceColumnsToEnd.setEnabled(bEditable && bAtLeastOneSourceColumn && bTargetTablesEditable);
        this.m_actUpdateSelectedTargetColumnsToSources.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetColumn);
        this.m_actUpdateSelectedTargetColumnsToBeginning.setEnabled(bEditable && bSourceTablesEditable && bAtLeastOneTargetColumn);
        this.m_actUpdateSelectedTargetColumnsToEnd.setEnabled(bEditable && bAtLeastOneTargetColumn);
        this.m_actUpdateSelectedSourceColumnsToTargets.setEnabled(bEditable && bAtLeastOneSourceColumn && bTargetTablesEditable);
        this.m_actUpdateSelectedSourceColumnsToBeginning.setEnabled(bEditable && bAtLeastOneSourceColumn);
        this.m_actUpdateSelectedSourceColumnsToEnd.setEnabled(bEditable && bAtLeastOneSourceColumn && bTargetTablesEditable);
        this.m_actMapAll.setEnabled(bEditable && bAtLeastOneSourceTable && bAtLeastOneTargetTable);
        this.m_actMapSelected.setEnabled(bEditable && bAtLeastOneSourceColumn && bOneTargetColumn);
        this.m_actIncludeTransformationInPropagation.setEnabled(bEditable);
        this.m_actIncludeTransformationInMapping.setEnabled(bEditable);
        this.m_actIncludeTransformationInPropagation.setSelected(this.m_container.isIncludedInPropagation());
        this.m_actIncludeTransformationInMapping.setSelected(this.m_container.isIncludedInMapping());
        this.m_actIncludeColumnsInPropagation.setEnabled(bEditable && bAtLeastOneTargetColumn);
        this.m_actIncludeColumnsInMapping.setEnabled(bEditable && bAtLeastOneTargetColumn);
        this.m_actIncludeColumnsInPropagation.setSelected(bEditable && bAnyIncludedInPropagation);
        this.m_actIncludeColumnsInMapping.setSelected(bEditable && bAnyIncludedInMapping);
        this.m_actSaveCurrentSourceColumnOrder.setEnabled(bEditable && bOneSourceTable && bSourceTablesEditable && !bSourceNotSorted);
        this.m_actNewColumn.setEnabled(bEditable && bOneTargetTable && bTargetTablesEditable && bTargetNotSorted);
        this.m_actImportColumns.setEnabled(bEditable && bOneTargetTable && bTargetTablesEditable && bTargetNotSorted);
        this.m_actExpressionDropMenu.setEnabled(bEditable);
        this.m_actChooseColumns.setEnabled(bEditable && bOneTargetColumn);
        this.m_actCase.setEnabled(bEditable && bOneTargetColumn);
        this.m_actSubquery.setEnabled(bEditable && bOneTargetColumn);
        this.m_actAdvanced.setEnabled(bEditable && bOneTargetColumn);
        this.m_actSaveCurrentTargetColumnOrder.setEnabled(bEditable && bOneTargetTable && bTargetTablesEditable && !bTargetNotSorted);
        this.m_actMoveUp.setEnabled(bEditable && bOneTargetTable && bTargetTablesEditable && bAtLeastOneTargetColumn && bTargetNotSorted && !bFirstTargetColumn);
        this.m_actMoveDown.setEnabled(bEditable && bOneTargetTable && bTargetTablesEditable && bAtLeastOneTargetColumn && bTargetNotSorted && !bLastTargetColumn);
        boolean bOneToOneWarning = false;
        boolean bExpressionWarning = false;
        if (bOneTargetColumn && (mapping = this.m_mdlTargetColumns.getMapping(iRow = this.m_tblTargetColumns.convertRowIndexToModel(aTargetRows[0]))) != null && mapping.hasWarnings()) {
            if (mapping.getType().equals("ONETOONE")) {
                bOneToOneWarning = true;
            } else if (mapping.getType().equals("DERIVED")) {
                if (mapping.getExpression() == null) {
                    bOneToOneWarning = true;
                } else {
                    bExpressionWarning = true;
                }
            }
        }
        this.m_actFixWarningDropMenu.setEnabled(bEditable);
        this.m_actFixSourceColumn.setEnabled(bEditable && bOneTargetColumn && bSourceTablesEditable && bOneToOneWarning);
        this.m_actFixTargetColumn.setEnabled(bEditable && bOneTargetColumn && bTargetTablesEditable && bOneToOneWarning);
        this.m_actFixExpressionMappings.setEnabled(bEditable && bOneTargetColumn && bExpressionWarning);
        this.m_actDeleteSourceColumns.setEnabled(bEditable && this.m_configuration.isSourceTablesEditable() && bSourceTablesEditable && bAtLeastOneSourceColumn);
        this.m_actDeleteTargetColumns.setEnabled(bEditable && this.m_configuration.isTargetTablesEditable() && bTargetTablesEditable && bAtLeastOneTargetColumn);
        this.m_actDeleteMappings.setEnabled(bEditable && bAtLeastOneMapping);
        this.m_actSelectAllMappings.setEnabled(this.m_pnlMappings.getMappingsCount() > 0);
        this.m_actSelectAllSourceColumns.setEnabled(this.m_tblSourceColumns.getRowCount() > 0);
        this.m_actSelectAllTargetColumns.setEnabled(this.m_tblTargetColumns.getRowCount() > 0);
        this.m_tblSourceColumns.setRowsReorderable(bEditable && this.m_configuration.isSourceTablesEditable() && bOneSourceTable && bSourceTablesEditable && bSourceNotSorted);
        this.m_tblTargetColumns.setRowsReorderable(bEditable && this.m_configuration.isTargetTablesEditable() && bOneTargetTable && bTargetTablesEditable && bTargetNotSorted);
        this.m_actAllFields.setEnabled(bEditable);
        this.m_actDistinctRows.setEnabled(bEditable);
    }

    private void propagateToTargetsFromSources() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToTargets(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateToTargetsFromBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromBeginningToTargets(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateToTargetsFromEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromEndToTargets(this.m_container, this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateToSourcesFromTargets() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToSources(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateToSourcesFromBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromBeginningToSources(this.m_container, this.getSelectedSourceTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateToSourcesFromEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromEndToSources(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateFromTargetsToSources() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToSources(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateFromTargetsToBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToBeginning(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateFromTargetsToEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToEnd(this.m_container, this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateFromSourcesToTargets() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToTargets(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateFromSourcesToBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToBeginning(this.m_container, this.getSelectedSourceTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateFromSourcesToEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToEnd(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateSelectedTargetColumnsToSources() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToSources(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateSelectedTargetColumnsToBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToBeginning(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateSelectedTargetColumnsToEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromTargetsToEnd(this.m_container, this.getSelectedTargetTables(), this.getSelectedTargetColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateSelectedSourceColumnsToTargets() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToTargets(this.m_container, this.getSelectedSourceColumns(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateSelectedSourceColumnsToBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToBeginning(this.m_container, this.getSelectedSourceTables(), this.getSelectedSourceColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void propagateSelectedSourceColumnsToEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.propagateFromSourcesToEnd(this.m_container, this.getSelectedSourceColumns(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void updateSelectedTargetColumnsToSources() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.updateMappedColumnsFromTargetsToSources(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void updateSelectedTargetColumnsToBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.updateMappedColumnsFromTargetsToBeginning(this.m_container, this.getSelectedSourceTables(), this.getSelectedTargetColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void updateSelectedTargetColumnsToEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.updateMappedColumnsFromTargetsToEnd(this.m_container, this.getSelectedTargetTables(), this.getSelectedTargetColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void updateSelectedSourceColumnsToTargets() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.updateMappedColumnsFromSourcesToTargets(this.m_container, this.getSelectedSourceColumns(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void updateSelectedSourceColumnsToBeginning() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.updateMappedColumnsFromSourcesToBeginning(this.m_container, this.getSelectedSourceTables(), this.getSelectedSourceColumns());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void updateSelectedSourceColumnsToEnd() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        try {
            this.m_mdlJob.updateMappedColumnsFromSourcesToEnd(this.m_container, this.getSelectedSourceColumns(), this.getSelectedTargetTables());
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPairingsBetweenSelectedColumns() {
        int iTargetRow = this.m_tblTargetColumns.convertRowIndexToModel(this.m_tblTargetColumns.getSelectedRowsFromSelectedCells()[0]);
        int[] aSourceRows = this.m_tblSourceColumns.getSelectedRowsFromSelectedCells();
        this.m_container.getModel().startCompoundUndoable();
        try {
            ArrayList<WsMapping> lPairings = new ArrayList<WsMapping>(aSourceRows.length);
            for (int iSourceRow = 0; iSourceRow < aSourceRows.length; ++iSourceRow) {
                lPairings.add(new WsMapping(this.m_tblSourceColumns.convertRowIndexToModel(aSourceRows[iSourceRow]), iTargetRow));
            }
            this.m_pnlMappings.onCreateMappings(lPairings);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapColumns() {
        this.m_container.getModel().startCompoundUndoable();
        this.setWaitCursor(true);
        try {
            ITable[] aSourceTables = this.getSelectedSourceTables();
            ITable[] aTargetTables = this.getSelectedTargetTables();
            for (int iSourceTable = 0; iSourceTable < aSourceTables.length; ++iSourceTable) {
                for (int iTargetTable = 0; iTargetTable < aTargetTables.length; ++iTargetTable) {
                    this.m_container.mapColumns(aSourceTables[iSourceTable], aTargetTables[iTargetTable]);
                }
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
            this.setWaitCursor(false);
        }
    }

    private void selectAllMappings() {
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_pnlMappings.selectAllMappings();
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectedColumnsToExcludeFromPropagation() {
        this.m_container.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            this.m_tblTargetColumns.convertRowIndexesToModel(aRows);
            ArrayList<IColumn> lChangedColumns = new ArrayList<IColumn>();
            List lExcludedColumns = this.m_container.getListOfColumnsExcludedFromPropagation();
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                IColumn column = this.m_mdlTargetColumns.getTargetColumn(aRows[iRow]);
                if (lExcludedColumns.contains(column)) continue;
                lExcludedColumns.add(column);
                lChangedColumns.add(column);
            }
            IColumn[] aChangedColumns = lChangedColumns.toArray(new IColumn[lChangedColumns.size()]);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aChangedColumns, true, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedColumnsFromExcludeFromPropagation() {
        this.m_container.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            this.m_tblTargetColumns.convertRowIndexesToModel(aRows);
            ArrayList<IColumn> lChangedColumns = new ArrayList<IColumn>();
            List lExcludedColumns = this.m_container.getListOfColumnsExcludedFromPropagation();
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                IColumn column = this.m_mdlTargetColumns.getTargetColumn(aRows[iRow]);
                if (!lExcludedColumns.contains(column)) continue;
                lExcludedColumns.remove(column);
                lChangedColumns.add(column);
            }
            IColumn[] aChangedColumns = lChangedColumns.toArray(new IColumn[lChangedColumns.size()]);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aChangedColumns, true, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectedColumnsToExcludeFromMapping() {
        this.m_container.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            this.m_tblTargetColumns.convertRowIndexesToModel(aRows);
            ArrayList<IColumn> lChangedColumns = new ArrayList<IColumn>();
            List lExcludedColumns = this.m_container.getListOfColumnsExcludedFromMapping();
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                IColumn column = this.m_mdlTargetColumns.getTargetColumn(aRows[iRow]);
                if (lExcludedColumns.contains(column)) continue;
                lExcludedColumns.add(column);
                lChangedColumns.add(column);
            }
            IColumn[] aChangedColumns = lChangedColumns.toArray(new IColumn[lChangedColumns.size()]);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aChangedColumns, true, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedColumnsFromExcludeFromMapping() {
        this.m_container.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            this.m_tblTargetColumns.convertRowIndexesToModel(aRows);
            ArrayList<IColumn> lChangedColumns = new ArrayList<IColumn>();
            List lExcludedColumns = this.m_container.getListOfColumnsExcludedFromMapping();
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                IColumn column = this.m_mdlTargetColumns.getTargetColumn(aRows[iRow]);
                if (!lExcludedColumns.contains(column)) continue;
                lExcludedColumns.remove(column);
                lChangedColumns.add(column);
            }
            IColumn[] aChangedColumns = lChangedColumns.toArray(new IColumn[lChangedColumns.size()]);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aChangedColumns, true, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewTargetColumn() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            ITable tbl = this.getSelectedTargetTable();
            int iRow = this.m_tblTargetColumns.getLastSelectedRow();
            int iColumn = iRow == -1 ? tbl.getColumnCount() - 1 : tbl.indexOfColumn(this.m_mdlTargetColumns.getTargetColumn(iRow));
            this.m_tblTargetColumns.clearSelection();
            IColumn colNew = this.m_container.getModel().getObjectFactory().createNewColumn(tbl.getID());
            colNew.setName(this.m_mdlTargetColumns.createUniqueNameForNewColumn());
            tbl.addColumn(iColumn + 1, colNew);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(colNew, false, true));
            this.m_tblTargetColumns.selectRow(iRow + 1);
            int iEditColumn = this.m_tblTargetColumns.convertColumnIndexToView(this.m_mdlTargetColumns.getDefaultEditColumnIndex());
            this.m_tblTargetColumns.editCellAt(iRow + 1, iEditColumn);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] showColumnsSelectionDialog() throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ImportColumns");
        try {
            ObjectsSelectorPanel pnl = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 4);
            String sImportDialogTitle = bundle.getString("MappingsTab.ImportColumns.Title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.setHelpProduct("shared");
            dlg.setHelpTopic("import_column_win");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject[] aColumns = pnl.getSelectedObjects();
                String[] aIDs = new String[aColumns.length];
                for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    aIDs[iColumn] = aColumns[iColumn].getID();
                }
                String[] stringArray = aIDs;
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            store.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IColumn[] loadColumns(IModel mdl, String[] aIDs) throws RemoteException, MdException {
        OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), "LoadImportedColumns");
        try {
            IColumn[] aColumns = new IColumn[aIDs.length];
            for (int iID = 0; iID < aIDs.length; ++iID) {
                Column mdoColumn = (Column)omr.acquireOMRObject(aIDs[iID], "Column");
                aColumns[iID] = (IColumn)omr.acquireObjectUsingTemplate((Root)mdoColumn);
            }
            IColumn[] iColumnArray = aColumns;
            return iColumnArray;
        }
        finally {
            omr.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importColumns() {
        if (!this.stopCellEditing()) {
            return;
        }
        try {
            String[] aIDs = this.showColumnsSelectionDialog();
            if (aIDs == null) {
                return;
            }
            BaseModel mdl = new BaseModel();
            try {
                IColumn[] aColumns = this.loadColumns((IModel)mdl, aIDs);
                this.addCopyOfColumns(aColumns);
            }
            finally {
                mdl.dispose();
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCopyOfColumns(IColumn[] aColumns) {
        ITable tblSelected = this.getSelectedTargetTable();
        ArrayList<String> lDuplicateColumns = new ArrayList<String>();
        ArrayList<IColumn> lAddedColumns = new ArrayList<IColumn>();
        IColumn[] aOriginalColumns = tblSelected.getColumns();
        int iRow = this.m_tblTargetColumns.getLastSelectedRow();
        int iStart = iRow == -1 ? tblSelected.getColumnCount() : tblSelected.indexOfColumn(this.m_mdlTargetColumns.getTargetColumn(iRow)) + 1;
        this.m_tblTargetColumns.clearSelection();
        tblSelected.getModel().startCompoundUndoable();
        try {
            int iInsert = iStart;
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                IColumn column = aColumns[iColumn];
                if (this.isColumnNameUnique(column.getName(), aOriginalColumns)) {
                    IColumn columnNew = tblSelected.getModel().getObjectFactory().createNewColumn(tblSelected.getID());
                    column.deepCopy(columnNew);
                    tblSelected.addColumn(iInsert++, columnNew);
                    lAddedColumns.add(columnNew);
                    continue;
                }
                lDuplicateColumns.add(column.getName());
            }
            if (!lAddedColumns.isEmpty()) {
                IColumn[] aAddedColumns = lAddedColumns.toArray(new IColumn[lAddedColumns.size()]);
                this.selectTargetColumns(aAddedColumns);
                this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aAddedColumns, false, true));
            }
            if (!lDuplicateColumns.isEmpty()) {
                String sMessage = bundle.getString("MappingsTab.Warning.DuplicateColumnsRemoved.txt");
                MessageUtil.displayListMessage((String)sMessage, lDuplicateColumns);
            }
        }
        finally {
            tblSelected.getModel().endCompoundUndoable();
        }
    }

    private boolean isColumnNameUnique(String sTestName, IColumn[] aColumns) {
        boolean bCaseSensitive = this.getSelectedTargetTable().isCaseSensitive();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            boolean bEquals;
            String sColumnName = aColumns[iColumn].getName();
            boolean bl = bEquals = bCaseSensitive ? sTestName.equals(sColumnName) : sTestName.equalsIgnoreCase(sColumnName);
            if (!bEquals) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSourceColumn(int iFrom, int iTo) {
        if (!this.stopCellEditing()) {
            return;
        }
        ITable table = this.getSelectedSourceTable();
        table.getModel().startCompoundUndoable();
        try {
            this.m_tblSourceColumns.clearSelection();
            IColumn column = this.m_mdlSourceColumns.getSourceColumn(iFrom);
            table.getModel().undoableEditHappened((UndoableEdit)new SelectSourceColumnsUndoable(column, true, false));
            table.moveColumn(column, iTo);
            this.m_tblSourceColumns.selectRow(iTo);
            table.getModel().undoableEditHappened((UndoableEdit)new SelectSourceColumnsUndoable(column, false, true));
        }
        finally {
            table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTargetColumn(int iFrom, int iTo) {
        if (!this.stopCellEditing()) {
            return;
        }
        ITable table = this.getSelectedTargetTable();
        table.getModel().startCompoundUndoable();
        try {
            this.m_tblTargetColumns.clearSelection();
            IColumn column = this.m_mdlTargetColumns.getTargetColumn(iFrom);
            table.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(column, true, false));
            table.moveColumn(column, iTo);
            this.m_tblTargetColumns.selectRow(iTo);
            table.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(column, false, true));
        }
        finally {
            table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedTargetColumns(int eDir) {
        if (eDir != 0 && eDir != 1) {
            throw new IllegalArgumentException("Direction must be UP or DOWN but is: " + eDir);
        }
        if (!this.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        this.setWaitCursor(true);
        try {
            int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            IColumn[] aColumns = new IColumn[aRows.length];
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                aColumns[iRow] = this.m_mdlTargetColumns.getTargetColumn(aRows[iRow]);
            }
            this.m_tblTargetColumns.clearSelection();
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aColumns, true, false));
            ITable table = this.getSelectedTargetTable();
            if (eDir == 1) {
                for (int iRow = aRows.length - 1; iRow >= 0; --iRow) {
                    table.moveColumn(aColumns[iRow], aRows[iRow] + 1);
                }
            } else {
                for (int iRow = 0; iRow < aRows.length; ++iRow) {
                    table.moveColumn(aColumns[iRow], aRows[iRow] - 1);
                }
            }
            this.selectTargetColumns(aColumns);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aColumns, false, true));
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
            this.setWaitCursor(false);
        }
    }

    private void saveCurrentSourceColumnOrder() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            IColumn[] aColumns = new IColumn[this.m_tblSourceColumns.getRowCount()];
            for (int iViewRow = 0; iViewRow < this.m_tblSourceColumns.getRowCount(); ++iViewRow) {
                aColumns[iViewRow] = this.m_mdlSourceColumns.getSourceColumn(this.m_tblSourceColumns.convertRowIndexToModel(iViewRow));
            }
            this.m_tblSourceColumns.resetToOriginalOrder();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.getSelectedSourceTable().moveColumn(aColumns[iColumn], iColumn);
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    private void saveCurrentTargetColumnOrder() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.m_container.getModel().startCompoundUndoable();
        try {
            IColumn[] aColumns = new IColumn[this.m_tblTargetColumns.getRowCount()];
            for (int iViewRow = 0; iViewRow < this.m_tblTargetColumns.getRowCount(); ++iViewRow) {
                aColumns[iViewRow] = this.m_mdlTargetColumns.getTargetColumn(this.m_tblTargetColumns.convertRowIndexToModel(iViewRow));
            }
            this.m_tblTargetColumns.resetToOriginalOrder();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                this.getSelectedTargetTable().moveColumn(aColumns[iColumn], iColumn);
            }
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedSourceColumns() {
        int iRow;
        if (!this.stopCellEditing()) {
            return;
        }
        int[] aRows = this.m_tblSourceColumns.getSelectedRowsFromSelectedCells();
        IColumn[] aColumns = new IColumn[aRows.length];
        for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
            ITable table;
            int iModelRow = this.m_tblSourceColumns.convertRowIndexToModel(aRows[iRow]);
            aColumns[iRow] = this.m_mdlSourceColumns.getSourceColumn(iModelRow);
            if (aColumns[iRow] instanceof IReflectiveObject) {
                aColumns[iRow] = (IColumn)((IReflectiveObject)aColumns[iRow]).getOMRObject();
            }
            if (!((table = aColumns[iRow].getTable()) instanceof IPhysicalTable) || !((IPhysicalTable)table).isColumnUsedInConstraint(aColumns[iRow])) continue;
            String sMessage = bundle.formatString("MappingsTab.Error.DeleteColumnInConstraint.txt", (Object)aColumns[iRow].getName());
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return;
        }
        this.m_tblSourceColumns.clearSelection();
        this.setWaitCursor(true);
        this.m_container.getModel().startCompoundUndoable();
        try {
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectSourceColumnsUndoable(aColumns, true, false));
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                IColumn column = aColumns[iColumn];
                column.getTable().removeColumn(column);
            }
            this.m_container.getModel().undoableEditHappened(this.m_tblSourceColumns.createClearSelectionUndoable(true, true));
        }
        finally {
            this.setWaitCursor(false);
            this.m_container.getModel().endCompoundUndoable();
        }
        iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_tblSourceColumns.getRowCount() - 1);
        if (iRow >= 0) {
            this.m_tblSourceColumns.selectRow(iRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedTargetColumns() {
        int iRow;
        if (!this.stopCellEditing()) {
            return;
        }
        int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
        IColumn[] aColumns = new IColumn[aRows.length];
        for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
            ITable table;
            int iModelRow = this.m_tblTargetColumns.convertRowIndexToModel(aRows[iRow]);
            aColumns[iRow] = this.m_mdlTargetColumns.getTargetColumn(iModelRow);
            if (aColumns[iRow] instanceof IReflectiveObject) {
                aColumns[iRow] = (IColumn)((IReflectiveObject)aColumns[iRow]).getOMRObject();
            }
            if (!((table = aColumns[iRow].getTable()) instanceof IPhysicalTable) || !((IPhysicalTable)table).isColumnUsedInConstraint(aColumns[iRow])) continue;
            String sMessage = bundle.formatString("MappingsTab.Error.DeleteColumnInConstraint.txt", (Object)aColumns[iRow].getName());
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return;
        }
        this.m_tblTargetColumns.clearSelection();
        this.setWaitCursor(true);
        this.m_container.getModel().startCompoundUndoable();
        try {
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectTargetColumnsUndoable(aColumns, true, false));
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                IColumn column = aColumns[iColumn];
                column.getTable().removeColumn(column);
            }
            this.m_container.getModel().undoableEditHappened(this.m_tblTargetColumns.createClearSelectionUndoable(true, true));
        }
        finally {
            this.setWaitCursor(false);
            this.m_container.getModel().endCompoundUndoable();
        }
        iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_tblTargetColumns.getRowCount() - 1);
        if (iRow >= 0) {
            this.m_tblTargetColumns.selectRow(iRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSelectedPairings() {
        if (!this.stopCellEditing()) {
            return;
        }
        this.setWaitCursor(true);
        this.m_container.getModel().startCompoundUndoable();
        try {
            List lMappings = this.m_pnlMappings.getSelectedMappings();
            this.m_pnlMappings.deselectAllMappings();
            WsMapping[] aMappings = lMappings.toArray(new WsMapping[lMappings.size()]);
            this.m_container.getModel().undoableEditHappened((UndoableEdit)new SelectPairingsUndoable(aMappings, true, false));
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                WsMapping pairing = aMappings[iMapping];
                IColumn colSource = this.m_mdlSourceColumns.getSourceColumn(pairing.getSource());
                IMapping mapping = this.m_mdlTargetColumns.getMapping(pairing.getTarget());
                mapping.removeSource(colSource);
            }
        }
        finally {
            this.setWaitCursor(false);
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    public void fireNavigationEvent(NavigationEvent ev) {
        if (!this.m_bSQLNavigateEventsEnabled) {
            return;
        }
        if (this.m_lSQLNavigateListeners == null) {
            return;
        }
        this.fireNavigationEventImpl(ev);
    }

    public void fireNavigationEvent(IObject modelObject) {
        this.fireNavigationEvent(new NavigationEvent((Object)this, modelObject));
    }

    private void fireNavigationEventImpl(NavigationEvent ev) {
        this.logNavigationEvent(ev);
        for (int iListener = 0; iListener < this.m_lSQLNavigateListeners.size(); ++iListener) {
            ((INavigationListener)this.m_lSQLNavigateListeners.get(iListener)).navigationChanged(ev);
        }
    }

    private void logNavigationEvent(NavigationEvent ev) {
        String sObject = ev.getModelObject() != null ? ev.getModelObject().toString() : "model";
        ModelLogger.getDefaultLogger().debug((Object)("NavigationEvent:for " + sObject));
    }

    public void addSQLNavigationListener(INavigationListener lsnr) {
        if (this.m_lSQLNavigateListeners == null) {
            this.m_lSQLNavigateListeners = new ArrayList();
        }
        this.m_lSQLNavigateListeners.add(lsnr);
    }

    public void removeSQLNavigationListener(INavigationListener lsnr) {
        if (this.m_lSQLNavigateListeners != null) {
            this.m_lSQLNavigateListeners.remove(lsnr);
        }
    }

    private void undo() {
        this.setWaitCursor(true);
        try {
            this.m_container.getModel().getUndoManager().undo();
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void redo() {
        this.setWaitCursor(true);
        try {
            this.m_container.getModel().getUndoManager().redo();
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    private void showExpressionBuilderDialog() {
        String sExpression;
        int iRow = this.m_tblTargetColumns.convertRowIndexToModel(this.m_tblTargetColumns.getSelectedRowsFromSelectedCells()[0]);
        String sNewExpression = this.showExpressionBuilderDialog(iRow, sExpression = this.m_mdlTargetColumns.getExpressionText(iRow));
        if (sNewExpression != null) {
            this.m_mdlTargetColumns.setExpressionText(iRow, sNewExpression);
        }
    }

    private String showExpressionBuilderDialog(int iRow, String sExpression) {
        IMapping mapping = this.m_mdlTargetColumns.getMapping(iRow);
        IColumn[] aSourceColumns = mapping != null ? mapping.getSources() : new IColumn[]{};
        IColumn targetColumn = this.m_mdlTargetColumns.getTargetColumn(iRow);
        String targetColName = "";
        if (targetColumn != null) {
            targetColName = targetColumn.getName();
        }
        boolean bUseQuotes = false;
        ITable[] aSourceTables = this.m_container.getSourceTables();
        for (int iSourceTable = 0; iSourceTable < aSourceTables.length && !bUseQuotes; ++iSourceTable) {
            bUseQuotes = aSourceTables[iSourceTable].isQuoted();
        }
        ExpressionBuilderTab tabExpression = new ExpressionBuilderTab(aSourceColumns, this.m_container.getSourceTables(), this.m_configuration.isUsingSQLSyntax());
        if (this.m_container instanceof SelectResultsContainer || this.m_container instanceof ExtractTransformModel || this.m_container instanceof FileReaderTransformModel || this.m_container instanceof FileWriterTransformModel || this.m_container instanceof LookupTransformModel || this.m_container instanceof TableLoaderTransformModel) {
            tabExpression.setUseValidateSelect(true);
        }
        tabExpression.setExpression(sExpression);
        String sDialogTitle = targetColName.isEmpty() ? bundle.getString("MappingsTab.Expression.Title.txt") : bundle.formatString("MappingsTab.Expression.Title.ColumnName.fmt", (Object)targetColName);
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), sDialogTitle, true, (WAPanel)tabExpression);
        dialog.setResizable(true);
        dialog.show();
        return dialog.getReturnValue() == 1 ? tabExpression.getExpression() : null;
    }

    private void showCaseDialog() {
        int iRow = this.m_tblTargetColumns.convertRowIndexToModel(this.m_tblTargetColumns.getSelectedRowsFromSelectedCells()[0]);
        IMapping mapping = this.m_mdlTargetColumns.getMapping(iRow);
        if (mapping == null) {
            mapping = this.m_container.addMapping(new IColumn[0], new IColumn[]{this.m_mdlTargetColumns.getTargetColumn(iRow)});
        }
        IExpression expression = mapping.getExpression();
        ICaseStatement caseStatement = null;
        boolean bNew = false;
        if (expression != null && expression.getExpressionType().equalsIgnoreCase("CaseOperand")) {
            caseStatement = (ICaseStatement)expression;
        } else {
            IQuery query = null;
            if (this.m_container instanceof ISelectResultsContainer) {
                query = ((ISelectResultsContainer)this.m_container).getParentQuery();
            }
            caseStatement = this.m_mdlJob.getObjectFactory().createNewSQLCaseStatement(mapping.getID(), query);
            bNew = true;
        }
        this.showCaseDialog(caseStatement, mapping, bNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCaseDialog(ICaseStatement caseStatement, IMapping mapping, boolean bNew) {
        block10: {
            this.m_container.getModel().startCompoundUndoable();
            try {
                ModelUndoManager mgrNew = new ModelUndoManager();
                boolean bOK = SQLExpressionActions.showCaseDialog(caseStatement, (IClause)this.m_container, (UndoManager)((Object)mgrNew));
                ((UndoManager)((Object)mgrNew)).end();
                if (bOK) {
                    IModel mdl = caseStatement.getModel();
                    mdl.startCompoundUndoable();
                    try {
                        mdl.undoableEditHappened((UndoableEdit)((Object)mgrNew));
                        if (bNew) {
                            mapping.setExpression((IExpression)caseStatement);
                        }
                        break block10;
                    }
                    finally {
                        mdl.endCompoundUndoable();
                    }
                }
                if (bNew) {
                    caseStatement.dispose();
                } else {
                    ((UndoManager)((Object)mgrNew)).undo();
                }
            }
            finally {
                this.m_container.getModel().endCompoundUndoable();
            }
        }
    }

    private void showChooseColumnsDialog() {
        int iRow = this.m_tblTargetColumns.convertRowIndexToModel(this.m_tblTargetColumns.getSelectedRowsFromSelectedCells()[0]);
        TablesPaletteTreeModel mdlTree = new TablesPaletteTreeModel(this.m_container.getSourceTables());
        String sExpression = SQLExpressionActions.showChooseColumnsDialog(mdlTree, this.m_configuration.isUsingSQLSyntax());
        if (sExpression != null) {
            this.m_mdlTargetColumns.setExpressionText(iRow, sExpression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSubquery() {
        this.m_container.getModel().startCompoundUndoable();
        try {
            if (!(this.m_container instanceof ISelectResultsContainer)) {
                return;
            }
            int iRow = this.m_tblTargetColumns.convertRowIndexToModel(this.m_tblTargetColumns.getSelectedRowsFromSelectedCells()[0]);
            IMapping mapping = this.m_mdlTargetColumns.getMapping(iRow);
            if (mapping == null) {
                mapping = this.m_container.addMapping(new IColumn[0], new IColumn[]{this.m_mdlTargetColumns.getTargetColumn(iRow)});
            }
            IExpression expression = mapping.getExpression();
            ISubquery subquery = null;
            if (expression instanceof ISubquery) {
                subquery = (ISubquery)expression;
            }
            if (subquery == null) {
                subquery = ((ISelectResultsContainer)this.m_container).createNewSubquery();
                mapping.setExpression((IExpression)subquery);
            }
            this.fireNavigationEvent((IObject)subquery);
        }
        finally {
            this.m_container.getModel().endCompoundUndoable();
        }
    }

    private boolean stopCellEditing() {
        return this.m_tblSourceColumns.stopCellEditing() && this.m_tblTargetColumns.stopCellEditing();
    }

    private boolean isSourceTable(ITable tbl) {
        return this.indexOfSourceTable(tbl) != -1;
    }

    private boolean isTargetTable(ITable tbl) {
        return this.indexOfTargetTable(tbl) != -1;
    }

    private int indexOfSourceTable(ITable tbl) {
        for (int iTable = 0; iTable < this.m_aSourceTables.length; ++iTable) {
            if (this.m_aSourceTables[iTable] != tbl) continue;
            return iTable;
        }
        return -1;
    }

    private int indexOfTargetTable(ITable tbl) {
        for (int iTable = 0; iTable < this.m_aTargetTables.length; ++iTable) {
            if (this.m_aTargetTables[iTable] != tbl) continue;
            return iTable;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectSourceColumns(IColumn[] aColumns) {
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_tblSourceColumns.clearSelection();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                int iRow = this.m_mdlSourceColumns.getRowIndex(aColumns[iColumn]);
                if (iRow == -1) continue;
                this.m_tblSourceColumns.addRowToSelection(this.m_tblSourceColumns.convertRowIndexToView(iRow));
            }
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromTable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectTargetColumns(IColumn[] aColumns) {
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_tblTargetColumns.clearSelection();
            for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                int iRow = this.m_mdlTargetColumns.getRowIndex(aColumns[iColumn]);
                if (iRow == -1) continue;
                this.m_tblTargetColumns.addRowToSelection(this.m_tblTargetColumns.convertRowIndexToView(iRow));
            }
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromTable(false);
        }
    }

    private void selectPairings(WsMapping[] aPairings) {
        this.setWaitCursor(true);
        this.m_pnlMappings.setAutoSelectEnabled(false);
        try {
            this.m_pnlMappings.deselectAllMappings();
            for (int iPairing = 0; iPairing < aPairings.length; ++iPairing) {
                this.m_pnlMappings.selectMapping(aPairings[iPairing]);
            }
        }
        finally {
            this.m_pnlMappings.setAutoSelectEnabled(true);
            this.m_pnlMappings.autoSelectFromMappings();
            this.setWaitCursor(false);
        }
    }

    private ITable[] getSelectedSourceTables() {
        ITable[] iTableArray;
        ITable tbl = this.getSelectedSourceTable();
        if (tbl != null) {
            ITable[] iTableArray2 = new ITable[1];
            iTableArray = iTableArray2;
            iTableArray2[0] = tbl;
        } else {
            iTableArray = this.m_aSourceTables;
        }
        return iTableArray;
    }

    private ITable[] getSelectedTargetTables() {
        ITable[] iTableArray;
        ITable tbl = this.getSelectedTargetTable();
        if (tbl != null) {
            ITable[] iTableArray2 = new ITable[1];
            iTableArray = iTableArray2;
            iTableArray2[0] = tbl;
        } else {
            iTableArray = this.m_aTargetTables;
        }
        return iTableArray;
    }

    private IColumn[] getSelectedSourceColumns() {
        int[] aRows = this.m_tblSourceColumns.getSelectedRowsFromSelectedCells();
        IColumn[] aColumns = new IColumn[aRows.length];
        for (int iRow = 0; iRow < aRows.length; ++iRow) {
            aColumns[iRow] = this.m_mdlSourceColumns.getSourceColumn(this.m_tblSourceColumns.convertRowIndexToModel(aRows[iRow]));
        }
        return aColumns;
    }

    private IColumn[] getSelectedTargetColumns() {
        int[] aRows = this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
        IColumn[] aColumns = new IColumn[aRows.length];
        for (int iRow = 0; iRow < aRows.length; ++iRow) {
            aColumns[iRow] = this.m_mdlTargetColumns.getTargetColumn(this.m_tblTargetColumns.convertRowIndexToModel(aRows[iRow]));
        }
        return aColumns;
    }

    private boolean allTrue(boolean[] aValues) {
        for (int iValue = 0; iValue < aValues.length; ++iValue) {
            if (aValues[iValue]) continue;
            return false;
        }
        return true;
    }

    private void setWaitCursor(boolean bWait) {
        if (this.m_rootPane == null) {
            this.m_rootPane = SwingUtilities.getRootPane((Component)((Object)this));
        }
        Cursor cursor = bWait ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        this.m_rootPane.setCursor(cursor);
    }

    protected WsAbstractAction getMapAll() {
        return this.m_actMapAll;
    }

    protected WsAbstractAction getMapSelected() {
        return this.m_actMapSelected;
    }

    protected WsAbstractAction getFixSourceColumn() {
        return this.m_actFixSourceColumn;
    }

    protected WsAbstractAction getSelectAllSourceColumns() {
        return this.m_actSelectAllSourceColumns;
    }

    protected WsAbstractAction getSelectAllTargetColumns() {
        return this.m_actSelectAllTargetColumns;
    }

    static /* synthetic */ ITable[] access$1902(MappingsTab x0, ITable[] x1) {
        x0.m_aSourceTables = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$3602(MappingsTab x0, boolean[] x1) {
        x0.m_aSourceTableEditables = x1;
        return x1;
    }

    static /* synthetic */ ITable[] access$2302(MappingsTab x0, ITable[] x1) {
        x0.m_aTargetTables = x1;
        return x1;
    }

    static /* synthetic */ boolean[] access$3902(MappingsTab x0, boolean[] x1) {
        x0.m_aTargetTableEditables = x1;
        return x1;
    }

    private class SelectPairingsUndoable
    extends AbstractUndoableEdit {
        private WsMapping[] m_aPairings;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectPairingsUndoable(WsMapping[] aPairings, boolean bOnUndo, boolean bOnRedo) {
            this.m_aPairings = aPairings;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                MappingsTab.this.selectPairings(this.m_aPairings);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                MappingsTab.this.selectPairings(this.m_aPairings);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aPairings, null);
            this.m_aPairings = null;
        }
    }

    private class SelectTargetColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_aColumns;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectTargetColumnsUndoable(IColumn column, boolean bOnUndo, boolean bOnRedo) {
            this(new IColumn[]{column}, bOnUndo, bOnRedo);
        }

        public SelectTargetColumnsUndoable(IColumn[] aColumns, boolean bOnUndo, boolean bOnRedo) {
            this.m_aColumns = aColumns;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                MappingsTab.this.selectTargetColumns(this.m_aColumns);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                MappingsTab.this.selectTargetColumns(this.m_aColumns);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aColumns, null);
            this.m_aColumns = null;
        }
    }

    private class SelectSourceColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_aColumns;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectSourceColumnsUndoable(IColumn column, boolean bOnUndo, boolean bOnRedo) {
            this(new IColumn[]{column}, bOnUndo, bOnRedo);
        }

        public SelectSourceColumnsUndoable(IColumn[] aColumns, boolean bOnUndo, boolean bOnRedo) {
            this.m_aColumns = aColumns;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                MappingsTab.this.selectSourceColumns(this.m_aColumns);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                MappingsTab.this.selectSourceColumns(this.m_aColumns);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aColumns, null);
            this.m_aColumns = null;
        }
    }

    private class DistinctRowsToggleAction
    extends WsAbstractToggleAction {
        public DistinctRowsToggleAction() {
            super(bundle, "MappingsTab.Action.DistinctRows", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IQuery query = null;
            if (MappingsTab.this.m_container instanceof ISelectResultsContainer) {
                query = ((ISelectResultsContainer)MappingsTab.this.m_container).getParentQuery();
                query.setUseDistinct(MappingsTab.this.m_ckbDistinctRows.isSelected());
            }
        }
    }

    private class AllFieldsToggleAction
    extends WsAbstractToggleAction {
        public AllFieldsToggleAction() {
            super(bundle, "MappingsTab.Action.AllFields", 0);
        }

        public void actionPerformed(ActionEvent e) {
            IQuery query = null;
            if (MappingsTab.this.m_container instanceof ISelectResultsContainer) {
                query = ((ISelectResultsContainer)MappingsTab.this.m_container).getParentQuery();
                query.setUseImplicit(MappingsTab.this.m_ckbAllFields.isSelected());
            }
        }
    }

    private class SelectAllMappingsAction
    extends WsAbstractAction {
        public SelectAllMappingsAction() {
            super(bundle, "MappingsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.selectAllMappings();
        }
    }

    private class SelectAllTargetColumnsAction
    extends WsAbstractAction {
        public SelectAllTargetColumnsAction() {
            super(bundle, "MappingsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.m_tblTargetColumns.selectAll();
        }
    }

    private class SelectAllSourceColumnsAction
    extends WsAbstractAction {
        public SelectAllSourceColumnsAction() {
            super(bundle, "MappingsTab.Action.SelectAll", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.m_tblSourceColumns.selectAll();
        }
    }

    private class AdvancedAction
    extends WsAbstractAction {
        public AdvancedAction() {
            super(bundle, "MappingsTab.Action.Advanced", 257);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.showExpressionBuilderDialog();
        }
    }

    private class SubqueryAction
    extends WsAbstractAction {
        public SubqueryAction() {
            super(bundle, "MappingsTab.Action.Subquery", 257);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.showSubquery();
        }
    }

    private class CaseAction
    extends WsAbstractAction {
        public CaseAction() {
            super(bundle, "MappingsTab.Action.Case", 257);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.showCaseDialog();
        }
    }

    private class ChooseColumnsAction
    extends WsAbstractAction {
        public ChooseColumnsAction() {
            super(bundle, "MappingsTab.Action.ChooseColumns", 257);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.showChooseColumnsDialog();
        }
    }

    private class ExpressionDropMenuAction
    extends WsDropMenuAction {
        public ExpressionDropMenuAction() {
            super(bundle, "MappingsTab.Action.ExpressionDropMenu", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ExpressionDropMenu"));
        }
    }

    private class ExpressionAction
    extends WsAbstractAction {
        public ExpressionAction() {
            super(bundle, "MappingsTab.Action.Expression", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Expression"));
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class DeleteMappingsAction
    extends WsAbstractAction {
        public DeleteMappingsAction() {
            super(bundle, "MappingsTab.Action.DeleteMappings", 257);
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.deleteSelectedPairings();
        }
    }

    private class DeleteTargetColumnsAction
    extends WsAbstractAction {
        public DeleteTargetColumnsAction() {
            super(bundle, "MappingsTab.Action.DeleteTargetColumns", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.deleteSelectedTargetColumns();
        }
    }

    private class DeleteSourceColumnsAction
    extends WsAbstractAction {
        public DeleteSourceColumnsAction() {
            super(bundle, "MappingsTab.Action.DeleteSourceColumns", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.deleteSelectedSourceColumns();
        }
    }

    private class DeleteAction
    extends WsDropMenuAction {
        public DeleteAction() {
            super(bundle, "MappingsTab.Action.Delete", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("DeleteDropMenu"));
        }
    }

    private class CollapseTargetPanelAction
    extends WsAbstractAction {
        public CollapseTargetPanelAction() {
            super(bundle, "MappingsTab.Action.CollapseTargetPanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ShowBothPanels"));
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.setTargetPanelExpanded(false);
        }
    }

    private class ExpandTargetPanelAction
    extends WsAbstractAction {
        public ExpandTargetPanelAction() {
            super(bundle, "MappingsTab.Action.ExpandTargetPanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ExpandRightPanel"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.setTargetPanelExpanded(true);
        }
    }

    private class CollapseSourcePanelAction
    extends WsAbstractAction {
        public CollapseSourcePanelAction() {
            super(bundle, "MappingsTab.Action.CollapseSourcePanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ShowBothPanels"));
        }

        public void actionPerformed(ActionEvent e) {
            MappingsTab.this.setSourcePanelExpanded(false);
        }
    }

    private class ExpandSourcePanelAction
    extends WsAbstractAction {
        public ExpandSourcePanelAction() {
            super(bundle, "MappingsTab.Action.ExpandSourcePanel", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("ExpandLeftPanel"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.setSourcePanelExpanded(true);
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            super(bundle, "MappingsTab.Action.Redo", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Redo"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.redo();
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            super(bundle, "MappingsTab.Action.Undo", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Undo"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.undo();
        }
    }

    private class SaveCurrentTargetColumnOrderAction
    extends WsAbstractAction {
        public SaveCurrentTargetColumnOrderAction() {
            super(bundle, "MappingsTab.Action.SaveCurrentTargetColumnOrder", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.saveCurrentTargetColumnOrder();
        }
    }

    private class SaveCurrentSourceColumnOrderAction
    extends WsAbstractAction {
        public SaveCurrentSourceColumnOrderAction() {
            super(bundle, "MappingsTab.Action.SaveCurrentSourceColumnOrder", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.saveCurrentSourceColumnOrder();
        }
    }

    private class FixExpressionMappingsAction
    extends WsAbstractAction {
        public FixExpressionMappingsAction() {
            super(bundle, "MappingsTab.Action.FixExpressionMappings", 256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            int[] aRows = MappingsTab.this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            if (aRows.length != 1) {
                return;
            }
            int iRow = MappingsTab.this.m_tblTargetColumns.convertRowIndexToModel(aRows[0]);
            IMapping mapping = MappingsTab.this.m_mdlTargetColumns.getMapping(iRow);
            IExpression expression = mapping.getExpression();
            if (expression == null) {
                return;
            }
            MappingsTab.this.m_mdlJob.startCompoundUndoable();
            try {
                IObject[] aExpressionColumns = expression.getSources();
                for (int iExpressionColumn = 0; iExpressionColumn < aExpressionColumns.length; ++iExpressionColumn) {
                    if (!(aExpressionColumns[iExpressionColumn] instanceof IColumn) || mapping.containsInSources((IColumn)aExpressionColumns[iExpressionColumn])) continue;
                    mapping.addSource((IColumn)aExpressionColumns[iExpressionColumn]);
                }
                IColumn[] aMappingSources = mapping.getSources();
                for (int iMappingColumn = 0; iMappingColumn < aMappingSources.length; ++iMappingColumn) {
                    if (expression.containsColumn(aMappingSources[iMappingColumn])) continue;
                    mapping.removeSource(aMappingSources[iMappingColumn]);
                }
            }
            finally {
                MappingsTab.this.m_mdlJob.endCompoundUndoable();
            }
        }
    }

    private class FixTargetColumnAction
    extends WsAbstractAction {
        public FixTargetColumnAction() {
            super(bundle, "MappingsTab.Action.FixTargetColumn", 256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            int[] aRows = MappingsTab.this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            if (aRows.length != 1) {
                return;
            }
            int iRow = MappingsTab.this.m_tblTargetColumns.convertRowIndexToModel(aRows[0]);
            IMapping mapping = MappingsTab.this.m_mdlTargetColumns.getMapping(iRow);
            IColumn[] sources = mapping.getSources();
            IColumn[] targets = mapping.getTargets();
            if (sources.length != 1 && targets.length != 1) {
                return;
            }
            MappingsTab.this.m_mdlJob.startCompoundUndoable();
            try {
                targets[0].setType(sources[0].getType());
                targets[0].setLength(sources[0].getLength());
                targets[0].setFormat(sources[0].getFormat());
                targets[0].setInformat(sources[0].getInformat());
            }
            finally {
                MappingsTab.this.m_mdlJob.endCompoundUndoable();
            }
        }
    }

    private class FixSourceColumnAction
    extends WsAbstractAction {
        public FixSourceColumnAction() {
            super(bundle, "MappingsTab.Action.FixSourceColumn", 256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ev) {
            int[] aRows = MappingsTab.this.m_tblTargetColumns.getSelectedRowsFromSelectedCells();
            if (aRows.length != 1) {
                return;
            }
            int iRow = MappingsTab.this.m_tblTargetColumns.convertRowIndexToModel(aRows[0]);
            IMapping mapping = MappingsTab.this.m_mdlTargetColumns.getMapping(iRow);
            IColumn[] sources = mapping.getSources();
            IColumn[] targets = mapping.getTargets();
            if (sources.length != 1 && targets.length != 1) {
                return;
            }
            MappingsTab.this.m_mdlJob.startCompoundUndoable();
            try {
                sources[0].setType(targets[0].getType());
                sources[0].setLength(targets[0].getLength());
                sources[0].setFormat(targets[0].getFormat());
                sources[0].setInformat(targets[0].getInformat());
            }
            finally {
                MappingsTab.this.m_mdlJob.endCompoundUndoable();
            }
        }
    }

    private class FixWarningDropMenuAction
    extends WsDropMenuAction {
        public FixWarningDropMenuAction() {
            super(bundle, "MappingsTab.Action.FixWarningDropMenu", 18);
        }
    }

    private class FixWarningAction
    extends WsAbstractAction {
        public FixWarningAction() {
            super(bundle, "MappingsTab.Action.FixWarning", 258);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "MappingsTab.Action.MoveDown", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.moveSelectedTargetColumns(1);
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "MappingsTab.Action.MoveUp", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.moveSelectedTargetColumns(0);
        }
    }

    private class ImportColumnsAction
    extends WsAbstractAction {
        public ImportColumnsAction() {
            super(bundle, "MappingsTab.Action.ImportColumns", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:ImportColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.importColumns();
        }
    }

    private class NewColumnAction
    extends WsAbstractAction {
        public NewColumnAction() {
            super(bundle, "MappingsTab.Action.NewColumn", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:NewColumn"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.createNewTargetColumn();
        }
    }

    private class IncludeColumnsInMappingAction
    extends WsAbstractToggleAction {
        public IncludeColumnsInMappingAction() {
            super(bundle, "MappingsTab.Action.IncludeSelectedColumnsInMapping", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.isSelected()) {
                MappingsTab.this.removeSelectedColumnsFromExcludeFromMapping();
            } else {
                MappingsTab.this.addSelectedColumnsToExcludeFromMapping();
            }
        }
    }

    private class IncludeColumnsInPropagationAction
    extends WsAbstractToggleAction {
        public IncludeColumnsInPropagationAction() {
            super(bundle, "MappingsTab.Action.IncludeSelectedColumnsInPropagation", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.isSelected()) {
                MappingsTab.this.removeSelectedColumnsFromExcludeFromPropagation();
            } else {
                MappingsTab.this.addSelectedColumnsToExcludeFromPropagation();
            }
        }
    }

    private class IncludeTransformationInMappingAction
    extends WsAbstractToggleAction {
        public IncludeTransformationInMappingAction() {
            super(bundle, "MappingsTab.Action.IncludeTransformationInMapping", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.m_container.setIncludedInMapping(this.isSelected());
        }
    }

    private class IncludeTransformationInPropagationAction
    extends WsAbstractToggleAction {
        public IncludeTransformationInPropagationAction() {
            super(bundle, "MappingsTab.Action.IncludeTransformationInPropagation", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.m_container.setIncludedInPropagation(this.isSelected());
        }
    }

    private class SettingsAction
    extends WsDropMenuAction {
        public SettingsAction() {
            super(bundle, "MappingsTab.Action.Settings", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("OptionsDropMenu"));
        }
    }

    private class MapSelectedColumnsAction
    extends WsAbstractAction {
        public MapSelectedColumnsAction() {
            super(bundle, "MappingsTab.Action.MapSelectedColumns", 1);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("MapSelectedColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.createPairingsBetweenSelectedColumns();
        }
    }

    private class MapAllAction
    extends WsAbstractAction {
        public MapAllAction() {
            super(bundle, "MappingsTab.Action.MapAll", 1);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:MapColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.mapColumns();
        }
    }

    private class UpdateSelectedSourceColumnsToEndAction
    extends WsAbstractAction {
        public UpdateSelectedSourceColumnsToEndAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedSourceColumnsToEnd", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.updateSelectedSourceColumnsToEnd();
        }
    }

    private class UpdateSelectedSourceColumnsToBeginningAction
    extends WsAbstractAction {
        public UpdateSelectedSourceColumnsToBeginningAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedSourceColumnsToBeginning", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.updateSelectedSourceColumnsToBeginning();
        }
    }

    private class UpdateSelectedSourceColumnsToTargetsAction
    extends WsAbstractAction {
        public UpdateSelectedSourceColumnsToTargetsAction() {
            super(bundle, MappingsTab.this.m_configuration.getPropagationActionsVisible() == 0 ? "MappingsTab.Action.UpdateSelectedSourceColumnsToTargets" : "MappingsTab.Action.UpdateSelectedSourceColumnsToTargets2", 257);
            if (MappingsTab.this.m_configuration.getPropagationActionsVisible() != 1) {
                this.setIcon(null);
            }
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.updateSelectedSourceColumnsToTargets();
        }
    }

    private class UpdateSelectedSourceColumnsAction
    extends WsAbstractAction {
        public UpdateSelectedSourceColumnsAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedSourceColumns", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class UpdateSelectedTargetColumnsToEndAction
    extends WsAbstractAction {
        public UpdateSelectedTargetColumnsToEndAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedTargetColumnsToEnd", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.updateSelectedTargetColumnsToEnd();
        }
    }

    private class UpdateSelectedTargetColumnsToBeginningAction
    extends WsAbstractAction {
        public UpdateSelectedTargetColumnsToBeginningAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedTargetColumnsToBeginning", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.updateSelectedTargetColumnsToBeginning();
        }
    }

    private class UpdateSelectedTargetColumnsToSourcesAction
    extends WsAbstractAction {
        public UpdateSelectedTargetColumnsToSourcesAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedTargetColumnsToSources", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.updateSelectedTargetColumnsToSources();
        }
    }

    private class UpdateSelectedTargetColumnsAction
    extends WsAbstractAction {
        public UpdateSelectedTargetColumnsAction() {
            super(bundle, "MappingsTab.Action.UpdateSelectedTargetColumns", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class SelectedSourceColumnsToEndAction
    extends WsAbstractAction {
        public SelectedSourceColumnsToEndAction() {
            super(bundle, "MappingsTab.Action.SelectedSourceColumnsToEnd", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateSelectedSourceColumnsToEnd();
        }
    }

    private class SelectedSourceColumnsToBeginningAction
    extends WsAbstractAction {
        public SelectedSourceColumnsToBeginningAction() {
            super(bundle, "MappingsTab.Action.SelectedSourceColumnsToBeginning", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateSelectedSourceColumnsToBeginning();
        }
    }

    private class SelectedSourceColumnsToTargetsAction
    extends WsAbstractAction {
        public SelectedSourceColumnsToTargetsAction() {
            super(bundle, MappingsTab.this.m_configuration.getPropagationActionsVisible() == 0 ? "MappingsTab.Action.SelectedSourceColumnsToTargets" : "MappingsTab.Action.SelectedSourceColumnsToTargets2", 257);
            if (MappingsTab.this.m_configuration.getPropagationActionsVisible() != 1) {
                this.setIcon(null);
            }
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateSelectedSourceColumnsToTargets();
        }
    }

    private class SelectedSourceColumnsAction
    extends WsAbstractAction {
        public SelectedSourceColumnsAction() {
            super(bundle, "MappingsTab.Action.SelectedSourceColumns", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class SelectedTargetColumnsToEndAction
    extends WsAbstractAction {
        public SelectedTargetColumnsToEndAction() {
            super(bundle, "MappingsTab.Action.SelectedTargetColumnsToEnd", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateSelectedTargetColumnsToEnd();
        }
    }

    private class SelectedTargetColumnsToBeginningAction
    extends WsAbstractAction {
        public SelectedTargetColumnsToBeginningAction() {
            super(bundle, "MappingsTab.Action.SelectedTargetColumnsToBeginning", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateSelectedTargetColumnsToBeginning();
        }
    }

    private class SelectedTargetColumnsToSourcesAction
    extends WsAbstractAction {
        public SelectedTargetColumnsToSourcesAction() {
            super(bundle, "MappingsTab.Action.SelectedTargetColumnsToSources", 256);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateSelectedTargetColumnsToSources();
        }
    }

    private class SelectedTargetColumnsAction
    extends WsAbstractAction {
        public SelectedTargetColumnsAction() {
            super(bundle, "MappingsTab.Action.SelectedTargetColumns", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class FromSourcesToEndAction
    extends WsAbstractAction {
        public FromSourcesToEndAction() {
            super(bundle, "MappingsTab.Action.FromSourcesToEnd", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateFromSourcesToEnd();
        }
    }

    private class FromSourcesToBeginningAction
    extends WsAbstractAction {
        public FromSourcesToBeginningAction() {
            super(bundle, "MappingsTab.Action.FromSourcesToBeginning", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateFromSourcesToBeginning();
        }
    }

    private class FromSourcesToTargetsAction
    extends WsAbstractAction {
        public FromSourcesToTargetsAction() {
            super(bundle, MappingsTab.this.m_configuration.getPropagationActionsVisible() == 0 ? "MappingsTab.Action.FromSourcesToTargets" : "MappingsTab.Action.FromSourcesToTargets2", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:PropagateColumns:FromSources:ToTargets"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateFromSourcesToTargets();
        }
    }

    private class FromSourcesAction
    extends WsAbstractAction {
        public FromSourcesAction() {
            super(bundle, "MappingsTab.Action.FromSources", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class FromTargetsToEndAction
    extends WsAbstractAction {
        public FromTargetsToEndAction() {
            super(bundle, "MappingsTab.Action.FromTargetsToEnd", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateFromTargetsToEnd();
        }
    }

    private class FromTargetsToBeginningAction
    extends WsAbstractAction {
        public FromTargetsToBeginningAction() {
            super(bundle, "MappingsTab.Action.FromTargetsToBeginning", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateFromTargetsToBeginning();
        }
    }

    private class FromTargetsToSourcesAction
    extends WsAbstractAction {
        public FromTargetsToSourcesAction() {
            super(bundle, "MappingsTab.Action.FromTargetsToSources", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:PropagateColumns:FromTargets:ToSources"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateFromTargetsToSources();
        }
    }

    private class FromTargetsAction
    extends WsAbstractAction {
        public FromTargetsAction() {
            super(bundle, "MappingsTab.Action.FromTargets", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class ToSourcesFromEndAction
    extends WsAbstractAction {
        public ToSourcesFromEndAction() {
            super(bundle, "MappingsTab.Action.ToSourcesFromEnd", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateToSourcesFromEnd();
        }
    }

    private class ToSourcesFromBeginningAction
    extends WsAbstractAction {
        public ToSourcesFromBeginningAction() {
            super(bundle, "MappingsTab.Action.ToSourcesFromBeginning", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateToSourcesFromBeginning();
        }
    }

    private class ToSourcesFromTargetsAction
    extends WsAbstractAction {
        public ToSourcesFromTargetsAction() {
            super(bundle, "MappingsTab.Action.ToSourcesFromTargets", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:PropagateColumns:FromTargets:ToSources"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateToSourcesFromTargets();
        }
    }

    private class ToSourcesAction
    extends WsAbstractAction {
        public ToSourcesAction() {
            super(bundle, "MappingsTab.Action.ToSources", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class ToTargetsFromEndAction
    extends WsAbstractAction {
        public ToTargetsFromEndAction() {
            super(bundle, "MappingsTab.Action.ToTargetsFromEnd", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateToTargetsFromEnd();
        }
    }

    private class ToTargetsFromBeginningAction
    extends WsAbstractAction {
        public ToTargetsFromBeginningAction() {
            super(bundle, "MappingsTab.Action.ToTargetsFromBeginning", 257);
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateToTargetsFromBeginning();
        }
    }

    private class ToTargetsFromSourcesAction
    extends WsAbstractAction {
        public ToTargetsFromSourcesAction() {
            super(bundle, "MappingsTab.Action.ToTargetsFromSources", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:PropagateColumns:FromSources:ToTargets"));
        }

        public void actionPerformed(ActionEvent ev) {
            MappingsTab.this.propagateToTargetsFromSources();
        }
    }

    private class ToTargetsAction
    extends WsAbstractAction {
        public ToTargetsAction() {
            super(bundle, "MappingsTab.Action.ToTargets", 256);
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class PropagateDropMenuAction
    extends WsDropMenuAction {
        public PropagateDropMenuAction() {
            super(bundle, "MappingsTab.Action.PropagateDropMenu", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("PropagateColumnsDropMenu"));
        }
    }

    private class PropagateAction
    extends WsAbstractAction {
        public PropagateAction() {
            super(bundle, "MappingsTab.Action.Propagate", 256);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Actions:PropagateColumns"));
        }

        public void actionPerformed(ActionEvent ev) {
        }
    }

    private class TargetRowModelListener
    implements WsTableRowModelListener {
        private TargetRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)MappingsTab.this.m_tblTargetColumns.getRowModel();
            mdlRows.clearRowMoves();
            MappingsTab.this.moveTargetColumn(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            MappingsTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class SourceRowModelListener
    implements WsTableRowModelListener {
        private SourceRowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)MappingsTab.this.m_tblSourceColumns.getRowModel();
            mdlRows.clearRowMoves();
            MappingsTab.this.moveSourceColumn(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            MappingsTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = MappingsTab.this.m_container.getModel().getUndoManager();
            MappingsTab.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            MappingsTab.this.m_actRedo.setEnabled(mgrUndo.canRedo());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            MappingsTab.this.m_tblSourceColumns.cancelCellEditing();
            MappingsTab.this.m_tblTargetColumns.cancelCellEditing();
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                MappingsTab.this.moveDataToView();
            } else if (obj == MappingsTab.this.m_container) {
                if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataSourceRemoved") {
                    MappingsTab.access$1902(MappingsTab.this, MappingsTab.this.m_container.getSourceTables());
                    MappingsTab.access$3602(MappingsTab.this, MappingsTab.this.getTableEditables(MappingsTab.this.m_aSourceTables));
                    MappingsTab.this.refreshSourcePanelLabel();
                    MappingsTab.this.updateActions();
                } else if (sType == "DataTransform.DataTargetAdded" || sType == "DataTransform.DataTargetRemoved") {
                    MappingsTab.access$2302(MappingsTab.this, MappingsTab.this.m_container.getTargetTables());
                    MappingsTab.access$3902(MappingsTab.this, MappingsTab.this.getTableEditables(MappingsTab.this.m_aTargetTables));
                    MappingsTab.this.refreshTargetPanelLabel();
                    MappingsTab.this.updateActions();
                } else if (sType == "MappingsContainer:IncludeInPropagationChanged" || sType == "MappingsContainer:IncludeInMappingsChanged") {
                    MappingsTab.this.updateActions();
                } else if (sType == "MappingsContainer:MappingAdded" || sType == "MappingsContainer:MappingRemoved") {
                    MappingsTab.this.m_actSelectAllMappings.setEnabled(MappingsTab.this.m_container.getMappingsList().size() != 0);
                } else if (sType == "MappingsContainer:MappingChanged") {
                    MappingsTab.this.updateActions();
                } else if (sType == "MiningResultTransformModel:MiningResultChanged") {
                    MappingsTab.this.moveDataToView();
                }
            } else if (MappingsTab.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)MappingsTab.this.m_container).getParentQuery() == obj) {
                if (sType == "SelectResults:UseDistinctChanged" && MappingsTab.this.m_configuration.isSetOperatorSpecificsEnabled()) {
                    MappingsTab.this.m_ckbDistinctRows.setSelected(((IQuery)obj).useDistinct());
                }
                if (sType == "SelectResults:UseImplicitChanged" && MappingsTab.this.m_configuration.isSetOperatorSpecificsEnabled()) {
                    MappingsTab.this.m_ckbAllFields.setSelected(((IQuery)obj).useImplicit());
                }
                if (sType == "SQLObject:QueryTableAdded" || sType == "SQLObject:QueryTableRemoved" || sType == "BaseQuery:SubqueryAdded" || sType == "BaseQuery:SubqueryRemoved" || sType == "SQLFrom:SourceOfFromChanged") {
                    MappingsTab.access$1902(MappingsTab.this, MappingsTab.this.m_container.getSourceTables());
                    MappingsTab.access$3602(MappingsTab.this, MappingsTab.this.getTableEditables(MappingsTab.this.m_aSourceTables));
                    MappingsTab.this.refreshSourcePanelLabel();
                    MappingsTab.this.updateActions();
                }
            } else if (MappingsTab.this.m_container instanceof ISelectResultsContainer && obj instanceof IJoin) {
                if (sType == "Join:LeftSideChanged" || sType == "Join:RightSideChanged") {
                    MappingsTab.access$1902(MappingsTab.this, MappingsTab.this.m_container.getSourceTables());
                    MappingsTab.access$3602(MappingsTab.this, MappingsTab.this.getTableEditables(MappingsTab.this.m_aSourceTables));
                    MappingsTab.this.refreshSourcePanelLabel();
                    MappingsTab.this.updateActions();
                }
            } else if (MappingsTab.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)MappingsTab.this.m_container).getParentQuery().getTransformModel() == obj) {
                if (sType == "DataTransform.DataTargetAdded" || sType == "DataTransform.DataTargetRemoved") {
                    MappingsTab.access$2302(MappingsTab.this, MappingsTab.this.m_container.getTargetTables());
                    MappingsTab.access$3902(MappingsTab.this, MappingsTab.this.getTableEditables(MappingsTab.this.m_aTargetTables));
                    MappingsTab.this.refreshTargetPanelLabel();
                    MappingsTab.this.updateActions();
                } else if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataSourceRemoved") {
                    MappingsTab.access$1902(MappingsTab.this, MappingsTab.this.m_container.getSourceTables());
                    MappingsTab.access$3602(MappingsTab.this, MappingsTab.this.getTableEditables(MappingsTab.this.m_aSourceTables));
                    MappingsTab.this.refreshSourcePanelLabel();
                    MappingsTab.this.updateActions();
                }
            } else if (obj instanceof ITable) {
                if (sType == "Object:NameChanged") {
                    if (MappingsTab.this.isSourceTable((ITable)obj)) {
                        MappingsTab.this.refreshSourcePanelLabel();
                    } else if (MappingsTab.this.isTargetTable((ITable)obj)) {
                        MappingsTab.this.refreshTargetPanelLabel();
                    }
                } else if (sType == "Table:ColumnAdded" || sType == "Table:ColumnRemoved") {
                    if (MappingsTab.this.isSourceTable((ITable)obj)) {
                        MappingsTab.this.m_actSelectAllSourceColumns.setEnabled(MappingsTab.this.m_tblSourceColumns.getRowCount() > 0);
                    } else if (MappingsTab.this.isTargetTable((ITable)obj)) {
                        MappingsTab.this.m_actSelectAllTargetColumns.setEnabled(MappingsTab.this.m_tblTargetColumns.getRowCount() > 0);
                    }
                }
            }
        }
    }

    private class CenterPanelLabelMouseListener
    implements MouseListener,
    MouseMotionListener {
        private int _x = -1;
        private boolean _dragging;

        private CenterPanelLabelMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._dragging) {
                Point pt = e.getPoint();
                SwingUtilities.convertPointToScreen(pt, e.getComponent());
                int x = pt.x;
                int delta = x - this._x;
                int outer = MappingsTab.this.m_spltOuter.getDividerLocation() + delta;
                int inner = MappingsTab.this.m_spltInner.getDividerLocation() + delta;
                if (delta < 0 ? inner < MappingsTab.this.m_spltInner.getMinimumDividerLocation() : outer > MappingsTab.this.m_spltOuter.getMaximumDividerLocation()) {
                    return;
                }
                MappingsTab.this.m_spltOuter.setDividerLocation(outer);
                MappingsTab.this.m_spltOuter.validate();
                MappingsTab.this.m_spltInner.setDividerLocation(inner);
                MappingsTab.this.m_spltInner.validate();
                this._x = x;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._dragging = true;
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            this._x = pt.x;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._dragging = false;
            this._x = -1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class MappingsPopupListener
    implements WsPopupMenuRequestListener {
        private MappingsPopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            MappingsTab.this.m_mnuMappingsPopup.show((Component)((Object)MappingsTab.this.m_pnlMappings), ev.getX(), ev.getY());
        }
    }

    private class TargetColumnsViewportPopupListener
    implements WsPopupMenuRequestListener {
        private TargetColumnsViewportPopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            MappingsTab.this.m_mnuTargetViewportPopup.show((Component)MappingsTab.this.m_tblTargetColumns, ev.getX(), ev.getY());
        }
    }

    private class TargetColumnsTablePopupListener
    implements WsPopupMenuRequestListener {
        private TargetColumnsTablePopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            MappingsTab.this.m_mnuTargetTablePopup.show((Component)MappingsTab.this.m_tblTargetColumns, ev.getX(), ev.getY());
        }
    }

    private class SourceColumnsViewportPopupListener
    implements WsPopupMenuRequestListener {
        private SourceColumnsViewportPopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            MappingsTab.this.m_mnuSourceViewportPopup.show((Component)MappingsTab.this.m_tblSourceColumns, ev.getX(), ev.getY());
        }
    }

    private class SourceColumnsTablePopupListener
    implements WsPopupMenuRequestListener {
        private SourceColumnsTablePopupListener() {
        }

        public void popupMenuRequested(MouseEvent ev) {
            MappingsTab.this.m_mnuSourceTablePopup.show((Component)MappingsTab.this.m_tblSourceColumns, ev.getX(), ev.getY());
        }
    }

    private class MappingsSelectionListener
    implements WsObjectSelectionListener {
        private MappingsSelectionListener() {
        }

        public void objectChangedSelection(WsObjectSelectionEvent ev) {
            MappingsTab.this.updateActions();
        }
    }

    private class TargetColumnsSelectionListener
    implements ListSelectionListener {
        private TargetColumnsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            MappingsTab.this.updateActions();
        }
    }

    private class SourceColumnsSelectionListener
    implements ListSelectionListener {
        private SourceColumnsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            MappingsTab.this.updateActions();
        }
    }

    private class TargetTableSelectionListener
    implements ItemListener {
        private TargetTableSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            int iSelect = MappingsTab.this.m_cmbTargetTables.getSelectedIndex();
            if (iSelect >= 2) {
                MappingsTab.this.setSelectedTargetTable(MappingsTab.this.m_aTargetTables[iSelect - 2]);
            } else {
                MappingsTab.this.setSelectedTargetTable(null);
            }
            MappingsTab.this.updateActions();
        }
    }

    private class SourceTableSelectionListener
    implements ItemListener {
        private SourceTableSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            int iSelect = MappingsTab.this.m_cmbSourceTables.getSelectedIndex();
            if (iSelect >= 2) {
                MappingsTab.this.setSelectedSourceTable(MappingsTab.this.m_aSourceTables[iSelect - 2]);
            } else {
                MappingsTab.this.setSelectedSourceTable(null);
            }
            MappingsTab.this.updateActions();
        }
    }

    private static class OrdinaryMappingsFilter
    implements IFilter {
        private OrdinaryMappingsFilter() {
        }

        public boolean pass(Object obj) {
            return ((IMapping)obj).isOrdinary();
        }
    }

    public static class Configuration {
        public static final int CHOOSE_COLUMNS_ACTION = 0;
        public static final int CASE_ACTION = 1;
        public static final int SUBQUERY_ACTION = 2;
        public static final int ADVANCED_ACTION = 3;
        public static final int ALL_PROPAGATION_ACTIONS = 0;
        public static final int SOURCE_TO_TARGET_PROPAGATION_ACTIONS = 1;
        public static final int NO_PROPAGATION_ACTIONS = 2;
        private boolean m_bSetOperatorSpecificsEnabled = false;
        private boolean m_bMultipleSourceTablesEnabled = false;
        private boolean m_bMultipleTargetTablesEnabled = false;
        private boolean m_bDragMultipleSourceColumnsEnabled = true;
        private boolean m_bDragMultipleTargetColumnsEnabled = true;
        private boolean m_bExpressionActionsVisible = true;
        private boolean m_bUseSQLSyntax = false;
        private int[] m_aHiddenColumnsInSourceColumnsTable = new int[]{2, 3};
        private int[] m_aHiddenColumnsInTargetColumnsTable = new int[]{5, 6};
        private int[] m_aHiddenExpressionActions = new int[]{1, 2};
        private String m_sSourceTableLabel = MappingsTab.access$000().getString("MappingsTab.Label.SourceTable.txt");
        private String m_sTargetTableLabel = MappingsTab.access$000().getString("MappingsTab.Label.TargetTable.txt");
        private String m_sSettingsKeyPrefix = "MappingsTab";
        private String m_sWhereUsedSettingsKeyPrefix = "Properties";
        private String m_sSourceTableSettingsKeyPrefix = "SourceColumnsTable";
        private String m_sTargetTableSettingsKeyPrefix = "TargetColumnsTable";
        private int m_ePropagationActionsVisible = 0;
        private boolean m_bSettingsActionVisible = true;
        private boolean m_bSourceTablesEditable = true;
        private boolean m_bTargetTablesEditable = true;
        private IFilter m_filter = new OrdinaryMappingsFilter();

        public void setSetOperatorSpecificsEnabled(boolean bEnabled) {
            this.m_bSetOperatorSpecificsEnabled = bEnabled;
        }

        public boolean isSetOperatorSpecificsEnabled() {
            return this.m_bSetOperatorSpecificsEnabled;
        }

        public void setMultipleSourceTablesEnabled(boolean bEnabled) {
            this.m_bMultipleSourceTablesEnabled = bEnabled;
        }

        public boolean isMultipleSourceTablesEnabled() {
            return this.m_bMultipleSourceTablesEnabled;
        }

        public void setMultipleTargetTablesEnabled(boolean bEnabled) {
            this.m_bMultipleTargetTablesEnabled = bEnabled;
        }

        public boolean isMultipleTargetTablesEnabled() {
            return this.m_bMultipleTargetTablesEnabled;
        }

        public void setDragMultipleSourceColumnsEnabled(boolean bEnabled) {
            this.m_bDragMultipleSourceColumnsEnabled = bEnabled;
        }

        public boolean isDragMultipleSourceColumnsEnabled() {
            return this.m_bDragMultipleSourceColumnsEnabled;
        }

        public void setDragMultipleTargetColumnsEnabled(boolean bEnabled) {
            this.m_bDragMultipleTargetColumnsEnabled = bEnabled;
        }

        public boolean isDragMultipleTargetColumnsEnabled() {
            return this.m_bDragMultipleTargetColumnsEnabled;
        }

        public void setPropagationActionsVisible(int ePropagationActionsVisible) {
            this.m_ePropagationActionsVisible = ePropagationActionsVisible;
        }

        public int getPropagationActionsVisible() {
            return this.m_ePropagationActionsVisible;
        }

        public void setSettingsActionVisible(boolean bVisible) {
            this.m_bSettingsActionVisible = bVisible;
        }

        public boolean isSettingsActionVisible() {
            return this.m_bSettingsActionVisible;
        }

        public void setExpressionActionsVisible(boolean bVisible) {
            this.m_bExpressionActionsVisible = bVisible;
        }

        public boolean isExpressionActionsVisible() {
            return this.m_bExpressionActionsVisible;
        }

        public void setHiddenExpressionActions(int[] aHiddenExpressionActions) {
            this.m_aHiddenExpressionActions = aHiddenExpressionActions;
        }

        public int[] getHiddenExpressionActions() {
            return this.m_aHiddenExpressionActions;
        }

        public boolean isActionHidden(int eAction) {
            for (int iAction = 0; iAction < this.m_aHiddenExpressionActions.length; ++iAction) {
                if (this.m_aHiddenExpressionActions[iAction] != eAction) continue;
                return true;
            }
            return false;
        }

        public void setUseSQLSyntax(boolean bUseSQLSyntax) {
            this.m_bUseSQLSyntax = bUseSQLSyntax;
        }

        public boolean isUsingSQLSyntax() {
            return this.m_bUseSQLSyntax;
        }

        public void setHiddenColumnsInSourceColumnsTable(int[] aHiddenColumnIndexes) {
            this.m_aHiddenColumnsInSourceColumnsTable = aHiddenColumnIndexes;
        }

        public int[] getHiddenColumnsInSourceColumnsTable() {
            return this.m_aHiddenColumnsInSourceColumnsTable;
        }

        public void setHiddenColumnsInTargetColumnsTable(int[] aHiddenColumnIndexes) {
            this.m_aHiddenColumnsInTargetColumnsTable = aHiddenColumnIndexes;
        }

        public int[] getHiddenColumnsInTargetColumnsTable() {
            return this.m_aHiddenColumnsInTargetColumnsTable;
        }

        public void setSourceTableLabel(String sLabel) {
            this.m_sSourceTableLabel = sLabel;
        }

        public String getSourceTableLabel() {
            return this.m_sSourceTableLabel;
        }

        public void setTargetTableLabel(String sLabel) {
            this.m_sTargetTableLabel = sLabel;
        }

        public String getTargetTableLabel() {
            return this.m_sTargetTableLabel;
        }

        public void setSettingsKeyPrefix(String sKeyPrefix) {
            this.m_sSettingsKeyPrefix = sKeyPrefix;
        }

        public String getSettingsKeyPrefix() {
            return this.m_sSettingsKeyPrefix;
        }

        public void setWhereUsedSettingsKeyPrefix(String sKeyPrefix) {
            this.m_sWhereUsedSettingsKeyPrefix = sKeyPrefix;
        }

        public String getWhereUsedSettingsKeyPrefix() {
            return this.m_sWhereUsedSettingsKeyPrefix;
        }

        public void setSourceTableSettingsKeyPrefix(String sKeyPrefix) {
            this.m_sSourceTableSettingsKeyPrefix = sKeyPrefix;
        }

        public String getSourceTableSettingsKeyPrefix() {
            return this.m_sSourceTableSettingsKeyPrefix;
        }

        public void setTargetTableSettingsKeyPrefix(String sKeyPrefix) {
            this.m_sTargetTableSettingsKeyPrefix = sKeyPrefix;
        }

        public String getTargetTableSettingsKeyPrefix() {
            return this.m_sTargetTableSettingsKeyPrefix;
        }

        public void setSourceTablesEditable(boolean bEditable) {
            this.m_bSourceTablesEditable = bEditable;
        }

        public boolean isSourceTablesEditable() {
            return this.m_bSourceTablesEditable;
        }

        public void setTargetTablesEditable(boolean bEditable) {
            this.m_bTargetTablesEditable = bEditable;
        }

        public boolean isTargetTablesEditable() {
            return this.m_bTargetTablesEditable;
        }

        public void setMappingsFilter(IFilter filter) {
            this.m_filter = filter;
        }

        public IFilter getMappingsFilter() {
            return this.m_filter;
        }
    }
}

