/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IFilter;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingsContainer;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.wadmin.visuals.common.SourceColumnsTableModel;
import com.sas.wadmin.visuals.common.TargetColumnsTableModel;
import com.sas.workspace.WsDefaultObjectListModel;
import com.sas.workspace.WsMapping;

public class MappingsModel
extends WsDefaultObjectListModel {
    private IMappingsContainer m_container;
    private SourceColumnsTableModel m_mdlSourceColumns;
    private TargetColumnsTableModel m_mdlTargetColumns;
    private IFilter m_filter;
    private IModelListener m_lsnrModel;

    public MappingsModel(IMappingsContainer container, SourceColumnsTableModel mdlSourceColumns, TargetColumnsTableModel mdlTargetColumns) {
        this.m_container = container;
        this.m_mdlSourceColumns = mdlSourceColumns;
        this.m_mdlTargetColumns = mdlTargetColumns;
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public void setMappingsFilter(IFilter filter) {
        this.m_filter = filter;
    }

    public IFilter getMappingsFilter() {
        return this.m_filter;
    }

    public void moveDataToModel() {
        this.removeAll();
        IMapping[] aMappings = this.m_container.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping])) continue;
            this.addMapping(aMappings[iMapping]);
        }
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        WsMapping pair = (WsMapping)obj;
        if (pair.isTemporary()) {
            super.add((Object)pair);
        } else {
            IColumn source = this.m_mdlSourceColumns.getSourceColumn(pair.getSource());
            IColumn target = this.m_mdlTargetColumns.getTargetColumn(pair.getTarget());
            IMapping mapping = this.m_mdlTargetColumns.getMapping(pair.getTarget());
            if (mapping == null) {
                this.m_container.addMapping(new IColumn[]{source}, new IColumn[]{target});
            } else {
                this.m_container.getModel().startCompoundUndoable();
                try {
                    mapping.addSource(source);
                }
                finally {
                    this.m_container.getModel().endCompoundUndoable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object obj) {
        WsMapping pair = (WsMapping)obj;
        if (pair.isTemporary()) {
            super.remove((Object)pair);
        } else {
            this.m_container.getModel().startCompoundUndoable();
            try {
                PairingDataObject pdo = (PairingDataObject)pair.getDataObject();
                IColumn source = pdo.m_colSource;
                IMapping mapping = pdo.m_mapping;
                mapping.removeSource(source);
            }
            finally {
                this.m_container.getModel().endCompoundUndoable();
            }
        }
    }

    public void remove(int iObj) {
        this.remove(this.get(iObj));
    }

    private void addMapping(IMapping mapping) {
        if (!this.m_filter.pass((Object)mapping)) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        IColumn[] aTargets = mapping.getTargets();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            int iSourceRow = this.m_mdlSourceColumns.getRowIndex(aSources[iSource]);
            if (iSourceRow == -1) continue;
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                int iTargetRow = this.m_mdlTargetColumns.getRowIndex(aTargets[iTarget]);
                if (iTargetRow == -1) continue;
                super.add((Object)this.createPairing(iSourceRow, aSources[iSource], iTargetRow, aTargets[iTarget], mapping));
            }
        }
    }

    private void removeMapping(IMapping mapping) {
        if (!this.m_filter.pass((Object)mapping)) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        IColumn[] aTargets = mapping.getTargets();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
                this.removePairing(aSources[iSource], aTargets[iTarget], mapping);
            }
        }
    }

    private void addPairingsForSourceColumnInMapping(IMapping mapping, IColumn column) {
        int iSourceRow = this.m_mdlSourceColumns.getRowIndex(column);
        if (iSourceRow == -1) {
            return;
        }
        IColumn[] aTargets = mapping.getTargets();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            int iTargetRow = this.m_mdlTargetColumns.getRowIndex(aTargets[iTarget]);
            if (iTargetRow == -1) continue;
            super.add((Object)this.createPairing(iSourceRow, column, iTargetRow, aTargets[iTarget], mapping));
        }
    }

    private void addPairingsForTargetColumnInMapping(IMapping mapping, IColumn column) {
        int iTargetRow = this.m_mdlTargetColumns.getRowIndex(column);
        if (iTargetRow == -1) {
            return;
        }
        IColumn[] aSources = mapping.getSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            int iSourceRow = this.m_mdlSourceColumns.getRowIndex(aSources[iSource]);
            if (iSourceRow == -1) continue;
            super.add((Object)this.createPairing(iSourceRow, aSources[iSource], iTargetRow, column, mapping));
        }
    }

    private void removePairingsForSourceColumnInMapping(IMapping mapping, IColumn column) {
        IColumn[] aTargets = mapping.getTargets();
        for (int iTarget = 0; iTarget < aTargets.length; ++iTarget) {
            this.removePairing(column, aTargets[iTarget], mapping);
        }
    }

    private void removePairingsForTargetColumnInMapping(IMapping mapping, IColumn column) {
        IColumn[] aSources = mapping.getSources();
        for (int iSource = 0; iSource < aSources.length; ++iSource) {
            this.removePairing(aSources[iSource], column, mapping);
        }
    }

    private void addPairingsForSourceColumn(IColumn col) {
        IMapping[] aMappings = this.m_container.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInSources(col)) continue;
            this.addPairingsForSourceColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void addPairingsForTargetColumn(IColumn col) {
        IMapping[] aMappings = this.m_container.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInTargets(col)) continue;
            this.addPairingsForTargetColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void removePairingsForSourceColumn(IColumn col) {
        IMapping[] aMappings = this.m_container.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInSources(col)) continue;
            this.removePairingsForSourceColumnInMapping(aMappings[iMapping], col);
        }
    }

    private void removePairingsForTargetColumn(IColumn col) {
        IMapping[] aMappings = this.m_container.getMappings();
        for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
            if (!this.m_filter.pass((Object)aMappings[iMapping]) || !aMappings[iMapping].containsInTargets(col)) continue;
            this.removePairingsForTargetColumnInMapping(aMappings[iMapping], col);
        }
    }

    private boolean isSourceTable(ITable tbl) {
        ITable[] aTables = this.m_container.getSourceTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != tbl) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetTable(ITable tbl) {
        ITable[] aTables = this.m_container.getTargetTables();
        for (int iTable = 0; iTable < aTables.length; ++iTable) {
            if (aTables[iTable] != tbl) continue;
            return true;
        }
        return false;
    }

    private WsMapping createPairing(int iSourceRow, IColumn colSource, int iTargetRow, IColumn colTarget, IMapping mapping) {
        WsMapping pairing = new WsMapping(iSourceRow, iTargetRow);
        pairing.setDataObject((Object)new PairingDataObject(colSource, colTarget, mapping));
        return pairing;
    }

    private WsMapping removePairing(IColumn colSource, IColumn colTarget, IMapping mapping) {
        for (int iPairing = 0; iPairing < this.size(); ++iPairing) {
            WsMapping pairing = (WsMapping)this.get(iPairing);
            PairingDataObject pdo = (PairingDataObject)pairing.getDataObject();
            if (pdo.m_colSource != colSource || pdo.m_colTarget != colTarget || pdo.m_mapping != mapping) continue;
            super.remove(iPairing);
            return pairing;
        }
        return null;
    }

    private static class PairingDataObject {
        IColumn m_colSource;
        IColumn m_colTarget;
        IMapping m_mapping;

        PairingDataObject(IColumn colSource, IColumn colTarget, IMapping mapping) {
            this.m_colSource = colSource;
            this.m_colTarget = colTarget;
            this.m_mapping = mapping;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                MappingsModel.this.moveDataToModel();
            } else if (obj == MappingsModel.this.m_container) {
                if (sType == "MappingsContainer:MappingAdded") {
                    MappingsModel.this.addMapping((IMapping)ev.getData());
                } else if (sType == "MappingsContainer:MappingRemoved") {
                    MappingsModel.this.removeMapping((IMapping)ev.getData());
                } else if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataTargetAdded") {
                    MappingsModel.this.moveDataToModel();
                }
            } else if (MappingsModel.this.m_container instanceof ISelectResultsContainer && ((ISelectResultsContainer)MappingsModel.this.m_container).getParentQuery().getTransformModel() == obj) {
                if (sType == "DataTransform.DataSourceAdded" || sType == "DataTransform.DataTargetAdded") {
                    MappingsModel.this.moveDataToModel();
                }
            } else if (obj instanceof ITable) {
                if (MappingsModel.this.isSourceTable((ITable)obj)) {
                    if (sType == "Table:ColumnAdded") {
                        MappingsModel.this.addPairingsForSourceColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        MappingsModel.this.removePairingsForSourceColumn((IColumn)ev.getData());
                        MappingsModel.this.addPairingsForSourceColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        MappingsModel.this.removePairingsForSourceColumn((IColumn)ev.getData());
                    }
                } else if (MappingsModel.this.isTargetTable((ITable)obj)) {
                    if (sType == "Table:ColumnAdded") {
                        MappingsModel.this.addPairingsForTargetColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnMoved") {
                        MappingsModel.this.removePairingsForTargetColumn((IColumn)ev.getData());
                        MappingsModel.this.addPairingsForTargetColumn((IColumn)ev.getData());
                    } else if (sType == "Table:ColumnRemoved") {
                        MappingsModel.this.removePairingsForTargetColumn((IColumn)ev.getData());
                    }
                }
            } else if (obj instanceof IMapping) {
                IMapping mapping = (IMapping)obj;
                if (!MappingsModel.this.m_filter.pass((Object)mapping) || !MappingsModel.this.m_container.containsMapping(mapping)) {
                    return;
                }
                if (sType == "Mapping:SourceColumnAdded") {
                    MappingsModel.this.addPairingsForSourceColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnAdded") {
                    MappingsModel.this.addPairingsForTargetColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:SourceColumnRemoved") {
                    MappingsModel.this.removePairingsForSourceColumnInMapping(mapping, (IColumn)ev.getData());
                } else if (sType == "Mapping:TargetColumnRemoved") {
                    MappingsModel.this.removePairingsForTargetColumnInMapping(mapping, (IColumn)ev.getData());
                }
            }
        }
    }
}

