/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class KeysTreeModel
extends AbstractTreeModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(KeysTreeModel.class);
    private IPhysicalTable m_table;
    private CategoryTreeNode m_nodePrimary;
    private CategoryTreeNode m_nodeUnique;
    private CategoryTreeNode m_nodeForeign;
    private IModelListener m_lsnrModel;

    public KeysTreeModel(IPhysicalTable table) {
        super(Workspace.getWorkspace().getUserContext(), null);
        this.m_table = table;
        cRootNode treeRoot = new cRootNode();
        treeRoot.setTreeModel((ITreeModel)this);
        treeRoot.setSorted(false);
        this.setRoot((TreeNode)((Object)treeRoot));
        this.initialize();
    }

    private void initialize() {
        cRootNode nodeRoot = (cRootNode)((Object)this.getRoot());
        this.m_nodePrimary = new CategoryTreeNode((Object)bundle.getString("KeysTreeModel.PrimaryKey.txt"));
        this.m_nodePrimary.setSorted(false);
        this.addChild((ITreeNode)this.m_nodePrimary, (ITreeNode)nodeRoot);
        this.m_nodeUnique = new CategoryTreeNode((Object)bundle.getString("KeysTreeModel.UniqueKey.txt"));
        this.m_nodeUnique.setSorted(false);
        this.addChild((ITreeNode)this.m_nodeUnique, (ITreeNode)nodeRoot);
        this.m_nodeForeign = new CategoryTreeNode((Object)bundle.getString("KeysTreeModel.ForeignKey.txt"));
        this.m_nodeForeign.setSorted(false);
        this.addChild((ITreeNode)this.m_nodeForeign, (ITreeNode)nodeRoot);
        this.m_lsnrModel = new ModelListener();
        this.m_table.getModel().addModelListener(this.m_lsnrModel);
    }

    public void moveDataToModel() {
        IKey[] uniqueKeys = this.m_table.getKeys();
        for (int iKey = 0; iKey < uniqueKeys.length; ++iKey) {
            IKey oKey = uniqueKeys[iKey];
            cUniqueKeyNode nodeKey = new cUniqueKeyNode(oKey);
            if (oKey.isPrimary()) {
                this.addChild((ITreeNode)nodeKey, (ITreeNode)this.m_nodePrimary);
                continue;
            }
            this.addChild((ITreeNode)nodeKey, (ITreeNode)this.m_nodeUnique);
        }
        IForeignKey[] foreignKeys = this.m_table.getForeignKeys();
        for (int iKey = 0; iKey < foreignKeys.length; ++iKey) {
            IForeignKey oKey = foreignKeys[iKey];
            cForeignKeyNode nodeKey = new cForeignKeyNode(oKey);
            this.addChild((ITreeNode)nodeKey, (ITreeNode)this.m_nodeForeign);
        }
    }

    public void dispose() {
        super.dispose();
        this.m_table.getModel().removeModelListener(this.m_lsnrModel);
    }

    public CategoryTreeNode getPrimaryNode() {
        return this.m_nodePrimary;
    }

    public CategoryTreeNode getUniqueNode() {
        return this.m_nodeUnique;
    }

    public CategoryTreeNode getForeignNode() {
        return this.m_nodeForeign;
    }

    public void addChild(IDataTreeNode newNode) {
    }

    public void addChildren(ITreeNode parentNode) {
    }

    public List findParentNodes(SimpleBrowseObject object) {
        return null;
    }

    public boolean isValidParent(ITreeNode parentNode, ITreeNode childNode) {
        return false;
    }

    private class cForeignKeyNode
    extends AbstractTreeNode
    implements IDataTreeNode {
        private IForeignKey m_key;

        public cForeignKeyNode(IForeignKey key) {
            super((Object)key.getName(), false);
            this.m_key = key;
        }

        public Icon getIcon() {
            return AppIconFactory.getInstance().getIconForPrivateType("Type:ForeignKey");
        }

        public boolean isFolder() {
            return false;
        }

        public String getType() {
            return null;
        }

        public boolean isEditable() {
            return true;
        }

        public boolean isValidDropTarget() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public Object getData() {
            return this.m_key;
        }

        public String getID() {
            return this.m_key.getID();
        }

        public boolean isDeleteAllowed() {
            return false;
        }

        public boolean isRenameAllowed() {
            return true;
        }

        public boolean isValidName(String sNewName) {
            return sNewName.trim().length() > 0;
        }

        public void rename(String sNewName) {
            this.m_key.setName(sNewName);
            this.setUserObject(sNewName);
        }

        public void update() {
        }

        public String getName() {
            return this.m_key.getName();
        }
    }

    private class cUniqueKeyNode
    extends AbstractTreeNode
    implements IDataTreeNode {
        private IKey m_key;

        public cUniqueKeyNode(IKey key) {
            super((Object)key.getName(), false);
            this.m_key = key;
        }

        public Icon getIcon() {
            if (this.m_key.isPrimary()) {
                return AppIconFactory.getInstance().getIconForPrivateType("Type:PrimaryKey");
            }
            return AppIconFactory.getInstance().getIconForPrivateType("Type:UniqueKey");
        }

        public boolean isFolder() {
            return false;
        }

        public String getType() {
            return null;
        }

        public boolean isEditable() {
            return true;
        }

        public boolean isValidDropTarget() {
            return false;
        }

        public boolean delete() {
            return false;
        }

        public Object getData() {
            return this.m_key;
        }

        public String getID() {
            return this.m_key.getID();
        }

        public boolean isDeleteAllowed() {
            return false;
        }

        public boolean isRenameAllowed() {
            return true;
        }

        public boolean isValidName(String sNewName) {
            return sNewName.trim().length() > 0;
        }

        public void rename(String sNewName) {
            this.m_key.setName(sNewName);
            this.setUserObject(sNewName);
        }

        public void update() {
        }

        public String getName() {
            return this.m_key.getName();
        }
    }

    private class cRootNode
    extends AbstractTreeNode {
        public cRootNode() {
            super((Object)"KeysRoot");
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isFolder() {
            return true;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (ev.getModelObject() == KeysTreeModel.this.m_table && sType == "PhysicalTable:KeyAdded") {
                IKey oKey = (IKey)ev.getData();
                cUniqueKeyNode node = new cUniqueKeyNode(oKey);
                KeysTreeModel.this.addChild((ITreeNode)node, (ITreeNode)(oKey.isPrimary() ? KeysTreeModel.this.getPrimaryNode() : KeysTreeModel.this.getUniqueNode()));
            } else if (ev.getModelObject() == KeysTreeModel.this.m_table && sType == "PhysicalTable:KeyRemoved") {
                IKey oKey = (IKey)ev.getData();
                List lNodes = KeysTreeModel.this.findNodes(oKey.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IDataTreeNode node = (IDataTreeNode)lNodes.get(0);
                KeysTreeModel.this.removeChild((ITreeNode)node);
            } else if (ev.getModelObject() == KeysTreeModel.this.m_table && sType == "PhysicalTable:ForeignKeyAdded") {
                IForeignKey oKey = (IForeignKey)ev.getData();
                cForeignKeyNode node = new cForeignKeyNode(oKey);
                KeysTreeModel.this.addChild((ITreeNode)node, (ITreeNode)KeysTreeModel.this.getForeignNode());
            } else if (ev.getModelObject() == KeysTreeModel.this.m_table && sType == "PhysicalTable:ForeignKeyRemoved") {
                IForeignKey oKey = (IForeignKey)ev.getData();
                List lNodes = KeysTreeModel.this.findNodes(oKey.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IDataTreeNode node = (IDataTreeNode)lNodes.get(0);
                KeysTreeModel.this.removeChild((ITreeNode)node);
            } else if (sType == "Object:NameChanged" && ev.getModelObject() instanceof IKey) {
                IKey oKey = (IKey)ev.getModelObject();
                List lNodes = KeysTreeModel.this.findNodes(oKey.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IDataTreeNode node = (IDataTreeNode)lNodes.get(0);
                node.rename(oKey.getName());
                KeysTreeModel.this.nodeChanged((TreeNode)node);
            } else if (sType == "Object:NameChanged" && ev.getModelObject() instanceof IForeignKey) {
                IForeignKey oKey = (IForeignKey)ev.getModelObject();
                List lNodes = KeysTreeModel.this.findNodes(oKey.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IDataTreeNode node = (IDataTreeNode)lNodes.get(0);
                node.rename(oKey.getName());
                KeysTreeModel.this.nodeChanged((TreeNode)node);
            }
        }
    }
}

