/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.data.impl.BaseKey;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.transforms.scd.ColumnSelectorPanel;
import com.sas.wadmin.visuals.common.AssociatedForeignKeysTableModel;
import com.sas.wadmin.visuals.common.ForeignKeyColumnsTableModel;
import com.sas.wadmin.visuals.common.KeysTree;
import com.sas.wadmin.visuals.common.KeysTreeModel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.PartnerKeyPanel;
import com.sas.wadmin.visuals.common.UniqueKeyColumnsTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUndoManager;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class KeysTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(KeysTab.class);
    public static final String CONTEXT = "KeysTab";
    private static final String SETTINGS_DETAILS_PREFIX = "KeysTab.Details";
    private static final String SETTINGS_ASSOC_PREFIX = "KeysTab.Assoc";
    private IPhysicalTable m_table;
    private int m_iKeys;
    private KeysTree m_treeKeys;
    private KeysTreeModel m_mdlKeysTree;
    private JToolBar m_barTools;
    private JPanel m_pnlTree;
    private JSplitPane m_pnlDetails;
    private JPanel m_pnlColumns;
    private JPanel m_pnlAssociations;
    private JPanel m_pnlMoveButtons;
    private JPanel m_pnlChangeButtons;
    private JScrollPane m_scrTree;
    private JScrollPane m_scrTable;
    private JScrollPane m_scrAssoc;
    private WsTable m_tblCurrentColumns;
    private IObject m_keyCurrent;
    private JButton m_btnMoveUp;
    private JButton m_btnMoveDown;
    private JButton m_btnAdd;
    private JButton m_btnRemove;
    private JPopupMenu m_mnuPrimaryCategoryNode;
    private JPopupMenu m_mnuUniqueCategoryNode;
    private JPopupMenu m_mnuForeignCategoryNode;
    private JPopupMenu m_mnuKeyNode;
    private WsDropMenuAction m_actNew;
    private WsAbstractAction m_actNewPrimaryKey;
    private WsAbstractAction m_actNewUniqueKey;
    private WsAbstractAction m_actNewForeignKey;
    private WsAbstractAction m_actNewPrimaryKeyPopup;
    private WsAbstractAction m_actNewUniqueKeyPopup;
    private WsAbstractAction m_actNewForeignKeyPopup;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actRename;
    private WsAbstractAction m_actUndo;
    private WsAbstractAction m_actRedo;
    private WsAbstractAction m_actMoveUp;
    private WsAbstractAction m_actMoveDown;
    private WsAbstractAction m_actAdd;
    private WsAbstractAction m_actRemove;
    private ChangeListener m_lsnrUndo;
    private ListSelectionListener m_lsnrTable;
    private WsPopupMenuRequestListener m_lsnrPopupMenu;
    private Map m_mapKeyToTbl;
    private Map m_mapKeyToAssoc;
    private int m_dividerLocation;

    public KeysTab(IPhysicalTable table) {
        this.m_table = table;
        this.initialize();
        this.setName(bundle.getString("KeysTab.Name.txt"));
        this.setHelpProduct("wdb");
        this.setHelpTopic("keys_tab");
    }

    protected void initialize() {
        this.m_mapKeyToTbl = new HashMap();
        this.m_mapKeyToAssoc = new HashMap();
        this.createActions();
        this.createToolBar();
        this.createTree();
        this.createTreePanel();
        this.createDetailsPanel();
        this.layoutComponents();
        this.updateActions();
    }

    private void createActions() {
        this.m_actNew = new NewAction();
        this.m_actNewPrimaryKey = new NewPrimaryKeyAction();
        this.m_actNewUniqueKey = new NewUniqueKeyAction();
        this.m_actNewForeignKey = new NewForeignKeyAction();
        JPopupMenu mnuNew = new JPopupMenu();
        mnuNew.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewPrimaryKey));
        mnuNew.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewUniqueKey));
        mnuNew.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewForeignKey));
        this.m_actNew.setDropMenu(mnuNew);
        this.m_actNewPrimaryKeyPopup = new NewPrimaryKeyPopupAction();
        this.m_actNewUniqueKeyPopup = new NewUniqueKeyPopupAction();
        this.m_actNewForeignKeyPopup = new NewForeignKeyPopupAction();
        this.m_actDelete = new DeleteAction();
        this.m_actRename = new RenameAction();
        this.m_actUndo = new UndoAction();
        this.m_actRedo = new RedoAction();
        this.m_mnuPrimaryCategoryNode = new JPopupMenu();
        this.m_mnuPrimaryCategoryNode.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewPrimaryKeyPopup));
        this.m_mnuUniqueCategoryNode = new JPopupMenu();
        this.m_mnuUniqueCategoryNode.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewUniqueKeyPopup));
        this.m_mnuForeignCategoryNode = new JPopupMenu();
        this.m_mnuForeignCategoryNode.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actNewForeignKeyPopup));
        this.m_mnuKeyNode = new JPopupMenu();
        this.m_mnuKeyNode.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actDelete));
        this.m_mnuKeyNode.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actRename));
        this.m_actMoveUp = new MoveUpAction();
        this.m_actMoveDown = new MoveDownAction();
        this.m_actAdd = new AddAction();
        this.m_actRemove = new RemoveAction();
        this.m_lsnrTable = new KeysTableSelectionListener();
        this.m_lsnrPopupMenu = new KeysTreePopupMenuListener();
    }

    private void createToolBar() {
        this.m_barTools = WsUIUtilities.createToolBar();
        this.m_barTools.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)this.m_actNew));
        this.m_barTools.addSeparator();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actUndo));
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actRedo));
        this.m_barTools.addSeparator();
        this.m_barTools.add(WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDelete));
    }

    private void createTree() {
        this.m_mdlKeysTree = new KeysTreeModel(this.m_table);
        this.m_treeKeys = new KeysTree(this.m_mdlKeysTree);
        this.m_scrTree = new JScrollPane((Component)((Object)this.m_treeKeys));
        this.m_treeKeys.getActionMap().put("delete", (Action)this.m_actDelete);
        this.m_treeKeys.addTreeSelectionListener(new KeysTreeSelectionListener());
        this.m_treeKeys.setPopupMenuRequestListener(this.m_lsnrPopupMenu);
    }

    private void createTreePanel() {
        this.m_pnlTree = new JPanel();
        JLabel lblTree = WsUIUtilities.createLabelForComponent((JComponent)((Object)this.m_treeKeys), (String)bundle.getString("KeysTab.Tree.Label.txt"));
        this.m_pnlTree.setLayout(new GridBagLayout());
        this.m_pnlTree.add((Component)lblTree, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlTree.add((Component)this.m_scrTree, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void createDetailsPanel() {
        JLabel lblDetails = new JLabel(bundle.getString("KeysTab.Details.txt"));
        this.m_scrTable = new JScrollPane();
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnAdd = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAdd);
        this.m_btnRemove = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actRemove);
        this.m_pnlMoveButtons = new JPanel((LayoutManager)new WsButtonsLayout(0, 2));
        this.m_pnlMoveButtons.add(this.m_btnMoveUp);
        this.m_pnlMoveButtons.add(this.m_btnMoveDown);
        this.m_pnlChangeButtons = new JPanel((LayoutManager)new WsButtonsLayout(0, 4));
        this.m_pnlChangeButtons.add(this.m_btnAdd);
        this.m_pnlChangeButtons.add(this.m_btnRemove);
        this.m_pnlColumns = new JPanel();
        this.m_pnlColumns.setLayout(new GridBagLayout());
        this.m_pnlColumns.add((Component)lblDetails, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.m_pnlColumns.add((Component)this.m_scrTable, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.m_pnlColumns.add((Component)this.m_pnlMoveButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 2, 5), 0, 0));
        this.m_pnlColumns.add((Component)this.m_pnlChangeButtons, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 2), 0, 0));
        this.m_pnlAssociations = new JPanel();
        this.m_scrAssoc = new JScrollPane();
        JLabel lblAssoc = WsUIUtilities.createLabelForComponent((JComponent)this.m_scrAssoc, (String)bundle.getString("KeysTab.AssociatedForeignKeys.txt"));
        this.m_pnlAssociations.setLayout(new GridBagLayout());
        this.m_pnlAssociations.add((Component)lblAssoc, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
        this.m_pnlAssociations.add((Component)this.m_scrAssoc, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.m_pnlDetails = new JSplitPane(0);
        this.m_pnlDetails.setBorder(null);
        this.m_pnlDetails.setResizeWeight(0.75);
        this.m_pnlDetails.setDividerLocation(300);
        this.m_pnlDetails.add((Component)this.m_pnlColumns, "top");
        this.m_pnlDetails.add((Component)this.m_pnlAssociations, "bottom");
    }

    private void initializeUndo() {
        if (this.m_lsnrUndo != null) {
            return;
        }
        WsUndoManager mgrUndo = (WsUndoManager)this.m_table.getModel().getUndoManager();
        this.m_lsnrUndo = new UndoManagerListener();
        mgrUndo.addChangeListener(this.m_lsnrUndo);
        this.m_actUndo.setEnabled(mgrUndo.canUndo());
        this.m_actRedo.setEnabled(mgrUndo.canRedo());
    }

    private void layoutComponents() {
        JSplitPane pnlCenter = new JSplitPane(1);
        pnlCenter.add((Component)this.m_pnlTree, "left");
        pnlCenter.add((Component)this.m_pnlDetails, "right");
        pnlCenter.setResizeWeight(0.25);
        pnlCenter.setDividerLocation(275);
        this.setLayout(new BorderLayout());
        this.add(this.m_barTools, "North");
        this.add(pnlCenter, "Center");
    }

    public void moveDataToView() {
        this.m_mdlKeysTree.moveDataToModel();
        this.m_iKeys = this.m_table.getKeysList().size();
        this.initializeUndo();
        this.updateActions();
        this.updateComponents();
        this.m_treeKeys.expandAll();
    }

    public void saveSettingsAndCleanUp() {
        TableModel tableModel;
        WsTable table;
        IKey[] aKeys = this.m_table.getKeys();
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            WsTable table2;
            IKey key = aKeys[iKey];
            if (this.m_mapKeyToTbl.containsKey(key)) {
                table2 = (WsTable)this.m_mapKeyToTbl.get(key);
                table2.saveSettings("KeysTab.Details." + key.getName());
            }
            if (!this.m_mapKeyToAssoc.containsKey(key)) continue;
            table2 = (WsTable)this.m_mapKeyToAssoc.get(key);
            table2.saveSettings("KeysTab.Assoc." + key.getName());
        }
        IForeignKey[] aForeignKeys = this.m_table.getForeignKeys();
        for (int iKey = 0; iKey < aForeignKeys.length; ++iKey) {
            IForeignKey key = aForeignKeys[iKey];
            if (!this.m_mapKeyToTbl.containsKey(key)) continue;
            WsTable table3 = (WsTable)this.m_mapKeyToTbl.get(key);
            table3.saveSettings("KeysTab.Details." + key.getName());
        }
        this.m_mdlKeysTree.dispose();
        this.m_treeKeys.dispose();
        IModel mdl = this.m_table.getModel();
        ((WsUndoManager)mdl.getUndoManager()).removeChangeListener(this.m_lsnrUndo);
        for (Object object : this.m_mapKeyToTbl.values()) {
            if (!(object instanceof WsTable)) continue;
            table = (WsTable)object;
            tableModel = table.getModel();
            if (tableModel instanceof ForeignKeyColumnsTableModel) {
                ((ForeignKeyColumnsTableModel)((Object)tableModel)).dispose();
                continue;
            }
            if (tableModel instanceof AssociatedForeignKeysTableModel) {
                ((AssociatedForeignKeysTableModel)((Object)tableModel)).dispose();
                continue;
            }
            if (!(tableModel instanceof UniqueKeyColumnsTableModel)) continue;
            ((UniqueKeyColumnsTableModel)((Object)tableModel)).dispose();
        }
        for (Object object : this.m_mapKeyToAssoc.values()) {
            if (!(object instanceof WsTable)) continue;
            table = (WsTable)object;
            tableModel = table.getModel();
            if (tableModel instanceof ForeignKeyColumnsTableModel) {
                ((ForeignKeyColumnsTableModel)((Object)tableModel)).dispose();
                continue;
            }
            if (tableModel instanceof AssociatedForeignKeysTableModel) {
                ((AssociatedForeignKeysTableModel)((Object)tableModel)).dispose();
                continue;
            }
            if (!(tableModel instanceof UniqueKeyColumnsTableModel)) continue;
            ((UniqueKeyColumnsTableModel)((Object)tableModel)).dispose();
        }
    }

    public boolean validateData() {
        this.m_treeKeys.stopEditing();
        IKey[] aKeys = this.m_table.getKeys();
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            IKey key = aKeys[iKey];
            IColumn[] aCols = key.getColumns();
            if (aCols != null && aCols.length != 0) continue;
            MessageUtil.displayMessage((String)bundle.formatString("KeysTab.Error.NoColumns.txt", (Object)key.getName()), (int)0);
            return false;
        }
        ArrayList<String> invalidForeignKeys = new ArrayList<String>();
        try {
            IForeignKey[] aForeignKeys = this.m_table.getForeignKeys();
            for (int iKey = 0; iKey < aForeignKeys.length; ++iKey) {
                IColumn[] aUniqueKeyCols;
                IColumn[] aForeignKeyCols;
                IForeignKey key = aForeignKeys[iKey];
                IKey uniqueKey = key.loadPartnerKeyFromOMR();
                if (uniqueKey == null) {
                    invalidForeignKeys.add(key.getName());
                    continue;
                }
                if (key.isComplete() || (aForeignKeyCols = key.getColumns()).length == (aUniqueKeyCols = uniqueKey.getColumns()).length) continue;
                MessageUtil.displayMessage((String)bundle.formatString("KeysTab.Error.AssociatedColumns.txt", (Object)key.getName()), (int)0);
                return false;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        if (invalidForeignKeys.size() == 1) {
            MessageUtil.displayMessage((String)bundle.formatString("KeysTab.Error.NoPartnerKey.txt", invalidForeignKeys.get(0)), (int)2);
        } else if (invalidForeignKeys.size() > 1) {
            MessageUtil.displayListMessage((String)bundle.getString("KeysTab.Error.NoPartnerKeys.txt"), invalidForeignKeys, (String)bundle.getString("KeysTab.Error.NoPartnerKeys.Title.txt"), (int)2, (int)-1);
        }
        return true;
    }

    protected boolean hasPartnerKey(IForeignKey foreignKey) {
        IKey partnerKey = null;
        try {
            partnerKey = foreignKey.loadPartnerKeyFromOMR();
            return partnerKey != null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            return false;
        }
    }

    public static boolean isKeyNameUnique(IPhysicalTable table, String name, IObject ignoreKey) {
        IKey[] keys = table.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == ignoreKey || !keys[i].getName().equals(name)) continue;
            return false;
        }
        IForeignKey[] foreignKeys = table.getForeignKeys();
        for (int i = 0; i < foreignKeys.length; ++i) {
            if (foreignKeys[i] == ignoreKey || !foreignKeys[i].getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private void setCurrentKey(IObject object) {
        IForeignKey foreignKey;
        if (object == this.m_keyCurrent) {
            return;
        }
        WsTable tblCols = null;
        WsTable tblAssoc = null;
        if (this.m_mapKeyToTbl.containsKey(object)) {
            tblCols = (WsTable)this.m_mapKeyToTbl.get(object);
        } else {
            if (object instanceof IKey) {
                tblCols = this.createUniqueKeyColumnsTable((IKey)object);
            } else if (object instanceof IForeignKey) {
                tblCols = this.createForeignKeyColumnsTable((IForeignKey)object);
            }
            this.m_mapKeyToTbl.put(object, tblCols);
        }
        if (object instanceof IKey) {
            if (this.m_mapKeyToAssoc.containsKey(object)) {
                tblAssoc = (WsTable)this.m_mapKeyToAssoc.get(object);
            } else {
                tblAssoc = this.createAssociationsTable((IKey)object);
                this.m_mapKeyToAssoc.put(object, tblAssoc);
            }
            this.showAssociations((JComponent)tblAssoc);
        } else {
            this.showAssociations(null);
        }
        if (object instanceof IForeignKey && !this.hasPartnerKey(foreignKey = (IForeignKey)object)) {
            SwingUtilities.invokeLater(new NoPartnerKeyRunnable());
        }
        this.switchColumnsTables(tblCols);
        this.m_keyCurrent = object;
    }

    private void showAssociations(JComponent cmp) {
        this.m_scrAssoc.setViewportView(cmp);
        this.m_pnlAssociations.repaint();
        this.m_pnlAssociations.revalidate();
    }

    private WsTable createUniqueKeyColumnsTable(IKey key) {
        UniqueKeyColumnsTableModel mdlColumns = new UniqueKeyColumnsTableModel(key);
        WsTable tblColumns = new WsTable((WsAbstractTableModel)mdlColumns);
        tblColumns.setEditable(false);
        tblColumns.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        tblColumns.getSelectionModel().addListSelectionListener(this.m_lsnrTable);
        tblColumns.removeColumn(9);
        tblColumns.removeColumn(10);
        tblColumns.hideColumn(4);
        tblColumns.hideColumn(5);
        tblColumns.hideColumn(6);
        tblColumns.hideColumn(8);
        tblColumns.hideColumn(7);
        tblColumns.hideColumn(2);
        tblColumns.setAutoResizeMode(4);
        tblColumns.restoreSettings("KeysTab.Details." + key.getName());
        ((WsDefaultTableRowModel)tblColumns.getRowModel()).addRowModelListener((WsTableRowModelListener)new KeysTableRowListener());
        mdlColumns.moveDataToModel();
        return tblColumns;
    }

    private WsTable createForeignKeyColumnsTable(IForeignKey key) {
        ForeignKeyColumnsTableModel mdlColumns = new ForeignKeyColumnsTableModel(key);
        WsTable tblColumns = new WsTable((WsAbstractTableModel)mdlColumns);
        tblColumns.setEditable(this.isEditable());
        tblColumns.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        tblColumns.getSelectionModel().addListSelectionListener(this.m_lsnrTable);
        tblColumns.removeColumn(9);
        tblColumns.removeColumn(10);
        tblColumns.hideColumn(4);
        tblColumns.hideColumn(5);
        tblColumns.hideColumn(6);
        tblColumns.hideColumn(8);
        tblColumns.hideColumn(7);
        tblColumns.hideColumn(2);
        tblColumns.hideColumn(1);
        tblColumns.setAutoResizeMode(4);
        tblColumns.restoreSettings("KeysTab.Details." + key.getName());
        mdlColumns.setDialog(new ForeignKeysTableDialog());
        mdlColumns.moveDataToModel();
        return tblColumns;
    }

    private WsTable createAssociationsTable(IKey key) {
        AssociatedForeignKeysTableModel mdlAssoc = new AssociatedForeignKeysTableModel(key);
        WsTable tblAssoc = new WsTable((WsAbstractTableModel)mdlAssoc);
        tblAssoc.setEditable(false);
        tblAssoc.setRowHeaderVisible(false);
        tblAssoc.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        tblAssoc.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        tblAssoc.setAutoResizeMode(4);
        try {
            mdlAssoc.moveDataToModel();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        tblAssoc.restoreSettings("KeysTab.Assoc." + key.getName());
        return tblAssoc;
    }

    private void switchColumnsTables(WsTable tblColumns) {
        this.m_tblCurrentColumns = tblColumns;
        this.m_scrTable.setViewportView((Component)this.m_tblCurrentColumns);
    }

    private void showBlankColumnsPanel() {
        this.m_keyCurrent = null;
        this.m_tblCurrentColumns = null;
        this.m_scrTable.setViewportView(null);
        this.m_scrAssoc.setViewportView(null);
        this.m_pnlColumns.repaint();
        this.m_pnlColumns.revalidate();
        this.m_pnlAssociations.repaint();
        this.m_pnlAssociations.revalidate();
    }

    private void updateActions() {
        WsTable associationsTable;
        boolean bEditable = this.isEditable();
        boolean bPrimaryExists = this.m_table.getPrimaryKey() != null;
        boolean bAnyKeySelected = this.getSelectedKey() != null;
        boolean bUniqueKeySelected = bAnyKeySelected && this.getSelectedKey() instanceof IKey;
        int[] aRows = this.getSelectedTableRows();
        boolean bColumnSelected = this.getSelectedTableRows().length > 0;
        boolean bFirstSelected = bColumnSelected && aRows[0] == 0;
        boolean bLastSelected = bColumnSelected && aRows[aRows.length - 1] == this.m_tblCurrentColumns.getRowCount() - 1;
        boolean bSorted = bUniqueKeySelected && this.m_tblCurrentColumns != null && this.m_tblCurrentColumns.isSorted();
        boolean bHeld = bUniqueKeySelected && this.m_tblCurrentColumns != null && !this.m_tblCurrentColumns.getRowHeader().getHeldIndices().isEmpty();
        boolean bHasAssociations = false;
        if (this.getSelectedKey() instanceof IKey && (associationsTable = (WsTable)this.m_mapKeyToAssoc.get(this.getSelectedKey())) != null && associationsTable.getRowCount() > 0) {
            bHasAssociations = true;
        }
        this.m_actNewPrimaryKey.setEnabled(bEditable && !bPrimaryExists);
        this.m_actNewPrimaryKeyPopup.setEnabled(bEditable && !bPrimaryExists);
        this.m_actDelete.setEnabled(bEditable && bAnyKeySelected && !bHasAssociations);
        this.m_actNewUniqueKey.setEnabled(bEditable);
        this.m_actNewUniqueKeyPopup.setEnabled(bEditable);
        this.m_actNewForeignKey.setEnabled(bEditable);
        this.m_actNewForeignKeyPopup.setEnabled(bEditable);
        this.m_actRename.setEnabled(bEditable);
        this.m_actRemove.setEnabled(bEditable);
        this.m_actNew.setEnabled(bEditable);
        this.m_pnlChangeButtons.setVisible(bUniqueKeySelected);
        this.m_pnlMoveButtons.setVisible(bUniqueKeySelected);
        this.m_btnAdd.setEnabled(bEditable && !bHasAssociations);
        this.m_btnRemove.setEnabled(bEditable && bColumnSelected && !bHasAssociations);
        this.m_actMoveUp.setEnabled(bEditable && bColumnSelected && !bFirstSelected && !bSorted && !bHeld);
        this.m_actMoveDown.setEnabled(bEditable && bColumnSelected && !bLastSelected && !bSorted && !bHeld);
        if (bUniqueKeySelected && this.m_tblCurrentColumns != null) {
            this.m_tblCurrentColumns.setRowsReorderable(bEditable && !bSorted && !bHeld);
        }
    }

    private void updateComponents() {
        if (this.getSelectedKey() instanceof IForeignKey) {
            if (this.m_pnlAssociations.isVisible()) {
                this.m_dividerLocation = this.m_pnlDetails.getDividerLocation();
            }
            this.m_pnlAssociations.setVisible(false);
        } else {
            if (!this.m_pnlAssociations.isVisible()) {
                this.m_pnlAssociations.setVisible(true);
                this.m_pnlDetails.setDividerLocation(this.m_dividerLocation);
            }
            this.m_pnlAssociations.setVisible(true);
        }
    }

    private IObject getSelectedKey() {
        IDataTreeNode node = this.m_treeKeys.getSelectedDataNode();
        return node != null ? (IObject)node.getData() : null;
    }

    private int[] getSelectedTableRows() {
        if (this.m_tblCurrentColumns == null) {
            return new int[0];
        }
        return this.m_tblCurrentColumns.getSelectedRowsFromSelectedCells();
    }

    private void handlePopupRequest(int x, int y) {
        ITreeNode node = this.m_treeKeys.getSelectedNode();
        if (node instanceof IDataTreeNode) {
            this.m_mnuKeyNode.show((Component)((Object)this.m_treeKeys), x, y);
        } else if (node == this.m_mdlKeysTree.getPrimaryNode()) {
            this.m_mnuPrimaryCategoryNode.show((Component)((Object)this.m_treeKeys), x, y);
        } else if (node == this.m_mdlKeysTree.getUniqueNode()) {
            this.m_mnuUniqueCategoryNode.show((Component)((Object)this.m_treeKeys), x, y);
        } else if (node == this.m_mdlKeysTree.getForeignNode()) {
            this.m_mnuForeignCategoryNode.show((Component)((Object)this.m_treeKeys), x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newUniqueKey(boolean bPrimary) {
        this.m_table.getModel().startCompoundUndoable();
        try {
            IColumn[] aCols = this.promptForColumns(true);
            if (aCols == null) {
                return;
            }
            IKey key = this.m_table.getModel().getObjectFactory().createNewKey(this.m_table.getID());
            key.setPrimary(bPrimary);
            key.setName(this.generateNewKeyName(bPrimary));
            for (int iCol = 0; iCol < aCols.length; ++iCol) {
                if (key.getColumnsList().contains(aCols[iCol])) continue;
                key.getColumnsList().add(aCols[iCol]);
            }
            this.m_table.getKeysList().add(key);
            if (bPrimary) {
                IIndex index = KeysTab.getIndexUsingPrimaryKey(key, this.m_table);
                if (index == null) {
                    index = this.m_table.createNewIndex();
                    if (!(this.m_table.getDBMSType() instanceof SASType) && this.m_table.isIndexNameUnique("pk_" + index.getName())) {
                        index.setName("pk_" + index.getName());
                    }
                }
                if (aCols.length == 1 && this.m_table.getDBMSType() instanceof SASType) {
                    index.setName(aCols[0].getName());
                } else if (aCols.length > 1 && index.getName().equals(aCols[0].getName())) {
                    index.setName("pk_index");
                }
                for (int iCol = 0; iCol < aCols.length; ++iCol) {
                    if (index.getColumnsList().contains(aCols[iCol])) continue;
                    index.getColumnsList().add(aCols[iCol]);
                }
                index.setUnique(true);
            }
            AbstractTreeNode node = (AbstractTreeNode)this.m_mdlKeysTree.findNodes(key.getID()).get(0);
            TreePath pathIndex = new TreePath(node.getPath());
            this.m_treeKeys.setSelectionPath(pathIndex);
            this.m_treeKeys.scrollPathToVisible(pathIndex);
            this.m_treeKeys.startEditingAtPath(pathIndex);
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    private IColumn[] promptForColumns(boolean bMultipleSelections) {
        String title = bundle.formatString("KeysTab.ColumnsDialog.Title.txt", (Object)this.m_table.getName());
        String desc = bMultipleSelections ? bundle.getString("KeysTab.ColumnsDialog.Desc.txt") : bundle.getString("KeysTab.ColumnDialog.Desc.txt");
        ColumnSelectorPanel colSelector = new ColumnSelectorPanel((ITable)this.m_table, desc, bMultipleSelections);
        if (this.getSelectedKey() instanceof IForeignKey) {
            IForeignKey foreignKey = (IForeignKey)this.getSelectedKey();
            List excludeColumns = foreignKey.getColumnsList();
            WsTable table = (WsTable)this.m_mapKeyToTbl.get(foreignKey);
            int[] selectedRows = table.getSelectedRowsFromSelectedCells();
            for (int i = 0; i < selectedRows.length; ++i) {
                int index = table.convertRowIndexToModel(selectedRows[i]);
                IColumn partnerColumn = ((ForeignKeyColumnsTableModel)((Object)table.getModel())).getPartnerColumnForRow(index);
                IColumn[] columns = this.m_table.getColumns();
                for (int j = 0; j < columns.length; ++j) {
                    if (columns[j].getType() == partnerColumn.getType() || excludeColumns.contains(columns[j])) continue;
                    excludeColumns.add(columns[j]);
                }
            }
            if (excludeColumns.containsAll(Arrays.asList(foreignKey.getTable().getColumns()))) {
                MessageUtil.displayMessage((String)bundle.getString("KeysTab.Error.NoMatchingColumns.txt"), (int)0);
                return null;
            }
            colSelector.hideColumns(excludeColumns);
        }
        WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), title, true, (WAPanel)colSelector);
        dialog.setResizable(true);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            return colSelector.getSelectedColumns();
        }
        return null;
    }

    private void newForeignKey() {
        IForeignKey foreignKey = this.createForeignKey();
        if (foreignKey == null) {
            return;
        }
        IKey uniqueKey = foreignKey.getPartnerKey();
        if (uniqueKey instanceof BaseKey) {
            ((BaseKey)uniqueKey).addForeignKeyToAddedList(foreignKey);
        }
        this.m_treeKeys.editObject(foreignKey.getID());
    }

    private IForeignKey createForeignKey() {
        ForeignKeySelectorPanel panel = new ForeignKeySelectorPanel();
        String sImportDialogTitle = bundle.getString("KeysTab.TableSelector.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sImportDialogTitle, true, (WAPanel)panel);
        dlg.setResizable(true);
        dlg.setHelpProduct("wdb");
        dlg.setHelpTopic("select_tables_win");
        dlg.show();
        int response = dlg.getReturnValue();
        if (response == 1) {
            return panel.getForeignKey();
        }
        return null;
    }

    private IPhysicalTable loadTable(IModel mdl, SimpleObject object) throws RemoteException, MdException {
        IPhysicalTable table = mdl.getObjectFactory().createPhysicalTable(object.getID());
        mdl.loadFromOMR((IOMRPersistable)table, Workspace.getMdFactory());
        return table;
    }

    private IPhysicalTable loadTable(SimpleObject object) {
        IPhysicalTable table = null;
        IModel mdl = this.m_table.getModel();
        try {
            table = this.loadTable(mdl, object);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        return table;
    }

    private void deleteSelectedKey() {
        if (this.m_keyCurrent instanceof IKey) {
            int answer;
            IIndex oIndex;
            if (((IKey)this.m_keyCurrent).isPrimary() && (oIndex = KeysTab.getIndexUsingPrimaryKey((IKey)this.m_keyCurrent, this.m_table)) != null && (answer = MessageUtil.displayMessage((String)bundle.formatString("KeysTab.PKDeletePartnerIndex.txt", (Object)oIndex.getName()), (int)1, (int)0)) == 0) {
                this.m_table.getIndexesList().remove(oIndex);
            }
            this.m_table.getKeysList().remove(this.m_keyCurrent);
        } else if (this.m_keyCurrent instanceof IForeignKey) {
            try {
                IKey key = ((IForeignKey)this.m_keyCurrent).loadPartnerKeyFromOMR();
                if (key instanceof BaseKey) {
                    ((BaseKey)key).addForeignKeyToRemovedList((IForeignKey)this.m_keyCurrent);
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.m_table.getForeignKeysList().remove(this.m_keyCurrent);
        }
    }

    private String generateNewKeyName(boolean bPrimary) {
        String sName = null;
        while (!KeysTab.isKeyNameUnique(this.m_table, sName = bPrimary ? bundle.formatString("KeysTab.NewPrimaryKeyName.fmt.notrans", (Object)this.m_table.getName()) : bundle.formatString("KeysTab.NewUniqueKeyName.fmt.notrans", (Object)this.m_table.getName(), (Object)new Integer(++this.m_iKeys)), null)) {
        }
        return sName;
    }

    private String generateNewForeignKeyName(IPhysicalTable partnerKeyTable) {
        String sName = null;
        while (!KeysTab.isKeyNameUnique(this.m_table, sName = bundle.formatString("KeysTab.NewForeignKeyName.fmt.notrans", (Object)partnerKeyTable.getName(), (Object)this.m_table.getName(), (Object)new Integer(++this.m_iKeys)), null)) {
        }
        return sName;
    }

    private void renameCurrentNode() {
        AbstractTreeNode node = (AbstractTreeNode)this.m_treeKeys.getSelectedDataNode();
        TreePath pathIndex = new TreePath(node.getPath());
        this.m_treeKeys.startEditingAtPath(pathIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumns() {
        if (!(this.m_keyCurrent instanceof IKey)) {
            return;
        }
        IKey key = (IKey)this.m_keyCurrent;
        IColumn[] aCols = this.promptForColumns(true);
        if (aCols != null && aCols.length > 0) {
            this.m_table.getModel().startCompoundUndoable();
            try {
                IIndex index = KeysTab.getIndexUsingPrimaryKey(key, this.m_table);
                for (int iCol = 0; iCol < aCols.length; ++iCol) {
                    if (key.getColumnsList().contains(aCols[iCol])) continue;
                    key.getColumnsList().add(aCols[iCol]);
                    if (index == null) continue;
                    index.getColumnsList().add(aCols[iCol]);
                }
                if (index != null) {
                    IColumn[] aIndexCols = index.getColumns();
                    int numCols = aIndexCols.length;
                    if (numCols == 1 && this.m_table.getDBMSType() instanceof SASType) {
                        index.setName(aIndexCols[0].getName());
                    } else if (numCols > 1 && index.getName().equals(aIndexCols[0].getName())) {
                        index.setName("pk_index");
                    }
                }
            }
            finally {
                this.m_table.getModel().endCompoundUndoable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedColumns(boolean bDown) {
        if (!this.m_tblCurrentColumns.stopCellEditing()) {
            return;
        }
        List lColumns = null;
        List lIndexColumns = null;
        if (this.m_keyCurrent instanceof IKey) {
            lColumns = ((IKey)this.m_keyCurrent).getColumnsList();
            IIndex index = KeysTab.getIndexUsingPrimaryKey((IKey)this.m_keyCurrent, this.m_table);
            if (index != null) {
                lIndexColumns = index.getColumnsList();
            }
        } else if (this.m_keyCurrent instanceof IForeignKey) {
            lColumns = ((IForeignKey)this.m_keyCurrent).getColumnsList();
        } else {
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            int iRow;
            int[] aRows = this.m_tblCurrentColumns.getSelectedRowsFromSelectedCells();
            IColumn[] aColumns = new IColumn[aRows.length];
            for (iRow = 0; iRow < aRows.length; ++iRow) {
                if (aRows[iRow] >= lColumns.size()) continue;
                aColumns[iRow] = (IColumn)lColumns.get(aRows[iRow]);
            }
            if (bDown) {
                for (iRow = aRows.length - 1; iRow >= 0; --iRow) {
                    if (aRows[iRow] >= lColumns.size()) continue;
                    lColumns.remove(aColumns[iRow]);
                    lColumns.add(aRows[iRow] + 1, aColumns[iRow]);
                    if (lIndexColumns == null) continue;
                    lIndexColumns.remove(aColumns[iRow]);
                    lIndexColumns.add(aRows[iRow] + 1, aColumns[iRow]);
                }
            } else {
                for (iRow = 0; iRow < aRows.length; ++iRow) {
                    if (aRows[iRow] >= lColumns.size()) continue;
                    lColumns.remove(aColumns[iRow]);
                    lColumns.add(aRows[iRow] - 1, aColumns[iRow]);
                    if (lIndexColumns == null) continue;
                    lIndexColumns.remove(aColumns[iRow]);
                    lIndexColumns.add(aRows[iRow] - 1, aColumns[iRow]);
                }
            }
            this.selectColumns(aColumns);
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveColumn(int iFrom, int iTo) {
        if (!this.m_tblCurrentColumns.stopCellEditing()) {
            return;
        }
        this.m_table.getModel().startCompoundUndoable();
        try {
            this.m_tblCurrentColumns.clearSelection();
            IKey key = (IKey)this.m_keyCurrent;
            IIndex pIndex = KeysTab.getIndexUsingPrimaryKey(key, this.m_table);
            IColumn column = ((UniqueKeyColumnsTableModel)((Object)this.m_tblCurrentColumns.getModel())).getColumnForRow(iFrom);
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(column, true, false));
            List lCols = key.getColumnsList();
            lCols.remove(column);
            lCols.add(iTo, column);
            if (pIndex != null) {
                List columnList = pIndex.getColumnsList();
                columnList.remove(column);
                columnList.add(iTo, column);
            }
            this.m_tblCurrentColumns.selectRow(iTo);
            this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectColumnsUndoable(column, false, true));
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedColumns() {
        List lColumns = null;
        if (this.m_keyCurrent instanceof IKey) {
            lColumns = ((IKey)this.m_keyCurrent).getColumnsList();
        } else if (this.m_keyCurrent instanceof IForeignKey) {
            lColumns = ((IForeignKey)this.m_keyCurrent).getColumnsList();
        } else {
            return;
        }
        IIndex index = this.m_keyCurrent instanceof IKey ? KeysTab.getIndexUsingPrimaryKey((IKey)this.m_keyCurrent, this.m_table) : null;
        this.m_table.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.getSelectedTableRows();
            IColumn[] aCols = new IColumn[aRows.length];
            for (int iRow = 0; iRow < aRows.length; ++iRow) {
                int iModelRow = this.m_tblCurrentColumns.convertRowIndexToModel(aRows[iRow]);
                aCols[iRow] = (IColumn)lColumns.get(iModelRow);
            }
            for (int iCol = 0; iCol < aCols.length; ++iCol) {
                lColumns.remove(aCols[iCol]);
                if (index == null) continue;
                index.getColumnsList().remove(aCols[iCol]);
            }
            if (index != null) {
                IColumn[] aIndexCols = index.getColumns();
                int numCols = aIndexCols.length;
                if (numCols == 1 && this.m_table.getDBMSType() instanceof SASType) {
                    index.setName(aIndexCols[0].getName());
                } else if (numCols > 1 && index.getName().equals(aIndexCols[0].getName())) {
                    index.setName(index.getName() + "_Primary");
                }
            }
        }
        finally {
            this.m_table.getModel().endCompoundUndoable();
        }
    }

    private void selectColumns(IColumn[] aColumns) {
        this.m_tblCurrentColumns.clearSelection();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            int iRow = ((UniqueKeyColumnsTableModel)((Object)this.m_tblCurrentColumns.getModel())).getRowIndex(aColumns[iColumn]);
            if (iRow == -1) continue;
            this.m_tblCurrentColumns.addRowToSelection(this.m_tblCurrentColumns.convertRowIndexToView(iRow));
        }
    }

    public static IIndex getIndexUsingPrimaryKey(IKey key, IPhysicalTable table) {
        if (!key.isPrimary()) {
            return null;
        }
        IColumn[] aKeyCols = key.getColumns();
        IIndex[] aIndex = table.getIndexes();
        for (int iIndex = 0; iIndex < aIndex.length; ++iIndex) {
            IColumn[] aIndexCols = aIndex[iIndex].getColumns();
            if (aIndexCols.length != aKeyCols.length) continue;
            boolean bMatch = true;
            for (int iCol = 0; iCol < aIndexCols.length; ++iCol) {
                if (aIndexCols[iCol] == aKeyCols[iCol]) continue;
                bMatch = false;
                iCol = aIndexCols.length;
            }
            if (!bMatch) continue;
            return aIndex[iIndex];
        }
        return null;
    }

    private class SelectObjectUndoable
    extends AbstractUndoableEdit {
        private IPersistableObject m_object;

        public SelectObjectUndoable(IPersistableObject object) {
            this.m_object = object;
        }

        @Override
        public void redo() {
            super.redo();
            KeysTab.this.m_treeKeys.selectObject(this.m_object.getID());
        }

        @Override
        public void die() {
            super.die();
            this.m_object = null;
        }
    }

    private class SelectColumnsUndoable
    extends AbstractUndoableEdit {
        private IColumn[] m_aColumns;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectColumnsUndoable(IColumn column, boolean bOnUndo, boolean bOnRedo) {
            this(new IColumn[]{column}, bOnUndo, bOnRedo);
        }

        public SelectColumnsUndoable(IColumn[] aColumns, boolean bOnUndo, boolean bOnRedo) {
            this.m_aColumns = aColumns;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.m_bOnUndo) {
                KeysTab.this.selectColumns(this.m_aColumns);
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.m_bOnRedo) {
                KeysTab.this.selectColumns(this.m_aColumns);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aColumns, null);
            this.m_aColumns = null;
        }
    }

    private class UndoManagerListener
    implements ChangeListener {
        private UndoManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            UndoManager mgrUndo = KeysTab.this.m_table.getModel().getUndoManager();
            KeysTab.this.m_actUndo.setEnabled(mgrUndo.canUndo());
            KeysTab.this.m_actRedo.setEnabled(mgrUndo.canRedo());
            KeysTab.this.updateActions();
        }
    }

    private class ForeignKeySelectorPanel
    extends ObjectSelectorPanel {
        private IPhysicalTable m_partnerKeyTable;
        private IForeignKey m_foreignKey;

        public ForeignKeySelectorPanel() {
            super(Workspace.getWorkspace().getUserContext(), 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean validateData() {
            IKey[] keys;
            boolean valid = super.validateData();
            if (!valid) {
                return false;
            }
            SimpleObject object = super.getSelectedObject();
            this.m_partnerKeyTable = (IPhysicalTable)KeysTab.this.m_table.getModel().getObject(object.getID());
            if (this.m_partnerKeyTable == null) {
                this.m_partnerKeyTable = KeysTab.this.loadTable(object);
            }
            if ((keys = this.m_partnerKeyTable.getKeys()) == null || keys.length == 0) {
                MessageUtil.displayMessage((String)bundle.getString("KeysTab.TableSelector.NoKeys.txt"), (int)0);
                return false;
            }
            boolean ok = true;
            try {
                KeysTab.this.m_table.getModel().startCompoundUndoable();
                this.m_foreignKey = KeysTab.this.m_table.getModel().getObjectFactory().createNewForeignKey(KeysTab.this.m_table.getID());
                KeysTab.this.m_table.getForeignKeysList().add(this.m_foreignKey);
                this.m_foreignKey.setName(KeysTab.this.generateNewForeignKeyName(this.m_partnerKeyTable));
                PartnerKeyPanel partnerKeyPanel = new PartnerKeyPanel(this.m_partnerKeyTable, KeysTab.this.m_table, this.m_foreignKey);
                partnerKeyPanel.setHelpProduct("wdb");
                partnerKeyPanel.setHelpTopic("select_partner_key");
                int response = ModelUIUtilities.showDialog((IObject)this.m_foreignKey, bundle.getString("KeysTab.SelectPartnerKey.Title.txt"), partnerKeyPanel);
                boolean bl = ok = response == 1;
                if (!ok) {
                    KeysTab.this.m_table.getForeignKeysList().remove(this.m_foreignKey);
                }
                boolean bl2 = ok;
                return bl2;
            }
            finally {
                if (ok) {
                    KeysTab.this.m_table.getModel().undoableEditHappened((UndoableEdit)new SelectObjectUndoable((IPersistableObject)this.m_foreignKey));
                    KeysTab.this.m_table.getModel().endCompoundUndoable();
                } else {
                    KeysTab.this.m_table.getModel().discardCompoundUndoable();
                }
            }
        }

        public IForeignKey getForeignKey() {
            return this.m_foreignKey;
        }
    }

    private class ForeignKeysTableDialog
    implements WsDialogTableCellEditorInterface {
        private ForeignKeysTableDialog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String showDialog(JTable tbl, int iRow, int iCol, String sValue) {
            IColumn[] aCols = KeysTab.this.promptForColumns(false);
            if (aCols == null || aCols.length == 0) {
                return null;
            }
            if (!(KeysTab.this.m_keyCurrent instanceof IForeignKey)) {
                return null;
            }
            IForeignKey key = (IForeignKey)KeysTab.this.m_keyCurrent;
            List lCols = key.getColumnsList();
            IColumn colOld = (IColumn)lCols.get(iRow);
            IColumn partnerColumn = key.getPartnerKeyColumn(colOld);
            IColumn colNew = aCols[0];
            if (colOld == colNew) {
                return null;
            }
            KeysTab.this.m_table.getModel().startCompoundUndoable();
            try {
                key.replaceKeyColumn(partnerColumn, colNew);
            }
            finally {
                KeysTab.this.m_table.getModel().endCompoundUndoable();
            }
            return colNew.getName();
        }
    }

    private class NoPartnerKeyRunnable
    implements Runnable {
        private NoPartnerKeyRunnable() {
        }

        @Override
        public void run() {
            String sMessage = bundle.formatString("KeysTab.Error.NoPartnerKeyDelete.txt", (Object)KeysTab.this.m_keyCurrent.getName());
            int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)0, (int)0);
            if (eAnswer == 0) {
                KeysTab.this.deleteSelectedKey();
            }
        }
    }

    private class KeysTreePopupMenuListener
    implements WsPopupMenuRequestListener {
        private KeysTreePopupMenuListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            KeysTab.this.handlePopupRequest(e.getX(), e.getY());
        }
    }

    private class KeysTableRowListener
    implements WsTableRowModelListener {
        private KeysTableRowListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
            WsDefaultTableRowModel mdlRows = (WsDefaultTableRowModel)KeysTab.this.m_tblCurrentColumns.getRowModel();
            mdlRows.clearRowMoves();
            KeysTab.this.moveColumn(ev.getFromIndex(), ev.getToIndex());
        }

        public void rowsRemapped(ChangeEvent ev) {
            KeysTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class KeysTableSelectionListener
    implements ListSelectionListener {
        private KeysTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent ev) {
            KeysTab.this.updateActions();
        }
    }

    private class KeysTreeSelectionListener
    implements TreeSelectionListener {
        private KeysTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent arg0) {
            IDataTreeNode node = KeysTab.this.m_treeKeys.getSelectedDataNode();
            if (node == null) {
                KeysTab.this.showBlankColumnsPanel();
            } else {
                IObject oKey = (IObject)node.getData();
                KeysTab.this.setCurrentKey(oKey);
            }
            KeysTab.this.updateActions();
            KeysTab.this.updateComponents();
        }
    }

    private class MoveDownAction
    extends WsAbstractAction {
        public MoveDownAction() {
            super(bundle, "KeysTab.Action.MoveDown", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveDown"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.moveSelectedColumns(true);
        }
    }

    private class MoveUpAction
    extends WsAbstractAction {
        public MoveUpAction() {
            super(bundle, "KeysTab.Action.MoveUp", 16);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:MoveUp"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.moveSelectedColumns(false);
        }
    }

    private class RemoveAction
    extends WsAbstractAction {
        public RemoveAction() {
            super(bundle, "KeysTab.Action.Remove", 0);
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.removeSelectedColumns();
        }
    }

    private class AddAction
    extends WsAbstractAction {
        public AddAction() {
            super(bundle, "KeysTab.Action.Add", 0);
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.addColumns();
        }
    }

    private class RenameAction
    extends WsAbstractAction {
        public RenameAction() {
            super(bundle, "KeysTab.Action.Rename", 1);
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.renameCurrentNode();
        }
    }

    private class DeleteAction
    extends WsAbstractAction {
        public DeleteAction() {
            super(bundle, "KeysTab.Action.Delete", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Delete"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.deleteSelectedKey();
        }
    }

    private class RedoAction
    extends WsAbstractAction {
        public RedoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Redo"));
            this.setToolTipText(bundle.getString("KeysTab.Action.Redo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.m_table.getModel().getUndoManager().redo();
        }
    }

    private class UndoAction
    extends WsAbstractAction {
        public UndoAction() {
            this.setIcon(AppIconFactory.getInstance().getIconForAction("Common:Undo"));
            this.setToolTipText(bundle.getString("KeysTab.Action.Undo.tip"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.m_table.getModel().getUndoManager().undo();
        }
    }

    private class NewForeignKeyPopupAction
    extends WsAbstractAction {
        public NewForeignKeyPopupAction() {
            super(bundle, "KeysTab.Action.NewForeignKeyPopup", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:ForeignKey"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.newForeignKey();
        }
    }

    private class NewUniqueKeyPopupAction
    extends WsAbstractAction {
        public NewUniqueKeyPopupAction() {
            super(bundle, "KeysTab.Action.NewUniqueKeyPopup", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:UniqueKey"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.newUniqueKey(false);
        }
    }

    private class NewPrimaryKeyPopupAction
    extends WsAbstractAction {
        public NewPrimaryKeyPopupAction() {
            super(bundle, "KeysTab.Action.NewPrimaryKeyPopup", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:PrimaryKey"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.newUniqueKey(true);
        }
    }

    private class NewForeignKeyAction
    extends WsAbstractAction {
        public NewForeignKeyAction() {
            super(bundle, "KeysTab.Action.NewForeignKey", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:ForeignKey"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.newForeignKey();
        }
    }

    private class NewUniqueKeyAction
    extends WsAbstractAction {
        public NewUniqueKeyAction() {
            super(bundle, "KeysTab.Action.NewUniqueKey", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:UniqueKey"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.newUniqueKey(false);
        }
    }

    private class NewPrimaryKeyAction
    extends WsAbstractAction {
        public NewPrimaryKeyAction() {
            super(bundle, "KeysTab.Action.NewPrimaryKey", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForPrivateType("Type:PrimaryKey"));
        }

        public void actionPerformed(ActionEvent ev) {
            KeysTab.this.newUniqueKey(true);
        }
    }

    private class NewAction
    extends WsDropMenuAction {
        public NewAction() {
            super(bundle, "KeysTab.Action.New", 0);
            this.setIcon(AppIconFactory.getInstance().getIconForAction("NewKeyDropMenu"));
        }
    }
}

