/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.dbmstypes.EXCELType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.data.dbmstypes.SPDEType;
import com.sas.etl.models.data.dbmstypes.SYBASEType;
import com.sas.etl.models.data.dbmstypes.TERADATAType;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.ColumnsTableModel;
import com.sas.wadmin.visuals.common.IndexTree;
import com.sas.wadmin.visuals.common.IndexTreeModel;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultClipboardOwner;
import com.sas.workspace.WsDragSourceAdapter;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class IndexesTab
extends WAPropertyTab {
    public static final String CONTEXT = "IndexesTab";
    private static final String SETTINGS_PREFIX = "TableIndexesTab";
    protected JPanel m_pnlColumns;
    protected JLabel m_lblColumns;
    protected JScrollPane m_scrColumns;
    protected WsTable m_tblColumns;
    protected JButton m_btnAdd;
    protected JPanel m_pnlIndexes;
    protected JLabel m_lblIndexes;
    protected JScrollPane m_scrIndexes;
    protected IndexTree m_treeIndexes;
    protected JPanel m_pnlButtons;
    protected JButton m_btnMoveUp;
    protected JButton m_btnMoveDown;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JPanel m_pnlOptions;
    protected JCheckBox m_ckbUnique;
    protected JCheckBox m_ckbNoMiss;
    protected JCheckBox m_ckbClustered;
    protected JCheckBox m_ckbPrimary;
    protected JCheckBox m_ckbAsyncIndex;
    protected IPhysicalTable m_oTable;
    protected IndexTreeModel m_mdlIndexes;
    protected ColumnsTableModel m_mdlColumns;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actRename;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actAdd;
    protected WsAbstractAction m_actMoveUp;
    protected WsAbstractAction m_actMoveDown;
    protected WsAbstractAction m_actCut;
    protected WsAbstractAction m_actCopy;
    protected WsAbstractAction m_actPaste;
    protected WsAbstractAction m_actUnique;
    protected WsAbstractAction m_actNoMiss;
    protected WsAbstractAction m_actClustered;
    protected WsAbstractAction m_actPrimary;
    protected WsAbstractAction m_actAsyncIndex;
    protected boolean m_bHoldActionUpdates;
    protected boolean m_bColumnsTableHasFocus;
    protected boolean m_bDBMSIsExcel;
    protected IModelListener m_lsnrModel;
    private static WAdminResource bundle = WAdminResource.getBundle(IndexesTab.class);

    public IndexesTab(IPhysicalTable oTable) {
        this.m_oTable = oTable;
        this.initialize();
        this.layoutWidgets();
        this.setName(bundle.getString("IndexesTab.Name.txt"));
        this.setHelpProduct("shared");
        this.setHelpTopic("indexes_tab");
    }

    protected void initialize() {
        this.createActions();
        this.createColumnsPanel();
        this.createAddButton();
        this.createIndexesPanel();
        this.createButtonsPanel();
        this.createOptionsPanel();
    }

    protected void createColumnsPanel() {
        this.createColumnsTable();
        this.m_lblColumns = new JLabel(bundle.getString("IndexesTab.ColumnsLabel.txt"));
        this.m_lblColumns.setDisplayedMnemonic(bundle.getString("IndexesTab.ColumnsLabel.mnem").charAt(0));
        this.m_lblColumns.setLabelFor((Component)this.m_tblColumns);
        this.m_pnlColumns = new JPanel(new BorderLayout(0, 5));
        this.m_pnlColumns.add((Component)this.m_lblColumns, "North");
        this.m_pnlColumns.add((Component)this.m_scrColumns, "Center");
    }

    protected void createColumnsTable() {
        this.m_mdlColumns = new ColumnsTableModel((ITable)this.m_oTable);
        this.m_mdlColumns.moveDataToModel();
        this.m_tblColumns = new WsTable((WsAbstractTableModel)this.m_mdlColumns);
        this.m_tblColumns.setToolTipText(bundle.getString("IndexesTab.ColumnsTable.ToolTip.txt"));
        this.m_tblColumns.setEditable(false);
        this.m_tblColumns.setMouseBlockSelectionEnabled(false);
        this.m_tblColumns.setMultipleSelectionDragEnabled(true);
        this.m_tblColumns.setRowsReorderable(false);
        this.m_tblColumns.getSelectionModel().addListSelectionListener(new cColumnsTableSelectionListener());
        this.m_tblColumns.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cColumnsTablePopupMenuRequestListener());
        this.m_tblColumns.addFocusListener((FocusListener)new cColumnsTableFocusListener());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.m_tblColumns, 1, new cColumnsTableDragGestureListener());
        this.m_tblColumns.getActionMap().put(this.m_actCopy, (Action)this.m_actCopy);
        this.m_tblColumns.getInputMap().put(KeyStroke.getKeyStroke(67, 2), this.m_actCopy);
        this.m_tblColumns.hideColumn(5);
        this.m_tblColumns.hideColumn(4);
        this.m_tblColumns.hideColumn(8);
        this.m_tblColumns.hideColumn(6);
        this.m_tblColumns.hideColumn(7);
        this.m_tblColumns.removeColumn(9);
        this.m_tblColumns.removeColumn(10);
        this.m_tblColumns.restoreSettings(SETTINGS_PREFIX);
        this.m_scrColumns = new JScrollPane((Component)this.m_tblColumns);
        this.m_scrColumns.setMinimumSize(new Dimension(170, 250));
        this.m_scrColumns.setPreferredSize(new Dimension(250, 250));
    }

    protected void createAddButton() {
        this.m_btnAdd = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actAdd);
    }

    protected void createIndexesPanel() {
        this.createIndexesTree();
        this.m_lblIndexes = new JLabel(bundle.getString("IndexesTab.IndexesLabel.txt"));
        this.m_lblIndexes.setDisplayedMnemonic(bundle.getString("IndexesTab.IndexesLabel.mnem").charAt(0));
        this.m_lblIndexes.setLabelFor((Component)((Object)this.m_treeIndexes));
        this.m_pnlIndexes = new JPanel(new BorderLayout(0, 5));
        this.m_pnlIndexes.add((Component)this.m_lblIndexes, "North");
        this.m_pnlIndexes.add((Component)this.m_scrIndexes, "Center");
    }

    protected void createIndexesTree() {
        this.m_mdlIndexes = new IndexTreeModel(this.m_oTable);
        this.m_treeIndexes = new IndexTree(this.m_mdlIndexes, this.m_mdlColumns);
        this.m_treeIndexes.setMetadataTable(this.m_oTable);
        this.m_mdlIndexes.addTreeModelListener(new cIndexesTreeModelListener());
        this.m_treeIndexes.addTreeSelectionListener(new cIndexesTreeSelectionListener());
        this.m_treeIndexes.setPopupMenuRequestListener(new cIndexesTreePopupMenuRequestListener());
        ActionMap mapActions = this.m_treeIndexes.getActionMap();
        mapActions.put(this.m_actDelete, (Action)this.m_actDelete);
        mapActions.put(this.m_actCut, (Action)this.m_actCut);
        mapActions.put(this.m_actCopy, (Action)this.m_actCopy);
        mapActions.put(this.m_actPaste, (Action)this.m_actPaste);
        InputMap mapKeys = this.m_treeIndexes.getInputMap();
        mapKeys.put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        mapKeys.put(KeyStroke.getKeyStroke(88, 2), this.m_actCut);
        mapKeys.put(KeyStroke.getKeyStroke(67, 2), this.m_actCopy);
        mapKeys.put(KeyStroke.getKeyStroke(86, 2), this.m_actPaste);
        this.m_scrIndexes = new JScrollPane((Component)((Object)this.m_treeIndexes));
        this.m_scrIndexes.setMinimumSize(new Dimension(230, 200));
        this.m_scrIndexes.setPreferredSize(new Dimension(250, 200));
    }

    protected void createButtonsPanel() {
        this.m_btnMoveUp = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveUp);
        this.m_btnMoveDown = WsUIUtilities.createToolButton((WsAbstractAction)this.m_actMoveDown);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        JPanel pnlLeft = new JPanel((LayoutManager)new WsButtonsLayout(0, 2));
        JPanel pnlRight = new JPanel((LayoutManager)new WsButtonsLayout(0, 4));
        pnlLeft.add(this.m_btnMoveUp);
        pnlLeft.add(this.m_btnMoveDown);
        pnlRight.add(this.m_btnNew);
        pnlRight.add(this.m_btnDelete);
        this.m_pnlButtons = new JPanel(new BorderLayout(10, 0));
        this.m_pnlButtons.add((Component)pnlLeft, "West");
        this.m_pnlButtons.add((Component)pnlRight, "East");
    }

    protected void createOptionsPanel() {
        this.m_ckbUnique = new JCheckBox((Action)this.m_actUnique);
        this.m_ckbNoMiss = new JCheckBox((Action)this.m_actNoMiss);
        this.m_ckbClustered = new JCheckBox((Action)this.m_actClustered);
        this.m_ckbPrimary = new JCheckBox((Action)this.m_actPrimary);
        this.m_ckbAsyncIndex = new JCheckBox((Action)this.m_actAsyncIndex);
        this.m_ckbClustered.setVisible(false);
        this.m_ckbPrimary.setVisible(false);
        this.m_ckbAsyncIndex.setVisible(false);
        this.m_pnlOptions = new JPanel(new GridBagLayout());
        String sTitle = " " + bundle.getString("IndexesTab.OptionsTitle.txt") + " ";
        this.m_pnlOptions.setBorder(BorderFactory.createTitledBorder(sTitle));
        this.m_pnlOptions.add((Component)this.m_ckbUnique, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbNoMiss, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbClustered, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbPrimary, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_pnlOptions.add((Component)this.m_ckbAsyncIndex, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    protected void layoutWidgets() {
        int cxMax;
        Dimension dimIndexes = this.m_pnlIndexes.getMinimumSize();
        Dimension dimButtons = this.m_pnlButtons.getMinimumSize();
        dimIndexes.width = cxMax = Math.max(dimIndexes.width, dimButtons.width);
        dimButtons.width = cxMax;
        this.m_pnlIndexes.setMinimumSize(dimIndexes);
        this.m_pnlButtons.setMinimumSize(dimButtons);
        dimIndexes = this.m_pnlIndexes.getPreferredSize();
        dimButtons = this.m_pnlButtons.getPreferredSize();
        dimIndexes.width = cxMax = Math.max(dimIndexes.width, dimButtons.width);
        dimButtons.width = cxMax;
        this.m_pnlIndexes.setPreferredSize(dimIndexes);
        this.m_pnlButtons.setPreferredSize(dimButtons);
        this.setLayout(new GridBagLayout());
        this.add(this.m_pnlColumns, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_pnlIndexes, new GridBagConstraints(2, 1, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_pnlButtons, new GridBagConstraints(2, 2, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_pnlOptions, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return this.m_treeIndexes.validateData();
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_mdlColumns.moveDataToModel();
        this.m_mdlIndexes.moveDataToModel();
        if (this.m_mdlColumns.getRowCount() > 0) {
            this.m_tblColumns.selectCell(0, 0);
        }
        this.m_treeIndexes.expandPath(new TreePath(this.m_mdlIndexes.getRoot()));
        boolean bSybase = false;
        boolean bSAS = false;
        boolean bTeradata = false;
        boolean bSPDE = false;
        this.m_bDBMSIsExcel = false;
        IDBMSType sDBMSType = this.m_oTable.getDBMSType();
        if (sDBMSType != null) {
            if (sDBMSType instanceof SYBASEType) {
                bSybase = true;
            } else if (sDBMSType instanceof SASType) {
                bSAS = true;
            } else if (sDBMSType instanceof EXCELType) {
                this.m_bDBMSIsExcel = true;
            } else if (sDBMSType instanceof TERADATAType) {
                bTeradata = true;
            }
            if (sDBMSType instanceof SPDEType) {
                bSPDE = true;
            }
        }
        this.m_ckbClustered.setVisible(bSybase);
        this.m_ckbNoMiss.setVisible(bSAS);
        this.m_ckbPrimary.setVisible(bTeradata);
        this.m_ckbAsyncIndex.setVisible(bSPDE);
        if (!this.m_bDBMSIsExcel) {
            this.setEditable(this.isEditable());
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.setDataChanged(false);
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
        this.m_actRename.setActive(bActive);
        this.m_actDelete.setActive(bActive);
        this.m_actCut.setActive(bActive);
        this.m_actCopy.setActive(bActive);
        this.m_actPaste.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_treeIndexes.setEditable(bEditable && !this.m_bDBMSIsExcel);
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        this.m_mdlColumns.dispose();
        this.m_tblColumns.saveSettings(SETTINGS_PREFIX);
        this.m_oTable.getModel().removeModelListener(this.m_lsnrModel);
        this.m_mdlIndexes.dispose();
        this.m_treeIndexes.dispose();
    }

    protected Transferable createTransferableFromSelectedTableColumns() {
        int[] aRows = this.m_tblColumns.getSelectedRowsFromSelectedCells();
        int nRows = aRows.length;
        if (nRows == 0) {
            return null;
        }
        DNDObject xferColumns = new DNDObject();
        for (int iRow = 0; iRow < nRows; ++iRow) {
            int iModelRow = this.m_tblColumns.convertRowIndexToModel(aRows[iRow]);
            xferColumns.add(this.m_mdlColumns.getValueAt(iModelRow, this.m_mdlColumns.getColumnCount()));
        }
        return xferColumns;
    }

    public void copySelectedTableColumns() {
        Transferable xfer = this.createTransferableFromSelectedTableColumns();
        if (xfer == null) {
            return;
        }
        this.getToolkit().getSystemClipboard().setContents(xfer, (ClipboardOwner)new WsDefaultClipboardOwner());
    }

    private boolean checkClipboard() {
        Transferable xfer = this.getToolkit().getSystemClipboard().getContents((Object)this);
        return xfer != null && xfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor);
    }

    protected void createActions() {
        this.m_actNew = new cNewAction();
        this.m_actRename = new cRenameAction();
        this.m_actDelete = new cDeleteAction();
        this.m_actAdd = new cAddAction();
        this.m_actMoveUp = new cMoveUpAction();
        this.m_actMoveDown = new cMoveDownAction();
        this.m_actCut = new cCutAction();
        this.m_actCopy = new cCopyAction();
        this.m_actPaste = new cPasteAction();
        this.m_actUnique = new cUniqueAction();
        this.m_actNoMiss = new cNoMissAction();
        this.m_actClustered = new cClusteredAction();
        this.m_actPrimary = new cPrimaryAction();
        this.m_actAsyncIndex = new cAsyncIndexAction();
        this.m_lsnrModel = new ModelListener();
        this.m_oTable.getModel().addModelListener(this.m_lsnrModel);
    }

    protected void setHoldActionUpdates(boolean bHoldActionUpdates) {
        this.m_bHoldActionUpdates = bHoldActionUpdates;
        if (!this.m_bHoldActionUpdates) {
            this.updateActions();
        }
    }

    protected void updateActions() {
        if (this.m_bHoldActionUpdates) {
            return;
        }
        boolean bEditable = this.isEditable() && !this.m_bDBMSIsExcel;
        boolean bIndexes = false;
        int nSelectedNodes = this.m_treeIndexes.getSelectionCount();
        boolean bTreeColumns = false;
        boolean bTableColumns = false;
        boolean bFirst = false;
        boolean bLast = false;
        boolean bCopy = false;
        boolean bUnique = false;
        boolean bNoMiss = false;
        boolean bClustered = false;
        boolean bPrimary = false;
        boolean bAsyncIndex = false;
        if (this.m_treeIndexes.isIndexSelected()) {
            bIndexes = true;
            if (nSelectedNodes == 1) {
                bUnique = this.m_treeIndexes.getSelectedIndexProperty("Unique");
                bNoMiss = this.m_treeIndexes.getSelectedIndexProperty("NoMiss");
                bClustered = this.m_treeIndexes.getSelectedIndexProperty("Clustered");
                bPrimary = this.m_treeIndexes.getSelectedIndexProperty("Primary");
                bAsyncIndex = this.m_treeIndexes.getSelectedIndexProperty("ASYNCINDEX");
            }
        } else {
            TreePath[] aPaths = this.m_treeIndexes.getSelectionPaths();
            if (aPaths != null) {
                bTreeColumns = true;
                int nPaths = aPaths.length;
                for (int iPath = 0; iPath < nPaths; ++iPath) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)aPaths[iPath].getLastPathComponent();
                    if (node.getPreviousSibling() == null) {
                        bFirst = true;
                    }
                    if (node.getNextSibling() != null) continue;
                    bLast = true;
                }
            }
        }
        bTableColumns = this.m_tblColumns.getSelectedRowsFromSelectedCells().length != 0;
        bCopy = this.m_bColumnsTableHasFocus ? bTableColumns : bTreeColumns;
        this.m_actNew.setEnabled(bEditable);
        this.m_actRename.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actDelete.setEnabled(bEditable && nSelectedNodes != 0);
        this.m_actAdd.setEnabled(bEditable && nSelectedNodes == 1 && bTableColumns);
        this.m_actMoveUp.setEnabled(bEditable && bTreeColumns && !bFirst);
        this.m_actMoveDown.setEnabled(bEditable && bTreeColumns && !bLast);
        this.m_actCut.setEnabled(bEditable && bTreeColumns);
        this.m_actCopy.setEnabled(bEditable && bCopy);
        this.m_actPaste.setEnabled(bEditable && nSelectedNodes == 1 && this.checkClipboard());
        this.m_actUnique.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actNoMiss.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actClustered.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actPrimary.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_actAsyncIndex.setEnabled(bEditable && nSelectedNodes == 1 && bIndexes);
        this.m_ckbUnique.setSelected(bUnique);
        this.m_ckbNoMiss.setSelected(bNoMiss);
        this.m_ckbClustered.setSelected(bClustered);
        this.m_ckbPrimary.setSelected(bPrimary);
        this.m_ckbAsyncIndex.setSelected(bAsyncIndex);
    }

    protected class cPrimaryAction
    extends WsAbstractAction {
        public cPrimaryAction() {
            super(bundle, "IndexesTab.Primary");
        }

        public void actionPerformed(ActionEvent e) {
            if (IndexesTab.this.m_ckbPrimary.isSelected()) {
                IIndex[] indexes = IndexesTab.this.m_oTable.getIndexes();
                for (int i = 0; i < indexes.length; ++i) {
                    if (!indexes[i].isPrimary()) continue;
                    MessageUtil.displayMessage((String)bundle.formatString("IndexesTab.TooManyPrimaryIndexes.txt", (Object)indexes[i].getName()), (int)0);
                    IndexesTab.this.m_ckbPrimary.setSelected(false);
                    return;
                }
            }
            IndexesTab.this.m_treeIndexes.setSelectedIndexProperty("Primary", IndexesTab.this.m_ckbPrimary.isSelected());
            IndexesTab.this.setDataChanged(true);
        }
    }

    protected class cClusteredAction
    extends WsAbstractAction {
        public cClusteredAction() {
            super(bundle, "IndexesTab.Clustered");
        }

        public void actionPerformed(ActionEvent e) {
            if (IndexesTab.this.m_mdlIndexes.getClusteredCount() > 0 && IndexesTab.this.m_ckbClustered.isSelected()) {
                String sMessage = bundle.getString("IndexesTab.TooManyClusteredError.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
            } else {
                IndexesTab.this.m_treeIndexes.setSelectedIndexProperty("Clustered", IndexesTab.this.m_ckbClustered.isSelected());
                IndexesTab.this.setDataChanged(true);
            }
        }
    }

    protected class cNoMissAction
    extends WsAbstractAction {
        public cNoMissAction() {
            super(bundle, "IndexesTab.NoMiss");
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.m_treeIndexes.setSelectedIndexProperty("NoMiss", IndexesTab.this.m_ckbNoMiss.isSelected());
            IndexesTab.this.setDataChanged(true);
        }
    }

    protected class cAsyncIndexAction
    extends WsAbstractAction {
        public cAsyncIndexAction() {
            super(bundle, "IndexesTab.AsyncIndex");
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.m_treeIndexes.setSelectedIndexProperty("ASYNCINDEX", IndexesTab.this.m_ckbAsyncIndex.isSelected());
            IndexesTab.this.setDataChanged(true);
        }
    }

    protected class cUniqueAction
    extends WsAbstractAction {
        public cUniqueAction() {
            super(bundle, "IndexesTab.Unique");
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.m_treeIndexes.setSelectedIndexProperty("Unique", IndexesTab.this.m_ckbUnique.isSelected());
            IndexesTab.this.setDataChanged(true);
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        public cPasteAction() {
            super(bundle, "IndexesTab.Paste", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            IndexesTab.this.m_treeIndexes.paste();
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        public cCopyAction() {
            super(bundle, "IndexesTab.Copy", true);
        }

        public void actionPerformed(ActionEvent e) {
            if (IndexesTab.this.m_bColumnsTableHasFocus) {
                IndexesTab.this.copySelectedTableColumns();
            } else {
                IndexesTab.this.m_treeIndexes.copy();
            }
            IndexesTab.this.updateActions();
        }
    }

    protected class cCutAction
    extends WsAbstractAction {
        public cCutAction() {
            super(bundle, "IndexesTab.Cut", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            IndexesTab.this.m_treeIndexes.cut();
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    protected class cMoveDownAction
    extends WsAbstractAction {
        public cMoveDownAction() {
            super(bundle, "IndexesTab.MoveDown", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            IndexesTab.this.m_treeIndexes.moveSelectedColumnsDown();
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    protected class cMoveUpAction
    extends WsAbstractAction {
        public cMoveUpAction() {
            super(bundle, "IndexesTab.MoveUp", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            IndexesTab.this.m_treeIndexes.moveSelectedColumnsUp();
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    protected class cAddAction
    extends WsAbstractAction {
        public cAddAction() {
            super(bundle, "IndexesTab.Add", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            int[] aRows = IndexesTab.this.m_tblColumns.getSelectedRowsFromSelectedCells();
            ArrayList<Object> lColumns = new ArrayList<Object>(aRows.length);
            int nRows = aRows.length;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                lColumns.add(IndexesTab.this.m_mdlColumns.getValueAt(IndexesTab.this.m_tblColumns.convertRowIndexToModel(aRows[iRow]), IndexesTab.this.m_mdlColumns.getColumnCount()));
            }
            IndexesTab.this.m_treeIndexes.addColumns(lColumns);
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "IndexesTab.Delete", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            IndexesTab.this.m_treeIndexes.deleteSelectedNodes();
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    protected class cRenameAction
    extends WsAbstractAction {
        public cRenameAction() {
            super(bundle, "IndexesTab.Rename");
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.m_treeIndexes.renameSelectedIndex();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "IndexesTab.New", true);
        }

        public void actionPerformed(ActionEvent e) {
            IndexesTab.this.setHoldActionUpdates(true);
            IndexesTab.this.m_treeIndexes.addNewIndex();
            IndexesTab.this.setHoldActionUpdates(false);
        }
    }

    class cIndexesTreeModelListener
    implements TreeModelListener {
        cIndexesTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (IndexesTab.this.isListeningForChanges()) {
                IndexesTab.this.setDataChanged(true);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (IndexesTab.this.isListeningForChanges()) {
                IndexesTab.this.setDataChanged(true);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (IndexesTab.this.isListeningForChanges()) {
                IndexesTab.this.setDataChanged(true);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    class cIndexesTreeSelectionListener
    implements TreeSelectionListener {
        cIndexesTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!IndexesTab.this.m_treeIndexes.isDragInProgress()) {
                IndexesTab.this.updateActions();
            }
        }
    }

    protected class cIndexesTreePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected cIndexesTreePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add((Action)IndexesTab.this.m_actNew);
            mnuPopup.add((Action)IndexesTab.this.m_actRename);
            mnuPopup.add((Action)IndexesTab.this.m_actDelete);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)IndexesTab.this.m_actAdd);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)IndexesTab.this.m_actMoveUp);
            mnuPopup.add((Action)IndexesTab.this.m_actMoveDown);
            mnuPopup.addSeparator();
            mnuPopup.add((Action)IndexesTab.this.m_actCut);
            mnuPopup.add((Action)IndexesTab.this.m_actCopy);
            mnuPopup.add((Action)IndexesTab.this.m_actPaste);
            mnuPopup.show((Component)((Object)IndexesTab.this.m_treeIndexes), e.getX(), e.getY());
        }
    }

    protected class cColumnsTableFocusListener
    implements FocusListener {
        protected cColumnsTableFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            IndexesTab.this.m_bColumnsTableHasFocus = true;
            IndexesTab.this.updateActions();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                IndexesTab.this.m_bColumnsTableHasFocus = false;
                IndexesTab.this.updateActions();
            }
        }
    }

    protected class cColumnsTableSelectionListener
    implements ListSelectionListener {
        protected cColumnsTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            IndexesTab.this.updateActions();
        }
    }

    public class cColumnsTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem((Action)IndexesTab.this.m_actCopy));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cColumnsTableDragGestureListener
    implements DragGestureListener {
        protected cColumnsTableDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            if (!IndexesTab.this.isEditable()) {
                return;
            }
            InputEvent ie = e.getTriggerEvent();
            if (ie.isControlDown() || ie.isShiftDown() || ie.isAltDown()) {
                return;
            }
            Transferable xfer = IndexesTab.this.createTransferableFromSelectedTableColumns();
            if (xfer == null) {
                return;
            }
            e.getDragSource().startDrag(e, null, xfer, (DragSourceListener)new WsDragSourceAdapter());
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "Index:ClusterChanged" || sType == "Index:NoMissingValuesChanged" || sType == "Index:UniqueChanged" || sType == "Index:PrimaryChanged" || sType == "Object:UserPropertySet" || sType == "Object:UserPropertyRemoved") {
                IndexesTab.this.updateActions();
            }
        }
    }
}

