/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.efi2.ImportColumnsMessage;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ImportNewColumnsFromEFF {
    private IExternalTable m_mdlTable;
    private String m_fullFileName;
    private static String m_delimiter;
    private static int m_fieldLength;
    private static String metaLib;
    private static String metaTable;
    private ArrayList m_alMessages;
    private static String READFLAG;
    private static WAdminResource bundle;
    private WsAppServer m_appServer;

    public ImportNewColumnsFromEFF(IExternalTable model, String fullFileName, String delimiter, WsAppServer appServer) {
        this.m_mdlTable = model;
        this.m_fullFileName = fullFileName;
        this.m_alMessages = new ArrayList();
        m_delimiter = delimiter;
        if (m_delimiter.length() == 0) {
            m_delimiter = " ";
        }
        this.m_appServer = appServer;
    }

    public List getColumns() throws SQLException, WsAppServerFailException, WsAppServerCodeException {
        StringBuffer sbLibAndTable = new StringBuffer();
        sbLibAndTable.append(metaLib);
        sbLibAndTable.append(".");
        sbLibAndTable.append(metaTable);
        String metaLibDotTable = sbLibAndTable.toString();
        StringBuffer sbSource = new StringBuffer(300);
        sbSource.append("\ndata _null_;\n");
        sbSource.append("infile '");
        sbSource.append(this.m_fullFileName);
        sbSource.append("' delimiter= '");
        sbSource.append(m_delimiter);
        sbSource.append("' firstobs=1 DSD ; \n");
        sbSource.append("length firstChar $1.;\n");
        sbSource.append("input@1 firstChar; \n");
        sbSource.append("   if (compress(_infile_) NE '' && firstChar NE '#') then do;\n");
        sbSource.append("   call symput('firstobs', _N_);\n");
        sbSource.append("   stop;\n");
        sbSource.append("   end;\n");
        sbSource.append("run;\n");
        sbSource.append("\ndata work.etls_nms ;\n");
        sbSource.append("infile '");
        sbSource.append(this.m_fullFileName);
        sbSource.append("' delimiter= '");
        sbSource.append(m_delimiter);
        sbSource.append("' firstobs=&firstobs");
        sbSource.append(" obs=&firstobs ");
        sbSource.append(" DSD; \n");
        sbSource.append("length Name $");
        sbSource.append(String.valueOf(m_fieldLength));
        sbSource.append(".;  \n");
        sbSource.append("input Name $ @@; \n");
        sbSource.append("call symput ('col' || compress(put(_N_,4.)), Name); \n");
        sbSource.append("call symput('count', _N_); \n");
        sbSource.append("if _N_ = 1 then do; \n");
        sbSource.append("   ColObs1 = &firstobs+1; \n");
        sbSource.append("   call symput('ColObs1', ColObs1);\n");
        sbSource.append("end; \n\n");
        sbSource.append("run; \n\n");
        sbSource.append("%macro getCols;\n");
        sbSource.append("data ");
        sbSource.append(metaLibDotTable);
        sbSource.append("; \n");
        sbSource.append("infile '");
        sbSource.append(this.m_fullFileName);
        sbSource.append("' delimiter='");
        sbSource.append(m_delimiter);
        sbSource.append("' firstobs=&ColObs1");
        sbSource.append(" missover DSD end=endfile ; \n");
        sbSource.append("Length \n");
        sbSource.append("%do i = 1 %to &count; \n");
        sbSource.append("&&col&i $");
        sbSource.append(String.valueOf(m_fieldLength) + ". \n");
        sbSource.append("%end; \n");
        sbSource.append("; \n");
        sbSource.append("do while (not endfile); \n");
        sbSource.append("input \n");
        sbSource.append("%do i = 1 %to &count; \n");
        sbSource.append("&&col&i $ \n");
        sbSource.append("%end; \n");
        sbSource.append("; \n");
        sbSource.append("  if (compress(_infile_) NE '' && substr(&col1,1,1) NE '#') then output;\n");
        sbSource.append("end;\n");
        sbSource.append("stop; \n");
        sbSource.append("run; \n");
        sbSource.append("%mend;\n");
        sbSource.append("%getCols; \n");
        sbSource.append(this.genTableDelete("work", "etls_nms"));
        if (this.m_appServer == null) {
            return null;
        }
        Workspace.getDefaultLogger().debug((Object)sbSource.toString());
        this.m_appServer.close();
        this.m_appServer.submitSASCode(sbSource.toString());
        List alAttributeNames = this.getColumnAttributeNames(metaLibDotTable, this.m_appServer);
        List alColumns = this.getColumnMetadata(metaLibDotTable, this.m_appServer);
        List alColumnMetadataObjects = new ArrayList(alColumns.size());
        alColumnMetadataObjects = this.createColumnMetadataObjects(alAttributeNames, alColumns);
        this.m_appServer.closeSQLConnection();
        this.m_appServer.submitSASCode(this.genTableDelete("work", metaTable));
        return alColumnMetadataObjects;
    }

    public String genTableDelete(String lib, String tableName) {
        StringBuffer sbDeleteSyntax = new StringBuffer(200);
        sbDeleteSyntax.append("proc datasets lib = ");
        sbDeleteSyntax.append(lib);
        sbDeleteSyntax.append(" nolist nowarn memtype = (data view);\n");
        sbDeleteSyntax.append("   delete ");
        sbDeleteSyntax.append(tableName);
        sbDeleteSyntax.append(";\n");
        sbDeleteSyntax.append("quit;\n\n");
        return sbDeleteSyntax.toString();
    }

    private List getColumnAttributeNames(String tabName, WsAppServer appServer) throws WsAppServerFailException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        String m_submitStmt = "select * from " + tabName;
        MVAResultSet rsltSet = appServer.submitSQLStatement(m_submitStmt);
        if (m_metadata == null) {
            try {
                m_metadata = rsltSet.getMetaData();
                colCount = m_metadata.getColumnCount();
            }
            catch (SQLException sqe) {
                MessageUtil.displayMessage((String)sqe.getLocalizedMessage(), (int)0);
            }
        }
        ArrayList<String> alColMetadata = new ArrayList<String>(colCount);
        for (int i = 0; i < colCount; ++i) {
            try {
                alColMetadata.add(m_metadata.getColumnName(i + 1));
                continue;
            }
            catch (SQLException sqe) {
                MessageUtil.displayMessage((String)sqe.getLocalizedMessage(), (int)0);
            }
        }
        return alColMetadata;
    }

    private List getColumnMetadata(String tabName, WsAppServer appServer) throws SQLException, WsAppServerFailException {
        ResultSetMetaData m_metadata = null;
        int colCount = 0;
        ArrayList alColumns = new ArrayList(50);
        String m_submitStmt = "select * from " + tabName;
        MVAResultSet rsltSet = appServer.submitSQLStatement(m_submitStmt);
        if (m_metadata == null) {
            m_metadata = rsltSet.getMetaData();
            colCount = m_metadata.getColumnCount();
        }
        while (rsltSet.next()) {
            ArrayList<String> alRow = new ArrayList<String>(colCount);
            for (int i = 1; i <= colCount; ++i) {
                String value = rsltSet.getString(i).trim();
                alRow.add(value);
            }
            alColumns.add(alRow);
        }
        try {
            rsltSet.close();
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return alColumns;
    }

    private List createColumnMetadataObjects(List alAttributeNames, List alColumns) {
        String space4 = "    ";
        String space = " ";
        ArrayList<IColumn> alColumnObjects = new ArrayList<IColumn>();
        for (int row = 0; row < alColumns.size(); ++row) {
            IColumn column = this.m_mdlTable.getModel().getObjectFactory().createNewColumn(this.m_mdlTable.getID());
            column.setNullable(true);
            boolean bReadColumnFlag = true;
            ArrayList columnValues = (ArrayList)alColumns.get(row);
            for (int attrPosn = 0; attrPosn < alAttributeNames.size(); ++attrPosn) {
                String attribute = ((String)alAttributeNames.get(attrPosn)).trim();
                String value = (String)columnValues.get(attrPosn);
                try {
                    if (attribute.equalsIgnoreCase("BeginPosition")) {
                        if (value.length() <= 0) continue;
                        column.setBeginPosition(Integer.parseInt(value));
                        continue;
                    }
                    if (attribute.compareToIgnoreCase("ColumnLength") == 0) {
                        if (value.length() <= 0) continue;
                        column.setLength(Integer.parseInt(value));
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("ColumnName")) {
                        column.setName(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("ColumnType")) {
                        if (value.length() > 0 && value.toUpperCase().charAt(0) == 'N') {
                            column.setType(1);
                            continue;
                        }
                        column.setType(0);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("Desc")) {
                        column.setDescription(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("EndPosition")) {
                        if (value.length() <= 0) continue;
                        column.setEndPosition(Integer.parseInt(value));
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("IsNullable")) {
                        if (value.length() <= 0) continue;
                        column.setNullable(Integer.parseInt(value) == 1);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("Name")) {
                        column.setName(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SASColumnLength")) {
                        if (value.length() <= 0) continue;
                        column.setLength(Integer.parseInt(value));
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SASColumnName")) {
                        column.setName(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SASColumnType")) {
                        if (value.length() > 0 && value.toUpperCase().charAt(0) == 'N') {
                            column.setType(1);
                            continue;
                        }
                        column.setType(0);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SASFormat")) {
                        column.setFormat(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SASInformat")) {
                        column.setInformat(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SortOrder")) {
                        column.setSortOrder(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("SummaryRole")) {
                        column.setSummaryRole(value);
                        continue;
                    }
                    if (attribute.equalsIgnoreCase(READFLAG)) {
                        if (value.length() <= 0 || !this.m_mdlTable.isFixedWidth() || value.charAt(0) != 'n' && value.charAt(0) != 'N') continue;
                        bReadColumnFlag = false;
                        continue;
                    }
                    if (row != 0) continue;
                    this.m_alMessages.add(new ImportColumnsMessage(row + 1, attrPosn + 1, attribute, "", bundle.getString("ImportNewColumnsFromEff.Error.InvalidAttribute.txt"), 2, false));
                    StringBuffer sbMsg = new StringBuffer(100);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.Error.InvalidAttribute.txt"));
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.Row.txt"));
                    sbMsg.append(space + (row + 1));
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.Column.txt"));
                    sbMsg.append(space + (attrPosn + 1));
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.ColumnAttribute.txt"));
                    sbMsg.append(space);
                    sbMsg.append(attribute);
                    Workspace.getDefaultLogger().debug((Object)sbMsg.toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    this.m_alMessages.add(new ImportColumnsMessage(row + 1, attrPosn + 1, attribute, value, bundle.getString("ImportNewColumnsFromEff.Error.IntegerValueExpected.txt"), 2, true));
                    StringBuffer sbMsg = new StringBuffer(100);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.Error.IntegerValueExpected.txt"));
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.Row.txt"));
                    sbMsg.append(space + (row + 1));
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.Column.txt"));
                    sbMsg.append(space + (attrPosn + 1));
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.ColumnAttribute.txt"));
                    sbMsg.append(space);
                    sbMsg.append(attribute);
                    sbMsg.append(space4);
                    sbMsg.append(bundle.getString("ImportNewColumnsFromEff.ColumnValue.txt"));
                    sbMsg.append(space);
                    sbMsg.append(value);
                    Workspace.getDefaultLogger().debug((Object)sbMsg.toString());
                }
            }
            this.checkEndPosnGreaterThanBeginPosn(column, row + 1);
            this.updateSASColumnLength(column);
            if (column.getName().length() == 0 || !bReadColumnFlag) {
                column.dispose();
                this.m_alMessages.add(new ImportColumnsMessage(row, 0, "SASColumnName", "", bundle.getString("ImportNewColumnsFromEff.Error.NoName.txt"), 2, true));
                continue;
            }
            alColumnObjects.add(column);
        }
        return alColumnObjects;
    }

    private void checkEndPosnGreaterThanBeginPosn(IColumn column, int row) {
        if (column.getEndPosition() < column.getBeginPosition()) {
            int beginPosn = column.getBeginPosition();
            String sEndPosn = String.valueOf(column.getEndPosition());
            column.setEndPosition(beginPosn);
            String msgString = bundle.formatString("ImportNewColumnsFromEff.Error.StartEndPosn.fmt.txt", (Object)sEndPosn, (Object)String.valueOf(beginPosn));
            this.m_alMessages.add(new ImportColumnsMessage(row, 0, "EndPosition", sEndPosn, msgString, 2, true));
        }
    }

    private void updateSASColumnLength(IColumn column) {
        if (column.getType() == 0) {
            if (column.getLength() == 0 && column.getEndPosition() > 0 && column.getBeginPosition() > 0) {
                column.setLength(column.getEndPosition() - column.getBeginPosition() + 1);
            }
        } else if (column.getType() == 1) {
            if (column.getLength() > 8) {
                column.setLength(8);
            } else if (column.getLength() > 0 && column.getLength() < 3) {
                column.setLength(3);
            }
        }
        if (column.getLength() == 0) {
            column.setLength(8);
        }
    }

    public void setMessagesList(List messages) {
        this.m_alMessages = (ArrayList)messages;
    }

    public List getMessagesList() {
        return this.m_alMessages;
    }

    static {
        m_fieldLength = 200;
        metaLib = "work";
        metaTable = "etls_Mta";
        READFLAG = "READFLAG";
        bundle = WAdminResource.getBundle(ImportNewColumnsFromEFF.class);
    }
}

