/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IFolder;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IResponsibleParty;
import com.sas.etl.models.other.IResponsiblePartyContainer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.swing.visuals.tableview.TableRowModelEvent;
import com.sas.wadmin.visuals.common.ResponsiblePartyTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsDefaultTableRowModel;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsTableRowModelEvent;
import com.sas.workspace.WsTableRowModelListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class GeneralTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(GeneralTab.class);
    private IObject m_object;
    private IComplexPersistableObject m_complexObject;
    private String m_originalName;
    private PathUrl m_originalPathUrl;
    private JLabel m_lblName;
    private WATextField m_txtName;
    private JLabel m_lblDescription;
    private JScrollPane m_scrDescription;
    private WATextArea m_txtDescription;
    private JLabel m_lblFolder;
    private WATextField m_txtFolder;
    private JButton m_btnFolder;
    private JLabel m_lblResponsibleParties;
    private WsTable m_tblResponsibleParties;
    private ResponsiblePartyTableModel m_mdlResponsibleParties;
    private JScrollPane m_scrResponsibleParties;
    private JButton m_btnNew;
    private JButton m_btnDelete;
    private JPanel m_pnlButtons;
    private boolean m_bShowFolder;
    private boolean m_bShowResponsibleParties;
    private boolean m_bSelectFolderEnabled;
    private boolean m_bFolderChanged;
    private boolean m_bFirstTimeThrough = true;
    private WsAbstractAction m_actNew;
    private WsAbstractAction m_actDelete;
    private WsAbstractAction m_actFolder;
    private IModelListener m_lsnrModel;
    private FocusListener m_lsrFocusName;
    private FocusListener m_lsrFocusDesc;

    public GeneralTab(IObject obj) {
        this(obj, false);
    }

    public GeneralTab(IObject obj, boolean bShowResponsibleParties) {
        this(obj, bShowResponsibleParties, false);
    }

    public GeneralTab(IObject obj, boolean bShowResponsibleParties, boolean bShowFolder) {
        this.setName(bundle.getString("GeneralTab.Title.txt"));
        this.m_object = obj;
        if (obj instanceof IComplexPersistableObject) {
            this.m_complexObject = (IComplexPersistableObject)obj;
            this.m_bShowResponsibleParties = bShowResponsibleParties;
            this.m_bShowFolder = bShowFolder;
        }
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("general_tab");
        this.setHelpProduct("shared");
    }

    public void setSelectFolderEnabled(boolean bEnabled) {
        if (this.m_bSelectFolderEnabled == bEnabled) {
            return;
        }
        this.m_bSelectFolderEnabled = bEnabled;
        this.updateActions();
    }

    public boolean isSelectFolderEnabled() {
        return this.m_bSelectFolderEnabled;
    }

    public void setFolder(PathUrl url) {
        if (url != null) {
            try {
                this.m_txtFolder.setText(url.getDisplayPath());
                MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), url);
                Tree tree = (Tree)metadataObject.getRepositoryEntity();
                IFolder oFolder = this.loadFolderFromID(this.m_complexObject.getModel(), tree.getFQID());
                this.m_complexObject.setFolder(oFolder);
                this.m_bFolderChanged = true;
            }
            catch (ServiceException e) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolder(Tree mdoFolder) {
        if (mdoFolder != null) {
            try {
                IFolder oFolder = this.loadFolderFromID(this.m_complexObject.getModel(), mdoFolder.getFQID());
                this.m_complexObject.setFolder(oFolder);
                String sPathWithType = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)mdoFolder.getObjectStore(), (PrimaryType)mdoFolder, true);
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                ChildServerInterface transaction = server.newChild(true);
                try {
                    PathUrl pathurl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)transaction, (String)sPathWithType);
                    this.m_txtFolder.setText(pathurl.getDisplayPath());
                    this.m_bFolderChanged = true;
                }
                finally {
                    transaction.destroy();
                }
            }
            catch (ServiceException e) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }
    }

    public boolean validateData() {
        if (this.m_bShowResponsibleParties && !this.m_tblResponsibleParties.stopCellEditing()) {
            return false;
        }
        String newString = this.m_txtName.getText().trim();
        if (newString.length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("GeneralTab.Error.NoName.txt"), (int)0);
            this.m_txtName.requestFocus();
            return false;
        }
        if (this.m_bShowFolder) {
            if (!WsMetadataNameUtil.isNameValid((String)this.m_txtName.getText())) {
                this.m_txtName.requestFocus();
                return false;
            }
            try {
                if (this.m_complexObject.getFolder() == null) {
                    MessageUtil.displayMessage((String)bundle.getString("GeneralTab.Error.NoFolder.txt"), (int)0);
                    return false;
                }
                PathUrl currentPathUrl = this.m_complexObject.getFolder().getPathUrl();
                if (currentPathUrl == null) {
                    MessageUtil.displayMessage((String)bundle.getString("GeneralTab.Error.NoFolder.txt"), (int)0);
                    return false;
                }
                if (!this.m_originalName.equals(newString) || this.m_bFolderChanged) {
                    if (this.m_originalName != null && this.m_originalName.equalsIgnoreCase(newString) && this.m_originalPathUrl != null && this.m_originalPathUrl.toString().equals(currentPathUrl.toString()) && !this.m_complexObject.isNew()) {
                        return true;
                    }
                    MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), currentPathUrl);
                    if (metadataObject != null && !WsMetadataNameUtil.isNameUniqueInFolder((String)newString, (MetadataInterface)metadataObject, (String)this.m_complexObject.getPublicType())) {
                        MessageUtil.displayMessage((String)bundle.formatString("GeneralTab.Warning.ChangeDuplicateName.fmt.txt", (Object)newString), (String)bundle.getString("GeneralTab.Warning.ChangeDuplicateName.Title.txt"), (int)0, (int)-1);
                        return false;
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            }
        }
        this.m_bFolderChanged = false;
        return true;
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        PathUrl objectPath;
        this.setListeningForChanges(false);
        this.m_txtName.setText(this.m_object.getName());
        this.m_txtDescription.setText(this.m_object.getDescription());
        if (this.m_bShowFolder && this.m_complexObject != null && this.m_complexObject.getFolder() != null && (objectPath = this.m_complexObject.getFolder().getPathUrl()) != null && objectPath.getDisplayPath() != null && objectPath.getDisplayPath().length() > 0 && this.m_bFirstTimeThrough) {
            this.m_originalName = this.m_object.getName();
            this.m_originalPathUrl = objectPath;
            this.m_bFirstTimeThrough = false;
        }
        if (this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties.moveDataToModel();
            this.updateActions();
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_object.getModel().startCompoundUndoable();
        try {
            this.updateName();
            this.updateDescription();
        }
        finally {
            this.m_object.getModel().endCompoundUndoable();
        }
    }

    private void updateName() {
        this.m_object.setName(this.m_txtName.getText().trim());
    }

    private void updateDescription() {
        this.m_object.setDescription(this.m_txtDescription.getText().trim());
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_txtName.setEditable(bEditable);
        this.m_txtDescription.setEditable(bEditable);
        if (this.m_bShowResponsibleParties) {
            this.m_tblResponsibleParties.setEditable(bEditable);
        }
        this.updateActions();
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_mdlResponsibleParties != null) {
            this.m_mdlResponsibleParties.dispose();
        }
        this.m_object.getModel().removeModelListener(this.m_lsnrModel);
        this.m_txtName.removeFocusListener(this.m_lsrFocusName);
        this.m_txtDescription.removeFocusListener(this.m_lsrFocusDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newResponsibleParty() {
        if (!this.m_tblResponsibleParties.stopCellEditing()) {
            return;
        }
        String[] saPersons = this.m_mdlResponsibleParties.getPersons();
        if (saPersons.length == 0) {
            MessageUtil.displayMessage((String)bundle.getString("GeneralTab.Error.NoPersons.txt"));
            return;
        }
        this.m_complexObject.getModel().startCompoundUndoable();
        try {
            List lRPs = this.m_complexObject.getResponsiblePartiesList();
            int iRow = this.m_tblResponsibleParties.getLastSelectedRow();
            int iRP = iRow == -1 ? lRPs.size() - 1 : lRPs.indexOf(this.m_mdlResponsibleParties.getResponsibleParty(iRow));
            this.m_tblResponsibleParties.clearSelection();
            this.m_complexObject.getModel().undoableEditHappened(this.m_tblResponsibleParties.createClearSelectionUndoable(true, false));
            IResponsibleParty rpNew = this.m_complexObject.getModel().getObjectFactory().createNewResponsibleParty();
            rpNew.setName(saPersons[0]);
            rpNew.setResponsibility("OWNER");
            lRPs.add(iRP + 1, rpNew);
            this.m_tblResponsibleParties.selectRow(iRow + 1);
            this.m_complexObject.getModel().undoableEditHappened((UndoableEdit)new SelectResponsiblePartiesUndoable(rpNew, false, true));
            int iEditColumn = Math.max(this.m_tblResponsibleParties.convertColumnIndexToView(this.m_mdlResponsibleParties.getDefaultEditColumnIndex()), 0);
            this.m_tblResponsibleParties.editCellAt(iRow + 1, iEditColumn);
        }
        finally {
            this.m_complexObject.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResponsibleParty() {
        if (!this.m_tblResponsibleParties.stopCellEditing()) {
            return;
        }
        this.m_complexObject.getModel().startCompoundUndoable();
        try {
            int[] aRows = this.m_tblResponsibleParties.getSelectedRowsFromSelectedCells();
            IResponsibleParty[] aRPs = new IResponsibleParty[aRows.length];
            for (int iRow = aRows.length - 1; iRow >= 0; --iRow) {
                int iModelRow = this.m_tblResponsibleParties.convertRowIndexToModel(aRows[iRow]);
                aRPs[iRow] = this.m_mdlResponsibleParties.getResponsibleParty(iModelRow);
            }
            this.m_complexObject.getModel().undoableEditHappened((UndoableEdit)new SelectResponsiblePartiesUndoable(aRPs, true, false));
            List lRPs = this.m_complexObject.getResponsiblePartiesList();
            for (int iRP = 0; iRP < aRPs.length; ++iRP) {
                lRPs.remove(aRPs[iRP]);
            }
            this.m_complexObject.getModel().undoableEditHappened(this.m_tblResponsibleParties.createClearSelectionUndoable(true, true));
            int iRow = Math.min(aRows[aRows.length - 1] - (aRows.length - 1), this.m_tblResponsibleParties.getRowCount() - 1);
            if (iRow >= 0) {
                this.m_tblResponsibleParties.selectRow(iRow);
            }
        }
        finally {
            this.m_complexObject.getModel().endCompoundUndoable();
        }
    }

    private void selectResponsibleParties(IResponsibleParty[] aResponsibleParties) {
        this.m_tblResponsibleParties.clearSelection();
        for (int iParty = 0; iParty < aResponsibleParties.length; ++iParty) {
            int iRow = this.m_mdlResponsibleParties.getRowIndex(aResponsibleParties[iParty]);
            if (iRow == -1) continue;
            this.m_tblResponsibleParties.addRowToSelection(this.m_tblResponsibleParties.convertRowIndexToView(iRow));
        }
    }

    protected void initialize() {
        this.m_bSelectFolderEnabled = true;
        this.createActions();
        this.m_txtName = new WATextField();
        this.m_txtName.setMaxCharacters(60);
        this.m_txtName.setToolTipText(bundle.getString("GeneralTab.Label.Name.tip"));
        this.m_lblName = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtName, (String)bundle.getString("GeneralTab.Label.Name.txt"));
        this.m_lsrFocusName = new NameFocusListener();
        this.m_txtName.addFocusListener(this.m_lsrFocusName);
        this.listenForDataChangesTo((JTextComponent)this.m_txtName);
        this.m_txtDescription = new WATextArea();
        this.m_txtDescription.setMaxCharacters(200);
        this.m_txtDescription.setLineWrap(true);
        this.m_txtDescription.setWrapStyleWord(true);
        this.m_txtDescription.setRows(5);
        this.m_txtDescription.setColumns(30);
        this.m_txtDescription.setToolTipText(bundle.getString("GeneralTab.Label.Description.tip"));
        this.m_lblDescription = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtDescription, (String)bundle.getString("GeneralTab.Label.Description.txt"));
        this.m_lsrFocusDesc = new DescriptionFocusListener();
        this.m_txtDescription.addFocusListener(this.m_lsrFocusDesc);
        this.m_scrDescription = new JScrollPane((Component)this.m_txtDescription, 20, 31);
        WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrDescription);
        this.listenForDataChangesTo((JTextComponent)this.m_txtDescription);
        if (this.m_bShowFolder) {
            this.m_txtFolder = new WATextField();
            this.m_txtFolder.setBehavior(2);
            this.m_txtFolder.setToolTipText(bundle.getString("GeneralTab.Label.Folder.tip"));
            this.m_lblFolder = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtFolder, (String)bundle.getString("GeneralTab.Label.Folder.txt"));
            this.m_lblFolder.setLabelFor((Component)this.m_txtFolder);
            this.m_actFolder = this.createSelectFolderAction();
            this.m_btnFolder = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actFolder);
            this.m_txtFolder.setText(this.getPathURL());
            Dimension preferredSize = this.m_txtFolder.getPreferredSize();
            this.m_txtFolder.setPreferredSize(new Dimension(0, preferredSize.height));
        }
        if (this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties = new ResponsiblePartyTableModel((IResponsiblePartyContainer)this.m_complexObject);
            this.m_mdlResponsibleParties.addTableModelListener(this.createTableModelListener());
            this.m_tblResponsibleParties = new WsTable((WsAbstractTableModel)this.m_mdlResponsibleParties);
            this.m_tblResponsibleParties.setToolTipText(bundle.getString("GeneralTab.Label.Responsibilities.tip"));
            this.m_lblResponsibleParties = WsUIUtilities.createLabelForComponent((JComponent)this.m_tblResponsibleParties, (String)bundle.getString("GeneralTab.Label.Responsibilities.txt"));
            this.m_tblResponsibleParties.getTableHeader().setReorderingAllowed(false);
            this.m_tblResponsibleParties.setRowHeaderVisible(false);
            this.m_tblResponsibleParties.setColumnHidingEnabled(false);
            this.m_tblResponsibleParties.setColumnHoldingEnabled(false);
            this.m_tblResponsibleParties.setAutoResizeMode(4);
            this.m_tblResponsibleParties.setKeepSortedEnabled(true);
            ((WsDefaultTableRowModel)this.m_tblResponsibleParties.getRowModel()).addRowModelListener((WsTableRowModelListener)new RowModelListener());
            this.m_tblResponsibleParties.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
            this.m_tblResponsibleParties.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
            this.m_tblResponsibleParties.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
            WsUIUtilities.adjustPreferredScrollableViewportSize((JTable)this.m_tblResponsibleParties, (int)5);
            this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
            this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
            this.m_scrResponsibleParties = new JScrollPane((Component)this.m_tblResponsibleParties, 20, 31);
            WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)this.m_scrResponsibleParties);
            this.m_scrResponsibleParties.setToolTipText(bundle.getString("GeneralTab.Label.Responsibilities.tip"));
            this.m_tblResponsibleParties.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
            this.m_tblResponsibleParties.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
            this.m_pnlButtons = new JPanel();
        }
        this.m_lsnrModel = new ModelListener();
        this.m_object.getModel().addModelListener(this.m_lsnrModel);
    }

    private String getPathURL() {
        String path = "";
        IFolder folder = this.m_complexObject.getFolder();
        if (folder != null) {
            return folder.getPathUrl().getDisplayPath();
        }
        return path;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_scrDescription.setMinimumSize(this.m_scrDescription.getPreferredSize());
        this.add(this.m_lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_scrDescription, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        if (this.m_bShowFolder) {
            this.add(this.m_lblFolder, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.m_txtFolder, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.add(this.m_btnFolder, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        if (this.m_bShowResponsibleParties) {
            this.m_pnlButtons.setLayout((LayoutManager)new WsButtonsLayout());
            this.m_pnlButtons.add(this.m_btnNew);
            this.m_pnlButtons.add(this.m_btnDelete);
            this.add(this.m_lblResponsibleParties, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.m_scrResponsibleParties, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add(this.m_pnlButtons, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 12, 2, new Insets(5, 5, 0, 0), 0, 0));
        } else {
            this.add(new JPanel(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    private TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    private WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    private WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    private void createActions() {
        if (this.m_bShowFolder) {
            this.m_actFolder = this.createSelectFolderAction();
        }
        if (this.m_bShowResponsibleParties) {
            this.m_actNew = this.createNewAction();
            this.m_actDelete = this.createDeleteAction();
        }
    }

    private void updateActions() {
        boolean bEditable = this.isEditable();
        if (this.m_bShowFolder) {
            this.m_actFolder.setEnabled(bEditable && this.m_bSelectFolderEnabled);
        }
        if (this.m_bShowResponsibleParties) {
            this.m_actNew.setEnabled(bEditable && !this.m_tblResponsibleParties.isSorted());
            this.m_actDelete.setEnabled(bEditable && this.m_tblResponsibleParties.getSelectedRowsFromSelectedCells().length > 0);
        }
    }

    private WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    private WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    private WsAbstractAction createSelectFolderAction() {
        return new cSelectFolderAction();
    }

    private PathUrl getPath() {
        String sInitPath = "";
        try {
            if (this.m_complexObject.getFolder() == null) {
                PathUrl url = WsMetadataUtil.getDefaultFolderPathUrl();
                sInitPath = url.toString();
            } else {
                sInitPath = this.m_complexObject.getFolder().getPathUrl().toString();
            }
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        SimpleObject[] aObjects = null;
        if (this.m_complexObject != null && !this.m_complexObject.isNew()) {
            aObjects = new SimpleObject[]{this.m_complexObject};
        }
        return WsMetadataUtil.promptForPathUrl((String)sInitPath, (boolean)false, aObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFolder loadFolderFromID(IModel mdl, String sID) throws RemoteException, MdException {
        OMRAdapter omr = new OMRAdapter(mdl, Workspace.getMdFactory(), "LoadExistingFolder");
        boolean oldUndo = mdl.isUndoSupported();
        mdl.setUndoSupported(false);
        try {
            IFolder oFolder = mdl.getObjectFactory().createFolder(sID);
            omr.populateFor((IOMRPersistable)oFolder);
            oFolder.loadFromOMR(omr);
            IFolder iFolder = oFolder;
            return iFolder;
        }
        finally {
            mdl.setUndoSupported(oldUndo);
            omr.dispose();
        }
    }

    private class SelectResponsiblePartiesUndoable
    extends AbstractUndoableEdit {
        private IResponsibleParty[] m_aResponsibleParties;
        private boolean m_bOnUndo;
        private boolean m_bOnRedo;

        public SelectResponsiblePartiesUndoable(IResponsibleParty party, boolean bOnUndo, boolean bOnRedo) {
            this(new IResponsibleParty[]{party}, bOnUndo, bOnRedo);
        }

        public SelectResponsiblePartiesUndoable(IResponsibleParty[] aResponsibleParties, boolean bOnUndo, boolean bOnRedo) {
            this.m_aResponsibleParties = aResponsibleParties;
            this.m_bOnUndo = bOnUndo;
            this.m_bOnRedo = bOnRedo;
        }

        @Override
        public void undo() {
            super.undo();
            GeneralTab.this.m_tblResponsibleParties.cancelCellEditing();
            if (this.m_bOnUndo) {
                GeneralTab.this.selectResponsibleParties(this.m_aResponsibleParties);
            }
        }

        @Override
        public void redo() {
            super.redo();
            GeneralTab.this.m_tblResponsibleParties.cancelCellEditing();
            if (this.m_bOnRedo) {
                GeneralTab.this.selectResponsibleParties(this.m_aResponsibleParties);
            }
        }

        @Override
        public void die() {
            super.die();
            Arrays.fill(this.m_aResponsibleParties, null);
            this.m_aResponsibleParties = null;
        }
    }

    private class DescriptionFocusListener
    implements FocusListener {
        private DescriptionFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            GeneralTab.this.updateDescription();
        }
    }

    private class NameFocusListener
    implements FocusListener {
        private NameFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            GeneralTab.this.updateName();
        }
    }

    private class RowModelListener
    implements WsTableRowModelListener {
        private RowModelListener() {
        }

        public void rowDragged(TableRowModelEvent ev) {
        }

        public void rowsRemapped(ChangeEvent ev) {
            GeneralTab.this.updateActions();
        }

        public void rowsHidden(WsTableRowModelEvent ev) {
        }

        public void rowsShown(WsTableRowModelEvent ev) {
        }
    }

    private class cSelectFolderAction
    extends WsAbstractAction {
        public cSelectFolderAction() {
            super(bundle, "GeneralTab.Action.SelectFolder", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            PathUrl url = GeneralTab.this.getPath();
            if (url != null) {
                GeneralTab.this.m_txtFolder.setText(url.getDisplayPath());
                try {
                    MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), url);
                    Tree tree = (Tree)metadataObject.getRepositoryEntity();
                    IFolder oFolder = GeneralTab.this.loadFolderFromID(GeneralTab.this.m_complexObject.getModel(), tree.getFQID());
                    GeneralTab.this.m_complexObject.setFolder(oFolder);
                    GeneralTab.this.m_bFolderChanged = true;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
                }
                GeneralTab.this.setDataChanged(true);
            }
        }
    }

    private class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "GeneralTab.Action.Delete", 0);
        }

        public void actionPerformed(ActionEvent e) {
            GeneralTab.this.deleteResponsibleParty();
        }
    }

    private class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "GeneralTab.Action.New", 0);
        }

        public void actionPerformed(ActionEvent e) {
            GeneralTab.this.newResponsibleParty();
        }
    }

    private class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cTablePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)GeneralTab.this.m_actNew));
            mnuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)GeneralTab.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class cTableModelListener
    implements TableModelListener {
        private cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (GeneralTab.this.isListeningForChanges()) {
                GeneralTab.this.setDataChanged(true);
            }
        }
    }

    private class cTableSelectionListener
    implements ListSelectionListener {
        private cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            GeneralTab.this.updateActions();
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            GeneralTab.this.setListeningForChanges(false);
            try {
                String sType = ev.getType();
                IObject obj = ev.getModelObject();
                if (sType == "ModelController:UnknownChanges") {
                    GeneralTab.this.m_txtName.setText(GeneralTab.this.m_object.getName());
                    GeneralTab.this.m_txtDescription.setText(GeneralTab.this.m_object.getDescription());
                } else if (obj == GeneralTab.this.m_object && sType == "Object:NameChanged") {
                    GeneralTab.this.m_txtName.setText(GeneralTab.this.m_object.getName());
                } else if (obj == GeneralTab.this.m_object && sType == "Object:DescriptionChanged") {
                    GeneralTab.this.m_txtDescription.setText(GeneralTab.this.m_object.getDescription());
                } else if (obj == GeneralTab.this.m_object && sType == "IComplexPersistableObject:FolderChanged") {
                    GeneralTab.this.m_txtFolder.setText(GeneralTab.this.m_complexObject.getFolder().getPathUrl().getDisplayPath());
                }
            }
            finally {
                GeneralTab.this.setListeningForChanges(true);
            }
        }
    }
}

