/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.IProperty;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConditionActionOptionEventPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ConditionActionOptionEventPanel.class);
    private IConditionActionSet m_oConditionActionSet;
    private List m_lEventTemplates;
    protected JLabel m_lblEvent;
    protected WAComboBox m_cmbEvent;
    protected WsAbstractAction m_actEvent;

    public ConditionActionOptionEventPanel(IConditionActionSet oConditionActionSet, List lEventTemplates) {
        this.m_oConditionActionSet = oConditionActionSet;
        this.m_lEventTemplates = lEventTemplates;
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("event_options_win");
    }

    protected void initialize() {
        this.m_cmbEvent = new WAComboBox();
        this.m_cmbEvent.addActionListener((ActionListener)this.m_actEvent);
        this.m_lblEvent = new JLabel(bundle.getString("ConditionActionOptionEventPanel.Event.lbl.txt"));
        this.m_lblEvent.setDisplayedMnemonic(bundle.getString("ConditionActionOptionEventPanel.Event.lbl.mnem").charAt(0));
        this.m_lblEvent.setLabelFor((Component)this.m_cmbEvent);
        this.setPreferredSize(new Dimension(200, 300));
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblEvent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_cmbEvent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        List actions = this.m_oConditionActionSet.getActionList();
        if (actions == null || actions.isEmpty()) {
            return;
        }
        IProperty oEventProperty = null;
        List lActionOptions = ((IConditionAction)actions.get(0)).getActionPropertiesList();
        for (int iProperty = 0; iProperty < lActionOptions.size(); ++iProperty) {
            IProperty oActionOption = (IProperty)lActionOptions.get(iProperty);
            if (!oActionOption.getPropertyRole().equals("Event")) continue;
            oEventProperty = oActionOption;
        }
        ArrayList<String> lEventNames = new ArrayList<String>();
        for (int iEvent = 0; iEvent < this.m_lEventTemplates.size(); ++iEvent) {
            lEventNames.add(((IProperty)this.m_lEventTemplates.get(iEvent)).getName());
        }
        this.populateComboBox(lEventNames, this.m_cmbEvent);
        if (oEventProperty != null && oEventProperty.getDefaultValue() != null) {
            for (int iSetEvent = 0; iSetEvent < this.m_lEventTemplates.size(); ++iSetEvent) {
                IProperty oProperty = (IProperty)this.m_lEventTemplates.get(iSetEvent);
                if (!oProperty.getName().equals(oEventProperty.getName())) continue;
                this.m_cmbEvent.setSelectedItem((Object)oProperty.getName());
            }
        }
        this.setListeningForChanges(true);
    }

    public void populateComboBox(List lValues, WAComboBox cmb) {
        cmb.removeAllItems();
        int nValues = lValues.size();
        for (int iValue = 0; iValue < nValues; ++iValue) {
            cmb.addItem(lValues.get(iValue));
        }
    }

    public boolean validateData() {
        return true;
    }

    public IProperty getSelectEvent() {
        String sEventName = (String)this.m_cmbEvent.getSelectedItem();
        for (int iEvent = 0; iEvent < this.m_lEventTemplates.size(); ++iEvent) {
            if (!((IProperty)this.m_lEventTemplates.get(iEvent)).getName().equals(sEventName)) continue;
            return (IProperty)this.m_lEventTemplates.get(iEvent);
        }
        return null;
    }
}

