/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IReflectiveObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsColumnMetadataUtil;
import javax.swing.Icon;

public class ColumnUIUtilities {
    private static final WAdminResource bundle = WAdminResource.getBundle(ColumnUIUtilities.class);
    public static final String NONE = bundle.getString("ColumnUIUtilities.None.txt");
    private static final Icon CHARACTER_ICON = bundle.getIcon("ColumnUIUtilities.Character.image");
    private static final Icon NUMERIC_ICON = bundle.getIcon("ColumnUIUtilities.Numeric.image");
    private static final Icon PRIMARY_KEY_ICON = AppIconFactory.getInstance().getIconForPrivateType("Type:PrimaryKey");
    private static final Icon UNIQUE_KEY_ICON = AppIconFactory.getInstance().getIconForPrivateType("Type:UniqueKey");
    private static final Icon FOREIGN_KEY_ICON = AppIconFactory.getInstance().getIconForPrivateType("Type:ForeignKey");
    private static final Icon INDEX_ICON = AppIconFactory.getInstance().getIconForPrivateType("Type:Index");
    private static final Icon PROPERTIES_ICON = AppIconFactory.getInstance().getIconForAction("Common:Properties");
    private static final Icon BLANK_ICON = bundle.getIcon("ColumnUIUtilities.Blank.image");
    private static final String VIEW_CHARACTER_TYPE = bundle.getString("ColumnUIUtilities.Character.txt");
    private static final String VIEW_NUMERIC_TYPE = bundle.getString("ColumnUIUtilities.Numeric.txt");
    private static final String[] VIEW_TYPES = new String[]{VIEW_CHARACTER_TYPE, VIEW_NUMERIC_TYPE};
    private static final String VIEW_SUMMARY_CLASS = "CLASS";
    private static final String VIEW_SUMMARY_ID = "ID";
    private static final String VIEW_SUMMARY_STATISTIC = "STATISTIC";
    private static final String VIEW_SUMMARY_DEFAULT = "_DEFAULT_";
    private static final String VIEW_SUMMARY_TYPE = "_TYPE_";
    private static final String VIEW_SUMMARY_FREQUENCY = "_FREQ_";
    private static final String VIEW_SUMMARY_NONE = NONE;
    private static final String[] VIEW_SUMMARIES = new String[]{"CLASS", "ID", "STATISTIC", "_DEFAULT_", "_TYPE_", "_FREQ_", VIEW_SUMMARY_NONE};
    private static final String VIEW_SORT_ASCENDING = bundle.getString("ColumnUIUtilities.SortOrder.Ascending.txt");
    private static final String VIEW_SORT_DESCENDING = bundle.getString("ColumnUIUtilities.SortOrder.Descending.txt");
    private static final String VIEW_SORT_ASCENDING_FORMATTED = bundle.getString("ColumnUIUtilities.SortOrder.AscendingFormatted.txt");
    private static final String VIEW_SORT_DESCENDING_FORMATTED = bundle.getString("ColumnUIUtilities.SortOrder.DescendingFormatted.txt");
    private static final String VIEW_SORT_DATASET_ORDER = bundle.getString("ColumnUIUtilities.SortOrder.DataSetOrder.txt");
    private static final String VIEW_SORT_NONE = NONE;
    private static final String[] VIEW_SORTS = new String[]{VIEW_SORT_ASCENDING, VIEW_SORT_DESCENDING, VIEW_SORT_ASCENDING_FORMATTED, VIEW_SORT_DESCENDING_FORMATTED, VIEW_SORT_DATASET_ORDER, VIEW_SORT_NONE};

    private ColumnUIUtilities() {
    }

    public static Icon getTypeIcon(IColumn column) {
        if (column instanceof IReflectiveObject) {
            column = (IColumn)((IReflectiveObject)column).getOMRObject();
        }
        return ColumnUIUtilities.getTypeIcon(column.getType());
    }

    public static Icon getTypeIcon(int type) {
        return type == 1 ? NUMERIC_ICON : CHARACTER_ICON;
    }

    public static String[] getViewTypes() {
        return VIEW_TYPES;
    }

    public static String getViewType(int eModelType) {
        return eModelType == 1 ? VIEW_NUMERIC_TYPE : VIEW_CHARACTER_TYPE;
    }

    public static int getModelType(String sViewType) {
        return VIEW_NUMERIC_TYPE.equals(sViewType) ? 1 : 0;
    }

    public static String[] getViewSortOrders() {
        return VIEW_SORTS;
    }

    public static String getViewSortOrder(String sModelSortOrder) {
        if ("".equals(sModelSortOrder)) {
            return VIEW_SORT_NONE;
        }
        if ("ASCENDING".equals(sModelSortOrder)) {
            return VIEW_SORT_ASCENDING;
        }
        if ("DESCENDING".equals(sModelSortOrder)) {
            return VIEW_SORT_DESCENDING;
        }
        if ("ASCFORMATTED".equals(sModelSortOrder)) {
            return VIEW_SORT_ASCENDING_FORMATTED;
        }
        if ("DSCFORMATTED".equals(sModelSortOrder)) {
            return VIEW_SORT_DESCENDING_FORMATTED;
        }
        if ("DSORDER".equals(sModelSortOrder)) {
            return VIEW_SORT_DATASET_ORDER;
        }
        return sModelSortOrder;
    }

    public static String getModelSortOrder(String sViewSortOrder) {
        if (VIEW_SORT_NONE.equals(sViewSortOrder)) {
            return "";
        }
        if (VIEW_SORT_ASCENDING.equals(sViewSortOrder)) {
            return "ASCENDING";
        }
        if (VIEW_SORT_DESCENDING.equals(sViewSortOrder)) {
            return "DESCENDING";
        }
        if (VIEW_SORT_ASCENDING_FORMATTED.equals(sViewSortOrder)) {
            return "ASCFORMATTED";
        }
        if (VIEW_SORT_DESCENDING_FORMATTED.equals(sViewSortOrder)) {
            return "DSCFORMATTED";
        }
        if (VIEW_SORT_DATASET_ORDER.equals(sViewSortOrder)) {
            return "DSORDER";
        }
        return sViewSortOrder;
    }

    public static String[] getViewSummaryRoles() {
        return VIEW_SUMMARIES;
    }

    public static String getViewSummaryRole(String sModelSummaryRole) {
        if ("".equals(sModelSummaryRole)) {
            return VIEW_SUMMARY_NONE;
        }
        if (VIEW_SUMMARY_CLASS.equals(sModelSummaryRole)) {
            return VIEW_SUMMARY_CLASS;
        }
        if (VIEW_SUMMARY_DEFAULT.equals(sModelSummaryRole)) {
            return VIEW_SUMMARY_DEFAULT;
        }
        if (VIEW_SUMMARY_ID.equals(sModelSummaryRole)) {
            return VIEW_SUMMARY_ID;
        }
        if (VIEW_SUMMARY_STATISTIC.equals(sModelSummaryRole)) {
            return VIEW_SUMMARY_STATISTIC;
        }
        return sModelSummaryRole;
    }

    public static String getModelSummaryRole(String sViewSummaryRole) {
        if (VIEW_SUMMARY_NONE.equals(sViewSummaryRole)) {
            return "";
        }
        if (VIEW_SUMMARY_CLASS.equals(sViewSummaryRole)) {
            return VIEW_SUMMARY_CLASS;
        }
        if (VIEW_SUMMARY_DEFAULT.equals(sViewSummaryRole)) {
            return VIEW_SUMMARY_DEFAULT;
        }
        if (VIEW_SUMMARY_ID.equals(sViewSummaryRole)) {
            return VIEW_SUMMARY_ID;
        }
        if (VIEW_SUMMARY_STATISTIC.equals(sViewSummaryRole)) {
            return VIEW_SUMMARY_STATISTIC;
        }
        return sViewSummaryRole;
    }

    public static String getViewInformat(String sInformat) {
        return sInformat.length() == 0 ? WsColumnMetadataUtil.NONE : sInformat;
    }

    public static String getViewFormat(String sFormat) {
        return sFormat.length() == 0 ? WsColumnMetadataUtil.NONE : sFormat;
    }

    public static String getModelInformat(String sInformat) {
        return WsColumnMetadataUtil.NONE.equals(sInformat) ? "" : sInformat;
    }

    public static String getModelFormat(String sFormat) {
        return WsColumnMetadataUtil.NONE.equals(sFormat) ? "" : sFormat;
    }

    public static Icon getUsageIcon(IColumn column) {
        ITable tbl;
        if (column instanceof IReflectiveObject) {
            column = (IColumn)((IReflectiveObject)column).getOMRObject();
        }
        if ((tbl = column.getTable()) == null || !(tbl instanceof IPhysicalTable)) {
            return BLANK_ICON;
        }
        IPhysicalTable table = (IPhysicalTable)tbl;
        IKey[] aKeys = table.getKeys();
        for (int iKey = 0; iKey < aKeys.length; ++iKey) {
            if (!aKeys[iKey].getColumnsList().contains(column)) continue;
            return aKeys[iKey].isPrimary() ? PRIMARY_KEY_ICON : UNIQUE_KEY_ICON;
        }
        IForeignKey[] aForeignKeys = table.getForeignKeys();
        for (int iForeignKey = 0; iForeignKey < aForeignKeys.length; ++iForeignKey) {
            if (!aForeignKeys[iForeignKey].getColumnsList().contains(column)) continue;
            return FOREIGN_KEY_ICON;
        }
        IIndex[] aIndexes = table.getIndexes();
        for (int iIndex = 0; iIndex < aIndexes.length; ++iIndex) {
            if (!aIndexes[iIndex].getColumnsList().contains(column)) continue;
            return INDEX_ICON;
        }
        return BLANK_ICON;
    }

    public static Icon getPropertiesIcon(IColumn column) {
        if (column instanceof IReflectiveObject) {
            column = (IColumn)((IReflectiveObject)column).getOMRObject();
        }
        if (column.getPrivateNote() != null || column.getNotesList().size() > 0 || column.getDocumentsList().size() > 0 || column.getExtendedAttributesList().size() > 0) {
            return PROPERTIES_ICON;
        }
        return BLANK_ICON;
    }
}

