/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.editor.EditableRegion;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IFile;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ObjectComparator;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.visuals.common.CodeGenerationController;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.SaveAsDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;

public class CodePane
extends WsEditorPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(CodePane.class);
    private static final Color READONLY_TEXT_COLOR = Color.BLACK;
    private static final Color READONLY_BACKGROUND_COLOR = SystemColor.control;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actScrollTop;
    protected WsAbstractAction m_actScrollBottom;
    private JLabel m_lblStatus;
    private JToolBar m_toolbar;
    private JButton m_btnNew;
    private JButton m_btnOpen;
    private JButton m_btnSave;
    private JButton m_btnSaveAs;
    private JButton m_btnCut;
    private JButton m_btnCopy;
    private JButton m_btnPaste;
    private JButton m_btnDelete;
    private JButton m_btnScrollTop;
    private JButton m_btnScrollBottom;
    private SaveAsDialog m_dlgSave;
    private ICodeGenerationEnvironment m_environment;
    private String m_sDefaultFileName;
    private String m_sDefaultMetadataName;
    private String m_sDefaultMetadataDesc;
    private IObject m_selectedObject;
    private IUserWrittenCodeContainer m_parentObject;
    private CodeGenerationController m_codeGenerator;
    private int m_iHeaderLength;
    private int m_iFooterLength;
    private IModelListener m_lsnrModel;
    private String m_sFileName;
    private String m_sSaveKey;

    public CodePane(IUserWrittenCodeContainer parentObject) {
        this(parentObject, null, "");
    }

    public CodePane(IUserWrittenCodeContainer parentObject, CodeGenerationController codeGenerator) {
        this(parentObject, codeGenerator, "");
    }

    public CodePane(IUserWrittenCodeContainer parentObject, CodeGenerationController codeGenerator, String sSaveKey) {
        this.m_codeGenerator = codeGenerator;
        this.m_sSaveKey = sSaveKey;
        this.m_lsnrModel = new ModelListener();
        this.setCodeSource(this.m_parentObject);
        this.setHelpProduct("texteditor");
        this.setHelpTopic("editorspace");
    }

    protected void initialize() {
        super.initialize();
        this.m_btnNew = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actNew);
        this.m_btnOpen = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actOpen);
        this.m_btnSave = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actSave);
        this.m_btnSaveAs = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actSaveAs);
        this.m_btnCut = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCut);
        this.m_btnCopy = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCopy);
        this.m_btnPaste = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actPaste);
        this.m_btnDelete = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actDelete);
        this.m_btnScrollTop = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actScrollTop);
        this.m_btnScrollBottom = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actScrollBottom);
        this.m_toolbar = this.createToolbar();
        this.m_dlgSave = new SaveAsDialog((Frame)Workspace.getWorkspace());
        this.m_lblStatus = new JLabel();
    }

    public JEditorPane getEditor() {
        return this.m_txtEditor;
    }

    public IUserWrittenCodeContainer getCodeSource() {
        return this.m_parentObject;
    }

    protected LinkedHashMap getOpenFileTypes() {
        LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
        mapFileTypes.put(bundle.getString("CodePane.OpenPanel.SASFileTypes.txt"), "SAS");
        mapFileTypes.put(bundle.getString("CodePane.OpenPanel.AllFileTypes.txt"), "*");
        return mapFileTypes;
    }

    protected LinkedHashMap getLocalOpenFileTypes() {
        LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
        mapFileTypes.put(bundle.getString("CodePane.OpenPanel.SASFileTypes.txt"), "SAS");
        return mapFileTypes;
    }

    public void setCodeSource(IUserWrittenCodeContainer codeSource) {
        this.setCodeSource(this.m_codeGenerator, codeSource, true, this.m_codeGenerator != null ? this.m_codeGenerator.getCodeGenerator().isGenerateDISHeaderAndFooters() : true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCodeToEdit(CodeGenerationController controller, IUserWrittenCodeContainer codeSource, boolean bReload, boolean useCompleteCode) throws ServerException, CodegenException, RemoteException, BadLibraryDefinitionException, BadServerDefinitionException, MdException {
        String code = "";
        if (bReload) {
            code = this.m_parentObject.getCode();
        } else {
            IModel model = codeSource.getModel();
            boolean oldUndo = model.isUndoSupported();
            boolean oldActive = codeSource.isActive();
            model.setUndoSupported(false);
            try {
                codeSource.setIsActive(false);
                code = !useCompleteCode ? controller.getBodyCode(true).toString() : controller.getCode(true).toString();
                codeSource.setUserWrittenCode(code);
            }
            finally {
                codeSource.setIsActive(oldActive);
                model.setUndoSupported(oldUndo);
            }
        }
        return code;
    }

    public int setCodeSource(CodeGenerationController controller, IUserWrittenCodeContainer codeSource, boolean bReloadCode, boolean useDISHeaderandFooters) {
        if (this.m_parentObject != null) {
            this.m_parentObject.getModel().removeModelListener(this.m_lsnrModel);
        }
        this.m_parentObject = codeSource;
        if (this.m_parentObject != null) {
            this.m_parentObject.getModel().addModelListener(this.m_lsnrModel);
        }
        try {
            if (this.m_dlgSave == null) {
                this.m_dlgSave = new SaveAsDialog((Frame)Workspace.getWorkspace());
            }
            if (this.m_parentObject != null && this.m_cmpEditor != null) {
                if (this.m_codeGenerator != null && useDISHeaderandFooters) {
                    IServer stepServer;
                    StringBuffer sbCompleteCode = new StringBuffer();
                    IServer defaultServer = ModelUIUtilities.acquireModelForDefaultSASAppServer(this.m_codeGenerator.getCodeGenerator().getModel());
                    boolean isRemote = !ObjectComparator.isEqual((Object)defaultServer, (Object)(stepServer = this.m_codeGenerator.getCodeGenerator().getServerForStep(defaultServer)));
                    String sBody = this.getCodeToEdit(controller, codeSource, bReloadCode, false);
                    ICodeGenerationEnvironment env = CodeGenerationEnvironmentFactory.getInstance().createCodeGenerationEnvironment(this.m_codeGenerator.getCodeGenerator().getJob(), defaultServer);
                    String sHeader = this.m_codeGenerator.getCodeGenerator().getGeneratedCodeHeader(env.createNewCodeSegment((IObject)this.m_parentObject), defaultServer, isRemote, false).getGeneratedCode().toString();
                    String sFooter = this.m_codeGenerator.getCodeGenerator().getGeneratedCodeFooter(env.createNewCodeSegment((IObject)this.m_parentObject), defaultServer, isRemote, false).getGeneratedCode().toString();
                    this.m_iHeaderLength = sHeader.length();
                    this.m_iFooterLength = sFooter.length();
                    sbCompleteCode.append(sHeader);
                    sbCompleteCode.append(sBody);
                    sbCompleteCode.append("\n");
                    sbCompleteCode.append(sFooter);
                    this.setText(sbCompleteCode.toString());
                    int iHeaderLines = sHeader.split("\n", -1).length - 1;
                    int iBodyLines = sBody.split("\n", -1).length;
                    EditableRegion editableRegion = new EditableRegion(iHeaderLines, iHeaderLines + iBodyLines - 1);
                    this.m_cmpEditor.setEditableRegion(editableRegion, READONLY_TEXT_COLOR, READONLY_BACKGROUND_COLOR);
                } else {
                    try {
                        String code = this.getCodeToEdit(controller, codeSource, bReloadCode, true);
                        this.setText(code);
                    }
                    catch (ServerException e) {
                        MessageUtil.displayMessage((String)bundle.formatString("CodePane.MissingServer.fmt.txt", (Object)e.getLocalizedMessage()), (int)0);
                    }
                }
            } else if (this.m_cmpEditor != null) {
                this.setText("");
            }
            if (this.m_parentObject != null && this.m_parentObject.getUserWrittenSourceCode() != null && this.m_parentObject.isActive()) {
                if (!this.m_parentObject.isFile()) {
                    ICodeSource src = this.m_parentObject.getUserWrittenSourceCode();
                    this.m_dlgSave.setMetadataName(src.getName());
                    this.m_dlgSave.setMetadataDescription(src.getDescription());
                    this.m_dlgSave.setSaveAsMetadata(true);
                } else {
                    this.m_dlgSave.setSaveAsMetadata(false);
                    IFile file = (IFile)this.m_parentObject.getUserWrittenSourceCode();
                    IServer server = file.getServer();
                    String serverId = null;
                    if (server != null) {
                        serverId = server.getID();
                        this.m_dlgSave.setFileServer(serverId);
                    }
                    this.m_dlgSave.setFileLocation(file.getPath());
                    this.m_dlgSave.setFileName(file.getShortFileName());
                }
            } else {
                this.m_dlgSave.setMetadataName(this.getDefaultMetadataName());
                this.m_dlgSave.setMetadataDescription(this.getDefaultMetadataDesc());
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (ServerException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (CodegenException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        this.updateStatusLabel();
        return this.m_iHeaderLength;
    }

    public String getEditableText(boolean bStripHeaderAndFooter) {
        String completeText = this.getText();
        int completeTextLength = completeText.length();
        if (this.m_codeGenerator != null && bStripHeaderAndFooter && completeTextLength > 0) {
            return completeText.substring(this.m_iHeaderLength, completeTextLength - this.m_iFooterLength - 1);
        }
        return completeText;
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add(this.m_toolbar, "North");
        this.add((Component)this.m_cmpEditor, "Center");
        this.add(this.m_lblStatus, "South");
    }

    protected JToolBar createToolbar() {
        JToolBar toolbar = WsUIUtilities.createToolBar();
        toolbar.add(this.m_btnNew);
        toolbar.add(this.m_btnOpen);
        toolbar.add(this.m_btnSave);
        toolbar.add(this.m_btnSaveAs);
        toolbar.addSeparator();
        toolbar.add(this.m_btnCut);
        toolbar.add(this.m_btnCopy);
        toolbar.add(this.m_btnPaste);
        toolbar.add(this.m_btnDelete);
        toolbar.addSeparator();
        toolbar.add(this.m_btnScrollTop);
        toolbar.add(this.m_btnScrollBottom);
        return toolbar;
    }

    protected void createActions() {
        super.createActions();
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actScrollTop = this.createScrollTopAction();
        this.m_actScrollBottom = this.createScrollBottomAction();
    }

    protected void updateActions() {
        super.updateActions();
        if (this.m_cmpEditor != null) {
            this.m_actDelete.setEnabled(this.m_cmpEditor.canCut());
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actDelete.setActive(bActive);
    }

    public void setText(String text) {
        super.setText(text);
        this.m_selectedObject = null;
        this.m_txtEditor.setCaretPosition(0);
    }

    public void setCodeGenerationEnvironment(ICodeGenerationEnvironment codeGenerationEnvironment) {
        this.m_environment = codeGenerationEnvironment;
    }

    public ICodeGenerationEnvironment getCodeGenerationEnvironment() {
        return this.m_environment;
    }

    public void setSelectedModelObject(IObject object) {
        if (this.m_environment == null) {
            throw new UnsupportedOperationException("setCodeSegments() must be called before calling this method");
        }
        int startIndex = this.m_codeGenerator.getEnvironment().getCodeGenerationStart(object);
        if (startIndex == -1) {
            return;
        }
        int endIndex = this.m_codeGenerator.getEnvironment().getCodeGenerationEnd(object);
        try {
            this.m_txtEditor.scrollRectToVisible(this.m_txtEditor.modelToView(endIndex));
            this.m_txtEditor.setCaretPosition(endIndex);
            this.m_txtEditor.moveCaretPosition(startIndex);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public IObject getSelectedModelObject() {
        return this.m_selectedObject;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable);
        this.m_actSave.setEnabled(bEditable);
    }

    public void saveSettingsAndCleanUp() {
        if (this.m_parentObject != null) {
            this.m_parentObject.getModel().removeModelListener(this.m_lsnrModel);
        }
        super.saveSettingsAndCleanUp();
    }

    private void updateStatusLabel() {
        String sText = "";
        String sTooltip = "";
        if (this.m_parentObject != null && this.m_parentObject.isActive()) {
            if (this.m_parentObject.isFile()) {
                IFile file = (IFile)this.m_parentObject.getUserWrittenSourceCode();
                IServer server = file.getServer();
                String sServerName = server == null ? "" : server.getName();
                this.m_sFileName = file.getShortFileName();
                sText = bundle.formatString("SaveAsDialog.FileStatusLabel.fmt", (Object)sServerName, (Object)this.m_sFileName);
                sTooltip = bundle.formatString("SaveAsDialog.FileStatusLabel.fmt", (Object)sServerName, (Object)file.getFileName());
                this.m_lblStatus.setText(sText);
                this.m_lblStatus.setToolTipText(this.wrapFileName(sTooltip));
            } else {
                ICodeSource src = this.m_parentObject.getUserWrittenSourceCode();
                if (src != null) {
                    sTooltip = sText = bundle.formatString("SaveAsDialog.MetadataStatusLabel.fmt", (Object)src.getName());
                    if (!this.m_dlgSave.getMetadataName().trim().isEmpty()) {
                        this.m_lblStatus.setText(sText);
                        this.m_lblStatus.setToolTipText(this.wrapFileName(sTooltip));
                    }
                }
            }
        }
    }

    private String wrapFileName(String sText) {
        StringBuffer buf = new StringBuffer(sText);
        for (int i = sText.length() - sText.length() % 100; i > 0; i -= 100) {
            buf.insert(i, "<P>");
        }
        buf.insert(0, "<HTML>");
        buf.append("</HTML>");
        return buf.toString();
    }

    protected void onNew() {
        int savePrompt;
        if (this.hasDataChanged() && (savePrompt = this.promptedSave()) != 0 && savePrompt != 1) {
            return;
        }
        this.m_dlgSave = null;
        this.setText("");
        if (this.m_parentObject != null) {
            this.m_parentObject.setUserWrittenCode("");
        }
        if (this.m_codeGenerator != null && this.m_codeGenerator.getCodeGenerator().isUsingUserWrittenCode() && this.m_codeGenerator.getCodeGenerator().isGenerateDISHeaderAndFooters()) {
            this.setCodeSource(this.m_codeGenerator, this.m_parentObject, true, true);
        }
        this.setTemporaryFileName("");
        this.setDataChanged(false);
    }

    public boolean open() {
        int savePrompt;
        if (this.hasDataChanged() && (savePrompt = this.promptedSave()) != 0 && savePrompt != 1) {
            return false;
        }
        if (this.m_codeGenerator != null && this.m_codeGenerator.getCodeGenerator().isUsingUserWrittenCode() && this.m_codeGenerator.getCodeGenerator().isGenerateDISHeaderAndFooters()) {
            this.m_cmpEditor.setEditableRegion(null, null, null);
        }
        boolean bReturn = this.showOpenDialog();
        if (this.m_codeGenerator != null && this.m_codeGenerator.getCodeGenerator().isUsingUserWrittenCode() && this.m_codeGenerator.getCodeGenerator().isGenerateDISHeaderAndFooters()) {
            this.setCodeSource(this.m_codeGenerator, this.m_parentObject, true, true);
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showOpenDialog() {
        boolean bSuccess;
        OpenPanel pnlOpen = new OpenPanel(this.m_sSaveKey);
        Window wdwParent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        String sTitle = bundle.getString("CodePane.OpenPanel.title");
        WAStandardDialog dlg = wdwParent instanceof Frame ? new WAStandardDialog((Frame)wdwParent, sTitle, true) : new WAStandardDialog((Dialog)wdwParent, sTitle, true);
        dlg.setMainPanel((WAPanel)pnlOpen);
        dlg.show();
        if (dlg.getReturnValue() != 1) {
            return false;
        }
        String sFileName = pnlOpen.getFileName();
        boolean bl = bSuccess = pnlOpen.isFileLocal() ? this.readLocalFile(sFileName) : this.readRemoteFile(sFileName);
        if (bSuccess) {
            this.m_dlgSave = null;
            this.m_parentObject.getModel().startCompoundUndoable();
            try {
                this.m_parentObject.setUserWrittenCode(this.getText());
                if (pnlOpen.getOpenMode() == 2) {
                    try {
                        IServer iServer = ModelUIUtilities.getServerForAppServer(this.m_parentObject.getModel(), WsAppServer.getDefaultAppServerFQID());
                        ICodeSource srcCode = this.m_parentObject.getUserWrittenSourceCode();
                        if (srcCode == null || !this.m_parentObject.isFile()) {
                            srcCode = this.m_parentObject.createUserWrittenSourceCodeFile(sFileName, iServer);
                        }
                        IFile srcFile = (IFile)srcCode;
                        srcFile.setFileName(sFileName);
                        srcFile.setName(sFileName);
                        this.m_parentObject.setUserWrittenSourceCode((ICodeSource)srcFile);
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    }
                }
            }
            finally {
                this.m_parentObject.getModel().endCompoundUndoable();
            }
        }
        return bSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readRemoteFile(String sFileName) {
        WsAppServer appServer = WsAppServer.createDefaultAppServer();
        try {
            String contents = appServer.readFile(sFileName);
            this.m_txtEditor.setText(contents);
            this.m_txtEditor.getCodeEditorDocument().setFilename(sFileName);
            boolean bl = true;
            return bl;
        }
        catch (GenericError ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        finally {
            appServer.dispose();
        }
        return false;
    }

    protected boolean readLocalFile(String sFileName) {
        try {
            this.m_txtEditor.openFile(sFileName);
            return true;
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return false;
        }
    }

    public boolean save() {
        if (!this.validateData()) {
            return false;
        }
        if (this.m_dlgSave != null && this.m_dlgSave.getSaveAsPanel().validateData() && this.saveFromDialog()) {
            return true;
        }
        return this.saveAs(false);
    }

    public boolean saveAsLocal() {
        return super.saveAs();
    }

    public boolean saveAs() {
        return this.saveAs(true);
    }

    protected void handleSaveAsAction() {
        if (this.isEditable()) {
            this.saveAs();
        } else {
            this.saveAsLocal();
        }
    }

    protected String getDefaultFileName() {
        return this.m_sDefaultFileName;
    }

    protected void setDefaultFileName(String defaultName) {
        this.m_sDefaultFileName = defaultName;
    }

    protected String getDefaultMetadataName() {
        return this.m_sDefaultMetadataName;
    }

    protected void setDefaultMetadataName(String defaultName) {
        this.m_sDefaultMetadataName = defaultName;
    }

    protected String getDefaultMetadataDesc() {
        return this.m_sDefaultMetadataDesc;
    }

    protected void setDefaultMetadataDesc(String defaultDesc) {
        this.m_sDefaultMetadataDesc = defaultDesc;
    }

    public boolean saveAs(boolean bCheckValidData) {
        if (bCheckValidData && !this.validateData()) {
            return false;
        }
        if (this.m_dlgSave == null) {
            this.m_dlgSave = new SaveAsDialog((Frame)Workspace.getWorkspace());
        }
        this.m_dlgSave.setDefaultFileName(this.m_sDefaultFileName);
        this.m_dlgSave.setDefaultMetadataName(this.m_sDefaultMetadataName);
        this.m_dlgSave.setDefaultMetadataDesc(this.m_sDefaultMetadataDesc);
        this.m_dlgSave.show();
        if (this.m_dlgSave.getReturnValue() == 1) {
            return this.saveFromDialog();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFromDialog() {
        Workspace.getDefaultLogger().debug((Object)"Saving code");
        this.getParent().setCursor(Cursor.getPredefinedCursor(3));
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            block23: {
                IModel model = this.m_parentObject.getModel();
                ICodeSource srcCode = this.m_parentObject.getUserWrittenSourceCode();
                boolean bHeaderFooterOn = this.m_codeGenerator != null && this.m_codeGenerator.getCodeGenerator().isGenerateDISHeaderAndFooters();
                model.startCompoundUndoable();
                try {
                    if (this.m_dlgSave.isSaveAsMetadata()) {
                        if (srcCode == null || this.m_parentObject.isFile()) {
                            srcCode = this.m_parentObject.createUserWrittenSourceCodeText(this.m_dlgSave.getMetadataName());
                        }
                        srcCode.setName(this.m_dlgSave.getMetadataName());
                        srcCode.setDescription(this.m_dlgSave.getMetadataDescription());
                        srcCode.setCode(this.getEditableText(bHeaderFooterOn));
                        break block23;
                    }
                    WsAppServer server = this.m_dlgSave.getFileServer();
                    try {
                        IServer iServer = ModelUIUtilities.getServerForAppServer(model, server);
                        if (srcCode == null || !this.m_parentObject.isFile()) {
                            srcCode = this.m_parentObject.createUserWrittenSourceCodeFile(this.m_dlgSave.getFileName(), iServer);
                        }
                        IFile srcFile = (IFile)srcCode;
                        srcFile.setFileName(server.getFileFullPath(this.m_dlgSave.getFileLocation(), this.m_dlgSave.getFileName()));
                        srcFile.setCode(this.getEditableText(bHeaderFooterOn));
                        srcFile.setName(this.m_dlgSave.getFileName());
                        this.m_parentObject.setUserWrittenSourceCode((ICodeSource)srcFile);
                    }
                    finally {
                        if (server != null) {
                            server.dispose();
                        }
                    }
                }
                finally {
                    model.endCompoundUndoable();
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Writing");
        }
        catch (ServerException ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        catch (WsAppServerFailException we) {
            MessageUtil.displayMessage((String)we.getLocalizedMessage(), (int)0);
        }
        catch (GenericError ge) {
            MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
        }
        finally {
            Workspace.getDefaultLogger().debug((Object)"Finished saving source code");
            this.getParent().setCursor(Cursor.getDefaultCursor());
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
        return false;
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createSaveAction() {
        return new cSaveAction();
    }

    protected WsAbstractAction createSaveAsAction() {
        return new cSaveAsAction();
    }

    protected WsAbstractAction createScrollTopAction() {
        return new cScrollTopAction();
    }

    protected WsAbstractAction createScrollBottomAction() {
        return new cScrollBottomAction();
    }

    protected class cScrollBottomAction
    extends WsAbstractAction {
        public cScrollBottomAction() {
            super(bundle, "CodePane.ScrollBottomAction", 18);
        }

        public void actionPerformed(ActionEvent e) {
            CodePane.this.m_txtEditor.moveCaretToEndOfDocument();
        }
    }

    protected class cScrollTopAction
    extends WsAbstractAction {
        public cScrollTopAction() {
            super(bundle, "CodePane.ScrollTopAction", 18);
        }

        public void actionPerformed(ActionEvent e) {
            CodePane.this.m_txtEditor.moveCaretPosition(0);
            CodePane.this.m_txtEditor.select(0, 0);
        }
    }

    protected class cSaveAsAction
    extends WsAbstractAction {
        public cSaveAsAction() {
            super(bundle, "CodePane.SaveAsAction", 16);
            this.setMenuSupportId("saveas");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:SaveAs"));
        }

        public void actionPerformed(ActionEvent e) {
            CodePane.this.handleSaveAsAction();
        }
    }

    protected class cSaveAction
    extends WsAbstractAction {
        public cSaveAction() {
            super(bundle, "CodePane.SaveAction", 16);
            this.setMenuSupportId("save");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Save"));
        }

        public void actionPerformed(ActionEvent e) {
            CodePane.this.save();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "CodePane.DeleteAction", 16);
            this.setMenuSupportId("Common:Delete");
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Delete"));
        }

        public void actionPerformed(ActionEvent e) {
            CodePane.this.m_txtEditor.replaceSelection("");
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "CodePane.NewAction", 16);
            this.setIcon(AppIconFactory.getAppInstance().getIconForAction("File:New:Code"));
        }

        public void actionPerformed(ActionEvent e) {
            CodePane.this.onNew();
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (obj == CodePane.this.m_parentObject.getOwner()) {
                if ("IUserWrittenCode:activeChanged".equals(sType) || "IUserWrittenCode:codeChanged".equals(sType) || "IPrePostCode:PreProcessCodeChanged".equals(sType) || "IPrePostCode:PostProcessCodeChanged".equals(sType)) {
                    CodePane.this.updateStatusLabel();
                }
            } else if (obj == CodePane.this.m_parentObject.getUserWrittenSourceCode() && ("Object:NameChanged".equals(sType) || "IFile:FileNameChanged".equals(sType))) {
                CodePane.this.updateStatusLabel();
            }
        }
    }

    private class OpenPanel
    extends WAPanel {
        public static final int IMPORT = 1;
        public static final int ATTACH_TO = 2;
        private static final String LAST_LOCAL_FILE_KEY = "CodePane.OpenPanel.ImportFile";
        private static final String LAST_REMOTE_FILE_KEY = "CodePane.OpenPanel.AttachToFile";
        private static final String LAST_OPEN_LOCAL = "CodePane.OpenLocal.OpenLocal";
        private JRadioButton m_rbnImport;
        private JRadioButton m_rbnAttachTo;
        private WATextField m_txtImport;
        private WATextField m_txtAttachTo;
        private JButton m_btnImportLocal;
        private JButton m_btnImportRemote;
        private JButton m_btnAttachToRemote;
        private WsAbstractToggleAction m_actImport;
        private WsAbstractToggleAction m_actAttachTo;
        private WsAbstractAction m_actImportLocal;
        private WsAbstractAction m_actImportRemote;
        private WsAbstractAction m_actAttachToRemote;
        private int m_eOpenMode;
        private boolean m_bLocal;
        private String m_sLastLocal;
        private String m_sLastRemote;
        private String m_sStateKey;

        public OpenPanel(String sStateKey) {
            this.createActions();
            this.createComponents();
            this.layoutComponents();
            this.m_sStateKey = sStateKey;
            this.restoreSettings();
            this.m_actImport.setSelected(true);
            this.setOpenMode(1);
            this.setHelpProduct("wdb");
            this.setHelpTopic("code_tab_open");
        }

        public void saveSettingsAndCleanUp() {
            this.saveSettings();
        }

        private void createActions() {
            this.m_actImport = new ImportAction();
            this.m_actImportLocal = new ImportLocalAction();
            this.m_actImportRemote = new ImportRemoteAction();
            this.m_actAttachTo = new AttachToAction();
            this.m_actAttachToRemote = new AttachToRemoteAction();
        }

        private void createComponents() {
            this.m_rbnImport = WsUIUtilities.createRadioButton((WsAbstractToggleAction)this.m_actImport);
            this.m_rbnAttachTo = WsUIUtilities.createRadioButton((WsAbstractToggleAction)this.m_actAttachTo);
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.m_rbnImport);
            grp.add(this.m_rbnAttachTo);
            this.m_txtImport = new WATextField(40);
            this.m_txtAttachTo = new WATextField(40);
            this.m_btnImportLocal = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actImportLocal);
            this.m_btnImportRemote = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actImportRemote);
            this.m_btnAttachToRemote = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAttachToRemote);
        }

        private void layoutComponents() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_rbnImport, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_txtImport, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 0, 0), 0, 0));
            this.add(this.m_btnImportLocal, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.add(this.m_btnImportRemote, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add(this.m_rbnAttachTo, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)this.m_txtAttachTo, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 10, 0), 0, 0));
            this.add(this.m_btnAttachToRemote, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 0), 0, 0));
        }

        private void restoreSettings() {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            this.m_sLastLocal = appDefaults.getPropertyString(LAST_LOCAL_FILE_KEY + this.m_sStateKey, "");
            this.m_sLastRemote = appDefaults.getPropertyString(LAST_REMOTE_FILE_KEY + this.m_sStateKey, "");
            this.setFileLocal(appDefaults.getPropertyBoolean(LAST_OPEN_LOCAL + this.m_sStateKey, true));
            this.m_txtImport.setText(this.isFileLocal() ? this.m_sLastLocal : this.m_sLastRemote);
            this.m_txtAttachTo.setText(this.m_sLastRemote);
        }

        private void saveSettings() {
            WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
            appDefaults.setPropertyString(LAST_LOCAL_FILE_KEY + this.m_sStateKey, this.m_sLastLocal);
            appDefaults.setPropertyString(LAST_REMOTE_FILE_KEY + this.m_sStateKey, this.m_sLastRemote);
            appDefaults.setPropertyBoolean(LAST_OPEN_LOCAL + this.m_sStateKey, this.isFileLocal());
        }

        public void setFileLocal(boolean bLocal) {
            this.m_bLocal = bLocal;
        }

        public boolean isFileLocal() {
            return this.m_bLocal;
        }

        public String getFileName() {
            if (this.m_eOpenMode == 1) {
                return this.m_txtImport.getText();
            }
            return this.m_txtAttachTo.getText();
        }

        public void setOpenMode(int eOpenMode) {
            if (this.m_eOpenMode == eOpenMode) {
                return;
            }
            this.m_eOpenMode = eOpenMode;
            this.m_txtImport.setEnabled(eOpenMode == 1);
            this.m_txtAttachTo.setEnabled(eOpenMode == 2);
            this.m_actImportLocal.setEnabled(eOpenMode == 1);
            this.m_actImportRemote.setEnabled(eOpenMode == 1);
            this.m_actAttachToRemote.setEnabled(eOpenMode == 2);
        }

        public int getOpenMode() {
            return this.m_eOpenMode;
        }

        private void importLocal() {
            String sFileName = this.m_bLocal ? this.m_txtImport.getText() : this.m_sLastLocal;
            if ((sFileName = this.showLocalOpenDialog(sFileName)) != null) {
                this.m_txtImport.setText(sFileName);
                this.m_sLastLocal = sFileName;
                this.setFileLocal(true);
            }
        }

        private void importRemote() {
            String sFileName = !this.m_bLocal ? this.m_txtImport.getText() : this.m_sLastRemote;
            if ((sFileName = this.showRemoteOpenDialog(sFileName)) != null) {
                this.m_txtImport.setText(sFileName);
                this.m_sLastRemote = sFileName;
                this.setFileLocal(false);
            }
        }

        private void attachToRemote() {
            String sFileName = this.m_txtAttachTo.getText();
            if (sFileName.length() == 0) {
                sFileName = this.m_sLastRemote;
            }
            if ((sFileName = this.showRemoteOpenDialog(sFileName)) != null) {
                this.m_txtAttachTo.setText(sFileName);
                this.m_sLastRemote = sFileName;
                this.setFileLocal(false);
            }
        }

        private String showLocalOpenDialog(String sFileName) {
            int returnVal;
            String sDirectory = sFileName;
            int iLastSlash = sDirectory.lastIndexOf(92);
            if (iLastSlash > 0) {
                sDirectory = sDirectory.substring(0, iLastSlash);
            }
            String sTitle = bundle.getString("CodePane.OpenPanel.LocalOpen.title");
            JFileChooser chooser = new JFileChooser(sDirectory);
            chooser.setDialogTitle(sTitle);
            chooser.setAcceptAllFileFilterUsed(true);
            List<FileFilter> filters = this.getFileFilters();
            for (FileFilter f : filters) {
                chooser.addChoosableFileFilter(f);
            }
            if (filters.size() > 0) {
                chooser.setFileFilter(filters.get(0));
            }
            if ((returnVal = chooser.showOpenDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)))) == 0) {
                return chooser.getSelectedFile().getAbsolutePath();
            }
            return null;
        }

        protected List<FileFilter> getFileFilters() {
            ArrayList<FileFilter> lst = new ArrayList<FileFilter>();
            LinkedHashMap map = CodePane.this.getLocalOpenFileTypes();
            for (Object key : ((HashMap)map).keySet()) {
                lst.add(new cFileFilter((String)((HashMap)map).get(key), (String)key));
            }
            return lst;
        }

        private String showRemoteOpenDialog(String sFileName) {
            WsAppServer server = WsAppServer.createDefaultAppServer();
            try {
                if (sFileName.length() == 0 || !server.doesFileExist(server.getParentDirectory(sFileName))) {
                    sFileName = "";
                }
                String sTitle = bundle.getString("CodePane.OpenPanel.RemoteOpen.title");
                return server.promptForFilename(sTitle, sFileName, (HashMap)CodePane.this.getOpenFileTypes());
            }
            catch (WsAppServerFailException we) {
                MessageUtil.displayMessage((String)we.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
            return null;
        }

        private class AttachToRemoteAction
        extends WsAbstractAction {
            public AttachToRemoteAction() {
                super(bundle, "CodePane.OpenPanel.Action.AttachToRemote", 256);
            }

            public void actionPerformed(ActionEvent ev) {
                OpenPanel.this.attachToRemote();
            }
        }

        private class ImportRemoteAction
        extends WsAbstractAction {
            public ImportRemoteAction() {
                super(bundle, "CodePane.OpenPanel.Action.ImportRemote", 256);
            }

            public void actionPerformed(ActionEvent ev) {
                OpenPanel.this.importRemote();
            }
        }

        private class ImportLocalAction
        extends WsAbstractAction {
            public ImportLocalAction() {
                super(bundle, "CodePane.OpenPanel.Action.ImportLocal", 256);
            }

            public void actionPerformed(ActionEvent ev) {
                OpenPanel.this.importLocal();
            }
        }

        private class AttachToAction
        extends WsAbstractToggleAction {
            public AttachToAction() {
                super(bundle, "CodePane.OpenPanel.Action.AttachTo", 256);
            }

            public void actionPerformed(ActionEvent ev) {
                OpenPanel.this.setOpenMode(2);
            }
        }

        private class ImportAction
        extends WsAbstractToggleAction {
            public ImportAction() {
                super(bundle, "CodePane.OpenPanel.Action.Import", 256);
            }

            public void actionPerformed(ActionEvent ev) {
                OpenPanel.this.setOpenMode(1);
            }
        }

        private class cFileFilter
        extends FileFilter {
            private String _extension;
            private String _description;

            public cFileFilter(String extension, String description) {
                this._extension = extension;
                this._description = description;
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                int pos = name.lastIndexOf(46);
                if (pos > -1) {
                    return this._extension.equalsIgnoreCase(name.substring(pos + 1));
                }
                return false;
            }

            @Override
            public String getDescription() {
                return this._description;
            }
        }
    }
}

