/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.AssignLibraryView;
import com.sas.workspace.mgmt.visuals.DBMSLibnamePropertyView;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryPropertyView;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class WsLibraryPanel
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(WsLibraryPanel.class);
    protected ArrayList m_cardClasses;
    protected ArrayList m_cardClassesNames;
    protected List vSASLibraryList;
    protected String m_strXMLSelectString;
    protected String m_strEngineTypeToLookFor;
    protected String m_strSASLibraryToSelect;
    protected SASLibrary m_foundLibrary;
    protected int m_iLibrarySelectedIndex;
    protected int m_strSelectedIndex;
    private JLabel m_label;
    private JButton m_editButton;
    private JButton m_newButton;
    private WAComboBox m_libraryBox;
    private WsAbstractAction m_newAction;
    private WsAbstractAction m_editAction;
    protected boolean m_showLabel = true;
    protected boolean m_displayShare;
    private SASLibrary m_library;
    private MdObjectStore m_store;
    private MdObjectStore m_returnStore;

    public WsLibraryPanel() {
        this(true);
    }

    public WsLibraryPanel(boolean showLabel) {
        this.m_showLabel = showLabel;
        this.m_displayShare = true;
        try {
            this.m_store = Workspace.getMdFactory().createObjectStore(null, "WsLibraryPanel");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.setHelpProduct("shared");
        this.setHelpTopic("ws_library");
        this.initialize();
    }

    public void initialize() {
        this.m_strSelectedIndex = 0;
        this.m_libraryBox = new WAComboBox();
        this.listenForDataChangesTo((JComboBox)this.m_libraryBox);
        this.vSASLibraryList = new Vector();
        this.m_strSASLibraryToSelect = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("WsLibraryPanel.LastLibrarySelected");
        this.m_iLibrarySelectedIndex = 0;
        this.m_label = new JLabel(bundle.getString("WsLibraryPanel.Label.Library.txt"));
        this.m_label.setDisplayedMnemonic(bundle.getString("WsLibraryPanel.Label.Library.mnem").charAt(0));
        this.m_label.setLabelFor((Component)this.m_libraryBox);
        this.m_libraryBox.setSorted(true);
        this.m_libraryBox.setToolTipText(bundle.getString("WsLibraryPanel.LibraryToolTip.txt"));
        this.m_libraryBox.setPrototypeDisplayValue((Object)"MMMMMMMMMMMM");
        this.m_newAction = new NewAction();
        this.m_newButton = new JButton((Action)this.m_newAction);
        this.m_editAction = new EditAction();
        this.m_editButton = new JButton((Action)this.m_editAction);
        this.setLayout(new GridBagLayout());
        if (this.m_showLabel) {
            this.add(this.m_label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.m_libraryBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.m_newButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_editButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
    }

    public void setReturnStore(MdObjectStore store) {
        this.m_returnStore = store;
    }

    public MdObjectStore getReturnedObjectsStore() {
        return this.m_returnStore;
    }

    public void setSASLibraryToSelect(String fqid) {
        this.m_strSASLibraryToSelect = fqid;
    }

    public String getSASLibraryToSelect() {
        return this.m_strSASLibraryToSelect;
    }

    public void setEngine(String strEngine) {
        this.m_strEngineTypeToLookFor = strEngine;
    }

    public void setLibraryComboBoxToolTipText(String toolTipText) {
        this.m_libraryBox.setToolTipText(toolTipText);
    }

    public void setLabelAndMnemonic(String label, String mnemonic) {
        this.m_label.setText(label);
        this.m_label.setDisplayedMnemonic(mnemonic.charAt(0));
    }

    public void setNewButtonLabelAndMnemonic(String label, String mnemonic) {
        this.m_newButton.setText(label);
        this.m_newButton.setMnemonic(mnemonic.charAt(0));
    }

    public void setEditButtonLabelAndMnemonic(String label, String mnemonic) {
        this.m_editButton.setText(label);
        this.m_editButton.setMnemonic(mnemonic.charAt(0));
    }

    public boolean validateData() {
        return true;
    }

    public void setSelectionCriteria(String strXMLSelectString, String strEngineType) {
        this.m_strXMLSelectString = strXMLSelectString;
        this.m_strEngineTypeToLookFor = strEngineType;
    }

    public void setDisplayShareLibraries(boolean display) {
        this.m_displayShare = display;
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            this.populateStore();
            this.moveDataToView();
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.initializeLibraryCombo();
        this.updateComponents();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        CMetadata library = (CMetadata)this.m_libraryBox.getSelectedItem();
        if (library == null) {
            return;
        }
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("WsLibraryPanel.LastLibrarySelected", library.getFQID());
        if (library instanceof SASLibrary) {
            this.m_library = (SASLibrary)library;
            if (this.m_returnStore != null) {
                this.m_library = (SASLibrary)Workspace.getWorkspace().getMdObjectFactory().createComplexMetadataObject(this.m_returnStore, library);
                MdStoreUtil.copyObjectAttributes((CMetadata)library, (CMetadata)this.m_library, (int)2);
            }
            Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("WsLibraryPanel.LastLibrarySelected");
        }
    }

    public void initializeLibraryCombo() {
        this.queryMetadata();
        if (!this.m_displayShare) {
            block5: for (int libraryIndex = 0; libraryIndex < this.vSASLibraryList.size(); ++libraryIndex) {
                SASLibrary library = (SASLibrary)this.vSASLibraryList.get(libraryIndex);
                try {
                    if (library.getEngine().equals("REMOTE")) {
                        this.vSASLibraryList.remove(libraryIndex);
                        continue;
                    }
                    AssociationList servers = library.getDeployedComponents();
                    for (int serverIndex = 0; serverIndex < servers.size(); ++serverIndex) {
                        ServerComponent serverComponent;
                        CMetadata server = (CMetadata)servers.get(serverIndex);
                        if (!server.getCMetadataType().equals("ServerComponent") || !(serverComponent = (ServerComponent)server).getClassIdentifier().equalsIgnoreCase("SHARE")) continue;
                        this.vSASLibraryList.remove(libraryIndex);
                        continue block5;
                    }
                    continue;
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    continue;
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        if (this.m_libraryBox.hasItems()) {
            this.m_libraryBox.removeAllItems();
        }
        this.m_libraryBox.addItems(this.vSASLibraryList);
        if (!this.vSASLibraryList.isEmpty()) {
            if (this.m_strSASLibraryToSelect.length() > 0) {
                for (int i = 0; i < this.m_libraryBox.getItemCount(); ++i) {
                    try {
                        if (!((SASLibrary)this.m_libraryBox.getItemAt(i)).getFQID().equalsIgnoreCase(this.m_strSASLibraryToSelect)) continue;
                        this.m_libraryBox.setSelectedIndex(i);
                        continue;
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
                if (this.m_libraryBox.getSelectedIndex() < 0) {
                    this.m_libraryBox.setSelectedIndex(0);
                }
            } else {
                this.m_libraryBox.setSelectedIndex(0);
            }
            this.m_editButton.setEnabled(true);
        } else {
            this.m_editButton.setEnabled(false);
        }
    }

    public SASLibrary getLibrary() {
        return (SASLibrary)this.m_libraryBox.getSelectedItem();
    }

    public JLabel getLabel() {
        return this.m_label;
    }

    public WAComboBox getLibraryComboBox() {
        return this.m_libraryBox;
    }

    public JButton getNewButton() {
        return this.m_newButton;
    }

    public JButton getEditButton() {
        return this.m_editButton;
    }

    public RelationalSchema getSchema() throws MdException, RemoteException {
        SASLibrary iLib = (SASLibrary)this.m_libraryBox.getSelectedItem();
        if (iLib.getIsDBMSLibname() > 0 && iLib.getEngine().toUpperCase().startsWith("REMOTE")) {
            return (SASLibrary)((SASLibrary)this.m_libraryBox.getSelectedItem()).getUsingPackages().elementAt(0);
        }
        if (this.m_strEngineTypeToLookFor.compareTo("SAS") == 0 || this.m_strEngineTypeToLookFor.compareTo("OTHER") == 0 && iLib.getIsDBMSLibname() == 0) {
            return null;
        }
        return (RelationalSchema)((SASLibrary)this.m_libraryBox.getSelectedItem()).getUsingPackages().elementAt(0);
    }

    protected void queryMetadata() {
        try {
            String sOptions = null;
            if (this.m_strXMLSelectString == null && this.m_strEngineTypeToLookFor == null) {
                return;
            }
            sOptions = this.m_strXMLSelectString != null ? this.m_strXMLSelectString : (this.m_strEngineTypeToLookFor.compareTo("SAS") == 0 ? "<XMLSELECT Search=\"@ISDBMSLIBNAME='0'\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SASShare") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'REMOTE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("DB2UNXPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'DB2UNXPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("DB2OS390") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'DB2OS390']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCOTHER") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCOTHER']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCACCESS") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCACCESS']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCEXCEL") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCEXCEL']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCINFORMIX") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCINFORMIX']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCORACLE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCORACLE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCSQLSVR") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCSQLSVR']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCSQLSVRPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCSQLSVRPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCSYBASE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCSYBASE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCTERADATA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCTERADATA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCDB2OS390") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCDB2OS390']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("ODBCDB2UNXPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'ODBCDB2UNXPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBOTHER") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBOTHER']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBACCESS") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBACCESS']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBEXCEL") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBEXCEL']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBINFORMIX") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBINFORMIX']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBORACLE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBORACLE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBSQLSVR") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBSQLSVR']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBSQLSVRPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBSQLSVRPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBSYBASE") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBSYBASE']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBTERADATA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBTERADATA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBDB2OS390") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBDB2OS390']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBDB2UNXPC") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBDB2UNXPC']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OLEDBNETEZZA") == 0 ? "<XMLSelect search=\"*[LibraryConnection/SASClientConnection/Source/*[@ProductName = 'OLEDBNETEZZA']]\"/>" : (this.m_strEngineTypeToLookFor.compareTo("SPDE") == 0 ? "<XMLSELECT Search=\"@ENGINE='" + this.m_strEngineTypeToLookFor + "'\"/>" : (this.m_strEngineTypeToLookFor.compareTo("OTHER") == 0 ? "<XMLSelect search=\"*[UsingPrototype/*[@Name = 'Generic Library']]\"/>" : "<XMLSELECT Search=\"@ENGINE='" + this.m_strEngineTypeToLookFor + "' and @ISDBMSLIBNAME='1'\"/>")))))))))))))))))))))))))))));
            List listWithCheckouts = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, Workspace.getWorkspace().getDefaultRepository().getFQID(), "SASLibrary", 8584, sOptions);
            this.vSASLibraryList = !listWithCheckouts.isEmpty() ? Workspace.removeCheckouts((List)listWithCheckouts) : listWithCheckouts;
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_label != null) {
            this.m_label.setEnabled(editable);
        }
        this.m_editButton.setEnabled(editable && this.m_libraryBox.getItemCount() > 0);
        this.m_newButton.setEnabled(editable);
        this.m_libraryBox.setEnabled(editable);
    }

    public void saveSettingsAndCleanUp() {
        try {
            super.saveSettingsAndCleanUp();
            this.m_store.dispose();
            Workspace.getMdFactory().dumpDetailHashMap();
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void updateComponents() {
        this.m_editAction.setEnabled(this.m_libraryBox.getItemCount() > 0);
    }

    private class EditAction
    extends WsAbstractAction {
        protected EditAction() {
            super(bundle, "WsLibraryPanel.Action.Edit", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MdObjectStore childStore = Workspace.getMdFactory().createObjectStore(null, "WsLibraryPanel.EditLibrary");
                SASLibrary selectedLibrary = (SASLibrary)WsLibraryPanel.this.m_libraryBox.getSelectedItem();
                CMetadata oLibrary = Workspace.getMdFactory().createComplexMetadataObject(childStore, null, selectedLibrary.getName(), selectedLibrary.getCMetadataType(), selectedLibrary.getId(), null);
                WAPropertyDialog editDialog = new WAPropertyDialog((Frame)Workspace.getWorkspace(), selectedLibrary.getName() + " " + bundle.getString("WsLibraryPanel.Edit.Title.txt"), true);
                Library lib = new Library(Workspace.getWorkspace().getDefaultRepository().getFQID(), (DeployedDataPackage)oLibrary, (MdObjectStore)oLibrary.getObjectStore());
                editDialog.setMetadataObject(oLibrary);
                editDialog.addTab(bundle.getString("WsLibraryPanel.Edit.General.Title.txt"), (WAPropertyTab)new WAGeneralPropertyTab(oLibrary, null, false, false, true, false));
                editDialog.addTab(bundle.getString("WsLibraryPanel.Edit.Options.Title.txt"), (WAPropertyTab)new LibraryPropertyView(lib, 1));
                if (selectedLibrary.getIsDBMSLibname() == 1) {
                    editDialog.addTab(bundle.getString("WsLibraryPanel.Edit.DataServer.Title.txt"), (WAPropertyTab)new DBMSLibnamePropertyView(lib, 1));
                }
                AssignLibraryView assignTab = new AssignLibraryView(lib, 1);
                assignTab.setHelpProduct("shared");
                assignTab.setHelpTopic("assign_tab");
                editDialog.addTab(bundle.getString("WsLibraryPanel.Edit.Assign.Title.txt"), (WAPropertyTab)assignTab);
                editDialog.addTab(bundle.getString("WsLibraryPanel.Edit.Notes.Title.txt"), (WAPropertyTab)new JOMANotesTab((Root)oLibrary));
                editDialog.addTab(bundle.getString("WsLibraryPanel.ExtendedAttributes.Notes.Title.txt"), (WAPropertyTab)new WAExtAttrPropertyTab(oLibrary));
                editDialog.addTab(bundle.getString("WsLibraryPanel.Advanced.Title.txt"), (WAPropertyTab)new WsGenericGeneralPropertyTab(oLibrary));
                editDialog.show();
                int index = WsLibraryPanel.this.m_libraryBox.getSelectedIndex();
                WsLibraryPanel.this.m_libraryBox.setSelectedIndex(index);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private class NewAction
    extends WsAbstractAction {
        protected NewAction() {
            super(bundle, "WsLibraryPanel.Action.New", false, false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Library library;
                LibraryWizard m_wizard;
                Workspace work = Workspace.getWorkspace();
                MdObjectStore childStore = Workspace.getMdFactory().createObjectStore(null, "WsLibraryPanel.NewLibraryWizard");
                Tree tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)childStore);
                String sRepositoryID = "";
                sRepositoryID = work.isChangeManagementOn() || tree == null ? work.getDefaultRepository().getFQID() : "A0000001." + tree.getRepositoryID();
                String engineName = WsLibraryPanel.this.m_strEngineTypeToLookFor;
                if (engineName != null) {
                    if (engineName.startsWith("ODBC")) {
                        engineName = "ODBC";
                    } else if (engineName.startsWith("OLEDB")) {
                        engineName = "OLEDB";
                    }
                }
                try {
                    if (WsLibraryPanel.this.m_strEngineTypeToLookFor == "OTHER") {
                        m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("WsLibraryPanel.New.Title.txt"), null, childStore, null, tree);
                    } else if (WsLibraryPanel.this.m_strEngineTypeToLookFor != null) {
                        String[] aLibEngine;
                        if (WsLibraryPanel.this.m_strEngineTypeToLookFor.equalsIgnoreCase("SASSHARE")) {
                            aLibEngine = new String[]{"REMOTE"};
                            m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("WsLibraryPanel.New.Title.txt"), aLibEngine, childStore, null, tree);
                        } else {
                            aLibEngine = new String[]{engineName};
                            m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("WsLibraryPanel.New.Title.txt"), aLibEngine, childStore, null, tree);
                        }
                    } else {
                        m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("WsLibraryPanel.New.Title.txt"), null, childStore, null, tree);
                    }
                }
                catch (Exception ex) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
                    MessageUtil.displayMessage((String)ex.getMessage());
                    childStore.dispose();
                    return;
                }
                m_wizard.show();
                if (!(m_wizard.getReturnValue() != 1 && m_wizard.getReturnValue() != 3 || (library = (Library)m_wizard.getWizardData("Library")) == null || library.getDeployedDataPackage().isNewObject())) {
                    SASLibrary sasLibraryObject = (SASLibrary)library.getDeployedDataPackage();
                    if (WsLibraryPanel.this.m_returnStore != null) {
                        sasLibraryObject = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(WsLibraryPanel.this.m_returnStore, (CMetadata)sasLibraryObject);
                    }
                    WsLibraryPanel.this.m_libraryBox.addItem((Object)sasLibraryObject);
                    WsLibraryPanel.this.m_libraryBox.setSelectedItem((Object)sasLibraryObject);
                    WsLibraryPanel.this.m_editButton.setEnabled(true);
                }
                childStore.dispose();
                WsLibraryPanel.this.updateComponents();
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
        }
    }
}

