/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.model.tree.DefaultNodeFactory;
import com.sas.wadmin.model.tree.DefaultRepositoryFolderNode;
import com.sas.wadmin.model.tree.FolderNode;
import com.sas.wadmin.model.tree.NoMembersFilter;
import com.sas.wadmin.visuals.MultiInventoryTreeNode;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.wadmin.visuals.WAdminTree_ChangeManagement;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WAdminTree_Warehouse
extends WAdminTree_ChangeManagement {
    private static WAdminResource bundle = WAdminResource.getBundle(WAdminTree_Warehouse.class);
    public static final String UNGROUPED = bundle.getString("WAdminTree_Warehouse.Ungrouped.txt");
    protected String m_sTreeName = "WarehouseTree";
    protected String m_sSoftClass = "com.sas.wadmin.visuals.TheAppWA";
    private boolean m_bMain;
    private WsAbstractAction m_actNewFolder;
    private WsAbstractAction m_actNewObject;
    private static int s_nModels = 0;

    public WAdminTree_Warehouse() {
        this.getSelectionModel().setSelectionMode(4);
    }

    void setMain(boolean bMain) {
        this.m_bMain = bMain;
    }

    boolean isMain() {
        return this.m_bMain;
    }

    public CMetadata getSelectedTree() {
        WsTreeNode node = this.getSelectedNode();
        if (node instanceof cTreeTreeNode) {
            return ((cTreeTreeNode)node).getTreeObject();
        }
        return null;
    }

    public ArrayList getAncestorTrees(Tree oTreeObject) {
        try {
            ArrayList<Tree> arAncestors = new ArrayList<Tree>();
            Tree oTree = oTreeObject.getParentTree();
            if (oTree == null) {
                return arAncestors;
            }
            arAncestors.add(oTree);
            arAncestors.addAll(this.getAncestorTrees(oTreeObject.getParentTree()));
            return arAncestors;
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    @Override
    protected void addPopupMenuItems(JPopupMenu menuPopup, WsTreeNode[] aNodes) {
        if (aNodes.length == 1) {
            if (aNodes[0] instanceof FolderNode || aNodes[0] instanceof DefaultRepositoryFolderNode) {
                if (menuPopup.getComponentCount() > 0) {
                    menuPopup.addSeparator();
                }
                menuPopup.add((Action)this.m_actNewFolder);
            }
            if (aNodes[0] instanceof FolderNode) {
                menuPopup.add((Action)this.m_actNewObject);
            }
        }
        super.addPopupMenuItems(menuPopup, aNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNewFolder() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "CustomTree:onNewFolder");
            try {
                Tree mdoNewFolder;
                this.expandPath(this.getSelectionPath());
                WsTreeNode nodeFolder = this.getSelectedNode();
                if (nodeFolder instanceof FolderNode) {
                    Tree mdoFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, nodeFolder.getMetadata());
                    mdoNewFolder = CustomTreeModel.addFolder(mdoFolder);
                } else {
                    mdoNewFolder = CustomTreeModel.addRootFolder(nodeFolder.getFQID(), store);
                }
                mdoNewFolder.updateMetadataAll();
                String sNewFolderFQID = mdoNewFolder.getFQID();
                for (int iChild = 0; iChild < nodeFolder.getChildCount(); ++iChild) {
                    WsTreeNode nodeChild = (WsTreeNode)nodeFolder.getChildAt(iChild);
                    if (!nodeChild.getFQID().equals(sNewFolderFQID)) continue;
                    TreePath pathChild = this.getSelectionPath().pathByAddingChild(nodeChild);
                    this.setSelectionPath(pathChild);
                    this.startEditingAtPath(pathChild);
                    break;
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Creating");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNewObject() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "CustomTree:onNewObject");
            try {
                WsDataTreeNode nodeFolder = (WsDataTreeNode)this.getSelectedNode();
                Tree mdoFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, nodeFolder.getMetadata());
                NewObjectWizard wizard = new NewObjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("NewObjectWizard.tab1Title.txt"), mdoFolder);
                wizard.show();
                wizard.handleGlobals();
            }
            finally {
                store.dispose();
                Workspace.getMdFactory().dumpDetailHashMap();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected WorkspaceTreeModel createModel(WsTreeNode nodeRoot) {
        if (!this.m_bMain) {
            this.dontListenToCopyList();
        }
        DefaultNodeFactory factory = new DefaultNodeFactory();
        factory.setCreateTypeNodes(true);
        CustomTreeModel model = new CustomTreeModel(factory);
        model.setListenForChanges(this.m_bMain);
        model.setReportUnconvertedRepositories(this.m_bMain);
        if (!this.isAddingMemberNodes()) {
            model.setNodeFilter(new NoMembersFilter());
        }
        if (this.m_vRepositories != null) {
            model.setRepositories(this.m_vRepositories);
        }
        model.setName("Custom" + ++s_nModels);
        return model;
    }

    protected WsTreeNode createRootNode() {
        return new cRootTreeNode();
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.m_actNewFolder = this.createNewFolderAction();
        this.m_actNewObject = this.createNewObjectAction();
    }

    protected WsAbstractAction createNewFolderAction() {
        return new NewFolderAction();
    }

    protected WsAbstractAction createNewObjectAction() {
        return new NewObjectAction();
    }

    protected class cWarehouseTreeModel
    extends WorkspaceTreeModel {
        public cWarehouseTreeModel(WsTreeNode nodeRoot) {
            super(nodeRoot);
        }

        protected void populateObjects(List lObjects) {
            try {
                if (!this.isObjectsPopulated(lObjects)) {
                    CMetadata oObject;
                    StringBuffer sbXML = new StringBuffer();
                    int nObjects = lObjects.size();
                    for (int iObject = 0; iObject < nObjects; ++iObject) {
                        oObject = (CMetadata)lObjects.get(iObject);
                        if (oObject == null) continue;
                        sbXML.append("<");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(" Id=\"");
                        sbXML.append(oObject.getFQID());
                        sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\"");
                        sbXML.append("><Trees/>");
                        if (oObject.getCMetadataType().equals("Tree")) {
                            sbXML.append("<ParentTree/>");
                        }
                        sbXML.append("</");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(">");
                    }
                    try {
                        oObject = (CMetadata)lObjects.get(0);
                        Workspace.getMdFactory().getOMIUtil().getMetadataObjects(oObject.getObjectStore(), sbXML.toString(), "", 256);
                    }
                    catch (MdException eMeta) {
                        eMeta.printStackTrace();
                    }
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        protected void populateUncheckedOutObjects(ArrayList alObjects) {
            try {
                if (((Root)alObjects.get(0)).getChangeState() != null && ((Root)alObjects.get(0)).getChangeState().length() > 0) {
                    StringBuffer sbXML = new StringBuffer();
                    int nObjects = alObjects.size();
                    for (int iObject = 0; iObject < nObjects; ++iObject) {
                        Root oObject = (Root)alObjects.get(iObject);
                        if (oObject == null) continue;
                        sbXML.append("<");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(" Id=\"");
                        String strChangeState = oObject.getChangeState();
                        int index = strChangeState.indexOf(58);
                        String strWarehouseID = strChangeState.substring(index += 2, strChangeState.length());
                        sbXML.append(strWarehouseID);
                        sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><Trees/>");
                        if (oObject.getCMetadataType().equals("Tree")) {
                            sbXML.append("<ParentTree/>");
                        }
                        sbXML.append("</");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(">");
                    }
                    try {
                        Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sbXML.toString(), "", 256);
                    }
                    catch (MdException eMeta) {
                        eMeta.printStackTrace();
                    }
                } else if (!this.isObjectsPopulated(alObjects)) {
                    StringBuffer sbXML = new StringBuffer();
                    int nObjects = alObjects.size();
                    for (int iObject = 0; iObject < nObjects; ++iObject) {
                        CMetadata oObject = (CMetadata)alObjects.get(iObject);
                        if (oObject == null) continue;
                        sbXML.append("<");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(" Id=\"");
                        sbXML.append(oObject.getFQID());
                        sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><Trees/>");
                        if (oObject.getCMetadataType().equals("Tree")) {
                            sbXML.append("<ParentTree/>");
                        }
                        sbXML.append("</");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(">");
                    }
                    try {
                        Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sbXML.toString(), "", 256);
                    }
                    catch (MdException eMeta) {
                        eMeta.printStackTrace();
                    }
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        protected void populateClearedObjects(ArrayList alObjects) {
            block13: {
                try {
                    if (((Root)alObjects.get(0)).getChangeState() != null && ((Root)alObjects.get(0)).getChangeState().length() > 0) {
                        StringBuffer sbXML = new StringBuffer();
                        int nObjects = alObjects.size();
                        for (int iObject = 0; iObject < nObjects; ++iObject) {
                            Root oObject = (Root)alObjects.get(iObject);
                            if (oObject.getChangeState().indexOf("New") >= 0 || oObject == null) continue;
                            sbXML.append("<");
                            sbXML.append(oObject.getCMetadataType());
                            sbXML.append(" Id=\"");
                            String strChangeState = oObject.getChangeState();
                            int index = strChangeState.indexOf(58);
                            String strWarehouseID = strChangeState.substring(index += 2, strChangeState.length());
                            sbXML.append(strWarehouseID);
                            sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><Trees/>");
                            if (oObject.getCMetadataType().equals("Tree")) {
                                sbXML.append("<ParentTree/>");
                            }
                            sbXML.append("</");
                            sbXML.append(oObject.getCMetadataType());
                            sbXML.append(">");
                        }
                        try {
                            if (sbXML.length() > 0) {
                                Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sbXML.toString(), "", 256);
                            }
                            break block13;
                        }
                        catch (MdException eMeta) {
                            eMeta.printStackTrace();
                        }
                        break block13;
                    }
                    if (this.isObjectsPopulated(alObjects)) break block13;
                    StringBuffer sbXML = new StringBuffer();
                    int nObjects = alObjects.size();
                    for (int iObject = 0; iObject < nObjects; ++iObject) {
                        CMetadata oObject = (CMetadata)alObjects.get(iObject);
                        if (((Root)oObject).getChangeState().indexOf("New") >= 0 || oObject == null) continue;
                        sbXML.append("<");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(" Id=\"");
                        sbXML.append(oObject.getFQID());
                        sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><Trees/>");
                        if (oObject.getCMetadataType().equals("Tree")) {
                            sbXML.append("<ParentTree/>");
                        }
                        sbXML.append("</");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(">");
                    }
                    try {
                        if (sbXML.length() > 0) {
                            Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sbXML.toString(), "", 256);
                        }
                    }
                    catch (MdException eMeta) {
                        eMeta.printStackTrace();
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
        }

        protected boolean isObjectsPopulated(List lObjects) {
            try {
                int nObjects = lObjects.size();
                for (int iObject = 0; iObject < nObjects; ++iObject) {
                    CMetadata oObject = (CMetadata)lObjects.get(iObject);
                    if (oObject == null) continue;
                    Map hmAssociations = oObject.getAssocs();
                    if (hmAssociations.get("Trees") == null) {
                        return false;
                    }
                    if (!oObject.getCMetadataType().equals("Tree") || hmAssociations.get("ParentTree") != null) continue;
                    return false;
                }
                return true;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }
    }

    protected class cTreeTreeNode
    extends WsDataTreeNode {
        protected CMetadata m_oParent;
        protected CMetadata m_oGroup;
        protected WsAbstractAction m_actNewSubTree;
        protected WsAbstractAction m_actNewObject;

        public cTreeTreeNode(CMetadata oMetadata) {
            super(oMetadata);
            this.m_oParent = oMetadata;
            this.createActions();
        }

        public Icon getIcon(boolean bExpanded) {
            if (this.m_icon != null) {
                return this.m_icon;
            }
            return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
        }

        public void addChildren() {
            this.addSubTrees();
            if (WAdminTree_Warehouse.this.isAddingMemberNodes()) {
                this.addMembers();
            }
        }

        public void doDefaultAction() {
        }

        public JPopupMenu getPopupMenu(WAdminResource aBundle) {
            JPopupMenu menuPopup = super.getPopupMenu(aBundle);
            if (menuPopup.getComponentCount() != 0) {
                menuPopup.add(new JSeparator());
            }
            menuPopup.add(new JMenuItem((Action)this.m_actNewSubTree));
            menuPopup.add(new JMenuItem((Action)this.m_actNewObject));
            return menuPopup;
        }

        public void onNewSubTree() {
            block7: {
                try {
                    MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                    MdObjectStore store = factory.createObjectStore();
                    Tree oDetailChild = null;
                    try {
                        if (!this.m_bHasExpanded) {
                            WAdminTree_Warehouse.this.expandPath(WAdminTree_Warehouse.this.getSelectionPath());
                        }
                        Tree oDetailParent = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oParent.getName(), this.m_oParent.getCMetadataType(), this.m_oParent.getId());
                        Group oDetailGroup = (Group)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oGroup.getName(), this.m_oGroup.getCMetadataType(), this.m_oGroup.getId());
                        String sRepository = this.m_oParent.getRepositoryID();
                        if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON) {
                            sRepository = Workspace.getWorkspace().getDefaultRepository().getFQID().substring(9, 17);
                        }
                        oDetailChild = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, bundle.getString("Common.Untitled.txt"), "Tree", sRepository);
                        oDetailChild.setParentTree(oDetailParent);
                        oDetailChild.getGroups().add((Object)oDetailGroup);
                        oDetailChild.setTreeType("Custom");
                        oDetailChild.updateMetadataAll();
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Creating");
                    }
                    String sChildFQID = oDetailChild.getFQID();
                    store.dispose();
                    if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON) break block7;
                    int nChilds = this.children.size();
                    for (int iChild = 0; iChild < nChilds; ++iChild) {
                        WsTreeNode nodeChild = (WsTreeNode)this.children.get(iChild);
                        String sFQID = nodeChild.getFQID();
                        if (sFQID == null || !sFQID.equals(sChildFQID)) continue;
                        TreePath pathChild = WAdminTree_Warehouse.this.getSelectionPath().pathByAddingChild(nodeChild);
                        WAdminTree_Warehouse.this.setSelectionPath(pathChild);
                        WAdminTree_Warehouse.this.startEditingAtPath(pathChild);
                        break;
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
        }

        public void onNewObject() {
            try {
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                MdObjectStore store = factory.createObjectStore();
                Tree oDetailParent = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oParent.getName(), this.m_oParent.getCMetadataType(), this.m_oParent.getId());
                NewObjectWizard wizard = new NewObjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("NewObjectWizard.tab1Title.txt"), oDetailParent);
                wizard.show();
                wizard.handleGlobals();
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        public boolean isDropTarget(DropTargetDragEvent e) {
            return super.isDropTarget() && e.isDataFlavorSupported(DNDObject.dndObjectDataFlavor);
        }

        public boolean isDropTarget(DropTargetDropEvent e) {
            if (!super.isDropTarget()) {
                return false;
            }
            Vector vDragObjects = this.getDragObjects(e.getTransferable());
            if (vDragObjects == null) {
                return false;
            }
            return this.validateDragObjects(vDragObjects);
        }

        protected Vector getDragObjects(Transferable t) {
            Vector vDragObjects = null;
            if (t.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                try {
                    vDragObjects = (Vector)t.getTransferData(DNDObject.dndObjectDataFlavor);
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().error((Object)"An IO exception occurred during the drop");
                }
                catch (UnsupportedFlavorException ex) {
                    Workspace.getDefaultLogger().error((Object)"An unsupported flavor exception occurred during the drop");
                }
            }
            return vDragObjects;
        }

        protected boolean validateDragObjects(Vector vObjects) {
            try {
                String sRepository = this.m_oParent.getRepositoryID();
                int nObjects = vObjects.size();
                for (int iObject = 0; iObject < nObjects; ++iObject) {
                    Object o = vObjects.get(iObject);
                    if (!(o instanceof CMetadata)) {
                        MessageUtil.displayMessage((String)bundle.getString("WarehouseTree.DropAborted.NonMetadataObjectsMessage.txt"), (String)bundle.getString("WarehouseTree.DropAborted.Title.txt"), (int)0);
                        return false;
                    }
                    CMetadata oData = (CMetadata)o;
                    if (!oData.getRepositoryID().equals(sRepository)) {
                        MessageUtil.displayMessage((String)bundle.getString("WarehouseTree.DropAborted.CrossRepositoryMessage.txt"), (String)bundle.getString("WarehouseTree.DropAborted.Title.txt"), (int)0);
                        return false;
                    }
                    if (oData.getFQID().equals(this.m_oParent.getFQID())) {
                        MessageUtil.displayMessage((String)bundle.getString("WarehouseTree.DropAborted.DropOnSelf.txt"), (String)bundle.getString("WarehouseTree.DropAborted.Title.txt"), (int)0);
                        return false;
                    }
                    if (oData.getCMetadataType().equals("Tree") && !this.m_actNewSubTree.isEnabled()) {
                        MessageUtil.displayMessage((String)bundle.getString("WarehouseTree.DropAborted.NoSubTrees.txt"), (String)bundle.getString("WarehouseTree.DropAborted.Title.txt"), (int)0);
                        return false;
                    }
                    if (!oData.getCMetadataType().equals("Tree")) continue;
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                    Tree oParent = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oParent.getName(), this.m_oParent.getCMetadataType(), this.m_oParent.getId());
                    ArrayList arParents = WAdminTree_Warehouse.this.getAncestorTrees(oParent);
                    for (int iParent = 0; iParent < arParents.size(); ++iParent) {
                        Tree oTree = (Tree)arParents.get(iParent);
                        if (!oTree.getFQID().equals(oData.getFQID())) continue;
                        MessageUtil.displayMessage((String)bundle.getString("WarehouseTree.DropAborted.DropIntoChild.txt"), (String)bundle.getString("WarehouseTree.DropAborted.Title.txt"), (int)0);
                        store.dispose();
                        return false;
                    }
                    store.dispose();
                }
                return true;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent e) {
            Vector vDragObjects = this.getDragObjects(e.getTransferable());
            int nDragObjects = vDragObjects.size();
            if (nDragObjects >= 0) {
                try {
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                    Tree oTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, this.m_oParent.getName(), this.m_oParent.getCMetadataType(), this.m_oParent.getId());
                    for (int iDragObject = 0; iDragObject < nDragObjects; ++iDragObject) {
                        CMetadata indragObject = (CMetadata)vDragObjects.get(iDragObject);
                        Root oObject = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, null, indragObject.getName(), indragObject.getCMetadataType(), indragObject.getId());
                        if (oObject.getCMetadataType().equals("Tree")) {
                            ((Tree)oObject).setParentTree(oTree);
                            continue;
                        }
                        Tree oOldWATree = WAdminTree_ChangeManagement.getWarehouseTree(oObject);
                        if (oOldWATree != null) {
                            oObject.getTrees().remove((Object)oOldWATree);
                        }
                        oObject.getTrees().add((Object)oTree);
                    }
                    store.updatedMetadataAll();
                    store.dispose();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                finally {
                    Workspace.getWorkspace().setCursor(null);
                }
            }
            e.dropComplete(false);
        }

        protected void addSubTrees() {
            try {
                Document doc;
                String sType = this.m_oParent.getCMetadataType();
                String sFQID = this.m_oParent.getFQID();
                String sInXML = "<" + sType + " ID=\"" + sFQID + "\"><SUBTREES/></" + sType + ">";
                try {
                    doc = Workspace.getMdFactory().getOMIUtil().getMetadata(sInXML, 264);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    return;
                }
                NodeList lSubTrees = doc.getFirstChild().getFirstChild().getChildNodes();
                int nSubTrees = lSubTrees.getLength();
                for (int iSubTree = 0; iSubTree < nSubTrees; ++iSubTree) {
                    Node domSubTree = lSubTrees.item(iSubTree);
                    String sSubTreeType = domSubTree.getNodeName();
                    NamedNodeMap mapSubTree = domSubTree.getAttributes();
                    String sSubTreeFQID = mapSubTree.getNamedItem("Id").getNodeValue();
                    String sSubTreeName = mapSubTree.getNamedItem("Name").getNodeValue();
                    String sSubTreeTreeType = mapSubTree.getNamedItem("TreeType").getNodeValue();
                    CMetadata oSubTree = Workspace.getMdFactory().createSimpleMetadataObject(sSubTreeName, sSubTreeType, sSubTreeFQID);
                    oSubTree.setClientSideOnlyObject((Object)sSubTreeTreeType);
                    try {
                        Workspace.getMdFactory().getOMIUtil().doSimple(oSubTree, mapSubTree);
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                        return;
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    WsTreeNode nodeSubTree = this.createTreeNode(oSubTree);
                    if (nodeSubTree == null) continue;
                    this.addChild(nodeSubTree);
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        protected void addMembers() {
            try {
                Document doc;
                String sType = this.m_oParent.getCMetadataType();
                String sFQID = this.m_oParent.getFQID();
                String sInXML = "<" + sType + " ID=\"" + sFQID + "\"><MEMBERS/></" + sType + ">";
                try {
                    doc = Workspace.getMdFactory().getOMIUtil().getMetadata(sInXML, 264);
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                    return;
                }
                NodeList lMembers = doc.getFirstChild().getFirstChild().getChildNodes();
                int nMembers = lMembers.getLength();
                for (int iMember = 0; iMember < nMembers; ++iMember) {
                    Node domMember = lMembers.item(iMember);
                    String sMemberType = domMember.getNodeName();
                    NamedNodeMap mapMember = domMember.getAttributes();
                    String sMemberFQID = mapMember.getNamedItem("Id").getNodeValue();
                    String sMemberName = mapMember.getNamedItem("Name").getNodeValue();
                    String sCheckedOut = mapMember.getNamedItem("ChangeState").getNodeValue();
                    String sLockedBy = mapMember.getNamedItem("LockedBy").getNodeValue();
                    CMetadata oMember = Workspace.getMdFactory().createSimpleMetadataObject(sMemberName, sMemberType, sMemberFQID);
                    ((Root)oMember).setChangeState(sCheckedOut);
                    ((Root)oMember).setLockedBy(sLockedBy);
                    WsTreeNode nodeMember = this.createDataNode(oMember);
                    this.addChild(nodeMember);
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        protected WsTreeNode createTreeNode(CMetadata oSubTree) {
            cTreeTreeNode node = new cTreeTreeNode(oSubTree);
            node.setDropTarget(true);
            node.setGroup(this.m_oGroup);
            return node;
        }

        protected WsTreeNode createDataNode(CMetadata oData) {
            WsDataTreeNode node = WorkspaceTree.createDataTreeNode((CMetadata)oData, (String)"com.sas.wadmin.visuals.", (String)"TreeNode");
            node.setAllowsChildren(false);
            return node;
        }

        public WsTreeNode createChild(CMetadata oMetadata) {
            try {
                if (oMetadata.getCMetadataType().equals("Tree")) {
                    return this.createTreeNode(oMetadata);
                }
                return this.createDataNode(oMetadata);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return null;
            }
        }

        public boolean isValidAncestorFor(CMetadata oMetadata) {
            return true;
        }

        public boolean isValidParentFor(CMetadata oMetadata) {
            block13: {
                try {
                    if (this.m_oParent == null) {
                        return false;
                    }
                    String sFQID = this.m_oParent.getFQID();
                    String sDataFQID = oMetadata.getFQID();
                    if (!sFQID.substring(0, 8).equals(sDataFQID.substring(0, 8))) {
                        return false;
                    }
                    AssociationList alTrees = null;
                    AssociationList alParents = null;
                    try {
                        if (WAdminTree_Warehouse.this.isAddingMemberNodes()) {
                            alTrees = ((Root)oMetadata).getTrees();
                        }
                        if (oMetadata instanceof Tree) {
                            alParents = ((Tree)oMetadata).getParentTrees();
                        }
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                        return false;
                    }
                    if (alTrees != null) {
                        int nTrees = alTrees.size();
                        for (int iTree = 0; iTree < nTrees; ++iTree) {
                            if (!((CMetadata)alTrees.get(iTree)).getFQID().equals(sFQID)) continue;
                            return true;
                        }
                    }
                    if (alParents == null) break block13;
                    int nParents = alParents.size();
                    for (int iParent = 0; iParent < nParents; ++iParent) {
                        try {
                            if (!((CMetadata)alParents.get(iParent)).getFQID().equals(sFQID)) continue;
                            return true;
                        }
                        catch (Exception e) {
                            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                            return false;
                        }
                    }
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
            return false;
        }

        public boolean isReallyDeleteable() {
            this.expand();
            if (this.getChildCount() != 0) {
                String sMessage = bundle.formatString("WAdminTree_Warehouse.GroupMustBeEmptyToDeleteError.fmt", (Object)this.m_sName);
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }

        public void setGroup(CMetadata oGroup) {
            this.m_oGroup = oGroup;
        }

        public CMetadata getTreeObject() {
            return this.m_oParent;
        }

        protected void createActions() {
            this.m_actNewSubTree = this.createNewSubTreeAction();
            this.m_actNewObject = this.createNewObjectAction();
        }

        protected WsAbstractAction createNewSubTreeAction() {
            return new cNewSubTreeAction();
        }

        protected WsAbstractAction createNewObjectAction() {
            return new cNewObjectAction();
        }

        protected class cNewObjectAction
        extends WsAbstractAction {
            public cNewObjectAction() {
                super(bundle, "Tree.PopupMenu.NewObject");
            }

            public void actionPerformed(ActionEvent e) {
                cTreeTreeNode.this.onNewObject();
            }
        }

        protected class cNewSubTreeAction
        extends WsAbstractAction {
            public cNewSubTreeAction() {
                super(bundle, "Tree.PopupMenu.NewSubTree");
            }

            public void actionPerformed(ActionEvent e) {
                cTreeTreeNode.this.onNewSubTree();
            }
        }
    }

    protected class cRepositoryTreeNode
    extends cTreeTreeNode {
        public cRepositoryTreeNode(CMetadata oRepository) {
            super(oRepository);
            this.setRenameable(false);
            this.setDeleteable(false);
            this.setDragSource(false);
        }

        @Override
        public void addChildren() {
            this.m_oParent = this.getWarehouseTree();
            if (this.m_oParent == null) {
                this.m_actNewObject.setEnabled(false);
                this.m_actNewSubTree.setEnabled(false);
                return;
            }
            super.addChildren();
            this.addUngroupedNode();
        }

        protected CMetadata getWarehouseTree() {
            try {
                MdObjectStore store = Workspace.getWorkspace().getMdObjectFactory().createObjectStore();
                CMetadata oTree = null;
                try {
                    oTree = this.findWarehouseTree(store);
                    if (oTree == null) {
                        MessageUtil.displayMessage((String)bundle.getString("WAdminTree_Warehouse.MissingComponentsWarning.txt"), (int)2);
                    }
                }
                finally {
                    store.dispose();
                }
                return oTree;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return null;
            }
        }

        protected CMetadata findWarehouseTree(MdObjectStore store) {
            try {
                String sXMLSelect;
                int fOptions = 392;
                String sOptions = sXMLSelect = "<XMLSELECT Search=\"@CLASSIDENTIFIER='" + WAdminTree_Warehouse.this.m_sSoftClass + "'\"/>";
                List vSoftComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, this.m_oMetadata.getFQID(), "SoftwareComponent", fOptions, sOptions);
                if (vSoftComponents.size() == 0) {
                    return null;
                }
                if (vSoftComponents.size() > 1) {
                    Workspace.getDefaultLogger().error((Object)("Incorrect number of software components with a class idenitifier of \"" + WAdminTree_Warehouse.this.m_sSoftClass + "\" in the repository"));
                }
                SoftwareComponent oSoft = (SoftwareComponent)vSoftComponents.get(0);
                Tree oTree = (Tree)oSoft.getSoftwareTrees().get(0);
                Group oGroup = (Group)oSoft.getSoftwareGroups().get(0);
                this.m_oGroup = Workspace.getMdFactory().createSimpleMetadataObject((CMetadata)oGroup);
                return Workspace.getMdFactory().createSimpleMetadataObject((CMetadata)oTree);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                return null;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                return null;
            }
        }

        protected void constructWarehouseTree() {
        }

        protected void addUngroupedNode() {
            if (!WAdminTree_Warehouse.this.isAddingMemberNodes()) {
                return;
            }
            this.addChild(this.createUngroupedNode());
        }

        protected WsTreeNode createUngroupedNode() {
            try {
                String sGroupedXML = "*[Trees/*[Groups/*[@Id='" + this.m_oGroup.getFQID() + "']]]";
                String sNoteXML = "*[@TextRole='Note']";
                String sNoteGroupedXML = "*[@TextRole='Note'][Trees/*[Groups/*[@Id='" + this.m_oGroup.getFQID() + "']]]";
                MultiInventoryTreeNode nodeUngrouped = new MultiInventoryTreeNode(UNGROUPED, "A0000001." + this.m_oParent.getRepositoryID());
                nodeUngrouped.addType("Cube", null, sGroupedXML);
                nodeUngrouped.addType("PhysicalTable", null, sGroupedXML);
                nodeUngrouped.addType("Job", null, sGroupedXML);
                nodeUngrouped.addType("Document", null, sGroupedXML);
                nodeUngrouped.addType("TextStore", sNoteXML, sNoteGroupedXML);
                nodeUngrouped.addType("ExternalTable", null, sGroupedXML);
                nodeUngrouped.addType("SASLibrary", null, sGroupedXML);
                return nodeUngrouped;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return null;
            }
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
        }

        @Override
        public JPopupMenu getPopupMenu(WAdminResource aBundle) {
            JPopupMenu menuPopup = super.getPopupMenu(aBundle);
            menuPopup.remove(0);
            menuPopup.remove(0);
            return menuPopup;
        }

        @Override
        public boolean isValidAncestorFor(CMetadata oMetadata) {
            try {
                String sDataFQID = oMetadata.getFQID();
                String sFQID = this.getFQID();
                return sFQID.substring(9).equals(sDataFQID.substring(0, 8));
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }
    }

    protected class cRootTreeNode
    extends WorkspaceTree.cRootNode {
        protected cRootTreeNode() {
            super((WorkspaceTree)WAdminTree_Warehouse.this);
        }

        public WsTreeNode createChild(CMetadata oMetadata) {
            return new cRepositoryTreeNode(oMetadata);
        }

        protected boolean isRepositoryIncluded(CMetadata oMetadata) {
            try {
                CMetadata oProject = Workspace.getWorkspace().getProjectRepository();
                return oProject == null || !oProject.getFQID().equals(oMetadata.getFQID());
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }
    }

    protected class NewObjectAction
    extends WsAbstractAction {
        public NewObjectAction() {
            super(bundle, "Tree.PopupMenu.NewObject");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_Warehouse.this.onNewObject();
        }
    }

    protected class NewFolderAction
    extends WsAbstractAction {
        public NewFolderAction() {
            super(bundle, "Tree.PopupMenu.NewSubTree");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_Warehouse.this.onNewFolder();
        }
    }
}

