/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.IndexCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.KeyAssociation;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.UniqueKey;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.awt.AWTEvent;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WAdminTree_TableKeys
extends WorkspaceTree {
    private static WAdminResource bundle = WAdminResource.getBundle(WAdminTree_TableKeys.class);
    protected WsDataTreeNode primaryKeyNode;
    protected WsTreeNode uniqueKeyFolderNode;
    protected WsTreeNode foreignKeyFolderNode;
    protected WorkspaceTreeModel model;
    protected DataTable keyTable;
    protected MdObjectStore store;
    protected List tableForeignKeys;
    protected WsTreeNode nodeRoot;
    protected boolean isEditable = true;
    protected boolean isTableForeignKey;
    protected UniqueKey primaryKey = null;
    protected Index primaryKeyIndex = null;
    protected List uniqueKeys;
    protected boolean hasUniqueKeys = false;
    protected WAPanel treePanel;
    protected static final int PRIMARY_KEY_FOLDER = 0;
    protected static final int COLUMN_FOLDER = 1;
    protected static final int ASSOCIATED_TABLES_FOLDER = 2;
    protected static final int FOREIGN_KEYS_FOLDER = 3;
    protected static final int UK_COLUMN = 4;
    protected static final int FK_COLUMN = 5;
    protected static final int FK_TABLE = 6;
    protected static final int PRIMARY_KEY = 7;
    protected static final int FOREIGN_KEY = 8;
    protected static final int UNIQUE_KEYS_FOLDER = 9;
    protected static final int UNIQUE_KEY = 10;

    public WAdminTree_TableKeys(CMetadata dataTable) {
        try {
            this.keyTable = (DataTable)dataTable;
            this.store = (MdObjectStore)this.keyTable.getObjectStore();
            this.nodeRoot = this.createRootNode();
            this.model = this.createModel(this.nodeRoot);
            this.setModel((TreeModel)this.model);
            this.setListenForChanges(false);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void initialize() {
        this.populateStore();
        if (this.nodeRoot.getChildCount() == 0) {
            this.nodeRoot.addChildren();
            this.nodeRoot.setHasExpanded(true);
        }
        this.setRootSelectionandExpandNodes();
    }

    public void setEditable(boolean bEditable) {
        this.isEditable = bEditable;
        this.setDroppingEnabled(bEditable);
        this.setDraggingEnabled(bEditable);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setRootSelectionandExpandNodes() {
        this.setSelectionPath(new TreePath(this.nodeRoot));
        if (this.primaryKey != null) {
            WsTreeNode child = (WsTreeNode)this.nodeRoot.getFirstChild();
            this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)child)));
            this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)this.primaryKeyNode)));
            this.expandPath(new TreePath(this.model.getPathToRoot(this.primaryKeyNode.getFirstChild())));
            if (this.primaryKeyNode.getChildCount() > 1) {
                WsTreeNode assocTabNode = (WsTreeNode)this.primaryKeyNode.getChildAfter(this.primaryKeyNode.getFirstChild());
                this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)assocTabNode)));
            }
        }
        if (this.hasUniqueKeys) {
            this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)this.uniqueKeyFolderNode)));
            Enumeration ukNodes = this.uniqueKeyFolderNode.children();
            while (ukNodes.hasMoreElements()) {
                cKeyNode ukNode = (cKeyNode)((Object)ukNodes.nextElement());
                TreePath path = new TreePath(this.model.getPathToRoot((TreeNode)((Object)ukNode)));
                this.expandPath(path);
                cKeyFolderNode ukColFolder = (cKeyFolderNode)((Object)ukNode.getFirstChild());
                this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)((Object)ukColFolder))));
                if (ukNode.getChildCount() <= 1) continue;
                WsTreeNode assocTabNode = (WsTreeNode)ukNode.getChildAfter((TreeNode)((Object)ukColFolder));
                this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)assocTabNode)));
            }
        }
        if (this.foreignKeyFolderNode != null) {
            this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)this.foreignKeyFolderNode)));
            Enumeration fkNodes = this.foreignKeyFolderNode.children();
            while (fkNodes.hasMoreElements()) {
                cKeyNode fkNode = (cKeyNode)((Object)fkNodes.nextElement());
                this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)((Object)fkNode))));
            }
        }
    }

    public void setSelectionMetadataObject(CMetadata object) {
        try {
            String id = object.getFQID();
            Enumeration allnodes = this.nodeRoot.preorderEnumeration();
            while (allnodes.hasMoreElements()) {
                CMetadata metaObject;
                WsTreeNode node = (WsTreeNode)allnodes.nextElement();
                if (node instanceof cKeyFolderNode || node instanceof cRootNode || !(metaObject = ((WsDataTreeNode)node).getMetadata()).getFQID().equals(id)) continue;
                this.setSelectionPath(new TreePath(this.model.getPathToRoot((TreeNode)node)));
                return;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public ForeignKey getForeignKey() {
        if (!this.isSelectedNodeForeignKey()) {
            return null;
        }
        WsTreeNode node = this.getSelectedNode();
        this.isTableForeignKey = true;
        try {
            if (node instanceof cKeyFolderNode) {
                int type = ((cKeyFolderNode)node).getNodeType();
                if (type == 2) {
                    this.isTableForeignKey = false;
                    cKeyNode ukNode = (cKeyNode)((Object)node.getParent());
                    UniqueKey uk = (UniqueKey)ukNode.getMetadata();
                    AssociationList al = uk.getForeignKeys();
                    if (al != null) {
                        return (ForeignKey)al.get(0);
                    }
                    return null;
                }
                return (ForeignKey)this.tableForeignKeys.get(0);
            }
            cKeyNode mNode = (cKeyNode)node;
            CMetadata metaObject = mNode.getMetadata();
            String metaType = metaObject.getCMetadataType();
            WsTreeNode parent = (WsTreeNode)mNode.getParent();
            if (metaType.equalsIgnoreCase("ForeignKey")) {
                return (ForeignKey)metaObject;
            }
            if (metaType.equalsIgnoreCase("Column")) {
                WsDataTreeNode dataNode = (WsDataTreeNode)parent;
                return (ForeignKey)dataNode.getMetadata();
            }
            if (parent instanceof cKeyFolderNode) {
                this.isTableForeignKey = false;
                int index = this.model.getIndexOfChild((Object)parent, (Object)mNode);
                WsDataTreeNode ukParent = (WsDataTreeNode)parent.getParent();
                UniqueKey uKey = (UniqueKey)ukParent.getMetadata();
                AssociationList fkeys = uKey.getForeignKeys();
                return (ForeignKey)fkeys.get(index);
            }
            WsDataTreeNode dataNode = (WsDataTreeNode)parent;
            return (ForeignKey)dataNode.getMetadata();
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            return null;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public boolean isSelectedNodeUniqueKeyColumn() {
        WsTreeNode node = this.getSelectedNode();
        if (node == null) {
            return false;
        }
        if (node.isRoot()) {
            return false;
        }
        int type = node instanceof cKeyNode ? ((cKeyNode)node).getNodeType() : ((cKeyFolderNode)node).getNodeType();
        return type == 4;
    }

    public boolean isSelectedNodeForeignKey() {
        WsTreeNode node = this.getSelectedNode();
        if (node == null) {
            return false;
        }
        if (node.isRoot()) {
            return false;
        }
        int type = node instanceof cKeyFolderNode ? ((cKeyFolderNode)node).getNodeType() : ((cKeyNode)node).getNodeType();
        return type == 8 || type == 3 || type == 2 || type == 5 || type == 6;
    }

    public void populateStore() {
        block11: {
            try {
                if (this.keyTable == null) {
                    return;
                }
                this.hasUniqueKeys = false;
                try {
                    this.uniqueKeys = this.keyTable.getUniqueKeys();
                    this.tableForeignKeys = this.keyTable.getForeignKeys();
                    this.tableForeignKeys = Workspace.removeCheckouts((List)this.tableForeignKeys);
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                }
                if (this.uniqueKeys.size() == 1) {
                    UniqueKey tableKey = (UniqueKey)this.uniqueKeys.get(0);
                    if (tableKey.getIsPrimary() == 1) {
                        this.primaryKey = tableKey;
                        try {
                            AssociationList indexList = ((PhysicalTable)this.keyTable).getIndexes();
                            for (int i = 0; i < indexList.size(); ++i) {
                                IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)((Index)indexList.get(i)));
                                if (indexCG.getPrimaryKeyUsingIndex() == null) continue;
                                this.primaryKeyIndex = (Index)indexList.get(i);
                            }
                            break block11;
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                            break block11;
                        }
                    }
                    this.hasUniqueKeys = true;
                    break block11;
                }
                if (this.uniqueKeys.size() <= 0) break block11;
                this.hasUniqueKeys = true;
                for (int i = 0; i < this.uniqueKeys.size(); ++i) {
                    UniqueKey tableKey = (UniqueKey)this.uniqueKeys.get(i);
                    if (tableKey.getIsPrimary() != 1) continue;
                    this.primaryKey = tableKey;
                    break;
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
    }

    public void saveSettingsAndCleanUp() {
        Enumeration treeNodes = this.nodeRoot.preorderEnumeration();
        WsTreeNode currNode = null;
        while (treeNodes.hasMoreElements()) {
            currNode = (WsTreeNode)treeNodes.nextElement();
            if (!(currNode instanceof cKeyNode)) continue;
            ((cKeyNode)currNode).saveSettingsAndCleanUp();
        }
        this.nodeRoot.removeAllChildren();
        this.tableForeignKeys = null;
        this.uniqueKeys = null;
        this.primaryKey = null;
        this.keyTable = null;
        this.primaryKeyIndex = null;
    }

    protected void addPopupMenuItems(JPopupMenu menuPopup, WsTreeNode node) {
        if (menuPopup.getComponentCount() != 0) {
            menuPopup.add(new JSeparator());
        }
        menuPopup.add(new JMenuItem((Action)this.m_actRefresh));
    }

    public void addForeignKeyEventListener(ForeignKeyEventListener l) {
        this.listenerList.add(ForeignKeyEventListener.class, l);
    }

    public void showPopupMenu(MouseEvent e) {
        cKeyNode node;
        WsTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof cKeyNode && (node = (cKeyNode)selectedNode).getNodeType() == 4) {
            if (this.isFirstChild((WsTreeNode)node)) {
                node.setAllowsMoveColumnUp(false);
            }
            if (this.isLastChild((WsTreeNode)node)) {
                node.setAllowsMoveColumnDown(false);
            }
        }
        JPopupMenu menuPopup = selectedNode.getPopupMenu(bundle);
        this.addPopupMenuItems(menuPopup, selectedNode);
        if (menuPopup.getComponentCount() != 0) {
            menuPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public boolean isOnlyChild(WsTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.isRoot()) {
            return false;
        }
        WsTreeNode parent = (WsTreeNode)node.getParent();
        int totChildren = parent.getChildCount();
        return totChildren == 1;
    }

    public boolean isFirstChild(WsTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.isRoot()) {
            return false;
        }
        WsTreeNode parent = (WsTreeNode)node.getParent();
        int index = this.model.getIndexOfChild((Object)parent, (Object)node);
        return index == 0;
    }

    public boolean isLastChild(WsTreeNode node) {
        if (node == null) {
            return false;
        }
        if (node.isRoot()) {
            return false;
        }
        WsTreeNode parent = (WsTreeNode)node.getParent();
        int totChildren = parent.getChildCount() - 1;
        int index = this.model.getIndexOfChild((Object)parent, (Object)node);
        return index == totChildren;
    }

    public WsTreeNode createRootNode() {
        return new cRootNode();
    }

    public void onRefresh() {
        this.refresh();
    }

    public void refresh() {
        this.populateStore();
        super.refresh();
        this.setRootSelectionandExpandNodes();
    }

    public void onMoveUp() {
        try {
            WsDataTreeNode node = (WsDataTreeNode)this.getSelectedNode();
            cKeyFolderNode parent = (cKeyFolderNode)((Object)node.getParent());
            cKeyNode ukNode = (cKeyNode)((Object)parent.getParent());
            UniqueKey uk = (UniqueKey)ukNode.getMetadata();
            AssociationList ukCols = uk.getKeyedColumns();
            int index = this.model.getIndexOfChild((Object)parent, (Object)node);
            int newIndex = index - 1;
            WsTreeNode newNode = parent.createKeyNode(node.getMetadata(), 4);
            this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)parent), newIndex);
            TreePath path = new TreePath(this.model.getPathToRoot((TreeNode)newNode));
            this.setSelectionPath(path);
            this.model.removeChild((WsTreeNode)node);
            Object colObject = ukCols.get(index);
            ukCols.removeElement(colObject);
            ukCols.insertElementAt(colObject, newIndex);
            this.setPanelDataChanged(true);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void onMoveDown() {
        try {
            WsDataTreeNode node = (WsDataTreeNode)this.getSelectedNode();
            cKeyFolderNode parent = (cKeyFolderNode)((Object)node.getParent());
            cKeyNode ukNode = (cKeyNode)((Object)parent.getParent());
            UniqueKey uk = (UniqueKey)ukNode.getMetadata();
            AssociationList ukCols = uk.getKeyedColumns();
            int index = this.model.getIndexOfChild((Object)parent, (Object)node);
            int newIndex = index + 2;
            WsTreeNode newNode = parent.createKeyNode(node.getMetadata(), 4);
            this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)parent), newIndex);
            this.model.removeChild((WsTreeNode)node);
            TreePath path = new TreePath(this.model.getPathToRoot((TreeNode)newNode));
            this.setSelectionPath(path);
            Object colObject = ukCols.get(index);
            ukCols.insertElementAt(colObject, newIndex);
            ukCols.remove(index);
            this.setPanelDataChanged(true);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public boolean isValidNodeForAUniqueKeyColumnInsert() {
        WsTreeNode node = this.getSelectedNode();
        if (node == null) {
            return false;
        }
        if (node.isRoot()) {
            return false;
        }
        int type = -1;
        type = node instanceof cKeyFolderNode ? ((cKeyFolderNode)node).nodeType : ((cKeyNode)node).nodeType;
        switch (type) {
            case 1: {
                return true;
            }
            case 4: {
                return true;
            }
            case 7: {
                return true;
            }
            case 10: {
                return true;
            }
        }
        return false;
    }

    public void insertUKColumns(List colList) {
        try {
            WsTreeNode node = this.getSelectedNode();
            if (!this.isValidNodeForAUniqueKeyColumnInsert()) {
                return;
            }
            cKeyFolderNode columnGroup = null;
            int type = -1;
            int loc = 0;
            type = node instanceof cKeyFolderNode ? ((cKeyFolderNode)node).nodeType : ((cKeyNode)node).nodeType;
            switch (type) {
                case 1: {
                    columnGroup = (cKeyFolderNode)node;
                    break;
                }
                case 4: {
                    columnGroup = (cKeyFolderNode)((Object)node.getParent());
                    loc = this.model.getIndexOfChild((Object)columnGroup, (Object)node) + 1;
                    break;
                }
                case 7: {
                    columnGroup = (cKeyFolderNode)((Object)node.getFirstChild());
                    break;
                }
                case 10: {
                    columnGroup = (cKeyFolderNode)((Object)node.getFirstChild());
                }
            }
            if (columnGroup == null) {
                return;
            }
            boolean addChild = true;
            cKeyNode parent = (cKeyNode)((Object)columnGroup.getParent());
            UniqueKey uk = (UniqueKey)parent.getMetadata();
            AssociationList ukColumns = null;
            try {
                ukColumns = uk.getKeyedColumns();
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            int childCount = columnGroup.getChildCount();
            for (int i = 0; i < colList.size(); ++i) {
                Column column = (Column)colList.get(i);
                addChild = true;
                for (int j = 0; j < childCount; ++j) {
                    WsDataTreeNode child = (WsDataTreeNode)columnGroup.getChildAt(j);
                    if (child.getMetadata().getFQID() != column.getFQID()) continue;
                    addChild = false;
                    break;
                }
                if (!addChild) continue;
                WsTreeNode newNode = columnGroup.createKeyNode((CMetadata)column, 4);
                this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)columnGroup), loc);
                ukColumns.insertElementAt((Object)column, loc);
                ++loc;
                TreePath path = new TreePath(this.model.getPathToRoot((TreeNode)newNode));
                this.setSelectionPath(path);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void removeUKColumns() {
        WsTreeNode node = this.getSelectedNode();
        int[] nRows = this.getSelectionRows();
        int loc = nRows[0] - 1;
        if (node instanceof cKeyFolderNode || node.isRoot()) {
            return;
        }
        cKeyNode ukColumnNode = (cKeyNode)node;
        if (ukColumnNode.nodeType != 4) {
            return;
        }
        Column metaObject = (Column)ukColumnNode.getMetadata();
        try {
            AssociationList al = metaObject.getUniqueKeyAssociations();
            if (al.size() > 0) {
                int eAnswer = MessageUtil.displayMessage((String)bundle.getString("WAdminTree_TableKeys.UKColumnWithFKRemove"), (String)bundle.getString("Common.ConfirmDelete.Title.txt"), (int)1, (int)0);
                if (eAnswer == 1) {
                    return;
                }
                for (int j = 0; j < al.size(); ++j) {
                    KeyAssociation ka = (KeyAssociation)al.get(j);
                    ForeignKey fk = ka.getOwningForeignKey();
                    int size = fk.getKeyedColumns().size();
                    Column fkC = ka.getForeignKeyColumn();
                    this.store.removeObjectFromStore((CMetadata)ka, null);
                    fk.getKeyedColumns().removeElement((Object)fkC);
                    if (size != 1) continue;
                    this.store.removeObjectFromStore((CMetadata)fk, null);
                }
            }
            cKeyNode keyNode = (cKeyNode)((Object)((cKeyFolderNode)((Object)node.getParent())).getParent());
            UniqueKey uKey = (UniqueKey)keyNode.getMetadata();
            uKey.getKeyedColumns().removeElement((Object)metaObject);
            this.onRefresh();
            if (uKey.getKeyedColumns().size() > 0) {
                ++loc;
            }
            this.setSelectionRow(loc);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Deleting");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public WsTreeNode getPrimaryKeyNode() {
        return this.primaryKeyNode;
    }

    public Index getIndexUsedInPrimaryKey() {
        return this.primaryKeyIndex;
    }

    public void setIndexUsedInPrimaryKey(Index index) {
        this.primaryKeyIndex = index;
    }

    public int getNodeType() {
        int type = -1;
        WsTreeNode node = this.getSelectedNode();
        if (node == null) {
            return type;
        }
        if (node == this.nodeRoot) {
            return type;
        }
        type = node instanceof cKeyFolderNode ? ((cKeyFolderNode)node).getNodeType() : ((cKeyNode)node).getNodeType();
        return type;
    }

    public WsTreeNode getUniqueKeyFolderNode() {
        return this.uniqueKeyFolderNode;
    }

    protected DragGestureListener createDragGestureListener() {
        return new cDragGestureListener();
    }

    protected void setPanelDataChanged(boolean dataChanged) {
        if (this.treePanel != null) {
            this.treePanel.setDataChanged(dataChanged);
        }
    }

    public void setPanel(WAPanel panel) {
        this.treePanel = panel;
    }

    public void onDelete() {
        String message;
        int eAnswer;
        int type = this.getNodeType();
        if (type == -1) {
            return;
        }
        WsTreeNode node = this.getSelectedNode();
        CMetadata metaObject = null;
        if (node instanceof cKeyNode) {
            metaObject = ((WsDataTreeNode)node).getMetadata();
        }
        if (!node.hasExpanded()) {
            this.expandPath(new TreePath(this.model.getPathToRoot((TreeNode)node)));
        }
        if ((eAnswer = MessageUtil.displayMessage((String)(message = this.getDeleteMessage(node)), (String)bundle.getString("Common.ConfirmDelete.Title.txt"), (int)1, (int)0)) == 0) {
            try {
                switch (type) {
                    case 0: {
                        WsDataTreeNode pkNode = (WsDataTreeNode)node.getFirstChild();
                        UniqueKey pKey = (UniqueKey)pkNode.getMetadata();
                        AssociationList fKeyList = null;
                        try {
                            fKeyList = pKey.getForeignKeys();
                        }
                        catch (NullPointerException ne) {
                            this.store.removeObjectFromStore((CMetadata)this.primaryKey, null);
                            this.primaryKey = null;
                            this.primaryKeyNode = null;
                            this.primaryKeyIndex = null;
                            break;
                        }
                        if (fKeyList != null && fKeyList.size() > 0) {
                            this.removeAllKeyForeignKeys(this.primaryKey);
                        }
                        this.store.removeObjectFromStore((CMetadata)this.primaryKey, null);
                        this.primaryKey = null;
                        this.primaryKeyNode = null;
                        this.primaryKeyIndex = null;
                        break;
                    }
                    case 7: {
                        AssociationList fKeyList = null;
                        try {
                            fKeyList = ((UniqueKey)metaObject).getForeignKeys();
                        }
                        catch (NullPointerException ne) {
                            this.store.removeObjectFromStore((CMetadata)this.primaryKey, null);
                            this.primaryKey = null;
                            this.primaryKeyNode = null;
                            this.primaryKeyIndex = null;
                            break;
                        }
                        if (fKeyList != null && fKeyList.size() > 0) {
                            this.removeAllKeyForeignKeys(this.primaryKey);
                        }
                        this.store.removeObjectFromStore((CMetadata)this.primaryKey, null);
                        this.primaryKey = null;
                        this.primaryKeyNode = null;
                        this.primaryKeyIndex = null;
                        break;
                    }
                    case 2: {
                        cKeyNode ukNode = (cKeyNode)((Object)node.getParent());
                        UniqueKey uk = (UniqueKey)ukNode.getMetadata();
                        this.removeAllKeyForeignKeys(uk);
                        this.fireForeignKeyRemovedEvent();
                        break;
                    }
                    case 10: {
                        UniqueKey uk = (UniqueKey)metaObject;
                        AssociationList al = null;
                        try {
                            al = uk.getForeignKeys();
                        }
                        catch (NullPointerException e) {
                            this.store.removeObjectFromStore((CMetadata)uk, null);
                            break;
                        }
                        if (al != null && al.size() > 0) {
                            this.removeAllKeyForeignKeys(uk);
                        }
                        this.store.removeObjectFromStore((CMetadata)uk, null);
                        break;
                    }
                    case 9: {
                        Enumeration ukNodes = node.children();
                        while (ukNodes.hasMoreElements()) {
                            WsDataTreeNode ukNode = (WsDataTreeNode)ukNodes.nextElement();
                            UniqueKey uk = (UniqueKey)ukNode.getMetadata();
                            AssociationList al = null;
                            try {
                                al = uk.getForeignKeys();
                            }
                            catch (NullPointerException e) {
                                this.store.removeObjectFromStore((CMetadata)uk, null);
                                continue;
                            }
                            if (al != null && al.size() > 0) {
                                this.removeAllKeyForeignKeys(uk);
                            }
                            this.store.removeObjectFromStore((CMetadata)uk, null);
                        }
                        break;
                    }
                    case 3: {
                        this.removeAllTableForeignKeys();
                        this.fireForeignKeyRemovedEvent();
                        break;
                    }
                    case 1: {
                        cKeyNode ukNode = (cKeyNode)((Object)node.getParent());
                        UniqueKey uk = (UniqueKey)ukNode.getMetadata();
                        uk.getKeyedColumns().removeAllElements();
                        this.removeAllKeyForeignKeys(uk);
                        break;
                    }
                    case 4: {
                        AssociationList al = ((Column)metaObject).getUniqueKeyAssociations();
                        if (al.size() > 0) {
                            for (int j = 0; j < al.size(); ++j) {
                                KeyAssociation ka = (KeyAssociation)al.get(j);
                                ForeignKey fk = ka.getOwningForeignKey();
                                AssociationList colList = fk.getKeyedColumns();
                                int size = colList.size();
                                Column fkC = ka.getForeignKeyColumn();
                                this.store.removeObjectFromStore((CMetadata)ka, null);
                                fk.getKeyedColumns().removeElement((Object)fkC);
                                if (size != 1) continue;
                                this.store.removeObjectFromStore((CMetadata)fk, null);
                            }
                        }
                        cKeyNode keyNode = (cKeyNode)((Object)((cKeyFolderNode)((Object)node.getParent())).getParent());
                        UniqueKey uKey = (UniqueKey)keyNode.getMetadata();
                        uKey.getKeyedColumns().removeElement((Object)metaObject);
                        break;
                    }
                    case 5: {
                        WsTreeNode fkNode = (WsTreeNode)node.getParent();
                        WsTreeNode parent = (WsTreeNode)fkNode.getParent();
                        int loc = this.model.getIndexOfChild((Object)parent, (Object)fkNode);
                        ForeignKey key = (ForeignKey)this.tableForeignKeys.get(loc);
                        AssociationList list = key.getKeyAssociations();
                        for (int i = 0; i < list.size(); ++i) {
                            KeyAssociation colKA = (KeyAssociation)list.get(i);
                            if (!colKA.getForeignKeyColumn().getFQID().equalsIgnoreCase(((Column)metaObject).getFQID())) continue;
                            this.store.removeObjectFromStore((CMetadata)colKA, null);
                            break;
                        }
                        AssociationList keyColumns = key.getKeyedColumns();
                        keyColumns.removeElement((Object)metaObject);
                        keyColumns.setState(2);
                        this.fireForeignKeyRemovedEvent();
                        break;
                    }
                    case 6: {
                        ForeignKey fkey = this.getForeignKey();
                        this.store.removeObjectFromStore((CMetadata)fkey, null);
                        this.fireForeignKeyRemovedEvent();
                        break;
                    }
                    case 8: {
                        ForeignKey fkey = (ForeignKey)metaObject;
                        AssociationList al = fkey.getKeyAssociations();
                        int size = al.size();
                        for (int i = --size; i > -1; --i) {
                            KeyAssociation ka = (KeyAssociation)al.get(i);
                            this.store.removeObjectFromStore((CMetadata)ka, null);
                        }
                        this.store.removeObjectFromStore(metaObject, null);
                        this.fireForeignKeyRemovedEvent();
                        break;
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Deleting");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.treePanel.setDataChanged(true);
            this.refresh();
        } else {
            this.setSelectionPath(new TreePath(this.model.getPathToRoot((TreeNode)node)));
        }
    }

    private String getDeleteMessage(WsTreeNode node) {
        try {
            int type = this.getNodeType();
            if (type == -1) {
                return null;
            }
            String name = "";
            CMetadata metaObj = null;
            if (node instanceof cKeyNode) {
                metaObj = ((WsDataTreeNode)node).getMetadata();
                name = metaObj.getName();
                type = ((cKeyNode)node).getNodeType();
            }
            String message = "";
            if (type == 2 || type == 3) {
                message = bundle.getString("WAdminTree_TableKeys.AllFKConfirmDelete.txt");
            } else {
                switch (type) {
                    case 0: {
                        WsDataTreeNode pkNode = (WsDataTreeNode)node.getFirstChild();
                        UniqueKey pKey = (UniqueKey)pkNode.getMetadata();
                        try {
                            AssociationList fKeyList = pKey.getForeignKeys();
                            name = pkNode.getMetadata().getName();
                            if (fKeyList == null || fKeyList.size() == 0) {
                                message = bundle.formatString("Common.ConfirmDelete.Text.txt", (Object)name);
                                break;
                            }
                            message = bundle.formatString("WAdminTree_TableKeys.UKFKConfirmDelete.txt", (Object)name);
                        }
                        catch (MdException me) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                        }
                        break;
                    }
                    case 7: {
                        UniqueKey pKey = (UniqueKey)metaObj;
                        try {
                            AssociationList fKeyList = pKey.getForeignKeys();
                            if (fKeyList == null || fKeyList.size() == 0) {
                                message = bundle.formatString("Common.ConfirmDelete.Text.txt", (Object)name);
                                break;
                            }
                            message = bundle.formatString("WAdminTree_TableKeys.UKFKConfirmDelete.txt", (Object)name);
                        }
                        catch (MdException me) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                        }
                        break;
                    }
                    case 10: {
                        try {
                            if (((UniqueKey)metaObj).getForeignKeys().size() > 0) {
                                message = bundle.formatString("WAdminTree_TableKeys.UKFKConfirmDelete.txt", (Object)name);
                                break;
                            }
                            message = bundle.formatString("Common.ConfirmDelete.Text.txt", (Object)name);
                        }
                        catch (MdException me) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                        }
                        break;
                    }
                    case 9: {
                        message = bundle.getString("WadminTree_TableKeys.AllUKConfirmDelete.txt");
                        break;
                    }
                    case 1: {
                        message = bundle.getString("WAdminTree_TableKeys.AllUKColumnsDelete.txt");
                        break;
                    }
                    case 4: {
                        AssociationList al = null;
                        boolean isPrimary = false;
                        cKeyNode parent = (cKeyNode)((Object)node.getParent().getParent());
                        if (parent.nodeType == 7) {
                            isPrimary = true;
                        }
                        try {
                            CMetadata metaObject = node.getMetadata();
                            al = ((Column)metaObject).getUniqueKeyAssociations();
                        }
                        catch (MdException e) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                        }
                        if (al.size() > 0) {
                            if (isPrimary) {
                                message = bundle.formatString("WAdminTree_TableKeys.PKColumnWFKDelete.txt", (Object)name);
                                break;
                            }
                            message = bundle.formatString("WAdminTree_TableKeys.UKColumnWFKDelete.txt", (Object)name);
                            break;
                        }
                        if (isPrimary) {
                            message = bundle.formatString("WAdminTree_TableKeys.PKColumnDelete.txt", (Object)name);
                            break;
                        }
                        message = bundle.formatString("WAdminTree_TableKeys.UKColumnDelete.txt", (Object)name);
                        break;
                    }
                    case 5: {
                        message = bundle.formatString("WAdminTree_TableKeys.FKColumnDelete.txt", (Object)name);
                        break;
                    }
                    case 6: {
                        WsTreeNode parent = (WsTreeNode)node.getParent();
                        int index = this.model.getIndexOfChild((Object)parent, (Object)node);
                        ForeignKey fk = null;
                        if (parent instanceof cKeyFolderNode) {
                            cKeyNode keyParent = (cKeyNode)((Object)parent.getParent());
                            try {
                                AssociationList fKeyList = ((UniqueKey)keyParent.getMetadata()).getForeignKeys();
                                fk = (ForeignKey)fKeyList.get(index);
                            }
                            catch (MdException me) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                            }
                        } else {
                            WsDataTreeNode dataNode = (WsDataTreeNode)parent;
                            fk = (ForeignKey)dataNode.getMetadata();
                        }
                        name = fk.getName();
                        message = bundle.formatString("Common.ConfirmDelete.Text.txt", (Object)name);
                        break;
                    }
                    case 8: {
                        message = bundle.formatString("Common.ConfirmDelete.Text.txt", (Object)name);
                        break;
                    }
                }
            }
            return message;
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
            return null;
        }
    }

    private void removeAllTableForeignKeys() throws MdException, RemoteException {
        AssociationList al = this.keyTable.getForeignKeys();
        int size = al.size();
        for (int i = --size; i > -1; --i) {
            ForeignKey fk = (ForeignKey)this.tableForeignKeys.get(i);
            AssociationList keyAssocs = fk.getKeyAssociations();
            int kaSize = keyAssocs.size();
            for (int j = --kaSize; j > -1; --j) {
                this.store.removeObjectFromStore((CMetadata)keyAssocs.get(j), null);
            }
            this.store.removeObjectFromStore((CMetadata)fk, null);
        }
    }

    private void removeAllKeyForeignKeys(UniqueKey key) throws MdException, RemoteException {
        AssociationList al = key.getForeignKeys();
        int size = al.size();
        for (int i = --size; i > -1; --i) {
            ForeignKey fk = (ForeignKey)al.get(i);
            AssociationList keyAssocs = fk.getKeyAssociations();
            int kaSize = keyAssocs.size();
            for (int j = --kaSize; j > -1; --j) {
                this.store.removeObjectFromStore((CMetadata)keyAssocs.get(j), null);
            }
            this.store.removeObjectFromStore((CMetadata)fk, null);
        }
    }

    public void fireForeignKeyRemovedEvent() {
        Object[] alListeners = this.listenerList.getListenerList();
        ForeignKeyEvent e = null;
        for (int iListener = alListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (alListeners[iListener] != ForeignKeyEventListener.class) continue;
            if (e == null) {
                e = new ForeignKeyEvent(this, 1);
            }
            ((ForeignKeyEventListener)alListeners[iListener + 1]).foreignKeyRemoved(e);
        }
    }

    public static interface ForeignKeyEventListener
    extends EventListener {
        public void foreignKeyRemoved(ForeignKeyEvent var1);
    }

    public class ForeignKeyEvent
    extends AWTEvent {
        public static final int FOREIGNKEY_REMOVED = 1;

        public ForeignKeyEvent(WAdminTree_TableKeys src, int eventId) {
            super((Object)src, eventId);
        }
    }

    protected class cKeyNode
    extends WsDataTreeNode {
        protected WsAbstractAction actionMoveColumnUp;
        protected WsAbstractAction actionMoveColumnDown;
        protected int nodeType;

        public cKeyNode(CMetadata object, int type) {
            super(object);
            this.nodeType = type;
            if (this.nodeType == 7 || this.nodeType == 8 || this.nodeType == 10) {
                this.setSorted(false);
            } else if (this.nodeType == 4 || this.nodeType == 5) {
                this.setAllowsChildren(false);
                Column col = (Column)object;
                this.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((Column)col));
                if (this.nodeType == 4) {
                    this.createActions();
                }
            } else {
                this.setAllowsChildren(false);
            }
            if (this.nodeType == 4) {
                this.setDragSource(WAdminTree_TableKeys.this.isEditable);
                this.setDropTarget(WAdminTree_TableKeys.this.isEditable);
            } else {
                this.setDragSource(false);
                this.setDropTarget(false);
            }
            this.m_bDeleteable = true;
            this.setIsEditable(WAdminTree_TableKeys.this.isEditable);
        }

        public void addChildren() {
            try {
                switch (this.nodeType) {
                    case 7: {
                        this.addChild(this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.ColumnsGroup.txt"), 1));
                        if (WAdminTree_TableKeys.this.primaryKey.getForeignKeys().size() <= 0) break;
                        this.addChild(this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.AssociatedTables.txt"), 2));
                        break;
                    }
                    case 10: {
                        UniqueKey uKey = (UniqueKey)this.m_oMetadata;
                        this.addChild(this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.ColumnsGroup.txt"), 1));
                        if (uKey.getForeignKeys().size() <= 0) break;
                        this.addChild(this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.AssociatedTables.txt"), 2));
                        break;
                    }
                    case 8: {
                        ForeignKey key = (ForeignKey)this.m_oMetadata;
                        UniqueKey uKey = key.getPartnerUniqueKey();
                        PhysicalTable table = (PhysicalTable)uKey.getTable();
                        AssociationList columns = key.getKeyedColumns();
                        for (int i = 0; i < columns.size(); ++i) {
                            this.addChild(this.createKeyNode((CMetadata)columns.get(i), 5));
                        }
                        this.addChild(this.createKeyNode((CMetadata)table, 6));
                        break;
                    }
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public void setIsEditable(boolean bIsEditable) {
            this.setDeleteable(bIsEditable);
            this.setRenameable(bIsEditable);
            if (this.nodeType == 4) {
                this.setAllowsMoveColumnDown(bIsEditable);
                this.setAllowsMoveColumnUp(bIsEditable);
            }
        }

        public void saveSettingsAndCleanUp() {
            this.m_oMetadata = null;
        }

        public WsTreeNode createKeyFolderNode(String name, int type) {
            return new cKeyFolderNode(name, type);
        }

        public WsTreeNode createKeyNode(CMetadata colObject, int type) {
            return new cKeyNode(colObject, type);
        }

        public void drop(DropTargetDropEvent e) {
            Transferable transfer = e.getTransferable();
            if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                Vector vDragObjects = null;
                try {
                    vDragObjects = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().error((Object)("IOException: " + ex.getLocalizedMessage()));
                    e.dropComplete(false);
                    return;
                }
                catch (UnsupportedFlavorException ex) {
                    Workspace.getDefaultLogger().error((Object)("UnSupportedFlavorException: " + ex.getLocalizedMessage()));
                    e.dropComplete(false);
                    return;
                }
                try {
                    cKeyFolderNode keyParent = (cKeyFolderNode)((Object)this.getParent());
                    cKeyNode ukNode = (cKeyNode)((Object)keyParent.getParent());
                    UniqueKey uk = (UniqueKey)ukNode.getMetadata();
                    AssociationList ukColumns = uk.getKeyedColumns();
                    for (int i = 0; i < vDragObjects.size(); ++i) {
                        Object obj = vDragObjects.get(i);
                        if (this.nodeType != 4) continue;
                        int loc = WAdminTree_TableKeys.this.model.getIndexOfChild((Object)keyParent, (Object)this) + 1;
                        if (obj instanceof Column) {
                            boolean addChild = true;
                            CMetadata metaObj = (CMetadata)obj;
                            for (int j = 0; j < keyParent.getChildCount(); ++j) {
                                WsDataTreeNode child = (WsDataTreeNode)keyParent.getChildAt(j);
                                if (child.getMetadata().getFQID() != metaObj.getFQID()) continue;
                                addChild = false;
                                break;
                            }
                            if (addChild) {
                                WsTreeNode newNode = keyParent.createKeyNode(metaObj, 4);
                                WAdminTree_TableKeys.this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)keyParent), loc);
                                ukColumns.insertElementAt((Object)metaObj, loc);
                            }
                        }
                        if (!(obj instanceof cKeyNode)) continue;
                        cKeyNode dragNode = (cKeyNode)((Object)obj);
                        WsTreeNode dragParent = (WsTreeNode)dragNode.getParent();
                        cKeyNode dragUKNode = (cKeyNode)((Object)dragParent.getParent());
                        UniqueKey dragUK = (UniqueKey)dragUKNode.getMetadata();
                        int oldLoc = WAdminTree_TableKeys.this.model.getIndexOfChild((Object)dragParent, (Object)dragNode);
                        dragUK.getKeyedColumns().remove(oldLoc);
                        CMetadata col = dragNode.getMetadata();
                        WsTreeNode newNode = keyParent.createKeyNode(col, 4);
                        WAdminTree_TableKeys.this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)keyParent), loc);
                        ukColumns.insertElementAt((Object)col, loc - 1);
                        WAdminTree_TableKeys.this.model.removeChild((WsTreeNode)dragNode);
                    }
                    WAdminTree_TableKeys.this.setPanelDataChanged(true);
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else {
                e.dropComplete(false);
            }
        }

        public int getNodeType() {
            return this.nodeType;
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            super.updateWorkspaceUIComponents(bActive);
            WAdminTree_TableKeys.this.m_actDelete.setActive(bActive);
        }

        protected void createActions() {
            this.actionMoveColumnUp = this.createMoveColumnUpAction();
            this.actionMoveColumnDown = this.createMoveColumnDownAction();
        }

        protected WsAbstractAction createMoveColumnUpAction() {
            return new cMoveColumnUpAction();
        }

        protected WsAbstractAction createMoveColumnDownAction() {
            return new cMoveColumnDownAction();
        }

        public void doDefaultAction() {
            if (this.nodeType == 6 || this.nodeType == 7 || this.nodeType == 10 || this.nodeType == 4 || this.nodeType == 8) {
                super.doDefaultAction();
            }
        }

        public void rename(String sName) {
            try {
                this.m_sName = sName.length() > 60 ? sName.substring(0, 60) : sName;
                this.m_oMetadata.setName(this.m_sName);
                this.getTreeModel().resortChild((WsTreeNode)this);
                WAdminTree_TableKeys.this.setPanelDataChanged(true);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        public void setAllowsMoveColumnUp(boolean allows) {
            this.actionMoveColumnUp.setEnabled(allows);
        }

        public void setAllowsMoveColumnDown(boolean allows) {
            this.actionMoveColumnDown.setEnabled(allows);
        }

        public JPopupMenu getPopupMenu(WAdminResource menuBundle) {
            JPopupMenu menuPopup = new JPopupMenu();
            if (this.nodeType == 4) {
                menuPopup.add(new JMenuItem((Action)this.actionMoveColumnUp));
                menuPopup.add(new JMenuItem((Action)this.actionMoveColumnDown));
                menuPopup.addSeparator();
            }
            menuPopup.add((Action)WAdminTree_TableKeys.this.m_actRename);
            menuPopup.add((Action)WAdminTree_TableKeys.this.m_actDelete);
            return menuPopup;
        }

        protected class cMoveColumnDownAction
        extends WsAbstractAction {
            public cMoveColumnDownAction() {
                super(bundle, "Tree.Column.MoveDown", false);
            }

            public void actionPerformed(ActionEvent e) {
                WAdminTree_TableKeys.this.onMoveDown();
            }
        }

        protected class cMoveColumnUpAction
        extends WsAbstractAction {
            public cMoveColumnUpAction() {
                super(bundle, "Tree.Column.MoveUp", false);
            }

            public void actionPerformed(ActionEvent e) {
                WAdminTree_TableKeys.this.onMoveUp();
            }
        }
    }

    protected class cKeyFolderNode
    extends WsTreeNode {
        protected int nodeType;

        public cKeyFolderNode(String name, int type) {
            super(name);
            this.nodeType = type;
            this.setSorted(false);
            this.setDragSource(false);
            this.setDeleteable(false);
            this.setRenameable(false);
            if (this.nodeType == 1) {
                this.setDropTarget(true);
            } else {
                this.setDropTarget(false);
            }
            this.m_bDeleteable = true;
        }

        public void addChildren() {
            try {
                switch (this.nodeType) {
                    case 0: {
                        WAdminTree_TableKeys.this.primaryKeyNode = (WsDataTreeNode)this.createKeyNode((CMetadata)WAdminTree_TableKeys.this.primaryKey, 7);
                        this.addChild((WsTreeNode)WAdminTree_TableKeys.this.primaryKeyNode);
                        break;
                    }
                    case 9: {
                        for (int i = 0; i < WAdminTree_TableKeys.this.uniqueKeys.size(); ++i) {
                            UniqueKey key = (UniqueKey)WAdminTree_TableKeys.this.uniqueKeys.get(i);
                            if (key == WAdminTree_TableKeys.this.primaryKey) continue;
                            this.addChild(this.createKeyNode((CMetadata)key, 10));
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < WAdminTree_TableKeys.this.tableForeignKeys.size(); ++i) {
                            this.addChild(this.createKeyNode((CMetadata)WAdminTree_TableKeys.this.tableForeignKeys.get(i), 8));
                        }
                        break;
                    }
                    case 2: {
                        cKeyNode keyParent = (cKeyNode)((Object)this.getParent());
                        UniqueKey uKey = (UniqueKey)keyParent.getMetadata();
                        Object keyForeignKeys = uKey.getForeignKeys();
                        keyForeignKeys = Workspace.removeCheckouts((List)keyForeignKeys);
                        for (int j = 0; j < keyForeignKeys.size(); ++j) {
                            ForeignKey fk = (ForeignKey)keyForeignKeys.get(j);
                            PhysicalTable fktable = (PhysicalTable)fk.getTable();
                            this.addChild(this.createKeyNode((CMetadata)fktable, 6));
                        }
                        break;
                    }
                    case 1: {
                        cKeyNode keyParent = (cKeyNode)((Object)this.getParent());
                        UniqueKey uKey = (UniqueKey)keyParent.getMetadata();
                        AssociationList keyCols = uKey.getKeyedColumns();
                        for (int i = 0; i < keyCols.size(); ++i) {
                            this.addChild(this.createKeyNode((CMetadata)keyCols.get(i), 4));
                        }
                        break;
                    }
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }

        public WsTreeNode createKeyNode(CMetadata object, int type) {
            return new cKeyNode(object, type);
        }

        public void doDefaultAction() {
        }

        public JPopupMenu getPopupMenu(WAdminResource keyBundle) {
            JPopupMenu menuPopup = new JPopupMenu();
            menuPopup.add((Action)WAdminTree_TableKeys.this.m_actDelete);
            return menuPopup;
        }

        public int getNodeType() {
            return this.nodeType;
        }

        public void drop(DropTargetDropEvent e) {
            Transferable transfer = e.getTransferable();
            if (transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                Vector vDragObjects = null;
                try {
                    vDragObjects = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().error((Object)("IOException: " + ex.getLocalizedMessage()));
                    e.dropComplete(false);
                    return;
                }
                catch (UnsupportedFlavorException ex) {
                    Workspace.getDefaultLogger().error((Object)("UnSupportedFlavorException: " + ex.getLocalizedMessage()));
                    e.dropComplete(false);
                    return;
                }
                try {
                    cKeyNode keyParent = (cKeyNode)((Object)this.getParent());
                    UniqueKey uk = (UniqueKey)keyParent.getMetadata();
                    AssociationList ukColumns = uk.getKeyedColumns();
                    int childCount = this.getChildCount();
                    for (int i = 0; i < vDragObjects.size(); ++i) {
                        Object obj = vDragObjects.get(i);
                        boolean addChild = true;
                        if (obj instanceof CMetadata) {
                            CMetadata metaObj = (CMetadata)obj;
                            addChild = true;
                            for (int j = 0; j < childCount; ++j) {
                                WsDataTreeNode child = (WsDataTreeNode)this.getChildAt(j);
                                if (child.getMetadata().getFQID() != metaObj.getFQID()) continue;
                                addChild = false;
                                break;
                            }
                            if (addChild) {
                                WsTreeNode newNode = this.createKeyNode(metaObj, 4);
                                WAdminTree_TableKeys.this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)this), 0);
                                ukColumns.insertElementAt((Object)metaObj, 0);
                            }
                        }
                        if (!(obj instanceof cKeyNode)) continue;
                        cKeyNode dragNode = (cKeyNode)((Object)obj);
                        WsTreeNode dragParent = (WsTreeNode)dragNode.getParent();
                        cKeyNode dragUKNode = (cKeyNode)((Object)dragParent.getParent());
                        UniqueKey dragUK = (UniqueKey)dragUKNode.getMetadata();
                        int oldLoc = WAdminTree_TableKeys.this.model.getIndexOfChild((Object)dragParent, (Object)dragNode);
                        dragUK.getKeyedColumns().remove(oldLoc);
                        CMetadata col = dragNode.getMetadata();
                        WsTreeNode newNode = this.createKeyNode(col, 4);
                        WAdminTree_TableKeys.this.model.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)((Object)this), 0);
                        ukColumns.insertElementAt((Object)col, 0);
                        WAdminTree_TableKeys.this.model.removeChild((WsTreeNode)dragNode);
                    }
                    WAdminTree_TableKeys.this.setPanelDataChanged(true);
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            } else {
                e.dropComplete(false);
            }
        }

        public void updateWorkspaceUIComponents(boolean bActive) {
            WAdminTree_TableKeys.this.m_actDelete.setActive(bActive);
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
        }
    }

    protected class cRootNode
    extends WsTreeNode {
        public cRootNode() {
            super(bundle.getString("Common.TableKeys.Title.txt"));
            this.setDragSource(false);
            this.setDropTarget(false);
            this.setSorted(false);
        }

        public void addChildren() {
            if (WAdminTree_TableKeys.this.primaryKey != null) {
                this.addChild(this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.PrimaryNode.txt"), 0));
            }
            if (WAdminTree_TableKeys.this.hasUniqueKeys) {
                WAdminTree_TableKeys.this.uniqueKeyFolderNode = this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.UniqueKeyNode.txt"), 9);
                this.addChild(WAdminTree_TableKeys.this.uniqueKeyFolderNode);
            }
            if (WAdminTree_TableKeys.this.tableForeignKeys.size() > 0) {
                WAdminTree_TableKeys.this.foreignKeyFolderNode = this.createKeyFolderNode(bundle.getString("WAdminTree_TableKeys.ForeignNode.txt"), 3);
                this.addChild(WAdminTree_TableKeys.this.foreignKeyFolderNode);
            }
        }

        public Icon getIcon(boolean bExpanded) {
            return bExpanded ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon();
        }

        public WsTreeNode createKeyFolderNode(String name, int type) {
            return new cKeyFolderNode(name, type);
        }
    }

    protected class cDragGestureListener
    implements DragGestureListener {
        protected cDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (!WAdminTree_TableKeys.this.m_bDraggingEnabled) {
                return;
            }
            if (WAdminTree_TableKeys.this.isEditing()) {
                return;
            }
            WsTreeNode[] aSelectedNodes = WAdminTree_TableKeys.this.getSelectedNodes();
            if (aSelectedNodes.length != 0) {
                DNDObject oDrag = new DNDObject();
                int nSelectedNodes = aSelectedNodes.length;
                for (int iSelectedNode = 0; iSelectedNode < nSelectedNodes; ++iSelectedNode) {
                    if (!aSelectedNodes[iSelectedNode].isDragSource()) {
                        return;
                    }
                    oDrag.add((Object)aSelectedNodes[iSelectedNode]);
                }
                WAdminTree_TableKeys.this.m_dragSource.startDrag(event, null, (Transferable)oDrag, WAdminTree_TableKeys.this.createDragSourceListener());
                WAdminTree_TableKeys.this.m_bDragging = true;
            }
        }
    }
}

