/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.promotion.visuals.ImportWizard;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.model.tree.DefaultInventoryNodeFactory;
import com.sas.wadmin.model.tree.LogicalObjectNode;
import com.sas.wadmin.visuals.CheckInDialog;
import com.sas.wadmin.visuals.InventoryTreeNode;
import com.sas.wadmin.visuals.MultiInventoryTreeNode;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.wadmin.visuals.NewProjectWizard;
import com.sas.wadmin.visuals.OperationUIAdapter;
import com.sas.wadmin.visuals.TreeTreeNode;
import com.sas.wadmin.visuals.WAdminTree_Warehouse;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.WsTreeNode;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WAdminTree_Project
extends WAdminTree_Warehouse {
    private static WAdminResource bundle = WAdminResource.getBundle(WAdminTree_Project.class);
    protected String m_changeName = null;
    protected String m_changeDesc = null;
    protected WorkspaceTreeModel m_model;
    protected WsAbstractAction m_actDestroy;
    protected Vector checkedInObjects;
    protected boolean m_bkeepCheckedOut;
    protected boolean m_fUndoCheckout = false;
    protected List m_lTSSteps;
    protected boolean m_bHoldUpdates = false;

    public WAdminTree_Project() {
        cProjectTreeCellRenderer tcr = new cProjectTreeCellRenderer();
        this.setCellRenderer((TreeCellRenderer)((Object)tcr));
        this.m_lTSSteps = new ArrayList();
    }

    public CMetadata getSelectedProjectRepository() {
        return Workspace.getWorkspace().getProjectRepository();
    }

    public void initialize() {
        super.initialize();
        this.m_model = (WorkspaceTreeModel)this.getModel();
        this.m_model.setHandleObjectsCreatedMetadataEvent(false);
        this.m_model.setName("Project");
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.m_actCheckout.setEnabled(false);
        this.m_actFetch.setEnabled(false);
        this.m_actDestroy = this.createDestroyAction();
    }

    protected WsAbstractAction createDestroyAction() {
        return new cDestroyAction();
    }

    @Override
    protected TreeSelectionListener createSelectionListener() {
        return new cProjectSelectionListener();
    }

    @Override
    protected WsTreeNode createRootNode() {
        CMetadata repos = Workspace.getWorkspace().getProjectRepository();
        return new cProjectRepositoryNode(repos);
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actDestroy.setActive(bActive);
    }

    public void onAdd() {
        NewProjectWizard dlgNewProject = new NewProjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("NewProjectWizard.Title.txt"));
        dlgNewProject.show();
    }

    @Override
    public void onNewObject() {
        NewObjectWizard wizard = new NewObjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("NewObjectWizard.tab1Title.txt"));
        wizard.show();
        wizard.handleGlobals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onImport() {
        block13: {
            try {
                WsTreeNode[] aNodes = this.getSelectedNodes();
                WsTreeNode treeNode = aNodes[0];
                if (treeNode == null) break block13;
                String sWizardTitle = bundle.getString("WAdminTree_ChangeManagement.ImportWizardTitle.txt");
                TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
                MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Project.onImport");
                try {
                    ImportWizard wizard;
                    if (treeNode instanceof TreeTreeNode) {
                        CMetadata mdNode = treeNode.getMetadata();
                        Tree mdTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(mdStore, mdNode.getName(), mdNode.getCMetadataType(), mdNode.getFQID());
                        wizard = new ImportWizard(mdTree, aSupportedTypes, sWizardTitle);
                    } else {
                        String sCheckinReposID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                        Tree mdTree = CustomTreeModel.getDISCustomTreeRootFolder(sCheckinReposID, mdStore);
                        wizard = new ImportWizard(mdTree, aSupportedTypes, sWizardTitle);
                    }
                    wizard.changeRepositoryID(Workspace.getWorkspace().getProjectRepository().getFQID());
                    wizard.show();
                    if (wizard.objectsWereImported()) {
                        this.generateObjectsModifiedEvent(wizard.getTargetObjectIDs());
                    }
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                finally {
                    mdStore.dispose();
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPaste() {
        block14: {
            try {
                WsTreeNode[] aNodes = this.getSelectedNodes();
                WsTreeNode treeNode = aNodes[0];
                if (treeNode == null) break block14;
                MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Project:onPaste");
                try {
                    FolderInterface folder = null;
                    if (treeNode instanceof TreeTreeNode) {
                        CMetadata mdNode = treeNode.getMetadata();
                        Tree mdTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(mdStore, mdNode.getName(), mdNode.getCMetadataType(), mdNode.getFQID());
                        folder = (FolderInterface)Factory.getInstance().getObject((Root)mdTree);
                    } else {
                        String sCheckinReposID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                        Tree mdTree = CustomTreeModel.getDISCustomTreeRootFolder(sCheckinReposID, mdStore);
                        folder = (FolderInterface)Factory.getInstance().getObject((Root)mdTree);
                    }
                    CopyPasteUtil.paste((FolderInterface)folder, (TypeInterface[])Factory.getInstance().getTypesSupported(), (String)Workspace.getWorkspace().getProjectRepository().getFQID());
                    if (CopyPasteUtil.objectsWerePasted()) {
                        this.generateObjectsModifiedEvent(CopyPasteUtil.getObjectsPasted());
                    }
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (LogicalTypeException lte) {
                    lte.printStackTrace();
                }
                finally {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPasteSpecial() {
        block14: {
            try {
                WsTreeNode[] aNodes = this.getSelectedNodes();
                WsTreeNode treeNode = aNodes[0];
                if (treeNode == null) break block14;
                MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Project:onPasteSpecial");
                try {
                    FolderInterface folder = null;
                    if (treeNode instanceof TreeTreeNode) {
                        CMetadata mdNode = treeNode.getMetadata();
                        Tree mdTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(mdStore, mdNode.getName(), mdNode.getCMetadataType(), mdNode.getFQID());
                        folder = (FolderInterface)Factory.getInstance().getObject((Root)mdTree);
                    } else {
                        String sCheckinReposID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                        Tree mdTree = CustomTreeModel.getDISCustomTreeRootFolder(sCheckinReposID, mdStore);
                        folder = (FolderInterface)Factory.getInstance().getObject((Root)mdTree);
                    }
                    CopyPasteUtil.pasteSpecial((FolderInterface)folder, (TypeInterface[])Factory.getInstance().getTypesSupported(), (String)Workspace.getWorkspace().getProjectRepository().getFQID());
                    if (CopyPasteUtil.objectsWerePasted()) {
                        this.generateObjectsModifiedEvent(CopyPasteUtil.getObjectsPasted());
                    }
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (LogicalTypeException lte) {
                    lte.printStackTrace();
                }
                finally {
                    mdStore.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    public void onDelete() {
        try {
            this.m_objectArray.clear();
            this.m_store = null;
            TreePath[] paths = this.getSelectionPaths();
            if (paths.length == 0) {
                return;
            }
            final WsTreeNode[] aNodes = this.getSelectedNodes();
            if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoDelete.Text.fmt")) {
                return;
            }
            if (!this.areNodesReallyCMDeleteable(aNodes)) {
                return;
            }
            StringBuffer sNames = new StringBuffer();
            if (aNodes.length == 1) {
                sNames.append(aNodes[0].getName());
            } else if (aNodes.length == 2) {
                sNames.append(bundle.formatString("Common.TwoNames.fmt", (Object)aNodes[0].getName(), (Object)aNodes[1].getName()));
            } else {
                int iNode;
                int nNodes = aNodes.length;
                for (iNode = 0; iNode < nNodes - 1; ++iNode) {
                    sNames.append(aNodes[iNode].getName());
                    sNames.append(", ");
                }
                sNames.append(bundle.getString("Common.and.txt"));
                sNames.append(" ");
                sNames.append(aNodes[iNode].getName());
            }
            int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("Common.ConfirmDelete.Text.txt", (Object)sNames), (String)bundle.getString("Common.ConfirmDelete.Title.txt"), (int)2, (int)0);
            if (eAnswer == 0) {
                this.m_fUndoCheckout = false;
                int iNewObjects = 0;
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    CMetadata object = node.getMetadata();
                    String sChangeState = ((Root)object).getChangeState();
                    if (sChangeState != null && sChangeState.length() != 0) continue;
                    ++iNewObjects;
                }
                final Integer iNumberOfNewObjects = new Integer(iNewObjects);
                if (iNewObjects > 0) {
                    Integer i = new Integer(iNewObjects);
                    final OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.formatString("WAdminTree_Project.DeleteProgressIndicator.Message.fmt.txt", (Object)i, (Object)i), bundle.getString("WAdminTree_Project.DeleteProgressIndicator.Title.txt"));
                    request.setDelayBeforeProgressCancelDialog(200);
                    Runnable runDelete = new Runnable(){

                        @Override
                        public void run() {
                            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)request);
                            int nNodes = aNodes.length;
                            int iCounter = 0;
                            for (int iNode = 0; iNode < nNodes; ++iNode) {
                                try {
                                    WsTreeNode treeNode = aNodes[iNode];
                                    CMetadata object = treeNode.getMetadata();
                                    String sChangeState = ((Root)object).getChangeState();
                                    if (sChangeState == null || sChangeState.length() == 0) {
                                        request.setMessage(bundle.formatString("WAdminTree_Project.DeleteProgressIndicator.Message.fmt.txt", (Object)new Integer(++iCounter), (Object)iNumberOfNewObjects));
                                        if (aNodes[iNode] instanceof LogicalObjectNode) {
                                            ((LogicalObjectNode)aNodes[iNode]).delete(op);
                                            continue;
                                        }
                                        treeNode.delete();
                                        continue;
                                    }
                                    WAdminTree_Project.this.m_fUndoCheckout = true;
                                    continue;
                                }
                                catch (RemoteException e) {
                                    Workspace.handleRemoteException((RemoteException)e);
                                }
                            }
                        }
                    };
                    request.execute(runDelete);
                } else {
                    this.m_fUndoCheckout = true;
                }
                if (this.m_fUndoCheckout) {
                    this.onUndoCheckout();
                }
                if (paths.length > 0) {
                    this.refresh();
                }
                this.m_fUndoCheckout = false;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    @Override
    public void onUndoCheckout() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        WsTreeNode[] aNodes = this.getSelectedNodes();
        if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoUndoCheckout.Text.fmt")) {
            return;
        }
        Integer nNewAndCheckedout = new Integer(paths.length);
        try {
            String str1 = bundle.getString("UndoCheckoutMetadataProgressIndicator.Msg.Message");
            String str2 = bundle.getString("UndoCheckoutMetadataProgressIndicator.Msg.Title");
            if (this.m_fUndoCheckout) {
                str1 = bundle.formatString("DeleteMetadataProgressIndicator.Msg.Message.fmt.txt", (Object)nNewAndCheckedout);
                str2 = bundle.getString("DeleteMetadataProgressIndicator.Msg.Title");
            }
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            Runnable runUndoCheckout = new Runnable(){

                @Override
                public void run() {
                    WAdminTree_Project.this.doThreadedUndocheckout();
                }
            };
            request.execute(runUndoCheckout);
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on undocheckout");
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error((Object)("Error encountered while undo checkout data" + ge.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        try {
            this.m_lTSSteps.clear();
            ArrayList<TransformationStep> lnewTSSteps = new ArrayList<TransformationStep>();
            TreePath[] paths = this.getSelectionPaths();
            if (paths.length == 0) {
                return;
            }
            WsTreeNode[] aNodes = this.getSelectedNodes();
            if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoDestroy.Text.fmt")) {
                return;
            }
            if (!this.areNodesReallyDestroyable(aNodes)) {
                return;
            }
            boolean b_needJobMessage = false;
            StringBuffer sJobCheckOutMessage = new StringBuffer();
            MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WadminTree_Project:onDestroy");
            try {
                int n = aNodes.length;
                for (int i = 0; i < n; ++i) {
                    CMetadata object = aNodes[i].getMetadata();
                    String sType = object.getCMetadataType();
                    if (sType.equals("Job")) {
                        Job mdJob = (Job)Workspace.getMdFactory().createComplexMetadataObject(mdStore, object);
                        AssociationList lSteps = mdJob.getSteps();
                        int nSteps = lSteps.size();
                        boolean b_resetJobMessage = true;
                        for (int iStep = 0; iStep < nSteps; ++iStep) {
                            TransformationStep tsStep = (TransformationStep)lSteps.get(iStep);
                            if (!Workspace.getWorkspace().getProjectRepositoryId().equals(tsStep.getFQID().substring(0, 8))) {
                                AssociationList l_activities;
                                TransformationActivity ta;
                                AssociationList l_jobs;
                                b_needJobMessage = true;
                                if (b_resetJobMessage) {
                                    sJobCheckOutMessage.append(bundle.formatString("WAdminTree_Project.CheckOutContainingJobs.Message.fmt", (Object)mdJob.getName())).append("\n");
                                    b_resetJobMessage = false;
                                }
                                if ((l_jobs = (ta = (TransformationActivity)(l_activities = tsStep.getActivities()).get(0)).getJobs()) == null || l_jobs.size() <= 0) continue;
                                Job oJob = (Job)l_jobs.get(0);
                                sJobCheckOutMessage.append(oJob.getName()).append("\n");
                                continue;
                            }
                            if (b_needJobMessage) continue;
                            if (tsStep.getChangeState() != null && tsStep.getChangeState().length() > 0) {
                                this.m_lTSSteps.add(tsStep);
                                continue;
                            }
                            lnewTSSteps.add(tsStep);
                        }
                    }
                    sJobCheckOutMessage.append("\n");
                }
                if (b_needJobMessage) {
                    MessageUtil.displayMessage((String)sJobCheckOutMessage.toString(), (String)bundle.getString("WAdminTree_Project.CheckOutContainingJobs.Message.Title.txt"), (int)2);
                    this.m_lTSSteps.clear();
                    lnewTSSteps.clear();
                    return;
                }
                StringBuffer sNames = new StringBuffer();
                if (aNodes.length == 1) {
                    sNames.append(aNodes[0].getName());
                } else {
                    int iNode;
                    int nNodes = aNodes.length;
                    for (iNode = 0; iNode < nNodes - 1; ++iNode) {
                        sNames.append(aNodes[iNode].getName());
                        sNames.append(", ");
                    }
                    sNames.append(bundle.getString("Common.and.txt"));
                    sNames.append(" ");
                    sNames.append(aNodes[iNode].getName());
                }
                int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("Common.ConfirmDestroy.Text.txt", (Object)sNames), (String)bundle.getString("Common.ConfirmDestroy.Title.txt"), (int)2, (int)0);
                if (eAnswer == 0) {
                    if (lnewTSSteps.size() > 0) {
                        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("DestroyMetadataProgressIndicator.Msg.Message"), bundle.getString("DestroyMetadataProgressIndicator.Msg.Title"));
                        request.setDelayBeforeProgressCancelDialog(200);
                        final ArrayList<TransformationStep> l_finalNewTSSteps = lnewTSSteps;
                        Runnable runDelete = new Runnable(){

                            @Override
                            public void run() {
                                int i_numNewSteps = l_finalNewTSSteps.size();
                                for (int i_newStep = 0; i_newStep < i_numNewSteps; ++i_newStep) {
                                    CMetadata object = (CMetadata)l_finalNewTSSteps.get(i_newStep);
                                    try {
                                        Workspace.getMdFactory().deleteMetadataObject(object);
                                        continue;
                                    }
                                    catch (MdException mde) {
                                        MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Deleting");
                                        continue;
                                    }
                                    catch (RemoteException re) {
                                        Workspace.handleRemoteException((RemoteException)re);
                                    }
                                }
                            }
                        };
                        request.execute(runDelete);
                    }
                    try {
                        String str1 = bundle.getString("DestroyMetadataProgressIndicator.Msg.Message");
                        String str2 = bundle.getString("DestroyMetadataProgressIndicator.Msg.Title");
                        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
                        request.setDelayBeforeProgressCancelDialog(200);
                        Runnable runDestroy = new Runnable(){

                            @Override
                            public void run() {
                                WAdminTree_Project.this.doThreadedDestroy();
                            }
                        };
                        request.execute(runDestroy);
                        Workspace.getDefaultLogger().debug((Object)"Finished waiting on destroy");
                    }
                    catch (Exception ge) {
                        Workspace.getDefaultLogger().error((Object)("Error encountered while destroy" + ge.getMessage()));
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            finally {
                if (mdStore != null) {
                    mdStore.dispose();
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void onCheckin() {
        try {
            if (this.getRowCount() > 1) {
                TreePath[] aPaths = this.getPathBetweenRows(1, this.getRowCount() - 1);
                int nPaths = aPaths == null ? 0 : aPaths.length;
                WsTreeNode[] aNodes = new WsTreeNode[nPaths];
                MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                MdObjectStore store = factory.createObjectStore();
                for (int iPath = 0; iPath < nPaths; ++iPath) {
                    int cmState;
                    WsTreeNode thisone = (WsTreeNode)aPaths[iPath].getLastPathComponent();
                    CMetadata oData = factory.createComplexMetadataObject(store, thisone.getMetadata());
                    if (!oData.getCMetadataType().equals("Environment")) {
                        try {
                            if (oData != null) {
                                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(oData, null, null, null, 8);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((cmState = oData.getChangeManagementState()) == 2) continue;
                    aNodes[iPath] = (WsTreeNode)aPaths[iPath].getLastPathComponent();
                }
                store.dispose();
                if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoCheckin.Text.fmt")) {
                    return;
                }
            }
            String m_strTitle = bundle.getString("CheckInDialog.Title.txt");
            CheckInDialog newDlg = new CheckInDialog((Frame)Workspace.getWorkspace(), m_strTitle);
            newDlg.show();
            if (newDlg.getReturnValue() == 2) {
                newDlg.dispose();
                return;
            }
            this.m_changeName = newDlg.getChangeName();
            this.m_changeDesc = newDlg.getChangeDesc();
            this.m_bkeepCheckedOut = newDlg.getKeepCheckedOut();
            newDlg.dispose();
            try {
                String str1 = bundle.getString("CheckinMetadataProgressIndicator.Msg.Message");
                String str2 = bundle.getString("CheckinMetadataProgressIndicator.Msg.Title");
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new InitializeCheckIn(), (Runnable)new CheckOutAgain());
                Workspace.getDefaultLogger().debug((Object)"Finished waiting on checkin/checkout");
            }
            catch (Exception ge) {
                Workspace.getDefaultLogger().error((Object)("Error encountered while checking in data" + ge.getMessage()));
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void doThreadedCheckin() {
        Workspace.getDefaultLogger().debug((Object)"Starting checkin");
        try {
            WsTreeNode nodeSelected = this.getSelectedNode();
            if (nodeSelected instanceof cProjectRepositoryNode) {
                WsTreeNode nodeFound = this.m_model.getFirstMetadataObjectNode(nodeSelected);
                if (nodeFound == null) {
                    return;
                }
                nodeSelected = nodeFound;
            }
            CMetadata projectRepos = Workspace.getWorkspace().getDefaultRepository();
            this.checkedInObjects = ProjectUtil.checkIn((CMetadata)projectRepos, (String)this.m_changeName, (String)this.m_changeDesc);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            MessageUtil.displayMessage((String)(bundle.getString("Common.ErrorCheckinginMetadata.txt") + e.getLocalizedMessage()), (String)bundle.getString("Common.Error.txt"), (int)0);
        }
        Workspace.getDefaultLogger().debug((Object)"Finished checkin");
    }

    @Override
    public void doThreadedClearProject() {
        if (this.m_projectRepository == null) {
            this.m_projectRepository = Workspace.getWorkspace().getProjectRepository();
        }
        try {
            ProjectUtil.clearProject((String)this.m_projectRepository.getFQID());
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"ClearProject");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"disposing of store");
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Finished ClearProject");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doThreadedUndocheckout() {
        try {
            Workspace.getDefaultLogger().debug((Object)"Starting undocheckout");
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            try {
                TreePath[] paths = this.getSelectionPaths();
                Vector<CMetadata> m_allObjects = new Vector<CMetadata>();
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    CMetadata undoObject = node.getMetadata();
                    if (((Root)undoObject).getChangeState() == null || ((Root)undoObject).getChangeState().length() == 0) continue;
                    CMetadata detailObject = Workspace.getMdFactory().createComplexMetadataObject(store, null, undoObject.getName(), undoObject.getCMetadataType(), undoObject.getFQID(), null);
                    m_allObjects.add(detailObject);
                }
                CMetadata projectRepos = Workspace.getWorkspace().getProjectRepository();
                ProjectUtil.undocheckoutMetadata(m_allObjects, (CMetadata)projectRepos);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                String message = e.getLocalizedMessage() == null ? bundle.getString("Common.ErrorNullException.txt") : e.getLocalizedMessage();
                MessageUtil.displayMessage((String)(bundle.getString("Common.ErrorUndoCheckoutMetadata.txt") + message), (String)bundle.getString("Common.Error.txt"), (int)0);
            }
            finally {
                if (store != null) {
                    store.dispose();
                    store = null;
                }
            }
            Workspace.getDefaultLogger().debug((Object)"Finished checkundocheckout");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doThreadedDestroy() {
        try {
            Workspace.getDefaultLogger().debug((Object)"Starting destroy");
            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
            try {
                TreePath[] paths = this.getSelectionPaths();
                Vector<CMetadata> m_allObjects = new Vector<CMetadata>();
                for (int s = 0; s < this.m_lTSSteps.size(); ++s) {
                    CMetadata object = (CMetadata)this.m_lTSSteps.get(s);
                    m_allObjects.add(object);
                }
                for (int i = 0; i < paths.length; ++i) {
                    TreePath path = paths[i];
                    WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                    CMetadata undoObject = node.getMetadata();
                    if (((Root)undoObject).getChangeState() == null || ((Root)undoObject).getChangeState().length() == 0) continue;
                    m_allObjects.add(undoObject);
                }
                CMetadata projectRepos = Workspace.getWorkspace().getProjectRepository();
                ProjectUtil.destroy(m_allObjects, (CMetadata)projectRepos);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                MessageUtil.displayMessage((String)(bundle.getString("Common.ErrorDeletingMetadata.txt") + e.getLocalizedMessage()), (String)bundle.getString("Common.Error.txt"), (int)0);
            }
            finally {
                if (store != null) {
                    store.dispose();
                    store = null;
                }
                this.m_lTSSteps.clear();
            }
            Workspace.getDefaultLogger().debug((Object)"Finished destroy");
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    @Override
    protected JMenu createChangeManagementMenu() {
        JMenu menuChgMgmt = new JMenu((Action)this.m_actChangeManagement);
        menuChgMgmt.add(new JMenuItem((Action)this.m_actUndoCheckout));
        menuChgMgmt.add(new JMenuItem((Action)this.m_actDestroy));
        menuChgMgmt.add(new JMenuItem((Action)this.m_actHistory));
        return menuChgMgmt;
    }

    protected void holdUpdates(boolean bHoldUpdates) {
        this.m_bHoldUpdates = bHoldUpdates;
        if (!bHoldUpdates) {
            this.updateActions();
        }
    }

    @Override
    protected void updateActions() {
        if (WAdminTree_Project.isNewStyleActions()) {
            this.fireSelectionChangedEvent();
        }
        try {
            if (this.m_bHoldUpdates) {
                return;
            }
            boolean bAllData = true;
            boolean bSingleNode = false;
            boolean bAllCheckedOut = true;
            boolean bFetched = false;
            boolean bAllExportable = true;
            boolean bFolderNode = false;
            boolean bRepositoryNode = false;
            boolean bRenameable = false;
            boolean bNoRootFolders = true;
            boolean bCMForClearProject = false;
            WsTreeNode[] aNodes = this.getSelectedNodes();
            int nNodes = aNodes.length;
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                String sType;
                if (nNodes == 1 && aNodes[iNode] instanceof cProjectRepositoryNode) {
                    Workspace.getWorkspace();
                    if (Workspace.getMetadataServerVersionNumber() > 0) {
                        bCMForClearProject = true;
                    }
                }
                if (aNodes[iNode] instanceof InventoryTreeNode) {
                    bAllData = false;
                    bRepositoryNode = true;
                    break;
                }
                CMetadata mdo = aNodes[iNode].getMetadata();
                if (mdo.getChangeManagementState() == 2) {
                    bFetched = true;
                }
                if (!mdo.isCheckedOut()) {
                    bAllCheckedOut = false;
                }
                if ((sType = mdo.getCMetadataType()).equals("Tree")) {
                    bFolderNode = true;
                    if (!(aNodes[iNode] instanceof TreeTreeNode) || !bNoRootFolders) continue;
                    bNoRootFolders = !((TreeTreeNode)aNodes[iNode]).isRootFolder();
                    continue;
                }
                if (aNodes[iNode] instanceof LogicalObjectNode) {
                    LogicalObjectNode node = (LogicalObjectNode)aNodes[iNode];
                    if (node.isExportable()) continue;
                    bAllExportable = false;
                    continue;
                }
                bAllExportable = false;
            }
            if (nNodes == 0) {
                bAllData = false;
            }
            if (nNodes == 1) {
                bSingleNode = true;
                this.setActiveNode(aNodes[0]);
                bRenameable = this.m_nodeActive.isRenameable();
            } else {
                this.setActiveNode(null);
            }
            this.m_actCopy.setEnabled(bAllData && bAllExportable);
            this.m_actExport.setEnabled(bAllData && bAllExportable);
            this.m_actPaste.setEnabled((bFolderNode || bRepositoryNode) && bSingleNode && CopyPasteUtil.isPasteAllowed());
            this.m_actPasteSpecial.setEnabled((bFolderNode || bRepositoryNode) && bSingleNode && CopyPasteUtil.isPasteAllowed());
            this.m_actImport.setEnabled((bFolderNode || bRepositoryNode) && bSingleNode);
            this.m_actRename.setEnabled(bAllData && bSingleNode && bRenameable);
            this.m_actDelete.setEnabled(bAllData);
            this.m_actUndoCheckout.setEnabled(bAllData && bAllCheckedOut);
            this.m_actGroup.setEnabled(bAllData && !bFetched && bNoRootFolders);
            this.m_actDestroy.setEnabled(bAllData && bAllCheckedOut);
            this.m_actHistory.setEnabled(bAllData);
            this.m_actClearProject.setEnabled(bCMForClearProject);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public CMetadata findProjectRepository(TreeNode object) {
        WorkspaceTreeModel myModel = this.m_model;
        TreeNode[] treeNodeArray = myModel.getPathToRoot(object);
        CMetadata projectRepository = null;
        for (int i = 0; i < treeNodeArray.length; ++i) {
            if (((WsTreeNode)treeNodeArray[i]).getMetadata() == null) continue;
            try {
                if (((WsTreeNode)treeNodeArray[i]).getMetadata().getFQID().indexOf("A0000001") <= -1) continue;
                projectRepository = ((WsTreeNode)treeNodeArray[i]).getMetadata();
                break;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        return projectRepository;
    }

    public CMetadata getDefaultProjectRepository() throws MdException, RemoteException {
        CMetadata projectRepository = Workspace.getWorkspace().getProjectRepository();
        return projectRepository;
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            Object content;
            Transferable transfer = dtde.getTransferable();
            if (!transfer.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
                Workspace.getDefaultLogger().debug((Object)"No transfer data obtained: wrong flavor");
                dtde.dropComplete(false);
                return;
            }
            try {
                Vector contentVector = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                content = contentVector.get(0);
            }
            catch (Exception ex) {
                Workspace.getDefaultLogger().error((Object)("No transfer data obtained: " + ex.getMessage()));
                ex.printStackTrace();
                dtde.dropComplete(false);
                return;
            }
            CMetadata object = null;
            if (content instanceof CMetadata) {
                object = (CMetadata)content;
                String strType = object.getCMetadataType();
                if (strType.compareTo("PhysicalTable") != 0) {
                    dtde.dropComplete(false);
                    return;
                }
                dtde.dropComplete(false);
                return;
            }
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            dtde.dropComplete(false);
        }
    }

    protected void populateObjects(ArrayList alObjects) {
        try {
            StringBuffer sbXML = new StringBuffer();
            int nObjects = alObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                Root oObject = (Root)alObjects.get(iObject);
                if (oObject != null) {
                    sbXML.append("<");
                    sbXML.append(oObject.getCMetadataType());
                    sbXML.append(" Id=\"");
                    sbXML.append(oObject.getFQID());
                    sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><Trees/>");
                    if (oObject.getCMetadataType().equals("Tree")) {
                        sbXML.append("<ParentTree/>");
                    }
                    sbXML.append("</");
                    sbXML.append(oObject.getCMetadataType());
                    sbXML.append(">");
                    if (oObject.getChangeState() != null && oObject.getChangeState().length() > 0) {
                        sbXML.append("<");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(" Id=\"");
                        String strChangeState = oObject.getChangeState();
                        int index = strChangeState.indexOf(58);
                        String strWarehouseID = strChangeState.substring(index += 2, strChangeState.length());
                        sbXML.append(strWarehouseID);
                        sbXML.append("\" Name=\"\" Desc=\"\" LockedBy = \"\" ChangeState=\"\" ><Trees/>");
                        if (oObject.getCMetadataType().equals("Tree")) {
                            sbXML.append("<ParentTree/>");
                        }
                        sbXML.append("</");
                        sbXML.append(oObject.getCMetadataType());
                        sbXML.append(">");
                    }
                }
                try {
                    Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)Workspace.getMdFactory().getStore(), sbXML.toString(), "", 256);
                    continue;
                }
                catch (MdException eMeta) {
                    eMeta.printStackTrace();
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    @Override
    protected WorkspaceTreeModel createModel(WsTreeNode nodeRoot) {
        return new cProjectTreeModel(nodeRoot);
    }

    public boolean areNodesReallyDestroyable(WsTreeNode[] aNodes) {
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            if (aNodes[iNode].isReallyDestroyable()) continue;
            return false;
        }
        return true;
    }

    public boolean areNodesReallyCMDeleteable(WsTreeNode[] aNodes) {
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            if (aNodes[iNode].isReallyCMDeleteable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onClearProject() {
        int eAnswer;
        if (this.getRowCount() > 1) {
            TreePath[] aPaths = this.getPathBetweenRows(1, this.getRowCount() - 1);
            int nPaths = aPaths == null ? 0 : aPaths.length;
            WsTreeNode[] aNodes = new WsTreeNode[nPaths];
            for (int iPath = 0; iPath < nPaths; ++iPath) {
                aNodes[iPath] = (WsTreeNode)aPaths[iPath].getLastPathComponent();
            }
            if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoClear.Text.fmt")) {
                return;
            }
        }
        if ((eAnswer = MessageUtil.displayMessage((String)bundle.getString("WAdminTree_Project.ClearProjectWarning.txt"), (int)2, (int)0)) == 0) {
            try {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                try {
                    String str1 = bundle.getString("ClearProjectProgressIndicator.Msg.Message");
                    String str2 = bundle.getString("ClearProjectProgressIndicator.Msg.Title");
                    OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
                    request.setDelayBeforeProgressCancelDialog(200);
                    Runnable runClearProject = new Runnable(){

                        @Override
                        public void run() {
                            WAdminTree_Project.this.doThreadedClearProject();
                        }
                    };
                    request.execute(runClearProject);
                    Workspace.getDefaultLogger().debug((Object)"Finished waiting on Clear Project");
                }
                catch (Exception ge) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ge);
                    MessageUtil.displayMessage((String)(bundle.getString("WAdminTree_ChangeManagement.ClearProjectError.txt") + " " + ge.getMessage()), (int)0);
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    public class CheckOutAgain
    implements Runnable {
        @Override
        public void run() {
            try {
                CMetadata myObject;
                MdStore store;
                if (WAdminTree_Project.this.checkedInObjects == null) {
                    return;
                }
                if (WAdminTree_Project.this.m_bkeepCheckedOut) {
                    WAdminTree_Project.this.checkoutItems(WAdminTree_Project.this.checkedInObjects);
                }
                if (WAdminTree_Project.this.checkedInObjects.size() > 0 && (store = (myObject = (CMetadata)WAdminTree_Project.this.checkedInObjects.elementAt(0)).getObjectStore()) != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    public class InitializeCheckIn
    implements Runnable {
        @Override
        public void run() {
            Workspace.getDefaultLogger().debug((Object)"Starting checkin");
            try {
                WsTreeNode nodeSelected = WAdminTree_Project.this.getSelectedNode();
                if (nodeSelected instanceof cProjectRepositoryNode) {
                    // empty if block
                }
                CMetadata projectRepos = Workspace.getWorkspace().getDefaultRepository();
                WAdminTree_Project.this.checkedInObjects = ProjectUtil.checkIn((CMetadata)projectRepos, (String)WAdminTree_Project.this.m_changeName, (String)WAdminTree_Project.this.m_changeDesc);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                MessageUtil.displayMessage((String)(bundle.getString("Common.ErrorCheckinginMetadata.txt") + e.getLocalizedMessage()), (String)bundle.getString("Common.Error.txt"), (int)0);
            }
            Workspace.getDefaultLogger().debug((Object)"Finished checkin");
        }
    }

    protected class cProjectTreeModel
    extends WAdminTree_Warehouse.cWarehouseTreeModel {
        private Map m_mapRequiredAttributeNames;

        public cProjectTreeModel(WsTreeNode nodeRoot) {
            super(WAdminTree_Project.this, nodeRoot);
            this.setName("Project");
            this.setNodeFactory(new DefaultInventoryNodeFactory());
        }

        public ArrayList findNodes(WsTreeNode nodeStart, CMetadata oMetadata) {
            try {
                return this.findNodes(nodeStart, oMetadata.getFQID());
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return null;
            }
        }

        public ArrayList findNodesByChangeState(WsTreeNode nodeStart, String sFQID) {
            ArrayList<WsTreeNode> alNodes = new ArrayList<WsTreeNode>();
            Enumeration enumNodes = nodeStart.breadthFirstEnumeration();
            while (enumNodes.hasMoreElements()) {
                WsTreeNode nodeCurr = (WsTreeNode)enumNodes.nextElement();
                String sFQIDCurr = nodeCurr.getFQID();
                if (sFQIDCurr == null) continue;
                try {
                    WsDataTreeNode dataNode = (WsDataTreeNode)nodeCurr;
                    String strChangeState = ((Root)dataNode.getMetadata()).getChangeState();
                    if (strChangeState != null && strChangeState.length() > 0) {
                        int middleIndex = strChangeState.indexOf(":");
                        String strFQIDToFind = strChangeState.substring(middleIndex + 2, strChangeState.length());
                        if (sFQID.compareToIgnoreCase(strFQIDToFind) != 0) continue;
                        alNodes.add(nodeCurr);
                        continue;
                    }
                    alNodes.add(nodeCurr);
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
            return alNodes;
        }

        public void objectsCheckedIn(ArrayList alObjects) {
            WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
            for (int i = 0; i < alObjects.size(); ++i) {
                try {
                    CMetadata object = (CMetadata)alObjects.get(i);
                    ArrayList alNodes = this.findNodesByChangeState(nodeRoot, object.getFQID());
                    int nNodes = alNodes.size();
                    for (int iNode = 0; iNode < nNodes; ++iNode) {
                        this.removeChild((WsTreeNode)alNodes.get(iNode));
                    }
                    continue;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
        }

        public void objectsUndoCheckout(ArrayList alObjects) {
            WAdminTree_Project.this.holdUpdates(true);
            WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
            for (int i = 0; i < alObjects.size(); ++i) {
                try {
                    CMetadata object = (CMetadata)alObjects.get(i);
                    ArrayList alNodes = this.findNodes(nodeRoot, object.getFQID());
                    int nNodes = alNodes.size();
                    for (int iNode = 0; iNode < nNodes; ++iNode) {
                        this.removeChild((WsTreeNode)alNodes.get(iNode));
                    }
                    continue;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
            WAdminTree_Project.this.holdUpdates(false);
        }

        public void objectsClearProject(ArrayList alObjects) {
            WAdminTree_Project.this.holdUpdates(true);
            WsTreeNode nodeRoot = (WsTreeNode)this.getRoot();
            for (int i = 0; i < alObjects.size(); ++i) {
                try {
                    CMetadata object = (CMetadata)alObjects.get(i);
                    ArrayList alNodes = this.findNodes(nodeRoot, object.getFQID());
                    int nNodes = alNodes.size();
                    for (int iNode = 0; iNode < nNodes; ++iNode) {
                        this.removeChild((WsTreeNode)alNodes.get(iNode));
                    }
                    continue;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                }
            }
            WAdminTree_Project.this.holdUpdates(false);
        }

        @Override
        protected void populateUncheckedOutObjects(ArrayList alObjects) {
        }

        @Override
        protected void populateClearedObjects(ArrayList alObjects) {
        }

        public void doObjectsCheckedOut(ArrayList alObjects) {
            this.doObjectsCopied(alObjects);
        }

        public void doObjectsFetched(ArrayList alObjects) {
            this.doObjectsCopied(alObjects);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doObjectsCopied(ArrayList alObjects) {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Project:doObjectsCopied");
                try {
                    this.populateStore(store, alObjects);
                    for (int iObject = 0; iObject < alObjects.size(); ++iObject) {
                        String sFQID;
                        CMetadata oObject = (CMetadata)alObjects.get(iObject);
                        if (oObject == null || !(sFQID = oObject.getFQID()).substring(0, 8).equals(WAdminTree_Project.this.getSelectedProjectRepository().getFQID().substring(9))) continue;
                        Root mdo = (Root)store.getObject(sFQID);
                        this.createNodesFor((WsTreeNode)this.getRoot(), (CMetadata)mdo);
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        public void objectsCreated(MdEvent e, List lFQIDs) {
            try {
                ArrayList alObjects = this.getObjects(lFQIDs);
                this.populateObjects(alObjects);
                CMetadata projectRepository = WAdminTree_Project.this.getSelectedProjectRepository();
                int nObjects = alObjects.size();
                for (int iObject = 0; iObject < nObjects; ++iObject) {
                    CMetadata oObject = (CMetadata)alObjects.get(iObject);
                    if (oObject == null || !projectRepository.getFQID().substring(9).equals(oObject.getFQID().substring(0, 8))) continue;
                    this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
        }

        protected boolean isValidNewObject(CMetadata mdoObject) {
            try {
                return WAdminTree_Project.this.getSelectedProjectRepository().getFQID().substring(9).equals(mdoObject.getFQID().substring(0, 8));
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectsModified(List alObjects) {
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ProjectTree:objectsModified");
                try {
                    this.populateStore(store, alObjects);
                    ArrayList<CMetadata> lObjectsInStore = new ArrayList<CMetadata>(alObjects.size());
                    for (int iObject = 0; iObject < alObjects.size(); ++iObject) {
                        Root mdo = (Root)alObjects.get(iObject);
                        lObjectsInStore.add(store.getObject(mdo.getFQID()));
                    }
                    this.handleObjectsModified(lObjectsInStore);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        protected void handleObjectsModified(List alObjects) {
            try {
                int nObjects = alObjects.size();
                for (int iObject = 0; iObject < nObjects; ++iObject) {
                    CMetadata oObject = (CMetadata)alObjects.get(iObject);
                    if (oObject == null) continue;
                    ArrayList alNodes = this.findNodes(oObject);
                    int nNodes = alNodes.size();
                    for (int iNode = 0; iNode < nNodes; ++iNode) {
                        WsTreeNode nodeObject = (WsTreeNode)alNodes.get(iNode);
                        WsTreeNode nodeParent = (WsTreeNode)nodeObject.getParent();
                        if (((Root)oObject).getChangeState() != null && ((Root)oObject).getChangeState().length() > 0) {
                            nodeObject.updateMetadata(oObject);
                            continue;
                        }
                        if (!nodeParent.isValidParentFor(oObject)) {
                            this.removeChild(nodeObject);
                            this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
                            continue;
                        }
                        nodeObject.updateMetadata(oObject);
                    }
                    if (nNodes != 0) continue;
                    this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }

        protected void handleObjectsCleared(List alObjects) {
            int nObjects = alObjects.size();
            for (int iObject = 0; iObject < nObjects; ++iObject) {
                CMetadata oObject = (CMetadata)alObjects.get(iObject);
                if (oObject == null) continue;
                ArrayList alNodes = this.findNodes(oObject);
                int nNodes = alNodes.size();
                for (int iNode = 0; iNode < nNodes; ++iNode) {
                    try {
                        WsTreeNode nodeObject = (WsTreeNode)alNodes.get(iNode);
                        WsTreeNode nodeParent = (WsTreeNode)nodeObject.getParent();
                        if (((Root)oObject).getChangeState() != null && ((Root)oObject).getChangeState().length() > 0) {
                            nodeObject.updateMetadata(oObject);
                            continue;
                        }
                        if (!nodeParent.isValidParentFor(oObject)) {
                            this.removeChild(nodeObject);
                            this.createNodesFor((WsTreeNode)this.getRoot(), oObject);
                            continue;
                        }
                        nodeObject.updateMetadata(oObject);
                        continue;
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                    }
                }
            }
        }

        private void populateStore(MdObjectStore store, List lObjects) throws MdException, RemoteException {
            StringBuffer sbXML = new StringBuffer();
            int fFlags = 256;
            for (int iObject = 0; iObject < lObjects.size(); ++iObject) {
                Root mdo = (Root)lObjects.get(iObject);
                if (mdo == null) continue;
                String sType = mdo.getCMetadataType();
                sbXML.append("<");
                sbXML.append(sType);
                sbXML.append(" Id=\"");
                sbXML.append(mdo.getFQID());
                sbXML.append("\" Name=\"\" ChangeState=\"\" LockedBy = \"\" PublicType=\"\" >");
                sbXML.append("</");
                sbXML.append(sType);
                sbXML.append(">");
            }
            Workspace.getMdFactory().getOMIUtil().getMetadataObjects((MdStore)store, sbXML.toString(), "", fFlags);
        }
    }

    protected class cCheckinAction
    extends WsAbstractAction {
        public cCheckinAction() {
            super(bundle, "Tree.ChangeManagement.Checkin");
            this.setMenuSupportId("checkin");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_Project.this.onCheckin();
        }
    }

    protected class cNewObjectAction
    extends WsAbstractAction {
        public cNewObjectAction() {
            super(bundle, "Tree.PopupMenu.NewObject");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_Project.this.onNewObject();
        }
    }

    protected class cAddToProjectAction
    extends WsAbstractAction {
        public cAddToProjectAction() {
            super(bundle, "Tree.ChangeManagement.AddToProject");
            this.setMenuSupportId("addtoproject");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_Project.this.onAdd();
        }
    }

    protected class cDestroyAction
    extends WsAbstractAction {
        public cDestroyAction() {
            super(bundle, "Tree.ChangeManagement.Destroy");
            this.setMenuSupportId("destroy");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_Project.this.onDestroy();
        }
    }

    protected class cProjectTreeCellRenderer
    extends WorkspaceTree.cTreeCellRenderer {
        protected Icon m_iconNew;
        protected Icon m_iconRoot;

        public cProjectTreeCellRenderer() {
            super((WorkspaceTree)WAdminTree_Project.this);
            this.m_iconNew = bundle.getImageIcon("Common.CheckoutNew.image");
            this.m_iconRoot = bundle.getImageIcon("WAdminTree_Project.Root.image");
        }

        protected Icon getNodeIcon(WsTreeNode node) {
            CMetadata oData;
            Icon icon = node.getIcon();
            if (icon == null) {
                icon = node.isLeaf() ? this.m_iconLeaf : (node.isExpanded() ? this.m_iconOpen : this.m_iconClosed);
            }
            if ((oData = node.getMetadata()) == null) {
                icon = this.createCompoundIcon(this.m_iconEmptyFiller, icon);
                return icon;
            }
            try {
                int iState = ((Root)oData).getChangeManagementState();
                icon = iState == 1 ? this.createCompoundIcon(this.m_iconCheckedOut, icon) : (iState == 2 ? this.createCompoundIcon(this.m_iconFetched, icon) : (iState == 3 ? this.createCompoundIcon(this.m_iconNew, icon) : this.createCompoundIcon(this.m_iconEmptyFiller, icon)));
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            return icon;
        }
    }

    protected class cProjectRepositoryNode
    extends MultiInventoryTreeNode {
        protected WsAbstractAction m_actAddToProject;
        protected WsAbstractAction m_actCheckin;
        protected WsAbstractAction m_actNewObject;

        public cProjectRepositoryNode(CMetadata oMetadata) {
            super("", "");
            try {
                this.setName(oMetadata.getName());
                this.setRepositoryFQID(oMetadata.getFQID());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.addType("Cube", null);
            this.addType("Report", null);
            this.addType("ServerContext", null);
            this.addType("Tree", null);
            try {
                TypeInterface[] aTypes = Factory.getInstance().getTypesSupported();
                for (int iType = 0; iType < aTypes.length; ++iType) {
                    this.addType(aTypes[iType]);
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            this.setIsEditable(false);
            this.setIcon(bundle.getImageIcon("WAdminTree_Project.Root.image"));
            this.m_actAddToProject = new cAddToProjectAction();
            this.m_actCheckin = new cCheckinAction();
            this.m_actNewObject = new cNewObjectAction();
        }

        @Override
        public void updateWorkspaceUIComponents(boolean bActive) {
            this.m_actAddToProject.setActive(bActive);
            this.m_actCheckin.setActive(bActive);
            this.m_actNewObject.setActive(bActive);
        }

        @Override
        public JPopupMenu getPopupMenu(WAdminResource mBundle) {
            JPopupMenu menuPopup = new JPopupMenu();
            menuPopup.add(new JMenuItem((Action)this.m_actAddToProject));
            menuPopup.add(new JMenuItem((Action)this.m_actCheckin));
            menuPopup.add(new JMenuItem((Action)this.m_actNewObject));
            if (Workspace.getMetadataServerVersionNumber() > 0) {
                menuPopup.add(new JMenuItem((Action)WAdminTree_Project.this.m_actClearProject));
            }
            return menuPopup;
        }
    }

    protected class cProjectSelectionListener
    extends WorkspaceTree.cSelectListener {
        protected cProjectSelectionListener() {
            super((WorkspaceTree)WAdminTree_Project.this);
        }

        public void valueChanged(TreeSelectionEvent e) {
            WAdminTree_Project.this.updateActions();
        }
    }
}

