/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.CopyListListener;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.promotion.visuals.ExportWizard;
import com.sas.metadata.promotion.visuals.ImportWizard;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginPropertiesView;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.ProcessLibFolderNode;
import com.sas.wadmin.visuals.ProcessLibTransformNode;
import com.sas.wadmin.visuals.ProcessTreeModel;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.GeneratedTransformationUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WAdminTree_Process
extends WorkspaceTree
implements WsSelectionProvider {
    private static WAdminResource bundle = WAdminResource.getBundle(WAdminTree_Process.class);
    protected WsAbstractAction m_actProperties;
    protected WsAbstractAction m_actImpact;
    private CopyListListener m_copyListListener;

    public void initialize() {
        try {
            new JFileChooser();
        }
        catch (Exception ex) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
        }
        ProcessTreeModel model = new ProcessTreeModel();
        this.setModel((TreeModel)((Object)model));
        this.setSelectionPath(new TreePath(model.getRoot()));
    }

    protected void createListeners() {
        super.createListeners();
        this.m_copyListListener = this.createCopyListListener();
        CopyPasteUtil.addCopyListListener((CopyListListener)this.m_copyListListener);
    }

    public void dispose() {
        CopyPasteUtil.removeCopyListListener((CopyListListener)this.m_copyListListener);
        super.dispose();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actProperties.setActive(bActive);
        this.m_actImpact.setActive(bActive);
    }

    protected DragGestureListener createDragGestureListener() {
        return new cProcessDragGestureListener();
    }

    protected CopyListListener createCopyListListener() {
        return new cCopyListListener();
    }

    protected void addPopupMenuItems(JPopupMenu menuPopup, WsTreeNode[] aNodes) {
        TransformInterface transform;
        super.addPopupMenuItems(menuPopup, aNodes);
        if (aNodes.length == 0) {
            return;
        }
        WsTreeNode nodeCurrent = this.getSelectedNode();
        if (nodeCurrent != null && nodeCurrent instanceof ProcessLibTransformNode && (transform = ((ProcessLibTransformNode)nodeCurrent).getTransformationObject()) instanceof MacroPlugin) {
            menuPopup.add((Component)new JMenuItem((Action)this.m_actProperties), 0);
            menuPopup.add((Component)new JMenuItem((Action)this.m_actImpact), 1);
            menuPopup.add((Component)new JSeparator(), 2);
        }
    }

    protected void createActions() {
        super.createActions();
        this.m_actProperties = this.createPropertiesAction();
        this.m_actImpact = this.createImpactAction();
    }

    protected WsAbstractAction createPropertiesAction() {
        return new cPropertiesAction();
    }

    protected WsAbstractAction createImpactAction() {
        return new cImpactAction();
    }

    protected void updateActions() {
        this.fireSelectionChangedEvent();
        boolean bGeneratedTransformation = false;
        boolean bFolderNode = false;
        boolean bEditable = false;
        WsTreeNode[] aNodes = this.getSelectedNodes();
        if (aNodes.length == 1 && aNodes[0] instanceof ProcessLibTransformNode && ((ProcessLibTransformNode)aNodes[0]).getTransformationObject() instanceof MacroPlugin) {
            bGeneratedTransformation = true;
            boolean bl = bEditable = bGeneratedTransformation && Workspace.getWorkspace().isObjectEditable(((MacroPlugin)((ProcessLibTransformNode)aNodes[0]).getTransformationObject()).getMetadata());
        }
        if (aNodes.length == 1 && !(aNodes[0] instanceof ProcessLibTransformNode)) {
            bFolderNode = true;
        }
        if (aNodes.length == 1) {
            this.setActiveNode(aNodes[0]);
        } else {
            this.setActiveNode(null);
        }
        this.m_actProperties.setEnabled(bGeneratedTransformation);
        this.m_actImpact.setEnabled(bGeneratedTransformation);
        this.m_actCopy.setEnabled(bGeneratedTransformation);
        this.m_actPaste.setEnabled(bFolderNode && this.isPasteAllowed());
        this.m_actPasteSpecial.setEnabled(bFolderNode && this.isPasteAllowed());
        this.m_actRename.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable);
        this.m_actExport.setEnabled(bGeneratedTransformation);
        this.m_actImport.setEnabled(bFolderNode);
    }

    private boolean isPasteAllowed() {
        if (!CopyPasteUtil.isPasteAllowed()) {
            return false;
        }
        List lCopyItems = CopyPasteUtil.getCopyList();
        for (SimpleLogicalObjectInterface logicalObject : lCopyItems) {
            if ("GeneratedTransform".equals(logicalObject.getTypeInterface().getPublicType())) continue;
            return false;
        }
        return true;
    }

    public Object[] getSelectedObjects() {
        WsTreeNode[] aNodes = this.getSelectedNodes();
        ArrayList<TransformInterface> lObjects = new ArrayList<TransformInterface>(aNodes.length);
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            if (!(aNodes[iNode] instanceof ProcessLibTransformNode)) continue;
            lObjects.add(((ProcessLibTransformNode)aNodes[iNode]).getTransformationObject());
        }
        return lObjects.toArray();
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    protected void fireSelectionChangedEvent() {
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    public void refresh() {
        TransformManager.getInstance().loadGeneratedTransformations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCopy() {
        try {
            WsTreeNode[] aNodes = this.getSelectedNodes();
            SimpleLogicalObjectInterface[] aData = new SimpleLogicalObjectInterface[aNodes.length];
            MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:onCopy");
            try {
                for (int iNode = 0; iNode < aNodes.length; ++iNode) {
                    TransformInterface transformInterface;
                    WsTreeNode treeNode = aNodes[iNode];
                    if (!(treeNode instanceof ProcessLibTransformNode) || !((transformInterface = ((ProcessLibTransformNode)treeNode).getTransformationObject()) instanceof MacroPlugin)) {
                        return;
                    }
                    CMetadata mdObject = ((MacroPlugin)transformInterface).getPrototype();
                    String sTemplate = "<Templates><Prototype Name=\"\" MetadataType=\"\"><Properties/></Prototype><Property PropertyName=\"\"><StoredConfiguration/></Property><TextStore StoredText=\"\"/></Templates>";
                    int iOptions = 260;
                    Prototype mdPrototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, mdObject.getCMetadataType(), mdObject.getFQID(), null, null, sTemplate, iOptions);
                    aData[iNode] = Factory.getInstance().getObject((Root)mdPrototype);
                }
                CopyPasteUtil.copy((SimpleLogicalObjectInterface[])aData);
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (LogicalTypeException lte) {
                lte.printStackTrace();
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaste() {
        try {
            WsTreeNode treeNode = this.getSelectedNode();
            MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:onPaste");
            try {
                String sTargetReposID;
                String sParentReposID;
                if (Workspace.getWorkspace().isChangeManagementOn()) {
                    sParentReposID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                    sTargetReposID = Workspace.getWorkspace().getProjectRepository().getFQID();
                } else {
                    sTargetReposID = sParentReposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                }
                Tree mdFolder = CustomTreeModel.getUserTransformsFolder(sParentReposID, mdStore);
                CopyPasteUtil.paste((FolderInterface)((FolderInterface)Factory.getInstance().getObject((Root)mdFolder)), (TypeInterface[])Factory.getInstance().getTypesSupported(), (String)sTargetReposID);
                if (CopyPasteUtil.objectsWerePasted()) {
                    String sNewPath = this.getPathName(treeNode);
                    this.updateTransformationPaths(CopyPasteUtil.getObjectsPasted(), sNewPath);
                }
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (LogicalTypeException lte) {
                lte.printStackTrace();
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPasteSpecial() {
        try {
            WsTreeNode treeNode = this.getSelectedNode();
            MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:onPasteSpecial");
            try {
                String sTargetReposID;
                String sParentReposID;
                if (Workspace.getWorkspace().isChangeManagementOn()) {
                    sParentReposID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                    sTargetReposID = Workspace.getWorkspace().getProjectRepository().getFQID();
                } else {
                    sTargetReposID = sParentReposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                }
                Tree mdFolder = CustomTreeModel.getUserTransformsFolder(sParentReposID, mdStore);
                CopyPasteUtil.pasteSpecial((FolderInterface)((FolderInterface)Factory.getInstance().getObject((Root)mdFolder)), (TypeInterface[])Factory.getInstance().getTypesSupported(), (String)sTargetReposID);
                if (CopyPasteUtil.objectsWerePasted()) {
                    String sNewPath = this.getPathName(treeNode);
                    this.updateTransformationPaths(CopyPasteUtil.getObjectsPasted(), sNewPath);
                }
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (LogicalTypeException lte) {
                lte.printStackTrace();
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExport() {
        try {
            WsTreeNode[] aNodes = this.getSelectedNodes();
            SimpleLogicalObjectInterface[] aData = new SimpleLogicalObjectInterface[aNodes.length];
            MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:onExport");
            try {
                for (int iNode = 0; iNode < aNodes.length; ++iNode) {
                    TransformInterface transformInterface;
                    WsTreeNode treeNode = aNodes[iNode];
                    if (!(treeNode instanceof ProcessLibTransformNode) || !((transformInterface = ((ProcessLibTransformNode)treeNode).getTransformationObject()) instanceof MacroPlugin)) {
                        return;
                    }
                    CMetadata mdObject = ((MacroPlugin)transformInterface).getPrototype();
                    String sTemplate = "<Templates><Prototype Name=\"\" MetadataType=\"\"><Properties/></Prototype><Property PropertyName=\"\"><StoredConfiguration/></Property><TextStore StoredText=\"\"/></Templates>";
                    int iOptions = 260;
                    Prototype mdPrototype = (Prototype)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, mdObject.getCMetadataType(), mdObject.getFQID(), null, null, sTemplate, iOptions);
                    aData[iNode] = Factory.getInstance().getObject((Root)mdPrototype);
                }
                ExportWizard wizard = new ExportWizard(aData, Factory.getInstance().getTypesSupported(), bundle.getString("WAdminTree_ChangeManagement.ExportWizardTitle.txt"));
                wizard.show();
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (LogicalTypeException lte) {
                lte.printStackTrace();
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImport() {
        try {
            WsTreeNode treeNode = this.getSelectedNode();
            MdObjectStore mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:onImport");
            try {
                String sReposID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getCheckinRepository().getFQID() : Workspace.getWorkspace().getDefaultRepository().getFQID();
                Tree mdFolder = CustomTreeModel.getUserTransformsFolder(sReposID, mdStore);
                ImportWizard wizard = new ImportWizard(mdFolder, Factory.getInstance().getTypesSupported(), bundle.getString("WAdminTree_ChangeManagement.ImportWizardTitle.txt"));
                if (Workspace.getWorkspace().isChangeManagementOn()) {
                    wizard.changeRepositoryID(Workspace.getWorkspace().getProjectRepository().getFQID());
                }
                wizard.show();
                if (wizard.objectsWereImported()) {
                    String sNewPath = this.getPathName(treeNode);
                    this.updateTransformationPaths(wizard.getTargetObjectIDs(), sNewPath);
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    private String getPathName(WsTreeNode node) {
        if (node instanceof ProcessLibTransformNode) {
            node = (WsTreeNode)node.getParent();
        }
        StringBuffer sbPath = new StringBuffer();
        while (node instanceof ProcessLibFolderNode) {
            sbPath.insert(0, node.getName());
            sbPath.insert(0, '.');
            node = (WsTreeNode)node.getParent();
        }
        if (sbPath.length() > 0) {
            sbPath.deleteCharAt(0);
        }
        return sbPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransformationPaths(Map mapObjects, String sNewPath) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_Process:updateTransformationPaths");
        try {
            ArrayList lObjectIDs = new ArrayList(mapObjects.keySet());
            for (String sFQID : lObjectIDs) {
                String sType = (String)mapObjects.get(sFQID);
                if (sType != "Prototype") continue;
                Root transform = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, null, sType, sFQID);
                GeneratedTransformationUtilities.setProcessTreePath((Root)transform, (String)sNewPath);
            }
            store.updatedMetadataAll();
            Workspace.getMdFactory().getStore().fireMdObjectsModified(new MdEvent((Object)this), lObjectIDs);
        }
        finally {
            store.dispose();
        }
    }

    public void onDelete() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        WsTreeNode[] aNodes = this.getSelectedNodes();
        StringBuffer sNames = new StringBuffer();
        if (aNodes.length == 1) {
            sNames.append(aNodes[0].getName());
        } else {
            int iNode;
            int nNodes = aNodes.length;
            for (iNode = 0; iNode < nNodes - 1; ++iNode) {
                sNames.append(aNodes[iNode].getName());
                sNames.append(", ");
            }
            sNames.append(bundle.getString("Common.and.txt"));
            sNames.append(" ");
            sNames.append(aNodes[iNode].getName());
        }
        int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("Process.ConfirmDelete.Text.txt", (Object)sNames), (String)bundle.getString("Common.ConfirmDelete.Title.txt"), (int)2, (int)0);
        if (eAnswer == 0) {
            TreePath path = paths[0];
            WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
            CMetadata metadataObject = node.getMetadata();
            try {
                String sRemoveTemplate = bundle.getString("RemoveTemplate.PROTOTYPE.notrans");
                if (sRemoveTemplate == null) {
                    Workspace.getMdFactory().deleteMetadataObject(metadataObject);
                } else {
                    Workspace.getMdFactory().deleteMetadataObjects(metadataObject, sRemoveTemplate);
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Deleting");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void showImpactAnalysis(TransformInterface myTransform, Prototype oDetail, boolean bForward) {
        this.showImpactAnalysis(oDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void showImpactAnalysis(Prototype mdoTransform) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            view = this.findImpactAnalysisView(mdoTransform);
            if (view == null) ** GOTO lbl12
            try {
                mdoTransform.getObjectStore().dispose();
                WsViewFactory.showExistingView((WsOMAView)view);
                return;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
lbl12:
                // 2 sources

                view = new ImpactAnalysisOMAView(mdoTransform);
                WsViewFactory.attachViewToFrame((CMetadata)mdoTransform, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)mdoTransform, ""));
            }
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(Prototype oPrototype) {
        try {
            ArrayList lViews = oPrototype.getViewList();
            int nViews = lViews.size();
            for (int iView = 0; iView < nViews; ++iView) {
                if (!lViews.get(iView).getClass().equals(ImpactAnalysisOMAView.class)) continue;
                ImpactAnalysisOMAView view = (ImpactAnalysisOMAView)((Object)lViews.get(iView));
                return view;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return null;
    }

    protected TreeSelectionListener createSelectionListener() {
        return new cProcessSelectionListener();
    }

    private class cCopyListListener
    implements CopyListListener {
        private cCopyListListener() {
        }

        public void copyListChanged() {
            WAdminTree_Process.this.updateActions();
        }
    }

    protected class cProcessSelectionListener
    extends WorkspaceTree.cSelectListener {
        protected cProcessSelectionListener() {
            super((WorkspaceTree)WAdminTree_Process.this);
        }

        public void valueChanged(TreeSelectionEvent e) {
            WAdminTree_Process.this.updateActions();
        }
    }

    protected class cProcessDragGestureListener
    implements DragGestureListener {
        protected cProcessDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            try {
                WsTreeNode nodeCurrent = WAdminTree_Process.this.getSelectedNode();
                if (nodeCurrent != null && nodeCurrent instanceof ProcessLibTransformNode) {
                    DNDObject process = new DNDObject();
                    TransformInterface myTransform = ((ProcessLibTransformNode)nodeCurrent).getTransformationObject();
                    if (myTransform instanceof MacroPlugin) {
                        process.add((Object)((MacroPlugin)myTransform).getPrototype());
                    } else {
                        process.add((Object)myTransform);
                    }
                    WAdminTree_Process.this.m_dragSource.startDrag(event, null, (Transferable)process, WAdminTree_Process.this.createDragSourceListener());
                }
            }
            catch (InvalidDnDOperationException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected class cImpactAction
    extends WsAbstractAction {
        public cImpactAction() {
            super(bundle, "Tree.PopupMenu.Impact", true);
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            TransformInterface myTransform;
            WsTreeNode nodeCurrent = WAdminTree_Process.this.getSelectedNode();
            if (nodeCurrent != null && nodeCurrent instanceof ProcessLibTransformNode && (myTransform = ((ProcessLibTransformNode)nodeCurrent).getTransformationObject()) instanceof MacroPlugin) {
                try {
                    MacroPlugin plugin = (MacroPlugin)myTransform;
                    CMetadata proto = plugin.getPrototype();
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                    Prototype prototype = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, proto);
                    WAdminTree_Process.this.showImpactAnalysis(myTransform, prototype, true);
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
            }
        }
    }

    protected class cPropertiesAction
    extends WsAbstractAction {
        public cPropertiesAction() {
            super(bundle, "Tree.PopupMenu.Properties", true);
            this.setMenuSupportId("properties");
        }

        public void actionPerformed(ActionEvent e) {
            TransformInterface myTransform;
            WsTreeNode nodeCurrent = WAdminTree_Process.this.getSelectedNode();
            if (nodeCurrent != null && nodeCurrent instanceof ProcessLibTransformNode && (myTransform = ((ProcessLibTransformNode)nodeCurrent).getTransformationObject()) instanceof MacroPlugin) {
                MacroPlugin plugin = (MacroPlugin)myTransform;
                boolean fIsUsed = false;
                CMetadata simplePrototype = plugin.getPrototype();
                try {
                    MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                    Prototype proto = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, simplePrototype);
                    if (MacroPluginUtilities.isGeneratedTransform((Root)proto) && (fIsUsed = MacroPluginUtilities.isPrototypeUsedInJobs(proto))) {
                        MessageUtil.displayMessage((String)bundle.getString("UsedPlugin.txt"), (int)2);
                    }
                    store.dispose();
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
                WsOMAView view = WsViewFactory.showView((CMetadata)plugin.getPrototype(), MacroPluginPropertiesView.class);
                if (fIsUsed) {
                    view.getFrame().setEditable(false);
                }
            }
        }
    }
}

