/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.CopyListListener;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.promotion.visuals.ExportWizard;
import com.sas.metadata.promotion.visuals.ImportWizard;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.model.tree.CustomTreeModel;
import com.sas.wadmin.model.tree.DefaultInventoryRepositoryFolderNode;
import com.sas.wadmin.model.tree.DefaultRepositoryFolderNode;
import com.sas.wadmin.model.tree.FolderNode;
import com.sas.wadmin.model.tree.InventoryFolderNode;
import com.sas.wadmin.model.tree.LogicalObjectNode;
import com.sas.wadmin.visuals.ChangeHistoryView;
import com.sas.wadmin.visuals.ClearProjectDialog;
import com.sas.wadmin.visuals.OperationUIAdapter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.ProjectUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractOperation;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.WsRepositoryUtil;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.WsMetadataChangeManagementUtil;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.GroupSelectorDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WAdminTree_ChangeManagement
extends WorkspaceTree
implements WsSelectionProvider {
    private static final WAdminResource bundle = WAdminResource.getBundle(WAdminTree_ChangeManagement.class);
    private static boolean s_bNewStyleActions;
    protected WsAbstractAction m_actCopyObject;
    protected WsAbstractAction m_actChangeManagement;
    protected WsAbstractAction m_actCheckout;
    protected WsAbstractAction m_actUndoCheckout;
    protected WsAbstractAction m_actFetch;
    protected WsAbstractAction m_actClearProject;
    protected WsAbstractAction m_actHistory;
    protected WsAbstractAction m_actGroup;
    private CopyListListener m_copyListListener;
    protected Group m_topGroup;
    protected Vector m_objectArray = new Vector();
    protected CMetadata m_projectRepository;
    protected String m_sClearRepositoryID1 = null;
    protected boolean m_bisDeletedRepos = false;
    protected MdObjectStore m_store;

    public static void setNewStyleActions(boolean bNewStyleActions) {
        s_bNewStyleActions = bNewStyleActions;
    }

    public static boolean isNewStyleActions() {
        return s_bNewStyleActions;
    }

    public WAdminTree_ChangeManagement() {
        this.setShowCheckout(true);
    }

    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    protected void fireSelectionChangedEvent() {
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent((WsSelectionProvider)this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    public Object[] getSelectedObjects() {
        WsTreeNode[] aNodes = this.getSelectedNodes();
        ArrayList<SimpleObjectImpl> lObjects = new ArrayList<SimpleObjectImpl>(aNodes.length);
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            if (!(aNodes[iNode] instanceof LogicalObjectNode)) continue;
            LogicalObjectInterface object = ((LogicalObjectNode)aNodes[iNode]).getLogicalObject();
            String sType = object.getTypeInterface().getPublicType();
            String sMetadataType = object.getTypeInterface().getMetadataType();
            String sName = object.getName();
            String sFQID = object.getID();
            lObjects.add(new SimpleObjectImpl(sName, sFQID, sMetadataType, sType));
        }
        return lObjects.toArray();
    }

    protected void dontListenToCopyList() {
        CopyPasteUtil.removeCopyListListener((CopyListListener)this.m_copyListListener);
    }

    protected void createListeners() {
        super.createListeners();
        this.m_copyListListener = this.createCopyListListener();
        CopyPasteUtil.addCopyListListener((CopyListListener)this.m_copyListListener);
    }

    public void dispose() {
        CopyPasteUtil.removeCopyListListener((CopyListListener)this.m_copyListListener);
        super.dispose();
    }

    protected void addPopupMenuItems(JPopupMenu menuPopup, WsTreeNode[] aNodes) {
        this.addLogicalObjectPopupMenuItems(menuPopup, aNodes);
        super.addPopupMenuItems(menuPopup, aNodes);
        if (aNodes.length == 0) {
            return;
        }
        int iInsert = menuPopup.getComponentCount() - 5;
        menuPopup.add((Component)new JMenuItem((Action)this.m_actGroup), iInsert);
        iInsert = menuPopup.getComponentCount() - 2;
        JMenu menuChgMgmt = this.createChangeManagementMenu();
        if (aNodes.length == 1 && Workspace.getMetadataServerVersionNumber() > 0) {
            try {
                CMetadata oData = aNodes[0].getMetadata();
                if (oData != null && oData.getCMetadataType().equals("Environment") && WsRepositoryUtil.isChangeManagedRepository((String)oData.getFQID()) && oData.getFQID().equals(Workspace.getWorkspace().getDefaultRepository().getFQID())) {
                    menuChgMgmt.add(new JMenuItem((Action)this.m_actClearProject));
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        if ((iInsert = menuPopup.getComponentCount() - 2) > 0) {
            menuPopup.add((Component)new JSeparator(), iInsert++);
        } else {
            iInsert = 0;
        }
        menuPopup.add((Component)menuChgMgmt, iInsert);
    }

    private void addLogicalObjectPopupMenuItems(JPopupMenu menuPopup, WsTreeNode[] aNodes) {
        if (aNodes.length == 0) {
            return;
        }
        boolean bAllLogicalObjects = true;
        LogicalObjectInterface[] aLOBs = new LogicalObjectInterface[aNodes.length];
        for (int iNode = 0; iNode < aNodes.length; ++iNode) {
            if (!(aNodes[iNode] instanceof LogicalObjectNode)) {
                bAllLogicalObjects = false;
                break;
            }
            aLOBs[iNode] = ((LogicalObjectNode)aNodes[iNode]).getLogicalObject();
        }
        if (bAllLogicalObjects) {
            try {
                TypeInterface[] aTypes = Factory.getInstance().getTypesSupported();
                for (int iType = 0; iType < aTypes.length; ++iType) {
                    Action[] aActions;
                    ObjectFactoryInterface factory = aTypes[iType].getObjectFactory();
                    Action[] actionArray = aActions = aLOBs.length == 1 ? factory.getActions(aLOBs[0], null, null) : factory.getActions(aLOBs, null, null);
                    if (aActions == null || aActions.length <= 0) continue;
                    if (menuPopup.getComponentCount() > 0) {
                        menuPopup.addSeparator();
                    }
                    for (int iAction = 0; iAction < aActions.length; ++iAction) {
                        if (aActions[iAction] == null) {
                            menuPopup.addSeparator();
                            continue;
                        }
                        menuPopup.add(aActions[iAction]);
                    }
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    protected JMenu createChangeManagementMenu() {
        JMenu menuChgMgmt = new JMenu((Action)this.m_actChangeManagement);
        menuChgMgmt.add(new JMenuItem((Action)this.m_actCheckout));
        menuChgMgmt.add(new JMenuItem((Action)this.m_actFetch));
        menuChgMgmt.add(new JMenuItem((Action)this.m_actHistory));
        return menuChgMgmt;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actCopyObject.setActive(bActive);
        this.m_actCheckout.setActive(bActive);
        this.m_actUndoCheckout.setActive(bActive);
        this.m_actFetch.setActive(bActive);
        this.m_actHistory.setActive(bActive);
        this.m_actGroup.setActive(bActive);
        this.m_actClearProject.setActive(bActive);
    }

    protected void updateActions() {
        if (WAdminTree_ChangeManagement.isNewStyleActions()) {
            this.fireSelectionChangedEvent();
        }
        try {
            Workspace.getWorkspace().clearStatusText();
            int eState = Workspace.getWorkspace().getChangeManagementState();
            boolean bAllData = true;
            boolean bAllNotCheckedOut = eState == Workspace.CHANGEMANAGEMENT_ON;
            boolean bFolderNode = false;
            boolean bSingleNode = false;
            boolean bAllDeleteable = this.isEditable();
            boolean bRenameable = false;
            boolean bSameRepository = true;
            boolean bValidRepository = true;
            String sRepository = null;
            boolean bAllFetchable = true;
            boolean bAllCheckOutable = true;
            boolean bAllExportable = true;
            boolean bCMForClearProject = false;
            boolean bRepositoryNode = false;
            boolean bInventoryNode = false;
            boolean bMoveToFolder = true;
            WsTreeNode[] aNodes = this.getSelectedNodes();
            int nNodes = aNodes.length;
            if (this.m_projectRepository == null && eState == Workspace.CHANGEMANAGEMENT_ON) {
                this.m_projectRepository = Workspace.getWorkspace().getProjectRepository();
            }
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                CMetadata oData = aNodes[iNode].getMetadata();
                if (nNodes == 1 && oData != null && oData.getFQID().equals(Workspace.getWorkspace().getDefaultRepository().getFQID()) && Workspace.getMetadataServerVersionNumber() > 0) {
                    bCMForClearProject = true;
                }
                if (oData == null) {
                    if (aNodes[iNode] instanceof InventoryFolderNode) {
                        bInventoryNode = true;
                    }
                    bAllData = false;
                    break;
                }
                if (oData.getCMetadataType().equals("Environment")) {
                    bRepositoryNode = true;
                    bAllData = false;
                    break;
                }
                if (aNodes[iNode] instanceof FolderNode) {
                    bFolderNode = true;
                    FolderInterface folder = ((FolderNode)aNodes[iNode]).getFolder();
                    if (folder.isTopLevel() || folder.isContentMapped()) {
                        bMoveToFolder = false;
                    }
                }
                if (aNodes[iNode] instanceof LogicalObjectNode) {
                    LogicalObjectNode node = (LogicalObjectNode)aNodes[iNode];
                    if (!node.isCheckOutable()) {
                        bAllCheckOutable = false;
                    }
                    if (!node.isFetchable()) {
                        bAllFetchable = false;
                    }
                    if (!node.isExportable()) {
                        bAllExportable = false;
                    }
                } else {
                    bAllExportable = false;
                    bAllCheckOutable = false;
                    bAllFetchable = false;
                }
                if (sRepository == null) {
                    sRepository = oData.getRepositoryID();
                } else if (!sRepository.equals(oData.getRepositoryID())) {
                    bSameRepository = false;
                }
                if (eState == Workspace.CHANGEMANAGEMENT_ON && aNodes[iNode].getMetadata().isCheckedOut()) {
                    bAllNotCheckedOut = false;
                    try {
                        if (bAllFetchable) {
                            String strType = oData.getCMetadataType();
                            String strIDToCheck = oData.getFQID();
                            String strXMLSelect = "<XMLSELECT search=\"*[@ChangeState contains '" + strIDToCheck + "' AND @ChangeState contains 'Checkout']\"/>";
                            List fetchedObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)Workspace.getMdFactory().getStore(), this.m_projectRepository.getFQID(), strType, 392, strXMLSelect);
                            if (fetchedObjects.size() > 0) {
                                bAllFetchable = false;
                            }
                        }
                    }
                    catch (MdException ex) {
                        ex.printStackTrace();
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
                if (aNodes[iNode].isDeleteable()) continue;
                bAllDeleteable = false;
            }
            if (nNodes == 0) {
                bAllData = false;
            }
            if (nNodes == 1) {
                String sName;
                String sLockID;
                this.setActiveNode(aNodes[0]);
                bRenameable = aNodes[0].isRenameable() && this.isEditable();
                bSingleNode = true;
                if (bAllData && aNodes[0].getMetadata().isCheckedOut() && (sLockID = ((Root)aNodes[0].getMetadata()).getLockedBy()) != null && sLockID.length() > 0 && (sName = this.getUserNameOfPersonWhoOwnsObject(sLockID)) != null) {
                    String message = bundle.formatString("WAdminTree_ChangeManagement.UserCheckout.txt", (Object)sName);
                    Workspace.getWorkspace().setStatusText(message);
                }
            } else {
                this.setActiveNode(null);
            }
            if (bSingleNode && eState == Workspace.CHANGEMANAGEMENT_ON) {
                String sReposID = null;
                if (bAllData) {
                    sReposID = aNodes[0].getMetadata().getRepositoryID();
                } else if (aNodes[0] instanceof InventoryFolderNode) {
                    sReposID = ((InventoryFolderNode)aNodes[0]).getRepositoryFQID().substring(9);
                } else if (aNodes[0] instanceof DefaultInventoryRepositoryFolderNode) {
                    sReposID = ((DefaultInventoryRepositoryFolderNode)aNodes[0]).getMetadata().getFQID().substring(9);
                } else if (aNodes[0] instanceof DefaultRepositoryFolderNode) {
                    sReposID = ((DefaultRepositoryFolderNode)aNodes[0]).getRepository().getFQID().substring(9);
                }
                if (sReposID != null && !sReposID.equals(Workspace.getWorkspace().getProjectRepositoryId()) && !sReposID.equals(Workspace.getWorkspace().getCheckinRepositoryId())) {
                    bValidRepository = false;
                }
            }
            this.m_actCopy.setEnabled(bAllData && bAllExportable);
            this.m_actExport.setEnabled(bAllData && bAllExportable || bSingleNode && bRepositoryNode);
            this.m_actPaste.setEnabled((bFolderNode || bRepositoryNode || bInventoryNode) && bSingleNode && bValidRepository && CopyPasteUtil.isPasteAllowed());
            this.m_actPasteSpecial.setEnabled((bFolderNode || bRepositoryNode || bInventoryNode) && bSingleNode && bValidRepository && CopyPasteUtil.isPasteAllowed());
            this.m_actImport.setEnabled((bFolderNode || bRepositoryNode || bInventoryNode) && bSingleNode && bValidRepository);
            this.m_actRename.setEnabled(bAllData && eState == Workspace.CHANGEMANAGEMENT_OFF && bSingleNode && bRenameable);
            this.m_actDelete.setEnabled(bAllData && eState == Workspace.CHANGEMANAGEMENT_OFF && bAllDeleteable);
            this.m_actCheckout.setEnabled(bAllData && eState == Workspace.CHANGEMANAGEMENT_ON && bAllNotCheckedOut && bAllCheckOutable);
            this.m_actFetch.setEnabled(bAllData && eState == Workspace.CHANGEMANAGEMENT_ON && bAllFetchable);
            this.m_actHistory.setEnabled(bAllData && bSingleNode);
            this.m_actGroup.setEnabled(bAllData && bMoveToFolder && eState == Workspace.CHANGEMANAGEMENT_OFF && bSameRepository);
            this.m_actClearProject.setEnabled(bCMForClearProject);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void onCheckout() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        WsTreeNode[] aNodes = this.getSelectedNodes();
        if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoCheckout.Text.fmt")) {
            return;
        }
        String str1 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Message");
        String str2 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Title");
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
        request.setDelayBeforeProgressCancelDialog(200);
        request.execute((Runnable)this.createCheckOutOperation(aNodes, request));
        Workspace.getDefaultLogger().debug((Object)"Finished waiting on checkout");
    }

    private OpRequestUICancellableRunnable createCheckOutOperation(WsTreeNode[] aNodes, OpRequestUI op) {
        return new CheckOutOperation(aNodes, op);
    }

    private OpRequestUICancellableRunnable createFetchOperation(WsTreeNode[] aNodes, OpRequestUI op) {
        return new FetchOperation(aNodes, op);
    }

    public void checkoutItems(Vector items) {
        this.m_objectArray.clear();
        this.m_objectArray = items;
        try {
            String str1 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Message");
            String str2 = bundle.getString("CheckoutMetadataProgressIndicator.Msg.Title");
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            Runnable runCheckout = new Runnable(){

                @Override
                public void run() {
                    WAdminTree_ChangeManagement.this.doThreadedCheckout();
                }
            };
            request.execute(runCheckout);
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on checkout");
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)ge);
            MessageUtil.displayMessage((String)(bundle.getString("WarehouseTree.CheckoutError.txt") + " " + ge.getMessage()), (int)0);
        }
    }

    public void doThreadedCheckout() {
        if (this.m_projectRepository == null) {
            this.m_projectRepository = Workspace.getWorkspace().getProjectRepository();
        }
        try {
            ProjectUtil.checkOutMetadata((List)this.m_objectArray, (CMetadata)this.m_projectRepository);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingout");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"disposing of store");
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Finished checkout");
    }

    public void onUndoCheckout() {
        try {
            this.m_objectArray.clear();
            this.m_store = null;
            TreePath[] paths = this.getSelectionPaths();
            if (paths.length == 0) {
                return;
            }
            this.m_store = Workspace.getMdFactory().createObjectStore();
            for (int i = 0; i < paths.length; ++i) {
                TreePath path = paths[i];
                WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                CMetadata object = node.getMetadata();
                CMetadata detailObject = Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, object);
                this.m_objectArray.add(detailObject);
            }
            try {
                String str1 = bundle.getString("UndoCheckoutMetadataProgressIndicator.Msg.Message");
                String str2 = bundle.getString("UndoCheckoutMetadataProgressIndicator.Msg.Title");
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
                request.setDelayBeforeProgressCancelDialog(200);
                Runnable runUndoCheckout = new Runnable(){

                    @Override
                    public void run() {
                        WAdminTree_ChangeManagement.this.doThreadedUndoCheckout();
                    }
                };
                request.execute(runUndoCheckout);
                Workspace.getDefaultLogger().debug((Object)"Finished waiting on Undocheckout");
            }
            catch (Exception ge) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ge);
                MessageUtil.displayMessage((String)(bundle.getString("WarehouseTree.UndoCheckoutError.txt") + " " + ge.getMessage()), (int)0);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void doThreadedUndoCheckout() {
        if (this.m_projectRepository == null) {
            this.m_projectRepository = Workspace.getWorkspace().getProjectRepository();
        }
        try {
            ProjectUtil.undocheckoutMetadata((List)this.m_objectArray, (CMetadata)this.m_projectRepository);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingout");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"disposing of store");
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Finished checkout");
    }

    public void onCopyObject() {
        this.m_objectArray.clear();
        this.m_store = null;
        TreePath[] paths = this.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
            CMetadata object = node.getMetadata();
            try {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                CMetadata detailObject = Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, object);
                this.m_objectArray.add(detailObject);
                continue;
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        if (this.m_projectRepository == null) {
            this.m_projectRepository = Workspace.getWorkspace().getProjectRepository();
        }
        try {
            String str1 = bundle.getString("CopyMetadataProgressIndicator.Msg.Message");
            String str2 = bundle.getString("CopyMetadataProgressIndicator.Msg.Title");
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            Runnable runCopyObject = new Runnable(){

                @Override
                public void run() {
                    WAdminTree_ChangeManagement.this.doThreadedCopyObject();
                }
            };
            request.execute(runCopyObject);
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on Copy");
        }
        catch (Exception ge) {
            Workspace.getDefaultLogger().debug((Object)("Error encountered while Copying out data " + ge.getMessage()));
        }
    }

    public void doThreadedCopyObject() {
        try {
            ProjectUtil.copyObjects((Vector)this.m_objectArray, (CMetadata)Workspace.getWorkspace().getDefaultRepository());
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"disposing of store");
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Finished copy");
    }

    public void doThreadedClearProject() {
        try {
            if (this.m_bisDeletedRepos) {
                ProjectUtil.clearProject((String)Workspace.getWorkspace().getDefaultRepository().getFQID(), (String)this.m_sClearRepositoryID1);
            } else {
                ProjectUtil.clearProject((String)this.m_sClearRepositoryID1);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"ClearProject");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"disposing of store");
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Finished ClearProject");
    }

    public void onFetch() {
        try {
            TreePath[] paths = this.getSelectionPaths();
            if (paths.length == 0) {
                return;
            }
            WsTreeNode[] aNodes = this.getSelectedNodes();
            if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoFetch.Text.fmt")) {
                return;
            }
            for (int i = 0; i < paths.length; ++i) {
                TreePath path = paths[i];
                WsTreeNode node = (WsTreeNode)path.getLastPathComponent();
                CMetadata object = node.getMetadata();
                String strType = object.getCMetadataType();
                String strIDToFetch = object.getFQID();
                String strXMLSelect = "<XMLSELECT search=\"*[@ChangeState contains '" + strIDToFetch + "' AND @ChangeState contains 'Fetch']\"/>";
                List fetchedObject = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)Workspace.getMdFactory().getStore(), this.m_projectRepository.getFQID(), strType, 392, strXMLSelect);
                if (fetchedObject.size() <= 0) continue;
                MessageUtil.displayMessage((String)bundle.formatString("WAdminTree_ChangeManagement.ObjectAlreadyFetched.Text.fmt", (Object)object.getName()), (int)2);
                return;
            }
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on checkout");
            String str1 = bundle.getString("FetchMetadataProgressIndicator.Msg.Message");
            String str2 = bundle.getString("FetchMetadataProgressIndicator.Msg.Title");
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            request.execute((Runnable)this.createFetchOperation(aNodes, request));
            Workspace.getDefaultLogger().debug((Object)"Finished waiting on fetch");
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void doThreadedFetch() {
        if (this.m_projectRepository == null) {
            this.m_projectRepository = Workspace.getWorkspace().getProjectRepository();
        }
        try {
            ProjectUtil.fetchMetadata((List)this.m_objectArray, (CMetadata)this.m_projectRepository);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Fetching");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        Workspace.getDefaultLogger().debug((Object)"disposing of store");
        if (this.m_store != null) {
            try {
                this.m_store.dispose();
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
        Workspace.getDefaultLogger().debug((Object)"Finished fetch");
    }

    public void onHistory() {
        WsTreeNode node = this.getSelectedNode();
        CMetadata m_oMetadata = node.getMetadata();
        WsViewFactory.showView((CMetadata)m_oMetadata, ChangeHistoryView.class);
    }

    public void onGroup() {
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            WsTreeNode[] selNodes = this.getSelectedNodes();
            GroupSelectorDialog selGrpDlg = new GroupSelectorDialog(selNodes);
            String sReposId = selNodes[0].getMetadata().getRepositoryID();
            if (sReposId.equals(Workspace.getWorkspace().getProjectRepositoryId())) {
                sReposId = Workspace.getWorkspace().getCheckinRepositoryId();
            }
            selGrpDlg.setRepository(sReposId);
            selGrpDlg.setStore((MdStore)store);
            selGrpDlg.show();
            if (selGrpDlg.getReturnValue() == 1) {
                Tree oTree = selGrpDlg.getSelectedTree();
                try {
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
                    for (int i = 0; i < selNodes.length; ++i) {
                        CMetadata metaObject = selNodes[i].getMetadata();
                        Root odetailObject = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, null, metaObject.getName(), metaObject.getCMetadataType(), metaObject.getFQID());
                        CustomTreeModel.moveToFolder(oTree, odetailObject);
                    }
                    store.updatedMetadataAll();
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                Workspace.getWorkspace().setCursor(null);
            }
            if (store != null) {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExport() {
        try {
            Object[] aNodes = this.getSelectedNodes();
            if (aNodes.length > 1) {
                aNodes = VisualsUtil.pruneChildrenFromNodeArray((DefaultMutableTreeNode[])aNodes);
            }
            CMetadata[] aData = WAdminTree_ChangeManagement.getSelectedObjects((TreeNode[])aNodes);
            String sWizardTitle = bundle.getString("WAdminTree_ChangeManagement.ExportWizardTitle.txt");
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_ChangeManagement.onExport");
            try {
                ExportWizard wizard;
                TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
                if (aData.length == 1 && aData[0].getCMetadataType().equals("Tree")) {
                    Tree mdTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, aData[0]);
                    if (mdTree == null) {
                        throw new MdException(bundle.getString("WAdminTree_ChangeManagement.PromotionError.txt"));
                    }
                    wizard = new ExportWizard(mdTree, aSupportedTypes, sWizardTitle);
                } else if (aData.length == 1 && aData[0].getCMetadataType().equals("Environment")) {
                    SoftwareComponent mdSoftComp = CustomTreeModel.getSoftwareComponent(aData[0].getFQID(), store);
                    if (mdSoftComp == null) {
                        throw new MdException(bundle.getString("WAdminTree_ChangeManagement.PromotionError.txt"));
                    }
                    wizard = new ExportWizard(mdSoftComp, aSupportedTypes, sWizardTitle);
                } else {
                    LogicalObjectInterface[] aLogicalObjects = new LogicalObjectInterface[aNodes.length];
                    for (int i = 0; i < aNodes.length; ++i) {
                        aLogicalObjects[i] = ((LogicalObjectNode)aNodes[i]).getLogicalObject();
                    }
                    wizard = new ExportWizard((SimpleLogicalObjectInterface[])aLogicalObjects, aSupportedTypes, sWizardTitle);
                }
                wizard.show();
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImport() {
        try {
            WsTreeNode[] aNodes = this.getSelectedNodes();
            WsTreeNode treeNode = aNodes[0];
            CMetadata mdNode = treeNode.getMetadata();
            String sWizardTitle = bundle.getString("WAdminTree_ChangeManagement.ImportWizardTitle.txt");
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_ChangeManagement.onImport");
            try {
                Map mapNewObjects;
                ImportWizard wizard;
                TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
                if (mdNode.getCMetadataType().equals("Environment")) {
                    SoftwareComponent mdSoftComp = CustomTreeModel.getSoftwareComponent(mdNode.getFQID(), store);
                    if (mdSoftComp == null) {
                        throw new MdException(bundle.getString("WAdminTree_ChangeManagement.PromotionError.txt"));
                    }
                    wizard = new ImportWizard(mdSoftComp, aSupportedTypes, sWizardTitle);
                } else {
                    Tree mdTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, mdNode);
                    if (mdTree == null) {
                        throw new MdException(bundle.getString("WAdminTree_ChangeManagement.PromotionError.txt"));
                    }
                    wizard = new ImportWizard(mdTree, aSupportedTypes, sWizardTitle);
                }
                if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_ON) {
                    wizard.changeRepositoryID(Workspace.getWorkspace().getProjectRepository().getFQID());
                }
                wizard.show();
                if (wizard.getReturnValue() == 1 && (mapNewObjects = wizard.getTargetObjectIDs()) != null && !mapNewObjects.isEmpty()) {
                    this.generateObjectsModifiedEvent(mapNewObjects);
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCopy() {
        try {
            WsTreeNode[] aNodes = this.getSelectedNodes();
            MdObjectStore mdStore = null;
            try {
                ArrayList<Object> lLogicalObjects = new ArrayList<Object>(aNodes.length);
                for (int i = 0; i < aNodes.length; ++i) {
                    if (aNodes[i] instanceof LogicalObjectNode) {
                        lLogicalObjects.add(((LogicalObjectNode)aNodes[i]).getLogicalObject());
                        continue;
                    }
                    CMetadata mdNode = aNodes[i].getMetadata();
                    if (!mdNode.getCMetadataType().equals("Tree")) continue;
                    if (mdStore == null) {
                        mdStore = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_ChangeManagement:onCopy");
                    }
                    Tree mdTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(mdStore, mdNode);
                    FolderInterface folder = (FolderInterface)Factory.getInstance().getObject((Root)mdTree);
                    lLogicalObjects.add(folder);
                }
                SimpleLogicalObjectInterface[] aLogicalObjects = lLogicalObjects.toArray(new SimpleLogicalObjectInterface[lLogicalObjects.size()]);
                CopyPasteUtil.copy((SimpleLogicalObjectInterface[])aLogicalObjects);
            }
            catch (LogicalTypeException lte) {
                lte.printStackTrace();
            }
            finally {
                if (mdStore != null) {
                    mdStore.dispose();
                }
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaste() {
        WsTreeNode[] aNodes = this.getSelectedNodes();
        WsTreeNode treeNode = aNodes[0];
        if (treeNode == null) {
            return;
        }
        try {
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            LogicalObjectInterface target = null;
            if (treeNode instanceof LogicalObjectNode) {
                target = ((LogicalObjectNode)treeNode).getLogicalObject();
            } else {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_ChangeManagement:onPaste");
                try {
                    String sRepositoryID = treeNode.getMetadata().getFQID();
                    SoftwareComponent mdSoftComp = CustomTreeModel.getSoftwareComponent(sRepositoryID, store);
                    if (mdSoftComp == null) {
                        throw new MdException(bundle.getString("WAdminTree_ChangeManagement.PromotionError.txt"));
                    }
                    target = Factory.getInstance().getObject((Root)mdSoftComp);
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                }
                finally {
                    store.dispose();
                }
            }
            if (!(target instanceof FolderInterface)) {
                return;
            }
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                CopyPasteUtil.paste((FolderInterface)((FolderInterface)target), (TypeInterface[])aSupportedTypes, (String)Workspace.getWorkspace().getProjectRepository().getFQID());
            } else {
                CopyPasteUtil.paste((FolderInterface)((FolderInterface)target), (TypeInterface[])aSupportedTypes);
            }
            Map mapNewObjects = CopyPasteUtil.getObjectsPasted();
            if (mapNewObjects != null && !mapNewObjects.isEmpty()) {
                this.generateObjectsModifiedEvent(mapNewObjects);
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPasteSpecial() {
        WsTreeNode[] aNodes = this.getSelectedNodes();
        WsTreeNode treeNode = aNodes[0];
        if (treeNode == null) {
            return;
        }
        try {
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            LogicalObjectInterface target = null;
            if (treeNode instanceof LogicalObjectNode) {
                target = ((LogicalObjectNode)treeNode).getLogicalObject();
            } else {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_ChangeManagement:onPaste");
                try {
                    String sRepositoryID = treeNode.getMetadata().getFQID();
                    SoftwareComponent mdSoftComp = CustomTreeModel.getSoftwareComponent(sRepositoryID, store);
                    if (mdSoftComp == null) {
                        throw new MdException(bundle.getString("WAdminTree_ChangeManagement.PromotionError.txt"));
                    }
                    target = Factory.getInstance().getObject((Root)mdSoftComp);
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                }
                finally {
                    store.dispose();
                }
            }
            if (!(target instanceof FolderInterface)) {
                return;
            }
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                CopyPasteUtil.pasteSpecial((FolderInterface)((FolderInterface)target), (TypeInterface[])aSupportedTypes, (String)Workspace.getWorkspace().getProjectRepository().getFQID());
            } else {
                CopyPasteUtil.pasteSpecial((FolderInterface)((FolderInterface)target), (TypeInterface[])aSupportedTypes);
            }
            Map mapNewObjects = CopyPasteUtil.getObjectsPasted();
            if (mapNewObjects != null && !mapNewObjects.isEmpty()) {
                this.generateObjectsModifiedEvent(mapNewObjects);
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public void onClearProject() {
        ClearProjectDialog clearDlg = new ClearProjectDialog();
        clearDlg.show();
        if (clearDlg.getReturnValue() == 2) {
            clearDlg.dispose();
            return;
        }
        this.m_bisDeletedRepos = clearDlg.isDeletedRepos();
        this.m_sClearRepositoryID1 = clearDlg.getSelectedProjectRepos();
        String sClearProjectName = clearDlg.getSelectedProjectName();
        clearDlg.dispose();
        if (this.m_sClearRepositoryID1 == null) {
            return;
        }
        int eAnswer = MessageUtil.displayMessage((String)bundle.formatString("WAdminTree_ChangeManagement.ClearProjectWarning.txt.fmt", (Object)sClearProjectName), (int)2, (int)0);
        if (eAnswer == 0) {
            try {
                this.m_store = Workspace.getMdFactory().createObjectStore();
                try {
                    String str1 = bundle.getString("ClearProjectProgressIndicator.Msg.Message");
                    String str2 = bundle.getString("ClearProjectProgressIndicator.Msg.Title");
                    OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2);
                    request.setDelayBeforeProgressCancelDialog(200);
                    Runnable runClearProject = new Runnable(){

                        @Override
                        public void run() {
                            WAdminTree_ChangeManagement.this.doThreadedClearProject();
                        }
                    };
                    request.execute(runClearProject);
                    Workspace.getDefaultLogger().debug((Object)"Finished waiting on Clear Project");
                }
                catch (Exception ge) {
                    Workspace.getDefaultLogger().error((Object)"", (Throwable)ge);
                    MessageUtil.displayMessage((String)(bundle.getString("WAdminTree_ChangeManagement.ClearProjectError.txt") + " " + ge.getMessage()), (int)0);
                }
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateObjectsModifiedEvent(Map mapNewObjects) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "WAdminTree_ChangeManagement:generateObjectsModifiedEvent");
            try {
                ArrayList lNewObjectIDs = new ArrayList(mapNewObjects.keySet());
                for (String sFQID : lNewObjectIDs) {
                    String sType = (String)mapNewObjects.get(sFQID);
                    Workspace.getMdFactory().createComplexMetadataObject(store, null, sType, sFQID);
                }
                Workspace.getMdFactory().getStore().fireMdObjectsModified(new MdEvent((Object)this), lNewObjectIDs);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public static Tree getWarehouseTree(Root oData) {
        try {
            if (oData.getFQID().indexOf(36) != -1) {
                return null;
            }
            try {
                StringBuffer sbTemplate = new StringBuffer("<Templates>");
                sbTemplate.append("<Tree><Groups/></Tree>");
                sbTemplate.append("<Group><SoftwareComponents/></Group>");
                sbTemplate.append("</Templates>");
                Vector<String> vComplexAttrs = new Vector<String>();
                vComplexAttrs.add("Trees");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oData, null, vComplexAttrs, sbTemplate.toString(), 268);
                AssociationList alTrees = oData.getTrees();
                int nTrees = alTrees.size();
                for (int iTree = 0; iTree < nTrees; ++iTree) {
                    AssociationList alGroups = ((Tree)alTrees.get(iTree)).getGroups();
                    int nGroups = alGroups.size();
                    for (int iGroup = 0; iGroup < nGroups; ++iGroup) {
                        AssociationList alSoftwares = ((Group)alGroups.get(iGroup)).getSoftwareComponents();
                        int nSoftwares = alSoftwares.size();
                        for (int iSoftware = 0; iSoftware < nSoftwares; ++iSoftware) {
                            SoftwareComponent Software = (SoftwareComponent)alSoftwares.get(iSoftware);
                            if (!Software.getClassIdentifier().equals("com.sas.wadmin.visuals.TheAppWA")) continue;
                            return (Tree)alTrees.get(iTree);
                        }
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return null;
    }

    protected OpRequestUICancellableRunnable createDeleteOperation(WsTreeNode[] aNodes, OpRequestUI opUI) {
        return new DeleteOperation(aNodes, opUI);
    }

    protected void createActions() {
        super.createActions();
        this.m_actCopyObject = this.createCopyObjectAction();
        this.m_actChangeManagement = this.createChangeManagementAction();
        this.m_actCheckout = this.createCheckoutAction();
        this.m_actUndoCheckout = this.createUndoCheckoutAction();
        this.m_actFetch = this.createFetchAction();
        this.m_actHistory = this.createHistoryAction();
        this.m_actGroup = this.createGroupAction();
        this.m_actClearProject = this.createClearProjectAction();
    }

    protected WsAbstractAction createCopyObjectAction() {
        return new cCopyObjectAction();
    }

    protected WsAbstractAction createChangeManagementAction() {
        return new cChangeManagementAction();
    }

    protected WsAbstractAction createCheckoutAction() {
        return new cCheckoutAction();
    }

    protected WsAbstractAction createUndoCheckoutAction() {
        return new cUndoCheckoutAction();
    }

    protected WsAbstractAction createFetchAction() {
        return new cFetchAction();
    }

    protected WsAbstractAction createHistoryAction() {
        return new cHistoryAction();
    }

    protected WsAbstractAction createGroupAction() {
        return new cGroupAction();
    }

    protected WsAbstractAction createClearProjectAction() {
        return new cClearProjectAction();
    }

    protected String getUserNameOfPersonWhoOwnsObject(String strMetadataIDToFind) {
        return WsMetadataChangeManagementUtil.getNameOfOwnerFor((String)strMetadataIDToFind);
    }

    public static CMetadata[] getSelectedObjects(TreeNode[] aNodes) {
        int nNodes = aNodes.length;
        if (nNodes <= 0) {
            return null;
        }
        CMetadata[] aData = new CMetadata[nNodes];
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            CMetadata oData;
            if (!(aNodes[iNode] instanceof WsDataTreeNode)) {
                return null;
            }
            WsDataTreeNode node = (WsDataTreeNode)aNodes[iNode];
            aData[iNode] = oData = node.getMetadata();
        }
        return aData;
    }

    protected TreeSelectionListener createSelectionListener() {
        return new cSelectionListener();
    }

    protected CopyListListener createCopyListListener() {
        return new cCopyListListener();
    }

    protected class cClearProjectAction
    extends WsAbstractAction {
        public cClearProjectAction() {
            super(bundle, "Tree.ChangeManagement.ClearProject");
            this.setMenuSupportId("clearproject");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onClearProject();
        }
    }

    protected class cGroupAction
    extends WsAbstractAction {
        public cGroupAction() {
            super(bundle, "Tree.ChangeManagement.Group");
            this.setMenuSupportId("group");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onGroup();
        }
    }

    protected class cHistoryAction
    extends WsAbstractAction {
        public cHistoryAction() {
            super(bundle, "Tree.ChangeManagement.History");
            this.setMenuSupportId("history");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onHistory();
        }
    }

    protected class cFetchAction
    extends WsAbstractAction {
        public cFetchAction() {
            super(bundle, "Tree.ChangeManagement.Fetch", true);
            this.setMenuSupportId("fetch");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onFetch();
        }
    }

    protected class cUndoCheckoutAction
    extends WsAbstractAction {
        public cUndoCheckoutAction() {
            super(bundle, "Tree.ChangeManagement.UndoCheckout", true);
            this.setMenuSupportId("undocheckout");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onUndoCheckout();
        }
    }

    protected class cCheckoutAction
    extends WsAbstractAction {
        public cCheckoutAction() {
            super(bundle, "Tree.ChangeManagement.Checkout", true);
            this.setMenuSupportId("checkout");
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onCheckout();
        }
    }

    protected class cChangeManagementAction
    extends WsAbstractAction {
        public cChangeManagementAction() {
            super(bundle, "Tree.ChangeManagement");
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cCopyObjectAction
    extends WsAbstractAction {
        public cCopyObjectAction() {
            super(bundle, "Tree.ChangeManagement.CopyObject");
            this.setMenuSupportId("copyobject");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            WAdminTree_ChangeManagement.this.onCopyObject();
        }
    }

    private class cCopyListListener
    implements CopyListListener {
        private cCopyListListener() {
        }

        public void copyListChanged() {
            WAdminTree_ChangeManagement.this.updateActions();
        }
    }

    public class cSelectionListener
    extends WorkspaceTree.cSelectListener {
        public cSelectionListener() {
            super((WorkspaceTree)WAdminTree_ChangeManagement.this);
        }
    }

    private static class DeleteOperation
    extends WsAbstractOperation {
        private WsTreeNode[] m_aNodes;
        private OpRequestUI m_opUI;

        public DeleteOperation(WsTreeNode[] aNodes, OpRequestUI opUI) {
            super(opUI);
            this.m_aNodes = aNodes;
            this.m_opUI = opUI;
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            for (int iNode = 0; iNode < this.m_aNodes.length; ++iNode) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                this.updateProgress(bundle.formatString("WAdminTree_ChangeManagement.Progress.Deleting.fmt.txt", (Object)this.m_aNodes[iNode]));
                if (this.m_aNodes[iNode] instanceof LogicalObjectNode) {
                    ((LogicalObjectNode)this.m_aNodes[iNode]).delete(op);
                    continue;
                }
                this.m_aNodes[iNode].delete();
            }
        }
    }

    private class FetchOperation
    extends WsAbstractOperation {
        private WsTreeNode[] m_aFetchNodes;
        private OpRequestUI m_opUI;

        public FetchOperation(WsTreeNode[] aNodes, OpRequestUI opUI) {
            super(opUI);
            this.m_aFetchNodes = aNodes;
            this.m_opUI = opUI;
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            ArrayList<CMetadata> lObjects = new ArrayList<CMetadata>();
            for (int iNode = 0; iNode < this.m_aFetchNodes.length; ++iNode) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                if (this.m_aFetchNodes[iNode] instanceof LogicalObjectNode) {
                    this.updateProgress(bundle.formatString("WAdminTree_ChangeManagement.Progress.Fetching.fmt.txt", (Object)this.m_aFetchNodes[iNode].getName()));
                    ((LogicalObjectNode)this.m_aFetchNodes[iNode]).fetch(op);
                    continue;
                }
                lObjects.add(this.m_aFetchNodes[iNode].getMetadata());
            }
            if (this.isOperationCancelled() || op.isOperationCancelled()) {
                return;
            }
            if (!lObjects.isEmpty()) {
                this.updateProgress(bundle.getString("WAdminTree_ChangeManagement.Progress.Fetching.txt"));
                try {
                    ProjectUtil.fetchMetadata(lObjects, (CMetadata)Workspace.getWorkspace().getProjectRepository());
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Fetching");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }

    private class CheckOutOperation
    extends WsAbstractOperation {
        private WsTreeNode[] m_aCheckOutNodes;
        private OpRequestUI m_opUI;

        public CheckOutOperation(WsTreeNode[] aNodes, OpRequestUI opUI) {
            super(opUI);
            this.m_aCheckOutNodes = aNodes;
            this.m_opUI = opUI;
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            ArrayList<CMetadata> lObjects = new ArrayList<CMetadata>();
            for (int iNode = 0; iNode < this.m_aCheckOutNodes.length; ++iNode) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                if (this.m_aCheckOutNodes[iNode] instanceof LogicalObjectNode) {
                    this.updateProgress(bundle.formatString("WAdminTree_ChangeManagement.Progress.CheckingOut.fmt.txt", (Object)this.m_aCheckOutNodes[iNode].getName()));
                    ((LogicalObjectNode)this.m_aCheckOutNodes[iNode]).checkOut(op);
                    continue;
                }
                lObjects.add(this.m_aCheckOutNodes[iNode].getMetadata());
            }
            if (this.isOperationCancelled() || op.isOperationCancelled()) {
                return;
            }
            if (!lObjects.isEmpty()) {
                this.updateProgress(bundle.getString("WAdminTree_ChangeManagement.Progress.CheckingOut.txt"));
                try {
                    ProjectUtil.checkOutMetadata(lObjects, (CMetadata)Workspace.getWorkspace().getProjectRepository());
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Checkingout");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
    }
}

