/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.visuals.util.XMLMenuBar;
import com.sas.wadmin.plugins.ShortcutInterface;
import com.sas.wadmin.visuals.DefaultCommandListener;
import com.sas.wadmin.visuals.NewJobWizard;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.wadmin.visuals.SourceDesigner;
import com.sas.wadmin.visuals.TargetDesigner;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceMenuSupport;
import com.sas.workspace.WorkspaceShortcutBar;
import com.sas.workspace.visuals.MetadataExporter;
import com.sas.workspace.visuals.MetadataImporter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class WAShortcutBar
extends WorkspaceShortcutBar {
    Workspace m_workspace;
    final int NUMBER_CUSTOM_SHORTCUTS = 6;
    ArrayList pluginsInBar = new ArrayList();
    ShortcutInterface shortcutInterface = null;
    boolean m_bIsPluginInMenu = false;
    private static WAdminResource bundle = WAdminResource.getBundle(WAShortcutBar.class);

    public WAShortcutBar(String title) {
        super(title, false);
        this.m_workspace = Workspace.getWorkspace();
        this.addItem(bundle.getImageIcon("ShortcutBar.Source.image"), "ShortcutBar.Source.Title");
        this.addItem(bundle.getImageIcon("ShortcutBar.Metadataimport.image"), "ShortcutBar.Metadataimport.Title");
        this.addItem(bundle.getImageIcon("ShortcutBar.Metadataexport.image"), "ShortcutBar.Metadataexport.Title");
        this.addItem(bundle.getImageIcon("ShortcutBar.Process.image"), "ShortcutBar.Process.Title");
        this.addItem(bundle.getImageIcon("ShortcutBar.Target.image"), "ShortcutBar.Target.Title");
        this.addItem(bundle.getImageIcon("ShortcutBar.Configure.image"), "ShortcutBar.Configure.Title");
        ArrayList plugins = this.m_workspace.getPluginLoader().getPlugins("com.sas.wadmin.plugins.ShortcutInterface");
        for (int i = 0; i < plugins.size(); ++i) {
            ShortcutInterface plugin = (ShortcutInterface)plugins.get(i);
            this.addShortcutPlugin(plugin, 6 + i);
        }
    }

    public void onItemSelected(int iItem) {
        switch (iItem) {
            case 0: {
                SourceDesigner waSourceDlg = new SourceDesigner((Frame)this.m_workspace, bundle.getString("SourceDesigner.Title"));
                waSourceDlg.show();
                break;
            }
            case 1: {
                MetadataImporter waMetadataImportDlg = new MetadataImporter(this.m_workspace, bundle.getString("MetadataImporter.Title.txt"), this.m_workspace.getDefaultRepository(), true);
                waMetadataImportDlg.show();
                break;
            }
            case 2: {
                MetadataExporter waMetadataExportDlg = new MetadataExporter(this.m_workspace, bundle.getString("MetadataExporter.Title.txt"), this.m_workspace.getDefaultRepository());
                waMetadataExportDlg.show();
                break;
            }
            case 3: {
                NewJobWizard plugin = new NewJobWizard();
                NewObjectWizard dlg = new NewObjectWizard((Frame)this.m_workspace, "", plugin, "Jobs");
                dlg.show();
                break;
            }
            case 4: {
                TargetDesigner waTargetDlg = new TargetDesigner((Frame)this.m_workspace, bundle.getString("ShortcutBar.Target.Title"));
                waTargetDlg.show();
                break;
            }
            case 5: {
                DefaultCommandListener.launchOptionsDialog();
                break;
            }
            default: {
                ((ShortcutInterface)this.pluginsInBar.get(iItem - 6)).onSelected();
            }
        }
    }

    public void addShortcutPlugin(final ShortcutInterface plugin, int shortcutIndex) {
        XMLMenuBar menuBar = WorkspaceMenuSupport.getWorkspaceMenuSupport().getMenuBar();
        if (plugin.getLocations() == 4 || plugin.getLocations() == 1) {
            this.pluginsInBar.add(plugin);
            this.addItem(plugin.getName(), (ImageIcon)plugin.getLargeIcon());
        }
        if (menuBar == null) {
            return;
        }
        if (plugin.getLocations() == 4 || plugin.getLocations() == 2) {
            if (!this.m_bIsPluginInMenu) {
                menuBar.addDynamicMenuItem("ShortcutPlugins", (Component)new JSeparator());
                this.m_bIsPluginInMenu = true;
            }
            JMenuItem menuItem = plugin.getMenuItem();
            menuItem.addActionListener(new ActionListener(){
                private ShortcutInterface m_plugin;
                {
                    this.m_plugin = plugin;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.m_plugin.onSelected();
                }
            });
            menuBar.addDynamicMenuItem("ShortcutPlugins", (Component)menuItem);
        }
    }
}

