/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.visuals.PhysicalStoragePane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class WAPhysicalStorageTab
extends WAPropertyTab
implements MdObjectListener {
    protected CMetadata m_metadata = null;
    protected Workspace m_workspace = null;
    PhysicalStoragePane m_physicalStoragePane = null;

    public WAPhysicalStorageTab(CMetadata metadata) {
        this.m_metadata = metadata;
        this.m_workspace = Workspace.getWorkspace();
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("physical_storage_tab");
    }

    public boolean validateData() {
        return this.m_physicalStoragePane.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            boolean bl = this.m_physicalStoragePane.doDataExchange(bSaveToModel);
            return bl;
        }
        finally {
            this.setDataChanged(false);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_physicalStoragePane.saveSettingsAndCleanUp();
    }

    protected void initialize() {
        try {
            if (this.m_metadata instanceof PhysicalTable) {
                this.m_physicalStoragePane = new PhysicalStoragePane(this.m_metadata);
            } else if (this.m_metadata instanceof TransformationStep) {
                ClassifierMap m_oMap = (ClassifierMap)((TransformationStep)this.m_metadata).getTransformations().get(0);
                PhysicalTable useTable = (PhysicalTable)m_oMap.getClassifierTargets().get(0);
                this.m_physicalStoragePane = new PhysicalStoragePane((CMetadata)useTable);
            }
            super.listenForDataChangesTo((WAPanel)this.m_physicalStoragePane);
        }
        catch (MdException e) {
            e.printStackTrace();
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.m_physicalStoragePane), "Center");
    }

    public void setEditable(boolean bEditable) {
        this.m_physicalStoragePane.setEditable(bEditable);
    }

    public void MdObjectModified(MdEvent e) {
        try {
            this.refresh();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    class WAGUndoableEditListener
    implements UndoableEditListener {
        WAGUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            WAPhysicalStorageTab.this.getWAUndoManager().addEdit(e.getEdit());
        }
    }
}

