/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Job;
import com.sas.wadmin.pfd.PFDCodegenEditorPropertyTab;
import com.sas.wadmin.pfd.PFDPanel;
import com.sas.wadmin.visuals.InnerJobView;
import com.sas.wadmin.visuals.WAPFDPropertyTab;
import com.sas.workspace.WAInternalFrame;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.WsEditorOMAView;
import com.sas.workspace.visuals.WsEditorPropertyTab;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.Icon;

public class WAPFDEditorOMAView
extends WsEditorOMAView {
    protected Job m_oJob;
    protected ArrayList m_outputTables = null;
    protected PFDCodegenEditorPropertyTab m_pcEditorTab = null;
    protected InnerJobView m_innerJobView = null;
    private static WAdminResource bundle = WAdminResource.getBundle(WAPFDEditorOMAView.class);
    protected WAPropertyTab m_tabPFD;
    protected String m_sTransformationStepFQID;

    public WAPFDEditorOMAView(Job oJob) {
        this(oJob, null);
    }

    public WAPFDEditorOMAView(Job oJob, ArrayList outputTables) {
        this.m_oJob = oJob;
        this.m_outputTables = outputTables;
        this.m_innerJobView = new InnerJobView();
    }

    public void setFrame(WAInternalFrame frame) {
        super.setFrame(frame);
        frame.addPropertyChangeListener(this.m_pcEditorTab.createDataChangedListener());
    }

    protected String getFrameTitle() {
        try {
            String sAppServName = Workspace.getAppServerName();
            String title = bundle.formatString("WAPFDEditorOMAView.Title.txt", (Object)this.m_metadata.getName(), (Object)sAppServName);
            if (this.m_sStatus != null && this.m_sStatus.length() > 0) {
                title = title + " : " + this.m_sStatus;
            }
            return title;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
            return null;
        }
    }

    public void updateTitleWithStatusChanges(String sNewStatus, String sFileName, String sHostName) {
        this.setLastAppServerStatus(this.m_sStatus);
        this.m_sStatus = sNewStatus;
        this.m_sHostname = sHostName;
        this.m_sFileName = sFileName;
        String title = bundle.formatString("WAPFDEditorOMAView.Title.txt", (Object)sFileName, (Object)sHostName);
        if (this.m_sStatus != null && this.m_sStatus.length() > 0) {
            title = title + " : " + this.m_sStatus;
        }
        this.getFrame().setTitle(title);
    }

    public void updateTitleWithStatusChanges(String sNewStatus, String sHostName) {
        this.updateTitleWithStatusChanges(sNewStatus, "", sHostName);
    }

    public WAPFDPropertyTab getPFDTab() {
        return (WAPFDPropertyTab)this.m_tabPFD;
    }

    protected Icon getFrameIcon() {
        return bundle.getImageIcon("WAPFDEditorOMAView.icon.image");
    }

    public void setTransformationStepFQID(String sTSFQID) {
        this.m_sTransformationStepFQID = sTSFQID;
    }

    protected void createTabs() {
        super.createTabs();
        this.m_tabPFD = this.createPFDPropertyTab();
        if (this.m_sTransformationStepFQID != null && this.m_sTransformationStepFQID.length() > 0) {
            ((WAPFDPropertyTab)this.m_tabPFD).getPFDPanel().setTransformationStepFQID(this.m_sTransformationStepFQID);
        }
        this.m_sTransformationStepFQID = null;
    }

    protected WAPropertyTabGroup createTabGroup() {
        WAPropertyTabGroup tabs = new WAPropertyTabGroup();
        tabs.addTab(this.m_tabPFD.getName(), this.m_tabPFD);
        if (this.m_bEditorPresent) {
            tabs.addTab(this.m_tabEditor.getName(), (WAPropertyTab)this.m_tabEditor);
        }
        if (this.m_bLogPresent) {
            tabs.addTab(this.m_tabLog.getName(), (WAPropertyTab)this.m_tabLog);
        }
        if (this.m_bOutputPresent) {
            tabs.addTab(this.m_tabOutput.getName(), (WAPropertyTab)this.m_tabOutput);
        }
        return tabs;
    }

    protected WAPropertyTab createPFDPropertyTab() {
        WAPFDPropertyTab tab = new WAPFDPropertyTab((CMetadata)this.m_metadata, this.m_outputTables);
        tab.setName(bundle.getString("WAPFDEditorOMAView.PFDTab.title.txt"));
        tab.setEditorTab((PFDCodegenEditorPropertyTab)this.m_tabEditor);
        tab.setOwningView(this);
        tab.setInnerJobView(this.m_innerJobView);
        return tab;
    }

    protected WsEditorPropertyTab createEditorPropertyTab() {
        this.m_pcEditorTab = new PFDCodegenEditorPropertyTab(this.m_oJob);
        this.m_pcEditorTab.setOwningView(this);
        return this.m_pcEditorTab;
    }

    public boolean isEditorShownByDefault() {
        return true;
    }

    protected boolean isLogShownByDefault() {
        return true;
    }

    protected boolean isOutputShownByDefault() {
        return false;
    }

    public PFDPanel getPFDPanel() {
        return ((WAPFDPropertyTab)this.m_tabPFD).getPFDPanel();
    }

    public void dispose() {
        this.m_tabPFD = null;
        super.dispose();
    }
}

