/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.workspace.WATextPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsFlatButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.basic.BasicSeparatorUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class WANotesPreviewPane
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(WANotesPreviewPane.class);
    protected JLabel m_lblText;
    protected WATextPane m_pnlText;
    protected JScrollPane m_scrText;
    protected JPopupMenu m_menuPopup;
    protected JToolBar m_barTools;
    protected cActiveAction m_actCut;
    protected cActiveAction m_actCopy;
    protected cActiveAction m_actPaste;
    protected boolean m_bEditable = true;
    protected UndoableEditListener m_lsnrUndoableEdit;
    protected DocumentListener m_lsnrDocument;
    protected StyledDocument m_mdlDocument;
    protected boolean m_bShowButtons;

    public WANotesPreviewPane() {
        this(true);
    }

    public WANotesPreviewPane(boolean bShowButtons) {
        this.m_bShowButtons = bShowButtons;
        this.initialize();
        this.layoutWidgets();
    }

    public WATextPane getTextPane() {
        return this.m_pnlText;
    }

    public JLabel getTextLabel() {
        return this.m_lblText;
    }

    public String getContents() {
        StringWriter sw = new StringWriter();
        StyledDocument sd = this.m_pnlText.getStyledDocument();
        try {
            this.m_pnlText.getEditorKit().write(sw, (Document)sd, 0, sd.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sw.toString();
    }

    public void setContents(String sText) {
        this.m_mdlDocument = new HTMLDocument();
        this.m_pnlText.setStyledDocument(this.m_mdlDocument);
        if (sText != null && sText.length() != 0) {
            try {
                StringReader sr = new StringReader(sText);
                this.m_pnlText.getEditorKit().read(sr, (Document)this.m_mdlDocument, 0);
                this.m_pnlText.setCaretPosition(1);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.m_lsnrUndoableEdit != null) {
            this.m_mdlDocument.addUndoableEditListener(this.m_lsnrUndoableEdit);
        }
        if (this.m_lsnrDocument != null) {
            this.m_mdlDocument.addDocumentListener(this.m_lsnrDocument);
        }
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
        this.m_pnlText.setEditable(bEditable);
        this.m_actCut.setEnabled(bEditable && this.isEnabled() && this.m_pnlText.getSelectedText() != null);
        this.m_actPaste.setEnabled(bEditable && this.isEnabled());
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.m_pnlText.setEnabled(bEnabled);
        this.m_actCut.setEnabled(bEnabled && this.isEditable() && this.m_pnlText.getSelectedText() != null);
        this.m_actCopy.setEnabled(bEnabled && this.m_pnlText.getSelectedText() != null);
        this.m_actPaste.setEnabled(bEnabled && this.isEditable());
    }

    public void dispose() {
        this.m_actCut.dispose();
        this.m_actCopy.dispose();
        this.m_actPaste.dispose();
    }

    public void setUndoableEditListener(UndoableEditListener l) {
        this.m_lsnrUndoableEdit = l;
        if (this.m_mdlDocument != null) {
            this.m_mdlDocument.addUndoableEditListener(l);
        }
    }

    public void setDocumentListener(DocumentListener l) {
        this.m_lsnrDocument = l;
        if (this.m_mdlDocument != null) {
            this.m_mdlDocument.addDocumentListener(l);
        }
    }

    protected void initialize() {
        this.m_pnlText = new WATextPane();
        this.m_pnlText.setAutoSelect(false);
        this.m_pnlText.setSelectionColor((Color)SystemColor.textHighlight);
        this.m_pnlText.setSelectedTextColor((Color)SystemColor.textHighlightText);
        this.m_pnlText.setFont(new Font("dialog", 0, 12));
        this.m_mdlDocument = new HTMLDocument();
        this.m_pnlText.setEditorKit((EditorKit)new HTMLEditorKit());
        this.m_pnlText.setStyledDocument(this.m_mdlDocument);
        this.m_pnlText.getCaret().addChangeListener(new cCaretMovedListener());
        if (this.m_bShowButtons) {
            this.m_pnlText.addMouseListener((MouseListener)new cPopupMenuListener());
        }
        this.m_pnlText.addFocusListener((FocusListener)new cFocusListener());
        this.m_lblText = new JLabel(bundle.getString("WANotesPreviewPane.Label.txt"));
        this.m_lblText.setDisplayedMnemonic(bundle.getString("WANotesPreviewPane.Label.mnem").charAt(0));
        this.m_lblText.setLabelFor((Component)this.m_pnlText);
        this.m_scrText = new JScrollPane((Component)this.m_pnlText);
        this.createActions();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_bShowButtons) {
            this.add((Component)this.m_barTools, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.m_scrText, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createActions() {
        this.m_menuPopup = new JPopupMenu();
        this.m_barTools = new JToolBar();
        this.m_barTools.setBorder(BorderFactory.createEmptyBorder());
        this.m_barTools.setRollover(true);
        this.m_actCut = this.createAction("cut-to-clipboard", "cut", KeyStroke.getKeyStroke(88, 2), "Common:Cut");
        this.m_actCopy = this.createAction("copy-to-clipboard", "copy", KeyStroke.getKeyStroke(67, 2), "Common:Copy");
        this.m_actPaste = this.createAction("paste-from-clipboard", "paste", KeyStroke.getKeyStroke(86, 2), "Common:Paste");
        this.m_menuPopup.addSeparator();
        JSeparator sep = new JSeparator(1);
        sep.setUI(new cSeparatorUI());
        this.m_barTools.add(sep);
    }

    protected cActiveAction createAction(String sAction, String sResource, KeyStroke key, String sFactoryIcon) {
        Action action = this.m_pnlText.getActionMap().get(sAction);
        if (action == null) {
            return null;
        }
        cActiveAction actActive = new cActiveAction(action);
        JMenuItem item = new JMenuItem(actActive);
        item.setText(bundle.getString("WANotesPreviewPane." + sResource + ".txt"));
        item.setMnemonic(bundle.getString("WANotesPreviewPane." + sResource + ".mnem").charAt(0));
        item.setAccelerator(key);
        this.m_menuPopup.add(item);
        JButton button = new JButton();
        button.setAction(actActive);
        button.setText(null);
        button.setFocusable(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setIcon(WsAbstractIconFactory.getInstance().getIconForAction(sFactoryIcon));
        button.setToolTipText(bundle.getString("WANotesPreviewPane." + sResource + ".tooltip.txt") + this.getAcceleratorText(key));
        this.m_barTools.add(button);
        this.m_pnlText.getKeymap().addActionForKeyStroke(key, actActive);
        return actActive;
    }

    protected String getAcceleratorText(KeyStroke accelerator) {
        StringBuffer sAccelerator = new StringBuffer();
        if (accelerator != null) {
            sAccelerator.append(" (");
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                sAccelerator.append(KeyEvent.getKeyModifiersText(modifiers));
                sAccelerator.append("+");
            }
            sAccelerator.append(KeyEvent.getKeyText(accelerator.getKeyCode()));
            sAccelerator.append(")");
        }
        return sAccelerator.toString();
    }

    public static class cSeparatorUI
    extends BasicSeparatorUI {
        @Override
        public Dimension getPreferredSize(JComponent c) {
            return new Dimension(4, 16);
        }

        @Override
        public Dimension getMinimumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public Dimension getMaximumSize(JComponent c) {
            return this.getPreferredSize(c);
        }

        @Override
        public void paint(Graphics g, JComponent cmp) {
            Dimension dimComponent = cmp.getSize();
            int x = dimComponent.width / 2;
            g.setColor(cmp.getForeground());
            g.drawLine(x, 0, x, dimComponent.height);
            g.setColor(cmp.getBackground());
            g.drawLine(++x, 0, x, dimComponent.height);
        }
    }

    protected class cCheckedFlatButton
    extends WsFlatButton {
        protected cCheckedFlatButton() {
        }

        public void mousePressed(MouseEvent e) {
            if (this.isEnabled()) {
                this.setSelected(!super.isSelected());
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    protected static class cCheckedAction
    extends cActiveAction {
        protected JCheckBoxMenuItem m_mi;
        protected AbstractButton m_btn;
        protected String m_sName;

        public cCheckedAction(Action action, JCheckBoxMenuItem mi, JToggleButton btn) {
            super(action);
            this.m_mi = mi;
            this.m_btn = btn;
        }

        public cCheckedAction(Action action, JCheckBoxMenuItem mi, cCheckedFlatButton btn) {
            super(action);
            this.m_mi = mi;
            this.m_btn = btn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src != this.m_mi) {
                this.m_mi.setSelected(!this.m_mi.isSelected());
            }
            if (src != this.m_btn) {
                this.m_btn.setSelected(!this.m_btn.isSelected());
            }
            this.m_action.actionPerformed(e);
        }

        public void setSelected(boolean bSelected) {
            this.m_btn.setSelected(bSelected);
            this.m_mi.setSelected(bSelected);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.m_mi = null;
            this.m_btn = null;
        }
    }

    protected static class cActiveAction
    extends AbstractAction {
        protected Action m_action;
        protected boolean m_bActive;
        protected boolean m_bReallyEnabled;

        public cActiveAction(Action action) {
            this.m_action = action;
            super.setEnabled(false);
        }

        public void setActive(boolean bActive) {
            if (this.m_bActive != bActive) {
                this.m_bActive = bActive;
                if (bActive) {
                    super.setEnabled(this.m_bReallyEnabled);
                } else {
                    this.m_bReallyEnabled = this.isEnabled();
                    super.setEnabled(false);
                }
            }
        }

        public boolean isActive() {
            return this.m_bActive;
        }

        @Override
        public void setEnabled(boolean bEnabled) {
            if (this.m_bActive) {
                super.setEnabled(bEnabled);
            } else {
                this.m_bReallyEnabled = bEnabled;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_action.actionPerformed(e);
        }

        public void dispose() {
        }
    }

    protected class cFocusListener
    implements FocusListener {
        protected cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            WANotesPreviewPane.this.m_actCut.setActive(true);
            WANotesPreviewPane.this.m_actCopy.setActive(true);
            WANotesPreviewPane.this.m_actPaste.setActive(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!WANotesPreviewPane.this.m_menuPopup.isShowing()) {
                WANotesPreviewPane.this.m_actCut.setActive(false);
                WANotesPreviewPane.this.m_actCopy.setActive(false);
                WANotesPreviewPane.this.m_actPaste.setActive(false);
            }
        }
    }

    protected class cPopupMenuListener
    extends MouseAdapter {
        protected cPopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && WANotesPreviewPane.this.m_pnlText.isEnabled()) {
                WANotesPreviewPane.this.m_menuPopup.show((Component)WANotesPreviewPane.this.m_pnlText, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && WANotesPreviewPane.this.m_pnlText.isEnabled()) {
                if (WANotesPreviewPane.this.m_pnlText.getSelectedText() == null) {
                    int newDot = WANotesPreviewPane.this.m_pnlText.getUI().viewToModel((JTextComponent)WANotesPreviewPane.this.m_pnlText, e.getPoint());
                    WANotesPreviewPane.this.m_pnlText.getCaret().setDot(newDot);
                }
                WANotesPreviewPane.this.m_menuPopup.show((Component)WANotesPreviewPane.this.m_pnlText, e.getX(), e.getY());
            }
        }
    }

    protected class cCaretMovedListener
    implements ChangeListener {
        protected cCaretMovedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (WANotesPreviewPane.this.m_pnlText.getSelectedText() != null) {
                if (WANotesPreviewPane.this.isEnabled()) {
                    WANotesPreviewPane.this.m_actCopy.setEnabled(true);
                    WANotesPreviewPane.this.m_actCut.setEnabled(WANotesPreviewPane.this.isEditable());
                }
                return;
            }
            WANotesPreviewPane.this.m_actCopy.setEnabled(false);
            WANotesPreviewPane.this.m_actCut.setEnabled(false);
        }

        protected boolean isAttribute(AttributeSet setAttrs, Object oAttribute) {
            Boolean bAttribute = (Boolean)setAttrs.getAttribute(oAttribute);
            return bAttribute != null && bAttribute != false;
        }
    }
}

