/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class WANoteSelectionDialog
extends WAStandardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(WANoteSelectionDialog.class);
    protected cNoteSelectionPanel m_pnlNotes;
    protected Vector m_vAddedNotes;
    protected String m_strIdsToRemove;

    public WANoteSelectionDialog(CMetadata metadata, String ids) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("WANoteSelectionDialog.Title.txt"), true);
        this.m_strIdsToRemove = ids;
        this.m_pnlNotes = new cNoteSelectionPanel(metadata);
        this.setMainPanel(this.m_pnlNotes);
        this.m_vAddedNotes = new Vector();
        this.setHelpProduct("shared");
        this.setHelpTopic("sel_note");
    }

    public Vector getSelections() {
        return this.m_vAddedNotes;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
    }

    public boolean onCancel() {
        return super.onCancel();
    }

    public class NoteSelectionModel
    extends WATableModel {
        protected CMetadata m_metadata = null;
        protected ArrayList m_cellChoices = new ArrayList();
        protected boolean[] isColumnEditable = new boolean[]{false, true};
        private boolean modelPopulated = false;
        private static final int TOTAL_COLS = 1;
        protected CMetadata m_Object;

        public NoteSelectionModel(CMetadata inObject) throws MdException, RemoteException {
            this.m_metadata = inObject;
            this.columnNames.add(bundle.getString("NoteSelectionModel.Column.txt"));
        }

        public void setupModel() {
            List<TextStore> vallNotes = new Vector();
            try {
                if (!this.modelPopulated) {
                    if (this.m_metadata != null) {
                        String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                        String reposID2 = null;
                        String sOptions = "<XMLSELECT Search=\"*[@TextRole='Note']\"/>";
                        if (Workspace.getWorkspace().getCheckinRepository() != null) {
                            reposID2 = Workspace.getWorkspace().getCheckinRepository().getFQID();
                        }
                        if (reposID2 != null) {
                            vallNotes = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_metadata.getObjectStore(), reposID2, "TextStore", 392, sOptions);
                        }
                        if (reposID2 != null && reposID != reposID2) {
                            List vallNotes2 = new Vector();
                            vallNotes2 = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_metadata.getObjectStore(), reposID, "TextStore", 392, sOptions);
                            for (int x = 0; x < vallNotes2.size(); ++x) {
                                TextStore noteTS = (TextStore)vallNotes2.get(x);
                                if (noteTS.getChangeState().length() != 0) continue;
                                vallNotes.add(noteTS);
                            }
                        }
                    }
                    this.modelPopulated = true;
                }
                for (int n = vallNotes.size(); n > 0; --n) {
                    TextStore tempTS = (TextStore)vallNotes.get(n - 1);
                    if (WANoteSelectionDialog.this.m_strIdsToRemove.indexOf(tempTS.getFQID()) <= -1) continue;
                    vallNotes.remove(tempTS);
                }
                for (int i = 0; i < vallNotes.size(); ++i) {
                    TextStore ts = (TextStore)vallNotes.get(i);
                    String s_noteName = ts.getName();
                    this.insertRow(s_noteName, ts);
                }
                if (this.data.size() > 0) {
                    this.fireTableRowsInserted(0, this.data.size() - 1);
                }
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }

        public int getColumnCount() {
            return 1;
        }

        public boolean insertRow(String s_noteName, TextStore o_textStore) {
            ++this.instanceCount;
            ArrayList<String> m = new ArrayList<String>();
            m.add(s_noteName);
            m.add((String)o_textStore);
            this.data.add(m);
            return true;
        }
    }

    class cNoteSelectionPanel
    extends WAPanel {
        protected WATable m_table;
        protected CMetadata m_metadata;
        protected NoteSelectionModel m_tableModel;
        protected JScrollPane m_tableScrollPane;
        final int SCROLL_PANE_WIDTH = 265;
        final int SCROLL_PANE_HEIGHT = 315;
        protected JLabel tempLabel;

        public cNoteSelectionPanel(CMetadata metadata) {
            this.m_metadata = metadata;
            this.initialize();
            this.layoutWidgets();
        }

        public void initialize() {
            try {
                this.m_tableModel = new NoteSelectionModel(this.m_metadata);
                this.m_table = new WATable((WATableModel)this.m_tableModel);
                this.m_table.setEditable(false);
                this.m_table.enableDefaultKeyTraversal(false);
                this.m_table.setSelectionMode(2);
                this.m_table.setAutoResizeMode(1);
                Border border = BorderFactory.createBevelBorder(1);
                this.m_tableScrollPane = new JScrollPane();
                this.m_tableScrollPane.getViewport().setView((Component)this.m_table);
                this.m_tableScrollPane.setVerticalScrollBarPolicy(20);
                this.m_tableScrollPane.setHorizontalScrollBarPolicy(30);
                this.m_tableScrollPane.setBorder(border);
                this.m_tableScrollPane.setPreferredSize(new Dimension(315, 315));
                this.m_tableScrollPane.setToolTipText(bundle.getString("WANoteSelectionDialog.TableToolTip.txt"));
                this.m_table.setToolTipText(bundle.getString("WANoteSelectionDialog.TableToolTip.txt"));
                this.m_table.setShowGrid(false);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "", 0);
            }
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_tableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(false);
            this.m_table.setEditable(false);
        }

        public boolean doDataExchange(boolean bsaveToModel) throws MdException, RemoteException {
            if (!bsaveToModel) {
                this.m_tableModel.setupModel();
                this.m_table.enableSorting(true);
                this.m_table.sort(0, true);
            }
            return true;
        }

        public boolean validateData() {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < this.m_table.getSelectedRowCount(); ++i) {
                TextStore o_addedTS = (TextStore)this.m_tableModel.getValueAt(selectedRows[i], 1);
                WANoteSelectionDialog.this.m_vAddedNotes.add(o_addedTS);
            }
            return true;
        }

        public boolean hasDataChanged() {
            return false;
        }
    }
}

