/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.OMRDocument;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.model.DocumentTableModel;
import com.sas.wadmin.visuals.DocumentTreeNode;
import com.sas.wadmin.visuals.WADocumentSelectionDialog;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.visuals.BaseTableMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FilenameFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class WADocumentPane
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(WADocumentPane.class);
    WATable m_tblDocuments;
    JScrollPane m_scrDocuments;
    DocumentTableModel m_mdlDocuments;
    JLabel m_lblDocuments;
    JButton m_btnNew;
    JButton m_btnDelete;
    JButton m_btnAttach;
    WsAbstractAction m_actNew;
    WsAbstractAction m_actDelete;
    WsAbstractAction m_actAttach;
    protected Root m_oMetadata = null;
    boolean updateDoc = false;
    boolean stillDisplay = true;
    DocPopup dPop = null;
    TableEditListener tel = null;
    boolean lastClicked = false;
    private static final String PUBLICTYPE_DOCUMENT = "Document";

    public WADocumentPane(Root oMetadata) {
        this.m_oMetadata = oMetadata;
        this.initialize();
        this.layoutWidgets();
    }

    public boolean validateData() {
        if (!this.updateDoc) {
            return true;
        }
        this.updateDoc = false;
        for (int i = 0; i < this.m_mdlDocuments.getRowCount(); ++i) {
            String URL2 = (String)this.m_mdlDocuments.getValueAt(i, 1);
            if (URL2 != null && !URL2.equals("")) continue;
            this.m_tblDocuments.clearSelection();
            JOptionPane.showMessageDialog((Component)((Object)this), bundle.getString("WADocumentPane.urlerror.txt"), bundle.getString("WADocumentPane.error.txt"), 0);
            this.m_tblDocuments.editCellAt(i, 1);
            URLCellEditor uce = (URLCellEditor)this.m_tblDocuments.getCellEditor();
            JTextField j = (JTextField)uce.getComponent();
            j.requestFocus();
            return false;
        }
        boolean duplicateNameWarnings = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("Workspace.EnableDuplicateNameWarnings", false);
        if (duplicateNameWarnings) {
            int changeDuplicateName;
            ArrayList<String> documentNameConflicts = new ArrayList<String>();
            for (int i = 0; i < this.m_mdlDocuments.getRowCount(); ++i) {
                String name = (String)this.m_mdlDocuments.getValueAt(i, 0);
                Document doc = (Document)this.m_mdlDocuments.getValueAt(i, 2);
                boolean nameConflictOnServer = doc != null ? !WsMetadataNameUtil.isNameUnique((Root)doc, (String)name) : !WsMetadataNameUtil.isNameUnique((String)PUBLICTYPE_DOCUMENT, (String)name);
                boolean nameConflictOnTab = false;
                for (int j = 0; j < this.m_mdlDocuments.getRowCount(); ++j) {
                    if (i == j || !this.m_mdlDocuments.getValueAt(j, 0).equals(name)) continue;
                    nameConflictOnTab = true;
                    break;
                }
                if (!nameConflictOnServer && !nameConflictOnTab) continue;
                documentNameConflicts.add(name);
            }
            if (documentNameConflicts.isEmpty()) {
                return true;
            }
            if (documentNameConflicts.size() == 1) {
                changeDuplicateName = MessageUtil.displayMessage((String)bundle.formatString("WADocumentPane.Error.OneDuplicateName.fmt.txt", documentNameConflicts.get(0)), (String)bundle.getString("Common.DuplicateNameWarning.txt"), (int)2, (int)0);
                return changeDuplicateName != 0;
            }
            Collections.sort(documentNameConflicts);
            changeDuplicateName = MessageUtil.displayListMessage((String)bundle.getString("WADocumentPane.Error.ManyDuplicateNames.txt"), documentNameConflicts, (String)bundle.getString("Common.DuplicateNameWarning.txt"), (int)2, (int)0);
            return changeDuplicateName != 0;
        }
        return true;
    }

    public boolean moveDataToModel() {
        try {
            if (this.hasDataChanged()) {
                AssociationList alDocuments = this.m_oMetadata.getDocuments(false);
                alDocuments.removeAllElements();
                int nDocuments = this.m_mdlDocuments.getRowCount();
                for (int iDocument = 0; iDocument < nDocuments; ++iDocument) {
                    Document oDoc;
                    Object obj = this.m_mdlDocuments.getValueAt(iDocument, 2);
                    String sName = (String)this.m_mdlDocuments.getValueAt(iDocument, 0);
                    String sURL = (String)this.m_mdlDocuments.getValueAt(iDocument, 1);
                    if (obj == null || obj instanceof String) {
                        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                        oDoc = (Document)factory.createComplexMetadataObject(this.m_oMetadata.getObjectStore(), null, sName, PUBLICTYPE_DOCUMENT, this.m_oMetadata.getRepositoryID(), null);
                        oDoc.setURI(sURL);
                        oDoc.setPublicType(PUBLICTYPE_DOCUMENT);
                        oDoc.setUsageVersion(OMRDocument.CURRENT_VERSION.encode());
                        Tree oGroup = AbstractDesigner.getDefaultGroup((MdObjectStore)((MdObjectStore)this.m_oMetadata.getObjectStore()), (CMetadata)Workspace.getWorkspace().getDefaultRepository(), (String)"Documents");
                        oDoc.getTrees().add((Object)oGroup);
                        this.m_mdlDocuments.setValueAt(oDoc, iDocument, 2);
                    } else {
                        oDoc = (Document)obj;
                        if (!sName.equals(oDoc.getName())) {
                            oDoc.setName(sName);
                        }
                        if (!sURL.equals(oDoc.getURI())) {
                            oDoc.setURI(sURL);
                        }
                    }
                    alDocuments.add((Object)oDoc);
                }
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return true;
    }

    public boolean moveDataToUI() {
        this.m_mdlDocuments.populate(this.m_oMetadata);
        return true;
    }

    public void populateData() throws MdException, RemoteException {
        this.m_mdlDocuments.populateData(this.m_oMetadata);
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            if (!bSaveToModel) {
                this.populateData();
                this.moveDataToUI();
            } else {
                this.moveDataToModel();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
        return true;
    }

    public boolean doLocalDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            if (!bSaveToModel) {
                this.moveDataToUI();
            } else {
                this.moveDataToModel();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
        return true;
    }

    public ArrayList getDocuments() {
        ArrayList<Document> alDocuments = new ArrayList<Document>();
        try {
            int nDocuments = this.m_mdlDocuments.getRowCount();
            for (int iDocument = 0; iDocument < nDocuments; ++iDocument) {
                Document oDoc = (Document)this.m_mdlDocuments.getValueAt(iDocument, 2);
                String sName = (String)this.m_mdlDocuments.getValueAt(iDocument, 0);
                String sURL = (String)this.m_mdlDocuments.getValueAt(iDocument, 1);
                if (oDoc == null) {
                    MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
                    oDoc = (Document)factory.createComplexMetadataObject(this.m_oMetadata.getObjectStore(), null, sName, PUBLICTYPE_DOCUMENT, this.m_oMetadata.getRepositoryID(), null);
                    oDoc.setURI(sURL);
                    Tree oGroup = AbstractDesigner.getDefaultGroup((MdObjectStore)((MdObjectStore)this.m_oMetadata.getObjectStore()), (CMetadata)Workspace.getWorkspace().getDefaultRepository(), (String)"Documents");
                    oDoc.getTrees().add((Object)oGroup);
                    this.m_mdlDocuments.setValueAt(oDoc, iDocument, 2);
                } else {
                    if (!sName.equals(oDoc.getName())) {
                        oDoc.setName(sName);
                    }
                    if (!sURL.equals(oDoc.getURI())) {
                        oDoc.setURI(sURL);
                    }
                }
                alDocuments.add(oDoc);
            }
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return alDocuments;
    }

    public WsAbstractAction getDeleteAction() {
        return this.m_actDelete;
    }

    protected void initialize() {
        this.createActions();
        this.m_mdlDocuments = new DocumentTableModel();
        this.m_tblDocuments = new WATable((WATableModel)this.m_mdlDocuments);
        this.m_tblDocuments.setAutoResizeMode(1);
        this.m_tblDocuments.setCellSelectionEnabled(true);
        this.m_tblDocuments.getTableHeader().setReorderingAllowed(false);
        this.m_tblDocuments.hideColumn(2);
        this.m_tblDocuments.setRowHeight((int)((double)this.m_tblDocuments.getRowHeight() * 1.2));
        this.m_lblDocuments = new JLabel(bundle.getString("WANotesPropertyTab.documents.assigned.txt"));
        this.m_lblDocuments.setDisplayedMnemonic(bundle.getString("WANotesPropertyTab.documents.assigned.mnem").charAt(0));
        this.m_lblDocuments.setLabelFor((Component)this.m_tblDocuments);
        TableColumn foo = this.m_tblDocuments.getColumnModel().getColumn(0);
        foo.setPreferredWidth(205);
        foo = this.m_tblDocuments.getColumnModel().getColumn(1);
        foo.setPreferredWidth(375);
        foo.setCellRenderer(new PathCellRenderer());
        this.m_tblDocuments.addMouseListener((MouseListener)new DocClickListener());
        this.dPop = new DocPopup(this.m_tblDocuments);
        this.m_tblDocuments.addMouseListener((MouseListener)((Object)this.dPop));
        TableColumn tc1 = this.m_tblDocuments.getColumnModel().getColumn(0);
        WATextField tf2 = new WATextField();
        tf2.setBorder((Border)new LineBorder(Color.black));
        tf2.setMaxCharacters(60);
        DefaultCellEditor dce = new DefaultCellEditor((JTextField)tf2);
        dce.addCellEditorListener(new DocCellEditListener());
        dce.setClickCountToStart(1);
        tc1.setCellEditor(dce);
        JTextField tf1 = new JTextField();
        tf1.setBorder(new LineBorder(Color.black));
        URLCellEditor uce = new URLCellEditor();
        TableColumn tc2 = this.m_tblDocuments.getColumnModel().getColumn(1);
        uce.addCellEditorListener(new DocCellEditListener());
        tc2.setCellEditor(uce);
        this.tel = new TableEditListener();
        for (int i = 0; i < this.m_tblDocuments.getColumnCount(); ++i) {
            TableCellEditor ce = this.m_tblDocuments.getCellEditor(0, i);
            ce.addCellEditorListener(this.tel);
        }
        this.m_tblDocuments.getActionMap().put(this.m_actDelete, (Action)this.m_actDelete);
        this.m_tblDocuments.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
        this.m_btnNew = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actNew);
        this.m_btnDelete = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actDelete);
        this.m_btnAttach = WsUIUtilities.createTextButton((WsAbstractAction)this.m_actAttach);
        this.m_tblDocuments.getSelectionModel().addListSelectionListener(new DocCellListener());
        this.m_mdlDocuments.addTableModelListener(new DocTableModelListener());
    }

    protected void createActions() {
        this.m_actNew = this.createNewAction();
        this.m_actDelete = this.createDeleteAction();
        this.m_actAttach = this.createAttachAction();
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createAttachAction() {
        return new cAttachAction();
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(bundle.getString("WANotesPropertyTab.docString.txt")));
        this.m_scrDocuments = new JScrollPane((Component)this.m_tblDocuments);
        this.m_scrDocuments.addMouseListener((MouseListener)((Object)this.dPop));
        this.m_tblDocuments.setToolTipText(bundle.getString("WANotesPropertyTab.docTip.txt"));
        this.m_scrDocuments.setToolTipText(bundle.getString("WANotesPropertyTab.docTip.txt"));
        JPanel pnlButtons = new JPanel((LayoutManager)new WsButtonsLayout());
        pnlButtons.add(this.m_btnNew);
        pnlButtons.add(this.m_btnDelete);
        pnlButtons.add(this.m_btnAttach);
        this.add(this.m_lblDocuments, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_scrDocuments, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(pnlButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actNew.setActive(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_tblDocuments.setEditable(bEditable);
        this.m_actNew.setEnabled(bEditable);
        this.m_actDelete.setEnabled(bEditable && this.m_tblDocuments.getSelectedRows().length > 0);
        this.m_actAttach.setEnabled(bEditable);
    }

    public void addDocFocusListener(FocusListener f) {
        URLCellEditor uce;
        this.m_tblDocuments.addFocusListener(f);
        DefaultCellEditor dce = (DefaultCellEditor)this.m_tblDocuments.getCellEditor(0, 0);
        if (dce != null) {
            dce.getComponent().addFocusListener(f);
        }
        if ((uce = (URLCellEditor)this.m_tblDocuments.getCellEditor(0, 1)) != null) {
            uce.getComponent().addFocusListener(f);
        }
    }

    protected void doNew() {
        WAUndoable wau = this.m_mdlDocuments.undoableInsertBlankRow(this.m_tblDocuments.getRowCount());
        this.waum.addEdit((UndoableEdit)wau);
        this.updateDoc = true;
        this.m_tblDocuments.editCellAt(this.m_tblDocuments.getRowCount() - 1, 0);
        this.m_mdlDocuments.setValueAt(null, this.m_tblDocuments.getRowCount() - 1, 2);
    }

    protected void doAttach() {
        try {
            int inumDocs = this.m_mdlDocuments.getRowCount();
            String s_ids = "";
            for (int x = 0; x < inumDocs; ++x) {
                Document tempDoc = (Document)this.m_mdlDocuments.getValueAt(x, 2);
                if (tempDoc == null) continue;
                s_ids = s_ids + tempDoc.getFQID();
                String changeState = tempDoc.getChangeState();
                if (changeState.length() <= 0) continue;
                s_ids = s_ids + changeState.substring(11);
            }
            WADocumentSelectionDialog docDlg = new WADocumentSelectionDialog((CMetadata)this.m_oMetadata, s_ids);
            docDlg.show();
            Vector v_newadds = docDlg.getSelections();
            for (int i = 0; i < v_newadds.size(); ++i) {
                Document o_addedTS = (Document)v_newadds.elementAt(i);
                WAUndoable wau = this.m_mdlDocuments.undoableInsertRow(o_addedTS);
                this.getWAUndoManager().addEdit((UndoableEdit)wau);
                this.setDataChanged(true);
            }
            if (v_newadds.size() > 0) {
                this.m_tblDocuments.editCellAt(this.m_mdlDocuments.getRowCount() - 1, 0);
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected void doDelete() {
        try {
            TableCellEditor ce = this.m_tblDocuments.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            int[] index = this.m_tblDocuments.getSelectedRows();
            Arrays.sort(index);
            CompoundEdit c = new CompoundEdit();
            for (int i = index.length - 1; i >= 0; --i) {
                Object obj = this.m_mdlDocuments.getValueAt(index[i], 2);
                if (obj != null || obj instanceof Document) {
                    Document doc = (Document)obj;
                    ((MdObjectStore)this.m_oMetadata.getObjectStore()).deleteObjectFromStore(doc.getFQID());
                    if (doc.getFQID().indexOf("$") != -1) {
                        doc.delete();
                    }
                }
                WAUndoable wau = this.m_mdlDocuments.undoableDeleteRow(index[i]);
                this.updateDoc = true;
                c.addEdit((UndoableEdit)wau);
            }
            c.end();
            this.waum.addEdit((UndoableEdit)c);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    protected class cAttachAction
    extends WsAbstractAction {
        public cAttachAction() {
            super(bundle, "WADocumentPane.Attach");
        }

        public void actionPerformed(ActionEvent e) {
            WADocumentPane.this.doAttach();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        public cDeleteAction() {
            super(bundle, "WADocumentPane.Delete", 544);
            this.setMenuSupportId("delete");
        }

        public void actionPerformed(ActionEvent e) {
            WADocumentPane.this.doDelete();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        public cNewAction() {
            super(bundle, "WADocumentPane.New", 544);
            this.setMenuSupportId("newdoc");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            WADocumentPane.this.doNew();
        }
    }

    class DocTableModelListener
    implements TableModelListener {
        DocTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            WADocumentPane.this.setDataChanged(true);
        }
    }

    class TableEditListener
    implements CellEditorListener {
        boolean postDlg = true;

        TableEditListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent ce) {
        }

        @Override
        public void editingStopped(ChangeEvent ce) {
            if (WADocumentPane.this.m_mdlDocuments.getUndoableSet()) {
                WAUndoable wau = WADocumentPane.this.m_mdlDocuments.getPersistedUndo();
                if (wau != null) {
                    Object newV;
                    Object oldV;
                    if (wau instanceof WATableModel.UndoableSet && !(oldV = ((WATableModel.UndoableSet)wau).getOldValue()).equals(newV = ((WATableModel.UndoableSet)wau).getNewValue())) {
                        WADocumentPane.this.waum.addEdit((UndoableEdit)wau);
                    }
                    WADocumentPane.this.m_mdlDocuments.resetUndoableSet();
                    WADocumentPane.this.m_mdlDocuments.resetPersistedUndo();
                } else if (this.postDlg) {
                    this.postDlg = false;
                    JOptionPane.showMessageDialog((Component)((Object)WADocumentPane.this), bundle.getString("WADocumentPane.nameError.txt"), bundle.getString("WADocumentPane.nameErrorTitle.txt"), 0);
                    int row = WADocumentPane.this.m_tblDocuments.getSelectedRow();
                    WADocumentPane.this.m_tblDocuments.clearSelection();
                    WADocumentPane.this.m_tblDocuments.setCellEditor(null);
                    WADocumentPane.this.m_tblDocuments.editCellAt(row, 0);
                }
            }
        }
    }

    class DocPopup
    extends BaseTableMenu {
        public DocPopup(WATable p) {
            super(p);
            JMenuItem jmItem = new JMenuItem(bundle.getString("Common.Edit.txt"));
            jmItem.setMnemonic(bundle.getString("Common.Edit.mnem").charAt(0));
            jmItem.setActionCommand("editCell");
            jmItem.addActionListener((ActionListener)((Object)this));
            this.pMenu.insert(jmItem, 2);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("delRow")) {
                WADocumentPane.this.doDelete();
            } else if (e.getActionCommand().equals("new")) {
                WADocumentPane.this.doNew();
            } else if (e.getActionCommand().equals("editCell")) {
                int r = this.parent.rowAtPoint(this.currentPoint);
                int c = this.parent.columnAtPoint(this.currentPoint);
                this.parent.editCellAt(r, c);
            }
        }

        public void postPopup(int x, int y) {
            TableCellEditor ce = this.parent.getCellEditor();
            if (ce != null && this.parent.isEditing()) {
                ce.stopCellEditing();
            }
            Point p = new Point(x, y);
            int r = this.parent.rowAtPoint(p);
            int c = this.parent.columnAtPoint(p);
            if (r == -1 || c == -1) {
                this.pMenu.getComponent(2).setEnabled(false);
            } else {
                this.pMenu.getComponent(2).setEnabled(true);
            }
            if (r == -1) {
                this.pMenu.getComponent(1).setEnabled(false);
            } else {
                this.pMenu.getComponent(1).setEnabled(true);
            }
            if (r != -1) {
                this.parent.changeSelection(r, c, false, false);
                this.parent.setColumnSelectionInterval(0, this.parent.getColumnCount() - 1);
            } else {
                this.parent.clearSelection();
            }
            super.postPopup(x, y);
        }
    }

    class URLCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    ItemListener,
    FocusListener {
        boolean tflag = false;
        boolean bflag = false;
        int clickCount = 2;
        URLField jtf = new URLField();
        URLButton jb = null;
        JPanel c = null;

        public URLCellEditor() {
            this.jtf.setMaxCharacters(256);
            String text = bundle.getString("WADocumentPane.Path.FindButton.txt");
            String textWithoutMnem = Util.getLabelWithoutMnemonic((String)text);
            int index = Util.getDisplayedMnemonicIndex((String)text);
            this.jb = new URLButton(textWithoutMnem);
            if (index > -1) {
                int mnemonic = Util.getDisplayedMnemonic((String)text);
                this.jb.setMnemonic(mnemonic);
                this.jb.setDisplayedMnemonicIndex(index);
            }
            this.jb.setMargin(new Insets(5, 2, 7, 2));
            this.c = new JPanel(new BorderLayout());
            this.c.add((Component)((Object)this.jtf), "West");
            this.c.add((Component)this.jb, "East");
            this.jtf.addActionListener(this);
            this.jb.addActionListener(this);
            this.jb.addFocusListener(this);
            this.jtf.addFocusListener(this);
            this.c.addFocusListener(this);
            WADocumentPane.this.addFocusListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                String s = (String)value;
                this.jtf.setText(s);
            } else {
                this.jtf.setText("");
            }
            this.jtf.setBorder(new LineBorder(Color.black));
            int cWidth = table.getColumnModel().getColumn(column).getWidth();
            int adjWidth = 0;
            adjWidth = this.jb.getWidth() == 0 ? cWidth - 40 : cWidth - this.jb.getWidth();
            this.jtf.setPreferredSize(new Dimension(adjWidth, table.getRowHeight()));
            this.jtf.requestFocus();
            return this.c;
        }

        public Component getComponent() {
            return this.jtf;
        }

        @Override
        public Object getCellEditorValue() {
            return this.jtf.getText();
        }

        @Override
        public boolean isCellEditable(EventObject eo) {
            if (eo instanceof MouseEvent) {
                return ((MouseEvent)eo).getClickCount() >= this.clickCount;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.bflag = true;
            this.tflag = true;
            Object o = e.getSource();
            if (o instanceof JTextField) {
                this.stopCellEditing();
            } else {
                FileDialog jfc = null;
                jfc = new FileDialog((Frame)Workspace.getWorkspace());
                jfc.setFilenameFilter(new BrowseFilter());
                jfc.setDirectory(Workspace.getWorkspace().getDefaultPath());
                jfc.setMode(0);
                jfc.show();
                String uFile = jfc.getFile();
                if (uFile != null) {
                    String uDir = jfc.getDirectory();
                    String whole = uDir + uFile;
                    if (whole != null) {
                        Workspace.getWorkspace().setDefaultPath(jfc.getDirectory().toString());
                        this.jtf.setText(whole);
                    }
                    this.jtf.requestFocus();
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.stopCellEditing();
        }

        @Override
        public void focusLost(FocusEvent e) {
            TableCellEditor ce;
            Object o = e.getSource();
            if (o instanceof JButton) {
                this.bflag = false;
                if (!this.tflag && (ce = WADocumentPane.this.m_tblDocuments.getCellEditor()) != null) {
                    ce.stopCellEditing();
                }
            }
            if (o instanceof JTextField) {
                this.tflag = false;
                if (!this.bflag && (ce = WADocumentPane.this.m_tblDocuments.getCellEditor()) != null) {
                    ce.stopCellEditing();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object o = e.getSource();
            if (o instanceof JPanel) {
                this.jtf.requestFocus();
            }
        }

        class URLField
        extends WATextField {
            URLField() {
            }

            public boolean isFocusable() {
                URLCellEditor.this.tflag = true;
                return super.isFocusable();
            }
        }

        class URLButton
        extends JButton {
            public URLButton(String text) {
                super(text);
            }

            @Override
            public boolean isFocusable() {
                URLCellEditor.this.bflag = true;
                return super.isFocusable();
            }

            @Override
            public boolean isRequestFocusEnabled() {
                URLCellEditor.this.bflag = true;
                return super.isRequestFocusEnabled();
            }
        }
    }

    class EThread
    extends Thread {
        long milliSecs = 0L;
        int row = 0;

        public EThread(long waitSecs, int r) {
            this.milliSecs = waitSecs;
            this.row = r;
        }

        @Override
        public void run() {
            String loc = (String)WADocumentPane.this.m_mdlDocuments.getValueAt(this.row, 1);
            try {
                EThread.sleep(this.milliSecs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (WADocumentPane.this.stillDisplay && !WADocumentPane.this.m_tblDocuments.isEditing()) {
                DocumentTreeNode.displayURL(loc);
            }
        }
    }

    class BrowseFilter
    implements FilenameFilter {
        BrowseFilter() {
        }

        @Override
        public boolean accept(File f, String s) {
            if (f.isDirectory()) {
                return true;
            }
            if (s == null) {
                return false;
            }
            if (s.endsWith("html")) {
                return true;
            }
            return s.endsWith("htm");
        }
    }

    class PathCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            StringBuffer buf = new StringBuffer();
            if (isSelected) {
                buf.append((String)value);
            } else {
                buf.append((String)value);
            }
            this.setText(buf.toString());
            if (isSelected) {
                super.setForeground(Color.yellow);
                super.setBackground(SystemColor.textHighlight);
            } else {
                super.setForeground(Color.blue);
                super.setBackground(table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }
    }

    class URLCellRenderer
    extends DefaultTableCellRenderer {
        public URLCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            JTableHeader foo = WADocumentPane.this.m_tblDocuments.getTableHeader();
            this.setForeground(foo.getForeground());
            this.setBackground(foo.getBackground());
            this.setFont(foo.getFont());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText("...");
            this.setFont(table.getFont());
            Color back = this.getBackground();
            boolean colorMatch = back != null && back.equals(table.getBackground()) && table.isOpaque();
            this.setOpaque(!colorMatch);
            return this;
        }
    }

    class DocCellEditListener
    implements CellEditorListener {
        DocCellEditListener() {
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            WADocumentPane.this.stillDisplay = true;
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            WADocumentPane.this.updateDoc = true;
            WADocumentPane.this.stillDisplay = true;
        }
    }

    class DocClickListener
    extends MouseAdapter {
        DocClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isShiftDown() || e.isControlDown()) {
                return;
            }
            int row = WADocumentPane.this.m_tblDocuments.rowAtPoint(e.getPoint());
            int col = WADocumentPane.this.m_tblDocuments.columnAtPoint(e.getPoint());
            if (col != 1) {
                return;
            }
            if (WADocumentPane.this.m_tblDocuments.isCellSelected(row, WADocumentPane.this.m_tblDocuments.convertColumnIndexToModel(1))) {
                String loc = (String)WADocumentPane.this.m_mdlDocuments.getValueAt(row, 1);
                if (e.getClickCount() >= 2 || loc.length() == 0) {
                    WADocumentPane.this.m_tblDocuments.clearSelection();
                    WADocumentPane.this.stillDisplay = false;
                    WADocumentPane.this.m_tblDocuments.editCellAt(row, 1);
                    URLCellEditor tce = (URLCellEditor)WADocumentPane.this.m_tblDocuments.getCellEditor(row, 1);
                    Component c = tce.getComponent();
                    if (c instanceof JTextField) {
                        c.requestFocus();
                    }
                } else {
                    EThread elmo = new EThread(1000L, row);
                    elmo.start();
                }
            }
        }
    }

    class DocCellListener
    implements ListSelectionListener {
        DocCellListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WADocumentPane.this.m_actDelete.setEnabled(WADocumentPane.this.isEditable() && WADocumentPane.this.m_tblDocuments.getSelectedRows().length > 0);
        }
    }
}

