/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsForwardInputMap;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class WADialogObjectTableCellEditor2
extends WsDefaultCellEditor {
    private static WAdminResource bundle = WAdminResource.getBundle(WADialogObjectTableCellEditor2.class);
    public static final int CUSTOM = -1;
    public static final int FOLDER = 0;
    public static final int JOB = 1;
    public static final int LIBRARY = 2;
    public static final int TABLE = 3;
    public static final int COLUMN = 4;
    public static final int NOTE = 5;
    public static final int DOCUMENT = 6;
    public static final int FILE = -5;
    protected JTable m_tbl;
    protected int m_iRow;
    protected int m_iColumn;
    protected JPanel m_pnl;
    protected JButton m_btn = WsUIUtilities.createBrowseButton();
    protected WATextField m_txt;
    protected boolean m_bStopEditingOnDialogClose;
    private int m_objectType;
    private boolean m_browseDirectories = false;
    private boolean m_returnObjects = true;
    private IModel m_model;
    private Object m_data = null;

    public WADialogObjectTableCellEditor2() {
        this.m_btn.addActionListener(new cShowDialogAction());
        cBackTabAction actBackTab = new cBackTabAction();
        this.m_btn.getActionMap().put(actBackTab, actBackTab);
        this.m_btn.getInputMap().put(KeyStroke.getKeyStroke(9, 1), actBackTab);
        this.m_txt = new WATextField();
        this.initialize(this.m_txt, new cBrowsableTextFieldDelegate());
        cTabAction actTab = new cTabAction();
        this.m_txt.getActionMap().put(actTab, actTab);
        this.m_txt.getInputMap().put(KeyStroke.getKeyStroke(9, 0), actTab);
        this.m_pnl = new JPanel(new BorderLayout()){

            @Override
            public void requestFocus() {
                WADialogObjectTableCellEditor2.this.m_txt.requestFocus();
            }
        };
        this.m_pnl.add((Component)this.m_txt, "Center");
        this.m_pnl.add((Component)this.m_btn, "East");
        WsForwardInputMap.install((JComponent)this.m_pnl, (JComponent)this.m_txt);
        this.m_cmpEditor = this.m_pnl;
    }

    public WADialogObjectTableCellEditor2(IModel model) {
        this();
        this.m_model = model;
    }

    public WADialogObjectTableCellEditor2(int objectType) {
        this();
        this.setSelectionType(objectType);
    }

    public WADialogObjectTableCellEditor2(IModel model, int objectType) {
        this(model);
        this.setSelectionType(objectType);
    }

    public WADialogObjectTableCellEditor2(IModel model, int objectType, boolean returnObjects) {
        this(model, objectType);
        this.setReturnObjects(returnObjects);
    }

    public void setBrowseDirectories(boolean browseDirectories) {
        this.m_browseDirectories = browseDirectories;
    }

    public void setSelectionType(int objectType) {
        this.m_objectType = objectType;
    }

    public void setTextFieldEditable(boolean editable) {
        this.m_txt.setEditable(editable);
    }

    public void setReturnObjects(boolean returnObjects) {
        this.m_returnObjects = returnObjects;
    }

    public boolean getReturnObjects() {
        return this.m_returnObjects;
    }

    public void setMaxCharacters(int nMaxCharacters) {
        this.m_txt.setMaxCharacters(nMaxCharacters);
    }

    public int getMaxCharacters() {
        return this.m_txt.getMaxCharacters();
    }

    private void setText(String text) {
        this.m_txt.setText(text);
    }

    private void setData(Object data) {
        this.m_data = data;
        this.setText(this.getDisplayTextForObject(data));
    }

    private String getText() {
        return this.m_txt.getText();
    }

    private Object getData() {
        return this.m_data;
    }

    public void setStopEditingOnDialogClose(boolean bStopEditingOnDialogClose) {
        this.m_bStopEditingOnDialogClose = bStopEditingOnDialogClose;
    }

    public boolean isStopEditingOnDialogClose() {
        return this.m_bStopEditingOnDialogClose;
    }

    protected String getDisplayTextForObject(Object value) {
        String text = "";
        try {
            if (value instanceof IComplexPersistableObject) {
                text = ((IComplexPersistableObject)value).getName();
            } else if (value instanceof Root) {
                text = ((Root)value).getName();
            } else if (value != null) {
                text = value.toString();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IComplexPersistableObject getModelObjectFromSimpleObject(SimpleObject meta) throws MdException, RemoteException {
        IComplexPersistableObject modelObject = null;
        if (meta != null) {
            OMRAdapter omr = null;
            try {
                modelObject = (IComplexPersistableObject)this.m_model.getObject(meta.getID());
                if (modelObject == null) {
                    omr = new OMRAdapter(this.m_model, Workspace.getMdFactory(), "WADialogObjectTableCellEditor");
                    Root root = omr.acquireOMRObject(meta.getID(), meta.getMetadataType());
                    modelObject = (IComplexPersistableObject)omr.acquireObjectUsingTemplate(root);
                }
            }
            finally {
                if (omr != null) {
                    omr.dispose();
                }
            }
        }
        return modelObject;
    }

    protected class cShowDialogAction
    extends AbstractAction {
        protected cShowDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WADialogObjectTableCellEditor2.this.m_objectType == -5) {
                LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
                fileTypes.put(bundle.getString("WADialogObjectTableCellEditor.AllFileTypes.txt"), "*");
                WADialogObjectTableCellEditor2.this.m_txt.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer wsAppServer = WsAppServer.createDefaultAppServer();
                String selection = "";
                try {
                    selection = WADialogObjectTableCellEditor2.this.m_browseDirectories ? wsAppServer.promptForDirectory(bundle.getString("WADialogObjectTableCellEditor.RemoteFileSelectorDirectory.Title.txt"), WADialogObjectTableCellEditor2.this.getText(), fileTypes) : wsAppServer.promptForFilename(bundle.getString("WADialogObjectTableCellEditor.RemoteFileSelector.Title.txt"), WADialogObjectTableCellEditor2.this.getText(), fileTypes);
                }
                catch (WsAppServerFailException exc) {
                    WADialogObjectTableCellEditor2.this.m_txt.setCursor(Cursor.getDefaultCursor());
                    MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                    return;
                }
                catch (GenericError err) {
                    WADialogObjectTableCellEditor2.this.m_txt.setCursor(Cursor.getDefaultCursor());
                    MessageUtil.displayMessage((String)err.getLocalizedMessage(), (int)0);
                    return;
                }
                WADialogObjectTableCellEditor2.this.m_txt.setCursor(Cursor.getDefaultCursor());
                if (selection != null) {
                    WADialogObjectTableCellEditor2.this.setText(selection);
                }
            } else {
                UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
                String type = bundle.getString("WADialogObjectTableCellEditor.Types.Object.txt");
                if (3 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Table.txt");
                } else if (2 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Library.txt");
                } else if (5 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Note.txt");
                } else if (4 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Column.txt");
                } else if (0 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Folder.txt");
                } else if (1 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Job.txt");
                } else if (6 == WADialogObjectTableCellEditor2.this.m_objectType) {
                    type = bundle.getString("WADialogObjectTableCellEditor.Types.Document.txt");
                }
                String sSelectDialogTitle = bundle.formatString("WADialogObjectTableCellEditor.SelectionType.title.txt", (Object)type);
                ObjectSelectorPanel pnl = new ObjectSelectorPanel(userContext, 2, null, true);
                pnl.setSelectionOptional(true);
                IComplexPersistableObject data = (IComplexPersistableObject)WADialogObjectTableCellEditor2.this.getData();
                if (data != null) {
                    pnl.setSelectedObject((SimpleObject)data);
                }
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sSelectDialogTitle, true, (WAPanel)pnl);
                dlg.setResizable(true);
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    SimpleObject newObject = pnl.getSelectedObject();
                    if (newObject != null) {
                        try {
                            WADialogObjectTableCellEditor2.this.setData(WADialogObjectTableCellEditor2.this.getModelObjectFromSimpleObject(newObject));
                        }
                        catch (MdException ex) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException((RemoteException)ex);
                        }
                    } else {
                        WADialogObjectTableCellEditor2.this.setData(null);
                    }
                }
                if (WADialogObjectTableCellEditor2.this.m_bStopEditingOnDialogClose) {
                    WADialogObjectTableCellEditor2.this.stopCellEditing();
                } else {
                    WADialogObjectTableCellEditor2.this.m_txt.requestFocus();
                }
            }
        }
    }

    protected class cTabAction
    extends AbstractAction {
        protected cTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WADialogObjectTableCellEditor2.this.m_btn.requestFocus();
        }
    }

    protected class cBackTabAction
    extends AbstractAction {
        protected cBackTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WADialogObjectTableCellEditor2.this.m_txt.requestFocus();
        }
    }

    protected class cBrowsableTextFieldDelegate
    extends WsDefaultCellEditor.cEditorDelegate {
        public cBrowsableTextFieldDelegate() {
            super((WsDefaultCellEditor)WADialogObjectTableCellEditor2.this);
        }

        public void setValue(Object value) {
            if (value instanceof IComplexPersistableObject) {
                WADialogObjectTableCellEditor2.this.setData(value);
            }
        }

        public Object getValue() {
            if (WADialogObjectTableCellEditor2.this.getReturnObjects()) {
                String txt = WADialogObjectTableCellEditor2.this.getText();
                if ("".equals(txt)) {
                    WADialogObjectTableCellEditor2.this.setData(null);
                    return null;
                }
                return WADialogObjectTableCellEditor2.this.getData();
            }
            return WADialogObjectTableCellEditor2.this.getText();
        }

        public void layout(JTable table, int iRow, int iColumn) {
            WADialogObjectTableCellEditor2.this.m_tbl = table;
            WADialogObjectTableCellEditor2.this.m_iRow = iRow;
            WADialogObjectTableCellEditor2.this.m_iColumn = iColumn;
        }
    }
}

