/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsForwardInputMap;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class WADialogObjectTableCellEditor
extends WsDefaultCellEditor {
    private static WAdminResource bundle = WAdminResource.getBundle(WADialogObjectTableCellEditor.class);
    protected JTable m_tbl;
    protected int m_iRow;
    protected int m_iColumn;
    protected JPanel m_pnl;
    protected JButton m_btn = WsUIUtilities.createBrowseButton();
    protected WATextField m_txt;
    protected boolean m_bStopEditingOnDialogClose;
    private String m_objectType;
    private boolean m_browseDirectories = false;
    private boolean m_returnObjects = true;
    private MdObjectStore m_mdStore;
    private Object m_data = null;

    public WADialogObjectTableCellEditor() {
        this.m_btn.addActionListener(new cShowDialogAction());
        cBackTabAction actBackTab = new cBackTabAction();
        this.m_btn.getActionMap().put(actBackTab, actBackTab);
        this.m_btn.getInputMap().put(KeyStroke.getKeyStroke(9, 1), actBackTab);
        this.m_txt = new WATextField();
        this.initialize(this.m_txt, new cBrowsableTextFieldDelegate());
        cTabAction actTab = new cTabAction();
        this.m_txt.getActionMap().put(actTab, actTab);
        this.m_txt.getInputMap().put(KeyStroke.getKeyStroke(9, 0), actTab);
        this.m_pnl = new JPanel(new BorderLayout()){

            @Override
            public void requestFocus() {
                WADialogObjectTableCellEditor.this.m_txt.requestFocus();
            }
        };
        this.m_pnl.add((Component)this.m_txt, "Center");
        this.m_pnl.add((Component)this.m_btn, "East");
        WsForwardInputMap.install((JComponent)this.m_pnl, (JComponent)this.m_txt);
        this.m_cmpEditor = this.m_pnl;
    }

    public WADialogObjectTableCellEditor(MdObjectStore mdStore) {
        this();
        this.m_mdStore = mdStore;
    }

    public WADialogObjectTableCellEditor(String objectType) {
        this();
        this.setMetadataType(objectType);
    }

    public WADialogObjectTableCellEditor(MdObjectStore mdStore, String objectType) {
        this(mdStore);
        this.setMetadataType(objectType);
    }

    public WADialogObjectTableCellEditor(MdObjectStore mdStore, String objectType, boolean returnObjects) {
        this(mdStore, objectType);
        this.setReturnObjects(returnObjects);
    }

    public void setBrowseDirectories(boolean browseDirectories) {
        this.m_browseDirectories = browseDirectories;
    }

    public void setMetadataType(String objectType) {
        this.m_objectType = objectType;
    }

    public void setTextFieldEditable(boolean editable) {
        this.m_txt.setEditable(editable);
    }

    public void setReturnObjects(boolean returnObjects) {
        this.m_returnObjects = returnObjects;
    }

    public boolean getReturnObjects() {
        return this.m_returnObjects;
    }

    public static String getTableTextDisplay(PhysicalTable oTable) throws MdException, RemoteException {
        String tableText = oTable.getSASTableName();
        if (oTable != null) {
            RelationalSchema rSchema = oTable.getTablePackage();
            if (rSchema != null && rSchema instanceof DatabaseSchema) {
                SASLibrary tLibrary;
                tableText = ((DatabaseSchema)rSchema).getSchemaName() + '.' + tableText;
                if (!rSchema.getUsedByPackages(false).isEmpty() && (tLibrary = (SASLibrary)rSchema.getUsedByPackages(false).get(0)) != null) {
                    tableText = tLibrary.getLibref() + '.' + tableText;
                }
            } else if (rSchema != null) {
                tableText = ((SASLibrary)rSchema).getLibref() + '.' + tableText;
            }
        }
        return tableText;
    }

    public void setMaxCharacters(int nMaxCharacters) {
        this.m_txt.setMaxCharacters(nMaxCharacters);
    }

    public int getMaxCharacters() {
        return this.m_txt.getMaxCharacters();
    }

    private void setText(String text) {
        this.m_txt.setText(text);
    }

    private void setData(Object data) {
        this.m_data = data;
    }

    private String getText() {
        return this.m_txt.getText();
    }

    private Object getData() {
        return this.m_data;
    }

    public void setStopEditingOnDialogClose(boolean bStopEditingOnDialogClose) {
        this.m_bStopEditingOnDialogClose = bStopEditingOnDialogClose;
    }

    public boolean isStopEditingOnDialogClose() {
        return this.m_bStopEditingOnDialogClose;
    }

    protected class cShowDialogAction
    extends AbstractAction {
        protected cShowDialogAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (WADialogObjectTableCellEditor.this.m_objectType.equals("File")) {
                    LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
                    fileTypes.put(bundle.getString("WADialogObjectTableCellEditor.AllFileTypes.txt"), "*");
                    WADialogObjectTableCellEditor.this.m_txt.setCursor(Cursor.getPredefinedCursor(3));
                    WsAppServer wsAppServer = WsAppServer.createDefaultAppServer();
                    String selection = "";
                    try {
                        selection = WADialogObjectTableCellEditor.this.m_browseDirectories ? wsAppServer.promptForDirectory(bundle.getString("WADialogObjectTableCellEditor.RemoteFileSelectorDirectory.Title.txt"), WADialogObjectTableCellEditor.this.getText(), fileTypes) : wsAppServer.promptForFilename(bundle.getString("WADialogObjectTableCellEditor.RemoteFileSelector.Title.txt"), WADialogObjectTableCellEditor.this.getText(), fileTypes);
                    }
                    catch (WsAppServerFailException exc) {
                        WADialogObjectTableCellEditor.this.m_txt.setCursor(Cursor.getDefaultCursor());
                        MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                        return;
                    }
                    catch (GenericError err) {
                        WADialogObjectTableCellEditor.this.m_txt.setCursor(Cursor.getDefaultCursor());
                        MessageUtil.displayMessage((String)err.getLocalizedMessage(), (int)0);
                        return;
                    }
                    WADialogObjectTableCellEditor.this.m_txt.setCursor(Cursor.getDefaultCursor());
                    if (selection != null) {
                        WADialogObjectTableCellEditor.this.setText(selection);
                    }
                } else {
                    ObjectSelectorPanel pnl;
                    boolean disposeStore = false;
                    SimpleObject selObject = null;
                    PrimaryType mdObject = null;
                    if (WADialogObjectTableCellEditor.this.m_mdStore == null) {
                        WADialogObjectTableCellEditor.this.m_mdStore = Workspace.getMdFactory().createObjectStore();
                        disposeStore = true;
                        try {
                            if (WADialogObjectTableCellEditor.this.m_objectType.equals("PhysicalTable")) {
                                mdObject = MacroPluginUtilities.findTable(Workspace.getWorkspace().getDefaultRepository().getFQID(), WADialogObjectTableCellEditor.this.getText().split("\\."), WADialogObjectTableCellEditor.this.m_mdStore);
                            } else if (WADialogObjectTableCellEditor.this.m_objectType.equals("SASLibrary")) {
                                mdObject = MacroPluginUtilities.findLibrary(Workspace.getWorkspace().getDefaultRepository().getFQID(), WADialogObjectTableCellEditor.this.getText(), WADialogObjectTableCellEditor.this.m_mdStore);
                            }
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                    } else if (WADialogObjectTableCellEditor.this.getData() != null && WADialogObjectTableCellEditor.this.getData() instanceof PrimaryType) {
                        mdObject = (PrimaryType)WADialogObjectTableCellEditor.this.getData();
                    }
                    if (mdObject != null) {
                        selObject = ObjectConverter.getInstance().convertToSimpleObject(mdObject);
                    }
                    UserContextInterface userContext = Workspace.getWorkspace().getUserContext();
                    String type = "";
                    if (WADialogObjectTableCellEditor.this.m_objectType.equals("PhysicalTable")) {
                        pnl = new ObjectSelectorPanel(userContext, 3);
                        type = bundle.getString("WADialogObjectTableCellEditor.Types.Table.txt");
                        pnl.setHelpProduct("wdb");
                        pnl.setHelpTopic("select_table_win");
                    } else if (WADialogObjectTableCellEditor.this.m_objectType.equals("SASLibrary")) {
                        pnl = new ObjectSelectorPanel(userContext, 2);
                        type = bundle.getString("WADialogObjectTableCellEditor.Types.Library.txt");
                        pnl.setHelpProduct("wdb");
                        pnl.setHelpTopic("select_library_win");
                    } else {
                        return;
                    }
                    String sSelectDialogTitle = bundle.formatString("WADialogObjectTableCellEditor.SelectionType.title.txt", (Object)type);
                    pnl.setSelectionOptional(true);
                    if (selObject != null) {
                        pnl.setSelectedObject(selObject);
                    }
                    WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sSelectDialogTitle, true, (WAPanel)pnl);
                    dlg.setResizable(true);
                    dlg.show();
                    if (dlg.getReturnValue() == 1) {
                        SimpleObject simpleObj = pnl.getSelectedObject();
                        if (simpleObj != null) {
                            try {
                                Root oRoot = ObjectConverter.getInstance().convertToJOMAObject(WADialogObjectTableCellEditor.this.m_mdStore, simpleObj);
                                String textDisplay = oRoot.toString();
                                if (WADialogObjectTableCellEditor.this.m_returnObjects) {
                                    WADialogObjectTableCellEditor.this.setData(oRoot);
                                } else if (oRoot instanceof PhysicalTable) {
                                    textDisplay = WADialogObjectTableCellEditor.getTableTextDisplay((PhysicalTable)oRoot);
                                } else if (oRoot instanceof SASLibrary) {
                                    textDisplay = ((SASLibrary)oRoot).getLibref();
                                }
                                WADialogObjectTableCellEditor.this.setText(textDisplay);
                            }
                            catch (MdException exc) {
                                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                            }
                        } else {
                            WADialogObjectTableCellEditor.this.setData("");
                            WADialogObjectTableCellEditor.this.setText("");
                        }
                    }
                    if (disposeStore) {
                        WADialogObjectTableCellEditor.this.m_mdStore.dispose();
                        WADialogObjectTableCellEditor.this.m_mdStore = null;
                    }
                }
                if (WADialogObjectTableCellEditor.this.m_bStopEditingOnDialogClose) {
                    WADialogObjectTableCellEditor.this.stopCellEditing();
                } else {
                    WADialogObjectTableCellEditor.this.m_txt.requestFocus();
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
        }
    }

    protected class cTabAction
    extends AbstractAction {
        protected cTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WADialogObjectTableCellEditor.this.m_btn.requestFocus();
        }
    }

    protected class cBackTabAction
    extends AbstractAction {
        protected cBackTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WADialogObjectTableCellEditor.this.m_txt.requestFocus();
        }
    }

    protected class cBrowsableTextFieldDelegate
    extends WsDefaultCellEditor.cEditorDelegate {
        public cBrowsableTextFieldDelegate() {
            super((WsDefaultCellEditor)WADialogObjectTableCellEditor.this);
        }

        public void setValue(Object value) {
            if (value != null) {
                WADialogObjectTableCellEditor.this.setText(value.toString());
                WADialogObjectTableCellEditor.this.setData(value);
            }
        }

        public Object getValue() {
            if (WADialogObjectTableCellEditor.this.getReturnObjects()) {
                return WADialogObjectTableCellEditor.this.getData();
            }
            return WADialogObjectTableCellEditor.this.getText();
        }

        public void layout(JTable table, int iRow, int iColumn) {
            WADialogObjectTableCellEditor.this.m_tbl = table;
            WADialogObjectTableCellEditor.this.m_iRow = iRow;
            WADialogObjectTableCellEditor.this.m_iColumn = iColumn;
        }
    }
}

