/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.workspace.CustomDesktop;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class WACommonTaskPanel
extends CustomDesktop {
    private static WAdminResource bundle = WAdminResource.getBundle(WACommonTaskPanel.class);
    protected JLabel m_backgroundLabel;
    protected JScrollPane m_mainScrollPane;
    protected JPanel m_mainPanel;
    protected JPanel new_mainPanel = null;
    protected JLabel m_smcLabel;
    protected JLabel m_sasLabel;
    protected JLabel m_etlLabel;
    protected JPanel m_header;
    protected JPanel m_repositoryHeader;
    protected JLabel m_repositoryLabel;
    protected ImageIcon m_backgroundImage;
    protected ImageIcon m_smcImage;
    protected ImageIcon m_sasImage;
    protected ImageIcon m_etlImage;
    protected ArrayList m_sectionButtons;
    protected ArrayList m_sectionList;
    protected static Color SECTION_BUTTON_BACKGROUND = new Color(206, 206, 206);
    protected static Color LIGHT_BLUE = new Color(156, 206, 255);
    protected static Color SAS_BLUE = new Color(0, 49, 156);
    public static int DEFAULT_DESKTOP_COLOR = 12700;
    protected Workspace m_workspace = Workspace.getWorkspace();
    protected WorkspaceFile m_appDefaultsFile = this.m_workspace.getAppDefaultsFile();
    protected boolean m_bIsDefaultBackgroundOn;

    public WACommonTaskPanel() {
        this.setBorder(null);
        this.m_bIsDefaultBackgroundOn = true;
        this._initialize();
        this._initializeDummyTasks();
        this._layoutWidgets();
    }

    public boolean isDefaultBackgroundOn() {
        return this.m_bIsDefaultBackgroundOn;
    }

    protected void _initialize() {
        this.setOpaque(false);
        this.setBackground(Color.white);
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setOpaque(false);
        this.m_header = new JPanel();
        this.m_header.setBackground(SAS_BLUE);
        this.m_etlImage = bundle.getImageIcon("WACommonTaskPanel.etlLogo.image");
        this.m_etlLabel = new JLabel(this.m_etlImage);
        this.m_sasImage = bundle.getImageIcon("WACommonTaskPanel.sasLogo.image");
        this.m_sasLabel = new JLabel(this.m_sasImage);
        this.m_backgroundImage = bundle.getImageIcon("WACommonTaskPanel.background.image");
        this.m_backgroundLabel = new JLabel(this.m_backgroundImage);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.m_mainPanel.setSize(this.getWidth(), this.getHeight());
        this.m_mainPanel.doLayout();
        int x2 = (this.getWidth() - this.m_backgroundLabel.getWidth()) / 2;
        int y2 = (this.getHeight() - this.m_backgroundLabel.getHeight()) / 2;
        this.m_backgroundLabel.setLocation(x2, y2);
    }

    protected void _layoutWidgets() {
        this.add(this.m_mainPanel, new Integer(JLayeredPane.DEFAULT_LAYER - 1));
        GridBagLayout gbl = new GridBagLayout();
        this.m_mainPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbl.setConstraints(this.m_header, gbc);
        this.m_mainPanel.add(this.m_header);
        this.m_mainPanel.setLocation(0, 0);
        this.m_header.setLayout(new BorderLayout(0, 0));
        this.m_header.add((Component)this.m_etlLabel, "West");
        this.m_header.add((Component)this.m_sasLabel, "East");
        this.add(this.m_backgroundLabel, new Integer(JLayeredPane.DEFAULT_LAYER - 1));
        this.m_backgroundLabel.setSize(this.m_backgroundImage.getIconWidth(), this.m_backgroundImage.getIconHeight());
        JPanel scrolledPanel = new JPanel();
        scrolledPanel.setOpaque(false);
        this.m_mainScrollPane = new JScrollPane(scrolledPanel);
        this.m_mainScrollPane.getViewport().setOpaque(false);
        this.m_mainScrollPane.setOpaque(false);
        this.m_mainScrollPane.setBorder(null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbl.setConstraints(this.m_mainScrollPane, gbc);
        this.m_mainPanel.add(this.m_mainScrollPane);
        gbl = new GridBagLayout();
        scrolledPanel.setLayout(gbl);
        int gridy = 3;
        this.m_sectionButtons = new ArrayList();
        for (Section section : this.m_sectionList) {
            SectionButton sectionButton = new SectionButton(section);
            this.m_sectionButtons.add(sectionButton);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = gridy++;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(7, 0, 0, 0);
            gbc.fill = 0;
            gbc.anchor = 18;
            gbl.setConstraints(sectionButton, gbc);
            scrolledPanel.add(sectionButton);
            for (DummyTask task : section.getTasks()) {
                Object[] args = new Object[]{task.m_arg};
                String strLabel = MessageFormat.format(task.m_desciption, args);
                JLabel taskButton = new JLabel(strLabel, task.m_icon, 0);
                taskButton.setOpaque(false);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = gridy++;
                gbc.weightx = 1.0;
                gbc.insets = new Insets(10, 40, 2, 0);
                gbc.fill = 0;
                gbc.anchor = 18;
                gbl.setConstraints(taskButton, gbc);
                scrolledPanel.add(taskButton);
            }
        }
        JPanel junk = new JPanel();
        junk.setOpaque(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbl.setConstraints(junk, gbc);
        scrolledPanel.add(junk);
    }

    protected void _initializeDummyTasks() {
        this.m_sectionList = new ArrayList();
    }

    class SectionButton
    extends JTextField {
        protected int m_initialWidth;

        public SectionButton(Section section) {
            super(section.getName(), 13);
            this.m_initialWidth = 0;
            this.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 0));
            this.setBackground(SECTION_BUTTON_BACKGROUND);
            this.setEditable(false);
            this.setEnabled(false);
            this.bold(this);
            this.setDisabledTextColor(Color.black);
        }

        public void bold(Component component) {
            Font font = component.getFont();
            if (!font.isBold()) {
                Font boldFont = new Font(font.getName(), font.getStyle() | 1, font.getSize());
                component.setFont(boldFont);
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            if (this.m_initialWidth == 0) {
                this.m_initialWidth = w;
            }
            super.setBounds(x, y, this.m_initialWidth, h);
        }
    }

    class DummyTask
    extends AbstractAction
    implements TaskLinkActionInterface {
        public ImageIcon m_icon;
        public String m_desciption;
        public String m_arg;

        public DummyTask(ImageIcon icon, String strName, String strDescription) {
            this.m_icon = icon;
            this.m_desciption = strDescription;
            this.m_arg = strName;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    }

    static interface TaskLinkActionInterface
    extends Action {
    }

    class Section {
        protected String m_strName;
        protected ArrayList m_taskList = new ArrayList();

        public Section(String strName) {
            this.m_strName = strName;
        }

        public String getName() {
            return this.m_strName;
        }

        public List getTasks() {
            return this.m_taskList;
        }

        public void addTask(TaskLinkActionInterface task) {
            this.m_taskList.add(task);
        }
    }
}

