/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsDataTreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class TreeTreeNode
extends WsDataTreeNode {
    private static WAdminResource bundle = WAdminResource.getBundle(TreeTreeNode.class);
    private boolean m_bRootFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeTreeNode(CMetadata oMetadata) {
        super(oMetadata);
        this.setIcon(WorkspaceTree.getClosedFolderIcon());
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        try {
            MdObjectStore store = factory.createObjectStore(null, "TreeTreeNode:rootFolderCheck");
            try {
                Tree tree = (Tree)factory.createComplexMetadataObject(store, oMetadata);
                ArrayList<String> lAssociations = new ArrayList<String>(1);
                lAssociations.add("ParentTree");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)tree, null, lAssociations, null, 0);
                this.m_bRootFolder = tree.getParentTree() == null;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public boolean isRootFolder() {
        return this.m_bRootFolder;
    }

    public boolean isReallyDestroyable() {
        boolean bDestroyable = this.isTreeObjectEmpty();
        if (!bDestroyable) {
            String sMessage = bundle.formatString("TreeTreeNode.GroupMustBeEmptyToDestroyError.fmt", (Object)this.m_sName);
            MessageUtil.displayMessage((String)sMessage, (int)2);
        }
        return bDestroyable;
    }

    public boolean isReallyDeleteable() {
        boolean bDeleteable = this.isTreeObjectEmpty();
        if (!bDeleteable) {
            String sMessage = bundle.formatString("TreeTreeNode.GroupMustBeEmptyToDeleteError.fmt", (Object)this.m_sName);
            MessageUtil.displayMessage((String)sMessage, (int)2);
        }
        return bDeleteable;
    }

    public boolean isReallyCMDeleteable() {
        boolean bDeleteable = this.isTreeObjectEmpty();
        if (!bDeleteable) {
            String sMessage = bundle.formatString("TreeTreeNode.GroupMustBeEmptyToDeleteError.fmt", (Object)this.m_sName);
            MessageUtil.displayMessage((String)sMessage, (int)2);
        }
        return bDeleteable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isTreeObjectEmpty() {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        try {
            MdObjectStore store = factory.createObjectStore();
            try {
                Tree tree = (Tree)factory.createComplexMetadataObject(store, this.m_oMetadata);
                ArrayList<String> lAssociations = new ArrayList<String>();
                lAssociations.add("SubTrees");
                lAssociations.add("Members");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)tree, null, lAssociations, null, 0);
                boolean bl = tree.getSubTrees().size() == 0 && tree.getMembers().size() == 0;
                return bl;
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
                return false;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }
}

