/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.JComponent;

public class TableStatisticsTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(TableStatisticsTab.class);
    private DataTable m_dataTable;
    private WsLogPropertyTab m_tabOutput;
    private DataManager m_dataManager;
    private boolean m_hasSubmitError;
    private WsAbstractAction m_actRefresh;

    public TableStatisticsTab(DataTable table) {
        this.m_dataTable = table;
        this.initialize();
        this.setName(bundle.getString("TableStatisticsTab.Name.txt"));
    }

    protected void initialize() {
        this.m_actRefresh = new cRefreshStatisticsAction();
        this.m_tabOutput = new WsLogPropertyTab(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabOutput, "Center");
        this.setHelpProduct("wdb");
        this.setHelpTopic("analysis_contents");
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        this.m_tabOutput.updateWorkspaceUIComponents(bActive);
        this.m_actRefresh.setActive(bActive);
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        String sOptions = "<TEMPLATES><PhysicalTable><Columns/><TablePackage/></PhysicalTable><SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary></TEMPLATES>";
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_dataTable, null, null, sOptions, 24972);
        this.setStorePopulated(true);
    }

    public void moveDataToStore() {
    }

    public void moveDataToView() throws MdException, RemoteException {
        try {
            this.m_dataManager = new DataManager();
            this.m_dataManager.init();
            this.fetchAndShowStatistics();
        }
        catch (WsAppServerLibraryException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (WsAppServerCodeException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (null != this.m_dataManager) {
            this.m_dataManager.close();
        }
        this.m_tabOutput.saveSettingsAndCleanUp();
    }

    protected void fetchAndShowStatistics() {
        this.m_hasSubmitError = false;
        OpRequestUI oppDlg = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("TableStatisticsTab.ProgressDlg.Message.txt"), bundle.getString("TableStatisticsTab.ProgressDlg.Title.txt"));
        oppDlg.setDelayBeforeProgressCancelDialog(1000);
        oppDlg.execute((Runnable)new CodeSubmitter(), (Runnable)new RunCompletionNotification());
    }

    protected String getTableName() throws MdException, RemoteException {
        return DBMSNamesUtil.getQuotedString((String)((PhysicalTable)this.m_dataTable).getSASTableName(), (DataTable)this.m_dataTable);
    }

    private class DataManager {
        private WsAppServer m_appServer;
        private SASLibrary m_library;

        public void init() throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
            this.fetchAppServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchAppServer() throws MdException, RemoteException, WsAppServerFailException, WsAppServerCodeException, WsAppServerLibraryException {
            WsAppServer defAppServer = WsAppServer.createDefaultAppServer();
            if (defAppServer == null) {
                throw new MdException(bundle.getString("TableStatisticsTab.DefAppServerCreationFailed.txt"));
            }
            try {
                ServerContext iDefault = defAppServer.getServerContext();
                SASLibrary iLib = LibraryUtil.getLibrary((DataTable)TableStatisticsTab.this.m_dataTable, (ServerContext)iDefault);
                if (iLib == null) {
                    throw new MdException(bundle.getString("TableStatisticsTab.LibraryFetchFail.txt"));
                }
                this.m_library = LibraryUtil.getClientLibrary((SASLibrary)iLib, (ServerContext)iDefault);
                this.m_appServer = LibraryUtil.interactiveAccessPath((SASLibrary)this.m_library, (WsAppServer)defAppServer);
                if (this.m_appServer == null) {
                    Workspace.getDefaultLogger().debug((Object)"Couldnot fetch appserver.");
                    throw new MdException(bundle.getString("TableStatisticsTab.AppServerFetchFail.txt"));
                }
                String specChar = DBMSNamesPropertyHandler.getSpecCharPropertyValue((Root)TableStatisticsTab.this.m_dataTable);
                if ("Y".equals(specChar)) {
                    this.submitSASCode("options VALIDVARNAME=ANY VALIDMEMNAME=EXTEND;");
                }
            }
            finally {
                if (this.m_appServer != defAppServer) {
                    defAppServer.dispose();
                }
            }
        }

        public void submitSASCode(String code) throws WsAppServerFailException, WsAppServerCodeException {
            this.m_appServer.submitSASCode(code);
        }

        public void submitProcContentsCode() throws WsAppServerFailException, WsAppServerCodeException, MdException, RemoteException {
            String libref = null;
            if (this.m_library != null) {
                libref = this.m_library.getLibref();
            }
            if (libref == null) {
                Workspace.getDefaultLogger().debug((Object)"Error fetching libref. Cannot form proc step.");
                throw new MdException(bundle.getString("TableStatisticsTab.LibraryFetchFail.txt"));
            }
            StringBuffer sCode = new StringBuffer();
            String parameters = this.getTableParametersCode();
            if (parameters != null) {
                sCode.append(parameters);
            }
            sCode.append("\nPROC CONTENTS DATA=");
            sCode.append(libref).append(".").append(TableStatisticsTab.this.getTableName());
            this.appendTableOptions(sCode);
            sCode.append("; RUN;");
            Workspace.getDefaultLogger().debug((Object)sCode.toString());
            TableStatisticsTab.this.m_dataManager.submitSASCode(sCode.toString());
        }

        protected String getTableParametersCode() throws MdException, RemoteException {
            ParametersModel parmModel = new ParametersModel((Root)TableStatisticsTab.this.m_dataTable);
            StringBuffer buffer = null;
            try {
                buffer = parmModel.getParameterMacroCode();
                if (buffer != null) {
                    return buffer.toString();
                }
            }
            catch (MdException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                throw e;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            return null;
        }

        private void appendTableOptions(StringBuffer sCode) throws MdException, RemoteException {
            OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)TableStatisticsTab.this.m_dataTable, false);
            String dsOptions = OP.getOptionsString();
            if (dsOptions != null && !dsOptions.trim().equals("")) {
                sCode.append(" (").append(dsOptions).append(") ");
            }
        }

        public LogListHolder getOutput() throws WsAppServerFailException {
            return this.m_appServer.getOutput();
        }

        public LogListHolder getLog() throws WsAppServerFailException {
            return this.m_appServer.getLog();
        }

        public void close() {
            if (this.m_appServer != null) {
                this.m_appServer.dispose();
                this.m_appServer = null;
            }
        }
    }

    private class cRefreshStatisticsAction
    extends WsAbstractAction {
        public cRefreshStatisticsAction() {
            this.setMenuSupportId("refresh");
        }

        public void actionPerformed(ActionEvent e) {
            TableStatisticsTab.this.fetchAndShowStatistics();
        }
    }

    private class RunCompletionNotification
    implements Runnable {
        private RunCompletionNotification() {
        }

        @Override
        public void run() {
            try {
                if (!TableStatisticsTab.this.m_hasSubmitError) {
                    TableStatisticsTab.this.m_tabOutput.clear();
                    TableStatisticsTab.this.m_tabOutput.appendText(TableStatisticsTab.this.m_dataManager.getOutput());
                    TableStatisticsTab.this.m_tabOutput.scrollToTop();
                }
            }
            catch (WsAppServerFailException sfe) {
                MessageUtil.displayMessage((String)sfe.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class CodeSubmitter
    implements Runnable {
        private CodeSubmitter() {
        }

        @Override
        public void run() {
            try {
                TableStatisticsTab.this.m_dataManager.submitProcContentsCode();
            }
            catch (MdException mde) {
                TableStatisticsTab.this.m_hasSubmitError = true;
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (WsAppServerFailException sfe) {
                TableStatisticsTab.this.m_hasSubmitError = true;
                MessageUtil.displayMessage((String)sfe.getLocalizedMessage(), (int)0);
            }
            catch (WsAppServerCodeException sce) {
                TableStatisticsTab.this.m_hasSubmitError = true;
                WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
                try {
                    logPropertyTab.appendText(TableStatisticsTab.this.m_dataManager.getLog());
                    logPropertyTab.scrollToTop();
                    MessageUtil.displayDetailsMessage((String)sce.getLocalizedMessage(), (String)bundle.getString("TableStatisticsTab.WsAppServerCodeException.Title.txt"), (JComponent)logPropertyTab);
                }
                catch (WsAppServerFailException e) {
                    MessageUtil.displayMessage((String)bundle.formatString("TableStatisticsTab.CodeSubmitLogNotAvailable.txt", (Object)e.getLocalizedMessage()), (int)0);
                }
                logPropertyTab.saveSettingsAndCleanUp();
            }
        }
    }
}

