/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TDColumnsTab
extends WsDescriptionWizardTab {
    private static WAdminResource m_bundle = new WAdminResource(TDColumnsTab.class);
    private WAWizardDialog m_parent = null;
    private ObjectsSelectorPanel m_objectsSelector;
    private PhysicalTable m_table = null;

    public TDColumnsTab() {
        super(m_bundle.getString("TDColumnsTab.Top.txt"));
        this.setHelpProduct("shared");
        this.setHelpTopic("import_column_win");
        this._initialize();
    }

    public void saveSettingsAndCleanUp() {
        this.m_objectsSelector.saveSettingsAndCleanUp();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        boolean rc = false;
        if (this.m_parent == null) {
            this.m_parent = (WAWizardDialog)this.getTopLevelAncestor();
        }
        if (!bSaveToModel) {
            this.m_table = (PhysicalTable)this.m_parent.getWizardData("TDNEWTABLE");
            this.m_objectsSelector.doDataExchange(false);
        }
        return rc;
    }

    public boolean validateData() {
        boolean rc = false;
        rc = this.m_objectsSelector.validateData();
        if (rc) {
            try {
                this.m_objectsSelector.moveDataToStore();
                SimpleObject[] aColumns = this.m_objectsSelector.getSelectedObjects();
                MdObjectStore store = (MdObjectStore)this.m_parent.getWizardData("OBJECTSTORE");
                Root[] aMDColumns = ObjectConverter.getInstance().convertToJOMAObjects(store, aColumns);
                List<Root> columns = Arrays.asList(aMDColumns);
                for (int i = 0; i < columns.size(); ++i) {
                    int iChoice;
                    Column col = (Column)columns.get(i);
                    if (col.getSASColumnName().length() <= 0 && (iChoice = MessageUtil.displayMessage((String)m_bundle.formatString("TDColumnsTab.Missing.SASColumnNameAttribute.fmt", (Object)col), (String)m_bundle.getString("TDColumnsTab.Missing.SASColumnNameAttribute.Title.txt"), (int)0, (int)2)) != 0) {
                        rc = false;
                    }
                    if (col.getSASColumnLength() <= 0 && (iChoice = MessageUtil.displayMessage((String)m_bundle.formatString("TDColumnsTab.Missing.SASColumnLengthAttribute.fmt", (Object)col), (String)m_bundle.getString("TDColumnsTab.Missing.SASColumnLengthAttribute.Title.txt"), (int)0, (int)2)) != 0) {
                        rc = false;
                    }
                    if (WsColumnMetadataUtil.isColumnTypeCharacter((Column)col) || WsColumnMetadataUtil.isColumnTypeNumeric((Column)col) || (iChoice = MessageUtil.displayMessage((String)m_bundle.formatString("TDColumnsTab.Missing.SASColumnTypeAttribute.fmt", (Object)col), (String)m_bundle.getString("TDColumnsTab.Missing.SASColumnTypeAttribute.Title.txt"), (int)0, (int)2)) == 0) continue;
                    rc = false;
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return rc;
    }

    public void onNext() {
        this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
        super.onNext();
        try {
            int i;
            SimpleObject[] aColumns = this.m_objectsSelector.getSelectedObjects();
            MdObjectStore store = (MdObjectStore)this.m_parent.getWizardData("OBJECTSTORE");
            Root[] aMDColumns = ObjectConverter.getInstance().convertToJOMAObjects(store, aColumns);
            ArrayList prevColumns = (ArrayList)this.m_parent.getWizardData("TDNEWTABLECOLUMNS");
            if (prevColumns != null) {
                for (i = 0; i < prevColumns.size(); ++i) {
                    String colID = ((Column)prevColumns.get(i)).getFQID();
                    store.deleteObjectFromStore(colID);
                }
            }
            for (i = 0; i < aMDColumns.length; ++i) {
                aMDColumns[i] = WsColumnMetadataUtil.createMetadataColumnCopy((Column)((Column)aMDColumns[i]), (MdObjectStore)store, (String)this.m_table.getRepositoryID());
            }
            ArrayList<Root> columns = new ArrayList<Root>(Arrays.asList(aMDColumns));
            try {
                this.m_table.getColumns().removeAllElements();
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Deleting");
            }
            try {
                this.m_table.getColumns().addAll(columns);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Creating");
            }
            this.m_parent.addWizardData("TDNEWTABLECOLUMNS", columns);
            this.m_parent.addWizardData("TDSOURCETABLES", (Object)this.getSourceTables(columns));
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_parent.setCursor(null);
    }

    public void onBack() {
        this.m_parent.setCursor(Cursor.getPredefinedCursor(3));
        super.onBack();
        try {
            MdObjectStore store = (MdObjectStore)this.m_parent.getWizardData("OBJECTSTORE");
            ArrayList prevColumns = (ArrayList)this.m_parent.getWizardData("TDNEWTABLECOLUMNS");
            if (prevColumns != null) {
                for (int i = 0; i < prevColumns.size(); ++i) {
                    String colID = ((Column)prevColumns.get(i)).getFQID();
                    store.deleteObjectFromStore(colID);
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_parent.removeWizardData("TDNEWTABLECOLUMNS");
        this.m_parent.removeWizardData("TDSOURCETABLES");
        this.m_objectsSelector.onBack();
        this.m_parent.setCursor(null);
    }

    private void _initialize() {
        this.m_objectsSelector = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), 4);
        this.m_objectsSelector.setSourceLabel(m_bundle.getString("TDColumnsTab.AvailableTables.txt"), m_bundle.getString("TDColumnsTab.AvailableTables.mnem").charAt(0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_objectsSelector, "Center");
    }

    public List getSourceTables(ArrayList columns) {
        ArrayList<DataTable> tables = new ArrayList<DataTable>(10);
        for (int i = 0; i < columns.size(); ++i) {
            try {
                Column col = (Column)columns.get(i);
                tables.add(col.getTable());
                continue;
            }
            catch (MdException col) {
                continue;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return tables;
    }
}

