/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.editor.CodeEditor;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASCatalog;
import com.sas.metadata.remote.SASCatalogEntry;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.wadmin.visuals.RemoteFilePanel;
import com.sas.workspace.AppServer;
import com.sas.workspace.AppServerDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsUIUtilities;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;

public class SourceCodePanel
extends WAPanel {
    protected JLabel m_lblType;
    protected WAComboBox m_cmbType;
    protected JButton m_btnEdit;
    protected boolean m_bEditEnabled = true;
    protected boolean m_bEditable = true;
    protected WAPanel m_pnlSourceType;
    protected CardLayout m_SourceTypeCards;
    protected cSASTypePanel m_pnlSASType;
    protected cFileTypePanel m_pnlFileType;
    protected cMetaTypePanel m_pnlMetaType;
    protected Text m_mdText;
    protected MdObjectStore m_mdStore;
    protected String m_strSourceCode;
    protected SourceCodePanel m_pnlSourceCode;
    protected int m_iType = 3;
    protected boolean m_bSecondBundleText;
    private String m_FQIDofRepositoryToMakeTheObjectIn = "";
    private final String m_strFileType = bundle.getString("SourceCodePanel.strFileType.txt");
    private final String m_strSASType = bundle.getString("SourceCodePanel.strSASType.txt");
    private final String m_strMetaType = bundle.getString("SourceCodePanel.strMetaType.txt");
    public static final int FILE_TYPE = 1;
    public static final int SAS_TYPE = 2;
    public static final int META_TYPE = 3;
    public static final int FileSourceType = 1;
    public static final int SASSourceType = 2;
    public static final int MetaSourceType = 3;
    private static WAdminResource bundle = WAdminResource.getBundle(SourceCodePanel.class);

    public SourceCodePanel() {
        this(false, "");
    }

    public SourceCodePanel(boolean bSecondBundleText) {
        this(bSecondBundleText, "");
    }

    public SourceCodePanel(String defaultTextFieldName, String defaultTextFieldDescription) {
        this(false, defaultTextFieldName, defaultTextFieldDescription);
    }

    public SourceCodePanel(boolean bSecondBundleText, String defaultTextFieldName) {
        this(bSecondBundleText, defaultTextFieldName, "");
    }

    public SourceCodePanel(boolean bSecondBundleText, String defaultTextFieldName, String defaultTextFieldDescription) {
        this.m_pnlSourceCode = this;
        this.m_bSecondBundleText = bSecondBundleText;
        this.m_SourceTypeCards = new CardLayout();
        this.m_pnlSourceType = new WAPanel();
        this.m_pnlSASType = new cSASTypePanel();
        this.m_pnlFileType = new cFileTypePanel();
        this.m_pnlMetaType = new cMetaTypePanel(defaultTextFieldName, defaultTextFieldDescription);
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        Object[] data = new String[]{this.m_strMetaType, this.m_strFileType};
        this.m_btnEdit = new JButton();
        this.m_lblType = new JLabel();
        this.m_cmbType = new WAComboBox(data);
        if (!this.m_bSecondBundleText) {
            this.setInfoForEdit("SourceCodePanel.btnEdit");
            this.setInfoForTypeLabel("SourceCodePanel.lblType");
            this.m_cmbType.setToolTipText(bundle.getString("SourceCodePanel.cmbType.ToolTip.txt"));
        } else {
            this.setInfoForEdit("SourceCodePanel.btnEdit2");
            this.setInfoForTypeLabel("SourceCodePanel.lblType2");
            this.m_pnlMetaType.setInfoForName("SourceCodePanel.lblName2");
            this.m_pnlMetaType.setInfoForDesc("SourceCodePanel.lblDesc2");
            this.m_pnlSASType.setInfoForHost("SourceCodePanel.lblHost2");
            this.m_pnlSASType.setInfoForLibrary("SourceCodePanel.lblLibrary2");
            this.m_pnlSASType.setInfoForCatalog("SourceCodePanel.lblCatalog2");
            this.m_pnlSASType.setInfoForCatEntry("SourceCodePanel.lblCatEntry2");
            this.m_pnlSASType.setInfoForDefine("SourceCodePanel.btnDefine2");
            this.m_pnlFileType.m_pnlRemoteFile.setInfoForDefine("RemoteFilePanel.btnDefine2");
            this.m_pnlFileType.m_pnlRemoteFile.setInfoForBrowse("RemoteFilePanel.btnBrowse2");
            this.m_pnlFileType.m_pnlRemoteFile.setInfoForHost("RemoteFilePanel.lblHost2");
            this.m_pnlFileType.m_pnlRemoteFile.setInfoForPath("RemoteFilePanel.lblPath2");
        }
        this.m_lblType.setLabelFor((Component)this.m_cmbType);
        this.listenForDataChangesTo((JComboBox)this.m_cmbType);
        this.listenForDataChangesTo(this.m_pnlFileType);
        this.listenForDataChangesTo(this.m_pnlMetaType);
        this.listenForDataChangesTo(this.m_pnlSASType);
        this.listenForDataChangesTo(this.m_pnlSourceType);
        this.m_btnEdit.setEnabled(true);
        this.m_cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strTypeName = (String)SourceCodePanel.this.m_cmbType.getSelectedItem();
                if (strTypeName.compareTo(SourceCodePanel.this.m_strSASType) == 0) {
                    SourceCodePanel.this.setSourcePanel(2);
                    SourceCodePanel.this.m_iType = 2;
                    SourceCodePanel.this.m_btnEdit.setEnabled(false);
                }
                if (strTypeName.compareTo(SourceCodePanel.this.m_strFileType) == 0) {
                    SourceCodePanel.this.setSourcePanel(1);
                    SourceCodePanel.this.m_iType = 1;
                    SourceCodePanel.this.m_btnEdit.setEnabled(false);
                }
                if (strTypeName.compareTo(SourceCodePanel.this.m_strMetaType) == 0) {
                    SourceCodePanel.this.setSourcePanel(3);
                    SourceCodePanel.this.m_iType = 3;
                    SourceCodePanel.this.m_btnEdit.setEnabled(true);
                }
                SourceCodePanel.this.m_bEditEnabled = SourceCodePanel.this.m_btnEdit.isEnabled();
            }
        });
        this.m_btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cEditorDlg dlgEditor = new cEditorDlg(WorkspaceUtil.getParentFrame((Component)((Object)SourceCodePanel.this.m_pnlSourceCode)));
                dlgEditor.setEditable(SourceCodePanel.this.m_bEditable);
                dlgEditor.setResizable(true);
                dlgEditor.show();
                if (dlgEditor.getReturnValue() != 2) {
                    SourceCodePanel.this.setDataChanged(true);
                }
            }
        });
    }

    protected void layoutWidgets() {
        this.m_pnlSourceType.setLayout((LayoutManager)this.m_SourceTypeCards);
        this.m_pnlSourceType.add((Component)((Object)this.m_pnlMetaType), (Object)this.m_strMetaType);
        this.m_pnlSourceType.add((Component)((Object)this.m_pnlFileType), (Object)this.m_strFileType);
        this.setLayout(new GridBagLayout());
        JSeparator separator = new JSeparator();
        this.add(this.m_lblType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.m_cmbType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.m_btnEdit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add(separator, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.m_pnlSourceType, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        switch (this.m_iType) {
            case 1: {
                return this.m_pnlFileType.validateData();
            }
            case 2: {
                return this.m_pnlSASType.validateData();
            }
            case 3: {
                return this.m_pnlMetaType.validateData();
            }
        }
        return false;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        try {
            if (saveToModel) {
                switch (this.m_iType) {
                    case 1: {
                        this.m_pnlFileType.doDataExchange(true);
                        if (this.m_mdText == null || this.m_mdText instanceof File) break;
                        this.m_mdText.delete();
                        break;
                    }
                    case 2: {
                        this.m_pnlSASType.doDataExchange(true);
                        if (this.m_mdText == null || this.m_mdText instanceof SASCatalogEntry) break;
                        this.m_mdText.delete();
                        break;
                    }
                    case 3: {
                        this.m_pnlMetaType.doDataExchange(true);
                        if (this.m_mdText == null || this.m_mdText instanceof TextStore) break;
                        this.m_mdText.delete();
                    }
                }
            } else {
                if (this.m_mdStore == null) {
                    this.m_mdStore = this.m_mdText != null ? (MdObjectStore)this.m_mdText.getObjectStore() : Workspace.getMdFactory().createObjectStore();
                }
                if (this.m_mdText instanceof TextStore) {
                    this.m_cmbType.setSelectedItem((Object)this.m_strMetaType);
                    this.m_iType = 3;
                    this.setSourcePanel(3);
                } else if (this.m_mdText instanceof File) {
                    this.m_cmbType.setSelectedItem((Object)this.m_strFileType);
                    this.m_iType = 1;
                    this.setSourcePanel(1);
                } else if (this.m_mdText instanceof SASCatalogEntry) {
                    this.m_cmbType.setSelectedItem((Object)this.m_strSASType);
                    this.m_iType = 2;
                    this.setSourcePanel(2);
                }
                this.m_pnlFileType.doDataExchange(false);
                this.m_pnlMetaType.doDataExchange(false);
            }
            this.setDataChanged(false);
            this.getWAUndoManager().discardAllEdits();
            return true;
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return false;
        }
    }

    public void setInfoForEdit(String sKey) {
        this.m_btnEdit.setText(bundle.getString(sKey + ".txt"));
        this.m_btnEdit.setMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        this.m_btnEdit.setToolTipText(bundle.getString(sKey + ".ToolTip.txt"));
    }

    public void setInfoForTypeLabel(String sKey) {
        this.m_lblType.setText(bundle.getString(sKey + ".txt"));
        this.m_lblType.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_bEditable = bEditable;
        this.m_cmbType.setEnabled(bEditable);
        this.m_pnlFileType.setEditable(bEditable);
        this.m_pnlMetaType.setEditable(bEditable);
        this.m_pnlSASType.setEditable(bEditable);
    }

    public void setFQIDofRepositoryToMakeTheObjectIn(String strFQID) {
        this.m_FQIDofRepositoryToMakeTheObjectIn = strFQID;
    }

    public void setMetadataObject(CMetadata inMetadata) {
        try {
            this.m_mdText = (Text)inMetadata;
            this.m_mdStore = (MdObjectStore)this.m_mdText.getObjectStore();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public void setMetadataStore(MdObjectStore inStore) {
        this.m_mdStore = inStore;
    }

    public void setButtonSize(Dimension newSize) {
    }

    public void disableAll() {
        this.disableUserWritten();
    }

    public void enableAll() {
        this.enableUserWritten();
    }

    public int getSourceTypeEnum() {
        return this.m_iType;
    }

    public WAComboBox getSourceTypeCombo() {
        return this.m_cmbType;
    }

    public cFileTypePanel getFilePanel() {
        return this.m_pnlFileType;
    }

    public cMetaTypePanel getMetaPanel() {
        return this.m_pnlMetaType;
    }

    public cSASTypePanel getSASPanel() {
        return this.m_pnlSASType;
    }

    protected void setSourcePanel(int iType) {
        this.m_iType = iType;
        switch (this.m_iType) {
            case 1: {
                this.m_SourceTypeCards.show((Container)this.m_pnlSourceType, this.m_strFileType);
                break;
            }
            case 2: {
                this.m_SourceTypeCards.show((Container)this.m_pnlSourceType, this.m_strSASType);
                break;
            }
            case 3: {
                this.m_SourceTypeCards.show((Container)this.m_pnlSourceType, this.m_strMetaType);
            }
        }
    }

    protected void disableUserWritten() {
        this.m_lblType.setEnabled(false);
        this.m_cmbType.setEnabled(false);
        this.m_btnEdit.setEnabled(false);
        this.m_pnlSourceType.setEnabled(false);
        switch (this.m_iType) {
            case 1: {
                this.m_pnlFileType.disableFileTypePanel();
                break;
            }
            case 2: {
                this.m_pnlSASType.disableSASTypePanel();
                break;
            }
            case 3: {
                this.m_pnlMetaType.disableMetaTypePanel();
            }
        }
    }

    protected void enableUserWritten() {
        if (this.m_bEditable) {
            this.m_lblType.setEnabled(true);
            this.m_cmbType.setEnabled(true);
            if (this.m_bEditEnabled) {
                this.m_btnEdit.setEnabled(true);
            } else {
                this.m_btnEdit.setEnabled(false);
            }
            switch (this.m_iType) {
                case 1: {
                    this.m_pnlFileType.enableFileTypePanel();
                    break;
                }
                case 2: {
                    this.m_pnlSASType.enableSASTypePanel();
                    break;
                }
                case 3: {
                    this.m_pnlMetaType.enableMetaTypePanel();
                }
            }
        }
    }

    protected String getSourceType() {
        return this.m_cmbType.getSelectedItem().toString();
    }

    protected String getSASHostLoc() {
        return this.m_pnlSASType.getSASHostLoc();
    }

    protected String getLibrary() {
        return this.m_pnlSASType.getLibrary();
    }

    protected String getCatalog() {
        return this.m_pnlSASType.getCatalog();
    }

    protected String getCatEntry() {
        return this.m_pnlSASType.getCatEntry();
    }

    protected String getPath() {
        return this.m_pnlFileType.getPath();
    }

    protected String getMetaName() {
        return this.m_pnlMetaType.getMetaName();
    }

    protected String getMetaDesc() {
        return this.m_pnlMetaType.getMetaDesc();
    }

    protected String getSourceCode() {
        return this.m_strSourceCode;
    }

    protected void setSourceCode(String sourcecode) {
        this.m_strSourceCode = sourcecode;
    }

    public Text getTextObject() {
        switch (this.m_iType) {
            case 1: {
                return this.m_pnlFileType.getFileObject();
            }
            case 2: {
                return this.m_pnlSASType.getSASObject();
            }
            case 3: {
                return this.m_pnlMetaType.getTextStoreObject();
            }
        }
        return null;
    }

    class WAGUndoableEditListener
    implements UndoableEditListener {
        WAGUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (SourceCodePanel.this.isListeningForChanges()) {
                SourceCodePanel.this.getWAUndoManager().addEdit(e.getEdit());
            }
        }
    }

    protected class cEditorDlg
    extends WAStandardDialog {
        protected CodeEditor m_editor;

        public cEditorDlg(Frame frmOwner) {
            super(frmOwner, bundle.getString("SourceCodePanel.EditSourceCode.txt"), true);
            this.setHelpProduct("texteditor");
            this.setHelpTopic("editorspace");
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            super.initialize();
            this.m_editor = new CodeEditor((Frame)Workspace.getWorkspace(), Workspace.getWorkspace().getCodeEditorDefaults());
            this.m_editor.setPreferredSize(new Dimension(600, 400));
            this.m_editor.setLineNumbers(true, true);
        }

        protected void layoutWidgets() {
            super.layoutWidgets();
            WAPanel pnlMain = new WAPanel();
            pnlMain.setLayout((LayoutManager)new GridBagLayout());
            pnlMain.add((Component)this.m_editor, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setMainPanel(pnlMain);
        }

        public boolean validateData() {
            String[] lines = this.m_editor.getText().split("\\n");
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].length() <= 255) continue;
                SASCodeGeneration.displayLineLengthMessage((String)lines[i], (int)(i + 1));
                return false;
            }
            return true;
        }

        public boolean doDataExchange(boolean saveToModel) {
            if (saveToModel) {
                SourceCodePanel.this.m_strSourceCode = this.m_editor.getText();
            } else {
                this.m_editor.setText(SourceCodePanel.this.m_strSourceCode);
                this.m_editor.requestFocus();
            }
            return true;
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
            this.m_editor.SetReadOnly(!bEditable);
        }

        public String getText() {
            return this.m_editor.getText();
        }

        public void setText(String strText) {
            this.m_editor.setText(strText);
        }
    }

    protected class cMetaTypePanel
    extends WAPanel {
        protected JLabel m_lblName;
        protected WATextField m_tfName;
        protected JLabel m_lblDesc;
        protected WATextField m_tfDesc;
        protected TextStore m_mdTextStore = null;
        protected boolean m_bPnlEditable = true;

        public cMetaTypePanel() {
            this("", "");
        }

        public cMetaTypePanel(String defaultTextFieldName) {
            this(defaultTextFieldName, "");
        }

        public cMetaTypePanel(String defaultTextFieldName, String defaultTextFieldDescription) {
            this.initialize(defaultTextFieldName, defaultTextFieldDescription);
            this.layoutWidgets();
        }

        protected void initialize() {
            this.initialize("", "");
        }

        protected void initialize(String defaultTextFieldName) {
            this.initialize(defaultTextFieldName, "");
        }

        protected void initialize(String defaultTextFieldName, String defaultTextFieldDescription) {
            this.m_lblName = new JLabel();
            this.m_tfName = new WATextField();
            if (defaultTextFieldName != null && defaultTextFieldName.length() > 0) {
                this.m_tfName.setText(defaultTextFieldName);
            }
            this.m_lblDesc = new JLabel();
            this.m_tfDesc = new WATextField();
            if (defaultTextFieldDescription != null && defaultTextFieldDescription.length() > 0) {
                this.m_tfDesc.setText(defaultTextFieldDescription);
            }
            this.createLabelForName("SourceCodePanel.lblName");
            this.createLabelForDesc("SourceCodePanel.lblDesc");
            this.m_tfName.setToolTipText(bundle.getString("SourceCodePanel.tfName.ToolTip.txt"));
            this.m_tfDesc.setToolTipText(bundle.getString("SourceCodePanel.tfDesc.ToolTip.txt"));
            this.m_tfName.setMaxCharacters(60);
            this.m_tfDesc.setMaxCharacters(200);
            this.listenForDataChangesTo((JTextComponent)this.m_tfName);
            this.m_tfName.getDocument().addUndoableEditListener(new WAGUndoableEditListener());
            this.listenForDataChangesTo((JTextComponent)this.m_tfDesc);
            this.m_tfDesc.getDocument().addUndoableEditListener(new WAGUndoableEditListener());
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this.m_tfName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add(this.m_lblDesc, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)this.m_tfDesc, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)new WAPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            if (this.m_tfName.getText().length() == 0) {
                this.m_tfName.requestFocus();
                String strErrMsg = bundle.getString("SourceCodePanel.tfName.Error.txt");
                MessageUtil.displayMessage((String)strErrMsg, (int)0);
                return false;
            }
            if (SourceCodePanel.this.m_strSourceCode != null && SourceCodePanel.this.m_strSourceCode.length() > 0) {
                String[] lines = SourceCodePanel.this.m_strSourceCode.split("\\n");
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].length() <= 255) continue;
                    SASCodeGeneration.displayLineLengthMessage((String)lines[i], (int)(i + 1), (String)this.m_tfName.getName());
                    return false;
                }
            }
            return true;
        }

        public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
            if (saveToModel) {
                if (SourceCodePanel.this.m_mdStore != null) {
                    if (this.m_mdTextStore == null) {
                        String strReposID = "";
                        if (SourceCodePanel.this.m_FQIDofRepositoryToMakeTheObjectIn.length() == 0) {
                            strReposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                            strReposID = strReposID.substring(strReposID.indexOf(".") + 1);
                        } else {
                            strReposID = SourceCodePanel.this.m_FQIDofRepositoryToMakeTheObjectIn;
                        }
                        this.m_mdTextStore = (TextStore)Workspace.getMdFactory().createComplexMetadataObject(SourceCodePanel.this.m_mdStore, null, "TextStore", "TextStore", strReposID, null);
                    }
                    this.m_mdTextStore.setName(this.getMetaName());
                    this.m_mdTextStore.setDesc(this.getMetaDesc());
                    this.m_mdTextStore.setStoredText(SourceCodePanel.this.getSourceCode());
                }
            } else if (SourceCodePanel.this.m_mdText != null && SourceCodePanel.this.m_mdText instanceof TextStore) {
                this.m_mdTextStore = (TextStore)SourceCodePanel.this.m_mdText;
                this.m_tfName.setText(this.m_mdTextStore.getName());
                this.m_tfDesc.setText(this.m_mdTextStore.getDesc());
                SourceCodePanel.this.m_strSourceCode = this.m_mdTextStore.getStoredText();
            }
            this.setDataChanged(false);
            this.getWAUndoManager().discardAllEdits();
            return true;
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
            this.m_bPnlEditable = bEditable;
            this.m_tfName.setEditable(bEditable);
            this.m_tfDesc.setEditable(bEditable);
        }

        public WATextField getTextStoreNameText() {
            return this.m_tfName;
        }

        public WATextField getTextStoreDescriptionText() {
            return this.m_tfDesc;
        }

        public void setButtonSize(Dimension newSize) {
        }

        protected void disableMetaTypePanel() {
            this.m_lblName.setEnabled(false);
            this.m_tfName.setEnabled(false);
            this.m_tfName.setEditable(false);
            this.m_lblDesc.setEnabled(false);
            this.m_tfDesc.setEnabled(false);
            this.m_tfDesc.setEditable(false);
        }

        protected void enableMetaTypePanel() {
            if (this.m_bPnlEditable) {
                this.m_lblName.setEnabled(true);
                this.m_tfName.setEnabled(true);
                this.m_tfName.setEditable(true);
                this.m_lblDesc.setEnabled(true);
                this.m_tfDesc.setEnabled(true);
                this.m_tfDesc.setEditable(true);
            }
        }

        public String getMetaName() {
            return this.m_tfName.getText();
        }

        public void setMetaName(String strName) {
            this.m_tfName.setText(strName);
        }

        public String getMetaDesc() {
            return this.m_tfDesc.getText();
        }

        public void setMetaDesc(String strDesc) {
            this.m_tfDesc.setText(strDesc);
        }

        public void createLabelForDesc(String sKey) {
            this.m_lblDesc = WsUIUtilities.createLabelForComponent((JComponent)this.m_tfDesc, (WAdminResource)bundle, (String)sKey);
        }

        public void setInfoForDesc(String sKey) {
            this.m_lblDesc.setText(bundle.getString(sKey + ".txt"));
            this.m_lblDesc.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        }

        public void createLabelForName(String sKey) {
            this.m_lblName = WsUIUtilities.createLabelForComponent((JComponent)this.m_tfName, (WAdminResource)bundle, (String)sKey);
        }

        public void setInfoForName(String sKey) {
            this.m_lblName.setText(bundle.getString(sKey + ".txt"));
            this.m_lblName.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        }

        public TextStore getTextStoreObject() {
            return this.m_mdTextStore;
        }
    }

    protected class cFileTypePanel
    extends WAPanel {
        protected RemoteFilePanel m_pnlRemoteFile;

        public cFileTypePanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.m_pnlRemoteFile = new RemoteFilePanel();
            this.m_pnlRemoteFile.setCheckRemoteFileLineLength(true);
            this.listenForDataChangesTo(this.m_pnlRemoteFile);
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)((Object)this.m_pnlRemoteFile), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            return this.m_pnlRemoteFile.validateData();
        }

        public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
            if (!saveToModel) {
                if (SourceCodePanel.this.m_mdStore != null) {
                    if (SourceCodePanel.this.m_mdText != null && SourceCodePanel.this.m_mdText instanceof File) {
                        this.m_pnlRemoteFile.setMetadataObject((File)SourceCodePanel.this.m_mdText);
                    } else {
                        this.m_pnlRemoteFile.setMetadataStore(SourceCodePanel.this.m_mdStore);
                    }
                    this.m_pnlRemoteFile.setCreateMDFileObject(true);
                } else {
                    return false;
                }
            }
            boolean bRC = this.m_pnlRemoteFile.doDataExchange(saveToModel);
            this.setDataChanged(false);
            this.getWAUndoManager().discardAllEdits();
            return bRC;
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
            this.m_pnlRemoteFile.setEditable(bEditable);
        }

        protected void disableFileTypePanel() {
            this.m_pnlRemoteFile.setEnabled(false);
        }

        protected void enableFileTypePanel() {
            this.m_pnlRemoteFile.setEnabled(true);
        }

        protected String getPath() {
            return this.m_pnlRemoteFile.getPath();
        }

        public File getFileObject() {
            return this.m_pnlRemoteFile.getFileObject();
        }
    }

    protected class cSASTypePanel
    extends WAPanel {
        protected JLabel m_lblHost;
        protected WAComboBox m_cmbHost;
        protected JButton m_btnDefine;
        protected JLabel m_lblLibrary;
        protected WAComboBox m_cmbLibrary;
        protected JLabel m_lblCatalog;
        protected WAComboBox m_cmbCatalog;
        protected JLabel m_lblCatEntry;
        protected WAComboBox m_cmbCatEntry;
        protected SASCatalogEntry m_mdCatEntry = null;
        protected HashMap m_hmServerContexts;
        protected HashMap m_hmLibraries;
        protected HashMap m_hmCatalogs;
        protected HashMap m_hmCatEntries;
        protected boolean m_bPnlEditable = true;
        protected boolean m_bActionListenersEnabled;
        protected boolean m_bAppServerDefined;

        public cSASTypePanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            this.m_lblHost = new JLabel();
            this.m_cmbHost = new WAComboBox();
            this.m_btnDefine = new JButton();
            this.m_lblLibrary = new JLabel();
            this.m_cmbLibrary = new WAComboBox();
            this.m_lblCatalog = new JLabel();
            this.m_cmbCatalog = new WAComboBox();
            this.m_lblCatEntry = new JLabel();
            this.m_cmbCatEntry = new WAComboBox();
            this.createLabelForHost("SourceCodePanel.lblHost");
            this.createLabelForLibrary("SourceCodePanel.lblLibrary");
            this.createLabelForCatalog("SourceCodePanel.lblCatalog");
            this.createLabelForCatEntry("SourceCodePanel.lblCatEntry");
            this.setInfoForDefine("SourceCodePanel.btnDefine");
            this.m_cmbHost.setToolTipText(bundle.getString("SourceCodePanel.cmbHost.ToolTip.txt"));
            this.m_btnDefine.setToolTipText(bundle.getString("SourceCodePanel.btnDefine.ToolTip.txt"));
            this.m_cmbLibrary.setToolTipText(bundle.getString("SourceCodePanel.cmbLibrary.ToolTip.txt"));
            this.m_cmbCatalog.setToolTipText(bundle.getString("SourceCodePanel.cmbCatalog.ToolTip.txt"));
            this.m_cmbCatEntry.setToolTipText(bundle.getString("SourceCodePanel.cmbCatEntry.ToolTip.txt"));
            this.m_cmbCatalog.setEditable(true);
            this.m_cmbCatEntry.setEditable(true);
            this.m_cmbLibrary.setSorted(true);
            this.m_cmbCatalog.setSorted(true);
            this.m_cmbCatEntry.setSorted(true);
            this.m_btnDefine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppServer appServer = new AppServer();
                    AppServerDialog dlgAppServer = new AppServerDialog((Frame)Workspace.getWorkspace(), appServer, bundle.getString("RemoteFilePanel.AppServer.Info.txt"));
                    dlgAppServer.show();
                    if (dlgAppServer.getReturnValue() == 1) {
                        cSASTypePanel.this.populateHosts();
                        try {
                            cSASTypePanel.this.m_cmbHost.setSelectedItem((Object)appServer.getServerContext().getName());
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException((RemoteException)ex);
                        }
                    }
                }
            });
            this.m_cmbLibrary.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cSASTypePanel.this.m_bActionListenersEnabled) {
                        cSASTypePanel.this.m_bActionListenersEnabled = false;
                        cSASTypePanel.this.populateCatalogs();
                        cSASTypePanel.this.m_bActionListenersEnabled = true;
                    }
                }
            });
            this.m_cmbCatalog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cSASTypePanel.this.m_bActionListenersEnabled) {
                        cSASTypePanel.this.m_bActionListenersEnabled = false;
                        cSASTypePanel.this.populateCatalogEntries();
                        cSASTypePanel.this.m_bActionListenersEnabled = true;
                    }
                }
            });
            this.m_btnDefine.setEnabled(false);
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_lblHost, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)this.m_cmbHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.add(this.m_btnDefine, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.add(this.m_lblLibrary, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_cmbLibrary, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(this.m_lblCatalog, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.add((Component)this.m_cmbCatalog, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(this.m_lblCatEntry, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add((Component)this.m_cmbCatEntry, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new WAPanel(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public boolean validateData() {
            String strErrMsg = null;
            if (this.m_cmbLibrary.getSelectedItem() == null) {
                this.m_cmbLibrary.requestFocus();
                strErrMsg = bundle.getString("SourceCodePanel.cmbLibrary.Error.txt");
            } else if (((String)this.m_cmbCatalog.getSelectedItem()).trim().length() == 0) {
                this.m_cmbCatalog.requestFocus();
                strErrMsg = bundle.getString("SourceCodePanel.cmbCatalog.Error.txt");
            } else if (((String)this.m_cmbCatEntry.getSelectedItem()).trim().length() == 0) {
                this.m_cmbCatEntry.requestFocus();
                strErrMsg = bundle.getString("SourceCodePanel.cmbCatEntry.Error.txt");
            } else {
                return true;
            }
            if (strErrMsg != null) {
                MessageUtil.displayMessage((String)strErrMsg, (int)0);
            }
            return false;
        }

        public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
            if (saveToModel) {
                if (SourceCodePanel.this.m_mdStore != null) {
                    String strReposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                    strReposID = strReposID.substring(strReposID.indexOf(".") + 1);
                    SASLibrary mdLibrary = (SASLibrary)this.m_hmLibraries.get(this.m_cmbLibrary.getSelectedItem());
                    String strCatalog = (String)this.m_cmbCatalog.getSelectedItem();
                    SASCatalog mdCatalog = (SASCatalog)this.m_hmCatalogs.get(strCatalog);
                    if (mdCatalog == null) {
                        mdCatalog = (SASCatalog)Workspace.getMdFactory().createComplexMetadataObject(SourceCodePanel.this.m_mdStore, null, strCatalog, "SASCatalog", strReposID, null);
                        AssociationList alCatalogs = mdLibrary.getSASCatalogs();
                        alCatalogs.add((Object)mdCatalog);
                        alCatalogs.setState(16);
                    }
                    String strCatEntry = (String)this.m_cmbCatEntry.getSelectedItem();
                    this.m_mdCatEntry = (SASCatalogEntry)this.m_hmCatEntries.get(strCatEntry);
                    if (this.m_mdCatEntry == null) {
                        this.m_mdCatEntry = (SASCatalogEntry)Workspace.getMdFactory().createComplexMetadataObject(SourceCodePanel.this.m_mdStore, null, strCatEntry, "SASCatalogEntry", strReposID, null);
                        this.m_mdCatEntry.setAssociatedSASCatalog(mdCatalog);
                    }
                }
            } else {
                this.populateHosts();
                this.populateLibraries();
                if (SourceCodePanel.this.m_mdText != null && SourceCodePanel.this.m_mdText instanceof SASCatalogEntry) {
                    this.m_mdCatEntry = (SASCatalogEntry)SourceCodePanel.this.m_mdText;
                    SASCatalog mdCatalog = this.m_mdCatEntry.getAssociatedSASCatalog();
                    AssociationList alLibraries = mdCatalog.getLibraries();
                    SASLibrary mdLibrary = (SASLibrary)alLibraries.get(0);
                    this.m_cmbLibrary.setSelectedItem((Object)mdLibrary.getName());
                    this.m_cmbCatalog.setSelectedItem((Object)mdCatalog.getName());
                    this.m_cmbCatEntry.setSelectedItem((Object)this.m_mdCatEntry.getName());
                }
            }
            this.setDataChanged(false);
            this.getWAUndoManager().discardAllEdits();
            return true;
        }

        protected void populateHosts() {
            this.m_cmbHost.removeAllItems();
            try {
                boolean bGoToServer = SourceCodePanel.this.m_mdStore.getIsGoToServerForMetadata();
                SourceCodePanel.this.m_mdStore.setIsGotToServerForMetadata(true);
                List vecServerContexts = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)SourceCodePanel.this.m_mdStore, Workspace.getWorkspace().getDefaultRepository().getFQID(), "ServerContext", 8460, "");
                SourceCodePanel.this.m_mdStore.setIsGotToServerForMetadata(bGoToServer);
                this.m_hmServerContexts = new HashMap();
                if (vecServerContexts.size() > 0) {
                    String strDefaultSCID = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default");
                    int iSize = vecServerContexts.size();
                    for (int i = 0; i < iSize; ++i) {
                        ServerContext mdSC = (ServerContext)vecServerContexts.get(i);
                        String strSCName = mdSC.getName();
                        this.m_cmbHost.addItem((Object)strSCName);
                        this.m_hmServerContexts.put(strSCName, mdSC);
                        if (strDefaultSCID == null || mdSC.getFQID().compareTo(strDefaultSCID) != 0) continue;
                        this.m_cmbHost.setSelectedItem((Object)strSCName);
                    }
                } else {
                    throw new Exception();
                }
                this.m_bAppServerDefined = true;
                this.m_cmbHost.setEnabled(true);
            }
            catch (Exception e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                this.m_cmbHost.addItem((Object)bundle.getString("RemoteFilePanel.cmbHost.NoAppServer.txt"));
                this.m_bAppServerDefined = false;
                this.m_cmbHost.setEnabled(false);
            }
        }

        protected void populateLibraries() {
            this.m_bActionListenersEnabled = false;
            this.m_cmbLibrary.removeAllItems();
            this.m_hmLibraries = new HashMap();
            List vecLibraries = null;
            String strOptions = "<XMLSelect search=\"*[@IsDBMSLibname = '0']\"/>";
            try {
                boolean bGoToServer = SourceCodePanel.this.m_mdStore.getIsGoToServerForMetadata();
                SourceCodePanel.this.m_mdStore.setIsGotToServerForMetadata(true);
                vecLibraries = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)SourceCodePanel.this.m_mdStore, Workspace.getWorkspace().getDefaultRepository().getFQID(), "SASLibrary", 8580, strOptions);
                SourceCodePanel.this.m_mdStore.setIsGotToServerForMetadata(bGoToServer);
                if (vecLibraries != null && vecLibraries.size() > 0) {
                    for (int i = 0; i < vecLibraries.size(); ++i) {
                        SASLibrary mdLibrary = (SASLibrary)vecLibraries.get(i);
                        String strLibName = mdLibrary.getName();
                        this.m_hmLibraries.put(strLibName, mdLibrary);
                        this.m_cmbLibrary.addItem((Object)strLibName);
                    }
                    this.m_cmbLibrary.setSelectedIndex(0);
                }
            }
            catch (MdException bGoToServer) {
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.populateCatalogs();
        }

        protected void populateCatalogs() {
            SASLibrary mdLibrary;
            this.m_bActionListenersEnabled = false;
            this.m_cmbCatalog.removeAllItems();
            this.m_hmCatalogs = new HashMap();
            String strSelectedItem = (String)this.m_cmbLibrary.getSelectedItem();
            if (strSelectedItem != null && (mdLibrary = (SASLibrary)this.m_hmLibraries.get(strSelectedItem)) != null) {
                AssociationList alCatalogs = null;
                try {
                    alCatalogs = mdLibrary.getSASCatalogs();
                    if (alCatalogs != null && alCatalogs.size() > 0) {
                        for (int i = 0; i < alCatalogs.size(); ++i) {
                            SASCatalog mdCatalog = (SASCatalog)alCatalogs.get(i);
                            String strCatName = mdCatalog.getName();
                            this.m_hmCatalogs.put(strCatName, mdCatalog);
                            this.m_cmbCatalog.addItem((Object)strCatName);
                        }
                        this.m_cmbCatalog.setSelectedIndex(0);
                    }
                }
                catch (MdException i) {
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            this.populateCatalogEntries();
        }

        protected void populateCatalogEntries() {
            SASCatalog mdCatalog;
            this.m_bActionListenersEnabled = false;
            this.m_cmbCatEntry.removeAllItems();
            this.m_hmCatEntries = new HashMap();
            String strSelectedItem = (String)this.m_cmbCatalog.getSelectedItem();
            if (strSelectedItem != null && (mdCatalog = (SASCatalog)this.m_hmCatalogs.get(strSelectedItem)) != null) {
                AssociationList alCatEntries = null;
                try {
                    alCatEntries = mdCatalog.getSASCatalogEntries();
                    if (alCatEntries != null && alCatEntries.size() > 0) {
                        for (int i = 0; i < alCatEntries.size(); ++i) {
                            SASCatalogEntry mdCatEntry = (SASCatalogEntry)alCatEntries.get(i);
                            String strEntryName = mdCatEntry.getName();
                            this.m_hmCatEntries.put(strEntryName, mdCatEntry);
                            this.m_cmbCatEntry.addItem((Object)strEntryName);
                        }
                        this.m_cmbCatEntry.setSelectedIndex(0);
                    }
                }
                catch (MdException i) {
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            this.m_bActionListenersEnabled = true;
        }

        public void setEditable(boolean bEditable) {
            super.setEditable(bEditable);
            this.m_bPnlEditable = bEditable;
            this.m_cmbHost.setEnabled(bEditable);
            this.m_cmbLibrary.setEnabled(bEditable);
            this.m_cmbCatalog.setEnabled(bEditable);
            this.m_cmbCatEntry.setEnabled(bEditable);
        }

        public void setInfoForDefine(String sKey) {
            this.m_btnDefine.setText(bundle.getString(sKey + ".txt"));
            this.m_btnDefine.setMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
            this.m_btnDefine.setToolTipText(bundle.getString(sKey + ".ToolTip.txt"));
        }

        public void createLabelForCatEntry(String sKey) {
            this.m_lblCatEntry = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbCatEntry, (WAdminResource)bundle, (String)sKey);
        }

        public void setInfoForCatEntry(String sKey) {
            this.m_lblCatEntry.setText(bundle.getString(sKey + ".txt"));
            this.m_lblCatEntry.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        }

        public void createLabelForLibrary(String sKey) {
            this.m_lblLibrary = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbLibrary, (WAdminResource)bundle, (String)sKey);
        }

        public void setInfoForLibrary(String sKey) {
            this.m_lblLibrary.setText(bundle.getString(sKey + ".txt"));
            this.m_lblLibrary.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        }

        public void createLabelForCatalog(String sKey) {
            this.m_lblCatalog = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbCatalog, (WAdminResource)bundle, (String)sKey);
        }

        public void setInfoForCatalog(String sKey) {
            this.m_lblCatalog.setText(bundle.getString(sKey + ".txt"));
            this.m_lblCatalog.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        }

        public void createLabelForHost(String sKey) {
            this.m_lblHost = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbHost, (WAdminResource)bundle, (String)sKey);
        }

        public void setInfoForHost(String sKey) {
            this.m_lblHost.setText(bundle.getString(sKey + ".txt"));
            this.m_lblHost.setDisplayedMnemonic(bundle.getString(sKey + ".mnem").charAt(0));
        }

        public WAComboBox getSASCatEntryComboBox() {
            return this.m_cmbCatalog;
        }

        public WAComboBox getSASLibraryComboBox() {
            return this.m_cmbLibrary;
        }

        public WAComboBox getSASHostLocComboBox() {
            return this.m_cmbHost;
        }

        public void setButtonSize(Dimension newSize) {
        }

        protected void disableSASTypePanel() {
            this.m_lblHost.setEnabled(false);
            this.m_cmbHost.setEnabled(false);
            this.m_lblLibrary.setEnabled(false);
            this.m_cmbLibrary.setEnabled(false);
            this.m_lblCatalog.setEnabled(false);
            this.m_cmbCatalog.setEnabled(false);
            this.m_lblCatEntry.setEnabled(false);
            this.m_cmbCatEntry.setEnabled(false);
        }

        protected void enableSASTypePanel() {
            if (this.m_bPnlEditable) {
                this.m_lblHost.setEnabled(true);
                this.m_cmbHost.setEnabled(this.m_bAppServerDefined);
                this.m_lblLibrary.setEnabled(true);
                this.m_cmbLibrary.setEnabled(true);
                this.m_lblCatalog.setEnabled(true);
                this.m_cmbCatalog.setEnabled(true);
                this.m_lblCatEntry.setEnabled(true);
                this.m_cmbCatEntry.setEnabled(true);
            }
        }

        protected String getSASHostLoc() {
            return this.m_cmbHost.getSelectedItem().toString();
        }

        protected String getLibrary() {
            return this.m_cmbLibrary.getSelectedItem().toString();
        }

        protected String getCatalog() {
            return this.m_cmbCatalog.getSelectedItem().toString();
        }

        protected String getCatEntry() {
            return this.m_cmbCatEntry.getSelectedItem().toString();
        }

        public SASCatalogEntry getSASObject() {
            return this.m_mdCatEntry;
        }
    }
}

