/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.visuals.ParallelOptionsPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.border.TitledBorder;

public class ServerOptionsPropertyTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ServerOptionsPropertyTab.class);
    protected WsAppServerPanel m_pnlWsAppserver;
    protected ParallelOptionsPanel m_pnlParallel;
    private WorkspaceFile m_appDefaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
    private cAppServerListener m_appServerListener;

    public ServerOptionsPropertyTab() {
        this.initialize();
        this.setName(bundle.getString("ServerOptionsPropertyTab.Name.txt"));
    }

    protected void initialize() {
        this.m_pnlWsAppserver = new WsAppServerPanel();
        this.m_pnlWsAppserver.setUpdateDefault(true);
        this.m_pnlWsAppserver.setWillSetDataChanged(false);
        this.listenForDataChangesTo((WAPanel)this.m_pnlWsAppserver);
        this.m_pnlParallel = new ParallelOptionsPanel(this.getHelpTopic(), true);
        this.listenForDataChangesTo(this.m_pnlParallel);
        this.m_appServerListener = new cAppServerListener();
        this.m_pnlWsAppserver.addPropertyChangeListener((PropertyChangeListener)this.m_appServerListener);
        this.m_pnlParallel.setBorder(new TitledBorder(bundle.getString("ServerOptionsPropertyTab.SubmitToGridOptions.Title.txt")));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlWsAppserver, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlParallel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setHelpProduct("wdb");
        this.setHelpTopic("options_sasserver_tab");
    }

    public boolean validateData() {
        return this.m_pnlParallel.validateData() && this.m_pnlWsAppserver.validateData();
    }

    public void populateStore() throws MdException, RemoteException {
        this.m_pnlWsAppserver.populateStore();
        this.m_pnlParallel.populateStore();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_pnlWsAppserver.moveDataToStore();
        this.m_pnlParallel.moveDataToStore();
        this.m_appDefaultsFile.setPropertyString("SubmitToGrid.LogOutputFileLocation", this.m_pnlParallel.getLogOutputLocation());
        this.m_appDefaultsFile.setPropertyString("SubmitToGrid.Application", this.m_pnlParallel.getApplication());
        this.m_appDefaultsFile.setPropertyString("SubmitToGrid.Workload", this.m_pnlParallel.getWorkload());
        this.m_appDefaultsFile.setPropertyString("SubmitToGrid.SignonOptions", this.m_pnlParallel.getAdditionalSignonOptions());
        this.m_appDefaultsFile.setPropertyInt("SubmitToGrid.SignonRetries", this.m_pnlParallel.getSignonRetries());
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_pnlParallel.moveDataToView();
        this.m_pnlParallel.setLogOutputLocation(this.m_appDefaultsFile.getPropertyString("SubmitToGrid.LogOutputFileLocation"));
        this.m_pnlParallel.setApplication(this.m_appDefaultsFile.getPropertyString("SubmitToGrid.Application"));
        this.m_pnlParallel.setWorkload(this.m_appDefaultsFile.getPropertyString("SubmitToGrid.Workload"));
        this.m_pnlParallel.setAdditionalSignonOptions(this.m_appDefaultsFile.getPropertyString("SubmitToGrid.SignonOptions"));
        this.m_pnlParallel.setSignonRetries(this.m_appDefaultsFile.getPropertyInt("SubmitToGrid.SignonRetries", 3));
        this.m_pnlWsAppserver.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlWsAppserver.removePropertyChangeListener((PropertyChangeListener)this.m_appServerListener);
        this.m_pnlWsAppserver.saveSettingsAndCleanUp();
        this.m_pnlParallel.saveSettingsAndCleanUp();
        super.saveSettingsAndCleanUp();
    }

    private class cAppServerListener
    implements PropertyChangeListener {
        private cAppServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("AppServerChanged") && ServerOptionsPropertyTab.this.isListeningForChanges()) {
                ServerContext serverContext = (ServerContext)e.getNewValue();
                BaseModel mdl = null;
                OMRAdapter omr = null;
                try {
                    mdl = new BaseModel();
                    mdl.setDebugName("grid options set update");
                    mdl.setDebugName("workload update");
                    omr = new OMRAdapter((IModel)mdl, Workspace.getMdFactory(), "workload update");
                    IServer server = (IServer)omr.acquireObjectUsingTemplate((Root)serverContext);
                    ServerOptionsPropertyTab.this.m_pnlParallel.updateGridOptionsSetList(server);
                    ServerOptionsPropertyTab.this.m_pnlParallel.updateWorkloadList(server);
                }
                catch (RemoteException e1) {
                    Workspace.handleRemoteException((RemoteException)e1);
                }
                catch (MdException e1) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                }
                finally {
                    if (mdl != null) {
                        mdl.dispose();
                    }
                    if (omr != null) {
                        omr.dispose();
                    }
                }
            }
        }
    }
}

