/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.objectselector.ISelectorComplexFilter;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.objectselector.ObjectsSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectedColumnPanel
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(SelectedColumnPanel.class);
    public static final int ALL_TABLES = 0;
    public static final int PHYSICAL_TABLES = 1;
    private JLabel m_lblTable;
    private WATextField m_txtTable;
    private JLabel[] m_aColumnLabels;
    private WATextField[] m_aColumnFields;
    private JButton m_btnSelect;
    private MdObjectStore m_store;
    private Column[] m_aColumns;
    private String m_sColumnSelectorDialogDescription;
    private String m_sColumnSelectorDialogTitle;
    private String m_sColumnSelectorDialogHelpTopic = "select_column_win";
    private boolean m_bEditable;
    private int m_iTableTypes;

    public SelectedColumnPanel() {
        this(0);
    }

    public SelectedColumnPanel(int iTableTypes) {
        if (iTableTypes != 0 && iTableTypes != 1) {
            throw new IllegalArgumentException("invalid table type restriction");
        }
        this.m_iTableTypes = iTableTypes;
        this.m_txtTable = new WATextField();
        this.m_txtTable.setEditable(false);
        this.m_lblTable = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtTable, (WAdminResource)bundle, (String)"SelectedColumnPanel.Table");
        this.m_aColumns = new Column[1];
        this.m_aColumnLabels = new JLabel[1];
        this.m_aColumnFields = new WATextField[1];
        this.createColumnComponents(0);
        this.m_aColumnLabels[0].setText(bundle.getString("SelectedColumnPanel.Column.txt"));
        this.m_aColumnLabels[0].setDisplayedMnemonic(bundle.getString("SelectedColumnPanel.Column.mnem").charAt(0));
        this.m_btnSelect = WsUIUtilities.createBrowseButton();
        this.m_btnSelect.addActionListener(new cSelectListener());
        this.m_btnSelect.setToolTipText(bundle.getString("SelectedColumnPanel.SelectButton.ToolTip.txt"));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_txtTable, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_btnSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.addColumnComponents(0);
        this.setEditable(true);
    }

    private void createColumnComponents(int iColumn) {
        for (int i = iColumn; i < this.m_aColumns.length; ++i) {
            this.m_aColumnFields[i] = new WATextField();
            this.m_aColumnFields[i].setEditable(false);
            String sNumber = Integer.toString(i + 1);
            this.m_aColumnLabels[i] = new JLabel(bundle.formatString("SelectedColumnPanel.Column.fmt.txt", (Object)sNumber));
            this.m_aColumnLabels[i].setDisplayedMnemonic(sNumber.charAt(sNumber.length() - 1));
            this.m_aColumnLabels[i].setLabelFor((Component)this.m_aColumnFields[i]);
        }
    }

    private void addColumnComponents(int iColumn) {
        for (int i = iColumn; i < this.m_aColumns.length; ++i) {
            this.add((Component)this.m_aColumnLabels[i], new GridBagConstraints(0, i + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.m_aColumnFields[i], new GridBagConstraints(1, i + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
    }

    private void removeColumnComponents(int iColumn) {
        for (int i = iColumn; i < this.m_aColumns.length; ++i) {
            this.remove(this.m_aColumnLabels[i]);
            this.remove((Component)this.m_aColumnFields[i]);
        }
    }

    public void setStore(MdObjectStore store) {
        this.m_store = store;
    }

    public MdObjectStore getStore() {
        return this.m_store;
    }

    public void setColumn(Column oColumn) throws MdException, RemoteException {
        this.setColumn(0, oColumn);
    }

    public void setColumn(int iColumn, Column oColumn) throws MdException, RemoteException {
        if (oColumn != this.m_aColumns[iColumn]) {
            this.m_aColumns[iColumn] = oColumn;
            if (oColumn != null) {
                if (oColumn.getTable() instanceof PhysicalTable) {
                    PhysicalTable oTable = (PhysicalTable)oColumn.getTable();
                    this.m_aColumnFields[iColumn].setText(oColumn.getSASColumnName());
                    this.m_txtTable.setText(oTable.getSASTableName());
                } else if (oColumn.getTable() instanceof ExternalTable) {
                    ExternalTable oTable = (ExternalTable)oColumn.getTable();
                    this.m_aColumnFields[iColumn].setText(oColumn.getSASColumnName());
                    this.m_txtTable.setText(oTable.getName());
                } else if (oColumn.getTable() instanceof DataTable) {
                    DataTable oTable = oColumn.getTable();
                    this.m_aColumnFields[iColumn].setText(oColumn.getSASColumnName());
                    this.m_txtTable.setText(oTable.getTableName());
                }
            } else {
                this.m_aColumnFields[iColumn].setText("");
                this.m_txtTable.setText("");
            }
            this.fireChangeEvent();
        }
    }

    public Column getColumn() {
        return this.getColumn(0);
    }

    public Column getColumn(int iColumn) {
        return this.m_aColumns[iColumn];
    }

    public Column[] getColumns() {
        Column[] aColumns = new Column[this.m_aColumns.length];
        System.arraycopy(this.m_aColumns, 0, aColumns, 0, this.m_aColumns.length);
        return aColumns;
    }

    public void setTableLabel(String sLabel, char mnem) {
        this.m_lblTable.setText(sLabel);
        this.m_lblTable.setDisplayedMnemonic(mnem);
    }

    public void setColumnLabel(String sLabel, char mnem) {
        this.setColumnLabel(0, sLabel, mnem);
    }

    public void setColumnLabel(int iColumn, String sLabel, char mnem) {
        this.m_aColumnLabels[iColumn].setText(sLabel);
        this.m_aColumnLabels[iColumn].setDisplayedMnemonic(mnem);
    }

    public void setNumberOfColumnFields(int nColumnFields) {
        if (nColumnFields != this.m_aColumns.length) {
            if (nColumnFields < this.m_aColumns.length) {
                this.removeColumnComponents(nColumnFields);
            }
            JLabel[] aColumnLabels = new JLabel[nColumnFields];
            WATextField[] aColumnFields = new WATextField[nColumnFields];
            Column[] aColumns = new Column[nColumnFields];
            int nOld = this.m_aColumns.length;
            int nCopy = Math.min(nColumnFields, nOld);
            System.arraycopy(this.m_aColumnLabels, 0, aColumnLabels, 0, nCopy);
            System.arraycopy(this.m_aColumnFields, 0, aColumnFields, 0, nCopy);
            System.arraycopy(this.m_aColumns, 0, aColumns, 0, nCopy);
            this.m_aColumnLabels = aColumnLabels;
            this.m_aColumnFields = aColumnFields;
            this.m_aColumns = aColumns;
            if (nColumnFields > nOld) {
                this.createColumnComponents(nOld);
                this.addColumnComponents(nOld);
            }
            this.invalidate();
            this.revalidate();
        }
    }

    public int getNumberOfColumnFields() {
        return this.m_aColumns.length;
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        this.m_lblTable.setEnabled(bEnabled);
        this.m_txtTable.setEnabled(bEnabled);
        this.m_btnSelect.setEnabled(bEnabled);
        for (int i = 0; i < this.m_aColumns.length; ++i) {
            this.m_aColumnLabels[i].setEnabled(bEnabled);
            this.m_aColumnFields[i].setEnabled(bEnabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.m_lblTable.isEnabled();
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
        this.m_btnSelect.setEnabled(bEditable && this.isEnabled());
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void setSelectButtonToolTip(String sToolTip) {
        this.m_btnSelect.setToolTipText(sToolTip);
    }

    public String getSelectButtonToolTip() {
        return this.m_btnSelect.getToolTipText();
    }

    public void setColumnSelectorDialogDescription(String sColumnSelectorDialogDescription) {
        this.m_sColumnSelectorDialogDescription = sColumnSelectorDialogDescription;
    }

    public String getColumnSelectorDialogDescription() {
        return this.m_sColumnSelectorDialogDescription;
    }

    public void setColumnSelectorDialogTitle(String sColumnSelectorDialogTitle) {
        this.m_sColumnSelectorDialogTitle = sColumnSelectorDialogTitle;
    }

    public String getColumnSelectorDialogTitle() {
        return this.m_sColumnSelectorDialogTitle;
    }

    public void setColumnSelectorDialogHelpTopic(String sColumnSelectorDialogHelpTopic) {
        this.m_sColumnSelectorDialogHelpTopic = sColumnSelectorDialogHelpTopic;
    }

    public void addChangeListener(ChangeListener lsnr) {
        this.listenerList.add(ChangeListener.class, lsnr);
    }

    public void removeChangeListener(ChangeListener lsnr) {
        this.listenerList.remove(ChangeListener.class, lsnr);
    }

    protected void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        Object[] aListeners = this.listenerList.getListenerList();
        for (int iListener = aListeners.length - 2; iListener >= 0; iListener -= 2) {
            if (aListeners[iListener] != ChangeListener.class) continue;
            ChangeListener lsnr = (ChangeListener)aListeners[iListener + 1];
            lsnr.stateChanged(e);
        }
    }

    @Override
    public void requestFocus() {
        this.m_txtTable.requestFocus();
    }

    private class cSelectorFilter
    implements ISelectorComplexFilter {
        ISimpleObjectFilter m_delegateFilter = ObjectSelectorFilterFactory.createObjectFilter((String[])new String[]{"Column"});

        private cSelectorFilter() {
        }

        public boolean accept(SimpleObject simpleObject) {
            return this.m_delegateFilter.accept(simpleObject);
        }

        public boolean accept(List lItems, List lTargets) {
            return this.areAllColumnsInSameTable(lItems, lTargets);
        }

        public String getReasonForRejection(List lItems, List lTargets) {
            if (!this.areAllColumnsInSameTable(lItems, lTargets)) {
                return bundle.getString("SelectedColumnPanel.SameTableError.txt");
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean areAllColumnsInSameTable(List lSources, List lTargets) {
            SimpleObject testColumn = !lTargets.isEmpty() ? (SimpleObject)lTargets.get(0) : (SimpleObject)lSources.get(0);
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "SelectedColumnPanel:cSelectorFilter");
                try {
                    Column testMDColumn = (Column)ObjectConverter.getInstance().convertToJOMAObject(store, testColumn);
                    String sTestTableID = testMDColumn.getTable().getFQID();
                    int iSource = 0;
                    while (iSource < lSources.size()) {
                        SimpleObject column = (SimpleObject)lSources.get(iSource);
                        Column mdColumn = (Column)ObjectConverter.getInstance().convertToJOMAObject(store, column);
                        String sTableID = mdColumn.getTable().getFQID();
                        if (!sTestTableID.equals(sTableID)) {
                            boolean bl = false;
                            return bl;
                        }
                        ++iSource;
                    }
                    return true;
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                    return true;
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return true;
        }
    }

    protected class cSelectListener
    implements ActionListener {
        protected cSelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectedColumnPanel.this.m_store == null) {
                throw new UnsupportedOperationException("SelectedColumnPanel's store is null.");
            }
            try {
                String sTitle = SelectedColumnPanel.this.m_sColumnSelectorDialogTitle;
                if (sTitle == null) {
                    sTitle = bundle.getString("SelectedColumnPanel.DialogTitle.txt");
                }
                ArrayList<SimpleObject> lColumns = new ArrayList<SimpleObject>(SelectedColumnPanel.this.m_aColumns.length);
                for (int iColumn = 0; iColumn < SelectedColumnPanel.this.m_aColumns.length; ++iColumn) {
                    if (SelectedColumnPanel.this.m_aColumns[iColumn] == null) continue;
                    Column column = SelectedColumnPanel.this.m_aColumns[iColumn];
                    SimpleObject simpleColumn = ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)column);
                    lColumns.add(simpleColumn);
                }
                SimpleObject[] aColumns = lColumns.toArray(new SimpleObject[lColumns.size()]);
                int columnTypes = 4;
                if (SelectedColumnPanel.this.m_iTableTypes == 1) {
                    columnTypes = 7;
                }
                ObjectsSelectorPanel pnlMain = new ObjectsSelectorPanel(Workspace.getWorkspace().getUserContext(), columnTypes, SelectedColumnPanel.this.m_sColumnSelectorDialogDescription);
                pnlMain.setMaxSelectionCount(SelectedColumnPanel.this.m_aColumns.length);
                pnlMain.setMinSelectionCount(SelectedColumnPanel.this.m_aColumns.length);
                pnlMain.setSelectableObjectsFilter((ISimpleObjectFilter)new cSelectorFilter());
                pnlMain.setSelectedObjects(aColumns);
                WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnlMain);
                dlg.setResizable(true);
                dlg.setHelpProduct("wdb");
                dlg.setHelpTopic(SelectedColumnPanel.this.m_sColumnSelectorDialogHelpTopic);
                dlg.show();
                if (dlg.getReturnValue() == 1) {
                    SimpleObject[] aSelectedColumns = pnlMain.getSelectedObjects();
                    Root[] aMDColumns = ObjectConverter.getInstance().convertToJOMAObjects(SelectedColumnPanel.this.m_store, aSelectedColumns);
                    int nColumns = Math.min(aMDColumns.length, SelectedColumnPanel.this.m_aColumns.length);
                    for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                        Column oSelectedColumn = (Column)aMDColumns[iColumn];
                        SelectedColumnPanel.this.setColumn(iColumn, oSelectedColumn);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

