/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.codegen.TableLoaderOptions;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SPDSLoaderLoadTechniquePropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(SPDSLoaderLoadTechniquePropertyTab.class);
    protected static String REFRESH_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Refresh.display.option.txt");
    protected static String APPEND_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Append.display.option.txt");
    protected static String UPDATE_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Update.display.option.txt");
    protected static String DROP_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.display.option.txt");
    protected static String TRUNCATE_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.display.option.txt");
    protected static String REMOVE_VALUE = bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.display.option.txt");
    private static final String TRUNCATE = "Truncate";
    private static final String APPEND = "Append";
    private static final String UPDATE = "Update";
    private static final String REFRESH = "Refresh";
    private static final String DROP = "Drop";
    private static final String REMOVE = "Remove";
    protected JCheckBox m_chkRecreateIndex;
    protected JCheckBox m_chkParallelIndex;
    protected WAPanel m_panel;
    protected boolean m_hasUniqueKey;
    protected WAPanel m_pnlLoadType;
    protected JLabel m_lblLoadType;
    protected WAComboBox m_cmbLoadType;
    protected WAPanel m_pnlDelete;
    protected ButtonGroup m_bgpDelete;
    protected JRadioButton m_rdoTruncate = null;
    protected JRadioButton m_rdoRemove = null;
    protected JRadioButton m_rdoDrop = null;
    protected ClassifierMap m_metadata;
    protected WAIntTextField m_txtLimitParallel;
    protected JLabel m_lblLimitParallel;
    protected boolean m_editable;
    private String m_loadValue;

    public SPDSLoaderLoadTechniquePropertyTab(CMetadata metadata) {
        try {
            if (metadata.getCMetadataType().compareTo("TransformationStep") == 0) {
                AssociationList transList = ((TransformationStep)metadata).getTransformations();
                this.m_metadata = (ClassifierMap)transList.get(0);
            } else {
                this.m_metadata = (ClassifierMap)metadata;
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("load_technique_spds_tab");
    }

    public void initialize() {
        try {
            this.m_pnlLoadType = new WAPanel();
            this.m_lblLoadType = new JLabel(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.label.txt"));
            this.m_lblLoadType.setDisplayedMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.mnem").charAt(0));
            this.m_cmbLoadType = new WAComboBox();
            this.m_cmbLoadType.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.LoadTechnique.Tooltip.txt"));
            this.m_lblLoadType.setLabelFor((Component)this.m_cmbLoadType);
            this.m_cmbLoadType.addItem((Object)REFRESH_VALUE);
            this.m_cmbLoadType.addItem((Object)APPEND_VALUE);
            this.m_cmbLoadType.addItem((Object)UPDATE_VALUE);
            Dimension dim = this.m_cmbLoadType.getPreferredSize();
            dim.width += 2;
            this.m_cmbLoadType.setMinimumSize(dim);
            this.m_cmbLoadType.setPreferredSize(dim);
            this.m_cmbLoadType.addActionListener((ActionListener)new LoadTypeListener());
            this.m_pnlDelete = new WAPanel();
            this.m_pnlDelete.setBorder((Border)new TitledBorder(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.DropTruncate.label.txt")));
            this.m_bgpDelete = new ButtonGroup();
            this.m_rdoTruncate = new JRadioButton(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.display.option.txt"));
            this.m_rdoTruncate.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.Tooltip.txt"));
            this.m_rdoTruncate.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Truncate.mnem").charAt(0));
            this.m_rdoTruncate.addActionListener(new DropTableListener());
            this.m_bgpDelete.add(this.m_rdoTruncate);
            this.m_rdoRemove = new JRadioButton(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.display.option.txt"));
            this.m_rdoRemove.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.Tooltip.txt"));
            this.m_rdoRemove.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Remove.mnem").charAt(0));
            this.m_rdoRemove.addActionListener(new DropTableListener());
            this.m_bgpDelete.add(this.m_rdoRemove);
            this.m_rdoDrop = new JRadioButton(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.display.option.txt"));
            this.m_rdoDrop.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.Tooltip.txt"));
            this.m_rdoDrop.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Delete.Drop.mnem").charAt(0));
            this.m_rdoDrop.addActionListener(new DropTableListener());
            this.m_bgpDelete.add(this.m_rdoDrop);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this), e.toString(), "", 0);
        }
        this.m_rdoTruncate.setSelected(true);
        super.initialize();
        this.m_chkRecreateIndex = new JCheckBox(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexes.label.txt"));
        this.m_chkRecreateIndex.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexes.Tooltip.txt"));
        this.m_chkRecreateIndex.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.RecreateIndexes.mnem").charAt(0));
        this.m_chkRecreateIndex.addActionListener(new RecreateIndexListener());
        this.listenForDataChangesTo(this.m_chkRecreateIndex);
        this.m_chkParallelIndex = new JCheckBox(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.label.txt"));
        this.m_chkParallelIndex.setToolTipText(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.Tooltip.txt"));
        this.m_chkParallelIndex.setMnemonic(bundle.getString("SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.mnem").charAt(0));
        this.m_chkParallelIndex.addActionListener(new ParallelIndexListener());
        this.listenForDataChangesTo(this.m_chkRecreateIndex);
        this.m_txtLimitParallel = new WAIntTextField();
        this.m_txtLimitParallel.setColumns(3);
        this.m_lblLimitParallel = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtLimitParallel, (WAdminResource)bundle, (String)"SPDSLoaderLoadTechniquePropertyTab.ParallelIndexes.Limit");
        this.m_txtLimitParallel.setEnabled(false);
        this.m_txtLimitParallel.setEditable(false);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        AssociationList targetList = this.m_metadata.getClassifierTargets();
        PhysicalTable targetTable = null;
        if (targetList.size() > 0) {
            targetTable = (PhysicalTable)targetList.get(0);
        }
        if (targetTable == null) {
            this.setEditable(false);
            return;
        }
        AssociationList indexes = targetTable.getIndexes();
        if (indexes.size() > 0) {
            for (int i = 0; i < indexes.size(); ++i) {
                Index ind = (Index)indexes.get(i);
                if (ind.getIsUnique() != 1) continue;
                this.m_hasUniqueKey = true;
                break;
            }
        }
        TableLoaderOptions TLO = new TableLoaderOptions(this.m_metadata);
        String loadType = TLO.getLoadType();
        boolean refresh = false;
        if (loadType.equals(APPEND_VALUE)) {
            this.m_cmbLoadType.setSelectedItem((Object)APPEND_VALUE);
        } else if (loadType.equals(UPDATE_VALUE)) {
            this.m_cmbLoadType.setSelectedItem((Object)UPDATE_VALUE);
        } else {
            this.m_cmbLoadType.setSelectedItem((Object)REFRESH_VALUE);
            refresh = true;
        }
        if (refresh) {
            String delete = TLO.getTruncateValue();
            if (delete == null || delete.compareTo("") == 0) {
                this.m_rdoTruncate.setSelected(true);
            } else if (TLO.getTruncate()) {
                this.m_rdoTruncate.setSelected(true);
                this.m_chkRecreateIndex.setEnabled(this.m_editable);
                if (this.m_editable) {
                    this.m_chkParallelIndex.setEnabled(TLO.getRecreateIndex());
                }
            } else if (TLO.getRemove()) {
                this.m_rdoRemove.setSelected(true);
                this.m_chkRecreateIndex.setEnabled(this.m_editable);
                if (this.m_editable) {
                    this.m_chkParallelIndex.setEnabled(TLO.getRecreateIndex());
                }
            } else {
                this.m_rdoDrop.setSelected(true);
                this.m_chkRecreateIndex.setEnabled(false);
                this.m_chkParallelIndex.setEnabled(this.m_editable);
            }
        } else {
            this.m_chkRecreateIndex.setEnabled(this.m_editable);
            if (this.m_editable) {
                this.m_chkParallelIndex.setEnabled(TLO.getParallelIndex());
                this.m_txtLimitParallel.setEnabled(TLO.getParallelIndex());
            }
        }
        if (TLO.getRecreateIndex()) {
            this.m_chkParallelIndex.setEnabled(this.m_editable);
        }
        this.m_txtLimitParallel.setText(TLO.getParallelGroupOption());
        this.m_chkRecreateIndex.setSelected(TLO.getRecreateIndex());
        this.m_chkParallelIndex.setSelected(TLO.getParallelIndex());
        if (TLO.getParallelIndex()) {
            this.m_txtLimitParallel.setEditable(this.m_editable);
            this.m_txtLimitParallel.setEnabled(this.m_editable);
        }
        this.setDataChanged(false);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        TableLoaderOptions TLO = new TableLoaderOptions(this.m_metadata);
        if (((String)this.m_cmbLoadType.getSelectedItem()).equals(APPEND_VALUE)) {
            TLO.setLoadType(APPEND);
        } else if (((String)this.m_cmbLoadType.getSelectedItem()).equals(UPDATE_VALUE)) {
            TLO.setLoadType(UPDATE);
        } else {
            TLO.setLoadType(REFRESH);
        }
        if (this.m_rdoTruncate.isSelected()) {
            TLO.setTruncate(TRUNCATE);
            TLO.setRemove(TRUNCATE);
        } else if (this.m_rdoRemove.isSelected()) {
            TLO.setTruncate(REMOVE);
            TLO.setRemove(REMOVE);
        } else if (this.m_rdoDrop.isSelected()) {
            TLO.setTruncate(DROP);
            TLO.setRemove(DROP);
        }
        TLO.setRecreateIndex(this.m_chkRecreateIndex.isSelected());
        TLO.setParallelIndex(this.m_chkParallelIndex.isSelected());
        TLO.setParallelGroupOption(this.m_txtLimitParallel.getText());
        this.setDataChanged(false);
    }

    public boolean loadTypeChange() {
        boolean refresh = false;
        if (this.m_loadValue == (String)this.m_cmbLoadType.getSelectedItem()) {
            return false;
        }
        this.m_loadValue = (String)this.m_cmbLoadType.getSelectedItem();
        this.m_chkRecreateIndex.setSelected(false);
        this.m_chkParallelIndex.setSelected(false);
        this.m_chkRecreateIndex.setEnabled(false);
        this.m_chkParallelIndex.setEnabled(false);
        if (((String)this.m_cmbLoadType.getSelectedItem()).equals(REFRESH_VALUE)) {
            this.m_rdoTruncate.setEnabled(this.m_editable);
            this.m_rdoRemove.setEnabled(this.m_editable);
            this.m_rdoDrop.setEnabled(this.m_editable);
            if (this.m_editable) {
                refresh = true;
            }
        } else {
            this.m_chkRecreateIndex.setEnabled(this.m_editable);
            this.m_chkRecreateIndex.setSelected(false);
        }
        this.m_rdoTruncate.setEnabled(refresh);
        this.m_rdoRemove.setEnabled(refresh);
        this.m_rdoDrop.setEnabled(refresh);
        if (refresh) {
            this.dropTableChange();
        }
        return true;
    }

    public void recreateIndexChange() {
        if (this.m_chkRecreateIndex.isSelected()) {
            this.m_chkParallelIndex.setEnabled(this.m_editable);
        } else {
            this.m_chkParallelIndex.setSelected(false);
            this.m_chkParallelIndex.setEnabled(false);
        }
        this.parallelIndexChange();
    }

    public void parallelIndexChange() {
        if (this.m_chkParallelIndex.isSelected()) {
            this.m_txtLimitParallel.setEnabled(this.m_editable);
            this.m_txtLimitParallel.setEditable(this.m_editable);
        } else {
            this.m_txtLimitParallel.setText("0");
            this.m_txtLimitParallel.setEnabled(false);
            this.m_txtLimitParallel.setEditable(false);
        }
    }

    public void dropTableChange() {
        boolean recreateIndex = false;
        boolean recreateEnabled = false;
        if (this.m_editable) {
            recreateEnabled = true;
        }
        boolean parallelIndex = false;
        this.m_chkParallelIndex.setEnabled(false);
        if (this.m_rdoTruncate.isSelected() || this.m_rdoRemove.isSelected()) {
            recreateIndex = false;
            parallelIndex = false;
        } else if (this.m_rdoDrop.isSelected()) {
            recreateIndex = true;
            recreateEnabled = false;
            parallelIndex = true;
            this.m_chkParallelIndex.setEnabled(this.m_editable);
        }
        this.m_chkRecreateIndex.setEnabled(recreateEnabled);
        this.m_chkRecreateIndex.setSelected(recreateIndex);
        this.m_chkParallelIndex.setSelected(parallelIndex);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.m_pnlLoadType.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlLoadType.add((Component)this.m_lblLoadType, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.m_pnlLoadType.add((Component)this.m_cmbLoadType, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanel m_pnlIndexes = new JPanel();
        m_pnlIndexes.setLayout(new GridBagLayout());
        m_pnlIndexes.add((Component)this.m_chkRecreateIndex, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlIndexes.add((Component)this.m_chkParallelIndex, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlIndexes.add((Component)this.m_lblLimitParallel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        m_pnlIndexes.add((Component)this.m_txtLimitParallel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel m_pnlTechnique = new JPanel();
        m_pnlTechnique.setLayout(new GridBagLayout());
        m_pnlTechnique.add((Component)this.m_rdoTruncate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlTechnique.add((Component)this.m_rdoRemove, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        m_pnlTechnique.add((Component)this.m_rdoDrop, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelete.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlDelete.add((Component)m_pnlTechnique, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlDelete.add((Component)m_pnlIndexes, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlLoadType, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_pnlDelete, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_cmbLoadType.setEnabled(bEditable);
        this.m_rdoTruncate.setEnabled(bEditable);
        this.m_rdoDrop.setEnabled(bEditable);
        this.m_rdoRemove.setEnabled(bEditable);
        this.m_chkRecreateIndex.setEnabled(bEditable);
        this.m_chkParallelIndex.setEnabled(bEditable);
        this.m_editable = bEditable;
    }

    public boolean validateData() {
        try {
            AssociationList targetList = this.m_metadata.getClassifierTargets();
            if (targetList.size() == 0) {
                return true;
            }
        }
        catch (MdException e) {
            return true;
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (!this.m_hasUniqueKey && this.m_cmbLoadType.getSelectedIndex() == 2) {
            JOptionPane.showConfirmDialog((Component)((Object)this), bundle.getString("SPDSLoaderLoadTechniquePropertyTab.UpdateUniqueIndexWarning.msg.txt"), bundle.getString("SPDSLoaderLoadTechniquePropertyTab.Warning.title.txt"), 2, 0);
            return false;
        }
        return true;
    }

    private class ParallelIndexListener
    implements ActionListener {
        private ParallelIndexListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
            SPDSLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class RecreateIndexListener
    implements ActionListener {
        private RecreateIndexListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSLoaderLoadTechniquePropertyTab.this.recreateIndexChange();
            SPDSLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }

    private class LoadTypeListener
    implements ActionListener {
        private LoadTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SPDSLoaderLoadTechniquePropertyTab.this.loadTypeChange()) {
                SPDSLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
                SPDSLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
            }
        }
    }

    private class DropTableListener
    implements ActionListener {
        private DropTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SPDSLoaderLoadTechniquePropertyTab.this.dropTableChange();
            SPDSLoaderLoadTechniquePropertyTab.this.parallelIndexChange();
            SPDSLoaderLoadTechniquePropertyTab.this.setDataChanged(true);
        }
    }
}

