/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

public class SASParallelMaximumConcurrentProcessesPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(SASParallelMaximumConcurrentProcessesPanel.class);
    public static String MAX_CONCURRENT_CHANGED = "MaximumConcurrentProcessesChanged";
    private static final int CONCURRENT_DEFAULT = 1;
    public static final String VALUE_NNODES = "NNODES";
    public static final String VALUE_ALL = "ALL";
    public static final String DEFAULT_SETTING = "NNODES";
    private ButtonGroup m_btnGrpMaxCurrentProcs;
    private JRadioButton m_rbtNNodes;
    private JRadioButton m_rbtAllProcesses;
    private JRadioButton m_rbtThisNumber;
    private WAIntTextField m_txtThisNumber;
    private String m_title;
    private String m_maxSetting = "NNODES";

    public SASParallelMaximumConcurrentProcessesPanel(String title) {
        this.m_title = title;
        this.initialize();
    }

    protected void initialize() {
        this.m_rbtNNodes = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"SASParallelMaximumConcurrentProcessesPanel.MaximumProcs.NNodes");
        this.m_rbtNNodes.addActionListener((ActionListener)((Object)new cUseThisNumberAction()));
        this.listenForDataChangesTo(this.m_rbtNNodes);
        this.m_rbtAllProcesses = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"SASParallelMaximumConcurrentProcessesPanel.MaximumProcs.AllProcesses");
        this.m_rbtAllProcesses.addActionListener((ActionListener)((Object)new cUseThisNumberAction()));
        this.listenForDataChangesTo(this.m_rbtAllProcesses);
        this.m_rbtThisNumber = WsUIUtilities.createRadioButton((WAdminResource)bundle, (String)"SASParallelMaximumConcurrentProcessesPanel.MaximumProcs.ThisNumber");
        this.m_rbtThisNumber.addActionListener((ActionListener)((Object)new cUseThisNumberAction()));
        this.listenForDataChangesTo(this.m_rbtThisNumber);
        this.m_txtThisNumber = new WAIntTextField(false);
        this.m_txtThisNumber.setColumns(10);
        this.m_txtThisNumber.setMinimumSize(this.m_txtThisNumber.getPreferredSize());
        this.m_txtThisNumber.setToolTipText(bundle.getString("SASParallelMaximumConcurrentProcessesPanel.MaximumProcs.ThisNumber.TextField.tip"));
        this.m_txtThisNumber.setValue(1);
        this.listenForDataChangesTo((JTextComponent)this.m_txtThisNumber);
        this.m_btnGrpMaxCurrentProcs = new ButtonGroup();
        this.m_btnGrpMaxCurrentProcs.add(this.m_rbtNNodes);
        this.m_btnGrpMaxCurrentProcs.add(this.m_rbtAllProcesses);
        this.m_btnGrpMaxCurrentProcs.add(this.m_rbtThisNumber);
        this.setLayout(new GridBagLayout());
        this.setBorder(WsUIUtilities.createTitledBorder((String)this.m_title));
        this.add(this.m_rbtNNodes, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_rbtThisNumber, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.m_txtThisNumber, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.m_rbtAllProcesses, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        if (this.m_rbtThisNumber.isEnabled() && this.m_rbtThisNumber.isSelected()) {
            try {
                this.m_txtThisNumber.getValue2();
            }
            catch (WAIntTextField.IllegalIntegerException exc) {
                MessageUtil.displayMessage((String)exc.getLocalizedMessage(), (int)0);
                return false;
            }
        }
        return true;
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        if (this.m_maxSetting == null || this.m_maxSetting.equals("NNODES") || "".equals(this.m_maxSetting)) {
            this.m_rbtNNodes.setSelected(true);
        } else if (this.m_maxSetting.equals(VALUE_ALL)) {
            this.m_rbtAllProcesses.setSelected(true);
        } else {
            this.m_rbtThisNumber.setSelected(true);
            if (this.m_maxSetting.length() == 0) {
                this.m_maxSetting = Integer.toString(1);
            }
            this.m_txtThisNumber.setText(this.m_maxSetting);
        }
        this.setUseThisNumberEditable();
        this.setListeningForChanges(true);
        this.setDataChanged(false);
    }

    public void moveDataToStore() {
        if (!this.hasDataChanged()) {
            return;
        }
        this.m_maxSetting = this.m_rbtNNodes.isSelected() ? "NNODES" : (this.m_rbtAllProcesses.isSelected() ? VALUE_ALL : Integer.toString(this.m_txtThisNumber.getValue()));
        this.setDataChanged(false);
    }

    public String getDefaultSetting() {
        return "NNODES";
    }

    public String getMaximumConcurrentSetting() {
        this.moveDataToStore();
        return this.m_maxSetting;
    }

    public void setMaximumConcurrentSetting(String maxSetting) {
        this.m_maxSetting = "".equals(maxSetting) ? "NNODES" : maxSetting;
        this.moveDataToView();
    }

    public void setEditable(boolean editable) {
        this.m_rbtAllProcesses.setEnabled(editable);
        this.m_rbtNNodes.setEnabled(editable);
        this.m_rbtThisNumber.setEnabled(editable);
        this.setUseThisNumberEditable();
    }

    private void setUseThisNumberEditable() {
        this.m_txtThisNumber.setEditable(this.isEditable() && this.m_rbtThisNumber.isSelected());
    }

    private class cUseThisNumberAction
    extends WsAbstractAction {
        public void actionPerformed(ActionEvent event) {
            SASParallelMaximumConcurrentProcessesPanel.this.firePropertyChange(MAX_CONCURRENT_CHANGED, null, SASParallelMaximumConcurrentProcessesPanel.this.getMaximumConcurrentSetting());
            SASParallelMaximumConcurrentProcessesPanel.this.setUseThisNumberEditable();
        }
    }
}

