/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class SASLibnameDialog
extends WAStandardDialog {
    private static WAdminResource bundle = WAdminResource.getBundle(SASLibnameDialog.class);

    public SASLibnameDialog(SASLibrary metadata) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("SASLibnameDialog.Title.txt"), true);
        cSASLibnamePanel m_pnlSASLibname = new cSASLibnamePanel((CMetadata)metadata);
        this.setMainPanel(m_pnlSASLibname);
        this.setEditable(false);
        this.setHelpProduct("wdb");
        this.setHelpTopic("display_libname");
    }

    class cSASLibnamePanel
    extends WAPanel {
        protected CMetadata m_metadata;
        protected JLabel m_labelField;
        protected JScrollPane m_labelScroll;
        protected WATextArea m_libnameField;
        protected JScrollPane m_libnameScroll;
        protected String m_sLibname;

        public cSASLibnamePanel(CMetadata metadata) {
            this.m_metadata = metadata;
            this.initialize();
            this.layoutWidgets();
        }

        public void initialize() {
            try {
                this.m_labelField = new JLabel(bundle.formatString("SASLibnameDialog.LibnameLabel.fmt", (Object)this.m_metadata.getName()));
                this.m_libnameField = new WATextArea();
                this.m_libnameField.setLineWrap(true);
                this.m_libnameField.setWrapStyleWord(true);
                this.m_libnameField.setBehavior(2);
                this.m_libnameField.setAutoSelect(false);
                Font font = this.m_libnameField.getFont();
                this.m_libnameField.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
                this.m_libnameScroll = new JScrollPane((Component)this.m_libnameField);
                this.m_libnameScroll.setBorder(new BevelBorder(1));
                this.m_libnameScroll.setPreferredSize(new Dimension(500, 200));
                this.setLayout(new GridBagLayout());
                this.add(this.m_labelField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.add(this.m_libnameScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public void moveDataToView() {
            this.m_libnameField.setText(this.m_sLibname);
            this.m_libnameField.setCaretPosition(0);
        }

        public void populateStore() throws MdException, RemoteException {
            ArrayList<String> lAssociations = new ArrayList<String>(2);
            lAssociations.add("DeployedComponents");
            lAssociations.add("UsingPackages");
            lAssociations.add("Properties");
            int fFlags = 24840;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths(this.m_metadata, null, lAssociations, null, fFlags);
            this.m_sLibname = LibraryUtil.getAccessPath((SASLibrary)((SASLibrary)this.m_metadata));
        }

        public boolean validateData() {
            return true;
        }
    }
}

