/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IGridServer;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.SASParallelMaximumConcurrentProcessesPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.visuals.objectselector.ISelectorFeedbackFilter;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class SASCodeGenerationOptionsPropertyTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(SASCodeGenerationOptionsPropertyTab.class);
    public static final String GENERATE_WARNINGS_FOR_MAPPINGS = "Workspace.GenerateWarningsForMappings";
    public static final String KEY_ALTERNATE_TEMPORARY_LIBRARY = "Workspace.AlternateJobLibrary";
    public static final String KEY_CHECKPOINT_LIBRARY = "Workspace.DefaultCheckpointStateLibrary";
    public static final String KEY_ENABLE_JOB_CHECKPOINTS = "Workspace.EnableJobCheckpoints";
    public static final String KEY_GENERATE_LINE_LENGTHS_LESS_THAN_EIGHTY = "Workspace.GenerateLineLengthsLessThanEighty";
    private JCheckBox m_ckbEnableMacroVariables;
    private JCheckBox m_ckbJCL;
    private JCheckBox m_ckbLineLengthsLessThanEighty;
    private JCheckBox m_ckbEnableParallelMacros;
    private JCheckBox m_ckbGenerateJobStatusHandlingLast;
    private JCheckBox m_ckbUseNLSDateFormat;
    private JCheckBox m_ckbGenerateWarningsForMappings;
    private JLabel m_lblApplication;
    private WAComboBox m_cmbApplication;
    private JLabel m_lblWorkload;
    private WAComboBox m_cmbWorkload;
    private Workspace m_workspace;
    private WorkspaceFile m_appDefaultsFile;
    private static final String NONE = bundle.getString("Common.None.txt");
    private static final String SELECT = bundle.getString("Common.Select.txt");
    private List<String> m_lstApplication = new ArrayList<String>();
    private List<String> m_lstWorkload = new ArrayList<String>();
    private SASParallelMaximumConcurrentProcessesPanel m_pnlMaxCurrentProcs;
    private WAPanel m_pnlNewJobOptions;
    private WAPanel m_pnlNewTransformOptions;
    private WAPanel m_pnlGridEnabledTransformationOptions;
    private WATextField m_txtCheckpointLibrary;
    private JButton m_btnCheckpointLibraryBrowse;
    private ActionListener m_btnCheckpointLibraryListener;
    private JLabel m_lblCheckpointLibrary;
    private SimpleObject m_checkpointLibrary;
    private WATextField m_txtAlternateLibrary;
    private JButton m_btnAlternateLibraryBrowse;
    private ActionListener m_btnAlternateLibraryListener;
    private JLabel m_lblAlternateLibrary;
    private SimpleObject m_alternateLibrary;
    private WATextField m_txtHadoopServer;
    private JButton m_btnHadoopServerBrowse;
    private ActionListener m_btnHadoopServerListener;
    private JLabel m_lblHadoopServer;
    private SimpleObject m_hadoopServer;

    public SASCodeGenerationOptionsPropertyTab() {
        this.setHelpTopic("options_codegen_tab");
        this.m_workspace = Workspace.getWorkspace();
        this.m_appDefaultsFile = this.m_workspace.getAppDefaultsFile();
        this.initialize();
        this.setName(bundle.getString("SASCodeGenerationOptionsTab.Name.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        this.createNewJobOptionsPanel();
        this.createNewTransformOptionsPanel();
        this.createGridEnabledTransformationOptionsPanel();
        String defaultAppServerid = WsAppServer.getDefaultAppServerFQID();
        if (defaultAppServerid != null && defaultAppServerid.length() > 0) {
            try {
                BaseModel model = null;
                OMRAdapter omr = null;
                try {
                    model = new BaseModel();
                    omr = new OMRAdapter((IModel)model, Workspace.getMdFactory(), "SASCodeGenerationOptionsPropertyTab");
                    Root server = omr.acquireOMRObject(defaultAppServerid, "ServerContext");
                    IGridServer gridServer = null;
                    if (server != null) {
                        IServer mServer = (IServer)omr.acquireObjectUsingTemplate(server);
                        gridServer = mServer.getGridServer();
                    }
                    if (gridServer != null) {
                        this.m_lstWorkload = gridServer.getWorkloads();
                        this.m_lstApplication = gridServer.getGridOptionSets();
                    } else {
                        this.m_lstWorkload = new ArrayList<String>();
                        this.m_lstApplication = new ArrayList<String>();
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Reading");
                }
                finally {
                    if (model != null) {
                        model.dispose();
                    }
                    if (omr != null) {
                        omr.dispose();
                    }
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.m_lstApplication.size() == 0) {
            this.m_lstApplication.add(0, NONE);
        } else if (this.m_lstApplication.size() > 1) {
            this.m_lstApplication.add(0, SELECT);
        }
        this.m_cmbApplication.addItems(this.m_lstApplication);
        this.listenForDataChangesTo((JComboBox)this.m_cmbApplication);
        this.m_lstWorkload.add(0, NONE);
        this.m_cmbWorkload.addItems(this.m_lstWorkload);
        this.listenForDataChangesTo((JComboBox)this.m_cmbWorkload);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlNewJobOptions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_pnlNewTransformOptions, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_pnlGridEnabledTransformationOptions, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
    }

    private void createNewJobOptionsPanel() {
        this.m_pnlNewJobOptions = new WAPanel();
        this.m_pnlNewJobOptions.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlNewJobOptions.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("SASCodeGenerationOptionsTab.NewJob.TitleBorder.txt")));
        this.m_ckbEnableMacroVariables = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.EnableMacroVariables", (int)5);
        this.listenForDataChangesTo(this.m_ckbEnableMacroVariables);
        this.m_ckbJCL = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.GenerateJCL", (int)5);
        this.listenForDataChangesTo(this.m_ckbJCL);
        this.m_ckbLineLengthsLessThanEighty = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.GenerateLineLengthsLessThanEighty", (int)5);
        this.listenForDataChangesTo(this.m_ckbLineLengthsLessThanEighty);
        this.m_ckbEnableParallelMacros = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.EnableParallelMacros", (int)5);
        this.listenForDataChangesTo(this.m_ckbEnableParallelMacros);
        this.m_ckbGenerateJobStatusHandlingLast = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.GenerateSendJobStatusLast", (int)5);
        this.listenForDataChangesTo(this.m_ckbGenerateJobStatusHandlingLast);
        this.m_ckbUseNLSDateFormat = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.UseNLSDateFormat", (int)5);
        this.listenForDataChangesTo(this.m_ckbUseNLSDateFormat);
        this.m_ckbGenerateWarningsForMappings = WsUIUtilities.createCheckBox((WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.GenerateWarningsForMappings", (int)5);
        this.listenForDataChangesTo(this.m_ckbGenerateWarningsForMappings);
        this.m_txtCheckpointLibrary = new WATextField();
        this.m_txtCheckpointLibrary.setEditable(false);
        this.m_lblCheckpointLibrary = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtCheckpointLibrary, (String)bundle.getString("SASCodeGenerationOptionsTab.CheckpointLibrary.txt"));
        this.m_btnCheckpointLibraryBrowse = WsUIUtilities.createBrowseButton();
        this.m_btnCheckpointLibraryListener = new cSelectListener();
        this.m_btnCheckpointLibraryBrowse.addActionListener(this.m_btnCheckpointLibraryListener);
        this.m_btnCheckpointLibraryBrowse.setToolTipText(bundle.getString("SASCodeGenerationOptionsTab.BrowseButton.ToolTip.txt"));
        this.m_txtAlternateLibrary = new WATextField();
        this.m_txtAlternateLibrary.setEditable(false);
        this.m_lblAlternateLibrary = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtAlternateLibrary, (String)bundle.getString("SASCodeGenerationOptionsTab.AlternateLibrary.txt"));
        this.m_btnAlternateLibraryBrowse = WsUIUtilities.createBrowseButton();
        this.m_btnAlternateLibraryListener = new cSelectAlternateListener();
        this.m_btnAlternateLibraryBrowse.addActionListener(this.m_btnAlternateLibraryListener);
        this.m_btnAlternateLibraryBrowse.setToolTipText(bundle.getString("SASCodeGenerationOptionsTab.BrowseButton.ToolTip.txt"));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbEnableMacroVariables, (Object)new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbJCL, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbLineLengthsLessThanEighty, (Object)new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbEnableParallelMacros, (Object)new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbGenerateJobStatusHandlingLast, (Object)new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbUseNLSDateFormat, (Object)new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_ckbGenerateWarningsForMappings, (Object)new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_lblCheckpointLibrary, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_txtCheckpointLibrary, (Object)new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_btnCheckpointLibraryBrowse, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_lblAlternateLibrary, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_txtAlternateLibrary, (Object)new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlNewJobOptions.add((Component)this.m_btnAlternateLibraryBrowse, (Object)new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void createNewTransformOptionsPanel() {
        this.m_pnlNewTransformOptions = new WAPanel();
        this.m_pnlNewTransformOptions.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlNewTransformOptions.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("SASCodeGenerationOptionsTab.NewTransform.TitleBorder.txt")));
        this.m_txtHadoopServer = new WATextField();
        this.m_txtHadoopServer.setEditable(false);
        this.m_lblHadoopServer = WsUIUtilities.createLabelForComponent((JComponent)this.m_txtHadoopServer, (String)bundle.getString("SASCodeGenerationOptionsTab.HadoopServer.txt"));
        this.m_btnHadoopServerBrowse = WsUIUtilities.createBrowseButton();
        this.m_btnHadoopServerListener = new cHadoopServerListener();
        this.m_btnHadoopServerBrowse.addActionListener(this.m_btnHadoopServerListener);
        this.m_btnHadoopServerBrowse.setToolTipText(bundle.getString("SASCodeGenerationOptionsTab.BrowseHadoopButton.ToolTip.txt"));
        this.m_pnlNewTransformOptions.add((Component)this.m_lblHadoopServer, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_pnlNewTransformOptions.add((Component)this.m_txtHadoopServer, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlNewTransformOptions.add((Component)this.m_btnHadoopServerBrowse, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    private void createGridEnabledTransformationOptionsPanel() {
        this.m_cmbApplication = new WAComboBox();
        this.m_cmbApplication.setEditable(false);
        this.m_cmbApplication.setSorted(false);
        this.m_lblApplication = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbApplication, (WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.DefaultApplication");
        this.m_cmbWorkload = new WAComboBox();
        this.m_cmbWorkload.setEditable(false);
        this.m_cmbWorkload.setSorted(true);
        this.m_lblWorkload = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbWorkload, (WAdminResource)bundle, (String)"SASCodeGenerationOptionsTab.DefaultWorkload");
        this.m_pnlMaxCurrentProcs = new SASParallelMaximumConcurrentProcessesPanel(bundle.getString("SASCodeGenerationOptionsTab.MaximumProcs.Title.txt"));
        this.listenForDataChangesTo(this.m_pnlMaxCurrentProcs);
        this.m_pnlGridEnabledTransformationOptions = new WAPanel();
        this.m_pnlGridEnabledTransformationOptions.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlGridEnabledTransformationOptions.setBorder((Border)WsUIUtilities.createTitledBorder((String)bundle.getString("SASCodeGenerationOptionsTab.GridSpecifications.TitleBorder.txt")));
        this.m_pnlGridEnabledTransformationOptions.add((Component)this.m_lblApplication, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_pnlGridEnabledTransformationOptions.add((Component)this.m_cmbApplication, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.m_pnlGridEnabledTransformationOptions.add((Component)this.m_lblWorkload, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_pnlGridEnabledTransformationOptions.add((Component)this.m_cmbWorkload, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.m_pnlGridEnabledTransformationOptions.add((Component)((Object)this.m_pnlMaxCurrentProcs), (Object)new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
    }

    public boolean validateData() {
        return this.m_pnlMaxCurrentProcs.validateData();
    }

    protected void setAlternateJobLibrary(SimpleObject library) {
        this.m_alternateLibrary = library;
        if (library != null) {
            this.m_txtAlternateLibrary.setText(library.getName());
        } else {
            this.m_txtAlternateLibrary.setText("");
        }
    }

    protected void setCheckpointStateLibrary(SimpleObject library) {
        this.m_checkpointLibrary = library;
        if (library != null) {
            this.m_txtCheckpointLibrary.setText(library.getName());
        } else {
            this.m_txtCheckpointLibrary.setText("");
        }
    }

    private SimpleObject getStoredCheckpointStateLibrary() {
        return this.getLibrary(KEY_CHECKPOINT_LIBRARY);
    }

    private SimpleObject getStoredAlternateJobLibrary() {
        return this.getLibrary(KEY_ALTERNATE_TEMPORARY_LIBRARY);
    }

    private SimpleObject getHadoopServer() {
        return this.getServer("Workspace.DefaultHadoopServer");
    }

    protected void setHadoopServer(SimpleObject server) {
        this.m_hadoopServer = server;
        if (server != null) {
            this.m_txtHadoopServer.setText(server.getName());
        } else {
            this.m_txtHadoopServer.setText("");
        }
    }

    protected SimpleObject getLibrary(String key) {
        SimpleBrowseObjectImpl library = null;
        String libId = this.m_appDefaultsFile.getPropertyString(key);
        if (libId != null && libId.length() > 0) {
            try {
                if (!WsMetadataUtil.doesObjectExist((String)libId, (String)"SASLibrary")) {
                    return null;
                }
                String sKey = libId + "/" + "SASLibrary";
                BrowseMetadataInterface browseObject = Workspace.getWorkspace().getUserContext().getAuthServer().browseFetch(sKey, null);
                if (browseObject != null) {
                    library = new SimpleBrowseObjectImpl(browseObject);
                }
            }
            catch (ServiceException e) {
                Workspace.handleServiceException((ServiceException)e);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        return library;
    }

    protected SimpleObject getServer(String key) {
        SimpleBrowseObjectImpl server = null;
        String svrId = this.m_appDefaultsFile.getPropertyString(key);
        if (svrId != null && svrId.length() > 0) {
            try {
                if (!WsMetadataUtil.doesObjectExist((String)svrId, (String)"ServerComponent")) {
                    return null;
                }
                String sKey = svrId + "/" + "ServerComponent";
                BrowseMetadataInterface browseObject = Workspace.getWorkspace().getUserContext().getAuthServer().browseFetch(sKey, null);
                if (browseObject != null) {
                    server = new SimpleBrowseObjectImpl(browseObject);
                }
            }
            catch (ServiceException e) {
                Workspace.handleServiceException((ServiceException)e);
            }
            catch (RemoteException e) {
                Workspace.handleRemoteException((RemoteException)e);
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        return server;
    }

    public void moveDataToView() throws MdException, RemoteException {
        String workload;
        this.m_ckbEnableMacroVariables.setSelected(this.m_appDefaultsFile.getPropertyBoolean("Workspace.EnableMacroVariables", false));
        this.m_ckbJCL.setSelected(this.m_appDefaultsFile.getPropertyBoolean("Workspace.GenerateJCL", false));
        this.m_ckbLineLengthsLessThanEighty.setSelected(this.m_appDefaultsFile.getPropertyBoolean(KEY_GENERATE_LINE_LENGTHS_LESS_THAN_EIGHTY, false));
        this.m_ckbEnableParallelMacros.setSelected(this.m_appDefaultsFile.getPropertyBoolean("Workspace.EnableParallelMacros", false));
        this.m_ckbGenerateJobStatusHandlingLast.setSelected(this.m_appDefaultsFile.getPropertyBoolean("Workspace.GenerateJobStatusHandlingLast", true));
        this.m_ckbUseNLSDateFormat.setSelected(this.m_appDefaultsFile.getPropertyBoolean("Workspace.UseNLSDateFormat", true));
        this.m_ckbGenerateWarningsForMappings.setSelected(this.m_appDefaultsFile.getPropertyBoolean(GENERATE_WARNINGS_FOR_MAPPINGS, true));
        String application = this.m_appDefaultsFile.getPropertyString("Workspace.DefaultApplication", "");
        if (application != null) {
            if (application.trim().isEmpty() || !this.m_lstApplication.contains(application)) {
                application = NONE;
            }
            this.m_cmbApplication.setSelectedItem((Object)application);
        }
        if ("".equals(workload = this.m_appDefaultsFile.getPropertyString("Workspace.DefaultWorkload", "")) || !this.m_lstWorkload.contains(workload)) {
            workload = NONE;
        }
        this.m_cmbWorkload.setSelectedItem((Object)workload);
        this.m_pnlMaxCurrentProcs.setMaximumConcurrentSetting(this.m_appDefaultsFile.getPropertyString("Workspace.DefaultMaxConcurrentProcesses", this.m_pnlMaxCurrentProcs.getDefaultSetting()));
        this.setAlternateJobLibrary(this.getStoredAlternateJobLibrary());
        this.setCheckpointStateLibrary(this.getStoredCheckpointStateLibrary());
        this.setHadoopServer(this.getHadoopServer());
    }

    public void moveDataToStore() {
        String workload;
        this.m_appDefaultsFile.setPropertyBoolean("Workspace.EnableMacroVariables", this.m_ckbEnableMacroVariables.isSelected());
        this.m_appDefaultsFile.setPropertyBoolean("Workspace.GenerateJCL", this.m_ckbJCL.isSelected());
        this.m_appDefaultsFile.setPropertyBoolean(KEY_GENERATE_LINE_LENGTHS_LESS_THAN_EIGHTY, this.m_ckbLineLengthsLessThanEighty.isSelected());
        this.m_appDefaultsFile.setPropertyBoolean("Workspace.EnableParallelMacros", this.m_ckbEnableParallelMacros.isSelected());
        this.m_appDefaultsFile.setPropertyBoolean("Workspace.GenerateJobStatusHandlingLast", this.m_ckbGenerateJobStatusHandlingLast.isSelected());
        this.m_appDefaultsFile.setPropertyBoolean("Workspace.UseNLSDateFormat", this.m_ckbUseNLSDateFormat.isSelected());
        this.m_appDefaultsFile.setPropertyBoolean(GENERATE_WARNINGS_FOR_MAPPINGS, this.m_ckbGenerateWarningsForMappings.isSelected());
        String application = this.m_cmbApplication.getSelectedItem().toString();
        if (application != null) {
            if (NONE.equals(application)) {
                application = "";
            }
            this.m_appDefaultsFile.setPropertyString("Workspace.DefaultApplication", application);
        }
        if (NONE.equals(workload = this.m_cmbWorkload.getSelectedItem().toString())) {
            workload = "";
        }
        this.m_appDefaultsFile.setPropertyString("Workspace.DefaultWorkload", workload);
        this.m_appDefaultsFile.setPropertyString("Workspace.DefaultMaxConcurrentProcesses", this.m_pnlMaxCurrentProcs.getMaximumConcurrentSetting());
        this.m_appDefaultsFile.setPropertyString(KEY_ALTERNATE_TEMPORARY_LIBRARY, this.m_alternateLibrary != null ? this.m_alternateLibrary.getID() : "");
        this.m_appDefaultsFile.setPropertyString(KEY_CHECKPOINT_LIBRARY, this.m_checkpointLibrary != null ? this.m_checkpointLibrary.getID() : "");
        this.m_appDefaultsFile.setPropertyString("Workspace.DefaultHadoopServer", this.m_hadoopServer != null ? this.m_hadoopServer.getID() : "");
    }

    private class cHadoopServerFilter
    implements ISelectorFeedbackFilter {
        ISimpleObjectFilter m_delegateFilter = ObjectSelectorFilterFactory.createObjectFilter((String[])new String[]{"Server.Hadoop"});

        private cHadoopServerFilter() {
        }

        public boolean accept(SimpleObject simpleObject) {
            return this.m_delegateFilter.accept(simpleObject);
        }

        public String getReasonForRejection(SimpleObject simpleObj) {
            return "invalid server type";
        }
    }

    protected class cSelectAlternateListener
    implements ActionListener {
        protected cSelectAlternateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel pnlMain = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 2);
            pnlMain.setVisibleTypes(new String[]{"Library"});
            pnlMain.setInventoryTypes(new String[]{"Library"});
            pnlMain.setSelectedObject(SASCodeGenerationOptionsPropertyTab.this.m_alternateLibrary);
            pnlMain.setSelectionOptional(true);
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SASCodeGenerationOptionsTab.LibraryDialogTitle.txt"), true, (WAPanel)pnlMain);
            dlg.setResizable(true);
            dlg.setHelpProduct("wdb");
            dlg.setHelpTopic("");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject sObject = pnlMain.getSelectedObject();
                SASCodeGenerationOptionsPropertyTab.this.setAlternateJobLibrary(sObject);
            }
        }
    }

    protected class cHadoopServerListener
    implements ActionListener {
        protected cHadoopServerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel pnlMain = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), -1);
            pnlMain.setVisibleTypes(new String[]{"Server.Hadoop"});
            pnlMain.setSelectableObjectsFilter((ISimpleObjectFilter)new cHadoopServerFilter());
            pnlMain.setInventoryTypes(new String[]{"Server.Hadoop"});
            pnlMain.setSelectedObject(SASCodeGenerationOptionsPropertyTab.this.m_hadoopServer);
            pnlMain.setSelectionOptional(true);
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SASCodeGenerationOptionsTab.HadoopDialogTitle.txt"), true, (WAPanel)pnlMain);
            dlg.setResizable(true);
            dlg.setHelpProduct("wdb");
            dlg.setHelpTopic("");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject sObject = pnlMain.getSelectedObject();
                SASCodeGenerationOptionsPropertyTab.this.setHadoopServer(sObject);
            }
        }
    }

    protected class cSelectListener
    implements ActionListener {
        protected cSelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel pnlMain = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 2);
            pnlMain.setVisibleTypes(new String[]{"Library"});
            pnlMain.setInventoryTypes(new String[]{"Library"});
            pnlMain.setSelectedObject(SASCodeGenerationOptionsPropertyTab.this.m_checkpointLibrary);
            pnlMain.setSelectionOptional(true);
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SASCodeGenerationOptionsTab.LibraryDialogTitle.txt"), true, (WAPanel)pnlMain);
            dlg.setResizable(true);
            dlg.setHelpProduct("wdb");
            dlg.setHelpTopic("");
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                SimpleObject sObject = pnlMain.getSelectedObject();
                SASCodeGenerationOptionsPropertyTab.this.setCheckpointStateLibrary(sObject);
            }
        }
    }
}

