/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.information.metadata.OMRColumn;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.swing.visuals.dualselector.TreeListSelector;
import com.sas.wadmin.model.TransformationTargetColumnsTableModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsColumnMetadataUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QuickPropagateSelectorPanel
extends WAPanel {
    static WAdminResource m_bundle = WAdminResource.getBundle(QuickPropagateSelectorPanel.class);
    private MdObjectStore m_store = null;
    private CMetadata m_repos = null;
    private String m_reposId = null;
    protected boolean m_bMultipleTargets;
    protected boolean m_bMultipleSources;
    protected List m_lTargetTables;
    protected JLabel m_lblTargetTables;
    protected WAComboBox m_cmbTargetTables;
    protected List m_lSourceTables;
    protected List m_lTargetColumns;
    protected TreeExpansionListener m_lsnrTreeExpansion;
    protected TreeSelectionListener l_lsnrTreeSelection;
    protected Vector m_columns = new Vector(0);
    protected TreeListSelector m_columnsSelector;
    protected DefaultTreeModel m_oAvailableTreeModel;
    protected DefaultListModel m_oSelectedListModel;
    private final Icon m_PhysicalTableIcon = WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true);
    private final Icon m_EnvironmentIcon = m_bundle.getImageIcon("Common.Environment.image");
    private final Icon m_FolderIcon = WorkspaceTree.getClosedFolderIcon();
    private final Icon m_FolderOpenIcon = WorkspaceTree.getOpenedFolderIcon();

    public QuickPropagateSelectorPanel() {
    }

    public QuickPropagateSelectorPanel(boolean bMultipleSources, boolean bMultipleTargets, List lSourceTables, List lTargetColumns, List lTargetTables) {
        this.m_bMultipleTargets = bMultipleTargets;
        this.m_bMultipleSources = bMultipleSources;
        this.m_lSourceTables = lSourceTables;
        this.m_lTargetTables = lTargetTables;
        this.m_lTargetColumns = lTargetColumns;
        this._initialize();
    }

    public void saveSettingsAndCleanUp() {
        this.m_columnsSelector.removeAll();
        this.m_store = null;
        this.m_repos = null;
        this.m_reposId = null;
        this.m_columnsSelector = null;
        this.m_oAvailableTreeModel = null;
        this.m_oSelectedListModel = null;
    }

    public void setRepository(CMetadata repos) {
        this.m_repos = repos;
    }

    public void setStore(MdObjectStore store) {
        this.m_store = store;
    }

    public void populateStore() {
    }

    public void moveDataToStore() throws RemoteException {
        for (int i = 0; i < this.m_oSelectedListModel.getSize(); ++i) {
            TreePath path = (TreePath)this.m_oSelectedListModel.elementAt(i);
            Column existingColumn = (Column)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            Column newColumn = (Column)Workspace.getMdFactory().createComplexMetadataObject(this.m_store, null, existingColumn.getName(), "Column", this.m_reposId, null);
            newColumn.setPublicType("Column");
            newColumn.setUsageVersion(OMRColumn.CURRENT_VERSION.encode());
            newColumn.setColumnName(existingColumn.getColumnName());
            newColumn.setColumnLength(existingColumn.getColumnLength());
            newColumn.setColumnType(existingColumn.getColumnType());
            newColumn.setSASColumnName(existingColumn.getSASColumnName());
            newColumn.setSASColumnLength(existingColumn.getSASColumnLength());
            newColumn.setSASColumnType(existingColumn.getSASColumnType());
            newColumn.setIsDiscrete(existingColumn.getIsDiscrete());
            newColumn.setIsNullable(existingColumn.getIsNullable());
            newColumn.setSASFormat(existingColumn.getSASFormat());
            newColumn.setSASInformat(existingColumn.getSASInformat());
            newColumn.setSortOrder(existingColumn.getSortOrder());
            newColumn.setSummaryRole(existingColumn.getSummaryRole());
            newColumn.setDesc(existingColumn.getDesc());
            this.m_columns.add(newColumn);
        }
    }

    public void moveDataToView() throws RemoteException {
        this.m_reposId = this.m_repos.getFQID().substring(9, 17);
        this.m_oAvailableTreeModel.setRoot(new DefaultMutableTreeNode(this.m_repos));
        DefaultMutableTreeNode oRootTreeNode = (DefaultMutableTreeNode)this.m_oAvailableTreeModel.getRoot();
        oRootTreeNode.setAllowsChildren(true);
        TreeSet sortedList = new TreeSet(new cDataTableComparator());
        sortedList.addAll(this.m_lSourceTables);
        for (DataTable oDataTable : sortedList) {
            DefaultMutableTreeNode oTableTreeNode = new DefaultMutableTreeNode(oDataTable);
            oTableTreeNode.setAllowsChildren(true);
            this.m_oAvailableTreeModel.insertNodeInto(oTableTreeNode, oRootTreeNode, oRootTreeNode.getChildCount());
        }
        this.m_oAvailableTreeModel.reload();
        JTree sourcetree = (JTree)this.m_columnsSelector.getSourceComponent();
        this.expandAvailableNodes(sourcetree, this.m_oAvailableTreeModel);
        this.selectImportNodes(sourcetree, this.m_oAvailableTreeModel);
    }

    protected void expandAvailableNodes(JTree sourceTree, DefaultTreeModel treeModel) {
        int numChildren;
        Object availableRootNode = treeModel.getRoot();
        for (int iChild = numChildren = treeModel.getChildCount(availableRootNode); iChild >= 0; --iChild) {
            sourceTree.expandRow(iChild);
        }
    }

    private void selectImportNodes(JTree sourceTree, DefaultTreeModel treeModel) throws RemoteException {
        Object availableRootNode = treeModel.getRoot();
        int numChildren = treeModel.getChildCount(availableRootNode);
        ArrayList<TreePath> SelectedColumns = new ArrayList<TreePath>();
        int nextRow = 0;
        TreePath Path2 = sourceTree.getPathForRow(0);
        for (int i = 0; i <= numChildren; ++i) {
            DefaultMutableTreeNode TreeNode2 = (DefaultMutableTreeNode)Path2.getLastPathComponent();
            CMetadata node = (CMetadata)TreeNode2.getUserObject();
            if (node == null) continue;
            String nodeType = node.getCMetadataType();
            if (nodeType.equals("DataTable") || nodeType.equals("WorkTable") || nodeType.equals("PhysicalTable") || nodeType.equals("QueryTable")) {
                int numNodes = treeModel.getChildCount(TreeNode2);
                for (int iNode = 0; iNode < numNodes; ++iNode) {
                    nextRow = sourceTree.getRowForPath(Path2);
                    Path2 = sourceTree.getPathForRow(nextRow + 1);
                    DefaultMutableTreeNode ColumnTreeNode = (DefaultMutableTreeNode)Path2.getLastPathComponent();
                    String columnName = ((Column)ColumnTreeNode.getUserObject()).getSASColumnName();
                    for (int iTargetColumn = 0; iTargetColumn < this.m_lTargetColumns.size(); ++iTargetColumn) {
                        String TargetColumnName = (String)this.m_lTargetColumns.get(iTargetColumn);
                        if (!columnName.equals(TargetColumnName)) continue;
                        SelectedColumns.add(Path2);
                    }
                }
            }
            nextRow = sourceTree.getRowForPath(Path2);
            Path2 = sourceTree.getPathForRow(nextRow + 1);
        }
        TreePath[] TreePathArray = SelectedColumns.toArray(new TreePath[0]);
        sourceTree.setSelectionPaths(TreePathArray);
        this.m_columnsSelector.transferSourceItems();
    }

    public Vector getColumns() {
        return this.m_columns;
    }

    public List getSelectedTables() {
        int iItem = this.m_cmbTargetTables.getSelectedIndex();
        if (iItem == 0) {
            return this.m_lTargetTables;
        }
        ArrayList lSelectedTable = new ArrayList(1);
        lSelectedTable.add(this.m_lTargetTables.get(iItem - 1));
        return lSelectedTable;
    }

    public boolean validateData() {
        return true;
    }

    protected void _initialize() {
        if (this.m_bMultipleTargets) {
            this.m_cmbTargetTables = new WAComboBox();
            this.m_cmbTargetTables.addItem((Object)m_bundle.getString("QuickPropagateSelectorPanel.All.txt"));
            int nTargetTables = this.m_lTargetTables.size();
            for (int iTargetTable = 0; iTargetTable < nTargetTables; ++iTargetTable) {
                DataTable oTargetTable = (DataTable)this.m_lTargetTables.get(iTargetTable);
                String sTargetTable = TransformationTargetColumnsTableModel.getDataTableDisplayName(oTargetTable);
                this.m_cmbTargetTables.addItem((Object)sTargetTable);
            }
            this.m_lblTargetTables = new JLabel(m_bundle.getString("QuickPropagateSelectorPanel.TargetTable.txt"));
            this.m_lblTargetTables.setDisplayedMnemonic(m_bundle.getString("QuickPropagateSelectorPanel.TargetTable.mnem").charAt(0));
            this.m_lblTargetTables.setLabelFor((Component)this.m_cmbTargetTables);
        }
        this.m_columnsSelector = this.createTreeSelector();
        this.m_oAvailableTreeModel = this.createTreeModel();
        this.m_oAvailableTreeModel.setAsksAllowsChildren(true);
        this.m_oSelectedListModel = new DefaultListModel();
        this.m_columnsSelector.setModel((TreeModel)this.m_oAvailableTreeModel);
        this.m_columnsSelector.setSourceLabel(m_bundle.getString("QuickPropagateSelectorPanel.AvailableColumns.txt"));
        ((JLabel)this.m_columnsSelector.getSourceLabelComponent()).setDisplayedMnemonic(m_bundle.getString("QuickPropagateSelectorPanel.AvailableColumns.mnem").charAt(0));
        this.m_columnsSelector.setSourceCellRenderer((TreeCellRenderer)this.createTreeCellRenderer());
        this.m_columnsSelector.setTargetModel((ListModel)this.m_oSelectedListModel);
        this.m_columnsSelector.setTargetLabel(m_bundle.getString("QuickPropagateSelectorPanel.SelectedColumns.txt"));
        ((JLabel)this.m_columnsSelector.getTargetLabelComponent()).setDisplayedMnemonic(m_bundle.getString("QuickPropagateSelectorPanel.SelectedColumns.mnem").charAt(0));
        this.m_columnsSelector.setTargetCellRenderer(this.createTargetListCellRenderer());
        this.m_columnsSelector.setTransferAllControlsVisible(false);
        this.m_columnsSelector.setDragAndDropEnabled(false);
        this.m_columnsSelector.setTargetControlsVisible(true);
        this.m_columnsSelector.setCopyModeEnabled(true);
        this.m_columnsSelector.setCopyModeDuplicatesAllowed(false);
        this.m_columnsSelector.setParentNodesMoveable(false);
        this.m_lsnrTreeExpansion = this.createExpansionListener();
        this.l_lsnrTreeSelection = this.createSelectionListener();
        JTree srcTree = (JTree)this.m_columnsSelector.getSourceComponent();
        this.addTreeListeners(srcTree);
        this.setLayout(new GridBagLayout());
        if (this.m_bMultipleTargets) {
            this.add(this.m_lblTargetTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_cmbTargetTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.add((Component)this.m_columnsSelector, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.m_columnsSelector, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    protected void addTreeListeners(JTree tree) {
        tree.addTreeExpansionListener(this.m_lsnrTreeExpansion);
        tree.addTreeSelectionListener(this.l_lsnrTreeSelection);
    }

    protected DefaultTreeModel createTreeModel() {
        return new DefaultTreeModel(new DefaultMutableTreeNode());
    }

    protected DefaultTreeCellRenderer createTreeCellRenderer() {
        return new SourceTreeCellRenderer();
    }

    protected TreeExpansionListener createExpansionListener() {
        return new cExpansionListener();
    }

    protected TreeSelectionListener createSelectionListener() {
        return new cSelectionListener();
    }

    protected TreeListSelector createTreeSelector() {
        return new cTreeListSelector();
    }

    protected ListCellRenderer createTargetListCellRenderer() {
        return new TargetListCellRenderer();
    }

    private class cDataTableComparator
    implements Comparator {
        private cDataTableComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                DataTable one = (DataTable)o1;
                DataTable two = (DataTable)o2;
                String oneString = one.getName() + one.getId();
                String twoString = two.getName() + two.getId();
                return oneString.compareToIgnoreCase(twoString);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return Integer.MIN_VALUE;
            }
        }
    }

    class cTreeListSelector
    extends TreeListSelector {
        JDialog m_dialog = null;

        cTreeListSelector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter) {
            Vector<String> dupNames = new Vector<String>();
            int maxCnt = -1;
            if (fromAdapter == this.sourceAdapter) {
                maxCnt = super.getTargetMaximumCount();
            }
            int selectedCount = fromAdapter.getSelectedCount();
            int index = fromAdapter.getLastSelectedIndex();
            List lSelectedItems = selectedCount > 0 ? fromAdapter.getSelectedItems() : null;
            if (lSelectedItems != null) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        int count = lSelectedItems.size() + toAdapter.getCount();
                        if (maxCnt == -1 || count <= maxCnt) {
                            try {
                                int currentCount;
                                if (!this.copyModeEnabled || this.copyModeEnabled && fromAdapter == this.targetAdapter) {
                                    fromAdapter.removeItems(lSelectedItems);
                                }
                                if (!this.copyModeDuplicatesAllowed) {
                                    for (int j = 0; j < lSelectedItems.size(); ++j) {
                                        DefaultMutableTreeNode selected_treeNode = (DefaultMutableTreeNode)((TreePath)lSelectedItems.get(j)).getLastPathComponent();
                                        if (selected_treeNode.getUserObject() instanceof Column) {
                                            Column selected_column = (Column)selected_treeNode.getUserObject();
                                            String selected_SASColumnName = selected_column.getSASColumnName();
                                            if (!this._DupFoundInSelectedItems(lSelectedItems, selected_SASColumnName, j)) continue;
                                            lSelectedItems.remove(j--);
                                            continue;
                                        }
                                        lSelectedItems.remove(j--);
                                    }
                                    List toItems = toAdapter.getAllItems();
                                    int toItemsSize = toItems.size();
                                    int size = lSelectedItems.size();
                                    block9: for (int j = size - 1; j >= 0; --j) {
                                        DefaultMutableTreeNode selected_treeNode = (DefaultMutableTreeNode)((TreePath)lSelectedItems.get(j)).getLastPathComponent();
                                        Column selected_column = (Column)selected_treeNode.getUserObject();
                                        String selected_SASColumnName = selected_column.getSASColumnName();
                                        for (int i = 0; i <= toItemsSize - 1; ++i) {
                                            Column toItems_column;
                                            String toItems_SASColumnName;
                                            DefaultMutableTreeNode toItems_treeNode;
                                            if (lSelectedItems.get(j).equals(toItems.get(i))) {
                                                lSelectedItems.remove(j);
                                                continue block9;
                                            }
                                            if (!(toAdapter.getComponent() instanceof JList) || !((toItems_treeNode = (DefaultMutableTreeNode)((TreePath)toItems.get(i)).getLastPathComponent()).getUserObject() instanceof Column) || !selected_SASColumnName.equalsIgnoreCase(toItems_SASColumnName = (toItems_column = (Column)toItems_treeNode.getUserObject()).getSASColumnName())) continue;
                                            dupNames.addElement(selected_SASColumnName);
                                            lSelectedItems.remove(j);
                                            continue block9;
                                        }
                                    }
                                }
                                if (dupNames.size() > 0) {
                                    if (fromAdapter instanceof JTreeDualSelectorAdapter) {
                                        String sTitle = m_bundle.getString("QuickPropagateSelectorPanel.DuplicateColumns.Removed.Header.txt");
                                        MessageUtil.displayListMessage((String)sTitle, dupNames);
                                    }
                                    dupNames.clear();
                                }
                                if (lSelectedItems.size() > 0 && (this.copyModeEnabled && fromAdapter == this.sourceAdapter || !this.copyModeEnabled)) {
                                    toAdapter.addItems(lSelectedItems);
                                }
                                if (!this.copyModeEnabled) {
                                    index = index - selectedCount + 1;
                                }
                                if (index >= (currentCount = fromAdapter.getCount())) {
                                    index = currentCount - 1;
                                }
                                fromAdapter.setSelectedIndex(index);
                            }
                            catch (RemoteException ex) {
                                Workspace.handleRemoteException((RemoteException)ex);
                            }
                        }
                    }
                }
            }
        }

        private boolean _DupFoundInSelectedItems(List lSelectedItems, String newName, int row) throws RemoteException {
            if (newName.trim().length() == 0) {
                return false;
            }
            for (int i = row; i < lSelectedItems.size(); ++i) {
                Column curr_column;
                String curr_SASColumnName;
                DefaultMutableTreeNode curr_treeNode = (DefaultMutableTreeNode)((TreePath)lSelectedItems.get(i)).getLastPathComponent();
                if (!(curr_treeNode.getUserObject() instanceof Column) || (curr_SASColumnName = (curr_column = (Column)curr_treeNode.getUserObject()).getSASColumnName()).compareToIgnoreCase(newName) != 0 || i == row) continue;
                return true;
            }
            return false;
        }
    }

    public class cSelectionListener
    implements TreeSelectionListener {
        boolean m_ResetSelection = false;

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            DefaultMutableTreeNode nodePath = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
            CMetadata node = (CMetadata)nodePath.getUserObject();
            if (node != null) {
                try {
                    if (node.getCMetadataType().compareTo("Environment") == 0) {
                        if (!this.m_ResetSelection) {
                            JTree tree = (JTree)tse.getSource();
                            TreePath npath = tse.getPath();
                            TreePath[] spaths = tree.getSelectionPaths();
                            int scount = spaths.length;
                            int tcount = 0;
                            TreePath[] tpaths = new TreePath[scount];
                            for (int i = 0; i < scount; ++i) {
                                boolean found = false;
                                if (npath.equals(spaths[i])) {
                                    found = true;
                                }
                                if (found) continue;
                                tpaths[tcount++] = spaths[i];
                            }
                            this.m_ResetSelection = true;
                            tree.setSelectionPaths(tpaths);
                            this.m_ResetSelection = false;
                        }
                    } else if (node.getCMetadataType().equals("DataTable")) {
                        if (nodePath.getChildCount() <= 0) {
                            String str1 = m_bundle.getString("QuickPropagateSelectorPanel.BuildColumnInfoProgressIndicator.Message.txt");
                            String str2 = m_bundle.getString("QuickPropagateSelectorPanel.BuildColumnInfoProgressIndicator.Title.txt");
                            String str3 = m_bundle.getString("QuickPropagateSelectorPanel.BuildColumnInfoProgressIndicator.Description.txt");
                            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
                            request.setDelayBeforeProgressCancelDialog(200);
                            request.execute((Runnable)new cRunnable(node, nodePath));
                        } else if (tse.getPaths().length > 1) {
                            this._removeTableNode(tse);
                        }
                    } else if (!this.m_ResetSelection) {
                        this._removeTableNode(tse);
                    }
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
        }

        private void _removeTableNode(TreeSelectionEvent tse) throws RemoteException {
            TreePath[] tpaths = tse.getPaths();
            int tcount = tpaths.length;
            TreePath[] npaths = new TreePath[tcount];
            int ncount = 0;
            boolean NotJustTables = false;
            for (int i = 0; i < tcount; ++i) {
                CMetadata tnode = (CMetadata)((DefaultMutableTreeNode)tpaths[i].getLastPathComponent()).getUserObject();
                if (tnode.getCMetadataType().compareTo("DataTable") == 0 || tnode.getCMetadataType().compareTo("Environment") == 0) {
                    npaths[ncount++] = tpaths[i];
                    continue;
                }
                NotJustTables = true;
            }
            if (ncount > 0 && NotJustTables) {
                JTree tree = (JTree)tse.getSource();
                TreePath[] spaths = tree.getSelectionPaths();
                int scount = spaths.length;
                tcount = 0;
                tpaths = new TreePath[scount];
                for (int i = 0; i < scount; ++i) {
                    boolean found = false;
                    for (int j = 0; j < ncount; ++j) {
                        if (!npaths[j].equals(spaths[i])) continue;
                        found = true;
                    }
                    if (found) continue;
                    tpaths[tcount++] = spaths[i];
                }
                this.m_ResetSelection = true;
                tree.setSelectionPaths(tpaths);
                this.m_ResetSelection = false;
            }
        }
    }

    public class cExpansionListener
    implements TreeExpansionListener {
        @Override
        public void treeExpanded(TreeExpansionEvent tee) {
            DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)tee.getPath().getLastPathComponent();
            CMetadata PhyTableNode = (CMetadata)treenode.getUserObject();
            if (PhyTableNode != null && PhyTableNode instanceof DataTable && treenode.getChildCount() <= 0) {
                String str1 = m_bundle.getString("QuickPropagateSelectorPanel.BuildColumnInfoProgressIndicator.Message.txt");
                String str2 = m_bundle.getString("QuickPropagateSelectorPanel.BuildColumnInfoProgressIndicator.Title.txt");
                String str3 = m_bundle.getString("QuickPropagateSelectorPanel.BuildColumnInfoProgressIndicator.Description.txt");
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str1, str2, str3);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new cRunnable(PhyTableNode, treenode));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent tee) {
        }
    }

    public class TargetListCellRenderer
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = new JLabel();
            try {
                if (value instanceof TreePath) {
                    TreePath path = (TreePath)value;
                    Column node = (Column)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (QuickPropagateSelectorPanel.this.m_bMultipleSources) {
                        label.setText(node.getTable() + "." + node.getName());
                    } else {
                        label.setText(node.getName());
                    }
                    label.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((Column)node));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            label.setOpaque(true);
            if (isSelected) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else {
                label.setBackground(SystemColor.window);
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }

    public class SourceTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean expanded, boolean leaf, int row, boolean bHasFocus) {
            JLabel label;
            block9: {
                label = new JLabel();
                if (value instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)value;
                    CMetadata node = (CMetadata)treenode.getUserObject();
                    if (node != null) {
                        try {
                            String nodeType = node.getCMetadataType();
                            if (nodeType.equals("Column")) {
                                label.setText(((Column)node).getSASColumnName());
                                label.setIcon(WsColumnMetadataUtil.getColumnTypeIcon((Column)((Column)node)));
                                break block9;
                            }
                            if (nodeType.equals("QueryTable") || nodeType.equals("DataTable") || nodeType.equals("WorkTable") || nodeType.equals("PhysicalTable")) {
                                label.setText(node.getName());
                                label.setIcon(QuickPropagateSelectorPanel.this.m_PhysicalTableIcon);
                                break block9;
                            }
                            label.setText(m_bundle.getString("QuickPropagateSelectorPanel.Tables.txt"));
                            label.setIcon(QuickPropagateSelectorPanel.this.m_EnvironmentIcon);
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException((RemoteException)ex);
                        }
                    } else {
                        label.setText(treenode.toString());
                        label.setIcon(QuickPropagateSelectorPanel.this.m_FolderIcon);
                    }
                }
            }
            label.setOpaque(true);
            this.setOpenIcon(QuickPropagateSelectorPanel.this.m_FolderOpenIcon);
            if (bSelected) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else {
                label.setBackground(SystemColor.window);
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }

    protected class cRunnable
    implements Runnable {
        CMetadata m_DataTable;
        DefaultMutableTreeNode m_treeNode;

        cRunnable(CMetadata PhyTableNode, DefaultMutableTreeNode treenode) {
            this.m_DataTable = PhyTableNode;
            this.m_treeNode = treenode;
        }

        @Override
        public void run() {
            AssociationList vTableColumns = new Vector();
            Vector<String> vComplex = new Vector<String>();
            vComplex.add("Columns");
            vComplex.add("Indexes");
            try {
                QuickPropagateSelectorPanel.this.m_columnsSelector.setCursor(Cursor.getPredefinedCursor(3));
                vTableColumns = ((DataTable)this.m_DataTable).getColumns();
                if (vTableColumns.size() > 0) {
                    for (int k = 0; k < vTableColumns.size(); ++k) {
                        DefaultMutableTreeNode oColumnTreeNode = new DefaultMutableTreeNode(vTableColumns.get(k));
                        QuickPropagateSelectorPanel.this.m_oAvailableTreeModel.insertNodeInto(oColumnTreeNode, this.m_treeNode, this.m_treeNode.getChildCount());
                        oColumnTreeNode.setAllowsChildren(false);
                    }
                }
                QuickPropagateSelectorPanel.this.m_oAvailableTreeModel.reload(this.m_treeNode);
                QuickPropagateSelectorPanel.this.m_columnsSelector.setCursor(Cursor.getDefaultCursor());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

