/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TransformationStep;
import com.sas.wadmin.visuals.PhysicalStoragePane;
import com.sas.wadmin.visuals.SourceCodePanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ProcessSourcePanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ProcessSourcePanel.class);
    protected SourceCodePanel m_pnlSource;
    protected WAPanel m_pnlCodeGen;
    protected JRadioButton m_rbAutoGen;
    protected JRadioButton m_rbUserWritten;
    protected ButtonGroup m_grpCodeGen;
    protected TitledBorder m_titledBorder;
    protected JLabel m_lblHost;
    protected WAComboBox m_cmbHost;
    protected JButton m_btnDefine;
    protected JCheckBox m_cbInactivate;
    protected JButton m_btnDataLoc;
    protected AbstractTransformation m_mdUpperLevel;
    protected AbstractTransformation m_mdLowerLevel;
    protected MdObjectStore m_mdStore;
    protected Text m_sourceCode;
    protected HashMap m_hmServerContexts;
    protected boolean m_bgottenData = false;
    protected boolean m_bEditable = true;
    protected boolean m_bDataLocation = false;
    protected boolean m_bAllowAutoGen;
    protected boolean m_bInactivate = true;
    protected boolean m_bHideExecutionHost = false;
    protected boolean m_bHideDataLocation = false;
    private WAComboBox m_cmbTargetTables;
    private JLabel m_lblTargetTables;
    private boolean m_bAllowMultipleDataLocSelection = false;

    public ProcessSourcePanel(AbstractTransformation inMetadata, boolean bAllowAutoGen) {
        this(inMetadata, bAllowAutoGen, false, false, false, false);
    }

    public ProcessSourcePanel(AbstractTransformation inMetadata, boolean bAllowAutoGen, boolean bHideDataLocation) {
        this(inMetadata, bAllowAutoGen, bHideDataLocation, false, false, false);
    }

    public ProcessSourcePanel(AbstractTransformation inMetadata, boolean bAllowAutoGen, boolean bHideDataLocation, boolean bHideInactivate) {
        this(inMetadata, bAllowAutoGen, bHideDataLocation, bHideInactivate, false, false);
    }

    public ProcessSourcePanel(AbstractTransformation inMetadata, boolean bAllowAutoGen, boolean bHideDataLocation, boolean bHideInactivate, boolean bHideExecutionHost) {
        this(inMetadata, bAllowAutoGen, bHideDataLocation, bHideInactivate, bHideExecutionHost, false);
    }

    public ProcessSourcePanel(AbstractTransformation inMetadata, boolean bAllowAutoGen, boolean bHideDataLocation, boolean bHideInactive, boolean bHideExecutionHost, boolean bAllowMultipleDataLocationSelection) {
        this.m_mdUpperLevel = inMetadata;
        this.m_bAllowAutoGen = bAllowAutoGen;
        this.m_bAllowMultipleDataLocSelection = !bHideDataLocation && bAllowMultipleDataLocationSelection;
        this.initialize();
        this.layoutWidgets();
        this.m_bHideDataLocation = bHideDataLocation;
        if (bHideDataLocation) {
            this.m_btnDataLoc.setEnabled(false);
            this.m_btnDataLoc.setVisible(false);
            this.m_bDataLocation = false;
            this.m_lblTargetTables.setVisible(false);
            this.m_lblTargetTables.setEnabled(false);
            this.m_cmbTargetTables.setEnabled(false);
            this.m_cmbTargetTables.setVisible(false);
        }
        if (bHideExecutionHost) {
            this.m_lblHost.setVisible(false);
            this.m_cmbHost.setVisible(false);
            this.m_bHideExecutionHost = true;
        }
        if (bHideInactive) {
            this.m_cbInactivate.setVisible(false);
            this.m_bInactivate = false;
        }
    }

    protected void initialize() {
        this.m_rbAutoGen = new JRadioButton();
        this.m_rbUserWritten = new JRadioButton();
        this.m_grpCodeGen = new ButtonGroup();
        this.m_titledBorder = new TitledBorder(bundle.getString("TableProcessSourceTab.SourcePanelTitle.txt"));
        this.m_pnlCodeGen = new WAPanel();
        this.m_pnlSource = new SourceCodePanel();
        this.m_lblHost = new JLabel();
        this.m_cmbHost = new WAComboBox();
        this.m_btnDefine = new JButton();
        this.m_cbInactivate = new JCheckBox();
        this.m_btnDataLoc = new JButton();
        this.m_cmbTargetTables = new WAComboBox(true);
        this.m_lblTargetTables = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbTargetTables, (WAdminResource)bundle, (String)"TableProcessSourceTab.TargetTables");
        this.m_grpCodeGen.add(this.m_rbAutoGen);
        this.m_grpCodeGen.add(this.m_rbUserWritten);
        this.m_rbAutoGen.setText(bundle.getString("TableProcessSourceTab.AutoGenerate.txt"));
        this.m_rbUserWritten.setText(bundle.getString("TableProcessSourceTab.UserWritten.txt"));
        this.m_lblHost.setText(bundle.getString("TableProcessSourceTab.ExecutionHost.txt"));
        this.m_btnDefine.setText(bundle.getString("ProcessSourcePanel.btnDefine.txt"));
        this.m_cbInactivate.setText(bundle.getString("ProcessSourcePanel.cbInactivate.txt"));
        this.m_btnDataLoc.setText(bundle.getString("ProcessSourcePanel.btnDataLoc.txt"));
        this.m_rbAutoGen.setMnemonic(bundle.getString("TableProcessSourceTab.AutoGenerate.mnem").charAt(0));
        this.m_rbUserWritten.setMnemonic(bundle.getString("TableProcessSourceTab.UserWritten.mnem").charAt(0));
        this.m_btnDefine.setMnemonic(bundle.getString("ProcessSourcePanel.btnDefine.mnem").charAt(0));
        this.m_cbInactivate.setMnemonic(bundle.getString("ProcessSourcePanel.cbInactivate.mnem").charAt(0));
        this.m_btnDataLoc.setMnemonic(bundle.getString("ProcessSourcePanel.btnDataLoc.mnem").charAt(0));
        this.m_lblHost.setDisplayedMnemonic(bundle.getString("TableProcessSourceTab.ExecutionHost.mnem").charAt(0));
        this.m_rbAutoGen.setToolTipText(bundle.getString("TableProcessSourceTab.AutoGenerate.ToolTip.txt"));
        this.m_rbUserWritten.setToolTipText(bundle.getString("TableProcessSourceTab.UserWritten.ToolTip.txt"));
        this.m_cmbHost.setToolTipText(bundle.getString("TableProcessSourceTab.ExecutionHost.ToolTip.txt"));
        this.m_btnDefine.setToolTipText(bundle.getString("ProcessSourcePanel.btnDefine.ToolTip.txt"));
        this.m_cbInactivate.setToolTipText(bundle.getString("ProcessSourcePanel.cbInactivate.ToolTip.txt"));
        this.m_btnDataLoc.setToolTipText(bundle.getString("ProcessSourcePanel.btnDataLoc.ToolTip.txt"));
        this.m_lblHost.setLabelFor((Component)this.m_cmbHost);
        this.listenForDataChangesTo(this.m_rbAutoGen);
        this.listenForDataChangesTo(this.m_rbUserWritten);
        this.listenForDataChangesTo(this.m_pnlSource);
        this.listenForDataChangesTo((JComboBox)this.m_cmbHost);
        this.listenForDataChangesTo(this.m_cbInactivate);
        this.m_rbAutoGen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProcessSourcePanel.this.m_rbAutoGen.isSelected()) {
                    ProcessSourcePanel.this.m_pnlSource.disableUserWritten();
                }
            }
        });
        this.m_rbUserWritten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProcessSourcePanel.this.m_rbUserWritten.isSelected()) {
                    ProcessSourcePanel.this.m_pnlSource.enableUserWritten();
                }
            }
        });
        this.m_cbInactivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProcessSourcePanel.this.m_cbInactivate.isSelected()) {
                    ProcessSourcePanel.this.disablePanel();
                } else {
                    ProcessSourcePanel.this.enablePanel();
                }
            }
        });
        this.m_btnDataLoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderPhysicalStorageDialog dlgLPS = new LoaderPhysicalStorageDialog();
                dlgLPS.setModal(true);
                dlgLPS.show();
                if (dlgLPS.getReturnValue() == 1) {
                    ((cTableListObject)ProcessSourcePanel.this.m_cmbTargetTables.getSelectedItem()).refresh();
                    ProcessSourcePanel.this.setDataChanged(true);
                }
            }
        });
        this.m_btnDefine.setEnabled(false);
    }

    protected void layoutWidgets() {
        this.m_pnlCodeGen.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlCodeGen.setBorder((Border)this.m_titledBorder);
        this.m_pnlCodeGen.add((Component)this.m_rbAutoGen, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlCodeGen.add((Component)this.m_rbUserWritten, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlCodeGen.add((Component)((Object)this.m_pnlSource), (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 16, 5, 5), 0, 0));
        WAPanel pnlProcAndOptions = new WAPanel();
        pnlProcAndOptions.setLayout((LayoutManager)new GridBagLayout());
        pnlProcAndOptions.add((Component)this.m_cbInactivate, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        WAPanel pnlServerSpec = new WAPanel();
        pnlServerSpec.setLayout((LayoutManager)new GridBagLayout());
        pnlServerSpec.add((Component)this.m_lblHost, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        pnlServerSpec.add((Component)this.m_cmbHost, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        WAPanel pnlProcPanel = new WAPanel();
        pnlProcPanel.setLayout((LayoutManager)new GridBagLayout());
        pnlProcPanel.add((Component)pnlServerSpec, (Object)new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlCodeGen, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)pnlProcPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)pnlProcAndOptions, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (!this.m_bAllowMultipleDataLocSelection) {
            this.add((Component)new WAPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.m_btnDataLoc, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 0, 0, 5), 0, 0));
        } else {
            WAPanel pnlTargetTables = new WAPanel();
            pnlTargetTables.setLayout((LayoutManager)new GridBagLayout());
            pnlTargetTables.add((Component)this.m_lblTargetTables, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            pnlTargetTables.add((Component)this.m_cmbTargetTables, (Object)new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            pnlTargetTables.add((Component)this.m_btnDataLoc, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)pnlTargetTables, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
        }
    }

    public boolean validateData() {
        return this.m_mdUpperLevel == null || !this.m_rbUserWritten.isSelected() || this.m_cbInactivate.isSelected() || this.m_pnlSource.validateData();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        if (this.m_mdUpperLevel != null) {
            if (this.m_bInactivate) {
                if (this.m_cbInactivate.isSelected()) {
                    this.m_mdUpperLevel.setIsActive(0);
                    this.m_mdLowerLevel.setIsActive(0);
                } else {
                    this.m_mdUpperLevel.setIsActive(1);
                    this.m_mdLowerLevel.setIsActive(1);
                }
            }
            if (this.m_rbUserWritten.isSelected()) {
                this.m_mdLowerLevel.setIsUserDefined(1);
                this.m_pnlSource.doDataExchange(true);
                AssociationList alSourceCode = this.m_mdLowerLevel.getSourceCodes();
                alSourceCode.flushAll();
                Text mdText = this.m_pnlSource.getTextObject();
                if (mdText != null) {
                    alSourceCode.add((Object)mdText);
                }
                alSourceCode.setState(16);
            } else {
                this.m_mdLowerLevel.setIsUserDefined(0);
            }
            if (!this.m_bHideExecutionHost) {
                ServerContext mdSC;
                AssociationList alDepComps = this.m_mdUpperLevel.getComputeLocations();
                alDepComps.flushAll();
                String strHost = (String)this.m_cmbHost.getSelectedItem();
                if (strHost.compareTo(bundle.getString("TableProcessSourceTab.ExecutionHost.DefaultHost.txt")) != 0 && (mdSC = (ServerContext)this.m_hmServerContexts.get(strHost)) != null) {
                    alDepComps.add(this.m_hmServerContexts.get(this.m_cmbHost.getSelectedItem()));
                }
                alDepComps.setState(16);
            }
        }
        this.m_mdUpperLevel.fireMdObjectModified(new MdEvent((Object)this));
        this.setDataChanged(false);
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_mdUpperLevel != null) {
            Text mdText;
            AssociationList al;
            this.m_mdStore = (MdObjectStore)this.m_mdUpperLevel.getObjectStore();
            this.m_mdLowerLevel = this.m_mdUpperLevel;
            if (this.m_mdUpperLevel instanceof TransformationStep && (al = ((TransformationStep)this.m_mdUpperLevel).getTransformations()).size() == 1) {
                this.m_mdLowerLevel = (ClassifierMap)al.get(0);
                AssociationList targetTableList = ((ClassifierMap)this.m_mdLowerLevel).getClassifierTargets();
                if (!this.m_bHideDataLocation && !targetTableList.isEmpty()) {
                    this.m_bDataLocation = true;
                    this.m_btnDataLoc.setEnabled(true);
                    this.m_cmbTargetTables.setEnabled(true);
                    this.m_lblTargetTables.setEnabled(true);
                    for (int i = 0; i < targetTableList.size(); ++i) {
                        this.m_cmbTargetTables.addItem((Object)new cTableListObject((PhysicalTable)targetTableList.get(i)));
                    }
                    this.m_cmbTargetTables.setSelectedIndex(0);
                }
            }
            if ((mdText = this.m_mdLowerLevel.getSourceCode()) == null) {
                this.m_pnlSource.setMetadataStore(this.m_mdStore);
            } else {
                this.m_pnlSource.setMetadataObject((CMetadata)mdText);
            }
            if (!this.m_bgottenData) {
                String template = "<Templates><AbstractTransformation><SourceCode/></AbstractTransformation><SASCatalogEntry><AssociatedSASCatalogs/></SASCatalogEntry><SASCatalog><UsingPackages/></SASCatalog><File><Directories/></File></Templates>";
                Vector<String> complex = new Vector<String>();
                complex.add("SourceCode");
                this.m_mdLowerLevel = (AbstractTransformation)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_mdLowerLevel, null, complex, template, 12);
                this.m_bgottenData = true;
            }
            this.m_pnlSource.doDataExchange(false);
            if (this.m_bAllowAutoGen) {
                if (this.m_mdLowerLevel.getIsUserDefined() == 0) {
                    this.m_rbAutoGen.setSelected(true);
                    this.m_rbUserWritten.setSelected(false);
                    this.m_pnlSource.disableAll();
                } else {
                    this.m_rbAutoGen.setSelected(false);
                    this.m_rbUserWritten.setSelected(true);
                    this.m_pnlSource.enableAll();
                }
            } else {
                this.m_rbAutoGen.setEnabled(false);
                this.m_rbUserWritten.setSelected(true);
                this.m_pnlSource.enableAll();
            }
            if (this.m_mdLowerLevel.getIsActive() == 0 && this.m_bInactivate) {
                this.m_cbInactivate.setSelected(true);
                this.disablePanel();
            } else {
                this.m_cbInactivate.setSelected(false);
            }
            if (!this.m_bHideExecutionHost) {
                this.populateHosts();
                AssociationList alCompLocations = this.m_mdUpperLevel.getComputeLocations();
                if (alCompLocations.size() > 0) {
                    String strDCName = ((DeployedComponent)alCompLocations.get(0)).getName();
                    this.m_cmbHost.setSelectedItem((Object)strDCName);
                }
            }
        }
        this.setListeningForChanges(true);
    }

    public void populateHosts() {
        this.m_cmbHost.removeAllItems();
        this.m_cmbHost.addItem((Object)bundle.getString("TableProcessSourceTab.ExecutionHost.DefaultHost.txt"));
        try {
            boolean bGoToServer = this.m_mdStore.getIsGoToServerForMetadata();
            this.m_mdStore.setIsGotToServerForMetadata(true);
            List vecServerContexts = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(this.m_mdLowerLevel.getObjectStore(), Workspace.getWorkspace().getDefaultRepository().getFQID(), "ServerContext", 8460, "");
            this.m_mdStore.setIsGotToServerForMetadata(bGoToServer);
            this.m_hmServerContexts = new HashMap();
            if (vecServerContexts.size() > 0) {
                int iSize = vecServerContexts.size();
                for (int i = 0; i < iSize; ++i) {
                    ServerContext mdSC = (ServerContext)vecServerContexts.get(i);
                    String strSCName = mdSC.getName();
                    this.m_cmbHost.addItem((Object)strSCName);
                    this.m_hmServerContexts.put(strSCName, mdSC);
                }
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public String getExecuteHostID() {
        String hostname = (String)this.m_cmbHost.getSelectedItem();
        if (hostname == null) {
            return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default");
        }
        if (hostname.equalsIgnoreCase("<Default Host>")) {
            return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default");
        }
        try {
            return ((ServerContext)this.m_hmServerContexts.get(hostname)).getFQID();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default");
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_bEditable = bEditable;
        this.m_rbAutoGen.setEnabled(bEditable);
        this.m_rbUserWritten.setEnabled(bEditable);
        this.m_cmbHost.setEnabled(bEditable);
        this.m_cbInactivate.setEnabled(bEditable && this.m_bInactivate);
        this.m_btnDataLoc.setEnabled(bEditable && this.m_bDataLocation);
        this.m_cmbTargetTables.setEnabled(bEditable && this.m_bDataLocation);
        this.m_pnlSource.setEditable(bEditable);
    }

    private void disablePanel() {
        this.m_cmbHost.setEnabled(false);
        this.m_lblHost.setEnabled(false);
        this.m_pnlCodeGen.setEnabled(false);
        this.m_rbAutoGen.setEnabled(false);
        this.m_rbUserWritten.setEnabled(false);
        this.m_btnDataLoc.setEnabled(false);
        this.m_cmbTargetTables.setEnabled(false);
        this.m_lblTargetTables.setEnabled(false);
        this.m_pnlSource.disableAll();
    }

    private void enablePanel() {
        if (this.m_bEditable) {
            this.m_pnlCodeGen.setEnabled(true);
            this.m_rbAutoGen.setEnabled(this.m_bAllowAutoGen);
            this.m_rbUserWritten.setEnabled(true);
            this.m_lblHost.setEnabled(true);
            this.m_cmbHost.setEnabled(true);
            this.m_btnDataLoc.setEnabled(this.m_bDataLocation);
            this.m_cmbTargetTables.setEnabled(this.m_bDataLocation);
            this.m_lblTargetTables.setEnabled(this.m_bDataLocation);
            if (this.m_rbUserWritten.isSelected()) {
                this.m_pnlSource.enableAll();
            }
        }
    }

    private class cTableListObject {
        private String m_displayString;
        private PhysicalTable m_table;

        public cTableListObject(PhysicalTable table) {
            try {
                this.m_displayString = table.getSASTableName();
                this.m_table = table;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }

        public String toString() {
            return this.m_displayString;
        }

        public PhysicalTable getTable() {
            return this.m_table;
        }

        public void refresh() {
            try {
                this.m_displayString = this.m_table.getSASTableName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    class LoaderPhysicalStorageDialog
    extends WAPropertyDialog {
        public LoaderPhysicalStorageDialog() {
            super((Frame)Workspace.getWorkspace(), bundle.getString("ProcessSourcePanel.btnDataLoc.txt"), true);
            try {
                PhysicalTable selTable = ((cTableListObject)ProcessSourcePanel.this.m_cmbTargetTables.getSelectedItem()).getTable();
                MdObjectStore store2 = Workspace.getMdFactory().createObjectStore(selTable.getObjectStore());
                PhysicalTable table2 = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(store2, (CMetadata)selTable);
                PhysicalStoragePane panel = new PhysicalStoragePane((CMetadata)table2, false, false);
                this.setMainPanel((WAPanel)panel);
                panel.setfGoToServer(false);
                this.setMetadataObject((CMetadata)table2);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }
}

