/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPlugin;
import com.sas.wadmin.visuals.MacroPluginPropertiesView;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.TransformManager;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsViewFactory;
import java.rmi.RemoteException;
import javax.swing.Icon;

public class ProcessLibTransformNode
extends WsTreeNode {
    private TransformInterface m_transform;
    private static final WAdminResource bundle = WAdminResource.getBundle(ProcessLibTransformNode.class);

    public ProcessLibTransformNode(TransformInterface transform) {
        super(transform.getName());
        super.setRenameable(true);
        this.setAllowsChildren(false);
        this.m_transform = transform;
    }

    public Icon getIcon() {
        return this.m_transform.getIcon();
    }

    public Icon getIcon(boolean bExpanded) {
        return this.m_transform.getIcon();
    }

    public String getName() {
        return this.m_transform.getName();
    }

    public String getToolTip() {
        return this.m_transform.getToolTip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName(String sName) {
        if (!(this.m_transform instanceof MacroPlugin)) {
            return;
        }
        if (sName.equals(this.getName())) {
            return;
        }
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ProcessLibTransformationNode:updateName");
            try {
                MacroPlugin plugin = (MacroPlugin)this.m_transform;
                Prototype mdoTransformation = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, plugin.getPrototype());
                mdoTransformation.setName(sName);
                if (MacroPluginUtilities.isGeneratedTransform((Root)mdoTransformation)) {
                    TransformManager.updateTransformNameAndDescription(mdoTransformation);
                    MacroPluginUtilities.updatePrototypeVersion(mdoTransformation);
                }
                store.updatedMetadataAll();
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public TransformInterface getTransformationObject() {
        return this.m_transform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showProperties() {
        if (this.m_transform instanceof MacroPlugin) {
            MacroPlugin plugin = (MacroPlugin)this.m_transform;
            boolean fIsUsed = false;
            CMetadata simplePrototype = plugin.getPrototype();
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                try {
                    Prototype proto = (Prototype)Workspace.getMdFactory().createComplexMetadataObject(store, simplePrototype);
                    if (MacroPluginUtilities.isGeneratedTransform((Root)proto) && (fIsUsed = MacroPluginUtilities.isPrototypeUsedInJobs(proto))) {
                        MessageUtil.displayMessage((String)bundle.getString("UsedPlugin.txt"), (int)2);
                    }
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            WsOMAView view = WsViewFactory.showView((CMetadata)plugin.getPrototype(), MacroPluginPropertiesView.class);
            if (fIsUsed) {
                view.getFrame().setEditable(false);
            }
        }
    }

    public void doDefaultAction() {
        this.showProperties();
    }

    public boolean isLeaf() {
        return true;
    }

    public CMetadata getMetadata() {
        if (this.m_transform instanceof MacroPlugin) {
            return ((MacroPlugin)this.m_transform).getPrototype();
        }
        return null;
    }

    public String getFQID() {
        if (this.m_transform instanceof MacroPlugin) {
            try {
                return ((MacroPlugin)this.m_transform).getPrototype().getFQID();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return null;
    }
}

