/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.Transformation;
import com.sas.wadmin.visuals.SourceCodePanel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class PrePostSourcePanel
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(PrePostSourcePanel.class);
    protected SourceCodePanel m_pnlPreSource;
    protected SourceCodePanel m_pnlPostSource;
    protected WAPanel m_pnlCodeGen;
    protected JCheckBox m_cbPreProcess;
    protected JCheckBox m_cbPostProcess;
    protected TitledBorder m_titledBorder;
    protected AbstractTransformation m_mdJob;
    protected Transformation m_mdPreProcess = null;
    protected Transformation m_mdPostProcess = null;
    protected AssociationList m_mdTransSources;
    protected AssociationList m_mdTransTargets;
    protected MdObjectStore m_mdStore;
    protected Text m_sourceCode;
    protected HashMap m_hmServerContexts;
    protected boolean m_bgottenData = false;
    protected boolean m_bEditable = true;

    public PrePostSourcePanel(AbstractTransformation inMetadata) {
        this(inMetadata, "", "");
    }

    public PrePostSourcePanel(AbstractTransformation inMetadata, String defaultProcessName) {
        this(inMetadata, defaultProcessName, "");
    }

    public PrePostSourcePanel(AbstractTransformation inMetadata, String defaultProcessName, String defaultUWCode) {
        this.m_mdJob = inMetadata;
        this.initialize(defaultProcessName, defaultUWCode);
        this.layoutWidgets();
    }

    protected void initialize() {
        this.initialize("");
    }

    protected void initialize(String defaultProcessName) {
        this.initialize(defaultProcessName, null);
    }

    protected void initialize(String defaultProcessName, String defaultUWCode) {
        this.m_cbPreProcess = new JCheckBox();
        this.m_cbPostProcess = new JCheckBox();
        this.m_titledBorder = new TitledBorder(bundle.getString("PrePostSourceTab.SourcePanelTitle"));
        this.m_pnlCodeGen = new WAPanel();
        String textName = "";
        if (defaultProcessName != null && defaultProcessName.length() > 0) {
            textName = defaultProcessName + " ";
        }
        StringBuffer preName = new StringBuffer(textName);
        StringBuffer postName = new StringBuffer(textName);
        preName.append(bundle.getString("PrePostSourcePanel.DefaultPreProcessName.txt"));
        this.m_pnlPreSource = new SourceCodePanel(false, preName.toString());
        if (defaultUWCode != null && defaultUWCode.length() > 0) {
            this.m_pnlPreSource.setSourceCode(defaultUWCode);
        }
        postName.append(bundle.getString("PrePostSourcePanel.DefaultPostProcessName.txt"));
        this.m_pnlPostSource = new SourceCodePanel(true, postName.toString());
        this.m_cbPreProcess.setText(bundle.getString("PrePostSourceTab.PreProcess"));
        this.m_cbPostProcess.setText(bundle.getString("PrePostSourceTab.PostProcess"));
        this.m_cbPreProcess.setMnemonic(bundle.getString("PrePostSourceTab.PreProcess.mnem").charAt(0));
        this.m_cbPostProcess.setMnemonic(bundle.getString("PrePostSourceTab.PostProcess.mnem").charAt(0));
        this.m_cbPreProcess.setToolTipText(bundle.getString("PrePostSourceTab.PreProcessToolTip"));
        this.m_cbPostProcess.setToolTipText(bundle.getString("PrePostSourceTab.PostProcessToolTip"));
        this.listenForDataChangesTo(this.m_cbPreProcess);
        this.listenForDataChangesTo(this.m_cbPostProcess);
        this.listenForDataChangesTo(this.m_pnlPreSource);
        this.listenForDataChangesTo(this.m_pnlPostSource);
        this.m_cbPreProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PrePostSourcePanel.this.m_cbPreProcess.isSelected()) {
                    PrePostSourcePanel.this.m_pnlPreSource.enableUserWritten();
                } else {
                    PrePostSourcePanel.this.m_pnlPreSource.disableUserWritten();
                }
            }
        });
        this.m_cbPostProcess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PrePostSourcePanel.this.m_cbPostProcess.isSelected()) {
                    PrePostSourcePanel.this.m_pnlPostSource.enableUserWritten();
                } else {
                    PrePostSourcePanel.this.m_pnlPostSource.disableUserWritten();
                }
            }
        });
    }

    protected void layoutWidgets() {
        this.m_pnlCodeGen.setLayout((LayoutManager)new GridBagLayout());
        this.m_pnlCodeGen.setBorder((Border)this.m_titledBorder);
        this.m_pnlCodeGen.add((Component)this.m_cbPreProcess, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlCodeGen.add((Component)((Object)this.m_pnlPreSource), (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 16, 5, 5), 0, 0));
        this.m_pnlCodeGen.add((Component)this.m_cbPostProcess, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlCodeGen.add((Component)((Object)this.m_pnlPostSource), (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 16, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlCodeGen, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new WAPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        if (this.m_mdJob != null) {
            if (this.m_cbPreProcess.isSelected() && !this.m_pnlPreSource.validateData()) {
                return false;
            }
            if (this.m_cbPostProcess.isSelected() && !this.m_pnlPostSource.validateData()) {
                return false;
            }
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            if (this.m_mdJob != null) {
                AssociationList List2;
                AssociationList jobList;
                this.m_pnlPreSource.doDataExchange(true);
                if (this.m_cbPreProcess.isSelected()) {
                    if (this.m_mdPreProcess == null) {
                        this.m_mdPreProcess = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(this.m_mdStore, null, "PreProcess", "Transformation", this.m_mdJob.getRepositoryID(), null);
                        jobList = this.m_mdJob.getTransformationSources();
                        if (jobList == null) {
                            List2 = new AssociationList("SourceTransformations");
                            List2.add((Object)this.m_mdJob);
                            this.m_mdPreProcess.setSourceTransformations(List2);
                        } else {
                            jobList.add((Object)this.m_mdPreProcess);
                        }
                        this.m_mdPreProcess.setTransformRole("PreProcess");
                    }
                    this.m_mdPreProcess.setIsActive(1);
                    AssociationList alSourceCode = this.m_mdPreProcess.getSourceCodes();
                    alSourceCode.flushAll();
                    Text mdPreText = this.m_pnlPreSource.getTextObject();
                    if (mdPreText != null) {
                        alSourceCode.add((Object)mdPreText);
                    }
                    alSourceCode.setState(16);
                } else if (this.m_mdPreProcess != null) {
                    this.m_mdPreProcess.setIsActive(0);
                }
                this.m_pnlPostSource.doDataExchange(true);
                if (this.m_cbPostProcess.isSelected()) {
                    if (this.m_mdPostProcess == null) {
                        this.m_mdPostProcess = (Transformation)Workspace.getMdFactory().createComplexMetadataObject(this.m_mdStore, null, "PostProcess", "Transformation", this.m_mdJob.getRepositoryID(), null);
                        jobList = this.m_mdJob.getTransformationTargets();
                        if (jobList == null) {
                            List2 = new AssociationList("TargetTransformations");
                            List2.add((Object)this.m_mdJob);
                            this.m_mdPostProcess.setTargetTransformations(List2);
                        } else {
                            jobList.add((Object)this.m_mdPostProcess);
                        }
                        this.m_mdPostProcess.setTransformRole("PostProcess");
                    }
                    this.m_mdPostProcess.setIsActive(1);
                    AssociationList alSourceCode1 = this.m_mdPostProcess.getSourceCodes();
                    alSourceCode1.flushAll();
                    Text mdPostText = this.m_pnlPostSource.getTextObject();
                    if (mdPostText != null) {
                        alSourceCode1.add((Object)mdPostText);
                    }
                    alSourceCode1.setState(16);
                } else if (this.m_mdPostProcess != null) {
                    this.m_mdPostProcess.setIsActive(0);
                }
            }
        } else if (this.m_mdJob != null) {
            Transformation step;
            Root root;
            this.m_mdStore = (MdObjectStore)this.m_mdJob.getObjectStore();
            this.m_mdTransSources = this.m_mdJob.getTransformationSources();
            for (int k = 0; k < this.m_mdTransSources.size(); ++k) {
                root = (Root)this.m_mdTransSources.get(k);
                if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equals("PreProcess")) continue;
                this.m_mdPreProcess = step;
                if (step.getIsActive() != 1) break;
                this.m_cbPreProcess.setSelected(true);
                break;
            }
            if (this.m_mdPreProcess != null) {
                Text mdPreText = this.m_mdPreProcess.getSourceCode();
                if (mdPreText == null) {
                    this.m_pnlPreSource.setMetadataStore(this.m_mdStore);
                } else {
                    this.m_pnlPreSource.setMetadataObject((CMetadata)mdPreText);
                }
            } else {
                this.m_pnlPreSource.setMetadataStore(this.m_mdStore);
            }
            this.m_mdTransTargets = this.m_mdJob.getTransformationTargets();
            for (int i = 0; i < this.m_mdTransTargets.size(); ++i) {
                root = (Root)this.m_mdTransTargets.get(i);
                if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equals("PostProcess")) continue;
                this.m_mdPostProcess = step;
                if (step.getIsActive() != 1) break;
                this.m_cbPostProcess.setSelected(true);
                break;
            }
            if (this.m_mdPostProcess != null) {
                Text mdPostText = this.m_mdPostProcess.getSourceCode();
                if (mdPostText == null) {
                    this.m_pnlPostSource.setMetadataStore(this.m_mdStore);
                } else {
                    this.m_pnlPostSource.setMetadataObject((CMetadata)mdPostText);
                }
            } else {
                this.m_pnlPostSource.setMetadataStore(this.m_mdStore);
            }
            if (!this.m_bgottenData) {
                String template = "<Templates><Transformation><SourceCode/></Transformation><File><Directories/></File></Templates>";
                Vector<String> complex = new Vector<String>();
                complex.add("SourceCode");
                this.m_mdPreProcess = (Transformation)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_mdPreProcess, null, complex, template, 12);
                this.m_mdPostProcess = (Transformation)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_mdPostProcess, null, complex, template, 12);
                this.m_bgottenData = true;
            }
            this.m_pnlPreSource.doDataExchange(false);
            this.m_pnlPostSource.doDataExchange(false);
            if (this.m_cbPreProcess.isSelected()) {
                this.m_pnlPreSource.enableUserWritten();
            } else {
                this.m_pnlPreSource.disableUserWritten();
            }
            if (this.m_cbPostProcess.isSelected()) {
                this.m_pnlPostSource.enableUserWritten();
            } else {
                this.m_pnlPostSource.disableUserWritten();
            }
        }
        this.setDataChanged(false);
        this.getWAUndoManager().discardAllEdits();
        return true;
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_bEditable = bEditable;
        this.m_cbPreProcess.setEnabled(bEditable);
        this.m_pnlPreSource.setEditable(bEditable);
        this.m_cbPostProcess.setEnabled(bEditable);
        this.m_pnlPostSource.setEditable(bEditable);
    }
}

