/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.wadmin.model.tree.TempLogicalObjectNode;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.ImpactAnalysisOMAView;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.wadmin.visuals.SASLibraryServerDialog;
import com.sas.wadmin.visuals.TableStatisticsView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsViewFactory;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PhysicalTableTreeNode
extends TempLogicalObjectNode {
    private static WAdminResource bundle = new WAdminResource(PhysicalTableTreeNode.class);
    private static Icon NORMAL_ICON = WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true);
    private static Icon PARAMS_ICON = bundle.getImageIcon("PhysicalTableTreeNode.PhysicalTableParameter.image");
    protected WsAbstractAction m_actViewData = this.createViewDataAction();
    protected WsAbstractAction m_actImpactAnalysis;
    protected WsAbstractAction m_actReverseImpactAnalysis;
    protected WsAbstractAction m_actDisplayLibrary = this.createDisplayLibraryAction();
    protected WsAbstractAction m_actDisplayTableStatistics;
    protected WsAbstractAction m_actViewStatistics;

    public PhysicalTableTreeNode(Root oTable) {
        super((CMetadata)oTable);
        this.m_actImpactAnalysis = this.createImpactAnalysisAction();
        this.m_actReverseImpactAnalysis = this.createReverseImpactAnalysisAction();
        this.m_actViewStatistics = this.createViewStatisticsAction();
        this.updateIcon();
    }

    public JPopupMenu getPopupMenu(WAdminResource abundle) {
        JPopupMenu menuPopup = super.getPopupMenu(abundle);
        menuPopup.add(new JMenuItem((Action)this.m_actViewData));
        menuPopup.add(new JMenuItem((Action)this.m_actViewStatistics));
        menuPopup.add(new JMenuItem((Action)this.m_actDisplayLibrary));
        menuPopup.addSeparator();
        menuPopup.add(new JMenuItem((Action)this.m_actImpactAnalysis));
        menuPopup.add(new JMenuItem((Action)this.m_actReverseImpactAnalysis));
        return menuPopup;
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actViewData.setActive(bActive);
        this.m_actViewStatistics.setActive(bActive);
        this.m_actDisplayLibrary.setActive(bActive);
        this.m_actImpactAnalysis.setActive(bActive);
        this.m_actReverseImpactAnalysis.setActive(bActive);
    }

    public void onViewData() {
        WsViewFactory.showView((CMetadata)this.m_oMetadata, ViewDataView.class);
    }

    public void onViewStatistics() {
        WsViewFactory.showView((CMetadata)this.m_oMetadata, TableStatisticsView.class);
    }

    @Override
    public void updateMetadata(CMetadata oMetadata) {
        this.updateIcon();
        super.updateMetadata(oMetadata);
    }

    protected void updateIcon() {
        this.setIcon(this.getDecoratedIcon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon getDecoratedIcon() {
        Icon icon = NORMAL_ICON;
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                PhysicalTable table = (PhysicalTable)factory.createComplexMetadataObject(store, this.m_oMetadata);
                ParametersModel parmModel = new ParametersModel((Root)table);
                if (parmModel.isParameterizedObject()) {
                    icon = PARAMS_ICON;
                }
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showImpactAnalysis(boolean bForward) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            MdObjectStore store = factory.createObjectStore();
            PhysicalTable oDetail = (PhysicalTable)Workspace.getMdFactory().createComplexMetadataObject(store, this.m_oMetadata);
            ImpactAnalysisOMAView view = this.findImpactAnalysisView(oDetail, bForward);
            if (view != null) {
                oDetail.getObjectStore().dispose();
                WsViewFactory.showExistingView((WsOMAView)view);
                return;
            }
            view = new ImpactAnalysisOMAView((Classifier)oDetail, bForward);
            WsViewFactory.attachViewToFrame((CMetadata)oDetail, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame((CMetadata)oDetail, ""));
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private ImpactAnalysisOMAView findImpactAnalysisView(PhysicalTable oTable, boolean bForward) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayLibrary() {
        try {
            Workspace.getWorkspace();
            MdFactory factory = Workspace.getMdFactory();
            MdObjectStore store = factory.createObjectStore();
            try {
                PhysicalTable oDetail = (PhysicalTable)factory.createComplexMetadataObject(store, this.m_oMetadata);
                new SASLibraryServerDialog(oDetail).show();
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected WsAbstractAction createViewDataAction() {
        return new cViewDataAction();
    }

    protected WsAbstractAction createViewStatisticsAction() {
        return new cViewStatisticsAction();
    }

    protected WsAbstractAction createImpactAnalysisAction() {
        return new cImpactAnalysisAction();
    }

    protected WsAbstractAction createReverseImpactAnalysisAction() {
        return new cReverseImpactAnalysisAction();
    }

    protected WsAbstractAction createDisplayLibraryAction() {
        return new cDisplayLibraryAction();
    }

    protected class cDisplayLibraryAction
    extends WsAbstractAction {
        public cDisplayLibraryAction() {
            super(bundle, "PhysicalTableTreeNode.DisplayLibrary");
            this.setMenuSupportId("displaylibrary");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalTableTreeNode.this.onDisplayLibrary();
        }
    }

    protected class cReverseImpactAnalysisAction
    extends WsAbstractAction {
        public cReverseImpactAnalysisAction() {
            super(bundle, "Tree.PopupMenu.ReverseImpact", true);
            this.setMenuSupportId("reverseimpactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalTableTreeNode.this.showImpactAnalysis(false);
        }
    }

    protected class cImpactAnalysisAction
    extends WsAbstractAction {
        public cImpactAnalysisAction() {
            super(bundle, "Tree.PopupMenu.Impact", true);
            this.setMenuSupportId("impactanalysis");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalTableTreeNode.this.showImpactAnalysis(true);
        }
    }

    protected class cViewStatisticsAction
    extends WsAbstractAction {
        public cViewStatisticsAction() {
            super(bundle, "PhysicalTableTreeNode.ViewStatistics");
            this.setMenuSupportId("viewtablestatistics");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalTableTreeNode.this.onViewStatistics();
        }
    }

    protected class cViewDataAction
    extends WsAbstractAction {
        public cViewDataAction() {
            super(bundle, "Tree.PopupMenu.ViewData");
            this.setMenuSupportId("viewdata");
            this.setHidable(true);
        }

        public void actionPerformed(ActionEvent e) {
            PhysicalTableTreeNode.this.onViewData();
        }
    }
}

