/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.WorkTable;
import com.sas.services.ServiceException;
import com.sas.wadmin.app.AppPropertiesDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.OptionsTab;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.TransformUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.mgmt.visuals.LibraryWizard;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.VersionUtil;
import com.sas.workspace.visuals.DBMSNamesPropertiesPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class PhysicalStoragePane
extends WAPropertyTab
implements MdObjectListener {
    private static WAdminResource bundle = WAdminResource.getBundle(PhysicalStoragePane.class);
    private static final int MAX_TABLE_NAME_L = 32;
    public static final String SAS_INFOMAP_LIBRARY_ENGINE = "SASIOIME";
    public static final String SAS_DATA_IN_HDFS = "SASHDAT";
    protected JLabel m_LibraryLabel;
    protected JLabel m_SchemaLabel;
    protected JLabel m_NameLabel;
    protected JLabel m_DBMSLabel;
    protected JButton m_OptionsButton;
    protected JButton m_btnNewLibrary;
    protected JButton m_btnEditLibrary;
    protected WAComboBox m_DBMSComboBox;
    protected WAComboBox m_LibraryComboBox;
    protected WATextField m_txtSchema;
    protected WATextField m_NameField;
    protected CMetadata m_metadata;
    protected ArrayList m_alProductNames;
    protected ArrayList m_alStringsPassedToLibWizard;
    protected boolean m_SASonly;
    protected boolean m_showButtons;
    protected boolean m_bDataObtained = false;
    protected boolean fGoToServer = true;
    protected int m_iPrevSchema;
    protected String m_origDBMS;
    protected String m_strCurrentDBMS;
    protected String m_origName;
    protected String m_strNoLib;
    protected String m_strPrevDBMS;
    protected String m_SASengine;
    protected String sEngineType;
    protected SASLibrary m_origLibrary;
    protected SASLibrary m_currentLibrary;
    protected SASLibrary m_selectedLibrary;
    protected DatabaseSchema m_origSchema;
    protected DatabaseSchema m_currentSchema;
    protected PhysicalTable m_ptCurrentTable;
    protected MdObjectStore m_myStore;
    protected DBMSNamesPropertiesPanel m_DBMSNamesPanel;
    protected ComboItemListener m_cmbLibraryListener;
    protected ComboItemListener m_cmbSchemaListener;
    protected List m_metaQuery;
    protected List m_metaQueryAll;

    public PhysicalStoragePane(CMetadata metadata, boolean SASonly, boolean showButtons) {
        this.m_SASonly = SASonly;
        this.m_showButtons = showButtons;
        this.m_metadata = metadata;
        this.initialize();
        this.layoutWidgets();
        if (showButtons) {
            this.setHelpProduct("shared");
            this.setHelpTopic("physical_storage_tab");
        } else {
            this.setHelpProduct("wdb");
            this.setHelpTopic("data_location_win");
        }
    }

    public PhysicalStoragePane(CMetadata metadata, boolean SASonly) {
        this(metadata, SASonly, true);
    }

    public PhysicalStoragePane(CMetadata metadata) {
        this(metadata, false, true);
    }

    public void initialize() {
        this.m_LibraryLabel = new JLabel(bundle.getString("PhysicalStoragePane.LibraryLabel.txt"));
        this.m_SchemaLabel = new JLabel(bundle.getString("PhysicalStoragePane.SchemaLabel.txt"));
        this.m_NameLabel = new JLabel(bundle.getString("PhysicalStoragePane.NameLabel.txt"));
        this.m_btnNewLibrary = new JButton(bundle.getString("Common.New3.txt"));
        this.m_btnEditLibrary = new JButton(bundle.getString("Common.Edit2.txt"));
        this.m_OptionsButton = new JButton(bundle.getString("PhysicalStoragePane.OptionsButton.txt"));
        this.m_DBMSComboBox = new WAComboBox();
        this.m_LibraryComboBox = new WAComboBox(true);
        this.m_txtSchema = new WATextField();
        this.m_txtSchema.setEnabled(false);
        this.m_DBMSLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_DBMSComboBox, (String)bundle.getString("PhysicalStoragePane.DBMSLabel.txt"));
        this.m_NameField = new WATextField();
        this.m_NameField.setMaxCharacters(32);
        this.listenForDataChangesTo((JTextComponent)this.m_NameField);
        this.m_NameField.getDocument().addUndoableEditListener(new WAGUndoableEditListener());
        this.m_strNoLib = bundle.getString("PhysicalStoragePane.Library.none.txt");
        this.m_DBMSNamesPanel = new DBMSNamesPropertiesPanel((Root)this.m_metadata);
        this.listenForDataChangesTo((WAPanel)this.m_DBMSNamesPanel);
        this.m_DBMSComboBox.setToolTipText(bundle.getString("PhysicalStoragePane.DBMSTootip"));
        this.m_LibraryComboBox.setToolTipText(bundle.getString("PhysicalStoragePane.LibraryTooltip"));
        this.m_btnNewLibrary.setToolTipText(bundle.getString("PhysicalStoragePane.NewLibraryButtonTooltip"));
        this.m_btnEditLibrary.setToolTipText(bundle.getString("PhysicalStoragePane.EditLibraryButtonTooltip"));
        this.m_OptionsButton.setToolTipText(bundle.getString("PhysicalStoragePane.OptionsButtonTooltip"));
        this.m_NameField.setToolTipText(bundle.getString("PhysicalStoragePane.NameTooltip"));
        this.setMnemonics();
        this.populateDBMSComboBox(this.m_SASonly);
        this.setSchemaDisplay(this.m_SASonly);
        this.m_DBMSNamesPanel.setVisible(true);
        this.m_cmbLibraryListener = new ComboItemListener();
        this.m_cmbSchemaListener = new ComboItemListener();
        this.m_LibraryComboBox.addItemListener((ItemListener)this.m_cmbLibraryListener);
        this.m_DBMSComboBox.addItemListener((ItemListener)new ComboItemListener());
        this.m_OptionsButton.addActionListener(new cOptionsButtonListener());
        if (this.m_showButtons) {
            this.m_btnNewLibrary.addActionListener(new cNewLibButtonListener());
            this.m_btnEditLibrary.addActionListener(new cEditLibButtonListener());
        } else {
            this.m_btnNewLibrary.setVisible(false);
            this.m_btnEditLibrary.setVisible(false);
        }
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_DBMSLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_DBMSComboBox, new GridBagConstraints(1, 0, 2, 1, 0.7, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_LibraryLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_LibraryComboBox, new GridBagConstraints(1, 1, 2, 1, 0.7, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_btnNewLibrary, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_btnEditLibrary, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_NameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_NameField, new GridBagConstraints(1, 2, 2, 1, 0.7, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add(this.m_SchemaLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_txtSchema, new GridBagConstraints(1, 3, 2, 1, 0.7, 0.0, 17, 2, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.m_DBMSNamesPanel, new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_OptionsButton, new GridBagConstraints(3, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        try {
            if (!saveToModel) {
                this.m_myStore = (MdObjectStore)this.m_metadata.getObjectStore();
                if (this.m_bDataObtained) {
                    boolean bl = true;
                    return bl;
                }
                this.queryMetadata();
                this.m_DBMSNamesPanel.doDataExchange(saveToModel);
                if (this.m_metadata instanceof PhysicalTable) {
                    this.m_ptCurrentTable = (PhysicalTable)this.m_metadata;
                    this.m_DBMSNamesPanel.setMetadataObject((Root)this.m_metadata);
                } else if (this.m_metadata instanceof TransformationStep) {
                    ClassifierMap m_oMap = (ClassifierMap)((TransformationStep)this.m_metadata).getTransformations().get(0);
                    this.m_ptCurrentTable = (PhysicalTable)m_oMap.getClassifierTargets().get(0);
                }
                this.m_origName = this.m_ptCurrentTable.getSASTableName();
                if (this.m_origName == null) {
                    this.m_origName = "";
                }
                this.m_NameField.setText(this.m_origName);
                this.m_DBMSNamesPanel.setSASTable(false);
                this.getLibraryCurrent(this.m_ptCurrentTable);
                this.m_origDBMS = TransformUtil.getDBMSProductName((PhysicalTable)this.m_ptCurrentTable);
                if (this.m_origDBMS == null) {
                    this.m_origDBMS = "SAS";
                } else if (this.m_origDBMS.equalsIgnoreCase("SAS")) {
                    if (this.m_currentLibrary != null) {
                        this.m_SASengine = this.m_currentLibrary.getEngine();
                        if (this.m_SASengine.equalsIgnoreCase("XML")) {
                            this.m_origDBMS = LibraryUtil.getXMLProductName((SASLibrary)this.m_currentLibrary);
                        } else if (this.m_SASengine.equalsIgnoreCase("XMLV2")) {
                            this.m_origDBMS = LibraryUtil.getXMLV2ProductName((SASLibrary)this.m_currentLibrary);
                        } else if (this.m_SASengine.equalsIgnoreCase("SPDE")) {
                            this.m_origDBMS = this.m_SASengine.toUpperCase();
                        } else if (this.m_SASengine.equalsIgnoreCase("JSON")) {
                            this.m_origDBMS = this.m_SASengine.toUpperCase();
                        }
                    }
                } else {
                    this.m_origDBMS = this.m_currentLibrary.getEngine().equalsIgnoreCase(SAS_INFOMAP_LIBRARY_ENGINE) ? SAS_INFOMAP_LIBRARY_ENGINE : (this.m_currentLibrary.getEngine().equalsIgnoreCase(SAS_DATA_IN_HDFS) ? SAS_DATA_IN_HDFS : this.m_origDBMS.toUpperCase());
                }
                this.m_strPrevDBMS = this.m_origDBMS == null || this.m_origDBMS.equals("") || this.m_SASonly ? "SAS" : this.m_origDBMS;
                if (this.m_SASonly) {
                    this.m_alProductNames.add("SAS");
                    this.m_DBMSComboBox.addItem((Object)"SAS");
                    this.m_alStringsPassedToLibWizard.add("BASE");
                } else {
                    int intLocation = this.m_alProductNames.indexOf(this.m_strPrevDBMS);
                    if (this.m_DBMSComboBox.getSelectedIndex() != intLocation) {
                        this.m_DBMSComboBox.setSelectedIndex(intLocation);
                    } else {
                        this.dbmsListenerGuts();
                    }
                }
                this.m_origLibrary = this.m_currentLibrary;
                this.m_origSchema = this.m_currentSchema;
            } else {
                this.m_DBMSNamesPanel.doDataExchange(saveToModel);
                if (this.m_strCurrentDBMS.equalsIgnoreCase("SAS") || this.m_strCurrentDBMS.startsWith("XML") || this.m_strCurrentDBMS.equalsIgnoreCase("JSON") || this.m_strCurrentDBMS.equalsIgnoreCase("SPDE")) {
                    if (this.m_selectedLibrary != null) {
                        if (!this.m_selectedLibrary.equals(this.m_origLibrary)) {
                            this.m_ptCurrentTable.setTablePackage((RelationalSchema)this.m_selectedLibrary);
                        }
                    } else if (this.m_origLibrary != null) {
                        this.m_ptCurrentTable.getTablePackages(false).removeAllElements();
                    }
                    this.m_DBMSNamesPanel.doDataExchange(saveToModel);
                } else if (this.m_strCurrentDBMS.equalsIgnoreCase("REMOTE")) {
                    if (this.m_selectedLibrary != null) {
                        if (!this.m_selectedLibrary.equals(this.m_origLibrary)) {
                            SASLibrary iServerLibrary = (SASLibrary)this.m_selectedLibrary.getUsingPackages().get(0);
                            if (iServerLibrary.getIsDBMSLibname() > 0 && iServerLibrary.getUsingPackages().size() > 0) {
                                RelationalSchema iSchema = (RelationalSchema)iServerLibrary.getUsingPackages().get(0);
                                if (iSchema instanceof DatabaseSchema) {
                                    this.m_ptCurrentTable.setTablePackage(iSchema);
                                }
                            } else {
                                this.m_ptCurrentTable.setTablePackage((RelationalSchema)iServerLibrary);
                            }
                        }
                    } else if (this.m_origLibrary != null) {
                        this.m_ptCurrentTable.getTablePackages(false).removeAllElements();
                    }
                } else {
                    if (this.m_currentSchema instanceof DatabaseSchema) {
                        if (!this.m_currentSchema.equals(this.m_origSchema)) {
                            this.m_ptCurrentTable.setTablePackage((RelationalSchema)this.m_currentSchema);
                        }
                    } else {
                        this.m_ptCurrentTable.getTablePackages(false).removeAllElements();
                    }
                    this.m_DBMSNamesPanel.setSASTable(false);
                    this.m_DBMSNamesPanel.doDataExchange(saveToModel);
                }
                String m_strCurrentName = this.m_NameField.getText();
                if (m_strCurrentName == null) {
                    m_strCurrentName = "";
                }
                if (!this.m_origName.equals(m_strCurrentName)) {
                    this.m_ptCurrentTable.setSASTableName(m_strCurrentName);
                }
            }
        }
        finally {
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
        return true;
    }

    public boolean validateData() {
        boolean validName = true;
        if (this.m_metadata instanceof WorkTable) {
            return validName;
        }
        String tableName = this.getNameField();
        if (tableName.length() < 1) {
            MessageUtil.displayMessage((String)bundle.getString("PhysicalStoragePane.BlankNameError.txt"), (int)0);
            this.m_NameField.requestFocus();
            return false;
        }
        return validName;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
    }

    public void setMetadataObject(CMetadata metadata) {
        this.m_metadata = metadata;
    }

    protected void subsetLibraries(String dbms) {
        try {
            this.m_LibraryComboBox.removeItemListener((ItemListener)this.m_cmbLibraryListener);
            if (this.m_LibraryComboBox.hasItems()) {
                this.m_LibraryComboBox.removeAllItems();
            }
            for (int j = 0; j < this.m_metaQuery.size(); ++j) {
                boolean bAddLibToList = false;
                SASLibrary library = (SASLibrary)this.m_metaQuery.get(j);
                boolean bIsDBMSLib = library.getIsDBMSLibname() >= 1;
                if (!bIsDBMSLib) {
                    String sXMLtype;
                    this.m_SASengine = library.getEngine();
                    if (dbms.equalsIgnoreCase("SAS")) {
                        if (this.m_SASengine.equalsIgnoreCase("BASE")) {
                            bAddLibToList = true;
                        } else if (!(this.m_SASengine.equalsIgnoreCase("SPDE") || this.m_SASengine.equalsIgnoreCase("XML") || this.m_SASengine.equalsIgnoreCase("JSON"))) {
                            bAddLibToList = true;
                        }
                    } else if (dbms.equalsIgnoreCase(this.m_SASengine)) {
                        bAddLibToList = true;
                    } else if (dbms.startsWith("XML") && this.m_SASengine.equalsIgnoreCase("XML")) {
                        sXMLtype = dbms.substring(3);
                        if (sXMLtype.length() > 0) {
                            this.sEngineType = LibraryUtil.getLibraryProperty((SASLibrary)library, (String)"XMLTYPE");
                            if (this.sEngineType.equalsIgnoreCase(sXMLtype)) {
                                bAddLibToList = true;
                            }
                        } else {
                            bAddLibToList = true;
                        }
                    } else if (dbms.startsWith("XMLV2") && this.m_SASengine.equalsIgnoreCase("XMLV2")) {
                        sXMLtype = dbms.substring(5);
                        if (sXMLtype.length() > 0) {
                            this.sEngineType = LibraryUtil.getLibraryProperty((SASLibrary)library, (String)"XMLTYPE");
                            if (this.sEngineType.equalsIgnoreCase(sXMLtype)) {
                                bAddLibToList = true;
                            }
                        } else {
                            bAddLibToList = true;
                        }
                    }
                } else if (!dbms.equalsIgnoreCase("SAS") && bIsDBMSLib) {
                    this.sEngineType = this.getEngineSubtype(library);
                    if (this.sEngineType.equalsIgnoreCase(dbms)) {
                        bAddLibToList = true;
                    }
                }
                if (!bAddLibToList) continue;
                this.m_LibraryComboBox.addItem((Object)library);
            }
            this.m_LibraryComboBox.addItem((Object)this.m_strNoLib);
            this.m_cmbLibraryListener = new ComboItemListener();
            this.m_LibraryComboBox.addItemListener((ItemListener)this.m_cmbLibraryListener);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    protected SASLibrary matchSchemaToLibrary(DatabaseSchema schema) {
        try {
            String schemaFQID = schema.getFQID();
            for (int j = 0; j < this.m_metaQuery.size(); ++j) {
                DatabaseSchema assocMeta;
                DeployedDataPackage ddp;
                AssociationList usingPackages;
                SASLibrary library = (SASLibrary)this.m_metaQuery.get(j);
                if (library.getIsDBMSLibname() <= 0 || (usingPackages = library.getUsingPackages()).size() <= 0 || !((ddp = (DeployedDataPackage)usingPackages.get(0)) instanceof DatabaseSchema) || !schemaFQID.equalsIgnoreCase((assocMeta = (DatabaseSchema)ddp).getFQID())) continue;
                return library;
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return null;
    }

    protected void getCurrentLibrarySchemas() {
        try {
            this.m_txtSchema.setText("");
            if (!(this.m_strCurrentDBMS.equalsIgnoreCase("SAS") || this.m_strCurrentDBMS.equalsIgnoreCase("SPDE") || this.m_strCurrentDBMS.equalsIgnoreCase("REMOTE") || this.m_strCurrentDBMS.equalsIgnoreCase("JSON") || this.m_strCurrentDBMS.startsWith("XML"))) {
                if (this.m_selectedLibrary != null) {
                    SASLibrary library = this.m_selectedLibrary;
                    this.setSchemaEnabled(this.m_bEditable);
                    AssociationList usingPackages = library.getUsingPackages();
                    for (int k = 0; k < usingPackages.size(); ++k) {
                        RelationalSchema assocMeta = (RelationalSchema)usingPackages.get(k);
                        if (!(assocMeta instanceof DatabaseSchema)) continue;
                        this.m_currentSchema = (DatabaseSchema)assocMeta;
                        this.m_txtSchema.setText(((DatabaseSchema)assocMeta).getSchemaName());
                        break;
                    }
                }
                this.setSchemaEnabled(this.m_bEditable);
                this.m_DBMSNamesPanel.setStorePopulated(false);
                this.m_DBMSNamesPanel.setSASTable(false);
                this.m_DBMSNamesPanel.populateStore();
                this.m_DBMSNamesPanel.moveDataToView();
                this.m_DBMSNamesPanel.setEditable(this.m_bEditable);
            } else {
                this.setSchemaEnabled(false);
                if (!(this.m_strCurrentDBMS.equalsIgnoreCase("SAS") || this.m_strCurrentDBMS.equalsIgnoreCase("SPDE") || this.m_strCurrentDBMS.equalsIgnoreCase("REMOTE") || this.m_strCurrentDBMS.equalsIgnoreCase("JSON") || this.m_strCurrentDBMS.startsWith("XML"))) {
                    this.m_DBMSNamesPanel.setPanelClear(true);
                    this.m_DBMSNamesPanel.setEditable(false);
                } else {
                    this.m_DBMSNamesPanel.setStorePopulated(false);
                    this.m_DBMSNamesPanel.setSASTable(false);
                    this.m_DBMSNamesPanel.populateStore();
                    this.m_DBMSNamesPanel.moveDataToView();
                    this.m_DBMSNamesPanel.setEditable(this.m_bEditable);
                }
            }
            this.m_cmbSchemaListener = new ComboItemListener();
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    protected void setMnemonics() {
        this.m_SchemaLabel.setDisplayedMnemonic(bundle.getString("PhysicalStoragePane.Schema.mnem").charAt(0));
        this.m_NameLabel.setLabelFor((Component)this.m_NameField);
        this.m_NameLabel.setDisplayedMnemonic(bundle.getString("PhysicalStoragePane.Name.mnem").charAt(0));
        this.m_LibraryLabel.setLabelFor((Component)this.m_LibraryComboBox);
        this.m_LibraryLabel.setDisplayedMnemonic(bundle.getString("PhysicalStoragePane.Library.mnem").charAt(0));
        this.m_OptionsButton.setMnemonic(bundle.getString("PhysicalStoragePane.OptionsButton.mnem").charAt(0));
        this.m_btnNewLibrary.setMnemonic(bundle.getString("PhysicalStoragePane.NewLibrary.mnem").charAt(0));
        this.m_btnEditLibrary.setMnemonic(bundle.getString("PhysicalStoragePane.EditLibrary.mnem").charAt(0));
    }

    protected void populateDBMSComboBox(boolean SASonlyDBMS) {
        this.m_alProductNames = new ArrayList();
        this.m_alStringsPassedToLibWizard = new ArrayList();
        if (!SASonlyDBMS) {
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ASTER.notrans"));
            this.m_alProductNames.add("ASTER");
            this.m_alStringsPassedToLibWizard.add("ASTER");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.BIGQUERY.notrans"));
            this.m_alProductNames.add("BIGQUERY");
            this.m_alStringsPassedToLibWizard.add("SASIOGBQ");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.DB2UNXPC.notrans"));
            this.m_alProductNames.add("DB2UNXPC");
            this.m_alStringsPassedToLibWizard.add("DB2UNXPC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.DB2OS390.notrans"));
            this.m_alProductNames.add("DB2OS390");
            this.m_alStringsPassedToLibWizard.add("DB2OS390");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.GREENPLUM.notrans"));
            this.m_alProductNames.add("GREENPLM");
            this.m_alStringsPassedToLibWizard.add("GREENPLM");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.HadoopViaHive.Name.txt"));
            this.m_alProductNames.add("HADOOP");
            this.m_alStringsPassedToLibWizard.add("HADOOP");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.HAWQ.Name.txt"));
            this.m_alProductNames.add("HAWQ");
            this.m_alStringsPassedToLibWizard.add("SASIOHWQ");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.Impala.Name.txt"));
            this.m_alProductNames.add("SASIOIMP");
            this.m_alStringsPassedToLibWizard.add("SASIOIMP");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.Informix.notrans"));
            this.m_alProductNames.add("INFORMIX");
            this.m_alStringsPassedToLibWizard.add("INFORMIX");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.JDBC.notrans"));
            this.m_alProductNames.add("JDBC");
            this.m_alStringsPassedToLibWizard.add("SASIOJDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("JSONImporter.Name.JSON.txt"));
            this.m_alProductNames.add(bundle.getString("JSONImporter.description.JSON.notrans"));
            this.m_alStringsPassedToLibWizard.add("JSON");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.EXCEL.notrans"));
            this.m_alProductNames.add("EXCEL");
            this.m_alStringsPassedToLibWizard.add("EXCEL");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SQLSVR.notrans"));
            this.m_alProductNames.add("SQLSVR");
            this.m_alStringsPassedToLibWizard.add("SQLSVR");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.MONGODB.notrans"));
            this.m_alProductNames.add("MONGODB");
            this.m_alStringsPassedToLibWizard.add("SASIOMGO");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.MYSQL.notrans"));
            this.m_alProductNames.add("MYSQL");
            this.m_alStringsPassedToLibWizard.add("MYSQL");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.NEOVIEW.notrans"));
            this.m_alProductNames.add("NEOVIEW");
            this.m_alStringsPassedToLibWizard.add("NEOVIEW");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.NETEZZA.notrans"));
            this.m_alProductNames.add("NETEZZA");
            this.m_alStringsPassedToLibWizard.add("NETEZZA");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCDB2UNXPC.notrans"));
            this.m_alProductNames.add("ODBCDB2UNXPC");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCDB2OS390.notrans"));
            this.m_alProductNames.add("ODBCDB2OS390");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCINFORMIX.notrans"));
            this.m_alProductNames.add("ODBCINFORMIX");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCACCESS.notrans"));
            this.m_alProductNames.add("ODBCACCESS");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCEXCEL.notrans"));
            this.m_alProductNames.add("ODBCEXCEL");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCSQLSVRPC.notrans"));
            this.m_alProductNames.add("ODBCSQLSVRPC");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCORACLE.notrans"));
            this.m_alProductNames.add("ODBCORACLE");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCOTHER.notrans"));
            this.m_alProductNames.add("ODBCOTHER");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCSYBASE.notrans"));
            this.m_alProductNames.add("ODBCSYBASE");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.ODBCTERADATA.notrans"));
            this.m_alProductNames.add("ODBCTERADATA");
            this.m_alStringsPassedToLibWizard.add("ODBC");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBDB2UNXPC.notrans"));
            this.m_alProductNames.add("OLEDBDB2UNXPC");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBDB2OS390.notrans"));
            this.m_alProductNames.add("OLEDBDB2OS390");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBINFORMIX.notrans"));
            this.m_alProductNames.add("OLEDBINFORMIX");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBACCESS.notrans"));
            this.m_alProductNames.add("OLEDBACCESS");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBEXCEL.notrans"));
            this.m_alProductNames.add("OLEDBEXCEL");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBSQLSVRPC.notrans"));
            this.m_alProductNames.add("OLEDBSQLSVRPC");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBNETEZZA.notrans"));
            this.m_alProductNames.add("OLEDBNETEZZA");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBORACLE.notrans"));
            this.m_alProductNames.add("OLEDBORACLE");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBOTHER.notrans"));
            this.m_alProductNames.add("OLEDBOTHER");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBSYBASE.notrans"));
            this.m_alProductNames.add("OLEDBSYBASE");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.OLEDBTERADATA.notrans"));
            this.m_alProductNames.add("OLEDBTERADATA");
            this.m_alStringsPassedToLibWizard.add("OLEDB");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.Oracle.notrans"));
            this.m_alProductNames.add("ORACLE");
            this.m_alStringsPassedToLibWizard.add("ORACLE");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.PI.Name.txt"));
            this.m_alProductNames.add("PI SYSTEM");
            this.m_alStringsPassedToLibWizard.add("SASIOPI");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.POSTGRES.notrans"));
            this.m_alProductNames.add("POSTGRES");
            this.m_alStringsPassedToLibWizard.add("POSTGRES");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.Redshift.Name.txt"));
            this.m_alProductNames.add("REDSHIFT");
            this.m_alStringsPassedToLibWizard.add("SASIORST");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SALESFORCE.notrans"));
            this.m_alProductNames.add("SALESFORCE");
            this.m_alStringsPassedToLibWizard.add("SASIOSLF");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.SAP.notrans"));
            this.m_alProductNames.add("SAPR3");
            this.m_alStringsPassedToLibWizard.add("SAPR3");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SAPHANA.notrans"));
            this.m_alProductNames.add("SASIOHNA");
            this.m_alStringsPassedToLibWizard.add("SASIOHNA");
            this.m_DBMSComboBox.addItem((Object)"SAS");
            this.m_alProductNames.add("SAS");
            this.m_alStringsPassedToLibWizard.add("BASE");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.LasrHdat.Name.txt"));
            this.m_alProductNames.add(SAS_DATA_IN_HDFS);
            this.m_alStringsPassedToLibWizard.add(SAS_DATA_IN_HDFS);
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.FEDERATIONSERVER.notrans"));
            this.m_alProductNames.add("SAS FEDERATION SERVER");
            this.m_alStringsPassedToLibWizard.add("FEDSVR");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.SASInformationMapLibrary.Name.txt"));
            this.m_alProductNames.add(SAS_INFOMAP_LIBRARY_ENGINE);
            this.m_alStringsPassedToLibWizard.add(SAS_INFOMAP_LIBRARY_ENGINE);
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.LasrAnalytic.Name.txt"));
            this.m_alProductNames.add("SASIOLA");
            this.m_alStringsPassedToLibWizard.add("SASIOLA");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.CAS.Name.txt"));
            this.m_alProductNames.add("CAS");
            this.m_alStringsPassedToLibWizard.add("CAS");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.SASTableServerLibrary.Name.txt"));
            this.m_alProductNames.add("SASTS");
            this.m_alStringsPassedToLibWizard.add("SASTS");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("PhysicalStoragePane.SASShare.notrans"));
            this.m_alProductNames.add("REMOTE");
            this.m_alStringsPassedToLibWizard.add("REMOTE");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SNOWFLAKE.notrans"));
            this.m_alProductNames.add("SASIOSNF");
            this.m_alStringsPassedToLibWizard.add("SASIOSNF");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SPARK.notrans"));
            this.m_alProductNames.add("SPARK");
            this.m_alStringsPassedToLibWizard.add("SASIOSK");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("SPDEImporter.Name.SPDE.notrans"));
            this.m_alProductNames.add("SPDE");
            this.m_alStringsPassedToLibWizard.add("SPDE");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SASSPDS.notrans"));
            this.m_alProductNames.add("SASSPDS");
            this.m_alStringsPassedToLibWizard.add("SASSPDS");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SYBASE.notrans"));
            this.m_alProductNames.add("SYBASE");
            this.m_alStringsPassedToLibWizard.add("SYBASE");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.SYBASEIQ.notrans"));
            this.m_alProductNames.add("SYBASEIQ");
            this.m_alStringsPassedToLibWizard.add("SYBASEIQ");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.TERADATA.notrans"));
            this.m_alProductNames.add("TERADATA");
            this.m_alStringsPassedToLibWizard.add("TERADATA");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.VERTICA.notrans"));
            this.m_alProductNames.add("VERTICA");
            this.m_alStringsPassedToLibWizard.add("VERTICA");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("XMLImporter.Name.XMLALL.txt"));
            this.m_alProductNames.add(bundle.getString("XMLImporter.description.XMLALL.notrans"));
            this.m_alStringsPassedToLibWizard.add("XML");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("XMLImporter.Name.XMLCDISC.txt"));
            this.m_alProductNames.add(bundle.getString("XMLImporter.description.XMLCDISC.notrans"));
            this.m_alStringsPassedToLibWizard.add("XML");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("XMLImporter.Name.XMLACCESS.txt"));
            this.m_alProductNames.add(bundle.getString("XMLImporter.description.XMLACCESS.notrans"));
            this.m_alStringsPassedToLibWizard.add("XML");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("XMLImporter.Name.XMLORACLE.txt"));
            this.m_alProductNames.add(bundle.getString("XMLImporter.description.XMLORACLE.notrans"));
            this.m_alStringsPassedToLibWizard.add("XML");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("XMLImporter.Name.XMLV2ALL.txt"));
            this.m_alProductNames.add(bundle.getString("XMLImporter.description.XMLV2ALL.notrans"));
            this.m_alStringsPassedToLibWizard.add("XMLV2");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("XMLImporter.Name.XMLV2XMLMAP.txt"));
            this.m_alProductNames.add(bundle.getString("XMLImporter.description.XMLV2XMLMAP.notrans"));
            this.m_alStringsPassedToLibWizard.add("XMLV2");
            this.m_DBMSComboBox.addItem((Object)bundle.getString("DBMSImporter.Name.YELLOWBRICK.notrans"));
            this.m_alProductNames.add("YELLOWBRICK");
            this.m_alStringsPassedToLibWizard.add("SASIOYLB");
        }
    }

    protected void setSchemaDisplay(boolean SASonlyDBMS) {
        if (SASonlyDBMS) {
            this.m_SchemaLabel.setVisible(false);
        } else {
            this.m_SchemaLabel.setVisible(true);
        }
    }

    protected void setSchemaEnabled(boolean bval) {
        this.m_SchemaLabel.setEnabled(bval);
    }

    protected void queryMetadata() {
        try {
            String sOptions = "<Templates><SASLibrary Id=\"\"><UsingPackages/></SASLibrary><DatabaseSchema Id=\"\"><DeployedComponents/></DatabaseSchema></Templates>";
            String reposID = Workspace.getWorkspace().getDefaultRepository().getFQID();
            this.m_metadata.removeMdObjectListener((MdObjectListener)this);
            boolean goToServerSetting = this.m_myStore.isGoToServerForMetadata();
            if (!goToServerSetting) {
                this.m_myStore.setGoToServerForMetadata(true);
            }
            this.m_metaQueryAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_myStore, reposID, "SASLibrary", 8460, sOptions);
            this.m_metaQuery = this.m_metaQueryAll.size() > 0 ? Workspace.removeCheckouts((List)this.m_metaQueryAll) : this.m_metaQueryAll;
            if (!goToServerSetting) {
                this.m_myStore.setGoToServerForMetadata(false);
            }
            this.m_bDataObtained = true;
            if (this.m_metadata != null) {
                this.m_metadata.addMdObjectListener((MdObjectListener)this);
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void setfGoToServer(boolean state) {
        this.fGoToServer = state;
    }

    public void dbmsListenerGuts() {
        this.m_strCurrentDBMS = (String)this.m_alProductNames.get(this.m_DBMSComboBox.getSelectedIndex());
        if (!this.m_bDataObtained) {
            this.queryMetadata();
        }
        this.subsetLibraries(this.m_strCurrentDBMS);
        this.setLibraryCurrent();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_DBMSComboBox.setEnabled(bEditable);
        this.m_btnNewLibrary.setEnabled(bEditable);
        this.m_LibraryComboBox.setEnabled(bEditable);
        this.m_NameField.setEnabled(bEditable);
        this.m_OptionsButton.setEnabled(bEditable);
        this.m_DBMSNamesPanel.setEnabled(bEditable);
    }

    protected void setLibraryCurrent() {
        if (this.m_currentLibrary != null && this.m_LibraryComboBox.getIndexOf((Object)this.m_currentLibrary) > -1) {
            this.m_LibraryComboBox.setSelectedItem((Object)this.m_currentLibrary);
            this.m_btnEditLibrary.setEnabled(true);
        } else {
            this.m_LibraryComboBox.setSelectedItem((Object)this.m_strNoLib);
            this.m_btnEditLibrary.setEnabled(false);
        }
    }

    protected void getLibraryCurrent(PhysicalTable o_PTable) {
        try {
            this.m_currentLibrary = null;
            this.m_currentSchema = null;
            RelationalSchema assocMetadata = null;
            AssociationList tempLst = o_PTable.getTablePackages(this.fGoToServer);
            if (tempLst.size() > 0) {
                assocMetadata = (RelationalSchema)tempLst.get(0);
            }
            if (assocMetadata != null) {
                if (assocMetadata instanceof SASLibrary) {
                    this.m_currentLibrary = (SASLibrary)assocMetadata;
                } else if (assocMetadata instanceof DatabaseSchema) {
                    this.m_currentSchema = (DatabaseSchema)assocMetadata;
                    this.m_txtSchema.setText(this.m_currentSchema.getSchemaName());
                    AssociationList usedByPackages = this.m_currentSchema.getUsedByPackages(true);
                    if (usedByPackages.size() > 0) {
                        assocMetadata = (RelationalSchema)usedByPackages.get(0);
                        if (assocMetadata instanceof SASLibrary) {
                            this.m_currentLibrary = (SASLibrary)assocMetadata;
                        }
                    } else {
                        this.m_currentLibrary = this.matchSchemaToLibrary(this.m_currentSchema);
                    }
                }
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public void MdObjectModified(MdEvent e) {
        try {
            this.refresh();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    public String getDBMS() {
        return (String)this.m_DBMSComboBox.getSelectedItem();
    }

    public String getDBMSType() {
        return (String)this.m_alProductNames.get(this.m_DBMSComboBox.getSelectedIndex());
    }

    public CMetadata getLibrary() {
        return this.m_selectedLibrary;
    }

    public String getNameField() {
        return this.m_NameField.getText().trim();
    }

    private String getEngineSubtype(SASLibrary o_library) {
        String sProdName = "";
        try {
            if (o_library.getEngine().equalsIgnoreCase(SAS_INFOMAP_LIBRARY_ENGINE)) {
                sProdName = SAS_INFOMAP_LIBRARY_ENGINE;
            } else if (SAS_DATA_IN_HDFS.equalsIgnoreCase(o_library.getEngine())) {
                sProdName = SAS_DATA_IN_HDFS;
            } else {
                RelationalSchema assocMeta;
                AssociationList components;
                AssociationList usingPackages = o_library.getUsingPackages(false);
                if (usingPackages.size() == 0) {
                    usingPackages = o_library.getUsingPackages(true);
                }
                if (usingPackages.size() > 0 && (components = (assocMeta = (RelationalSchema)usingPackages.get(0)).getDeployedComponents()).size() > 0) {
                    DeployedComponent comp = (DeployedComponent)components.get(0);
                    sProdName = comp.getProductName();
                }
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return sProdName;
    }

    class cOptionsButtonListener
    implements ActionListener {
        cOptionsButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            BaseModel model = new BaseModel(null);
            model.setEditable(true);
            OAdapter omr = null;
            model.setUndoManager((UndoManager)((Object)new ModelUndoManager()));
            try {
                omr = new OAdapter((IModel)model, PhysicalStoragePane.this.m_myStore);
                Object library = PhysicalStoragePane.this.m_LibraryComboBox.getSelectedItem();
                ILibrary iLib = null;
                if (library != null && library instanceof SASLibrary) {
                    iLib = (ILibrary)omr.acquireObjectUsingTemplate((Root)((SASLibrary)library));
                }
                IPhysicalTable table = (IPhysicalTable)omr.acquireObject((Root)PhysicalStoragePane.this.m_ptCurrentTable);
                table.setLibrary(iLib);
                if (table != null) {
                    PhysicalTablePromptModelCollection collection = table.getTableOptionCollection();
                    collection.loadFromOMR((OMRAdapter)omr);
                    IPromptModel[] aModels = collection.getModels();
                    if (aModels != null && aModels.length > 0) {
                        Object panel = null;
                        if (aModels.length > 1) {
                            panel = new WATabbedPanel();
                            for (int i = 0; i < aModels.length; ++i) {
                                panel.addTab(collection.getTitles()[i], (WAPropertyTab)new OptionsTab(aModels[i], "shared", collection.getHelpTopics()[i], false));
                            }
                        } else {
                            panel = new OptionsTab(aModels[0], "shared", collection.getHelpTopics()[0], false);
                        }
                        panel.setHelpProduct("shared");
                        int answer = ModelUIUtilities.showDialog((IObject)table, bundle.getString("PhysicalStoragePane.TableOptions.title.txt"), (WAPanel)panel);
                        if (answer == 1) {
                            if (collection.isChanged()) {
                                PhysicalStoragePane.this.setDataChanged(true);
                            }
                            collection.saveToOMR((OMRAdapter)omr);
                        }
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                model.dispose();
                if (omr != null) {
                    omr.dispose();
                }
            }
        }
    }

    private class OAdapter
    extends OMRAdapter {
        public OAdapter(IModel model, MdObjectStore store) throws RemoteException {
            super(model, Workspace.getMdFactory(), "PhysicalStoragePanel:Model");
            this.setOMRStore(store);
        }

        public void dispose() {
        }
    }

    class cEditLibButtonListener
    implements ActionListener {
        cEditLibButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (!PrototypeUtil.isPrototypeCompatible((Root)PhysicalStoragePane.this.m_selectedLibrary, (Component)PhysicalStoragePane.this.getTopLevelAncestor())) {
                    VersionUtil.displayPropertiesMessage((Window)((Window)PhysicalStoragePane.this.getTopLevelAncestor()), (String)bundle.getString("apptitle"));
                    return;
                }
                MdObjectStore childStore = Workspace.getMdFactory().createObjectStore(null, "PhysicalStoragePane: eEditButtonListener");
                try {
                    SASLibrary tempLibrary = PhysicalStoragePane.this.m_selectedLibrary;
                    SASLibrary oLibrary = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject(childStore, null, tempLibrary.getName(), tempLibrary.getCMetadataType(), tempLibrary.getId(), null);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)oLibrary, null, null, "", 8);
                    AppPropertiesDialogFactory.getInstance().showPropertiesDialog((Window)Workspace.getWorkspace(), ObjectConverter.getInstance().convertToSimpleObject((PrimaryType)oLibrary));
                    int index = PhysicalStoragePane.this.m_LibraryComboBox.getSelectedIndex();
                    PhysicalStoragePane.this.m_LibraryComboBox.setSelectedIndex(index);
                }
                finally {
                    childStore.dispose();
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    class cNewLibButtonListener
    implements ActionListener {
        cNewLibButtonListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryWizard m_wizard = null;
            try {
                MdObjectStore childStore = Workspace.getMdFactory().createObjectStore();
                try {
                    Library library;
                    AssociationList lTrees;
                    Workspace work = Workspace.getWorkspace();
                    String libEngine = (String)PhysicalStoragePane.this.m_alStringsPassedToLibWizard.get(PhysicalStoragePane.this.m_DBMSComboBox.getSelectedIndex());
                    String[] aLibEngine = new String[]{libEngine};
                    Tree tree = null;
                    if (PhysicalStoragePane.this.m_ptCurrentTable != null && (lTrees = PhysicalStoragePane.this.m_ptCurrentTable.getTrees()).size() > 0) {
                        tree = (Tree)lTrees.get(0);
                    }
                    if (tree == null) {
                        tree = WsMetadataUtil.getDefaultFolder((MdObjectStore)childStore);
                    }
                    String sRepositoryID = "";
                    sRepositoryID = work.isChangeManagementOn() || tree == null ? work.getDefaultRepository().getFQID() : "A0000001." + tree.getRepositoryID();
                    m_wizard = new LibraryWizard((JFrame)work, sRepositoryID, bundle.getString("NewLibraryWizard.Title.txt"), aLibEngine, childStore, null, tree);
                    m_wizard.show();
                    if (m_wizard.getReturnValue() == 1 && (library = (Library)m_wizard.getWizardData("Library")) != null && !library.getDeployedDataPackage().isNewObject()) {
                        SASLibrary sasLibraryObject = null;
                        DeployedDataPackage dataPackage = library.getDeployedDataPackage();
                        if (dataPackage instanceof SASLibrary) {
                            sasLibraryObject = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)PhysicalStoragePane.this.m_metadata.getObjectStore(), (CMetadata)((SASLibrary)dataPackage));
                            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasLibraryObject, null, null, "", 8);
                        } else {
                            AssociationList lstPackages = dataPackage.getUsedByPackages();
                            if (!lstPackages.isEmpty()) {
                                sasLibraryObject = (SASLibrary)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)PhysicalStoragePane.this.m_metadata.getObjectStore(), (CMetadata)((SASLibrary)lstPackages.get(0)));
                                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)sasLibraryObject, null, null, "", 8);
                            }
                        }
                        if (sasLibraryObject != null) {
                            PhysicalStoragePane.this.m_metaQuery.add(sasLibraryObject);
                            PhysicalStoragePane.this.subsetLibraries(PhysicalStoragePane.this.m_strCurrentDBMS);
                            PhysicalStoragePane.this.m_LibraryComboBox.setSelectedItem((Object)sasLibraryObject);
                            PhysicalStoragePane.this.setDataChanged(true);
                        }
                    }
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
                }
                catch (ServiceException se) {
                    MessageUtil.displayServiceExceptionMessage((ServiceException)se);
                }
                finally {
                    childStore.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    class WAGUndoableEditListener
    implements UndoableEditListener {
        WAGUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            PhysicalStoragePane.this.getWAUndoManager().addEdit(e.getEdit());
        }
    }

    class ComboItemListener
    implements ItemListener {
        ComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                if (ie.getSource() == PhysicalStoragePane.this.m_DBMSComboBox) {
                    PhysicalStoragePane.this.dbmsListenerGuts();
                } else if (ie.getSource() == PhysicalStoragePane.this.m_LibraryComboBox) {
                    PhysicalStoragePane.this.setDataChanged(true);
                    PhysicalStoragePane.this.m_selectedLibrary = PhysicalStoragePane.this.m_LibraryComboBox.getSelectedItem() instanceof SASLibrary ? (SASLibrary)PhysicalStoragePane.this.m_LibraryComboBox.getSelectedItem() : null;
                    PhysicalStoragePane.this.m_currentSchema = null;
                    PhysicalStoragePane.this.getCurrentLibrarySchemas();
                    if (PhysicalStoragePane.this.m_selectedLibrary != null) {
                        PhysicalStoragePane.this.m_btnEditLibrary.setEnabled(true);
                    } else {
                        PhysicalStoragePane.this.m_btnEditLibrary.setEnabled(false);
                    }
                }
            }
            if ("PI System".equals(PhysicalStoragePane.this.m_strCurrentDBMS)) {
                PhysicalStoragePane.this.m_DBMSNamesPanel.setCase(true);
            }
        }
    }
}

