/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.wadmin.plugins.TransformInterface;
import com.sas.wadmin.visuals.MacroPluginUtilities;
import com.sas.wadmin.visuals.ParameterTreeNode;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParametersSelectorTreeModel
extends DefaultTreeModel {
    private Comparator m_cmp;
    private Job m_mdJob;

    public ParametersSelectorTreeModel(Job startingJob) {
        super(new DefaultMutableTreeNode());
        this.m_mdJob = startingJob;
        this.setAsksAllowsChildren(true);
        this.setComparator(new cComparator());
        cJobTreeNode node = new cJobTreeNode(this.m_mdJob);
        this.setRoot((TreeNode)((Object)node));
    }

    public void setComparator(Comparator cmp) {
        this.m_cmp = cmp;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    public void expandRootNode() {
        cJobTreeNode node = (cJobTreeNode)((Object)this.getRoot());
        node.addChildren();
    }

    public WsTreeNode createTreeNode(Object mdObject, CMetadata parent) throws MdException, RemoteException {
        TransformationStep step;
        Object node = mdObject instanceof TransformationStep ? (!(step = (TransformationStep)mdObject).getTransformations().isEmpty() && step.getTransformations().get(0) instanceof Job ? new cJobTreeNode((Job)step.getTransformations().get(0)) : new cTransformationStepTreeNode((TransformationStep)mdObject)) : (mdObject instanceof DataTable ? new cDataTableTreeNode((DataTable)mdObject) : (mdObject instanceof PromptDefinitionInterface ? new ParameterTreeNode((PromptDefinitionInterface)mdObject, parent, true) : (mdObject instanceof Job ? new cJobTreeNode((Job)mdObject) : new WsTreeNode(mdObject.toString()))));
        return node;
    }

    public DefaultMutableTreeNode getInitialNodeToScrollTo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getRoot();
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        if (node.getChildCount() > 0) {
            node = (DefaultMutableTreeNode)node.getChildAt(0);
        }
        return node;
    }

    public void addListenersToTree(JTree tree) {
        tree.addTreeExpansionListener(new cExpansionListener());
        tree.addTreeSelectionListener(new cSelectionListener());
    }

    protected void appendChild(MutableTreeNode nodeChild, MutableTreeNode nodeParent) {
        this.insertNodeInto(nodeChild, nodeParent, nodeParent.getChildCount());
    }

    private class cComparator
    implements Comparator {
        private cComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }

    protected class cSelectionListener
    implements TreeSelectionListener {
        protected cSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] aPaths = e.getPaths();
            if (aPaths != null) {
                for (int iPath = 0; iPath < aPaths.length; ++iPath) {
                    WsTreeNode node;
                    Object obj = aPaths[iPath].getLastPathComponent();
                    if (obj instanceof ParameterTreeNode || obj.equals(ParametersSelectorTreeModel.this.getRoot()) || (node = (WsTreeNode)obj).hasExpanded()) continue;
                    node.addChildren();
                    node.setHasExpanded(true);
                    if (node.getChildCount() != 0) continue;
                    node.setAllowsChildren(false);
                }
            }
        }
    }

    protected class cExpansionListener
    implements TreeExpansionListener {
        protected cExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            WsTreeNode node = (WsTreeNode)e.getPath().getLastPathComponent();
            if (!node.hasExpanded()) {
                node.addChildren();
                node.setHasExpanded(true);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
        }
    }

    protected class cTransformationStepTreeNode
    extends WsDataTreeNode {
        private TransformationStep m_oStep;

        public cTransformationStepTreeNode(TransformationStep oStep) {
            super((CMetadata)oStep);
            this.m_oStep = oStep;
            try {
                TransformInterface tInterface = MacroPluginUtilities.getTransformInterfaceFromStep(oStep);
                this.setIcon(tInterface.getIcon());
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setAllowsChildren(true);
        }

        public void addChildren() {
            ParametersModel parmModel = new ParametersModel((Root)this.m_oStep);
            try {
                List attrList = parmModel.getParameterDefinitions();
                for (int i = 0; i < attrList.size(); ++i) {
                    ParametersSelectorTreeModel.this.appendChild((MutableTreeNode)ParametersSelectorTreeModel.this.createTreeNode(attrList.get(i), (CMetadata)this.m_oStep), (MutableTreeNode)((Object)this));
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }

        public void removeChildren() {
            while (this.getChildCount() > 0) {
                ParametersSelectorTreeModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
            this.setHasExpanded(false);
        }
    }

    protected class cDataTableTreeNode
    extends WsDataTreeNode {
        private DataTable m_oTable;

        public cDataTableTreeNode(DataTable oTable) {
            super((CMetadata)oTable);
            this.m_oTable = oTable;
            this.setAllowsChildren(true);
        }

        public void addChildren() {
            ParametersModel parmModel = new ParametersModel((Root)this.m_oTable);
            try {
                List attrList = parmModel.getParameterDefinitions();
                for (int i = 0; i < attrList.size(); ++i) {
                    ParametersSelectorTreeModel.this.appendChild((MutableTreeNode)ParametersSelectorTreeModel.this.createTreeNode(attrList.get(i), (CMetadata)this.m_oTable), (MutableTreeNode)((Object)this));
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }

        public void removeChildren() {
            while (this.getChildCount() > 0) {
                ParametersSelectorTreeModel.this.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
            this.setHasExpanded(false);
        }
    }

    protected class cJobTreeNode
    extends WsDataTreeNode {
        private Job m_oJob;

        public cJobTreeNode(Job mdJob) {
            super((CMetadata)mdJob);
            this.m_oJob = mdJob;
        }

        public void addChildren() {
            try {
                ArrayList<Object> parmObjects = new ArrayList<Object>();
                if (!ParametersSelectorTreeModel.this.getRoot().equals((Object)this)) {
                    ParametersModel parmModel = new ParametersModel((Root)this.m_oJob);
                    parmObjects.addAll(parmModel.getParameterDefinitions());
                }
                if (!this.m_oJob.getJobActivities().isEmpty()) {
                    AssociationList steps = ((TransformationActivity)this.m_oJob.getJobActivities().get(0)).getSteps();
                    for (int i = 0; i < steps.size(); ++i) {
                        TransformationStep step = (TransformationStep)steps.get(i);
                        ParametersModel paramModel = new ParametersModel((Root)step);
                        if (paramModel.isParameterizedObject() && !parmObjects.contains(step)) {
                            parmObjects.add(step);
                        }
                        for (int j = 0; j < step.getTransformations().size(); ++j) {
                            if (step.getTransformations().get(j) instanceof ClassifierMap) {
                                ClassifierMap cMap = (ClassifierMap)step.getTransformations().get(j);
                                ArrayList tables = new ArrayList();
                                tables.addAll(cMap.getClassifierSources());
                                tables.addAll(cMap.getClassifierTargets());
                                for (int k = 0; k < tables.size(); ++k) {
                                    paramModel.setMetadata((Root)tables.get(k));
                                    if (!paramModel.isParameterizedObject() || parmObjects.contains(tables.get(k))) continue;
                                    parmObjects.add(tables.get(k));
                                }
                                continue;
                            }
                            if (!(step.getTransformations().get(j) instanceof Job)) continue;
                            paramModel.setMetadata((Root)step.getTransformations().get(j));
                            if (parmObjects.contains(step)) continue;
                            parmObjects.add(step.getTransformations().get(j));
                        }
                    }
                }
                for (int i = 0; i < parmObjects.size(); ++i) {
                    ParametersSelectorTreeModel.this.appendChild((MutableTreeNode)ParametersSelectorTreeModel.this.createTreeNode(parmObjects.get(i), (CMetadata)this.m_oJob), (MutableTreeNode)((Object)this));
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            this.setHasExpanded(true);
        }
    }
}

